/*
 * Copyright 2021 Embedded Artists AB
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */


#ifndef _PIN_MUX_H_
#define _PIN_MUX_H_

#include "board.h"

/***********************************************************************************************************************
 * Definitions
 **********************************************************************************************************************/


/*!
 * @addtogroup pin_mux
 * @{
 */

/***********************************************************************************************************************
 * API
 **********************************************************************************************************************/

#if defined(__cplusplus)
extern "C" {
#endif

/*!
 * @brief Calls initialization functions.
 *
 */
void BOARD_InitBootPins(void);

/* Aliases to deal with all the different example setups without having to
   patch every example in the SDK.*/
void BOARD_InitPins(void);
void BOARD_InitEnetPins(void);
void BOARD_InitCSIPins(void);
void BOARD_InitI2C1Pins(void);
void BOARD_I2C_ConfigurePins(void);
void BOARD_InitParallelRGBPins(void);
void BOARD_InitDEBUG_UARTPins(void);
void BOARD_InitLCDPins(void);

/* Functions needed to setup interfaces that conflicts with the default
   setupt, i.e. pins have different functions. ENET2 conflicts with display
   pins, Semc (i.e. SDRAM) can only be called under certain circumstances
   and the Wi-Fi pins conflict with the uSD card pins. */
void BOARD_InitEnet2Pins(void);
void BOARD_InitSemcPins(void);
void BOARD_InitUSDWiFiPins(void);
void BOARD_InitOnboardWiFiPins(void);
void BOARD_InitSDRAMPins(void);

#if defined(__cplusplus)
}
#endif


/* Some of the network examples have these pins defined in the pin_mux.h file
   so they have to be repeated here. */

#if BOARD_NETWORK_USE_ONBOARD_100M_ENET_PORT
    #define BOARD_INITENETPINS_PHY_INTR_PERIPHERAL                             GPIO1   /*!< Peripheral name */
    #define BOARD_INITENETPINS_PHY_INTR_SIGNAL                               gpio_io   /*!< Signal name */
    #define BOARD_INITENETPINS_PHY_INTR_CHANNEL                                   0U   /*!< Signal channel */
    
    #define BOARD_INITENETPINS_PHY_INTR_GPIO                                   GPIO1   /*!< GPIO peripheral base pointer */
    #define BOARD_INITENETPINS_PHY_INTR_GPIO_PIN                                  0U   /*!< GPIO pin number */
    #define BOARD_INITENETPINS_PHY_INTR_GPIO_PIN_MASK                    (1U <<  0U)   /*!< GPIO pin mask */
    #define BOARD_INITENETPINS_PHY_INTR_PORT                                   GPIO1   /*!< PORT peripheral base pointer */
    #define BOARD_INITENETPINS_PHY_INTR_PIN                                       0U   /*!< PORT pin number */
    #define BOARD_INITENETPINS_PHY_INTR_PIN_MASK                         (1U <<  0U)   /*!< PORT pin mask */
#else
    #define BOARD_INITENETPINS_PHY_INTR_PERIPHERAL                             GPIO3   /*!< Peripheral name */
    #define BOARD_INITENETPINS_PHY_INTR_SIGNAL                               gpio_io   /*!< Signal name */
    #define BOARD_INITENETPINS_PHY_INTR_CHANNEL                                   0U   /*!< Signal channel */
    
    #define BOARD_INITENETPINS_PHY_INTR_GPIO                                   GPIO3   /*!< GPIO peripheral base pointer */
    #define BOARD_INITENETPINS_PHY_INTR_GPIO_PIN                                  0U   /*!< GPIO pin number */
    #define BOARD_INITENETPINS_PHY_INTR_GPIO_PIN_MASK                    (1U <<  0U)   /*!< GPIO pin mask */
    #define BOARD_INITENETPINS_PHY_INTR_PORT                                   GPIO3   /*!< PORT peripheral base pointer */
    #define BOARD_INITENETPINS_PHY_INTR_PIN                                       0U   /*!< PORT pin number */
    #define BOARD_INITENETPINS_PHY_INTR_PIN_MASK                         (1U <<  0U)   /*!< PORT pin mask */
#endif


/*!
 * @}
 */
#endif /* _PIN_MUX_H_ */

/***********************************************************************************************************************
 * EOF
 **********************************************************************************************************************/
