/*
 * Copyright 2018-2022 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

/***********************************************************************************************************************
 * This file was generated by the MCUXpresso Config Tools. Any manual edits made to this file
 * will be overwritten if the respective MCUXpresso Config Tools is used to update this file.
 **********************************************************************************************************************/

/* clang-format off */
/* TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
!!GlobalInfo
product: Peripherals v9.0
processor: MIMXRT1064xxxxA
package_id: MIMXRT1064DVL6A
mcu_data: ksdk2_0
processor_version: 9.0.1
board: MIMXRT1064-EVK
functionalGroups:
- name: BOARD_InitPeripherals
  UUID: 1c6563a6-c68b-40e5-8828-2853c99f95fa
  called_from_default_init: true
  selectedCore: core0
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS **********/

/* TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
component:
- type: 'system'
- type_id: 'system'
- global_system_definitions:
  - user_definitions: '#define LITTLEFS_START_ADDR 0x400000\n'
  - user_includes: '#include "lfs_mflash.h"\n'
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS **********/
/* clang-format on */

/***********************************************************************************************************************
 * Included files
 **********************************************************************************************************************/
#include "peripherals.h"

/***********************************************************************************************************************
 * BOARD_InitPeripherals functional group
 **********************************************************************************************************************/
/***********************************************************************************************************************
 * LittleFS initialization code
 **********************************************************************************************************************/
/* clang-format off */
/* TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
instance:
- name: 'LittleFS'
- type: 'littlefs'
- mode: 'general'
- custom_name_enabled: 'false'
- type_id: 'littlefs_2fd9081a6d702e2c6a27590ee19148f3'
- functional_group: 'BOARD_InitPeripherals'
- config_sets:
  - general_config:
    - lfsConfig:
      - enableUserContext: 'true'
      - userContext:
        - contextVar: '(void*)&LittleFS_ctx'
        - contextDef: 'struct lfs_mflash_ctx LittleFS_ctx'
        - disableContextDeclaration: 'true'
      - userCallbacks:
        - read: 'lfs_mflash_read'
        - prog: 'lfs_mflash_prog'
        - erase: 'lfs_mflash_erase'
        - sync: 'lfs_mflash_sync'
      - readSize: '16'
      - progSize: '256'
      - blockSize: '4096'
      - blockCount: '1024'
      - blockCycles: '100'
      - cacheSize: '256'
      - lookaheadSize: '16'
      - enableReadBuff: 'false'
      - readBuffer:
        - customBuffer: 'false'
      - enableProgBuff: 'false'
      - progBuffer:
        - customBuffer: 'false'
      - enableLookaheadBuff: 'false'
      - lookaheadBuffer:
        - customBuffer: 'false'
      - enableOptionalSizes: 'false'
      - optionalSizes:
        - name_max: '255'
        - file_max: '0x7FFFFFFF'
        - attr_max: '1022'
    - initLFS: 'false'
    - initConfig:
      - lfsObj: 'LittleFS_system'
      - mountLFS: 'disable'
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS **********/
/* clang-format on */
const struct lfs_config LittleFS_config = {
  .context = (void*)&LittleFS_ctx,
  .read = lfs_mflash_read,
  .prog = lfs_mflash_prog,
  .erase = lfs_mflash_erase,
  .sync = lfs_mflash_sync,
  .read_size = LITTLEFS_READ_SIZE,
  .prog_size = LITTLEFS_PROG_SIZE,
  .block_size = LITTLEFS_BLOCK_SIZE,
  .block_count = 1024,
  .block_cycles = 100,
  .cache_size = LITTLEFS_CACHE_SIZE,
  .lookahead_size = LITTLEFS_LOOKAHEAD_SIZE
};

/* Empty initialization function (commented out)
static void LittleFS_init(void) {
} */

/***********************************************************************************************************************
 * Initialization functions
 **********************************************************************************************************************/
void BOARD_InitPeripherals(void)
{
  /* Initialize components */
}

/***********************************************************************************************************************
 * BOARD_InitBootPeripherals function
 **********************************************************************************************************************/
void BOARD_InitBootPeripherals(void)
{
  BOARD_InitPeripherals();
}
