
This SDK has been patched by Embedded Artists for the iMXRT1064 Developer's Kit.
The SDK was released on 2024-03-25 and is based on NXP's 2.15.000 SDK (SDK_2_15_000_MIMXRT1064xxxxB.zip).

This is what has been patched:
* Set CPU speed according to Commercial/Industrial CPU
* Correction of the VDD_SOC_IN voltage.
* LWIP projects - added reading of the MAC address from the onboard I2C EEPROM
* Added an I2C driver for the gpio expander (PCA6416) and code to use it
* Added an I2C driver for the PWM gpio expander (PCA9530) and code to use it
* SEMC projects - changed algorithm for memory test and now test entire 32MB instead of only 4KB
* Examples using a display have been updated to use PCA6416/PCA9530 for
  RST/PWR/BL signals
* BOARD_USER_BUTTON has been redirected to SW5/WAKEUP button on the uCOM Carrier Board
* USER_LED has been changed to the blue RGB LED using PCA6416
* Adjusted the USB interface number (it is different for host and device examples)
* Changed the Wi-Fi examples to use the Embedded Artists 1XK M.2 Module (EAR00385) as default
* Many of the projects have been updated to use a more complete pin_mux.c file where all
  necessary pins have been initialized. The SDK examples used to only configure the pins
  that they use (and often not every pin) and most of the time the configuration was only
  for MUX:ing and not the PAD settings (pull up/down/none, drive strength and slew).
* Changed reset pin for SD card examples

This has been added:
* LWIP projects - option to use 100/10Mbps Ethernet-PHY Adapter
* AWS projects - option to use 100/10Mbps Ethernet-PHY Adapter
* AzureRTOS projects - option to use 100/10Mbps Ethernet-PHY Adapter
* I2C probe example

Important things to note:
* Read section "8 - Known Issues" in docs/MCUXpresso SDK Release Notes for EVK-MIMXRT1064.pdf
  to see known issues with the current version of the SDK.
* For Iperf examples, set compiler optimization to -O3 or similar to improve performance.
* If the hardware seems unresponsive and the debugger cannot connect/flash/erase the current program
  then the most likely cause is the running program preventing the access. To stop the currently
  running program and regain control:
  1) Press and hold down the ISP_ENABLE button (SW1)
  2) Press and hold down the RESET button (SW3)
  3) Let go of the RESET button
  4) Wait an extra second or two
  5) Release the ISP_ENABLE button
  6) The hardware is now in a mode where programming/erasing it should work


Connectors:
* J29 (micro USB) is the default UART and unless specified otherwise it is setup for 115200 8/N/1


This example has been extended to support two different network options:

Option1: (default) uses the 100/10Mbit Ethernet PHY on the iMX RT1064 uCOM board
         and the connector on the uCOM Carrier Board
Option2: uses the 100/10Mbit Ethernet-PHY Adapter board

For examples that support both options, select which option to use by changing
this define in board.h:

#define BOARD_NETWORK_USE_ONBOARD_100M_ENET_PORT (1U)

Some of the network examples have been modified to obtain the globally unique
MAC address from an EEPROM either on the 100/10Mbit Ethernet-PHY Adapter board
or on the iMX RT1064 uCOM board depending on which interface is used.


Everything below this line is the original content of the readme file.
=======================================================================



Overview
========

The lwip_httpsrv_mbedTSL_bm demo application demonstrates an HTTPS Server
set up on lwIP TCP/IP and the mbedTLS stack with bare metal. The user
uses an internet browser to send an HTTPS request for connection.
The board acts as an HTTPS server and sends a web page back to the PC.

The example supports both IPv4 and IPv6 protocols. But some combinations of boards or build configurations may have
only IPv4 enabled due to memory constraints. If it fits into memory, it is possible for the example to be compiled
with both IPv4 and IPv6 (LWIP_IPV4=1 and LWIP_IPV6=1 in lwipopts.h), IPv4 only (LWIP_IPV4=1 and LWIP_IPV6=0
in lwipopts.h) or IPv6 only (LWIP_IPV4=0 and LWIP_IPV6=1 in lwipopts.h).
If IPv6 is enabled, the board will assign a link-local IPv6 address to its interface, but this is often not enough
as web browsers tend to not support link-local address with zone index in URL (e.g. https://[FE80::5627:8DFF:FE46:29F8%eth0]).
So if the board is connected directly to the host PC, the PC should be configured to send ICMPv6 Router Advertisement
messages with Prefix option, which the board could use to assign itself a routable address using the Stateless Address
Autoconfiguration mechanism. If the board and the host PC are connected through a router, sending of Router Advertisement
messages could be configured on that router (if it supports IPv6).
Instructions how to set the IPv6 network correctly can be different on each system and it is out of scope of this readme.
It can take a couple of seconds until the addresses are validated and assigned to the board's ethernet interface,
so the board will print "IPv6 address update" messages followed by all valid IPv6 addresses anytime there is a change.
The assigned unique local or global unique addresses could be typed into the web browser's address bar in a form like
"https://[FD00:AABB:CCDD:EEFF:5627:8DFF:FE46:29F8]" to access the web server over IPv6.


SDK version
===========
- Version: 2.15.000

Toolchain supported
===================
- IAR embedded Workbench  9.40.1
- Keil MDK  5.38.1
- GCC ARM Embedded  12.2
- MCUXpresso  11.8.0

Hardware requirements
=====================
- Mini/micro USB cable
- EVK-MIMXRT1064 board
- Personal Computer

Board settings
==============
No special settings are required.

Prepare the Demo
================
1.  Connect a mini USB cable between the PC host and the OpenSDA(or USB to Serial) USB port on the board.
2.  Open a serial terminal on PC for OpenSDA serial(or USB to Serial) device with these settings:
    - 115200 baud rate
    - 8 data bits
    - No parity
    - One stop bit
    - No flow control
3.  Insert Cable to Ethernet RJ45 port and connect it to your PC.
4.  Configure ip address of PC to 192.168.0.100 .
5.  Configure the host PC to advertise IPv6 address prefix.
6.  Open a web browser.
7.  Download the program to the target board.
8.  Either press the reset button on your board or launch the debugger in your IDE to begin running the demo.

Running the demo
================
1.  When the demo runs successfully, the terminal will display the following:
		Initializing PHY...

        ***********************************************************
         mbedTLS HTTPS Server example
        ***********************************************************
         IPv4 Address     : 192.168.0.102
         IPv4 Subnet mask : 255.255.255.0
         IPv4 Gateway     : 192.168.0.100
         IPv6 Address0    : -
         IPv6 Address1    : -
         IPv6 Address2    : -
        ***********************************************************
        IPv6 address update, valid addresses:
         IPv6 Address0    : FE80::5627:8DFF:FE46:29F8
         IPv6 Address1    : -
         IPv6 Address2    : -

        IPv6 address update, valid addresses:
         IPv6 Address0    : FE80::5627:8DFF:FE46:29F8
         IPv6 Address1    : FD00:AABB:CCDD:EEFF:5627:8DFF:FE46:29F8
         IPv6 Address2    : -

2.  If the example has been compiled with IPv4 enabled (LWIP_IPV4=1), type https://192.168.0.102 (IP address of the board) into the browser.
    The browser should respond as shown below:

		lwIP - A Lightweight TCP/IP stack

		The web page you are watching was served by a simple web server running on top of the lightweight TCP/IP stack lwIP.

		lwIP is an open source implementation of the TCP/IP protocol suite that was originally written by Adam Dunkels of
		the Swedish Institute of Computer Science but now is being actively developed by a team of developers distributed
		world-wide.Since it's release, lwIP has spurred a lot of interest and has been ported to several platforms and
		operating systems. lwIP can be used either with or without an underlying OS.

		The focus of the lwIP TCP/IP implementation is to reduce the RAM usage while still having a full scale TCP. This
		makes lwIP suitable for use in embedded systems with tens of kilobytes of free RAM and room for around 40 kilobytes
		of code ROM.

		More information about lwIP can be found at the lwIP homepage at http://savannah.nongnu.org/projects/lwip/ or at
		the lwIP wiki at http://lwip.wikia.com/.

3.  If the example has been compiled with IPv6 enabled (LWIP_IPV6=1), wait for the unique local or global unique IPv6 address to appear
    in the list of valid addresses in the console output. Then the server could be reached over IPv6.
    For the example console output above, https://[FD00:AABB:CCDD:EEFF:5627:8DFF:FE46:29F8] could be typed into the browser's address bar to make it
    show the web page and communicate with the board over IPv6.
