
This SDK has been patched by Embedded Artists for the iMXRT1064 Developer's Kit.
The SDK was released on 2024-03-25 and is based on NXP's 2.15.000 SDK (SDK_2_15_000_MIMXRT1064xxxxB.zip).

This is what has been patched:
* Set CPU speed according to Commercial/Industrial CPU
* Correction of the VDD_SOC_IN voltage.
* LWIP projects - added reading of the MAC address from the onboard I2C EEPROM
* Added an I2C driver for the gpio expander (PCA6416) and code to use it
* Added an I2C driver for the PWM gpio expander (PCA9530) and code to use it
* SEMC projects - changed algorithm for memory test and now test entire 32MB instead of only 4KB
* Examples using a display have been updated to use PCA6416/PCA9530 for
  RST/PWR/BL signals
* BOARD_USER_BUTTON has been redirected to SW5/WAKEUP button on the uCOM Carrier Board
* USER_LED has been changed to the blue RGB LED using PCA6416
* Adjusted the USB interface number (it is different for host and device examples)
* Changed the Wi-Fi examples to use the Embedded Artists 1XK M.2 Module (EAR00385) as default
* Many of the projects have been updated to use a more complete pin_mux.c file where all
  necessary pins have been initialized. The SDK examples used to only configure the pins
  that they use (and often not every pin) and most of the time the configuration was only
  for MUX:ing and not the PAD settings (pull up/down/none, drive strength and slew).
* Changed reset pin for SD card examples

This has been added:
* LWIP projects - option to use 100/10Mbps Ethernet-PHY Adapter
* AWS projects - option to use 100/10Mbps Ethernet-PHY Adapter
* AzureRTOS projects - option to use 100/10Mbps Ethernet-PHY Adapter
* I2C probe example

Important things to note:
* Read section "8 - Known Issues" in docs/MCUXpresso SDK Release Notes for EVK-MIMXRT1064.pdf
  to see known issues with the current version of the SDK.
* For Iperf examples, set compiler optimization to -O3 or similar to improve performance.
* If the hardware seems unresponsive and the debugger cannot connect/flash/erase the current program
  then the most likely cause is the running program preventing the access. To stop the currently
  running program and regain control:
  1) Press and hold down the ISP_ENABLE button (SW1)
  2) Press and hold down the RESET button (SW3)
  3) Let go of the RESET button
  4) Wait an extra second or two
  5) Release the ISP_ENABLE button
  6) The hardware is now in a mode where programming/erasing it should work


Connectors:
* J29 (micro USB) is the default UART and unless specified otherwise it is setup for 115200 8/N/1


This example has been configured to use the 1XK M.2 module. To change which
module to use, replace WIFI_IW416_BOARD_MURATA_1XK_USD in the app_config.h file
with one of the following and then rebuild the project:

    WIFI_IW416_BOARD_MURATA_1XK_ONBOARD - To use the 1XK chip on the uCOM board (special mounting option)
    WIFI_IW416_BOARD_MURATA_1XK_USD     - To use the 1XK M.2 module
    WIFI_88W8801_BOARD_MURATA_2DS_USD   - To use the 2DS M.2 module
    WIFI_88W8987_BOARD_MURATA_1ZM_USD   - To use the 1ZM M.2 module

This example requires an M.2 Module and a uSD-M2 Adapter (LBEE0ZZ1WE-TEMP)
from Murata inserted in uSD connector J34. The M.2 socket (J33) on the uCOM Carrier Board
is not used.

The uSD-M2 Adapter must be configured with:
J1  shorted in 1-2 position
J12 shorted in 2-3 position
J13 shorted in 1-2 position
J9 pin 3 must be connected to J32 pin 2 (INT) on the uCOM Carrier Board with a cable.

Due to high current consumption peaks of the M.2 module, especially during startup calibration,
you must power the uSD-M2 Adapter from an external source. The power supply from the uSD
interface is not enough. Connect a USB cable to the micro-B USB connector on the uSD-M2 Adapter,
in one end, and a PC, USB Hub or USB charger in the other end.

The BLUE LED on the uSD-M2 Adapter should be on if the adapter is configured correctly.

More information about the M.2 Modules can be found here: https://www.embeddedartists.com/m2/.
More information about the uSD-M2 Adapter can be found here: https://wireless.murata.com/usd-m2.html.

It could be possible to use the other modules as shown in the original
readme text below, however that is untested and unsupported.


Everything below this line is the original content of the readme file.
=======================================================================



Overview
========
The wifi_httpsrv demo application demonstrates an HTTPServer on the lwIP TCP/IP stack with FreeRTOS.
The user uses an Internet browser to send a request for connection. The board acts as an HTTP server and sends a Web
page back to the PC

Before building the example application select Wi-Fi module macro in the app_config.h. (see #define WIFI_<SoC Name>_BOARD_<Module Name>).
For more information about Wi-Fi module connection see:
    readme_modules.txt
    Getting started guide on supported modules configuration:
    https://www.nxp.com/document/guide/getting-started-with-nxp-wi-fi-modules-using-i-mx-rt-platform:GS-WIFI-MODULES-IMXRT-PLATFORM



SDK version
===========
- Version: 2.15.000

Toolchain supported
===================
- IAR embedded Workbench  9.40.1
- Keil MDK  5.38.1
- GCC ARM Embedded  12.2
- MCUXpresso  11.8.0

Hardware requirements
=====================
- Micro USB cable
- EVK-MIMXRT1064 board
- Personal Computer


Board settings
==============

Prepare the Demo
================
1.  Connect a micro USB cable between the PC host and the CMSIS DAP USB port on the board
2.  Open a serial terminal with the following settings:
    - 115200 baud rate
    - 8 data bits
    - No parity
    - One stop bit
    - No flow control
3.  Connect the Wi-Fi module.
4.  Set symbols WIFI_SSID and WIFI_PASSWORD to match settings of your network prior building of example.
5.  Download the program to the target board.
6.  Either press the reset button on your board or launch the debugger in your IDE to begin running the demo.


Running the demo
================
1.	When the demo runs, it tries to connect to your network and acquire configuration form DHCP.
2.	On success network configuration will be printed.
3.	On the browser address bar, type IP address of the board.
	The browser should show a web page. The board also advertises itself using mDNS so that it can be accessed using URL http://wifi-http.local.
	Please note that your system may not support mDNS out-of-the-box as it is necessary to have an mDNS resolver installed.
    For instance Bonjour Print Services for Windows contain such resolver. In case of Linux nss-mdns serves this purpose.
    Username admin and password admin is required to access "Authorization example" section of the web page.


Modifying content of static web pages
To modify content available through the web server you must complete following steps:
  1. Modify, add or delete files in folder "boards\<board_name>\lwip_examples\lwip_httpsrv_freertos\webpage".
  2. Run the script file "middleware\lwip\src\apps\httpsrv\mkfs\mkfs.pl <directory name>" to generate new "httpsrv_fs_data.c".
     Make sure to execute it from a folder where the file "httpsrv_fs_data.c" is. For example:
        C:\sdk\boards\<board_name>\lwip_examples\lwip_httpsrv_freertos> C:\sdk\middleware\lwip\src\apps\httpsrv\mkfs\mkfs.pl webpage
		Processing file webpage/auth.html
		Processing file webpage/cgi.html
		Processing file webpage/favicon.ico
		Processing file webpage/help.html
		Processing file webpage/httpsrv.css
		Processing file webpage/index.html
		Processing file webpage/NXP_logo.png
		Processing file webpage/poll.html
		Processing file webpage/request.js
		Processing file webpage/ssi.shtml
		Processing file webpage/welcome.html
		Done.
  3. Make sure the "httpsrv_fs_data.c" file has been overwritten with the newly generated content.
  4. Re-compile the HTTP server application example and download it to your board.
