
This SDK has been patched by Embedded Artists for the iMXRT1064 Developer's Kit.
The SDK was released on 2024-03-25 and is based on NXP's 2.15.000 SDK (SDK_2_15_000_MIMXRT1064xxxxB.zip).

This is what has been patched:
* Set CPU speed according to Commercial/Industrial CPU
* Correction of the VDD_SOC_IN voltage.
* LWIP projects - added reading of the MAC address from the onboard I2C EEPROM
* Added an I2C driver for the gpio expander (PCA6416) and code to use it
* Added an I2C driver for the PWM gpio expander (PCA9530) and code to use it
* SEMC projects - changed algorithm for memory test and now test entire 32MB instead of only 4KB
* Examples using a display have been updated to use PCA6416/PCA9530 for
  RST/PWR/BL signals
* BOARD_USER_BUTTON has been redirected to SW5/WAKEUP button on the uCOM Carrier Board
* USER_LED has been changed to the blue RGB LED using PCA6416
* Adjusted the USB interface number (it is different for host and device examples)
* Changed the Wi-Fi examples to use the Embedded Artists 1XK M.2 Module (EAR00385) as default
* Many of the projects have been updated to use a more complete pin_mux.c file where all
  necessary pins have been initialized. The SDK examples used to only configure the pins
  that they use (and often not every pin) and most of the time the configuration was only
  for MUX:ing and not the PAD settings (pull up/down/none, drive strength and slew).
* Changed reset pin for SD card examples

This has been added:
* LWIP projects - option to use 100/10Mbps Ethernet-PHY Adapter
* AWS projects - option to use 100/10Mbps Ethernet-PHY Adapter
* AzureRTOS projects - option to use 100/10Mbps Ethernet-PHY Adapter
* I2C probe example

Important things to note:
* Read section "8 - Known Issues" in docs/MCUXpresso SDK Release Notes for EVK-MIMXRT1064.pdf
  to see known issues with the current version of the SDK.
* For Iperf examples, set compiler optimization to -O3 or similar to improve performance.
* If the hardware seems unresponsive and the debugger cannot connect/flash/erase the current program
  then the most likely cause is the running program preventing the access. To stop the currently
  running program and regain control:
  1) Press and hold down the ISP_ENABLE button (SW1)
  2) Press and hold down the RESET button (SW3)
  3) Let go of the RESET button
  4) Wait an extra second or two
  5) Release the ISP_ENABLE button
  6) The hardware is now in a mode where programming/erasing it should work


Connectors:
* J29 (micro USB) is the default UART and unless specified otherwise it is setup for 115200 8/N/1


This example has been configured to use the 1XK M.2 module. To change which
module to use, replace WIFI_IW416_BOARD_MURATA_1XK_USD in the app_config.h file
with one of the following and then rebuild the project:

    WIFI_IW416_BOARD_MURATA_1XK_ONBOARD - To use the 1XK chip on the uCOM board (special mounting option)
    WIFI_IW416_BOARD_MURATA_1XK_USD     - To use the 1XK M.2 module
    WIFI_88W8801_BOARD_MURATA_2DS_USD   - To use the 2DS M.2 module
    WIFI_88W8987_BOARD_MURATA_1ZM_USD   - To use the 1ZM M.2 module

This example requires an M.2 Module and a uSD-M2 Adapter (LBEE0ZZ1WE-TEMP)
from Murata inserted in uSD connector J34. The M.2 socket (J33) on the uCOM Carrier Board
is not used.

The uSD-M2 Adapter must be configured with:
J1  shorted in 1-2 position
J12 shorted in 2-3 position
J13 shorted in 1-2 position
J9 pin 3 must be connected to J32 pin 2 (INT) on the uCOM Carrier Board with a cable.

Due to high current consumption peaks of the M.2 module, especially during startup calibration,
you must power the uSD-M2 Adapter from an external source. The power supply from the uSD
interface is not enough. Connect a USB cable to the micro-B USB connector on the uSD-M2 Adapter,
in one end, and a PC, USB Hub or USB charger in the other end.

The BLUE LED on the uSD-M2 Adapter should be on if the adapter is configured correctly.

More information about the M.2 Modules can be found here: https://www.embeddedartists.com/m2/.
More information about the uSD-M2 Adapter can be found here: https://wireless.murata.com/usd-m2.html.

It could be possible to use the other modules as shown in the original
readme text below, however that is untested and unsupported.


Everything below this line is the original content of the readme file.
=======================================================================



Overview
========
The wifi_ipv4_ipv6_echo application demonstrates a TCP and UDP echo on the lwIP TCP/IP stack with FreeRTOS.
The demo can use both TCP or UDP protocol over IPv4 or IPv6 and acts as an echo server. The application sends back
the packets received from the PC, which can be used to test whether a TCP or UDP connection is available.

A few notes about IPv6
The demo generates a link-local address (the one from range FE80::/10) after the start. To send something to this (demo) address
from your computer you need to specify the interface over which the demo is reachable by appending % followed by zone index.
- On Windows, the zone index is a number. You can get it from the output of the ipconfig command.
- On Linux, the zone index is an interface name.
To connect to board with address FE80::12:13FF:FE10:1511
- over interface 21 on your Windows machine specify address as FE80::12:13FF:FE10:1511%21
- over interface eth on your Linux or Mac machine specify address as FE80::12:13FF:FE10:1511%eth0
But the demo has only a single interface, so do not append zone ID to any address typed to the demo terminal.

The LwIP stack is trying to get an IPv6 address automatically by neighbor discovery in the background.
This takes some time. You can print all addresses using the command print_ip_cfg any time.

Tools
It is necessary to have installed tools capable of sending and receiving data over TCP or UDP to interact with the demo.
- ncat - Recommended tool. Supports both IPv4 and IPv6. It is part of nmap tools. It can be found at https://nmap.org/download.html.
- nc (netcat) - Basically, the same as ncat, but a lot of antiviruses consider this a virus.
- echotool - Supports only IPv4 and only for Windows. It can be obtained from https://github.com/PavelBansky/EchoTool


SDK version
===========
- Version: 2.15.000

Toolchain supported
===================
- IAR embedded Workbench  9.40.1
- Keil MDK  5.38.1
- GCC ARM Embedded  12.2
- MCUXpresso  11.8.0

Hardware requirements
=====================
- Micro USB cable
- EVK-MIMXRT1064 board
- Personal Computer


Board settings
==============

Prepare the Demo
================
Before building the example application, select Wi-Fi module macro in the app_config.h. (see #define WIFI_<SoC Name>_BOARD_<Module Name>).
For more information about Wi-Fi module connection, see:
    readme_modules.txt
    Getting started guide on supported modules configuration:
    https://www.nxp.com/document/guide/getting-started-with-nxp-wi-fi-modules-using-i-mx-rt-platform:GS-WIFI-MODULES-IMXRT-PLATFORM
    
1.  Connect a micro USB cable between the PC host and the CMSIS DAP USB port on the board.
2.  Open a serial terminal with the following settings:
    - 115200 baud rate
    - 8 data bits
    - No parity
    - One stop bit
    - No flow control
3.  Connect the WiFi module to the SD card slot.
4.  Download the program to the target board.
5.  Either press the reset button on your board or launch the debugger in your IDE to begin running the demo.

Running the demo
================

1.  When the demo starts, a welcome message would appear on the terminal, press enter for the command prompt:
    Press tab or type help to list out all available CLI commands.

    Initialize WLAN
    MAC Address: 9C:50:D1:45:4D:87
    Initialize CLI

    Copyright  2022  NXP

    SHELL>> help

    "help": List all the registered commands

    "exit": Exit program

    "echo_tcp_client ip_addr port":
    Connects to specified server and sends back every received data.
    Usage:
    ip_addr:     IPv6 or IPv4 server address
    port:        TCP port number

    "echo_tcp_server port":
    Listens for one incoming connection and sends back every received data.
    Usage:
    port:        TCP port number

    "echo_udp port":
    Waits for datagrams and sends them back.
    Usage:
    port:        UDP port number

    "end": Ends echo_* command.

    "print_ip_cfg": Prints IP configuration.

    "wlan_scan": Scans networks.

    "wlan_connect ssid":
    Connects to the specified network without password.
    Usage:
    ssid:        network SSID

    "wlan_connect_with_password ssid password":
    Connects to the specified network with password.
    Usage:
    ssid:        network SSID
    password:    password

    "wlan_disconnect":
    Disconnect from connected network
    SHELL>>

2.  You can list all available networks using wlan_scan command.
    SHELL>> wlan_scan

    Initiating scan...
    MyWifi
        BSSID         : 00:5F:67:8B:25:8E
        RSSI          : -66dBm
        Channel       : 1

3.  Connect to the network using one of the following commands:

    wlan_connect <ssid>
    wlan_connect_with_password <ssid> <password>
    
    Use SSID (the name of your network) to join the network.
    
    Example of successful wlan_connect_with_password command:	

    SHELL>> wlan_connect_with_password MyWifi pass0123456
    Joining: MyWifi
    Network joined
    
    Note: If you see your network in the list of scanned networks but demo 
    prints "Failed to join network!", make sure you entered the correct SSID and password.
    If that did not help, try to restart your Wi-Fi access point.

4.  TCP client echo
    a) Launch ncat -v -l -p 10001 on your computer.
    b) Run the command echo_tcp_client <PC IPv4 addr> 10001 in demo shell.
    c) You should see on your PC "Ncat: Connection from <Demo IPv4 addr>."
    d) Type some text into ncat (not demo shell) and the demo will send your line back
       when you hit enter.
    e) You can terminate the connection by pressing ctrl+c in ncat or typing end to the demo shell.
    
    For IPv6 just replace <PC IPv4 addr> with IPv6 address of your PC.
    
5.  TCP server echo
    a) Run the command echo_tcp_server 10001 in demo shell.
    b) Launch ncat -v <Demo IPv4 addr> 10001 on your computer.
    c) You should see on your PC "Ncat: Connected to <Demo IPv4 addr>:10001."
    d) Type some text into ncat (not demo shell) and the demo will send your line back
       when you hit enter.
    e) You can terminate the connection by pressing ctrl+c in ncat or typing end to the demo shell.
    
    For IPv6, just replace <Demo IPv4 addr> with the IPv6 address of the demo. In case of
    link-local IPv6 address, don't forget to append % followed by zone id of your PC.
    
6.  UDP echo
    a) Run the command echo_udp 10001 in demo shell.
    b) On your computer launch ncat -v -u <Demo IPv4 addr> 10001
    c) You should see on your PC "Ncat: Connected to <Demo IPv4 addr>:10001."
    d) Type some text into ncat (not the demo shell) and the demo will send your line back
       when you hit enter.
    e) To terminate is necessary by doing both, pressing ctrl+c in ncat and typing end to demo shell.
    
    For IPv6, just replace <Demo IPv4 addr> with the IPv6 address of the demo. In case of
    link-local IPv6 address, don't forget to append % followed by zone id of your PC.
