/*
 *  Copyright 2021-2023 NXP
 *  All rights reserved.
 *
 *  SPDX-License-Identifier: BSD-3-Clause
 */

/*
 * Supported Wi-Fi boards (modules):
 *     WIFI_88W8801_BOARD_AW_NM191_USD
 *     WIFI_IW416_BOARD_AW_AM510_USD
 *     WIFI_88W8987_BOARD_AW_CM358_USD
 *     WIFI_88W8801_BOARD_MURATA_2DS_USD
 *     WIFI_IW416_BOARD_MURATA_1XK_USD
 *     WIFI_IW416_BOARD_MURATA_1XK_ONBOARD
 *     WIFI_88W8987_BOARD_MURATA_1ZM_USD
 */
/* @TEST_ANCHOR */
#define WIFI_IW416_BOARD_MURATA_1XK_USD
/* @END_TEST_ANCHOR */

#include "wifi_bt_module_config.h"
#include "wifi_config.h"

/* For convenience - sets WIFI_BOARD_NAME as string */
#if defined(WIFI_88W8801_BOARD_AW_NM191_USD)
   #define WIFI_BOARD_NAME  "WIFI_88W8801_BOARD_AW_NM191_USD"
#elif defined(WIFI_IW416_BOARD_AW_AM510_USD)
   #define WIFI_BOARD_NAME  "WIFI_IW416_BOARD_AW_AM510_USD"
#elif defined(WIFI_88W8987_BOARD_AW_CM358_USD)
   #define WIFI_BOARD_NAME  "WIFI_88W8987_BOARD_AW_CM358_USD"
#elif defined(WIFI_88W8801_BOARD_MURATA_2DS_USD)
   #define WIFI_BOARD_NAME  "WIFI_88W8801_BOARD_MURATA_2DS_USD"
#elif defined(WIFI_IW416_BOARD_MURATA_1XK_USD)
   #define WIFI_BOARD_NAME  "WIFI_IW416_BOARD_MURATA_1XK_USD"
#elif defined(WIFI_IW416_BOARD_MURATA_1XK_ONBOARD)
   #define WIFI_BOARD_NAME  "WIFI_IW416_BOARD_MURATA_1XK_ONBOARD"
#elif defined(WIFI_88W8987_BOARD_MURATA_1ZM_USD)
   #define WIFI_BOARD_NAME  "WIFI_88W8987_BOARD_MURATA_1ZM_USD"
#endif
