
This SDK has been patched by Embedded Artists for the iMXRT1064 Developer's Kit.
The SDK was released on 2024-03-25 and is based on NXP's 2.15.000 SDK (SDK_2_15_000_MIMXRT1064xxxxB.zip).

This is what has been patched:
* Set CPU speed according to Commercial/Industrial CPU
* Correction of the VDD_SOC_IN voltage.
* LWIP projects - added reading of the MAC address from the onboard I2C EEPROM
* Added an I2C driver for the gpio expander (PCA6416) and code to use it
* Added an I2C driver for the PWM gpio expander (PCA9530) and code to use it
* SEMC projects - changed algorithm for memory test and now test entire 32MB instead of only 4KB
* Examples using a display have been updated to use PCA6416/PCA9530 for
  RST/PWR/BL signals
* BOARD_USER_BUTTON has been redirected to SW5/WAKEUP button on the uCOM Carrier Board
* USER_LED has been changed to the blue RGB LED using PCA6416
* Adjusted the USB interface number (it is different for host and device examples)
* Changed the Wi-Fi examples to use the Embedded Artists 1XK M.2 Module (EAR00385) as default
* Many of the projects have been updated to use a more complete pin_mux.c file where all
  necessary pins have been initialized. The SDK examples used to only configure the pins
  that they use (and often not every pin) and most of the time the configuration was only
  for MUX:ing and not the PAD settings (pull up/down/none, drive strength and slew).
* Changed reset pin for SD card examples

This has been added:
* LWIP projects - option to use 100/10Mbps Ethernet-PHY Adapter
* AWS projects - option to use 100/10Mbps Ethernet-PHY Adapter
* AzureRTOS projects - option to use 100/10Mbps Ethernet-PHY Adapter
* I2C probe example

Important things to note:
* Read section "8 - Known Issues" in docs/MCUXpresso SDK Release Notes for EVK-MIMXRT1064.pdf
  to see known issues with the current version of the SDK.
* For Iperf examples, set compiler optimization to -O3 or similar to improve performance.
* If the hardware seems unresponsive and the debugger cannot connect/flash/erase the current program
  then the most likely cause is the running program preventing the access. To stop the currently
  running program and regain control:
  1) Press and hold down the ISP_ENABLE button (SW1)
  2) Press and hold down the RESET button (SW3)
  3) Let go of the RESET button
  4) Wait an extra second or two
  5) Release the ISP_ENABLE button
  6) The hardware is now in a mode where programming/erasing it should work


Connectors:
* J29 (micro USB) is the default UART and unless specified otherwise it is setup for 115200 8/N/1


This example has been configured to use the 1XK M.2 module. To change which
module to use, replace WIFI_IW416_BOARD_MURATA_1XK_USD in the app_config.h file
with one of the following and then rebuild the project:

    WIFI_IW416_BOARD_MURATA_1XK_ONBOARD - To use the 1XK chip on the uCOM board (special mounting option)
    WIFI_IW416_BOARD_MURATA_1XK_USD     - To use the 1XK M.2 module
    WIFI_88W8801_BOARD_MURATA_2DS_USD   - To use the 2DS M.2 module
    WIFI_88W8987_BOARD_MURATA_1ZM_USD   - To use the 1ZM M.2 module

This example requires an M.2 Module and a uSD-M2 Adapter (LBEE0ZZ1WE-TEMP)
from Murata inserted in uSD connector J34. The M.2 socket (J33) on the uCOM Carrier Board
is not used.

The uSD-M2 Adapter must be configured with:
J1  shorted in 1-2 position
J12 shorted in 2-3 position
J13 shorted in 1-2 position
J9 pin 3 must be connected to J32 pin 2 (INT) on the uCOM Carrier Board with a cable.

Due to high current consumption peaks of the M.2 module, especially during startup calibration,
you must power the uSD-M2 Adapter from an external source. The power supply from the uSD
interface is not enough. Connect a USB cable to the micro-B USB connector on the uSD-M2 Adapter,
in one end, and a PC, USB Hub or USB charger in the other end.

The BLUE LED on the uSD-M2 Adapter should be on if the adapter is configured correctly.

More information about the M.2 Modules can be found here: https://www.embeddedartists.com/m2/.
More information about the uSD-M2 Adapter can be found here: https://wireless.murata.com/usd-m2.html.

It could be possible to use the other modules as shown in the original
readme text below, however that is untested and unsupported.


Everything below this line is the original content of the readme file.
=======================================================================



Overview
========
This demo implements a simple web based Wi-Fi configuration utility for connecting the board to the local Wireless network. 

Initially, the board doesn't have the credentials to join the local network, so it starts its own Access Point with SSID: "nxp_configuration_access_point" and password: "NXP0123456789".

The user can connect their device to this SSID and access the HTML UI under 192.168.1.1. The board will scan for the nearby Wi-Fi networks and display a list of them on this page. By clicking on the entries, the user can choose their network, enter the credentials and connect. The board will attempt to join this Wi-Fi network as a client and if it succeeds, it will disconnect its AP and save the credentials to its mflash memory.

On successive restarts, it checks the mflash memory and uses the saved credentials to directly connect to the local Wi-Fi network without starting the AP. 

A simple LED visualization is implemented. The board LED will be on if the device is in AP mode and turns off after the board changes to client mode.

The site allows the user to clear the credentials from the flash memory and reset the board to AP mode. If connection fails, user can also set device to AP mode through serial connection.

The source files for the web interface are located in the webui directory. Use the `<path_to_sdk>/middleware/lwip/src/apps/httpsrv/mkfs/mkfs.pl webui` Perl script in order to convert the webui files into the httpsrv_fs_data.c which is used in order to flash the static files onto the board. Make sure the mkfsl.pl script is executed from the same directory where the file httpsrv_fs_data.c and the directory webui are.

Note that Microsoft Internet Explorer is not supported by this webconfig example.

Before building the example application select Wi-Fi module macro in the app_config.h. (see #define WIFI_<SoC Name>_BOARD_<Module Name>).
For more information about Wi-Fi module connection see:
    readme_modules.txt
    Getting started guide on supported modules configuration:
    https://www.nxp.com/document/guide/getting-started-with-nxp-wi-fi-modules-using-i-mx-rt-platform:GS-WIFI-MODULES-IMXRT-PLATFORM



SDK version
===========
- Version: 2.15.000

Toolchain supported
===================
- IAR embedded Workbench  9.40.1
- Keil MDK  5.38.1
- GCC ARM Embedded  12.2
- MCUXpresso  11.8.0

Hardware requirements
=====================
- Micro USB cable
- EVK-MIMXRT1064 board
- Personal Computer


Board settings
==============

Prepare the Demo
================
1.  Connect a micro USB cable between the PC host and the CMSIS DAP USB port on the board
2.  Open a serial terminal with the following settings:
    - 115200 baud rate
    - 8 data bits
    - No parity
    - One stop bit
    - No flow control
3.  Connect the WiFi module to SD card slot or M.2 slot.
4.  Download the program to the target board.
5.  Either press the reset button on your board or launch the debugger in your IDE to begin running the demo.


Running the demo
================
1. When the demo starts, basic initialization proceeds
2. After that, device will wait for connection and configuration:

+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
Starting webconfig DEMO
[i] Trying to load data from mflash.
[i] Nothing stored yet
[i] Initializing Wi-Fi connection...
MAC Address: 9C:50:D1:44:67:5F
[i] Successfully initialized Wi-Fi module
Starting Access Point: SSID: nxp_configuration_access_point, Chnl: 1
[wlcm] Warn: NOTE: uAP will automatically switch to the channel that station is on.
 Now join that network on your device and connect to this IP: 192.168.1.1
+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

3. Connect to the access point and in your web browser enter 192.168.1.1
4. Wait for the scan to finish - the demo terminal will print something like:

+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
Initiating scan...

nxptp
     BSSID         : B0:A7:B9:99:27:52
     RSSI          : -34dBm
     Channel       : 3
+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

5. In your web browser you should also see the scan results, click on the network
   you want to add, fill in the credentials and click connect.
6. After you send credentials, device will try connecting to the AP and if successful saves the credentials to the mflash.

+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
[i] Chosen ssid: nxptp
[i] Chosen passphrase: "NXP01234"
[i] Chosen security methods: "WPA2 WPA3_SAE"
[i] Joining: nxptp
[i] Successfully joined: nxptp
 Now join that network on your device and connect to this IP: 192.168.0.209
[i] mflash_save_file success
[i] Stopping AP!
+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

7. The device is now in station mode and is joined to the selected network.
   Now join this network on your PC and enter the IP from demo terminal.
8. You can try to join different networks or reset the board back to AP mode and start again.
