/*
 * Copyright 2020 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

/***********************************************************************************************************************
 * This file was generated by the MCUXpresso Config Tools. Any manual edits made to this file
 * will be overwritten if the respective MCUXpresso Config Tools is used to update this file.
 **********************************************************************************************************************/

/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
!!GlobalInfo
product: Pins v8.0
processor: MIMXRT1166xxxxx
package_id: MIMXRT1166DVM6A
mcu_data: ksdk2_0
processor_version: 0.8.1
pin_labels:
- {pin_num: K14, pin_signal: GPIO_AD_21, label: UART1_TXD, identifier: UART1_TXD;TX}
- {pin_num: L14, pin_signal: GPIO_AD_26, label: UART1_RXD, identifier: UART1_RXD;RX_GPIO;RX}
- {pin_num: M15, pin_signal: GPIO_AD_25, label: UART1_RX_PIN, identifier: UART_RX_DETECT;UART1_RX_PIN}
- {pin_num: L13, pin_signal: GPIO_AD_24, label: UART1_TX_PIN, identifier: UART1_TX_PIN}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */

#include "fsl_iomuxc.h"
#include "fsl_gpio.h"
#include "peripherals_pinmux.h"

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitBootPins
 * Description   : Calls initialization functions.
 *
 * END ****************************************************************************************************************/
void BOARD_InitBootPins(void) {
}

/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
UART1_PollForActivity:
- options: {callFromInitBoot: 'false', coreID: cm7, enableClock: 'false'}
- pin_list:
  - {pin_num: M15, peripheral: CM7_GPIO3, signal: 'gpio_mux_io_cm7, 24', pin_signal: GPIO_AD_25, identifier: UART_RX_DETECT}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : UART1_PollForActivity, assigned for the Cortex-M7F core.
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
void UART1_PollForActivity(void) {

  /* GPIO configuration of RX_GPIO on GPIO_AD_25 */
  gpio_pin_config_t RX_GPIO_config = {
      .direction = kGPIO_DigitalInput,
      .outputLogic = 0U,
      .interruptMode = kGPIO_NoIntmode
  };
  /* Initialize GPIO functionality on GPIO_AD_25 */
  GPIO_PinInit(UART1_RX_GPIO_BASE, UART1_RX_GPIO_PIN_NUM, &RX_GPIO_config);
  IOMUXC_SetPinMux(
      UART1_RX_IOMUXC_MUX_GPIO,               /* GPIO_AD_25 is configured as GPIO_MUX3_IO24 */
      0U);                                    /* Software Input On Field: Input Path is determined by functionality */
  IOMUXC_GPR->GPR43 &= ~IOMUXC_GPR_GPR43_GPIO_MUX3_GPIO_SEL_HIGH(1<<(UART1_RX_GPIO_PIN_NUM-16));
  IOMUXC_SetPinConfig(
      UART1_RX_IOMUXC_MUX_GPIO,
      IOMUXC_SW_PAD_CTL_PAD_PUE(1) | IOMUXC_SW_PAD_CTL_PAD_PUS(1));
}

/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
UART1_InitPins:
- options: {callFromInitBoot: 'false', prefix: UART1_, coreID: cm7, enableClock: 'false'}
- pin_list:
  - {pin_num: M15, peripheral: LPUART1, signal: RXD, pin_signal: GPIO_AD_25, identifier: UART1_RX_PIN}
  - {pin_num: L13, peripheral: LPUART1, signal: TXD, pin_signal: GPIO_AD_24}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : UART1_InitPins, assigned for the Cortex-M7F core.
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
void UART1_InitPins(void) {
  IOMUXC_SetPinMux(
      UART1_TX_IOMUXC_MUX_FUNC,               /* GPIO_AD_24 is configured as LPUART1_TX */
      0U);                                    /* Software Input On Field: Input Path is determined by functionality */
  IOMUXC_SetPinMux(
      UART1_RX_IOMUXC_MUX_FUNC,               /* GPIO_AD_25 is configured as LPUART1_RX */
      0U);                                    /* Software Input On Field: Input Path is determined by functionality */
  IOMUXC_SetPinConfig(
      UART1_TX_IOMUXC_MUX_FUNC,
      IOMUXC_SW_PAD_CTL_PAD_DSE(1) | IOMUXC_SW_PAD_CTL_PAD_PUE(1) | IOMUXC_SW_PAD_CTL_PAD_PUS(1));
  IOMUXC_SetPinConfig(
      UART1_RX_IOMUXC_MUX_FUNC,
      IOMUXC_SW_PAD_CTL_PAD_DSE(1) | IOMUXC_SW_PAD_CTL_PAD_PUE(1) | IOMUXC_SW_PAD_CTL_PAD_PUS(1));
}

/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
UART1_RestoreDefault:
- options: {callFromInitBoot: 'false', coreID: cm7, enableClock: 'false'}
- pin_list:
  - {pin_num: L13, peripheral: LPUART1, signal: TXD, pin_signal: GPIO_AD_24}
  - {pin_num: M15, peripheral: LPUART1, signal: RXD, pin_signal: GPIO_AD_25, identifier: UART1_RX_PIN}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : UART1_RestoreDefault, assigned for the Cortex-M7F core.
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
void UART1_RestoreDefault(void) {
  IOMUXC_SetPinMux(
      UART1_TX_IOMUXC_MUX_FUNC,               /* GPIO_AD_24 is configured as LPUART1_TX */
      0U);                                    /* Software Input On Field: Input Path is determined by functionality */
  IOMUXC_SetPinMux(
      UART1_RX_IOMUXC_MUX_FUNC,               /* GPIO_AD_25 is configured as LPUART1_RX */
      0U);                                    /* Software Input On Field: Input Path is determined by functionality */
  IOMUXC_SetPinConfig(
      UART1_TX_IOMUXC_MUX_FUNC,
      IOMUXC_SW_PAD_CTL_PAD_DSE(1));
  IOMUXC_SetPinConfig(
      UART1_RX_IOMUXC_MUX_FUNC,
      IOMUXC_SW_PAD_CTL_PAD_DSE(1));
}

/***********************************************************************************************************************
 * EOF
 **********************************************************************************************************************/
