/*
 * Copyright 2021 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

/***********************************************************************************************************************
 * This file was generated by the MCUXpresso Config Tools. Any manual edits made to this file
 * will be overwritten if the respective MCUXpresso Config Tools is used to update this file.
 **********************************************************************************************************************/

/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
!!GlobalInfo
product: Pins v9.0
processor: MIMXRT1166xxxxx
package_id: MIMXRT1166DVM6A
mcu_data: ksdk2_0
processor_version: 0.0.0
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */

#include "fsl_common.h"
#include "fsl_iomuxc.h"
#include "pin_mux.h"

/* FUNCTION ************************************************************************************************************
 * 
 * Function Name : BOARD_InitBootPins
 * Description   : Calls initialization functions.
 * 
 * END ****************************************************************************************************************/
void BOARD_InitBootPins(void) {
    BOARD_InitPins();
}

/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
BOARD_InitPins:
- options: {callFromInitBoot: 'true', coreID: cm7, enableClock: 'true'}
- pin_list:
  - {pin_num: D9, peripheral: XBARA1, signal: 'IN, 38', pin_signal: GPIO_DISP_B2_10, software_input_on: Enable}
  - {pin_num: A6, peripheral: XBARA1, signal: 'IN, 39', pin_signal: GPIO_DISP_B2_11, software_input_on: Enable}
  - {pin_num: M15, peripheral: LPUART1, signal: RXD, pin_signal: GPIO_AD_25, software_input_on: Disable}
  - {pin_num: L13, peripheral: LPUART1, signal: TXD, pin_signal: GPIO_AD_24}
  - {pin_num: B6, peripheral: XBARA1, signal: 'IN, 40', pin_signal: GPIO_DISP_B2_12, software_input_on: Enable}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitPins, assigned for the Cortex-M7F core.
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
void BOARD_InitPins(void) {
  CLOCK_EnableClock(kCLOCK_Iomuxc);           /* LPCG on: LPCG is ON. */

  IOMUXC_SetPinMux(
      IOMUXC_GPIO_AD_24_LPUART1_TXD,          /* GPIO_AD_24 is configured as LPUART1_TXD */
      0U);                                    /* Software Input On Field: Input Path is determined by functionality */
  IOMUXC_SetPinMux(
      IOMUXC_GPIO_AD_25_LPUART1_RXD,          /* GPIO_AD_25 is configured as LPUART1_RXD */
      0U);                                    /* Software Input On Field: Input Path is determined by functionality */
  IOMUXC_SetPinMux(
      IOMUXC_GPIO_DISP_B2_10_XBAR1_INOUT38,   /* GPIO_DISP_B2_10 is configured as XBAR1_INOUT38 */
      1U);                                    /* Software Input On Field: Force input path of pad GPIO_DISP_B2_10 */
  IOMUXC_SetPinMux(
      IOMUXC_GPIO_DISP_B2_11_XBAR1_INOUT39,   /* GPIO_DISP_B2_11 is configured as XBAR1_INOUT39 */
      1U);                                    /* Software Input On Field: Force input path of pad GPIO_DISP_B2_11 */
  IOMUXC_SetPinMux(
      IOMUXC_GPIO_DISP_B2_12_XBAR1_INOUT40,   /* GPIO_DISP_B2_12 is configured as XBAR1_INOUT40 */
      1U);                                    /* Software Input On Field: Force input path of pad GPIO_DISP_B2_12 */
  IOMUXC_GPR->GPR21 = ((IOMUXC_GPR->GPR21 &
    (~(IOMUXC_GPR_GPR21_IOMUXC_XBAR_DIR_SEL_38_MASK | IOMUXC_GPR_GPR21_IOMUXC_XBAR_DIR_SEL_39_MASK | IOMUXC_GPR_GPR21_IOMUXC_XBAR_DIR_SEL_40_MASK))) /* Mask bits to zero which are setting */
      | IOMUXC_GPR_GPR21_IOMUXC_XBAR_DIR_SEL_38(0x00U) /* IOMUXC XBAR_INOUT38 function direction select: 0x00U */
      | IOMUXC_GPR_GPR21_IOMUXC_XBAR_DIR_SEL_39(0x00U) /* IOMUXC XBAR_INOUT39 function direction select: 0x00U */
      | IOMUXC_GPR_GPR21_IOMUXC_XBAR_DIR_SEL_40(0x00U) /* IOMUXC XBAR_INOUT40 function direction select: 0x00U */
    );
}

/***********************************************************************************************************************
 * EOF
 **********************************************************************************************************************/
