/*
 * Copyright 2021 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */
#ifndef _LCDIFV2_SUPPORT_H_
#define _LCDIFV2_SUPPORT_H_

#include "fsl_mipi_dsi.h"

/*******************************************************************************
 * Definitions
 ******************************************************************************/
#define MIPI_PANEL_RK055AHD091        1   /* 720 * 1280, RK055AHD091-CTG(RK055HDMIPI4M) */
#define MIPI_PANEL_RK055IQH091        2   /* 540 * 960,  RK055IQH091-CTG */
#define MIPI_PANEL_RK055MHD091        3   /* 720 * 1280, RK055MHD091A0-CTG(RK055HDMIPI4MA0) */
#define MIPI_PANEL_RK043FN02HC        4   /* 480 * 272 */
#define MIPI_PANEL_KD050WVTPA045      5   /* 800 * 480 */
#define MIPI_PANEL_NHD50800480TFATXL  6   /* 800 * 480,  NHD-5.0-800480TF-ATXL#-CTP */
#define MIPI_PANEL_HDMI_720X480_60   10
#define MIPI_PANEL_HDMI_720X576_50   11
#define MIPI_PANEL_HDMI_800X480_60   12
#define MIPI_PANEL_HDMI_1024X600_76  13
#define MIPI_PANEL_HDMI_1024X768_60  14
#define MIPI_PANEL_HDMI_1280X720_60  15
#define MIPI_PANEL_HDMI_1920X1080_30 16

#define DEMO_LCDIFV2            LCDIFV2
#define DEMO_LCDIFV2_IRQn       LCDIFv2_IRQn
#define DEMO_LCDIFV2_IRQHandler LCDIFv2_IRQHandler

#ifndef USE_MIPI_PANEL
#define USE_MIPI_PANEL   MIPI_PANEL_RK043FN02HC
#endif

#if (MIPI_PANEL_RK055AHD091 == USE_MIPI_PANEL)

  #define DEMO_PANEL_WIDTH  (720)
  #define DEMO_PANEL_HEIGHT (1280)
  #define DEMO_PANEL_NAME   "RK055AHD091"

  #define DEMO_HSW 8
  #define DEMO_HFP 32
  #define DEMO_HBP 32
  #define DEMO_VSW 2
  #define DEMO_VFP 16
  #define DEMO_VBP 14

#elif (MIPI_PANEL_RK055IQH091 == USE_MIPI_PANEL)

  #define DEMO_PANEL_WIDTH  (540)
  #define DEMO_PANEL_HEIGHT (960)
  #define DEMO_PANEL_NAME   "RK055IQH091"

  #define DEMO_HSW 2
  #define DEMO_HFP 32
  #define DEMO_HBP 30
  #define DEMO_VSW 2
  #define DEMO_VFP 16
  #define DEMO_VBP 14

#elif (MIPI_PANEL_RK055MHD091 == USE_MIPI_PANEL)

  #define DEMO_PANEL_WIDTH  (720)
  #define DEMO_PANEL_HEIGHT (1280)
  #define DEMO_PANEL_NAME   "RK055MHD091"

  #define DEMO_HSW 6
  #define DEMO_HFP 12
  #define DEMO_HBP 24
  #define DEMO_VSW 2
  #define DEMO_VFP 16
  #define DEMO_VBP 14

#elif (MIPI_PANEL_RK043FN02HC == USE_MIPI_PANEL)

  #define DEMO_PANEL_WIDTH  (480)
  #define DEMO_PANEL_HEIGHT (272)
  #define DEMO_PANEL_NAME   "RK043FN02HC"

  #define DEMO_HSW 2
  #define DEMO_HFP 32
  #define DEMO_HBP 30
  #define DEMO_VSW 2
  #define DEMO_VFP 16
  #define DEMO_VBP 14

#elif (MIPI_PANEL_KD050WVTPA045 == USE_MIPI_PANEL)

  #define DEMO_PANEL_WIDTH  (800)
  #define DEMO_PANEL_HEIGHT (480)
  #define DEMO_PANEL_NAME   "KD050WVTPA045"

  #define DEMO_HSW 48
  #define DEMO_HFP 40
  #define DEMO_HBP 40
  #define DEMO_VSW 3
  #define DEMO_VFP 141
  #define DEMO_VBP 29

#elif (MIPI_PANEL_NHD50800480TFATXL == USE_MIPI_PANEL)

  #define DEMO_PANEL_WIDTH  (800)
  #define DEMO_PANEL_HEIGHT (480)
  #define DEMO_PANEL_NAME   "NHD50800480TFATXL"

  #define DEMO_HSW 48
  #define DEMO_HFP 40
  #define DEMO_HBP 40
  #define DEMO_VSW 3
  #define DEMO_VFP 141
  #define DEMO_VBP 29

#elif (MIPI_PANEL_HDMI_720X480_60 == USE_MIPI_PANEL)

  #define DEMO_PANEL_WIDTH  (720)
  #define DEMO_PANEL_HEIGHT (480)
  #define DEMO_PANEL_NAME   "HDMI_720X480_60"

  #define DEMO_HSW 62
  #define DEMO_HBP 60
  #define DEMO_HFP 16
  #define DEMO_VSW 6
  #define DEMO_VBP 30
  #define DEMO_VFP 9

  #define DEMO_VIDEO_FREQ_KHZ    594000
  #define DEMO_PIXEL_CLOCK_DIV   22
  #define DEMO_MIPI_DPY_REF_DIV  22

#elif (MIPI_PANEL_HDMI_720X576_50 == USE_MIPI_PANEL)

  #define DEMO_PANEL_WIDTH  (720)
  #define DEMO_PANEL_HEIGHT (576)
  #define DEMO_PANEL_NAME   "HDMI_720X576_50"

  #define DEMO_HSW 64
  #define DEMO_HBP 68
  #define DEMO_HFP 12
  #define DEMO_VSW 5
  #define DEMO_VBP 39
  #define DEMO_VFP 5

  #define DEMO_VIDEO_FREQ_KHZ    594000
  #define DEMO_PIXEL_CLOCK_DIV   22
  #define DEMO_MIPI_DPY_REF_DIV  22

#elif (MIPI_PANEL_HDMI_800X480_60 == USE_MIPI_PANEL)

  #define DEMO_PANEL_WIDTH  (800)
  #define DEMO_PANEL_HEIGHT (480)
  #define DEMO_PANEL_NAME   "HDMI_800X480_60"

  #define DEMO_HSW 20
  #define DEMO_HFP 70
  #define DEMO_HBP 26
  #define DEMO_VSW 2
  #define DEMO_VFP 7
  #define DEMO_VBP 21

  #define DEMO_VIDEO_FREQ_KHZ    594000
  #define DEMO_PIXEL_CLOCK_DIV   22
  #define DEMO_MIPI_DPY_REF_DIV  22

#elif (MIPI_PANEL_HDMI_1024X600_76 == USE_MIPI_PANEL)

  #define DEMO_PANEL_WIDTH  (1024)
  #define DEMO_PANEL_HEIGHT (600)
  #define DEMO_PANEL_NAME   "HDMI_1024X600_76"

  #define DEMO_HSW 136
  #define DEMO_HBP 160
  #define DEMO_HFP 24
  #define DEMO_VSW 6
  #define DEMO_VBP 29
  #define DEMO_VFP 3

  #define DEMO_VIDEO_FREQ_KHZ    260000
  #define DEMO_PIXEL_CLOCK_DIV   4
  #define DEMO_MIPI_DPY_REF_DIV  10

#elif (MIPI_PANEL_HDMI_1024X768_60 == USE_MIPI_PANEL)

  #define DEMO_PANEL_WIDTH  (1024)
  #define DEMO_PANEL_HEIGHT (768)
  #define DEMO_PANEL_NAME   "HDMI_1024X768_60"

  #define DEMO_HSW 136
  #define DEMO_HBP 160
  #define DEMO_HFP 24
  #define DEMO_VSW 6
  #define DEMO_VBP 29
  #define DEMO_VFP 3

  #define DEMO_VIDEO_FREQ_KHZ    260000
  #define DEMO_PIXEL_CLOCK_DIV   4
  #define DEMO_MIPI_DPY_REF_DIV  10

#elif (MIPI_PANEL_HDMI_1280X720_60 == USE_MIPI_PANEL)

  #define DEMO_PANEL_WIDTH  (1280)
  #define DEMO_PANEL_HEIGHT (720)
  #define DEMO_PANEL_NAME   "HDMI_1280X720_60"

  #define DEMO_HSW 40
  #define DEMO_HBP 220
  #define DEMO_HFP 110
  #define DEMO_VSW 5
  #define DEMO_VBP 20
  #define DEMO_VFP 5

  #define DEMO_VIDEO_FREQ_KHZ    594000
  #define DEMO_PIXEL_CLOCK_DIV   8
  #define DEMO_MIPI_DPY_REF_DIV  22

#elif (MIPI_PANEL_HDMI_1920X1080_30 == USE_MIPI_PANEL)

  #define DEMO_PANEL_WIDTH  (1920)
  #define DEMO_PANEL_HEIGHT (1080)
  #define DEMO_PANEL_NAME   "HDMI_1920X1080_30"

  #define DEMO_HSW 44
  #define DEMO_HBP 148
  #define DEMO_HFP 88
  #define DEMO_VSW 5
  #define DEMO_VBP 36
  #define DEMO_VFP 4

  #define DEMO_VIDEO_FREQ_KHZ    594000
  #define DEMO_PIXEL_CLOCK_DIV   8
  #define DEMO_MIPI_DPY_REF_DIV  22

#else
  #error Must set USE_MIPI_PANEL to one of the valid MIPI_PANEL_* values
#endif

#define IS_HDMI_PANEL()         (USE_MIPI_PANEL >= 10)
#define USE_FT5406_TOUCH()      ((MIPI_PANEL_RK043FN02HC == USE_MIPI_PANEL) || (MIPI_PANEL_NHD50800480TFATXL == USE_MIPI_PANEL))
#define USE_GT911_TOUCH()       ((MIPI_PANEL_RK055AHD091 == USE_MIPI_PANEL) || (MIPI_PANEL_RK055IQH091 == USE_MIPI_PANEL) || (MIPI_PANEL_RK055MHD091 == USE_MIPI_PANEL))
#define IS_TOUCH_SUPPORTED()    (USE_FT5406_TOUCH() || USE_GT911_TOUCH())
#define IS_PARALLEL_RGB_PANEL() ((MIPI_PANEL_RK043FN02HC == USE_MIPI_PANEL) || (MIPI_PANEL_KD050WVTPA045 == USE_MIPI_PANEL) || (MIPI_PANEL_NHD50800480TFATXL == USE_MIPI_PANEL))


#if (MIPI_PANEL_RK043FN02HC == USE_MIPI_PANEL)
  #define DEMO_POL_FLAGS                                                                   \
      (kLCDIFV2_DataEnableActiveHigh | kLCDIFV2_VsyncActiveLow | kLCDIFV2_HsyncActiveLow | \
       kLCDIFV2_DriveDataOnRisingClkEdge)
#else
  #define DEMO_POL_FLAGS                                                                   \
      (kLCDIFV2_DataEnableActiveHigh | kLCDIFV2_VsyncActiveLow | kLCDIFV2_HsyncActiveLow | \
       kLCDIFV2_DriveDataOnFallingClkEdge)
#endif

/* Frame buffer must be 8 byte aligned. */
#define DEMO_FB_ALIGN              8
#define DEMO_BUFFER_COUNT          3
#define DEMO_BUFFER_BYTE_PER_PIXEL 2

extern const MIPI_DSI_Type g_mipiDsi;

#define DEMO_FB0_ADDR ((uint32_t)s_frameBuffer[0])
#define DEMO_FB1_ADDR ((uint32_t)s_frameBuffer[1])
#define DEMO_FB2_ADDR ((uint32_t)s_frameBuffer[2])



extern uint8_t s_frameBuffer[DEMO_BUFFER_COUNT][DEMO_PANEL_HEIGHT][DEMO_PANEL_WIDTH][DEMO_BUFFER_BYTE_PER_PIXEL];

/*******************************************************************************
 * Prototypes
 ******************************************************************************/
#if defined(__cplusplus)
extern "C" {
#endif /* __cplusplus */

status_t BOARD_InitDisplayInterface(void);
void BOARD_InitLcdifClock(void);

#if defined(__cplusplus)
}
#endif /* __cplusplus */

#endif /* _LCDIFV2_SUPPORT_H_ */
