
This SDK has been patched by Embedded Artists for the iMXRT1166 Developer's Kit.
The SDK was released on 2024-04-16 and is based on NXP's 2.15.0 SDK (SDK_2_15_000_MIMXRT1166xxxxx.zip).

This is what has been patched:
* LWIP projects - added reading of the MAC address from I2C EEPROM either on the 100Mbit adapter
  or on the uCOM board
* Added an I2C driver for the gpio expander (PCA6416) and code to use it
* Added an I2C driver for the PWM gpio expander (PCA9530) and code to use it
* SDRAM size has been corrected to 32Mb (including linker files, MPU and DCD)
* The RTL8211F Ethernet PHY driver has been extended to also work with the AR8031DS PHY.
  The difference between the PHYs are minimal and extending the driver and letting the
  PHY ID decide which instructions to use makes switching PHYs seamless.
* SEMC projects - changed to correct settings for the SDRAM
* SEMC projects - changed algorithm for memory test and now test entire 32MB instead of only 4KB
* Examples using eLCDIF/LCDIFv2 have been updated to use PCA6416/PCA9530 for
  RST/PWR/BL signals
* BOARD_USER_BUTTON has been redirected to SW5/WAKEUP button on the uCOM Carrier Board
* USER_LED has been changed to the blue RGB LED using PCA6416
* Touch: I2C bus and GPIOs have been changed for RST/INT
* Camera pins
* Adjusted the USB interface number (it is different for host and device examples)
* Changed the Wi-Fi examples to use the Embedded Artists 1XK M.2 Module (EAR00385) as default
* Corrected the ethernet PHY addresses
* Changed CORE clock depending on speed grading of MCU (528MHz for Industrial, 600MHz for Commercial)
* Changed SEMC clock to be within maximum speed for SDRAM (now 148.5MHz, was 198MHz)
* Many of the projects have been updated to use a more complete pin_mux.c file where all
  necessary pins have been initialized. The SDK examples used to only configure the pins
  that they use (and often not every pin) and most of the time the configuration was only
  for MUX:ing and not the PAD settings (pull up/down/none, drive strength and slew).
* Converted the AzureRTOS examples to use the BOARD_NETWORK_USE_100M_ENET_PORT (same as all
  other networking examples) instead of using the old EXAMPLE_USE_1G_ENET_PORT


This has been added:
* HDMI support to most GUI examples. The default is the 4.3" Parallel RGB
  display as it is a part of the iMXRT1166 Developer's Kit. The switch to HDMI
  can be made per project in display_support.h/elcdif_support.h/lcdifv2_support.h.
* I2C probe example
* EDID reader example

Important things to note:
* Read section "8 - Known Issues" in docs/MCUXpresso SDK Release Notes for MIMXRT1160-EVK.pdf
  to see known issues with the current version of the SDK.
* For Iperf examples, set compiler optimization to -O3 or similar to improve performance.
* If the hardware seems unresponsive and the debugger cannot connect/flash/erase the current program
  then the most likely cause is the running program preventing the access. To stop the currently
  running program and regain control:
  1) Press and hold down the ISP_ENABLE button (SW1)
  2) Press and hold down the RESET button (SW3)
  3) Let go of the RESET button
  4) Wait an extra second or two
  5) Release the ISP_ENABLE button
  6) The hardware is now in a mode where programming/erasing it should work
* GUI applications using Parallel RGB display and the LCDIFv2 interface require
  a carrier board supporting the 24 bit mapping (like the uCOM Carrier Board rev B and later).
  If you don't have that then switch the interface to eLCDIF in the project's
  display_support.h/elcdif_support.h/lcdifv2_support.h file.

Connectors:
* J29 (micro USB) is the default UART for the CM7 core and unless specified otherwise it is setup for 115200 8/N/1
* J30 (micro USB) is the default UART for the CM4 core and unless specified otherwise it is setup for 115200 8/N/1
* For 1Gbit Ethernet examples, use connector J25 on uCOM Carrier Board
* For 100Mbit Ethernet examples, use ethernet adapter connected between Connector "D" on
  uCOM Carrier Board and J37 on the adapter. These four connections are also needed:
    1) uCOM Carrier Board, JP38:1 -> adapter JP37:1
    2) uCOM Carrier Board, JP38:2 -> adapter JP37:2
    3) uCOM Carrier Board, JP27:1 -> adapter JP39:2
    4) uCOM Carrier Board, JP27:2 -> adapter JP39:1
* The two CSI examples can use either an OV5640 camera in connector J23 or a camera in connector J24
* The EIQ examples that use a camera expects the camera in connector J24 (J23 might work for some
  of the examples but runs much slower)
* Some GUI examples are configured for the RK055AHD091 display which should be in connector "C" on
  the uCOM Carrier Board. Ignore the readme text about connecting extra 5V power.
* The default for GUI examples is to use an HDMI adapter in connector "C" on
  the uCOM Carrier Board. Ignore the readme text about connecting extra 5V power.


Everything below this line is the original content of the readme file.
=======================================================================



Overview
========
Convolutional neural network (CNN) example with the use of
convolution, ReLU activation, pooling and fully-connected functions.

The CNN model in the example was trained using the scripts available at [1]
with the CifarNet model. 
The configuration of the model was modified to match the neural 
network structure in the CMSIS-NN CIFAR-10 example.
The example source code is a modified version of the Label Image
example from the TensorFlow Lite examples [2], adjusted to run on MCUs.
The neural network consists of 3 convolution layers interspersed by
ReLU activation and max pooling layers, followed by a fully-connected layer
at the end. The input to the network is a 32x32 pixel color image, which is 
classified into one of the 10 output classes. The model size is 91 KB.

Firstly a static ship image is used as input regardless camera is connected or not.
Secondly runtime image processing from camera in the case camera and display
is connected. Camera data are displayed on LCD. 

HOW TO USE THE APPLICATION:
To classify an image, place an image in front of the camera so that it fits in the
white rectangle in the middle of the LCD display. 
Note that semihosting implementation causes slower or discontinuous video experience. 
Select UART in 'Project Options' during project import for using external debug console 
via UART (virtual COM port).

[1] https://github.com/tensorflow/models/tree/master/research/slim
[2] https://github.com/tensorflow/tensorflow/tree/r2.3/tensorflow/lite/examples/label_image

Files:
  main.cpp - example main function
  ship.bmp - shrinked picture of the object to recognize
    (source: https://en.wikipedia.org/wiki/File:Christian_Radich_aft_foto_Ulrich_Grun.jpg)
  image_data.h - image file converted to a C language array of RGB values
    using Python with the OpenCV and Numpy packages:
    import cv2
    import numpy as np
    img = cv2.imread('ship.bmp')
    img = cv2.cvtColor(img, cv2.COLOR_BGR2RGB)
    with open('image_data.h', 'w') as fout:
      print('#define STATIC_IMAGE_NAME "ship"', file=fout)
      print('static const uint8_t image_data[] = {', file=fout)
      img.tofile(fout, ', ', '0x%02X')
      print('};\n', file=fout)
  timer.c - timer source code
  image/* - image capture and pre-processing code
  model/get_top_n.cpp - top results retrieval
  model/model_data.h - model data converted from a .tflite file to a C language
    array using the xxd tool (distributed with the Vim editor at www.vim.org)
  model/model.cpp - model initialization and inference code
  model/model_cifarnet_ops.cpp - model operations registration
  model/output_postproc.cpp - model output processing
  video/* - camera and display handling


SDK version
===========
- Version: 2.15.000

Toolchain supported
===================
- IAR embedded Workbench  9.40.1
- Keil MDK  5.38.1
- GCC ARM Embedded  12.2
- MCUXpresso  11.8.0

Hardware requirements
=====================
- Mini/micro USB cable
- EVK-MIMXRT1160 board
- Personal computer
- RK055AHD091 or RK055MHD091 display (optional)
- OV5640 camera (optional)

Board settings
==============
Connect the display to J48 (optional)
Connect the camera to J2 (optional)
Connect external 5V power to J43, set J38 to 1-2

Prepare the Demo
================
1. Connect a USB cable between the host PC and the OpenSDA USB port on the target board. 
2. Open a serial terminal with the following settings:
   - 115200 baud rate
   - 8 data bits
   - No parity
   - One stop bit
   - No flow control
3. Build the project. (The project expects the RK055MHD091 panel by default. To use the RK055AHD091 panel,
    change #define DEMO_PANEL DEMO_PANEL_RK055MHD091 to #define DEMO_PANEL MIPI_PANEL_RK055AHD091
    in eiq_display_conf.h.)
4. Download the program to the target board.
5. Either press the reset button on your board or launch the debugger in your IDE to begin running the demo.

Running the demo
================
The log below shows the output of the demo in the terminal window (compiled with ARM GCC):

CIFAR-10 object recognition example using a TensorFlow Lite model.
Detection threshold: 60%
Expected category: ship
Model: cifarnet_quant

Static data processing:
----------------------------------------
     Inference time: 65 ms
     Detected:       ship (100%)
----------------------------------------


Camera data processing:
Data for inference are ready
----------------------------------------
     Inference time: 64 ms
     Detected:        dog (95%)
----------------------------------------

Data for inference are ready
----------------------------------------
     Inference time: 65 ms
     Detected: No label detected (0%)
----------------------------------------

Data for inference are ready
----------------------------------------
     Inference time: 64 ms
     Detected:      horse (60%)
----------------------------------------
