
This SDK has been patched by Embedded Artists for the iMXRT1166 Developer's Kit.
The SDK was released on 2024-04-16 and is based on NXP's 2.15.0 SDK (SDK_2_15_000_MIMXRT1166xxxxx.zip).

This is what has been patched:
* LWIP projects - added reading of the MAC address from I2C EEPROM either on the 100Mbit adapter
  or on the uCOM board
* Added an I2C driver for the gpio expander (PCA6416) and code to use it
* Added an I2C driver for the PWM gpio expander (PCA9530) and code to use it
* SDRAM size has been corrected to 32Mb (including linker files, MPU and DCD)
* The RTL8211F Ethernet PHY driver has been extended to also work with the AR8031DS PHY.
  The difference between the PHYs are minimal and extending the driver and letting the
  PHY ID decide which instructions to use makes switching PHYs seamless.
* SEMC projects - changed to correct settings for the SDRAM
* SEMC projects - changed algorithm for memory test and now test entire 32MB instead of only 4KB
* Examples using eLCDIF/LCDIFv2 have been updated to use PCA6416/PCA9530 for
  RST/PWR/BL signals
* BOARD_USER_BUTTON has been redirected to SW5/WAKEUP button on the uCOM Carrier Board
* USER_LED has been changed to the blue RGB LED using PCA6416
* Touch: I2C bus and GPIOs have been changed for RST/INT
* Camera pins
* Adjusted the USB interface number (it is different for host and device examples)
* Changed the Wi-Fi examples to use the Embedded Artists 1XK M.2 Module (EAR00385) as default
* Corrected the ethernet PHY addresses
* Changed CORE clock depending on speed grading of MCU (528MHz for Industrial, 600MHz for Commercial)
* Changed SEMC clock to be within maximum speed for SDRAM (now 148.5MHz, was 198MHz)
* Many of the projects have been updated to use a more complete pin_mux.c file where all
  necessary pins have been initialized. The SDK examples used to only configure the pins
  that they use (and often not every pin) and most of the time the configuration was only
  for MUX:ing and not the PAD settings (pull up/down/none, drive strength and slew).
* Converted the AzureRTOS examples to use the BOARD_NETWORK_USE_100M_ENET_PORT (same as all
  other networking examples) instead of using the old EXAMPLE_USE_1G_ENET_PORT


This has been added:
* HDMI support to most GUI examples. The default is the 4.3" Parallel RGB
  display as it is a part of the iMXRT1166 Developer's Kit. The switch to HDMI
  can be made per project in display_support.h/elcdif_support.h/lcdifv2_support.h.
* I2C probe example
* EDID reader example

Important things to note:
* Read section "8 - Known Issues" in docs/MCUXpresso SDK Release Notes for MIMXRT1160-EVK.pdf
  to see known issues with the current version of the SDK.
* For Iperf examples, set compiler optimization to -O3 or similar to improve performance.
* If the hardware seems unresponsive and the debugger cannot connect/flash/erase the current program
  then the most likely cause is the running program preventing the access. To stop the currently
  running program and regain control:
  1) Press and hold down the ISP_ENABLE button (SW1)
  2) Press and hold down the RESET button (SW3)
  3) Let go of the RESET button
  4) Wait an extra second or two
  5) Release the ISP_ENABLE button
  6) The hardware is now in a mode where programming/erasing it should work
* GUI applications using Parallel RGB display and the LCDIFv2 interface require
  a carrier board supporting the 24 bit mapping (like the uCOM Carrier Board rev B and later).
  If you don't have that then switch the interface to eLCDIF in the project's
  display_support.h/elcdif_support.h/lcdifv2_support.h file.

Connectors:
* J29 (micro USB) is the default UART for the CM7 core and unless specified otherwise it is setup for 115200 8/N/1
* J30 (micro USB) is the default UART for the CM4 core and unless specified otherwise it is setup for 115200 8/N/1
* For 1Gbit Ethernet examples, use connector J25 on uCOM Carrier Board
* For 100Mbit Ethernet examples, use ethernet adapter connected between Connector "D" on
  uCOM Carrier Board and J37 on the adapter. These four connections are also needed:
    1) uCOM Carrier Board, JP38:1 -> adapter JP37:1
    2) uCOM Carrier Board, JP38:2 -> adapter JP37:2
    3) uCOM Carrier Board, JP27:1 -> adapter JP39:2
    4) uCOM Carrier Board, JP27:2 -> adapter JP39:1
* The two CSI examples can use either an OV5640 camera in connector J23 or a camera in connector J24
* The EIQ examples that use a camera expects the camera in connector J24 (J23 might work for some
  of the examples but runs much slower)
* Some GUI examples are configured for the RK055AHD091 display which should be in connector "C" on
  the uCOM Carrier Board. Ignore the readme text about connecting extra 5V power.
* The default for GUI examples is to use an HDMI adapter in connector "C" on
  the uCOM Carrier Board. Ignore the readme text about connecting extra 5V power.


The iMXRT1166 Developer's kit supports two different wired network options:

Option1: uses the 1Gbit Ethernet PHY on the iMX RT1166 uCOM board and the
         connector on the uCOM Carrier Board. Examples that support this option
         has a '#include "fsl_phyrtl8211f.h"' line in the main .c file
Option2: (default) uses the 100/10Mbit Ethernet-PHY Adapter board. Examples that
         support this option has a '#include "fsl_phyksz8081.h"' line in the
         main .c file

Note: The current version of the iMXRT1166 uCOM board has an onboard Wi-Fi
      so Option1 above is not available. The only wired network option is
      Option2

For examples that support both options, select which option to use by changing
this define in board.h:

#define BOARD_NETWORK_USE_100M_ENET_PORT (1U)

Some of the network examples have been modified to obtain the globally unique
MAC address from an EEPROM either on the 100/10Mbit Ethernet-PHY Adapter board
(if the 100Mbit interface is selected) or on the iMX RT1166 uCOM board (if the
1Gbit interface is selected).


Everything below this line is the original content of the readme file.
=======================================================================



Overview
========

The lwip_httpsrv_freertos demo application demonstrates an HTTP server on the lwIP TCP/IP stack with FreeRTOS.
The user uses an internet browser to send a request for connection. The board acts as an HTTP server and sends a web
page back to the PC.

The example supports both IPv4 and IPv6 protocols. But some combinations of boards or build configurations may have
only IPv4 enabled due to memory constraints. If it fits into memory, it is possible for the example to be compiled
with both IPv4 and IPv6 (LWIP_IPV4=1 and LWIP_IPV6=1 in lwipopts.h), IPv4 only (LWIP_IPV4=1 and LWIP_IPV6=0
in lwipopts.h) or IPv6 only (LWIP_IPV4=0 and LWIP_IPV6=1 in lwipopts.h).
If IPv6 is enabled, the board will assign a link-local IPv6 address to its interface, but this is often not enough
as web browsers tend to not support link-local address with zone index in URL (e.g. http://[FE80::5627:8DFF:FE46:29F8%eth0]).
So if the board is connected directly to the host PC, the PC should be configured to send ICMPv6 Router Advertisement
messages with Prefix option, which the board could use to assign itself a routable address using the Stateless Address
Autoconfiguration mechanism. If the board and the host PC are connected through a router, sending of Router Advertisement
messages could be configured on that router (if it supports IPv6).
Instructions how to set the IPv6 network correctly can be different on each system and it is out of scope of this readme.
It can take a couple of seconds until the addresses are validated and assigned to the board's ethernet interface,
so the board will print "IPv6 address update" messages followed by all valid IPv6 addresses anytime there is a change.
The assigned unique local or global unique addresses could be typed into the web browser's address bar in a form like
"http://[FD00:AABB:CCDD:EEFF:5627:8DFF:FE46:29F8]" to access the web server over IPv6.


SDK version
===========
- Version: 2.15.000

Toolchain supported
===================
- IAR embedded Workbench  9.40.1
- Keil MDK  5.38.1
- GCC ARM Embedded  12.2
- MCUXpresso  11.8.0

Hardware requirements
=====================
- Mini/micro USB cable
- Network cable RJ45 standard
- MIMXRT1160-EVK board
- Personal Computer

Board settings
==============
This example uses 1G port(J4) as default. If want to test 100M port(J3), please set the macro BOARD_NETWORK_USE_100M_ENET_PORT to 1.

Prepare the Demo
================
1.  Connect a USB cable between the PC host and the OpenSDA(or USB to Serial) USB port on the target board.
2.  Open a serial terminal on PC for OpenSDA serial(or USB to Serial) device with these settings:
    - 115200 baud rate
    - 8 data bits
    - No parity
    - One stop bit
    - No flow control
3.  Insert the Ethernet Cable into the target board's RJ45 port and connect it to your PC network adapter.
4.  Configure the host PC IP address to 192.168.0.100.
5.  Configure the host PC to advertise IPv6 address prefix.
6.  Open a web browser.
7.  Download the program to the target board.
8.  Either press the reset button on your board or launch the debugger in your IDE to begin running the demo.

Running the demo
================
1.  When the demo runs successfully, the terminal will display the following:
        Initializing PHY...

        ***********************************************************
         HTTP Server example
        ***********************************************************
         IPv4 Address     : 192.168.0.102
         IPv4 Subnet mask : 255.255.255.0
         IPv4 Gateway     : 192.168.0.100
         IPv6 Address0    : -
         IPv6 Address1    : -
         IPv6 Address2    : -
         mDNS hostname    : lwip-http
        ***********************************************************
        IPv6 address update, valid addresses:
         IPv6 Address0    : FE80::5627:8DFF:FE46:29F8
         IPv6 Address1    : -
         IPv6 Address2    : -

        IPv6 address update, valid addresses:
         IPv6 Address0    : FE80::5627:8DFF:FE46:29F8
         IPv6 Address1    : FD00:AABB:CCDD:EEFF:5627:8DFF:FE46:29F8
         IPv6 Address2    : -

2.  If the example has been compiled with IPv4 enabled (LWIP_IPV4=1), type 192.168.0.102 (IP address of the board) into the browser address bar.
	The browser should show a web page. The board also advertises itself using mDNS so that it can be accessed using URL http://lwip-http.local.
	Please note that your system may not support mDNS out-of-the-box as it is necessary to have an mDNS resolver installed.
    For instance Bonjour Print Services for Windows contain such resolver. In case of Linux nss-mdns serves this purpose.
    Username admin and password admin is required to access "Authorization example" section of the web page.

3.  If the example has been compiled with IPv6 enabled (LWIP_IPV6=1), wait for the unique local or global unique IPv6 address to appear
    in the list of valid addresses in the console output. Then the server could be reached over IPv6.
    For the example output above, http://[FD00:AABB:CCDD:EEFF:5627:8DFF:FE46:29F8] could be typed into the browser's address bar to make it
    show the web page and communicate with the board over IPv6.

4.  If the example has been compiled with IPv6 only and no IPv4 (LWIP_IPV6=1 and LWIP_IPV4=0), the board will still have the mDNS responder
    enabled. But some web browsers seem to send mDNS queries for IPv4 address only, so it might not be possible to access the board using
    http://lwip-http.local URL. Still, some utilities (like avahi-resolve on Linux) could be used to resolve the name to IPv6 address using mDNS.

Modifying content of static web pages
To modify content available through the web server you must complete following steps:
  1. Modify, add or delete files in folder "boards\<board_name>\lwip_examples\lwip_httpsrv_freertos\webpage".
  2. Run the script file "middleware\lwip\src\apps\httpsrv\mkfs\mkfs.pl <directory name>" to generate new "httpsrv_fs_data.c".
     Make sure to execute it from a folder where the file "httpsrv_fs_data.c" is. For example:
        C:\sdk\boards\<board_name>\lwip_examples\lwip_httpsrv_freertos> C:\sdk\middleware\lwip\src\apps\httpsrv\mkfs\mkfs.pl webpage
		Processing file webpage/auth.html
		Processing file webpage/cgi.html
		Processing file webpage/favicon.ico
		Processing file webpage/help.html
		Processing file webpage/httpsrv.css
		Processing file webpage/index.html
		Processing file webpage/NXP_logo.png
		Processing file webpage/poll.html
		Processing file webpage/request.js
		Processing file webpage/ssi.shtml
		Processing file webpage/welcome.html
		Done.
  3. Make sure the "httpsrv_fs_data.c" file has been overwritten with the newly generated content.
  4. Re-compile the HTTP server application example and download it to your board.
