#ifndef _MAC_ADDR_H_
#define _MAC_ADDR_H_


/*!
 * @addtogroup mac_addr
 * @{
 */

/*******************************************************************************
 * API
 ******************************************************************************/

/*!
 * @brief 7-bit I2C address of the E2PROM on the 100/10Mbps Ethernet-PHY Adapter
 */
#define MAC_E2PROM_I2C_7BIT_ADDR_ADAPTER 0x52

/*!
 * @brief 7-bit I2C address of the E2PROM on the iMX RT1166 uCOM Board
 */
#define MAC_E2PROM_I2C_7BIT_ADDR_ONBOARD 0x53

#if defined(__cplusplus)
extern "C" {
#endif

/*!
 * @brief Reads MAC from first found E2PROM (adapter if possible otherwise onboard)
 *
 * @param addr   Six bytes to store the MAC address in
 */
void MAC_ReadEither(uint8_t* addr);

/*!
 * @brief Attempts to read the MAC address from an E2PROM
 *
 * @param i2caddr  7-bit i2c address of the E2PROM with EUI-48
 * @param addr     Six bytes to store the MAC address in
 */
void MAC_Read(uint8_t i2c_addr, uint8_t* addr);

#if defined(__cplusplus)
}
#endif

/*!
 * @}
 */
#endif /* _MAC_ADDR_H_ */

/*******************************************************************************
 * EOF
 ******************************************************************************/
