/****************************************************************************
*
*   The MIT License (MIT)
*
*   Copyright 2014 Vivante Corporation
*   All Rights Reserved.
*
*   Permission is hereby granted, free of charge, to any person obtaining a copy
*   of this software and associated documentation files (the "Software"), to
*   deal in the Software without restriction, including without limitation the
*   rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
*   sell copies of the Software, and to permit persons to whom the Software is
*   furnished to do so, subject to the following conditions:
*
*   The above copyright notice and this permission notice shall be included in
*   all copies or substantial portions of the Software.
*
*   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
*   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
*   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
*   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
*   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
*   FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
*   IN THE SOFTWARE.
*
*****************************************************************************/

/*	Created by sw-builder on 6/25/14.
 *
 *	Optimization (on 02/07/20): Paths having the same colour were
 *	concatenated. This is needed to increase the performance in terms of
 *	FPS. The number of paths to be tessellated is reduced from 236 to 131.
 */

#ifndef __TIGER_PATHS_H__
#define __TIGER_PATHS_H__

#include "vg_lite.h"

#define _S8 (signed char)

/* path_data0 ===========================================*/
signed char path_data0[] = {
	2, _S8 -30.576000, _S8 21.071251,
	8, _S8 -30.576000, _S8 21.071251, _S8 -30.550751, _S8 21.544750, _S8 -30.756750, _S8 21.540001,
	8, _S8 -30.962749, _S8 21.535250, _S8 -35.076248, _S8 9.516500, _S8 -40.208248, _S8 10.077250,
	8, _S8 -40.208248, _S8 10.077250, _S8 -35.762501, _S8 8.239000, _S8 -30.576000, _S8 21.071251,
/* path_data1 ===========================================*/
	2, _S8 -29.693501, _S8 20.315500,
	8, _S8 -29.693501, _S8 20.315500, _S8 -29.830750, _S8 20.769501, _S8 -30.023001, _S8 20.694750,
	8, _S8 -30.215000, _S8 20.620251, _S8 -29.994249, _S8 7.918750, _S8 -35.010750, _S8 6.700250,
	8, _S8 -35.010750, _S8 6.700250, _S8 -30.205000, _S8 6.484250, _S8 -29.693501, _S8 20.315500,
/* path_data2 ===========================================*/
	2, _S8 -22.820999, _S8 30.897499,
	8, _S8 -22.820999, _S8 30.897499, _S8 -22.412001, _S8 31.137501, _S8 -22.529499, _S8 31.306749,
	8, _S8 -22.647249, _S8 31.476000, _S8 -34.940750, _S8 28.275499, _S8 -37.304501, _S8 32.864750,
	8, _S8 -37.304501, _S8 32.864750, _S8 -36.384750, _S8 28.143000, _S8 -22.820999, _S8 30.897499,
/* path_data3 ===========================================*/
	2, _S8 -23.523251, _S8 33.450249,
	8, _S8 -23.523251, _S8 33.450249, _S8 -23.059250, _S8 33.549252, _S8 -23.117750, _S8 33.747002,
	8, _S8 -23.176001, _S8 33.944752, _S8 -35.851749, _S8 34.780251, _S8 -36.649250, _S8 39.880501,
	8, _S8 -36.649250, _S8 39.880501, _S8 -37.263748, _S8 35.109249, _S8 -23.523251, _S8 33.450249,
/* path_data4 ===========================================*/
	2, _S8 -24.576000, _S8 32.069000,
	8, _S8 -24.576000, _S8 32.069000, _S8 -24.131500, _S8 32.234749, _S8 -24.218000, _S8 32.421749,
	8, _S8 -24.304501, _S8 32.608749, _S8 -36.966499, _S8 31.586500, _S8 -38.499500, _S8 36.515999,
	8, _S8 -38.499500, _S8 36.515999, _S8 -38.411499, _S8 31.706249, _S8 -24.576000, _S8 32.069000,
/* path_data5 ===========================================*/
	2, _S8 -27.252251, _S8 27.518000,
	8, _S8 -27.252251, _S8 27.518000, _S8 -26.925249, _S8 27.861500, _S8 -27.084999, _S8 27.991751,
	8, _S8 -27.244749, _S8 28.122000, _S8 -38.180500, _S8 21.658501, _S8 -41.717251, _S8 25.419001,
	8, _S8 -41.717251, _S8 25.419001, _S8 -39.532001, _S8 21.133249, _S8 -27.252251, _S8 27.518000,
/* path_data6 ===========================================*/
	2, _S8 -29.138500, _S8 28.565750,
	8, _S8 -29.138500, _S8 28.565750, _S8 -28.774500, _S8 28.870001, _S8 -28.918501, _S8 29.017750,
	8, _S8 -29.062500, _S8 29.165251, _S8 -40.659500, _S8 23.980499, _S8 -43.748001, _S8 28.117250,
	8, _S8 -43.748001, _S8 28.117250, _S8 -42.061749, _S8 23.611750, _S8 -29.138500, _S8 28.565750,
/* path_data7 ===========================================*/
	2, _S8 -29.788500, _S8 29.583750,
	8, _S8 -29.788500, _S8 29.583750, _S8 -29.386499, _S8 29.835751, _S8 -29.509001, _S8 30.001499,
	8, _S8 -29.631500, _S8 30.167250, _S8 -41.827000, _S8 26.611500, _S8 -44.322750, _S8 31.130501,
	8, _S8 -44.322750, _S8 31.130501, _S8 -43.266499, _S8 26.437250, _S8 -29.788500, _S8 29.583750,
	0
};

/* path_data8 ===========================================*/
signed char path_data8[] = {
	2, _S8 -27.105000, _S8 29.737249,
	8, _S8 -27.105000, _S8 29.737249, _S8 -26.824499, _S8 30.120001, _S8 -26.999750, _S8 30.228750,
	8, _S8 -27.174999, _S8 30.337500, _S8 -37.192249, _S8 22.525499, _S8 -41.181751, _S8 25.801750,
	8, _S8 -41.181751, _S8 25.801750, _S8 -38.465500, _S8 21.831499, _S8 -27.105000, _S8 29.737249,
/* path_data9 ===========================================*/
	2, _S8 -32.049999, _S8 22.500000,
	8, _S8 -32.049999, _S8 22.500000, _S8 -31.900000, _S8 22.950001, _S8 -32.099998, _S8 23.000000,
	8, _S8 -32.299999, _S8 23.049999, _S8 -39.450001, _S8 12.550000, _S8 -44.250252, _S8 14.450000,
	8, _S8 -44.250252, _S8 14.450000, _S8 -40.450001, _S8 11.500000, _S8 -32.049999, _S8 22.500000,
/* path_data10 ===========================================*/
	2, _S8 -31.876249, _S8 24.244749,
	8, _S8 -31.876249, _S8 24.244749, _S8 -31.632500, _S8 24.652000, _S8 -31.817249, _S8 24.743750,
	8, _S8 -32.001751, _S8 24.835751, _S8 -41.248001, _S8 16.124750, _S8 -45.525249, _S8 19.015249,
	8, _S8 -45.525249, _S8 19.015249, _S8 -42.451000, _S8 15.315250, _S8 -31.876249, _S8 24.244749,
/* path_data11 ===========================================*/
	2, _S8 -31.905001, _S8 25.337250,
	8, _S8 -31.905001, _S8 25.337250, _S8 -31.624500, _S8 25.719999, _S8 -31.799749, _S8 25.828751,
	8, _S8 -31.975000, _S8 25.937250, _S8 -41.992249, _S8 18.125500, _S8 -45.981750, _S8 21.401751,
	8, _S8 -45.981750, _S8 21.401751, _S8 -43.265499, _S8 17.431499, _S8 -31.905001, _S8 25.337250,
	0
};

/* path_data12 ===========================================*/
signed char path_data12[] = {
	2, _S8 -32.457500, _S8 25.766251,
	8, _S8 -32.331749, _S8 27.278250, _S8 -32.084751, _S8 28.920500, _S8 -31.650000, _S8 29.700251,
	8, _S8 -31.650000, _S8 29.700251, _S8 -32.549999, _S8 32.800251, _S8 -30.350000, _S8 36.100250,
	8, _S8 -30.350000, _S8 36.100250, _S8 -30.450001, _S8 37.900249, _S8 -30.049999, _S8 38.700249,
	8, _S8 -30.049999, _S8 38.700249, _S8 -29.049999, _S8 40.800251, _S8 -27.850000, _S8 41.000252,
	8, _S8 -26.879000, _S8 41.161999, _S8 -24.698250, _S8 41.929249, _S8 -22.233000, _S8 42.280251,
	8, _S8 -22.233000, _S8 42.280251, _S8 -17.950001, _S8 45.800251, _S8 -18.750000, _S8 49.000252,
	8, _S8 -18.750000, _S8 49.000252, _S8 -18.850000, _S8 53.100250, _S8 -19.750000, _S8 53.500252,
	8, _S8 -19.750000, _S8 53.500252, _S8 -16.850000, _S8 50.700249, _S8 -19.250000, _S8 54.900249,
	4, _S8 -20.350000, _S8 59.600250,
	8, _S8 -20.350000, _S8 59.600250, _S8 -13.950000, _S8 54.200249, _S8 -17.850000, _S8 58.800251,
	4, _S8 -20.350000, _S8 65.300247,
	8, _S8 -20.350000, _S8 65.300247, _S8 -15.450000, _S8 60.700249, _S8 -17.250000, _S8 62.800251,
	4, _S8 -18.049999, _S8 65.000252,
	8, _S8 -18.049999, _S8 65.000252, _S8 -7.250000, _S8 58.200249, _S8 -14.950000, _S8 65.600250,
	8, _S8 -14.950000, _S8 65.600250, _S8 -12.950000, _S8 64.700249, _S8 -11.850000, _S8 65.400253,
	8, _S8 -11.850000, _S8 65.400253, _S8 -10.150000, _S8 65.100250, _S8 -10.350000, _S8 65.500252,
	8, _S8 -10.350000, _S8 65.500252, _S8 -15.550000, _S8 68.100250, _S8 -16.450001, _S8 72.700249,
	8, _S8 -16.450001, _S8 72.700249, _S8 -14.350000, _S8 70.200249, _S8 -15.150000, _S8 72.900253,
	4, _S8 -15.050000, _S8 75.800247,
	8, _S8 -15.050000, _S8 75.800247, _S8 -14.050000, _S8 70.400253, _S8 -14.150000, _S8 79.800247,
	8, _S8 -14.150000, _S8 79.800247, _S8 -9.350000, _S8 75.300247, _S8 -12.250000, _S8 80.500252,
	4, _S8 -12.250000, _S8 84.700249,
	8, _S8 -12.250000, _S8 84.700249, _S8 -8.450000, _S8 80.600250, _S8 -10.050000, _S8 83.800247,
	8, _S8 -10.050000, _S8 83.800247, _S8 -7.550000, _S8 81.600250, _S8 -8.550000, _S8 85.400253,
	8, _S8 -8.550000, _S8 85.400253, _S8 -8.750000, _S8 88.000252, _S8 -7.650000, _S8 85.200249,
	8, _S8 -7.650000, _S8 85.200249, _S8 -3.650000, _S8 77.550247, _S8 -5.150000, _S8 84.100250,
	8, _S8 -5.150000, _S8 84.100250, _S8 -5.350000, _S8 88.900253, _S8 -4.150000, _S8 85.200249,
	8, _S8 -4.150000, _S8 85.200249, _S8 -4.050000, _S8 87.800247, _S8 -1.750000, _S8 89.600250,
	8, _S8 -1.750000, _S8 89.600250, _S8 -2.050000, _S8 76.900253, _S8 1.150000, _S8 85.900253,
	4, _S8 2.150000, _S8 90.000252,
	8, _S8 2.150000, _S8 90.000252, _S8 2.850000, _S8 87.700249, _S8 2.750000, _S8 86.400253,
	8, _S8 2.750000, _S8 86.400253, _S8 6.450000, _S8 82.300247, _S8 4.750000, _S8 88.400253,
	8, _S8 4.750000, _S8 88.400253, _S8 8.550000, _S8 82.700249, _S8 7.750000, _S8 86.000252,
	8, _S8 7.750000, _S8 86.000252, _S8 5.850000, _S8 90.000252, _S8 6.250000, _S8 91.200249,
	8, _S8 6.250000, _S8 91.200249, _S8 10.450000, _S8 82.500252, _S8 10.750000, _S8 82.100250,
	8, _S8 10.750000, _S8 82.100250, _S8 10.250000, _S8 92.700500, _S8 12.950000, _S8 83.700249,
	8, _S8 12.950000, _S8 83.700249, _S8 14.350000, _S8 86.700249, _S8 13.650000, _S8 87.800247,
	8, _S8 13.650000, _S8 87.800247, _S8 15.650000, _S8 85.800247, _S8 15.450000, _S8 85.000252,
	8, _S8 15.450000, _S8 85.000252, _S8 16.600000, _S8 82.950249, _S8 17.299999, _S8 86.350250,
	8, _S8 17.299999, _S8 86.350250, _S8 17.750000, _S8 88.700249, _S8 18.150000, _S8 87.900253,
	8, _S8 18.150000, _S8 87.900253, _S8 19.150000, _S8 93.900497, _S8 19.450001, _S8 88.200249,
	8, _S8 19.450001, _S8 88.200249, _S8 19.850000, _S8 84.800247, _S8 18.049999, _S8 81.900253,
	8, _S8 18.049999, _S8 81.900253, _S8 18.250000, _S8 81.100250, _S8 17.549999, _S8 80.100250,
	8, _S8 17.549999, _S8 80.100250, _S8 20.950001, _S8 85.500252, _S8 19.150000, _S8 78.300247,
	8, _S8 19.150000, _S8 78.300247, _S8 21.950251, _S8 80.300247, _S8 22.250250, _S8 80.300247,
	8, _S8 22.250250, _S8 80.300247, _S8 18.850000, _S8 74.500252, _S8 21.049999, _S8 75.700249,
	8, _S8 21.049999, _S8 75.700249, _S8 19.750000, _S8 73.100250, _S8 24.250250, _S8 76.100250,
	8, _S8 24.250250, _S8 76.100250, _S8 20.250000, _S8 72.100250, _S8 24.650249, _S8 74.500252,
	8, _S8 24.650249, _S8 74.500252, _S8 26.650249, _S8 76.100250, _S8 24.750250, _S8 73.600250,
	8, _S8 24.750250, _S8 73.600250, _S8 21.150000, _S8 69.600250, _S8 26.650249, _S8 74.100250,
	8, _S8 26.650249, _S8 74.100250, _S8 29.550249, _S8 78.200249, _S8 29.750250, _S8 78.900253,
	8, _S8 29.750250, _S8 78.900253, _S8 27.250250, _S8 71.600250, _S8 26.150249, _S8 70.900253,
	8, _S8 26.150249, _S8 70.900253, _S8 28.250250, _S8 61.800251, _S8 38.550251, _S8 65.700249,
	8, _S8 38.550251, _S8 65.700249, _S8 40.250252, _S8 70.000252, _S8 41.350250, _S8 65.400253,
	8, _S8 41.350250, _S8 65.400253, _S8 44.550251, _S8 63.800251, _S8 47.350250, _S8 70.700249,
	8, _S8 47.350250, _S8 70.700249, _S8 48.350250, _S8 67.300247, _S8 48.150249, _S8 66.600250,
	8, _S8 48.150249, _S8 66.600250, _S8 49.850250, _S8 66.900253, _S8 49.650249, _S8 66.600250,
	8, _S8 49.650249, _S8 66.600250, _S8 52.950249, _S8 67.700249, _S8 53.250252, _S8 67.500252,
	8, _S8 53.250252, _S8 67.500252, _S8 54.950249, _S8 69.200249, _S8 55.050251, _S8 68.300247,
	8, _S8 55.050251, _S8 68.300247, _S8 57.350250, _S8 69.000252, _S8 56.850250, _S8 68.100250,
	8, _S8 56.850250, _S8 68.100250, _S8 59.050251, _S8 72.000252, _S8 59.150249, _S8 72.900253,
	4, _S8 59.750252, _S8 69.400253,
	4, _S8 60.250252, _S8 70.100250,
	8, _S8 60.250252, _S8 70.100250, _S8 60.650249, _S8 68.200249, _S8 60.450249, _S8 67.900253,
	8, _S8 60.250252, _S8 67.600250, _S8 65.450249, _S8 69.600250, _S8 66.650253, _S8 74.800247,
	4, _S8 67.150253, _S8 76.900253,
	8, _S8 67.150253, _S8 76.900253, _S8 68.650253, _S8 73.200249, _S8 68.250252, _S8 72.200249,
	8, _S8 68.250252, _S8 72.200249, _S8 69.550247, _S8 72.400253, _S8 69.650253, _S8 73.500252,
	8, _S8 69.650253, _S8 73.500252, _S8 70.650253, _S8 67.700249, _S8 69.450249, _S8 66.200249,
	8, _S8 69.450249, _S8 66.200249, _S8 70.550247, _S8 66.000252, _S8 70.850250, _S8 66.900253,
	4, _S8 70.850250, _S8 65.100250,
	8, _S8 70.850250, _S8 65.100250, _S8 72.650253, _S8 65.300247, _S8 72.650253, _S8 64.700249,
	8, _S8 72.650253, _S8 64.700249, _S8 73.750252, _S8 63.700249, _S8 74.250252, _S8 64.900253,
	8, _S8 74.250252, _S8 64.900253, _S8 71.150253, _S8 56.100250, _S8 75.750252, _S8 60.900249,
	8, _S8 75.750252, _S8 60.900249, _S8 77.550247, _S8 63.600250, _S8 76.650253, _S8 58.900249,
	8, _S8 75.750252, _S8 54.200249, _S8 74.750252, _S8 53.800251, _S8 75.950249, _S8 53.700249,
	8, _S8 75.950249, _S8 53.700249, _S8 76.150253, _S8 52.800251, _S8 75.650253, _S8 52.400249,
	8, _S8 75.150253, _S8 52.000252, _S8 75.950249, _S8 52.400249, _S8 75.950249, _S8 52.400249,
	8, _S8 75.950249, _S8 52.400249, _S8 77.150253, _S8 53.400249, _S8 75.850250, _S8 47.900249,
	8, _S8 75.850250, _S8 47.900249, _S8 77.450249, _S8 48.300251, _S8 74.450249, _S8 41.000252,
	8, _S8 74.450249, _S8 41.000252, _S8 75.150253, _S8 40.400249, _S8 74.150253, _S8 38.300251,
	8, _S8 74.150253, _S8 38.300251, _S8 76.150253, _S8 39.400249, _S8 76.850250, _S8 39.000252,
	8, _S8 76.850250, _S8 39.000252, _S8 76.750252, _S8 38.600250, _S8 75.950249, _S8 37.600250,
	8, _S8 75.950249, _S8 37.600250, _S8 70.550247, _S8 23.900000, _S8 75.650253, _S8 29.400249,
	8, _S8 75.650253, _S8 29.400249, _S8 78.612747, _S8 32.787750, _S8 77.012749, _S8 27.087749,
	8, _S8 77.012749, _S8 27.087749, _S8 74.735001, _S8 21.085251, _S8 74.929253, _S8 20.011250,
	4, _S8 -32.457500, _S8 25.766251,
	0
};

/* path_data13 ===========================================*/
signed char path_data13[] = {
	2, _S8 74.929253, _S8 20.061251,
	8, _S8 75.086250, _S8 20.106501, _S8 75.637749, _S8 20.387501, _S8 75.950249, _S8 20.799999,
	8, _S8 75.950249, _S8 20.799999, _S8 77.650253, _S8 23.500000, _S8 76.350250, _S8 18.900000,
	8, _S8 76.350250, _S8 18.900000, _S8 74.050247, _S8 11.700000, _S8 76.250252, _S8 14.500000,
	8, _S8 76.250252, _S8 14.500000, _S8 77.750252, _S8 16.299999, _S8 76.950249, _S8 12.900000,
	8, _S8 75.984001, _S8 8.793250, _S8 75.350250, _S8 7.200000, _S8 75.350250, _S8 7.200000,
	8, _S8 75.350250, _S8 7.200000, _S8 78.250252, _S8 8.400000, _S8 71.550247, _S8 -1.500000,
	4, _S8 73.750252, _S8 -0.600000,
	8, _S8 73.750252, _S8 -0.600000, _S8 68.850250, _S8 -10.500000, _S8 63.450249, _S8 -11.800000,
	4, _S8 61.450249, _S8 -13.300000,
	8, _S8 61.450249, _S8 -13.300000, _S8 71.050247, _S8 -22.799999, _S8 67.850250, _S8 -32.000000,
	8, _S8 67.850250, _S8 -32.000000, _S8 66.150253, _S8 -33.299999, _S8 63.750252, _S8 -31.000000,
	8, _S8 63.750252, _S8 -31.000000, _S8 62.150249, _S8 -29.799999, _S8 60.650249, _S8 -30.200001,
	8, _S8 60.650249, _S8 -30.200001, _S8 52.950249, _S8 -29.900000, _S8 52.450249, _S8 -29.900000,
	8, _S8 51.950249, _S8 -29.900000, _S8 43.250252, _S8 -39.200001, _S8 26.850250, _S8 -34.799999,
	8, _S8 26.850250, _S8 -34.799999, _S8 25.550249, _S8 -34.299999, _S8 24.450251, _S8 -34.599998,
	8, _S8 24.450251, _S8 -34.599998, _S8 19.850000, _S8 -38.599998, _S8 7.650000, _S8 -32.900002,
	8, _S8 7.650000, _S8 -32.900002, _S8 5.150000, _S8 -32.400002, _S8 4.750000, _S8 -32.400002,
	8, _S8 4.350000, _S8 -32.400002, _S8 3.650000, _S8 -32.400002, _S8 1.650000, _S8 -30.799999,
	8, _S8 -0.350000, _S8 -29.200001, _S8 -0.450000, _S8 -29.000000, _S8 -0.950000, _S8 -28.600000,
	8, _S8 -0.950000, _S8 -28.600000, _S8 -5.050000, _S8 -25.799999, _S8 -6.250000, _S8 -25.600000,
	8, _S8 -6.250000, _S8 -25.600000, _S8 -9.150000, _S8 -24.000000, _S8 -10.250000, _S8 -21.500000,
	4, _S8 -11.150000, _S8 -21.200001,
	8, _S8 -11.150000, _S8 -21.200001, _S8 -11.550000, _S8 -19.400000, _S8 -11.650000, _S8 -19.100000,
	8, _S8 -11.650000, _S8 -19.100000, _S8 -12.850000, _S8 -18.200001, _S8 -13.050000, _S8 -16.799999,
	8, _S8 -13.050000, _S8 -16.799999, _S8 -15.250000, _S8 -15.300000, _S8 -15.150000, _S8 -14.200000,
	8, _S8 -15.150000, _S8 -14.200000, _S8 -15.550000, _S8 -12.900000, _S8 -15.750000, _S8 -11.700000,
	8, _S8 -15.750000, _S8 -11.700000, _S8 -17.549999, _S8 -10.500000, _S8 -17.350000, _S8 -9.800000,
	8, _S8 -17.350000, _S8 -9.800000, _S8 -19.250000, _S8 -6.300000, _S8 -18.950001, _S8 -4.600000,
	8, _S8 -18.950001, _S8 -4.600000, _S8 -20.549999, _S8 -4.700000, _S8 -21.250000, _S8 -4.100000,
	8, _S8 -21.250000, _S8 -4.100000, _S8 -21.450001, _S8 -2.900000, _S8 -21.850000, _S8 -2.800000,
	8, _S8 -21.850000, _S8 -2.800000, _S8 -22.549999, _S8 -2.500000, _S8 -21.950001, _S8 -1.500000,
	8, _S8 -21.950001, _S8 -1.500000, _S8 -22.350000, _S8 -0.800000, _S8 -22.450001, _S8 -0.400000,
	8, _S8 -22.450001, _S8 -0.400000, _S8 -22.250000, _S8 0.300000, _S8 -23.350000, _S8 1.700000,
	8, _S8 -23.350000, _S8 1.700000, _S8 -24.950001, _S8 6.400000, _S8 -24.450001, _S8 7.700000,
	8, _S8 -24.450001, _S8 7.700000, _S8 -24.350000, _S8 8.900000, _S8 -25.049999, _S8 9.300000,
	8, _S8 -25.049999, _S8 9.300000, _S8 -25.950001, _S8 9.200000, _S8 -23.850000, _S8 12.200000,
	8, _S8 -23.850000, _S8 12.200000, _S8 -23.650000, _S8 12.500000, _S8 -24.450001, _S8 13.100000,
	8, _S8 -24.450001, _S8 13.100000, _S8 -28.750000, _S8 14.000000, _S8 -29.350000, _S8 18.100000,
	8, _S8 -29.350000, _S8 18.100000, _S8 -32.750000, _S8 21.799999, _S8 -32.750000, _S8 23.100000,
	8, _S8 -32.750000, _S8 23.676250, _S8 -32.682251, _S8 24.462999, _S8 -32.507500, _S8 25.616249,
	8, _S8 -32.507500, _S8 25.616249, _S8 -32.650002, _S8 27.700251, _S8 -25.750000, _S8 27.900249,
	8, _S8 -18.850000, _S8 28.100250, _S8 74.929253, _S8 20.061251, _S8 74.929253, _S8 20.061251,
	0
};

/* path_data14 ===========================================*/
signed char path_data14[] = {
	2, _S8 -28.900000, _S8 25.650000,
	8, _S8 -35.150002, _S8 15.800000, _S8 -31.549999, _S8 29.900249, _S8 -31.549999, _S8 29.900249,
	8, _S8 -29.350000, _S8 38.500252, _S8 3.050000, _S8 29.100250, _S8 3.050000, _S8 29.100250,
	8, _S8 3.050000, _S8 29.100250, _S8 45.250252, _S8 21.500000, _S8 48.050251, _S8 20.500000,
	8, _S8 50.850250, _S8 19.500000, _S8 74.650253, _S8 21.100000, _S8 74.650253, _S8 21.100000,
	4, _S8 73.250252, _S8 16.900000,
	8, _S8 57.050251, _S8 5.300000, _S8 52.250252, _S8 11.100000, _S8 48.850250, _S8 10.100000,
	8, _S8 45.450249, _S8 9.100000, _S8 46.050251, _S8 11.500000, _S8 45.250252, _S8 11.700000,
	8, _S8 44.450249, _S8 11.900000, _S8 34.650249, _S8 5.700000, _S8 33.050251, _S8 5.900000,
	8, _S8 31.450251, _S8 6.100000, _S8 25.114750, _S8 0.162250, _S8 28.850250, _S8 8.100000,
	8, _S8 32.850250, _S8 16.600000, _S8 14.250000, _S8 17.900000, _S8 10.050000, _S8 15.100000,
	8, _S8 5.850000, _S8 12.300000, _S8 11.850000, _S8 19.700001, _S8 11.850000, _S8 19.700001,
	8, _S8 16.450001, _S8 24.700001, _S8 7.850000, _S8 20.500000, _S8 7.850000, _S8 20.500000,
	8, _S8 -0.750000, _S8 17.299999, _S8 -6.750000, _S8 23.700001, _S8 -7.550000, _S8 23.900000,
	8, _S8 -8.350000, _S8 24.100000, _S8 -9.550000, _S8 24.900000, _S8 -9.750000, _S8 23.299999,
	8, _S8 -9.950000, _S8 21.700001, _S8 -11.827500, _S8 17.524750, _S8 -19.750000, _S8 24.100000,
	8, _S8 -24.750000, _S8 28.250250, _S8 -28.200001, _S8 22.750000, _S8 -28.200001, _S8 22.750000,
	4, _S8 -28.900000, _S8 25.650000,
	0
};

/* path_data15 ===========================================*/
signed char path_data15[] = {
	2, _S8 33.377499, _S8 6.336500,
	8, _S8 31.777500, _S8 6.536500, _S8 25.435749, _S8 0.601750, _S8 29.177500, _S8 8.536500,
	8, _S8 33.327499, _S8 17.336500, _S8 14.577500, _S8 18.336500, _S8 10.377500, _S8 15.536500,
	8, _S8 6.177250, _S8 12.736500, _S8 12.177500, _S8 20.136499, _S8 12.177500, _S8 20.136499,
	8, _S8 16.777500, _S8 25.136499, _S8 8.177250, _S8 20.936501, _S8 8.177250, _S8 20.936501,
	8, _S8 -0.422750, _S8 17.736500, _S8 -6.422750, _S8 24.136499, _S8 -7.222750, _S8 24.336500,
	8, _S8 -8.022750, _S8 24.536501, _S8 -9.222750, _S8 25.336500, _S8 -9.422750, _S8 23.736500,
	8, _S8 -9.622750, _S8 22.136499, _S8 -11.467500, _S8 18.003000, _S8 -19.422750, _S8 24.536501,
	8, _S8 -24.731750, _S8 28.872999, _S8 -28.104500, _S8 23.509251, _S8 -28.104500, _S8 23.509251,
	4, _S8 -28.904499, _S8 26.036501,
	8, _S8 -35.154499, _S8 16.086500, _S8 -31.386499, _S8 30.663750, _S8 -31.386499, _S8 30.663750,
	8, _S8 -29.186251, _S8 39.264000, _S8 3.377250, _S8 29.536501, _S8 3.377250, _S8 29.536501,
	8, _S8 3.377250, _S8 29.536501, _S8 45.577499, _S8 21.936501, _S8 48.377499, _S8 20.936501,
	8, _S8 51.177502, _S8 19.936501, _S8 74.759499, _S8 21.518250, _S8 74.759499, _S8 21.518250,
	4, _S8 73.377502, _S8 17.191000,
	8, _S8 57.177502, _S8 5.591000, _S8 52.577499, _S8 11.536500, _S8 49.177502, _S8 10.536500,
	8, _S8 45.777500, _S8 9.536500, _S8 46.377499, _S8 11.936500, _S8 45.577499, _S8 12.136500,
	8, _S8 44.777500, _S8 12.336500, _S8 34.977501, _S8 6.136500, _S8 33.377499, _S8 6.336500,
	0
};

/* path_data16 ===========================================*/
signed char path_data16[] = {
	2, _S8 33.704750, _S8 6.772750,
	8, _S8 32.104752, _S8 6.972750, _S8 25.921249, _S8 0.965500, _S8 29.504749, _S8 8.972750,
	8, _S8 33.554749, _S8 18.023001, _S8 14.904750, _S8 18.773001, _S8 10.704750, _S8 15.973000,
	8, _S8 6.504750, _S8 13.173000, _S8 12.504750, _S8 20.573000, _S8 12.504750, _S8 20.573000,
	8, _S8 17.104750, _S8 25.573000, _S8 8.504750, _S8 21.372999, _S8 8.504750, _S8 21.372999,
	8, _S8 -0.095250, _S8 18.173000, _S8 -6.095500, _S8 24.573000, _S8 -6.895500, _S8 24.773001,
	8, _S8 -7.695500, _S8 24.973000, _S8 -8.895500, _S8 25.773001, _S8 -9.095500, _S8 24.173000,
	8, _S8 -9.295500, _S8 22.573000, _S8 -11.107500, _S8 18.481251, _S8 -19.095501, _S8 24.973000,
	8, _S8 -24.713751, _S8 29.495750, _S8 -28.009001, _S8 24.268499, _S8 -28.009001, _S8 24.268499,
	4, _S8 -28.909000, _S8 26.423000,
	8, _S8 -34.859001, _S8 16.673000, _S8 -31.222750, _S8 31.427500, _S8 -31.222750, _S8 31.427500,
	8, _S8 -29.022751, _S8 40.027500, _S8 3.704750, _S8 29.973000, _S8 3.704750, _S8 29.973000,
	8, _S8 3.704750, _S8 29.973000, _S8 45.904751, _S8 22.372999, _S8 48.704750, _S8 21.372999,
	8, _S8 51.504749, _S8 20.372999, _S8 74.868500, _S8 21.936501, _S8 74.868500, _S8 21.936501,
	4, _S8 73.504997, _S8 17.482000,
	8, _S8 57.304749, _S8 5.882000, _S8 52.904751, _S8 11.972750, _S8 49.504749, _S8 10.972750,
	8, _S8 46.104752, _S8 9.972750, _S8 46.704750, _S8 12.372750, _S8 45.904751, _S8 12.573000,
	8, _S8 45.104752, _S8 12.773000, _S8 35.304749, _S8 6.572750, _S8 33.704750, _S8 6.772750,
	0
};

/* path_data17 ===========================================*/
signed char path_data17[] = {
	2, _S8 34.032001, _S8 7.209250,
	8, _S8 32.431999, _S8 7.409250, _S8 26.249750, _S8 1.401250, _S8 29.832001, _S8 9.409250,
	8, _S8 34.032001, _S8 18.798250, _S8 15.098500, _S8 19.120501, _S8 11.032000, _S8 16.409250,
	8, _S8 6.832000, _S8 13.609250, _S8 12.832000, _S8 21.009251, _S8 12.832000, _S8 21.009251,
	8, _S8 17.431999, _S8 26.009251, _S8 8.832000, _S8 21.809250, _S8 8.832000, _S8 21.809250,
	8, _S8 0.232000, _S8 18.609249, _S8 -5.768000, _S8 25.009251, _S8 -6.568000, _S8 25.209249,
	8, _S8 -7.368000, _S8 25.409250, _S8 -8.568000, _S8 26.209249, _S8 -8.768000, _S8 24.609249,
	8, _S8 -8.968000, _S8 23.009251, _S8 -10.747250, _S8 18.959749, _S8 -18.768250, _S8 25.409250,
	8, _S8 -24.695499, _S8 30.118500, _S8 -27.913750, _S8 25.027500, _S8 -27.913750, _S8 25.027500,
	4, _S8 -28.913750, _S8 26.809250,
	8, _S8 -34.363750, _S8 17.609249, _S8 -31.059000, _S8 32.191250, _S8 -31.059000, _S8 32.191250,
	8, _S8 -28.858999, _S8 40.791248, _S8 4.032000, _S8 30.409250, _S8 4.032000, _S8 30.409250,
	8, _S8 4.032000, _S8 30.409250, _S8 46.231998, _S8 22.809250, _S8 49.032249, _S8 21.809250,
	8, _S8 51.832249, _S8 20.809250, _S8 74.977753, _S8 22.354750, _S8 74.977753, _S8 22.354750,
	4, _S8 73.632248, _S8 17.773001,
	8, _S8 57.432251, _S8 6.172750, _S8 53.232250, _S8 12.409250, _S8 49.832249, _S8 11.409250,
	8, _S8 46.431999, _S8 10.409250, _S8 47.032001, _S8 12.809250, _S8 46.231998, _S8 13.009250,
	8, _S8 45.431999, _S8 13.209250, _S8 35.632000, _S8 7.009250, _S8 34.032001, _S8 7.209250,
	0
};

/* path_data18 ===========================================*/
signed char path_data18[] = {
	2, _S8 34.359501, _S8 7.645750,
	8, _S8 32.759251, _S8 7.845750, _S8 26.703501, _S8 1.782250, _S8 30.159250, _S8 9.845750,
	8, _S8 34.359501, _S8 19.645750, _S8 15.559250, _S8 19.645750, _S8 11.359250, _S8 16.845751,
	8, _S8 7.159250, _S8 14.045750, _S8 13.159250, _S8 21.445749, _S8 13.159250, _S8 21.445749,
	8, _S8 17.759251, _S8 26.445749, _S8 9.159250, _S8 22.245750, _S8 9.159250, _S8 22.245750,
	8, _S8 0.559250, _S8 19.045750, _S8 -5.440750, _S8 25.445749, _S8 -6.240750, _S8 25.645750,
	8, _S8 -7.040750, _S8 25.845751, _S8 -8.240750, _S8 26.645750, _S8 -8.440750, _S8 25.045750,
	8, _S8 -8.640750, _S8 23.445749, _S8 -10.387000, _S8 19.438000, _S8 -18.440750, _S8 25.845751,
	8, _S8 -24.677250, _S8 30.741249, _S8 -27.818251, _S8 25.786501, _S8 -27.818251, _S8 25.786501,
	4, _S8 -28.918249, _S8 27.195749,
	8, _S8 -33.868252, _S8 18.495501, _S8 -30.895500, _S8 32.954750, _S8 -30.895500, _S8 32.954750,
	8, _S8 -28.695499, _S8 41.555000, _S8 4.359250, _S8 30.845751, _S8 4.359250, _S8 30.845751,
	8, _S8 4.359250, _S8 30.845751, _S8 46.559502, _S8 23.245750, _S8 49.359501, _S8 22.245750,
	8, _S8 52.159500, _S8 21.245750, _S8 75.086746, _S8 22.773001, _S8 75.086746, _S8 22.773001,
	4, _S8 73.759499, _S8 18.063749,
	8, _S8 57.559502, _S8 6.463750, _S8 53.559502, _S8 12.845750, _S8 50.159500, _S8 11.845750,
	8, _S8 46.759499, _S8 10.845750, _S8 47.359501, _S8 13.245750, _S8 46.559502, _S8 13.445750,
	8, _S8 45.759499, _S8 13.645750, _S8 35.959499, _S8 7.445750, _S8 34.359501, _S8 7.645750,
	0
};

/* path_data19 ===========================================*/
signed char path_data19[] = {
	2, _S8 34.686749, _S8 8.082000,
	8, _S8 33.086750, _S8 8.282000, _S8 26.595751, _S8 2.419250, _S8 30.486750, _S8 10.282000,
	8, _S8 35.286751, _S8 19.982000, _S8 15.886500, _S8 20.082001, _S8 11.686500, _S8 17.282000,
	8, _S8 7.486500, _S8 14.482000, _S8 13.486500, _S8 21.882000, _S8 13.486500, _S8 21.882000,
	8, _S8 18.086500, _S8 26.882000, _S8 9.486500, _S8 22.681999, _S8 9.486500, _S8 22.681999,
	8, _S8 0.886500, _S8 19.482000, _S8 -5.113500, _S8 25.882000, _S8 -5.913500, _S8 26.082001,
	8, _S8 -6.713500, _S8 26.282000, _S8 -7.913500, _S8 27.082001, _S8 -8.113500, _S8 25.482000,
	8, _S8 -8.313500, _S8 23.882000, _S8 -10.027000, _S8 19.916250, _S8 -18.113501, _S8 26.282000,
	8, _S8 -24.659000, _S8 31.364000, _S8 -27.722750, _S8 26.545750, _S8 -27.722750, _S8 26.545750,
	4, _S8 -28.922750, _S8 27.582001,
	8, _S8 -33.422749, _S8 19.282000, _S8 -30.731750, _S8 33.718498, _S8 -30.731750, _S8 33.718498,
	8, _S8 -28.531750, _S8 42.318501, _S8 4.686500, _S8 31.282000, _S8 4.686500, _S8 31.282000,
	8, _S8 4.686500, _S8 31.282000, _S8 46.886749, _S8 23.681999, _S8 49.686749, _S8 22.681999,
	8, _S8 52.486752, _S8 21.681999, _S8 75.195747, _S8 23.191000, _S8 75.195747, _S8 23.191000,
	4, _S8 73.886749, _S8 18.354750,
	8, _S8 57.686749, _S8 6.754750, _S8 53.886749, _S8 13.282000, _S8 50.486752, _S8 12.282000,
	8, _S8 47.086750, _S8 11.282000, _S8 47.686749, _S8 13.682000, _S8 46.886749, _S8 13.882000,
	8, _S8 46.086750, _S8 14.082000, _S8 36.286751, _S8 7.882000, _S8 34.686749, _S8 8.082000,
	0
};

/* path_data20 ===========================================*/
signed char path_data20[] = {
	2, _S8 35.014000, _S8 8.518250,
	8, _S8 33.413750, _S8 8.718250, _S8 26.828251, _S8 2.903250, _S8 30.813749, _S8 10.718250,
	8, _S8 35.914001, _S8 20.718500, _S8 16.213751, _S8 20.518499, _S8 12.013750, _S8 17.718500,
	8, _S8 7.813750, _S8 14.918500, _S8 13.813750, _S8 22.318501, _S8 13.813750, _S8 22.318501,
	8, _S8 18.413750, _S8 27.318501, _S8 9.813750, _S8 23.118500, _S8 9.813750, _S8 23.118500,
	8, _S8 1.213750, _S8 19.918501, _S8 -4.786250, _S8 26.318501, _S8 -5.586250, _S8 26.518499,
	8, _S8 -6.386250, _S8 26.718500, _S8 -7.586250, _S8 27.518499, _S8 -7.786250, _S8 25.918501,
	8, _S8 -7.986250, _S8 24.318501, _S8 -9.667000, _S8 20.394501, _S8 -17.786249, _S8 26.718500,
	8, _S8 -24.641001, _S8 31.986750, _S8 -27.627251, _S8 27.304750, _S8 -27.627251, _S8 27.304750,
	4, _S8 -28.927250, _S8 27.968500,
	8, _S8 -32.927250, _S8 20.418501, _S8 -30.568251, _S8 34.482250, _S8 -30.568251, _S8 34.482250,
	8, _S8 -28.368250, _S8 43.082249, _S8 5.013750, _S8 31.718500, _S8 5.013750, _S8 31.718500,
	8, _S8 5.013750, _S8 31.718500, _S8 47.214001, _S8 24.118500, _S8 50.014000, _S8 23.118500,
	8, _S8 52.813999, _S8 22.118500, _S8 75.305000, _S8 23.609249, _S8 75.305000, _S8 23.609249,
	4, _S8 74.014000, _S8 18.645750,
	8, _S8 57.813999, _S8 7.045750, _S8 54.214001, _S8 13.718500, _S8 50.813999, _S8 12.718500,
	8, _S8 47.414001, _S8 11.718250, _S8 48.014000, _S8 14.118500, _S8 47.214001, _S8 14.318500,
	8, _S8 46.414001, _S8 14.518500, _S8 36.613998, _S8 8.318250, _S8 35.014000, _S8 8.518250,
	0
};

/* path_data21 ===========================================*/
signed char path_data21[] = {
	2, _S8 35.341251, _S8 8.954750,
	8, _S8 33.741249, _S8 9.154750, _S8 26.880751, _S8 3.486000, _S8 31.141251, _S8 11.154750,
	8, _S8 36.641251, _S8 21.054750, _S8 16.541000, _S8 20.954750, _S8 12.341000, _S8 18.154751,
	8, _S8 8.141000, _S8 15.354750, _S8 14.141000, _S8 22.754749, _S8 14.141000, _S8 22.754749,
	8, _S8 18.740999, _S8 27.754749, _S8 10.141000, _S8 23.554750, _S8 10.141000, _S8 23.554750,
	8, _S8 1.541000, _S8 20.354750, _S8 -4.459000, _S8 26.754749, _S8 -5.259000, _S8 26.954750,
	8, _S8 -6.059000, _S8 27.154751, _S8 -7.259000, _S8 27.954750, _S8 -7.459000, _S8 26.354750,
	8, _S8 -7.659000, _S8 24.754749, _S8 -9.306750, _S8 20.872999, _S8 -17.459000, _S8 27.154751,
	8, _S8 -24.622749, _S8 32.609501, _S8 -27.531750, _S8 28.063999, _S8 -27.531750, _S8 28.063999,
	4, _S8 -28.931749, _S8 28.354750,
	8, _S8 -32.532001, _S8 21.254749, _S8 -30.404499, _S8 35.245750, _S8 -30.404499, _S8 35.245750,
	8, _S8 -28.204500, _S8 43.846001, _S8 5.341000, _S8 32.154751, _S8 5.341000, _S8 32.154751,
	8, _S8 5.341000, _S8 32.154751, _S8 47.541248, _S8 24.554750, _S8 50.341251, _S8 23.554750,
	8, _S8 53.141251, _S8 22.554750, _S8 75.414001, _S8 24.027500, _S8 75.414001, _S8 24.027500,
	4, _S8 74.141251, _S8 18.936501,
	8, _S8 57.941250, _S8 7.336500, _S8 54.541248, _S8 14.154750, _S8 51.141251, _S8 13.154750,
	8, _S8 47.741249, _S8 12.154750, _S8 48.341251, _S8 14.554750, _S8 47.541248, _S8 14.754750,
	8, _S8 46.741249, _S8 14.954750, _S8 36.941250, _S8 8.754750, _S8 35.341251, _S8 8.954750,
	0
};

/* path_data22 ===========================================*/
signed char path_data22[] = {
	2, _S8 35.668499, _S8 9.391250,
	8, _S8 34.068501, _S8 9.591250, _S8 27.208000, _S8 3.922250, _S8 31.468500, _S8 11.591250,
	8, _S8 36.968498, _S8 21.491249, _S8 16.868500, _S8 21.391251, _S8 12.668500, _S8 18.591249,
	8, _S8 8.468500, _S8 15.791250, _S8 14.468500, _S8 23.191250, _S8 14.468500, _S8 23.191250,
	8, _S8 19.068501, _S8 28.191250, _S8 10.468500, _S8 23.991249, _S8 10.468500, _S8 23.991249,
	8, _S8 1.868250, _S8 20.791250, _S8 -4.131750, _S8 27.191250, _S8 -4.931750, _S8 27.391251,
	8, _S8 -5.731750, _S8 27.591249, _S8 -6.931750, _S8 28.391251, _S8 -7.131750, _S8 26.791250,
	8, _S8 -7.331750, _S8 25.191250, _S8 -8.946500, _S8 21.351250, _S8 -17.131750, _S8 27.591249,
	8, _S8 -24.604500, _S8 33.232250, _S8 -27.436251, _S8 28.823250, _S8 -27.436251, _S8 28.823250,
	4, _S8 -28.936251, _S8 28.741249,
	8, _S8 -32.336498, _S8 22.141001, _S8 -30.240749, _S8 36.009499, _S8 -30.240749, _S8 36.009499,
	8, _S8 -28.040751, _S8 44.609501, _S8 5.668250, _S8 32.591251, _S8 5.668250, _S8 32.591251,
	8, _S8 5.668250, _S8 32.591251, _S8 47.868500, _S8 24.991249, _S8 50.668499, _S8 23.991249,
	8, _S8 53.468498, _S8 22.991249, _S8 75.523247, _S8 24.445749, _S8 75.523247, _S8 24.445749,
	4, _S8 74.268753, _S8 19.227501,
	8, _S8 58.068501, _S8 7.627500, _S8 54.868500, _S8 14.591250, _S8 51.468498, _S8 13.591250,
	8, _S8 48.068501, _S8 12.591250, _S8 48.668499, _S8 14.991250, _S8 47.868500, _S8 15.191250,
	8, _S8 47.068501, _S8 15.391250, _S8 37.268501, _S8 9.191250, _S8 35.668499, _S8 9.391250,
	0
};

/* path_data23 ===========================================*/
signed char path_data23[] = {
	2, _S8 35.995751, _S8 9.827500,
	8, _S8 34.395748, _S8 10.027500, _S8 27.632250, _S8 4.305750, _S8 31.795750, _S8 12.027500,
	8, _S8 37.295750, _S8 22.227501, _S8 17.195749, _S8 21.827499, _S8 12.995751, _S8 19.027500,
	8, _S8 8.795750, _S8 16.227501, _S8 14.795750, _S8 23.627501, _S8 14.795750, _S8 23.627501,
	8, _S8 19.395750, _S8 28.627501, _S8 10.795750, _S8 24.427500, _S8 10.795750, _S8 24.427500,
	8, _S8 2.195750, _S8 21.227501, _S8 -3.804250, _S8 27.627501, _S8 -4.604250, _S8 27.827499,
	8, _S8 -5.404500, _S8 28.027500, _S8 -6.604500, _S8 28.827499, _S8 -6.804500, _S8 27.227501,
	8, _S8 -7.004500, _S8 25.627501, _S8 -8.586500, _S8 21.829500, _S8 -16.804501, _S8 28.027500,
	8, _S8 -24.586250, _S8 33.854999, _S8 -27.340750, _S8 29.582251, _S8 -27.340750, _S8 29.582251,
	4, _S8 -28.941000, _S8 29.127501,
	8, _S8 -32.191002, _S8 23.127501, _S8 -30.077250, _S8 36.773251, _S8 -30.077250, _S8 36.773251,
	8, _S8 -27.877251, _S8 45.373249, _S8 5.995750, _S8 33.027500, _S8 5.995750, _S8 33.027500,
	8, _S8 5.995750, _S8 33.027500, _S8 48.195751, _S8 25.427500, _S8 50.995751, _S8 24.427500,
	8, _S8 53.795750, _S8 23.427500, _S8 75.632248, _S8 24.864000, _S8 75.632248, _S8 24.864000,
	4, _S8 74.395752, _S8 19.518499,
	8, _S8 58.195751, _S8 7.918250, _S8 55.195751, _S8 15.027500, _S8 51.795750, _S8 14.027500,
	8, _S8 48.395748, _S8 13.027500, _S8 48.995751, _S8 15.427500, _S8 48.195751, _S8 15.627500,
	8, _S8 47.395748, _S8 15.827500, _S8 37.595749, _S8 9.627500, _S8 35.995751, _S8 9.827500,
	0
};

/* path_data24 ===========================================*/
signed char path_data24[] = {
	2, _S8 36.323002, _S8 10.263750,
	8, _S8 34.723000, _S8 10.463750, _S8 28.229250, _S8 4.602750, _S8 32.123001, _S8 12.463750,
	8, _S8 37.423000, _S8 23.163999, _S8 17.523001, _S8 22.264000, _S8 13.323000, _S8 19.464001,
	8, _S8 9.123000, _S8 16.663999, _S8 15.123000, _S8 24.063999, _S8 15.123000, _S8 24.063999,
	8, _S8 19.723000, _S8 29.063999, _S8 11.123000, _S8 24.864000, _S8 11.123000, _S8 24.864000,
	8, _S8 2.523000, _S8 21.663999, _S8 -3.477000, _S8 28.063999, _S8 -4.277000, _S8 28.264000,
	8, _S8 -5.077000, _S8 28.464001, _S8 -6.277000, _S8 29.264000, _S8 -6.477000, _S8 27.663999,
	8, _S8 -6.677000, _S8 26.063999, _S8 -8.226250, _S8 22.308000, _S8 -16.476999, _S8 28.464001,
	8, _S8 -24.568251, _S8 34.477749, _S8 -27.245500, _S8 30.341250, _S8 -27.245500, _S8 30.341250,
	4, _S8 -28.945500, _S8 29.514000,
	8, _S8 -32.145500, _S8 23.714001, _S8 -29.913500, _S8 37.536751, _S8 -29.913500, _S8 37.536751,
	8, _S8 -27.713499, _S8 46.136749, _S8 6.323000, _S8 33.464001, _S8 6.323000, _S8 33.464001,
	8, _S8 6.323000, _S8 33.464001, _S8 48.523251, _S8 25.864000, _S8 51.323250, _S8 24.864000,
	8, _S8 54.123249, _S8 23.864000, _S8 75.741249, _S8 25.282000, _S8 75.741249, _S8 25.282000,
	4, _S8 74.523247, _S8 19.809250,
	8, _S8 58.323002, _S8 8.209250, _S8 55.523251, _S8 15.464000, _S8 52.123249, _S8 14.464000,
	8, _S8 48.723251, _S8 13.463750, _S8 49.323250, _S8 15.864000, _S8 48.523251, _S8 16.063999,
	8, _S8 47.723000, _S8 16.264000, _S8 37.923000, _S8 10.063750, _S8 36.323002, _S8 10.263750,
	0
};

/* path_data25 ===========================================*/
signed char path_data25[] = {
	2, _S8 -28.950001, _S8 29.900250,
	8, _S8 -32.150002, _S8 24.400000, _S8 -29.750000, _S8 38.300251, _S8 -29.750000, _S8 38.300251,
	8, _S8 -27.549999, _S8 46.900250, _S8 6.650000, _S8 33.900250, _S8 6.650000, _S8 33.900250,
	8, _S8 6.650000, _S8 33.900250, _S8 48.850250, _S8 26.299999, _S8 51.650250, _S8 25.299999,
	8, _S8 54.450249, _S8 24.299999, _S8 75.850250, _S8 25.700001, _S8 75.850250, _S8 25.700001,
	4, _S8 74.650253, _S8 20.100001,
	8, _S8 58.450249, _S8 8.500000, _S8 55.850250, _S8 15.900000, _S8 52.450249, _S8 14.900000,
	8, _S8 49.050251, _S8 13.900000, _S8 49.650250, _S8 16.299999, _S8 48.850250, _S8 16.500000,
	8, _S8 48.050251, _S8 16.700001, _S8 38.250252, _S8 10.500000, _S8 36.650250, _S8 10.700000,
	8, _S8 35.050251, _S8 10.900000, _S8 28.745251, _S8 4.948250, _S8 32.450249, _S8 12.900000,
	8, _S8 38.007000, _S8 24.826750, _S8 17.260250, _S8 22.306749, _S8 13.650000, _S8 19.900000,
	8, _S8 9.450000, _S8 17.100001, _S8 15.450000, _S8 24.500000, _S8 15.450000, _S8 24.500000,
	8, _S8 20.049999, _S8 29.500250, _S8 11.450000, _S8 25.299999, _S8 11.450000, _S8 25.299999,
	8, _S8 2.850000, _S8 22.100001, _S8 -3.150000, _S8 28.500250, _S8 -3.950000, _S8 28.700251,
	8, _S8 -4.750000, _S8 28.900250, _S8 -5.950000, _S8 29.700251, _S8 -6.150000, _S8 28.100250,
	8, _S8 -6.350000, _S8 26.500000, _S8 -7.866250, _S8 22.785999, _S8 -16.150000, _S8 28.900250,
	8, _S8 -24.549999, _S8 35.100250, _S8 -27.150000, _S8 31.100250, _S8 -27.150000, _S8 31.100250,
	4, _S8 -28.950001, _S8 29.900250,
	0
};

/* path_data26 ===========================================*/
signed char path_data26[] = {
	2, _S8 -18.549999, _S8 37.400250,
	8, _S8 -18.549999, _S8 37.400250, _S8 -20.350001, _S8 40.300251, _S8 -15.150000, _S8 43.600250,
	8, _S8 -15.150000, _S8 43.600250, _S8 -14.800000, _S8 43.950249, _S8 -19.299999, _S8 42.900250,
	8, _S8 -19.299999, _S8 42.900250, _S8 -20.850001, _S8 42.400250, _S8 -21.250000, _S8 39.800251,
	8, _S8 -21.250000, _S8 39.800251, _S8 -22.450001, _S8 38.700249, _S8 -23.650000, _S8 37.300251,
	8, _S8 -24.850001, _S8 35.900250, _S8 -18.549999, _S8 37.400250, _S8 -18.549999, _S8 37.400250,
	0
};

/* path_data27 ===========================================*/
signed char path_data27[] = {
	2, _S8 16.450001, _S8 25.500000,
	8, _S8 16.450001, _S8 25.500000, _S8 20.874500, _S8 32.205250, _S8 20.725001, _S8 33.400250,
	8, _S8 20.400000, _S8 36.000252, _S8 20.350001, _S8 38.400250, _S8 21.150000, _S8 39.400250,
	8, _S8 21.950251, _S8 40.400250, _S8 24.150250, _S8 48.700249, _S8 24.150250, _S8 48.700249,
	8, _S8 24.150250, _S8 48.700249, _S8 24.050249, _S8 49.000252, _S8 27.150250, _S8 39.500252,
	8, _S8 27.150250, _S8 39.500252, _S8 30.050249, _S8 35.500252, _S8 25.050249, _S8 30.900250,
	8, _S8 25.050249, _S8 30.900250, _S8 16.250000, _S8 23.700001, _S8 16.450001, _S8 25.500000,
	0
};

/* path_data28 ===========================================*/
signed char path_data28[] = {
	2, _S8 -13.550000, _S8 44.100250,
	8, _S8 -13.550000, _S8 44.100250, _S8 -10.750000, _S8 45.900250, _S8 -14.350001, _S8 53.700249,
	4, _S8 -12.750000, _S8 53.100250,
	8, _S8 -12.750000, _S8 53.100250, _S8 -12.950000, _S8 55.900250, _S8 -13.750000, _S8 56.500252,
	4, _S8 -11.950000, _S8 55.700249,
	8, _S8 -11.950000, _S8 55.700249, _S8 -10.750000, _S8 57.700249, _S8 -11.750000, _S8 58.900250,
	8, _S8 -11.750000, _S8 58.900250, _S8 -7.550000, _S8 60.900250, _S8 -7.750000, _S8 62.500252,
	8, _S8 -7.750000, _S8 62.500252, _S8 -6.150000, _S8 60.500252, _S8 -7.150000, _S8 58.900250,
	8, _S8 -8.149999, _S8 57.300251, _S8 -9.950000, _S8 58.300251, _S8 -9.750000, _S8 53.700249,
	4, _S8 -11.950000, _S8 54.500252,
	8, _S8 -11.950000, _S8 54.500252, _S8 -10.550000, _S8 52.300251, _S8 -10.550000, _S8 50.700249,
	4, _S8 -12.550000, _S8 51.300251,
	8, _S8 -12.550000, _S8 51.300251, _S8 -8.682750, _S8 44.655750, _S8 -11.350001, _S8 44.300251,
	8, _S8 -12.850001, _S8 44.100250, _S8 -13.550000, _S8 44.100250, _S8 -13.550000, _S8 44.100250,
	0
};

/* path_data29 ===========================================*/
signed char path_data29[] = {
	2, _S8 -5.450000, _S8 48.300251,
	8, _S8 -5.450000, _S8 48.300251, _S8 -4.750000, _S8 47.200249, _S8 -5.450000, _S8 47.400250,
	8, _S8 -6.150000, _S8 47.600250, _S8 -13.950000, _S8 51.300251, _S8 -15.450000, _S8 53.700249,
	8, _S8 -15.450000, _S8 53.700249, _S8 -6.850000, _S8 47.600250, _S8 -5.450000, _S8 48.300251,
/* path_data30 ===========================================*/
	2, _S8 -2.850000, _S8 50.300251,
	8, _S8 -2.850000, _S8 50.300251, _S8 -2.150000, _S8 49.200249, _S8 -2.850000, _S8 49.400250,
	8, _S8 -3.550000, _S8 49.600250, _S8 -11.350001, _S8 53.300251, _S8 -12.850001, _S8 55.700249,
	8, _S8 -12.850001, _S8 55.700249, _S8 -4.250000, _S8 49.600250, _S8 -2.850000, _S8 50.300251,
/* path_data31 ===========================================*/
	2, _S8 0.450000, _S8 46.500252,
	8, _S8 0.450000, _S8 46.500252, _S8 1.150000, _S8 45.400250, _S8 0.450000, _S8 45.600250,
	8, _S8 -0.250000, _S8 45.800251, _S8 -8.050000, _S8 49.500252, _S8 -9.550000, _S8 51.900250,
	8, _S8 -9.550000, _S8 51.900250, _S8 -0.950000, _S8 45.800251, _S8 0.450000, _S8 46.500252,
/* path_data32 ===========================================*/
	2, _S8 -5.350000, _S8 57.400250,
	8, _S8 -5.350000, _S8 57.400250, _S8 -5.350000, _S8 55.900250, _S8 -6.050000, _S8 56.100250,
	8, _S8 -6.750000, _S8 56.300251, _S8 -15.750000, _S8 60.700249, _S8 -17.250000, _S8 63.100250,
	8, _S8 -17.250000, _S8 63.100250, _S8 -6.750000, _S8 56.700249, _S8 -5.350000, _S8 57.400250,
/* path_data33 ===========================================*/
	2, _S8 -5.050000, _S8 54.700249,
	8, _S8 -5.050000, _S8 54.700249, _S8 -4.750000, _S8 53.500252, _S8 -5.450000, _S8 53.700249,
	8, _S8 -5.950000, _S8 53.700249, _S8 -12.550000, _S8 56.600250, _S8 -14.050000, _S8 59.000252,
	8, _S8 -14.050000, _S8 59.000252, _S8 -6.650000, _S8 53.600250, _S8 -5.050000, _S8 54.700249,
/* path_data34 ===========================================*/
	2, _S8 -8.649999, _S8 66.600250,
	4, _S8 -11.150000, _S8 68.500252,
	8, _S8 -11.150000, _S8 68.500252, _S8 -8.550000, _S8 66.600250, _S8 -7.650000, _S8 66.900253,
	8, _S8 -7.650000, _S8 66.900253, _S8 -9.350001, _S8 69.700249, _S8 -9.550000, _S8 71.000252,
	8, _S8 -9.550000, _S8 71.000252, _S8 -6.950000, _S8 67.800247, _S8 -5.550000, _S8 67.900253,
	8, _S8 -5.550000, _S8 67.900253, _S8 -3.650000, _S8 68.000252, _S8 -3.650000, _S8 70.700249,
	8, _S8 -3.650000, _S8 70.700249, _S8 -2.250000, _S8 68.100250, _S8 -1.450000, _S8 68.200249,
	8, _S8 -1.450000, _S8 68.200249, _S8 -1.150000, _S8 69.800247, _S8 -1.450000, _S8 71.500252,
	8, _S8 -1.450000, _S8 71.500252, _S8 -0.450000, _S8 69.600250, _S8 0.550000, _S8 70.000252,
	8, _S8 0.550000, _S8 70.000252, _S8 2.150000, _S8 69.500252, _S8 1.950000, _S8 72.400253,
	8, _S8 1.950000, _S8 72.400253, _S8 1.950000, _S8 75.000252, _S8 1.750000, _S8 75.700249,
	8, _S8 1.750000, _S8 75.700249, _S8 3.150000, _S8 69.100250, _S8 3.750000, _S8 69.000252,
	8, _S8 3.750000, _S8 69.000252, _S8 5.750000, _S8 68.700249, _S8 6.950000, _S8 70.900253,
	8, _S8 6.950000, _S8 70.900253, _S8 5.950000, _S8 69.000252, _S8 7.150000, _S8 69.500252,
	8, _S8 7.150000, _S8 69.500252, _S8 9.850001, _S8 69.900253, _S8 10.650000, _S8 71.600250,
	8, _S8 10.650000, _S8 71.600250, _S8 8.950000, _S8 68.600250, _S8 10.350001, _S8 69.400253,
	8, _S8 10.350001, _S8 69.400253, _S8 12.050000, _S8 69.400253, _S8 12.350001, _S8 71.000252,
	8, _S8 12.350001, _S8 71.000252, _S8 14.450000, _S8 76.300247, _S8 14.950000, _S8 76.700249,
	8, _S8 14.950000, _S8 76.700249, _S8 13.050000, _S8 71.300247, _S8 13.450000, _S8 71.300247,
	8, _S8 13.450000, _S8 71.300247, _S8 12.950000, _S8 68.300247, _S8 14.250000, _S8 72.000252,
	8, _S8 14.250000, _S8 72.000252, _S8 13.450000, _S8 68.500252, _S8 14.850001, _S8 68.700249,
	8, _S8 16.250000, _S8 68.900253, _S8 17.350001, _S8 71.400253, _S8 19.450001, _S8 70.800247,
	8, _S8 19.450001, _S8 70.800247, _S8 21.850250, _S8 72.200249, _S8 22.350250, _S8 54.900250,
	4, _S8 -8.649999, _S8 66.600250,
	0
};

/* path_data35 ===========================================*/
signed char path_data35[] = {
	2, _S8 -7.450000, _S8 43.400250,
	8, _S8 -7.450000, _S8 43.400250, _S8 -3.750000, _S8 41.900250, _S8 6.250000, _S8 43.400250,
	8, _S8 6.250000, _S8 43.400250, _S8 8.050000, _S8 43.500252, _S8 9.750000, _S8 41.300251,
	8, _S8 11.450000, _S8 39.100250, _S8 18.150000, _S8 37.300251, _S8 19.750000, _S8 37.800251,
	4, _S8 22.150250, _S8 39.400250,
	4, _S8 22.350250, _S8 39.700249,
	8, _S8 22.350250, _S8 39.700249, _S8 25.450251, _S8 42.300251, _S8 25.550249, _S8 44.200249,
	8, _S8 25.650250, _S8 46.100250, _S8 21.950251, _S8 58.100250, _S8 19.549999, _S8 62.100250,
	8, _S8 17.150000, _S8 66.100250, _S8 14.750000, _S8 69.200249, _S8 9.950000, _S8 68.600250,
	8, _S8 9.950000, _S8 68.600250, _S8 4.750000, _S8 67.600250, _S8 -1.650000, _S8 68.600250,
	8, _S8 -1.650000, _S8 68.600250, _S8 -8.950000, _S8 68.200249, _S8 -9.649999, _S8 66.200249,
	8, _S8 -10.350001, _S8 64.200249, _S8 -6.850000, _S8 60.400250, _S8 -6.850000, _S8 60.400250,
	8, _S8 -6.850000, _S8 60.400250, _S8 -5.750000, _S8 58.300251, _S8 -6.050000, _S8 54.700249,
	8, _S8 -6.350000, _S8 51.100250, _S8 -6.250000, _S8 44.100250, _S8 -7.450000, _S8 43.400250,
	0
};

/* path_data36 ===========================================*/
signed char path_data36[] = {
	2, _S8 -1.950000, _S8 43.900250,
	8, _S8 0.150000, _S8 48.500252, _S8 -7.250000, _S8 64.800247, _S8 -7.250000, _S8 64.800247,
	8, _S8 -7.750000, _S8 65.200249, _S8 -4.085000, _S8 66.711502, _S8 -1.550000, _S8 66.100250,
	8, _S8 1.186500, _S8 65.440750, _S8 11.250000, _S8 66.500252, _S8 11.250000, _S8 66.500252,
	8, _S8 17.150000, _S8 62.600250, _S8 20.350001, _S8 51.500252, _S8 20.350001, _S8 51.500252,
	8, _S8 20.350001, _S8 51.500252, _S8 22.950251, _S8 45.500252, _S8 18.549999, _S8 44.700249,
	8, _S8 14.150000, _S8 43.900250, _S8 -1.950000, _S8 43.900250, _S8 -1.950000, _S8 43.900250,
	0
};

/* path_data37 ===========================================*/
signed char path_data37[] = {
	2, _S8 -2.457750, _S8 51.624249,
	8, _S8 -1.626250, _S8 48.426750, _S8 -1.230250, _S8 45.476501, _S8 -1.950000, _S8 43.900250,
	8, _S8 -1.950000, _S8 43.900250, _S8 13.650000, _S8 45.500252, _S8 16.450001, _S8 40.300251,
	8, _S8 17.510250, _S8 38.331501, _S8 21.200251, _S8 46.000252, _S8 21.100001, _S8 48.400250,
	8, _S8 21.100001, _S8 48.400250, _S8 5.350000, _S8 52.000252, _S8 1.650000, _S8 49.200249,
	4, _S8 -2.457750, _S8 51.624249,
	0
};

/* path_data38 ===========================================*/
signed char path_data38[] = {
	2, _S8 -1.350000, _S8 55.700249,
	8, _S8 -1.350000, _S8 55.700249, _S8 -0.850000, _S8 57.500252, _S8 -1.450000, _S8 58.500252,
	8, _S8 -1.450000, _S8 58.500252, _S8 -1.850000, _S8 58.700249, _S8 -2.150000, _S8 58.800251,
	8, _S8 -2.150000, _S8 58.800251, _S8 -1.850000, _S8 59.700249, _S8 -0.350000, _S8 60.100250,
	8, _S8 -0.350000, _S8 60.100250, _S8 0.150000, _S8 61.200249, _S8 0.750000, _S8 61.300251,
	8, _S8 1.350000, _S8 61.400250, _S8 2.550000, _S8 62.800251, _S8 3.550000, _S8 62.500252,
	8, _S8 4.550000, _S8 62.200249, _S8 7.350000, _S8 61.200249, _S8 7.350000, _S8 61.200249,
	8, _S8 7.350000, _S8 61.200249, _S8 8.750000, _S8 60.400250, _S8 10.950000, _S8 61.300251,
	8, _S8 10.950000, _S8 61.300251, _S8 11.543750, _S8 61.099750, _S8 11.650000, _S8 60.100250,
	8, _S8 11.775000, _S8 58.925251, _S8 12.550000, _S8 58.000252, _S8 13.050000, _S8 57.500252,
	8, _S8 13.550000, _S8 57.000252, _S8 15.950000, _S8 53.800251, _S8 15.650000, _S8 53.700249,
	8, _S8 15.350001, _S8 53.600250, _S8 -1.350000, _S8 55.700249, _S8 -1.350000, _S8 55.700249,
	0
};

/* path_data39 ===========================================*/
signed char path_data39[] = {
	2, _S8 -2.450000, _S8 43.600250,
	8, _S8 -2.450000, _S8 43.600250, _S8 -3.150000, _S8 49.200249, _S8 -2.350000, _S8 51.300251,
	8, _S8 -1.550000, _S8 53.400250, _S8 -1.750000, _S8 53.900250, _S8 -1.950000, _S8 54.900250,
	8, _S8 -2.150000, _S8 55.900250, _S8 -1.050000, _S8 58.400250, _S8 0.350000, _S8 59.900250,
	4, _S8 3.350000, _S8 60.300251,
	8, _S8 3.350000, _S8 60.300251, _S8 7.150000, _S8 59.400250, _S8 9.450000, _S8 60.100250,
	8, _S8 9.450000, _S8 60.100250, _S8 11.698500, _S8 60.436001, _S8 12.550000, _S8 56.700249,
	8, _S8 12.550000, _S8 56.700249, _S8 13.750000, _S8 55.100250, _S8 15.550000, _S8 54.400250,
	8, _S8 17.350001, _S8 53.700249, _S8 19.150000, _S8 43.300251, _S8 18.150000, _S8 41.300251,
	8, _S8 17.150000, _S8 39.300251, _S8 13.550000, _S8 38.200249, _S8 9.550000, _S8 42.100250,
	8, _S8 5.550000, _S8 46.000252, _S8 5.050000, _S8 41.800251, _S8 -2.450000, _S8 43.600250,
	0
};

/* path_data40 ===========================================*/
signed char path_data40[] = {
	2, _S8 -2.050000, _S8 62.300251,
	8, _S8 -2.050000, _S8 62.300251, _S8 -2.250000, _S8 61.800251, _S8 -3.350000, _S8 61.700249,
	8, _S8 -3.350000, _S8 61.700249, _S8 -8.950000, _S8 60.800251, _S8 -11.050000, _S8 57.700249,
	8, _S8 -11.050000, _S8 57.700249, _S8 -12.750000, _S8 56.300251, _S8 -11.650000, _S8 59.200249,
	8, _S8 -11.650000, _S8 59.200249, _S8 -9.050000, _S8 64.300247, _S8 -7.350000, _S8 65.000252,
	8, _S8 -7.350000, _S8 65.000252, _S8 -3.250000, _S8 66.000252, _S8 -2.050000, _S8 62.300251,
	0
};

/* path_data41 ===========================================*/
signed char path_data41[] = {
	2, _S8 17.935499, _S8 46.307251,
	8, _S8 18.100250, _S8 44.330750, _S8 18.588499, _S8 42.177250, _S8 18.150000, _S8 41.300251,
	8, _S8 16.538500, _S8 38.076752, _S8 12.295250, _S8 39.423752, _S8 9.550000, _S8 42.100250,
	8, _S8 5.550000, _S8 46.000252, _S8 5.050000, _S8 41.800251, _S8 -2.450000, _S8 43.600250,
	8, _S8 -2.450000, _S8 43.600250, _S8 -2.886250, _S8 47.091000, _S8 -2.676250, _S8 49.594002,
	8, _S8 -2.676250, _S8 49.594002, _S8 6.650000, _S8 46.700249, _S8 6.850000, _S8 48.100250,
	8, _S8 6.850000, _S8 48.100250, _S8 7.250000, _S8 47.300251, _S8 9.550000, _S8 47.300251,
	8, _S8 11.850001, _S8 47.300251, _S8 17.535500, _S8 47.007252, _S8 17.935499, _S8 46.307251,
	0
};

/* path_data42 ===========================================*/
signed char path_data42[] = {
	2, _S8 7.150000, _S8 43.800251,
	8, _S8 7.150000, _S8 43.800251, _S8 8.350001, _S8 45.000252, _S8 7.450000, _S8 47.400250,
	8, _S8 7.450000, _S8 47.400250, _S8 3.850000, _S8 51.400250, _S8 4.350000, _S8 54.900250,
	0
};

/* path_data43 ===========================================*/
signed char path_data43[] = {
	2, _S8 -4.850000, _S8 65.000252,
	8, _S8 -4.850000, _S8 65.000252, _S8 -5.950000, _S8 61.800251, _S8 -3.750000, _S8 63.500252,
	8, _S8 -3.750000, _S8 63.500252, _S8 -2.550000, _S8 64.000252, _S8 -2.850000, _S8 64.400253,
	8, _S8 -3.150000, _S8 64.800247, _S8 -4.550000, _S8 65.800247, _S8 -4.850000, _S8 65.000252,
	0
};

/* path_data44 ===========================================*/
signed char path_data44[] = {
	2, _S8 -3.590000, _S8 65.300247,
	8, _S8 -3.590000, _S8 65.300247, _S8 -4.470000, _S8 62.740250, _S8 -2.710000, _S8 64.100250,
	8, _S8 -2.710000, _S8 64.100250, _S8 -1.604750, _S8 64.712250, _S8 -1.990000, _S8 64.820251,
	8, _S8 -3.130000, _S8 65.140251, _S8 -1.990000, _S8 65.780250, _S8 -3.590000, _S8 65.300247,
	0
};

/* path_data45 ===========================================*/
signed char path_data45[] = {
	2, _S8 -2.390000, _S8 65.300247,
	8, _S8 -2.390000, _S8 65.300247, _S8 -3.270000, _S8 62.740250, _S8 -1.510000, _S8 64.100250,
	8, _S8 -1.510000, _S8 64.100250, _S8 -0.416250, _S8 64.677750, _S8 -0.790000, _S8 64.820251,
	8, _S8 -1.630000, _S8 65.140251, _S8 -0.790000, _S8 65.780250, _S8 -2.390000, _S8 65.300247,
	0
};

/* path_data46 ===========================================*/
signed char path_data46[] = {
	2, _S8 -0.740000, _S8 65.350250,
	8, _S8 -0.740000, _S8 65.350250, _S8 -1.620000, _S8 62.790249, _S8 0.140000, _S8 64.150253,
	8, _S8 0.140000, _S8 64.150253, _S8 1.235750, _S8 64.733254, _S8 0.860250, _S8 64.870247,
	8, _S8 0.120000, _S8 65.140251, _S8 0.860250, _S8 65.830253, _S8 -0.740000, _S8 65.350250,
	0
};

/* path_data47 ===========================================*/
signed char path_data47[] = {
	2, _S8 0.880000, _S8 65.330253,
	8, _S8 0.880000, _S8 65.330253, _S8 0.000000, _S8 62.770249, _S8 1.760250, _S8 64.130249,
	8, _S8 1.760250, _S8 64.130249, _S8 2.720250, _S8 64.530250, _S8 2.480250, _S8 64.850250,
	8, _S8 2.240250, _S8 65.170250, _S8 2.480250, _S8 65.810249, _S8 0.880000, _S8 65.330253,
	0
};

/* path_data48 ===========================================*/
signed char path_data48[] = {
	2, _S8 2.550000, _S8 65.500252,
	8, _S8 2.550000, _S8 65.500252, _S8 1.350000, _S8 62.400250, _S8 3.650000, _S8 64.000252,
	8, _S8 3.650000, _S8 64.000252, _S8 4.850000, _S8 64.500252, _S8 4.550000, _S8 64.900253,
	8, _S8 4.250000, _S8 65.300247, _S8 4.550000, _S8 66.100250, _S8 2.550000, _S8 65.500252,
	0
};

/* path_data49 ===========================================*/
signed char path_data49[] = {
	2, _S8 -4.550000, _S8 61.200249,
	8, _S8 -4.550000, _S8 61.200249, _S8 -1.250000, _S8 60.500252, _S8 0.250000, _S8 61.300251,
	8, _S8 0.250000, _S8 61.300251, _S8 1.750000, _S8 61.600250, _S8 2.050000, _S8 61.500252,
	8, _S8 2.350000, _S8 61.400250, _S8 3.150000, _S8 61.300251, _S8 3.150000, _S8 61.300251,
/* path_data50 ===========================================*/
	2, _S8 3.950000, _S8 63.400250,
	8, _S8 3.950000, _S8 63.400250, _S8 6.950000, _S8 60.000252, _S8 9.950000, _S8 61.100250,
	8, _S8 11.704000, _S8 61.743500, _S8 11.450000, _S8 60.900250, _S8 11.650000, _S8 60.200249,
	8, _S8 11.850001, _S8 59.500252, _S8 11.900000, _S8 58.450249, _S8 13.150000, _S8 57.700249,
	0
};

/* path_data51 ===========================================*/
signed char path_data51[] = {
	2, _S8 8.250000, _S8 59.400250,
	8, _S8 8.250000, _S8 59.400250, _S8 7.250000, _S8 56.700249, _S8 6.550000, _S8 59.900250,
	8, _S8 5.850000, _S8 63.100250, _S8 5.050000, _S8 64.000252, _S8 4.650000, _S8 64.700249,
	8, _S8 4.650000, _S8 64.700249, _S8 4.650000, _S8 66.000252, _S8 6.750000, _S8 65.900253,
	8, _S8 6.750000, _S8 65.900253, _S8 9.450000, _S8 65.800247, _S8 9.550000, _S8 65.100250,
	8, _S8 9.649999, _S8 64.400253, _S8 9.250000, _S8 61.500252, _S8 8.250000, _S8 59.400250,
	0
};

/* path_data52 ===========================================*/
signed char path_data52[] = {
	2, _S8 11.750000, _S8 61.200249,
	8, _S8 11.750000, _S8 61.200249, _S8 12.650000, _S8 60.600250, _S8 13.250000, _S8 60.900250,
/* path_data53 ===========================================*/
	2, _S8 13.375000, _S8 57.100250,
	8, _S8 13.375000, _S8 57.100250, _S8 14.100001, _S8 55.875252, _S8 15.300000, _S8 55.675251,
	0
};

/* path_data54 ===========================================*/
signed char path_data54[] = {
	2, _S8 -6.450000, _S8 66.300247,
	8, _S8 -6.450000, _S8 66.300247, _S8 -1.950000, _S8 67.100250, _S8 -0.850000, _S8 66.700249,
	8, _S8 -0.850000, _S8 66.700249, _S8 1.350000, _S8 66.700249, _S8 -0.750000, _S8 67.200249,
	8, _S8 -0.750000, _S8 67.200249, _S8 -3.950000, _S8 67.200249, _S8 -5.950000, _S8 66.900253,
	8, _S8 -5.950000, _S8 66.900253, _S8 -8.850001, _S8 65.500252, _S8 -6.450000, _S8 66.300247,
	0
};

/* path_data55 ===========================================*/
signed char path_data55[] = {
	2, _S8 -2.950000, _S8 43.000252,
	8, _S8 -2.950000, _S8 43.000252, _S8 1.450000, _S8 43.000252, _S8 1.950000, _S8 43.200249,
	8, _S8 1.950000, _S8 43.200249, _S8 3.750000, _S8 50.900250, _S8 2.850000, _S8 52.800251,
	8, _S8 2.850000, _S8 52.800251, _S8 2.550000, _S8 53.500252, _S8 1.850000, _S8 52.100250,
	8, _S8 1.850000, _S8 52.100250, _S8 -2.750000, _S8 43.900250, _S8 -3.550000, _S8 43.400250,
	8, _S8 -4.350000, _S8 42.900250, _S8 -3.250000, _S8 43.000252, _S8 -2.950000, _S8 43.000252,
	0
};

/* path_data56 ===========================================*/
signed char path_data56[] = {
	2, _S8 -22.225001, _S8 42.325249,
	8, _S8 -22.225001, _S8 42.325249, _S8 -20.000000, _S8 42.750252, _S8 -16.850001, _S8 43.400250,
	8, _S8 -16.850001, _S8 43.400250, _S8 -15.650000, _S8 49.000252, _S8 -14.850001, _S8 50.200249,
	8, _S8 -14.050000, _S8 51.400250, _S8 -14.950000, _S8 51.400250, _S8 -15.850001, _S8 50.700249,
	8, _S8 -16.750000, _S8 50.000252, _S8 -20.450001, _S8 46.500252, _S8 -20.950001, _S8 45.400250,
	8, _S8 -21.450001, _S8 44.300251, _S8 -22.225001, _S8 42.325249, _S8 -22.225001, _S8 42.325249,
	0
};

/* path_data57 ===========================================*/
signed char path_data57[] = {
	2, _S8 -16.759750, _S8 43.454498,
	8, _S8 -16.759750, _S8 43.454498, _S8 -15.309750, _S8 43.841499, _S8 -15.057500, _S8 44.395249,
	8, _S8 -14.805500, _S8 44.948749, _S8 -15.358000, _S8 45.772999, _S8 -15.358000, _S8 45.772999,
	8, _S8 -15.358000, _S8 45.772999, _S8 -15.608000, _S8 46.599251, _S8 -15.908500, _S8 46.058750,
	8, _S8 -16.209000, _S8 45.518001, _S8 -16.927000, _S8 43.603001, _S8 -16.759750, _S8 43.454498,
	0
};

/* path_data58 ===========================================*/
signed char path_data58[] = {
	2, _S8 -16.750000, _S8 43.400250,
	8, _S8 -16.750000, _S8 43.400250, _S8 -15.850001, _S8 44.700249, _S8 -14.950000, _S8 44.700249,
	8, _S8 -14.050000, _S8 44.700249, _S8 -13.954500, _S8 44.597000, _S8 -13.250000, _S8 44.750252,
	8, _S8 -12.100001, _S8 45.000252, _S8 -12.200000, _S8 44.500252, _S8 -10.550000, _S8 44.800251,
	8, _S8 -9.890000, _S8 44.920250, _S8 -9.250000, _S8 44.700249, _S8 -8.550000, _S8 45.000252,
	8, _S8 -7.850000, _S8 45.300251, _S8 -7.050000, _S8 45.100250, _S8 -6.750000, _S8 44.600250,
	8, _S8 -6.450000, _S8 44.100250, _S8 -5.250000, _S8 43.050251, _S8 -5.250000, _S8 43.050251,
	8, _S8 -5.250000, _S8 43.050251, _S8 -8.450000, _S8 43.500252, _S8 -9.149999, _S8 43.700249,
	8, _S8 -9.149999, _S8 43.700249, _S8 -14.750000, _S8 44.000252, _S8 -16.750000, _S8 43.400250,
	0
};

/* path_data59 ===========================================*/
signed char path_data59[] = {
	2, _S8 -5.600000, _S8 43.450249,
	8, _S8 -5.600000, _S8 43.450249, _S8 -7.212500, _S8 44.325249, _S8 -7.312500, _S8 44.925251,
	8, _S8 -7.412500, _S8 45.525250, _S8 -6.000000, _S8 46.450249, _S8 -6.000000, _S8 46.450249,
	8, _S8 -6.000000, _S8 46.450249, _S8 -5.312500, _S8 47.600250, _S8 -5.162500, _S8 47.000252,
	8, _S8 -5.012500, _S8 46.400250, _S8 -5.400000, _S8 43.550251, _S8 -5.600000, _S8 43.450249,
	0
};

/* path_data60 ===========================================*/
signed char path_data60[] = {
	2, _S8 -14.971250, _S8 44.816250,
	8, _S8 -14.971250, _S8 44.816250, _S8 -13.219500, _S8 47.613251, _S8 -13.165250, _S8 44.810501,
	8, _S8 -13.165250, _S8 44.810501, _S8 -13.026000, _S8 44.495998, _S8 -13.466000, _S8 44.490502,
	8, _S8 -14.984750, _S8 44.471500, _S8 -14.604500, _S8 43.445999, _S8 -14.971250, _S8 44.816250,
	0
};

/* path_data61 ===========================================*/
signed char path_data61[] = {
	2, _S8 -13.176750, _S8 44.878502,
	8, _S8 -13.176750, _S8 44.878502, _S8 -11.196500, _S8 47.675251, _S8 -11.355500, _S8 44.855251,
	8, _S8 -11.355500, _S8 44.855251, _S8 -11.353750, _S8 44.772251, _S8 -11.792000, _S8 44.734001,
	8, _S8 -12.978750, _S8 44.630501, _S8 -12.892500, _S8 43.500999, _S8 -13.176750, _S8 44.878502,
	0
};

/* path_data62 ===========================================*/
signed char path_data62[] = {
	2, _S8 -11.373500, _S8 44.880501,
	8, _S8 -11.373500, _S8 44.880501, _S8 -9.383500, _S8 47.537498, _S8 -9.550750, _S8 45.120998,
	8, _S8 -9.550750, _S8 45.120998, _S8 -9.521000, _S8 44.812752, _S8 -9.934500, _S8 44.737499,
	8, _S8 -10.907500, _S8 44.561001, _S8 -10.960250, _S8 43.748749, _S8 -11.373500, _S8 44.880501,
	0
};

/* path_data63 ===========================================*/
signed char path_data63[] = {
	2, _S8 -9.654500, _S8 44.900501,
	8, _S8 -9.654500, _S8 44.900501, _S8 -7.679500, _S8 47.790749, _S8 -7.592500, _S8 45.345501,
	8, _S8 -7.592500, _S8 45.345501, _S8 -7.181500, _S8 45.000999, _S8 -7.618000, _S8 44.945499,
	8, _S8 -9.072500, _S8 44.760502, _S8 -8.873000, _S8 43.646999, _S8 -9.654500, _S8 44.900501,
	0
};

/* path_data64 ===========================================*/
signed char path_data64[] = {
	2, _S8 -18.698000, _S8 45.783001,
	4, _S8 -20.612499, _S8 45.400249,
	8, _S8 -21.262501, _S8 44.150249, _S8 -21.787500, _S8 42.612751, _S8 -21.787500, _S8 42.612751,
	8, _S8 -21.787500, _S8 42.612751, _S8 -20.200001, _S8 42.862751, _S8 -17.075001, _S8 43.562752,
	8, _S8 -17.075001, _S8 43.562752, _S8 -16.856001, _S8 44.392250, _S8 -16.488001, _S8 45.841000,
	4, _S8 -18.698000, _S8 45.783001,
	0
};

/* path_data65 ===========================================*/
signed char path_data65[] = {
	2, _S8 -2.431000, _S8 44.617500,
	8, _S8 -2.847500, _S8 43.991001, _S8 -3.176750, _S8 43.551498, _S8 -3.339250, _S8 43.450001,
	8, _S8 -4.092500, _S8 42.979252, _S8 -3.056750, _S8 43.073502, _S8 -2.774500, _S8 43.073502,
	8, _S8 -2.774500, _S8 43.073502, _S8 1.368250, _S8 43.073502, _S8 1.839000, _S8 43.261749,
	8, _S8 1.839000, _S8 43.261749, _S8 1.970000, _S8 43.822250, _S8 2.141000, _S8 44.669998,
	8, _S8 2.141000, _S8 44.669998, _S8 -0.381000, _S8 44.167500, _S8 -2.431000, _S8 44.617500,
	0
};

/* path_data66 ===========================================*/
signed char path_data66[] = {
	2, _S8 10.970000, _S8 10.080250,
	8, _S8 17.900249, _S8 11.070250, _S8 24.280251, _S8 2.160250, _S8 24.720249, _S8 -0.260000,
	8, _S8 25.160250, _S8 -2.680000, _S8 22.630251, _S8 -5.650000, _S8 22.630251, _S8 -5.650000,
	8, _S8 22.960251, _S8 -6.420000, _S8 21.750250, _S8 -9.940000, _S8 20.430250, _S8 -12.250000,
	8, _S8 19.110250, _S8 -14.560000, _S8 15.135000, _S8 -14.316500, _S8 10.750000, _S8 -14.560000,
	8, _S8 6.790000, _S8 -14.780000, _S8 2.170000, _S8 -8.950000, _S8 1.840000, _S8 -8.510000,
	8, _S8 1.510000, _S8 -8.070000, _S8 3.050000, _S8 1.500250, _S8 3.380000, _S8 2.930250,
	8, _S8 3.710000, _S8 4.360250, _S8 3.050000, _S8 10.960250, _S8 3.050000, _S8 10.960250,
	8, _S8 11.610000, _S8 8.685250, _S8 4.040000, _S8 9.090250, _S8 10.970000, _S8 10.080250,
	0
};

/* path_data67 ===========================================*/
signed char path_data67[] = {
	2, _S8 2.022000, _S8 -8.348000,
	8, _S8 1.698000, _S8 -7.916000, _S8 3.210000, _S8 1.480250, _S8 3.534000, _S8 2.884250,
	8, _S8 3.858000, _S8 4.288250, _S8 3.210000, _S8 10.768250, _S8 3.210000, _S8 10.768250,
	8, _S8 11.378000, _S8 8.548250, _S8 4.182000, _S8 8.932250, _S8 10.986000, _S8 9.904250,
	8, _S8 17.790251, _S8 10.876250, _S8 24.054251, _S8 2.128250, _S8 24.486250, _S8 -0.248000,
	8, _S8 24.918249, _S8 -2.624000, _S8 22.434250, _S8 -5.540000, _S8 22.434250, _S8 -5.540000,
	8, _S8 22.758249, _S8 -6.296000, _S8 21.570250, _S8 -9.752000, _S8 20.274250, _S8 -12.020000,
	8, _S8 18.978251, _S8 -14.288000, _S8 15.075500, _S8 -14.048750, _S8 10.770000, _S8 -14.288000,
	8, _S8 6.882000, _S8 -14.504000, _S8 2.346000, _S8 -8.780000, _S8 2.022000, _S8 -8.348000,
	0
};

/* path_data68 ===========================================*/
signed char path_data68[] = {
	2, _S8 2.204000, _S8 -8.186000,
	8, _S8 1.886000, _S8 -7.762000, _S8 3.370000, _S8 1.460250, _S8 3.688000, _S8 2.838250,
	8, _S8 4.006000, _S8 4.216250, _S8 3.370000, _S8 10.576250, _S8 3.370000, _S8 10.576250,
	8, _S8 11.221000, _S8 8.286250, _S8 4.324000, _S8 8.774250, _S8 11.002000, _S8 9.728250,
	8, _S8 17.680250, _S8 10.682250, _S8 23.828251, _S8 2.096250, _S8 24.252251, _S8 -0.236000,
	8, _S8 24.676250, _S8 -2.568000, _S8 22.238251, _S8 -5.430000, _S8 22.238251, _S8 -5.430000,
	8, _S8 22.556250, _S8 -6.172000, _S8 21.390249, _S8 -9.564000, _S8 20.118250, _S8 -11.790000,
	8, _S8 18.846251, _S8 -14.016000, _S8 15.015750, _S8 -13.781250, _S8 10.790000, _S8 -14.016000,
	8, _S8 6.974000, _S8 -14.228000, _S8 2.522000, _S8 -8.610000, _S8 2.204000, _S8 -8.186000,
	0
};

/* path_data69 ===========================================*/
signed char path_data69[] = {
	2, _S8 2.386000, _S8 -8.024000,
	8, _S8 2.074000, _S8 -7.608000, _S8 3.530000, _S8 1.440250, _S8 3.842000, _S8 2.792250,
	8, _S8 4.154000, _S8 4.144250, _S8 3.530000, _S8 10.384250, _S8 3.530000, _S8 10.384250,
	8, _S8 10.889000, _S8 8.124250, _S8 4.466000, _S8 8.616250, _S8 11.018000, _S8 9.552250,
	8, _S8 17.570250, _S8 10.488250, _S8 23.602249, _S8 2.064250, _S8 24.018250, _S8 -0.223750,
	8, _S8 24.434250, _S8 -2.512000, _S8 22.042250, _S8 -5.320000, _S8 22.042250, _S8 -5.320000,
	8, _S8 22.354250, _S8 -6.048000, _S8 21.210251, _S8 -9.376000, _S8 19.962250, _S8 -11.560000,
	8, _S8 18.714251, _S8 -13.744000, _S8 14.956000, _S8 -13.513750, _S8 10.810000, _S8 -13.744000,
	8, _S8 7.066000, _S8 -13.952000, _S8 2.698000, _S8 -8.440000, _S8 2.386000, _S8 -8.024000,
	0
};

/* path_data70 ===========================================*/
signed char path_data70[] = {
	2, _S8 2.568000, _S8 -7.862000,
	8, _S8 2.262000, _S8 -7.454000, _S8 3.690000, _S8 1.420250, _S8 3.996000, _S8 2.746250,
	8, _S8 4.302000, _S8 4.072250, _S8 3.690000, _S8 10.192250, _S8 3.690000, _S8 10.192250,
	8, _S8 10.657000, _S8 7.962250, _S8 4.608000, _S8 8.458250, _S8 11.034000, _S8 9.376250,
	8, _S8 17.460251, _S8 10.294250, _S8 23.376249, _S8 2.032250, _S8 23.784250, _S8 -0.212000,
	8, _S8 24.192249, _S8 -2.456000, _S8 21.846251, _S8 -5.210000, _S8 21.846251, _S8 -5.210000,
	8, _S8 22.152250, _S8 -5.924000, _S8 21.030251, _S8 -9.188000, _S8 19.806250, _S8 -11.330000,
	8, _S8 18.582251, _S8 -13.472000, _S8 14.896250, _S8 -13.246250, _S8 10.830000, _S8 -13.472000,
	8, _S8 7.158000, _S8 -13.676000, _S8 2.874000, _S8 -8.270000, _S8 2.568000, _S8 -7.862000,
	0
};

/* path_data71 ===========================================*/
signed char path_data71[] = {
	2, _S8 11.050000, _S8 9.200000,
	8, _S8 17.350000, _S8 10.100000, _S8 23.150249, _S8 2.000000, _S8 23.550249, _S8 -0.200000,
	8, _S8 23.950251, _S8 -2.400000, _S8 21.650249, _S8 -5.100000, _S8 21.650249, _S8 -5.100000,
	8, _S8 21.950251, _S8 -5.800000, _S8 20.850000, _S8 -9.000000, _S8 19.650000, _S8 -11.100000,
	8, _S8 18.450001, _S8 -13.200000, _S8 14.836500, _S8 -12.978500, _S8 10.850000, _S8 -13.200000,
	8, _S8 7.250000, _S8 -13.400000, _S8 3.050000, _S8 -8.100000, _S8 2.750000, _S8 -7.700000,
	8, _S8 2.450000, _S8 -7.300000, _S8 3.850000, _S8 1.400000, _S8 4.150000, _S8 2.700000,
	8, _S8 4.450000, _S8 4.000000, _S8 3.850000, _S8 10.000000, _S8 3.850000, _S8 10.000000,
	8, _S8 10.225000, _S8 7.850000, _S8 4.750000, _S8 8.300000, _S8 11.050000, _S8 9.200000,
	0
};

/* path_data72 ===========================================*/
signed char path_data72[] = {
	2, _S8 22.650249, _S8 0.700000,
	8, _S8 22.650249, _S8 0.700000, _S8 15.700000, _S8 2.600000, _S8 12.800000, _S8 2.200000,
	8, _S8 12.800000, _S8 2.200000, _S8 8.850000, _S8 0.550000, _S8 6.650000, _S8 6.000000,
	8, _S8 6.650000, _S8 6.000000, _S8 5.750000, _S8 7.800000, _S8 5.250000, _S8 8.300000,
	8, _S8 4.750000, _S8 8.800000, _S8 22.650249, _S8 0.700000, _S8 22.650249, _S8 0.700000,
	0
};

/* path_data73 ===========================================*/
signed char path_data73[] = {
	2, _S8 23.600250, _S8 0.150000,
	8, _S8 23.600250, _S8 0.150000, _S8 16.350000, _S8 3.200000, _S8 13.850000, _S8 3.100000,
	8, _S8 13.850000, _S8 3.100000, _S8 9.750000, _S8 1.950000, _S8 7.650000, _S8 5.600000,
	8, _S8 7.650000, _S8 5.600000, _S8 5.550000, _S8 7.900000, _S8 4.750000, _S8 8.300000,
	8, _S8 4.750000, _S8 8.300000, _S8 4.650000, _S8 8.700000, _S8 6.250000, _S8 7.700000,
	4, _S8 8.850000, _S8 9.000000,
	8, _S8 8.850000, _S8 9.000000, _S8 12.550000, _S8 11.400000, _S8 14.950000, _S8 7.400000,
	8, _S8 14.950000, _S8 7.400000, _S8 15.950000, _S8 4.600000, _S8 15.950000, _S8 4.100000,
	8, _S8 15.950000, _S8 3.600000, _S8 21.250000, _S8 2.200000, _S8 21.650249, _S8 2.100000,
	8, _S8 22.050249, _S8 2.000000, _S8 23.700251, _S8 0.950000, _S8 23.600250, _S8 0.150000,
	0
};

/* path_data74 ===========================================*/
signed char path_data74[] = {
	2, _S8 11.750000, _S8 9.128500,
	8, _S8 10.032000, _S8 9.128500, _S8 7.938750, _S8 8.162250, _S8 7.938750, _S8 6.600000,
	8, _S8 7.938750, _S8 5.038000, _S8 10.032000, _S8 3.471750, _S8 11.750000, _S8 3.471750,
	8, _S8 13.468500, _S8 3.471750, _S8 14.861500, _S8 4.738000, _S8 14.861500, _S8 6.300000,
	8, _S8 14.861500, _S8 7.862250, _S8 13.468500, _S8 9.128500, _S8 11.750000, _S8 9.128500,
	0
};

/* path_data75 ===========================================*/
signed char path_data75[] = {
	2, _S8 10.844250, _S8 4.957500,
	8, _S8 9.632750, _S8 5.138000, _S8 8.360500, _S8 5.513750, _S8 8.378500, _S8 5.459750,
	8, _S8 8.763500, _S8 4.305000, _S8 10.353750, _S8 3.471750, _S8 11.750000, _S8 3.471750,
	8, _S8 12.824000, _S8 3.471750, _S8 13.771000, _S8 3.966250, _S8 14.330000, _S8 4.718750,
	8, _S8 14.330000, _S8 4.718750, _S8 13.001000, _S8 4.636250, _S8 10.844250, _S8 4.957500,
	0
};

/* path_data76 ===========================================*/
signed char path_data76[] = {
	2, _S8 13.850000, _S8 4.900000,
	8, _S8 13.850000, _S8 4.900000, _S8 12.750000, _S8 4.100000, _S8 12.750000, _S8 4.650000,
	8, _S8 12.750000, _S8 4.650000, _S8 13.650000, _S8 5.750000, _S8 13.850000, _S8 4.900000,
	0
};

/* path_data77 ===========================================*/
signed char path_data77[] = {
	2, _S8 11.350000, _S8 6.931500,
	8, _S8 10.725250, _S8 6.931500, _S8 10.218750, _S8 6.425000, _S8 10.218750, _S8 5.800000,
	8, _S8 10.218750, _S8 5.175250, _S8 10.725250, _S8 4.668750, _S8 11.350000, _S8 4.668750,
	8, _S8 11.975000, _S8 4.668750, _S8 12.481500, _S8 5.175250, _S8 12.481500, _S8 5.800000,
	8, _S8 12.481500, _S8 6.425000, _S8 11.975000, _S8 6.931500, _S8 11.350000, _S8 6.931500,
	0
};

/* path_data78 ===========================================*/
signed char path_data78[] = {
	2, _S8 -14.650000, _S8 3.600000,
	8, _S8 -14.650000, _S8 3.600000, _S8 -15.450000, _S8 -1.700000, _S8 -14.850000, _S8 -2.800000,
	8, _S8 -14.850000, _S8 -2.800000, _S8 -12.150000, _S8 -5.300000, _S8 -12.250000, _S8 -6.200000,
	8, _S8 -12.250000, _S8 -6.200000, _S8 -12.350000, _S8 -10.700000, _S8 -12.650000, _S8 -10.900000,
	8, _S8 -12.950000, _S8 -11.100000, _S8 -14.850000, _S8 -12.600000, _S8 -16.350000, _S8 -11.000000,
	8, _S8 -16.350000, _S8 -11.000000, _S8 -18.950001, _S8 -6.500000, _S8 -18.750000, _S8 -4.900000,
	4, _S8 -18.750000, _S8 -4.400000,
	8, _S8 -18.750000, _S8 -4.400000, _S8 -20.650000, _S8 -4.500000, _S8 -21.049999, _S8 -4.000000,
	8, _S8 -21.049999, _S8 -4.000000, _S8 -21.350000, _S8 -2.700000, _S8 -21.650000, _S8 -2.600000,
	8, _S8 -21.650000, _S8 -2.600000, _S8 -22.350000, _S8 -2.000000, _S8 -21.850000, _S8 -1.300000,
	8, _S8 -21.850000, _S8 -1.300000, _S8 -22.350000, _S8 -0.700000, _S8 -22.250000, _S8 0.300000,
	4, _S8 -20.350000, _S8 1.300000,
	8, _S8 -20.350000, _S8 1.300000, _S8 -19.850000, _S8 4.900000, _S8 -17.150000, _S8 6.200000,
	8, _S8 -15.941000, _S8 6.782250, _S8 -15.150000, _S8 5.100000, _S8 -14.650000, _S8 3.600000,
	0
};

/* path_data79 ===========================================*/
signed char path_data79[] = {
	2, _S8 -14.900000, _S8 3.140000,
	8, _S8 -14.900000, _S8 3.140000, _S8 -15.620000, _S8 -1.630000, _S8 -15.080000, _S8 -2.620000,
	8, _S8 -15.080000, _S8 -2.620000, _S8 -12.650000, _S8 -4.870000, _S8 -12.740000, _S8 -5.680000,
	8, _S8 -12.740000, _S8 -5.680000, _S8 -12.830000, _S8 -9.730000, _S8 -13.100000, _S8 -9.910000,
	8, _S8 -13.370000, _S8 -10.090000, _S8 -15.080000, _S8 -11.440000, _S8 -16.430000, _S8 -10.000000,
	8, _S8 -16.430000, _S8 -10.000000, _S8 -18.770000, _S8 -5.950000, _S8 -18.590000, _S8 -4.510000,
	4, _S8 -18.590000, _S8 -4.060000,
	8, _S8 -18.590000, _S8 -4.060000, _S8 -20.299999, _S8 -4.150000, _S8 -20.660000, _S8 -3.700000,
	8, _S8 -20.660000, _S8 -3.700000, _S8 -20.930000, _S8 -2.530000, _S8 -21.200001, _S8 -2.440000,
	8, _S8 -21.200001, _S8 -2.440000, _S8 -21.830000, _S8 -1.900000, _S8 -21.379999, _S8 -1.270000,
	8, _S8 -21.379999, _S8 -1.270000, _S8 -21.830000, _S8 -0.730000, _S8 -21.740000, _S8 0.170000,
	4, _S8 -20.030001, _S8 1.070000,
	8, _S8 -20.030001, _S8 1.070000, _S8 -19.580000, _S8 4.310000, _S8 -17.150000, _S8 5.480000,
	8, _S8 -16.062000, _S8 6.003750, _S8 -15.350000, _S8 4.490000, _S8 -14.900000, _S8 3.140000,
	0
};

/* path_data80 ===========================================*/
signed char path_data80[] = {
	2, _S8 -12.762500, _S8 -10.652500,
	8, _S8 -13.035000, _S8 -10.867500, _S8 -14.907500, _S8 -12.310000, _S8 -16.370001, _S8 -10.750000,
	8, _S8 -16.370001, _S8 -10.750000, _S8 -18.905001, _S8 -6.362500, _S8 -18.709999, _S8 -4.802500,
	4, _S8 -18.709999, _S8 -4.315000,
	8, _S8 -18.709999, _S8 -4.315000, _S8 -20.562500, _S8 -4.412500, _S8 -20.952499, _S8 -3.925000,
	8, _S8 -20.952499, _S8 -3.925000, _S8 -21.245001, _S8 -2.657500, _S8 -21.537500, _S8 -2.560000,
	8, _S8 -21.537500, _S8 -2.560000, _S8 -22.219999, _S8 -1.975000, _S8 -21.732500, _S8 -1.292500,
	8, _S8 -21.732500, _S8 -1.292500, _S8 -22.219999, _S8 -0.707500, _S8 -22.122499, _S8 0.267500,
	4, _S8 -20.270000, _S8 1.242500,
	8, _S8 -20.270000, _S8 1.242500, _S8 -19.782499, _S8 4.752500, _S8 -17.150000, _S8 6.020000,
	8, _S8 -15.971500, _S8 6.587500, _S8 -15.200000, _S8 4.947500, _S8 -14.712500, _S8 3.485000,
	8, _S8 -14.712500, _S8 3.485000, _S8 -15.492500, _S8 -1.682500, _S8 -14.907500, _S8 -2.755000,
	8, _S8 -14.907500, _S8 -2.755000, _S8 -12.275000, _S8 -5.192500, _S8 -12.372500, _S8 -6.070000,
	8, _S8 -12.372500, _S8 -6.070000, _S8 -12.470000, _S8 -10.457500, _S8 -12.762500, _S8 -10.652500,
	0
};

/* path_data81 ===========================================*/
signed char path_data81[] = {
	2, _S8 -12.875000, _S8 -10.405000,
	8, _S8 -13.120000, _S8 -10.635000, _S8 -14.965000, _S8 -12.020000, _S8 -16.389999, _S8 -10.500000,
	8, _S8 -16.389999, _S8 -10.500000, _S8 -18.860001, _S8 -6.225000, _S8 -18.670000, _S8 -4.705000,
	4, _S8 -18.670000, _S8 -4.230000,
	8, _S8 -18.670000, _S8 -4.230000, _S8 -20.475000, _S8 -4.325000, _S8 -20.855000, _S8 -3.850000,
	8, _S8 -20.855000, _S8 -3.850000, _S8 -21.139999, _S8 -2.615000, _S8 -21.424999, _S8 -2.520000,
	8, _S8 -21.424999, _S8 -2.520000, _S8 -22.090000, _S8 -1.950000, _S8 -21.615000, _S8 -1.285000,
	8, _S8 -21.615000, _S8 -1.285000, _S8 -22.090000, _S8 -0.715000, _S8 -21.995001, _S8 0.235000,
	4, _S8 -20.190001, _S8 1.185000,
	8, _S8 -20.190001, _S8 1.185000, _S8 -19.715000, _S8 4.605000, _S8 -17.150000, _S8 5.840000,
	8, _S8 -16.001499, _S8 6.393000, _S8 -15.250000, _S8 4.795000, _S8 -14.775000, _S8 3.370000,
	8, _S8 -14.775000, _S8 3.370000, _S8 -15.535000, _S8 -1.665000, _S8 -14.965000, _S8 -2.710000,
	8, _S8 -14.965000, _S8 -2.710000, _S8 -12.400000, _S8 -5.085000, _S8 -12.495000, _S8 -5.940000,
	8, _S8 -12.495000, _S8 -5.940000, _S8 -12.590000, _S8 -10.215000, _S8 -12.875000, _S8 -10.405000,
	0
};

/* path_data82 ===========================================*/
signed char path_data82[] = {
	2, _S8 -12.987500, _S8 -10.157500,
	8, _S8 -13.205000, _S8 -10.402500, _S8 -15.022500, _S8 -11.730000, _S8 -16.410000, _S8 -10.250000,
	8, _S8 -16.410000, _S8 -10.250000, _S8 -18.815001, _S8 -6.087500, _S8 -18.629999, _S8 -4.607500,
	4, _S8 -18.629999, _S8 -4.145000,
	8, _S8 -18.629999, _S8 -4.145000, _S8 -20.387501, _S8 -4.237500, _S8 -20.757500, _S8 -3.775000,
	8, _S8 -20.757500, _S8 -3.775000, _S8 -21.035000, _S8 -2.572500, _S8 -21.312500, _S8 -2.480000,
	8, _S8 -21.312500, _S8 -2.480000, _S8 -21.959999, _S8 -1.925000, _S8 -21.497499, _S8 -1.277500,
	8, _S8 -21.497499, _S8 -1.277500, _S8 -21.959999, _S8 -0.722500, _S8 -21.867500, _S8 0.202500,
	4, _S8 -20.110001, _S8 1.127500,
	8, _S8 -20.110001, _S8 1.127500, _S8 -19.647499, _S8 4.457500, _S8 -17.150000, _S8 5.660000,
	8, _S8 -16.031750, _S8 6.198500, _S8 -15.300000, _S8 4.642500, _S8 -14.837500, _S8 3.255000,
	8, _S8 -14.837500, _S8 3.255000, _S8 -15.577500, _S8 -1.647500, _S8 -15.022500, _S8 -2.665000,
	8, _S8 -15.022500, _S8 -2.665000, _S8 -12.525000, _S8 -4.977500, _S8 -12.617500, _S8 -5.810000,
	8, _S8 -12.617500, _S8 -5.810000, _S8 -12.710000, _S8 -9.972500, _S8 -12.987500, _S8 -10.157500,
	0
};

/* path_data83 ===========================================*/
signed char path_data83[] = {
	2, _S8 -14.900000, _S8 3.115000,
	8, _S8 -14.900000, _S8 3.115000, _S8 -15.620000, _S8 -1.630000, _S8 -15.080000, _S8 -2.620000,
	8, _S8 -15.080000, _S8 -2.620000, _S8 -12.650000, _S8 -4.870000, _S8 -12.740000, _S8 -5.680000,
	8, _S8 -12.740000, _S8 -5.680000, _S8 -12.830000, _S8 -9.730000, _S8 -13.100000, _S8 -9.910000,
	8, _S8 -13.290000, _S8 -10.170000, _S8 -15.080000, _S8 -11.440000, _S8 -16.430000, _S8 -10.000000,
	8, _S8 -16.430000, _S8 -10.000000, _S8 -18.770000, _S8 -5.950000, _S8 -18.590000, _S8 -4.510000,
	4, _S8 -18.590000, _S8 -4.060000,
	8, _S8 -18.590000, _S8 -4.060000, _S8 -20.299999, _S8 -4.150000, _S8 -20.660000, _S8 -3.700000,
	8, _S8 -20.660000, _S8 -3.700000, _S8 -20.930000, _S8 -2.530000, _S8 -21.200001, _S8 -2.440000,
	8, _S8 -21.200001, _S8 -2.440000, _S8 -21.830000, _S8 -1.900000, _S8 -21.379999, _S8 -1.270000,
	8, _S8 -21.379999, _S8 -1.270000, _S8 -21.830000, _S8 -0.730000, _S8 -21.740000, _S8 0.170000,
	4, _S8 -20.030001, _S8 1.070000,
	8, _S8 -20.030001, _S8 1.070000, _S8 -19.580000, _S8 4.310000, _S8 -17.150000, _S8 5.480000,
	8, _S8 -16.062000, _S8 6.003750, _S8 -15.350000, _S8 4.465000, _S8 -14.900000, _S8 3.115000,
	0
};

/* path_data84 ===========================================*/
signed char path_data84[] = {
	2, _S8 -15.675000, _S8 1.550000,
	8, _S8 -15.675000, _S8 1.550000, _S8 -21.075001, _S8 -1.000000, _S8 -21.299999, _S8 -1.200000,
	8, _S8 -21.299999, _S8 -1.200000, _S8 -19.025000, _S8 0.850000, _S8 -18.825001, _S8 0.850000,
	8, _S8 -18.625000, _S8 0.850000, _S8 -15.675000, _S8 1.550000, _S8 -15.675000, _S8 1.550000,
	0
};

/* path_data85 ===========================================*/
signed char path_data85[] = {
	2, _S8 -19.950001, _S8 0.000000,
	8, _S8 -19.950001, _S8 0.000000, _S8 -15.350000, _S8 0.900000, _S8 -15.350000, _S8 2.000000,
	8, _S8 -15.350000, _S8 2.728000, _S8 -15.410750, _S8 6.082750, _S8 -16.750000, _S8 5.700000,
	8, _S8 -18.850000, _S8 5.100000, _S8 -17.950001, _S8 1.500000, _S8 -19.950001, _S8 0.000000,
	0
};

/* path_data86 ===========================================*/
signed char path_data86[] = {
	2, _S8 -17.850000, _S8 0.950000,
	8, _S8 -17.850000, _S8 0.950000, _S8 -15.605500, _S8 1.318500, _S8 -15.350000, _S8 2.000000,
	8, _S8 -15.200000, _S8 2.400000, _S8 -15.034250, _S8 4.477000, _S8 -16.400000, _S8 4.750000,
	8, _S8 -17.538000, _S8 4.977750, _S8 -18.095501, _S8 2.422500, _S8 -17.850000, _S8 0.950000,
	0
};

/* path_data87 ===========================================*/
signed char path_data87[] = {
	2, _S8 3.648750, _S8 11.587250,
	8, _S8 3.524500, _S8 11.151750, _S8 3.852250, _S8 11.184500, _S8 4.300000, _S8 11.050000,
	8, _S8 4.800000, _S8 10.900000, _S8 7.850000, _S8 9.950000, _S8 8.050000, _S8 9.300000,
	8, _S8 8.250000, _S8 8.650000, _S8 11.550000, _S8 9.750000, _S8 11.550000, _S8 9.750000,
	8, _S8 12.000000, _S8 9.950000, _S8 13.100000, _S8 10.600000, _S8 13.100000, _S8 10.600000,
	8, _S8 14.300000, _S8 10.900000, _S8 15.950000, _S8 11.000000, _S8 15.950000, _S8 11.000000,
	8, _S8 16.549999, _S8 11.250000, _S8 17.400000, _S8 11.950000, _S8 17.400000, _S8 11.950000,
	8, _S8 21.049999, _S8 14.500000, _S8 24.150249, _S8 12.700000, _S8 24.150249, _S8 12.700000,
	8, _S8 29.150249, _S8 11.050000, _S8 27.650249, _S8 6.750000, _S8 27.650249, _S8 6.750000,
	8, _S8 26.900249, _S8 4.500000, _S8 27.700251, _S8 3.650000, _S8 27.700251, _S8 3.650000,
	8, _S8 27.750250, _S8 2.700000, _S8 29.550249, _S8 4.300000, _S8 29.550249, _S8 4.300000,
	8, _S8 30.200251, _S8 5.350000, _S8 30.400249, _S8 6.600000, _S8 30.400249, _S8 6.600000,
	8, _S8 32.400249, _S8 9.400000, _S8 31.550249, _S8 4.950000, _S8 31.550249, _S8 4.950000,
	8, _S8 31.600250, _S8 4.700000, _S8 30.900249, _S8 3.800000, _S8 30.900249, _S8 3.500000,
	8, _S8 30.900249, _S8 3.200000, _S8 30.450251, _S8 2.350000, _S8 30.450251, _S8 2.350000,
	8, _S8 29.700251, _S8 1.500000, _S8 30.300249, _S8 -0.250000, _S8 30.300249, _S8 -0.250000,
	8, _S8 30.750250, _S8 -3.700000, _S8 30.200251, _S8 -3.250000, _S8 30.200251, _S8 -3.250000,
	8, _S8 29.900249, _S8 -3.700000, _S8 27.600250, _S8 -1.200000, _S8 27.600250, _S8 -1.200000,
	8, _S8 27.050249, _S8 -0.350000, _S8 25.550249, _S8 0.050000, _S8 25.550249, _S8 0.050000,
	8, _S8 24.850250, _S8 0.500000, _S8 24.000250, _S8 0.150000, _S8 24.000250, _S8 0.150000,
	8, _S8 23.350250, _S8 0.050000, _S8 21.950251, _S8 1.800000, _S8 21.950251, _S8 1.800000,
	8, _S8 22.650249, _S8 1.750000, _S8 23.250250, _S8 2.850000, _S8 23.850250, _S8 2.900000,
	8, _S8 24.450251, _S8 2.950000, _S8 24.900249, _S8 2.300000, _S8 25.300249, _S8 2.150000,
	8, _S8 25.700251, _S8 2.000000, _S8 26.400249, _S8 3.450000, _S8 26.400249, _S8 3.450000,
	8, _S8 26.500250, _S8 4.100000, _S8 25.100250, _S8 5.300000, _S8 25.100250, _S8 5.300000,
	8, _S8 25.000250, _S8 6.450000, _S8 24.600250, _S8 6.050000, _S8 24.600250, _S8 6.050000,
	8, _S8 23.850250, _S8 5.900000, _S8 23.550249, _S8 6.850000, _S8 23.300249, _S8 8.000000,
	8, _S8 23.050249, _S8 9.150000, _S8 22.000250, _S8 9.250000, _S8 22.000250, _S8 9.250000,
	8, _S8 21.600250, _S8 11.100000, _S8 21.299999, _S8 10.350000, _S8 21.299999, _S8 10.350000,
	8, _S8 21.250000, _S8 8.950000, _S8 19.750000, _S8 10.400000, _S8 19.750000, _S8 10.400000,
	8, _S8 19.450001, _S8 10.900000, _S8 18.299999, _S8 10.350000, _S8 18.299999, _S8 10.350000,
	8, _S8 16.600000, _S8 9.850000, _S8 17.200001, _S8 9.350000, _S8 17.200001, _S8 9.350000,
	8, _S8 17.650000, _S8 8.800000, _S8 20.450001, _S8 9.350000, _S8 20.450001, _S8 9.350000,
	8, _S8 21.000000, _S8 8.950000, _S8 19.000000, _S8 7.950000, _S8 19.000000, _S8 7.950000,
	8, _S8 18.850000, _S8 7.500000, _S8 19.100000, _S8 6.400000, _S8 19.100000, _S8 6.400000,
	8, _S8 19.400000, _S8 5.600000, _S8 21.100000, _S8 4.200000, _S8 21.100000, _S8 4.200000,
	8, _S8 23.450251, _S8 3.900000, _S8 22.750250, _S8 3.500000, _S8 22.750250, _S8 3.500000,
	8, _S8 21.200251, _S8 2.200000, _S8 19.750000, _S8 4.100000, _S8 19.750000, _S8 4.100000,
	8, _S8 19.200001, _S8 5.650000, _S8 14.850000, _S8 9.400000, _S8 14.850000, _S8 9.400000,
	8, _S8 13.650000, _S8 10.250000, _S8 14.300000, _S8 8.550000, _S8 13.300000, _S8 9.400000,
	8, _S8 12.300000, _S8 10.250000, _S8 7.150000, _S8 8.000000, _S8 7.150000, _S8 8.000000,
	8, _S8 4.259500, _S8 7.701750, _S8 3.576500, _S8 11.637250, _S8 2.694250, _S8 10.857250,
	8, _S8 2.694250, _S8 10.857250, _S8 4.048750, _S8 12.987250, _S8 3.648750, _S8 11.587250,
/* path_data88 ===========================================*/
	2, _S8 52.350250, _S8 -30.000000,
	8, _S8 52.350250, _S8 -30.000000, _S8 45.950249, _S8 -28.000000, _S8 45.250252, _S8 -23.299999,
	8, _S8 45.250252, _S8 -23.299999, _S8 44.650249, _S8 -17.600000, _S8 49.750252, _S8 -13.200000,
	8, _S8 49.750252, _S8 -13.200000, _S8 49.850250, _S8 -11.600000, _S8 50.350250, _S8 -10.800000,
	8, _S8 50.350250, _S8 -10.800000, _S8 49.950249, _S8 -9.600000, _S8 54.650249, _S8 -11.500000,
	4, _S8 61.450249, _S8 -13.600000,
	8, _S8 61.450249, _S8 -13.600000, _S8 63.050251, _S8 -14.200000, _S8 64.350250, _S8 -16.400000,
	8, _S8 65.650253, _S8 -18.600000, _S8 69.450249, _S8 -23.299999, _S8 68.550247, _S8 -29.600000,
	8, _S8 68.550247, _S8 -29.600000, _S8 68.850250, _S8 -32.400002, _S8 67.350250, _S8 -32.500000,
	8, _S8 67.350250, _S8 -32.500000, _S8 65.250252, _S8 -32.900002, _S8 63.450249, _S8 -31.000000,
	8, _S8 63.450249, _S8 -31.000000, _S8 61.750252, _S8 -30.200001, _S8 61.150249, _S8 -30.299999,
	4, _S8 52.350250, _S8 -30.000000,
	0
};

/* path_data89 ===========================================*/
signed char path_data89[] = {
	2, _S8 66.005501, _S8 -30.247499,
	8, _S8 66.005501, _S8 -30.247499, _S8 66.530502, _S8 -32.480000, _S8 65.320503, _S8 -31.270000,
	8, _S8 65.320503, _S8 -31.270000, _S8 63.560501, _S8 -29.840000, _S8 61.690250, _S8 -29.840000,
	8, _S8 61.690250, _S8 -29.840000, _S8 58.060249, _S8 -29.290001, _S8 56.960251, _S8 -25.990000,
	8, _S8 56.960251, _S8 -25.990000, _S8 55.970249, _S8 -19.280001, _S8 57.950249, _S8 -17.850000,
	8, _S8 57.950249, _S8 -17.850000, _S8 59.160252, _S8 -15.980000, _S8 60.920250, _S8 -17.629999,
	8, _S8 62.680500, _S8 -19.280001, _S8 66.555496, _S8 -26.837500, _S8 66.005501, _S8 -30.247499,
	0
};

/* path_data90 ===========================================*/
signed char path_data90[] = {
	2, _S8 65.912003, _S8 -30.158001,
	8, _S8 65.912003, _S8 -30.158001, _S8 66.434502, _S8 -32.344002, _S8 65.246498, _S8 -31.156000,
	8, _S8 65.246498, _S8 -31.156000, _S8 63.518501, _S8 -29.752001, _S8 61.682251, _S8 -29.752001,
	8, _S8 61.682251, _S8 -29.752001, _S8 58.118252, _S8 -29.212000, _S8 57.038250, _S8 -25.972000,
	8, _S8 57.038250, _S8 -25.972000, _S8 56.066250, _S8 -19.384001, _S8 58.010250, _S8 -17.980000,
	8, _S8 58.010250, _S8 -17.980000, _S8 59.198250, _S8 -16.143999, _S8 60.926250, _S8 -17.764000,
	8, _S8 62.654499, _S8 -19.384001, _S8 66.452003, _S8 -26.809999, _S8 65.912003, _S8 -30.158001,
	0
};

/* path_data91 ===========================================*/
signed char path_data91[] = {
	2, _S8 65.818497, _S8 -30.068501,
	8, _S8 65.818497, _S8 -30.068501, _S8 66.338501, _S8 -32.208000, _S8 65.172501, _S8 -31.042000,
	8, _S8 65.172501, _S8 -31.042000, _S8 63.476501, _S8 -29.664000, _S8 61.674252, _S8 -29.664000,
	8, _S8 61.674252, _S8 -29.664000, _S8 58.176250, _S8 -29.134001, _S8 57.116249, _S8 -25.954000,
	8, _S8 57.116249, _S8 -25.954000, _S8 56.162251, _S8 -19.488001, _S8 58.070251, _S8 -18.110001,
	8, _S8 58.070251, _S8 -18.110001, _S8 59.236252, _S8 -16.308001, _S8 60.932251, _S8 -17.898001,
	8, _S8 62.628502, _S8 -19.488001, _S8 66.348503, _S8 -26.782499, _S8 65.818497, _S8 -30.068501,
	0
};

/* path_data92 ===========================================*/
signed char path_data92[] = {
	2, _S8 65.724998, _S8 -29.979000,
	8, _S8 65.724998, _S8 -29.979000, _S8 66.242500, _S8 -32.071999, _S8 65.098503, _S8 -30.927999,
	8, _S8 65.098503, _S8 -30.927999, _S8 63.434502, _S8 -29.576000, _S8 61.666248, _S8 -29.576000,
	8, _S8 61.666248, _S8 -29.576000, _S8 58.234249, _S8 -29.056000, _S8 57.194248, _S8 -25.936001,
	8, _S8 57.194248, _S8 -25.936001, _S8 56.258251, _S8 -19.591999, _S8 58.130249, _S8 -18.240000,
	8, _S8 58.130249, _S8 -18.240000, _S8 59.274250, _S8 -16.472000, _S8 60.938251, _S8 -18.032000,
	8, _S8 62.602501, _S8 -19.591999, _S8 66.245003, _S8 -26.754999, _S8 65.724998, _S8 -29.979000,
	0
};

/* path_data93 ===========================================*/
signed char path_data93[] = {
	2, _S8 65.631500, _S8 -29.889500,
	8, _S8 65.631500, _S8 -29.889500, _S8 66.146500, _S8 -31.936001, _S8 65.024498, _S8 -30.813999,
	8, _S8 65.024498, _S8 -30.813999, _S8 63.392250, _S8 -29.488001, _S8 61.658249, _S8 -29.488001,
	8, _S8 61.658249, _S8 -29.488001, _S8 58.292252, _S8 -28.978001, _S8 57.272251, _S8 -25.917999,
	8, _S8 57.272251, _S8 -25.917999, _S8 56.354252, _S8 -19.695999, _S8 58.190250, _S8 -18.370001,
	8, _S8 58.190250, _S8 -18.370001, _S8 59.312248, _S8 -16.636000, _S8 60.944248, _S8 -18.166000,
	8, _S8 62.576248, _S8 -19.695999, _S8 66.141502, _S8 -26.727501, _S8 65.631500, _S8 -29.889500,
	0
};

/* path_data94 ===========================================*/
signed char path_data94[] = {
	2, _S8 65.537750, _S8 -29.799999,
	8, _S8 65.537750, _S8 -29.799999, _S8 66.050247, _S8 -31.799999, _S8 64.950249, _S8 -30.700001,
	8, _S8 64.950249, _S8 -30.700001, _S8 63.350250, _S8 -29.400000, _S8 61.650249, _S8 -29.400000,
	8, _S8 61.650249, _S8 -29.400000, _S8 58.350250, _S8 -28.900000, _S8 57.350250, _S8 -25.900000,
	8, _S8 57.350250, _S8 -25.900000, _S8 56.450249, _S8 -19.799999, _S8 58.250252, _S8 -18.500000,
	8, _S8 58.250252, _S8 -18.500000, _S8 59.350250, _S8 -16.799999, _S8 60.950249, _S8 -18.299999,
	8, _S8 62.550251, _S8 -19.799999, _S8 66.037750, _S8 -26.700001, _S8 65.537750, _S8 -29.799999,
	0
};

/* path_data95 ===========================================*/
signed char path_data95[] = {
	2, _S8 12.650000, _S8 21.000000,
	8, _S8 12.650000, _S8 21.000000, _S8 7.550000, _S8 16.200001, _S8 5.550000, _S8 16.000000,
	8, _S8 5.550000, _S8 16.000000, _S8 -3.050000, _S8 15.000000, _S8 -6.750000, _S8 19.500000,
	8, _S8 -6.750000, _S8 19.500000, _S8 -2.350000, _S8 14.400000, _S8 4.550000, _S8 15.800000,
	8, _S8 4.550000, _S8 15.800000, _S8 -0.850000, _S8 14.700000, _S8 -3.950000, _S8 15.500000,
	8, _S8 -3.950000, _S8 15.500000, _S8 -8.150000, _S8 15.500000, _S8 -10.550000, _S8 19.000000,
	4, _S8 -11.250000, _S8 20.200001,
	8, _S8 -11.250000, _S8 20.200001, _S8 -10.250000, _S8 16.500000, _S8 -5.650000, _S8 15.000000,
	8, _S8 -5.650000, _S8 15.000000, _S8 0.050000, _S8 13.800000, _S8 2.750000, _S8 15.000000,
	8, _S8 2.750000, _S8 15.000000, _S8 -2.650000, _S8 13.300000, _S8 -5.150000, _S8 13.800000,
	8, _S8 -5.150000, _S8 13.800000, _S8 -12.750000, _S8 13.200000, _S8 -15.950000, _S8 19.799999,
	8, _S8 -15.950000, _S8 19.799999, _S8 -14.950000, _S8 16.200001, _S8 -11.250000, _S8 14.400000,
	8, _S8 -11.250000, _S8 14.400000, _S8 -7.850000, _S8 12.200000, _S8 -2.750000, _S8 12.900000,
	8, _S8 -2.750000, _S8 12.900000, _S8 0.850000, _S8 13.700000, _S8 2.150000, _S8 14.300000,
	8, _S8 3.450000, _S8 14.900000, _S8 3.150000, _S8 14.200000, _S8 1.050000, _S8 13.000000,
	8, _S8 1.050000, _S8 13.000000, _S8 -0.350000, _S8 10.500000, _S8 -3.850000, _S8 10.600000,
	8, _S8 -3.850000, _S8 10.600000, _S8 -14.550000, _S8 11.500000, _S8 -17.150000, _S8 14.500000,
	8, _S8 -17.150000, _S8 14.500000, _S8 -13.750000, _S8 11.700000, _S8 -11.150000, _S8 11.000000,
	8, _S8 -11.150000, _S8 11.000000, _S8 -5.550000, _S8 9.000000, _S8 -3.450000, _S8 9.200000,
	8, _S8 -3.450000, _S8 9.200000, _S8 2.750000, _S8 9.450000, _S8 4.650000, _S8 8.450000,
	8, _S8 4.650000, _S8 8.450000, _S8 1.850000, _S8 9.700000, _S8 2.650000, _S8 10.500000,
	8, _S8 3.450000, _S8 11.300000, _S8 5.150000, _S8 13.200000, _S8 5.150000, _S8 13.500000,
	8, _S8 5.150000, _S8 13.800000, _S8 11.200000, _S8 19.325001, _S8 12.100000, _S8 20.424999,
	4, _S8 12.650000, _S8 21.000000,
	0
};

/* path_data96 ===========================================*/
signed char path_data96[] = {
	2, _S8 47.250000, _S8 69.500000,
	8, _S8 47.250000, _S8 69.500000, _S8 43.375000, _S8 60.375000, _S8 40.250000, _S8 58.000000,
	8, _S8 40.250000, _S8 58.000000, _S8 46.750000, _S8 62.000000, _S8 47.625000, _S8 66.500000,
	8, _S8 47.625000, _S8 66.500000, _S8 47.625000, _S8 69.000000, _S8 47.250000, _S8 69.500000,
/* path_data97 ===========================================*/
	2, _S8 59.000000, _S8 71.375000,
	8, _S8 59.000000, _S8 71.375000, _S8 52.375000, _S8 57.625000, _S8 47.750000, _S8 51.625000,
	8, _S8 47.750000, _S8 51.625000, _S8 58.625000, _S8 61.000000, _S8 59.875000, _S8 67.625000,
	4, _S8 60.000000, _S8 69.000000,
	4, _S8 59.250000, _S8 68.375000,
	8, _S8 59.250000, _S8 68.375000, _S8 59.125000, _S8 70.625000, _S8 59.000000, _S8 71.375000,
/* path_data98 ===========================================*/
	2, _S8 73.125000, _S8 59.250000,
	8, _S8 73.125000, _S8 59.250000, _S8 57.500000, _S8 44.375000, _S8 57.125000, _S8 43.750000,
	8, _S8 57.125000, _S8 43.750000, _S8 72.250000, _S8 60.250000, _S8 73.000000, _S8 62.125000,
	8, _S8 73.000000, _S8 62.125000, _S8 72.500000, _S8 59.875000, _S8 73.125000, _S8 59.250000,
/* path_data99 ===========================================*/
	2, _S8 26.000000, _S8 70.125000,
	8, _S8 26.000000, _S8 70.125000, _S8 30.875000, _S8 57.125000, _S8 35.625000, _S8 62.750000,
	8, _S8 35.625000, _S8 62.750000, _S8 39.375000, _S8 65.250000, _S8 39.250000, _S8 66.000000,
	8, _S8 39.250000, _S8 66.000000, _S8 38.250000, _S8 64.375000, _S8 33.750000, _S8 64.500000,
	8, _S8 33.750000, _S8 64.500000, _S8 29.000000, _S8 63.750000, _S8 26.000000, _S8 70.125000,
/* path_data100 ===========================================*/
	2, _S8 73.625000, _S8 38.250000,
	8, _S8 73.625000, _S8 38.250000, _S8 62.375000, _S8 31.125000, _S8 60.500000, _S8 30.750000,
	8, _S8 57.548248, _S8 30.159750, _S8 72.875000, _S8 38.000000, _S8 74.125000, _S8 40.625000,
	8, _S8 74.125000, _S8 40.625000, _S8 74.625000, _S8 40.000000, _S8 73.625000, _S8 38.250000,
	0
};

/* path_data101 ===========================================*/
signed char path_data101[] = {
	2, _S8 35.950249, _S8 64.900253,
	8, _S8 35.950249, _S8 64.900253, _S8 41.050251, _S8 64.400253, _S8 42.750252, _S8 62.700249,
	4, _S8 43.850250, _S8 63.600250,
	4, _S8 48.250252, _S8 54.000252,
	4, _S8 49.150249, _S8 55.300251,
	8, _S8 49.150249, _S8 55.300251, _S8 52.750252, _S8 51.600250, _S8 52.550251, _S8 49.600250,
	8, _S8 52.350250, _S8 47.600250, _S8 55.750252, _S8 51.100250, _S8 55.750252, _S8 51.100250,
	8, _S8 55.750252, _S8 51.100250, _S8 55.550251, _S8 48.200249, _S8 57.350250, _S8 49.900249,
	8, _S8 57.350250, _S8 49.900249, _S8 56.750252, _S8 46.000252, _S8 58.850250, _S8 48.000252,
	8, _S8 58.850250, _S8 48.000252, _S8 56.216000, _S8 40.460999, _S8 61.850250, _S8 46.900249,
	8, _S8 63.250252, _S8 48.500252, _S8 62.150249, _S8 46.800251, _S8 62.150249, _S8 46.800251,
	8, _S8 62.150249, _S8 46.800251, _S8 55.650249, _S8 34.800251, _S8 61.050251, _S8 38.400249,
	8, _S8 61.050251, _S8 38.400249, _S8 61.550251, _S8 32.700249, _S8 61.250252, _S8 31.600250,
	8, _S8 60.950249, _S8 30.500250, _S8 60.450249, _S8 24.900000, _S8 59.250252, _S8 23.600000,
	8, _S8 58.050251, _S8 22.299999, _S8 59.350250, _S8 21.900000, _S8 60.750252, _S8 23.200001,
	8, _S8 60.750252, _S8 23.200001, _S8 57.950249, _S8 17.200001, _S8 61.250252, _S8 20.200001,
	8, _S8 61.250252, _S8 20.200001, _S8 60.350250, _S8 16.400000, _S8 59.250252, _S8 15.700000,
	8, _S8 59.250252, _S8 15.700000, _S8 57.850250, _S8 11.400000, _S8 61.650249, _S8 14.100000,
	8, _S8 61.650249, _S8 14.100000, _S8 60.550251, _S8 11.000000, _S8 59.750252, _S8 10.200000,
	8, _S8 59.750252, _S8 10.200000, _S8 56.850250, _S8 3.300000, _S8 58.650249, _S8 4.500000,
	4, _S8 59.750252, _S8 5.400000,
	8, _S8 59.750252, _S8 5.400000, _S8 58.050251, _S8 1.900000, _S8 59.650249, _S8 3.000000,
	8, _S8 61.250252, _S8 4.100000, _S8 61.250252, _S8 4.000000, _S8 61.250252, _S8 4.000000,
	8, _S8 61.250252, _S8 4.000000, _S8 55.950249, _S8 -4.300000, _S8 61.050251, _S8 0.100000,
	8, _S8 61.050251, _S8 0.100000, _S8 59.010502, _S8 -3.379500, _S8 58.150249, _S8 -5.100000,
	8, _S8 58.150249, _S8 -5.100000, _S8 53.450249, _S8 -10.200000, _S8 57.050251, _S8 -8.600000,
	4, _S8 58.250252, _S8 -8.200000,
	8, _S8 58.250252, _S8 -8.200000, _S8 56.050251, _S8 -10.700000, _S8 54.050251, _S8 -11.100000,
	8, _S8 52.050251, _S8 -11.500000, _S8 54.650249, _S8 -13.100000, _S8 56.250252, _S8 -12.600000,
	8, _S8 57.850250, _S8 -12.100000, _S8 61.750252, _S8 -10.200000, _S8 61.750252, _S8 -10.200000,
	8, _S8 61.750252, _S8 -10.200000, _S8 64.950249, _S8 -5.500000, _S8 65.950249, _S8 -5.400000,
	8, _S8 65.950249, _S8 -5.400000, _S8 60.950249, _S8 -7.300000, _S8 62.450249, _S8 -5.300000,
	8, _S8 62.450249, _S8 -5.300000, _S8 66.050247, _S8 -1.800000, _S8 64.250252, _S8 -1.900000,
	8, _S8 64.250252, _S8 -1.900000, _S8 62.750252, _S8 -0.100000, _S8 63.950249, _S8 2.100000,
	8, _S8 63.950249, _S8 2.100000, _S8 59.335499, _S8 -2.497750, _S8 63.050251, _S8 3.900000,
	4, _S8 64.750252, _S8 8.000000,
	8, _S8 64.750252, _S8 8.000000, _S8 58.650249, _S8 1.800000, _S8 61.450249, _S8 7.300000,
	8, _S8 61.450249, _S8 7.300000, _S8 65.750252, _S8 13.200000, _S8 66.250252, _S8 13.300000,
	8, _S8 66.750252, _S8 13.400000, _S8 67.850250, _S8 15.600000, _S8 67.850250, _S8 15.600000,
	4, _S8 66.750252, _S8 15.100000,
	4, _S8 68.050247, _S8 17.299999,
	8, _S8 68.050247, _S8 17.299999, _S8 65.250252, _S8 14.300000, _S8 66.750252, _S8 17.600000,
	4, _S8 68.150253, _S8 21.200001,
	8, _S8 68.150253, _S8 21.200001, _S8 63.050251, _S8 15.700000, _S8 66.450249, _S8 23.100000,
	8, _S8 66.450249, _S8 23.100000, _S8 62.350250, _S8 21.799999, _S8 64.550247, _S8 26.100000,
	8, _S8 64.550247, _S8 26.100000, _S8 64.150253, _S8 30.100250, _S8 64.250252, _S8 31.400249,
	8, _S8 64.350250, _S8 32.700249, _S8 64.650253, _S8 39.800251, _S8 63.550251, _S8 41.800251,
	8, _S8 62.450249, _S8 43.800251, _S8 65.050247, _S8 48.600250, _S8 65.550247, _S8 49.600250,
	8, _S8 66.050247, _S8 50.600250, _S8 66.950249, _S8 53.300251, _S8 64.750252, _S8 51.000252,
	8, _S8 62.550251, _S8 48.700249, _S8 63.650249, _S8 50.100250, _S8 64.150253, _S8 52.300251,
	8, _S8 64.650253, _S8 54.500252, _S8 66.150253, _S8 58.400249, _S8 65.950249, _S8 59.800251,
	8, _S8 65.950249, _S8 59.800251, _S8 65.650253, _S8 60.100250, _S8 64.850250, _S8 59.200249,
	8, _S8 64.850250, _S8 59.200249, _S8 61.150249, _S8 53.500252, _S8 61.550251, _S8 57.100250,
	8, _S8 61.550251, _S8 57.100250, _S8 61.250252, _S8 59.100250, _S8 60.450249, _S8 61.300251,
	8, _S8 60.450249, _S8 61.300251, _S8 59.650249, _S8 64.000252, _S8 59.650249, _S8 61.800251,
	8, _S8 59.650249, _S8 61.800251, _S8 58.850250, _S8 57.600250, _S8 58.150249, _S8 59.500252,
	8, _S8 57.450249, _S8 61.400249, _S8 56.550251, _S8 62.900249, _S8 55.850250, _S8 63.500252,
	8, _S8 55.150249, _S8 64.100250, _S8 53.850250, _S8 58.400249, _S8 53.550251, _S8 61.000252,
	8, _S8 53.550251, _S8 61.000252, _S8 50.550251, _S8 57.900249, _S8 49.350250, _S8 62.000252,
	4, _S8 46.450249, _S8 66.100250,
	8, _S8 46.450249, _S8 66.100250, _S8 46.350250, _S8 63.000252, _S8 46.050251, _S8 64.500252,
	8, _S8 46.050251, _S8 64.500252, _S8 38.550251, _S8 66.000252, _S8 35.950249, _S8 64.900253,
/* path_data102 ===========================================*/
	2, _S8 27.350250, _S8 -24.299999,
	8, _S8 27.350250, _S8 -24.299999, _S8 24.450251, _S8 -26.299999, _S8 23.450251, _S8 -26.200001,
	8, _S8 22.450251, _S8 -26.100000, _S8 30.350250, _S8 -28.400000, _S8 40.650249, _S8 -21.500000,
	8, _S8 40.650249, _S8 -21.500000, _S8 41.850250, _S8 -20.799999, _S8 42.750252, _S8 -20.900000,
	8, _S8 42.750252, _S8 -20.900000, _S8 43.550251, _S8 -20.299999, _S8 42.850250, _S8 -19.400000,
	8, _S8 42.850250, _S8 -19.400000, _S8 40.650249, _S8 -17.000000, _S8 43.450249, _S8 -14.200000,
	8, _S8 43.450249, _S8 -14.200000, _S8 48.050251, _S8 -12.500000, _S8 46.650249, _S8 -14.700000,
	8, _S8 46.650249, _S8 -14.700000, _S8 49.350250, _S8 -13.700000, _S8 49.950249, _S8 -12.700000,
	8, _S8 50.550251, _S8 -11.700000, _S8 50.250252, _S8 -12.700000, _S8 50.250252, _S8 -12.700000,
	8, _S8 50.250252, _S8 -12.700000, _S8 48.650249, _S8 -14.500000, _S8 47.150249, _S8 -15.800000,
	8, _S8 47.150249, _S8 -15.800000, _S8 45.850250, _S8 -16.299999, _S8 45.150249, _S8 -18.400000,
	8, _S8 44.450249, _S8 -20.500000, _S8 43.850250, _S8 -23.000000, _S8 44.950249, _S8 -23.799999,
	8, _S8 44.950249, _S8 -23.799999, _S8 43.950249, _S8 -22.700001, _S8 44.150249, _S8 -23.700001,
	8, _S8 44.350250, _S8 -24.700001, _S8 45.250252, _S8 -25.600000, _S8 45.650249, _S8 -25.700001,
	8, _S8 46.050251, _S8 -25.799999, _S8 50.150249, _S8 -29.750000, _S8 51.850250, _S8 -29.850000,
	8, _S8 51.850250, _S8 -29.850000, _S8 49.550251, _S8 -29.500000, _S8 48.800251, _S8 -29.750000,
	8, _S8 48.050251, _S8 -30.000000, _S8 41.400249, _S8 -32.849998, _S8 39.900249, _S8 -33.150002,
	8, _S8 39.900249, _S8 -33.150002, _S8 35.700249, _S8 -34.799999, _S8 38.700249, _S8 -34.299999,
	8, _S8 38.700249, _S8 -34.299999, _S8 47.650249, _S8 -33.349998, _S8 52.200249, _S8 -30.049999,
	8, _S8 52.200249, _S8 -30.049999, _S8 50.400249, _S8 -32.150002, _S8 45.800251, _S8 -33.900002,
	8, _S8 45.800251, _S8 -33.900002, _S8 40.250252, _S8 -37.049999, _S8 31.450251, _S8 -35.799999,
	8, _S8 31.450251, _S8 -35.799999, _S8 27.000250, _S8 -35.000000, _S8 25.050249, _S8 -34.549999,
	8, _S8 25.050249, _S8 -34.549999, _S8 24.400249, _S8 -34.700001, _S8 24.250250, _S8 -34.799999,
	8, _S8 24.100250, _S8 -34.900002, _S8 21.150000, _S8 -37.150002, _S8 14.250000, _S8 -35.400002,
	8, _S8 14.250000, _S8 -35.400002, _S8 10.000000, _S8 -34.250000, _S8 7.850000, _S8 -33.049999,
	8, _S8 7.850000, _S8 -33.049999, _S8 4.050000, _S8 -32.750000, _S8 3.150000, _S8 -31.950001,
	8, _S8 3.150000, _S8 -31.950001, _S8 -1.500000, _S8 -28.299999, _S8 -2.000000, _S8 -28.100000,
	8, _S8 -2.500000, _S8 -27.900000, _S8 -5.350000, _S8 -26.000000, _S8 -5.550000, _S8 -25.900000,
	8, _S8 -5.550000, _S8 -25.900000, _S8 0.600000, _S8 -27.549999, _S8 1.200000, _S8 -28.150000,
	8, _S8 1.800000, _S8 -28.750000, _S8 6.150000, _S8 -29.400000, _S8 6.750000, _S8 -29.049999,
	8, _S8 7.350000, _S8 -28.700001, _S8 9.450000, _S8 -28.850000, _S8 7.050000, _S8 -28.700001,
	8, _S8 7.050000, _S8 -28.700001, _S8 25.950251, _S8 -25.000000, _S8 26.150249, _S8 -24.500000,
	8, _S8 26.350250, _S8 -24.000000, _S8 27.350250, _S8 -24.299999, _S8 27.350250, _S8 -24.299999,
	0
};

/* path_data103 ===========================================*/
signed char path_data103[] = {
	2, _S8 45.200249, _S8 -26.600000,
	8, _S8 45.200249, _S8 -26.600000, _S8 42.650249, _S8 -28.450001, _S8 42.150249, _S8 -28.450001,
	8, _S8 41.650249, _S8 -28.450001, _S8 38.550251, _S8 -31.000000, _S8 37.500252, _S8 -30.900000,
	8, _S8 36.450249, _S8 -30.799999, _S8 33.400249, _S8 -33.299999, _S8 26.550249, _S8 -31.250000,
	8, _S8 26.550249, _S8 -31.250000, _S8 26.400249, _S8 -31.750000, _S8 27.300249, _S8 -31.950001,
	8, _S8 27.300249, _S8 -31.950001, _S8 28.900249, _S8 -32.500000, _S8 29.000250, _S8 -32.650002,
	8, _S8 29.000250, _S8 -32.650002, _S8 34.050251, _S8 -33.700001, _S8 35.850250, _S8 -32.799999,
	8, _S8 35.850250, _S8 -32.799999, _S8 38.150249, _S8 -32.150002, _S8 39.700249, _S8 -30.600000,
	8, _S8 39.700249, _S8 -30.600000, _S8 42.500252, _S8 -29.799999, _S8 43.300251, _S8 -30.049999,
	8, _S8 43.300251, _S8 -30.049999, _S8 45.500252, _S8 -29.500000, _S8 45.600250, _S8 -29.049999,
	8, _S8 45.600250, _S8 -29.049999, _S8 47.050251, _S8 -28.299999, _S8 46.600250, _S8 -27.650000,
	8, _S8 46.600250, _S8 -27.650000, _S8 46.700249, _S8 -27.250000, _S8 45.200249, _S8 -26.600000,
/* path_data104 ===========================================*/
	2, _S8 42.082500, _S8 -27.127251,
	8, _S8 42.284248, _S8 -26.969250, _S8 42.539001, _S8 -26.944750, _S8 42.690250, _S8 -26.742500,
	8, _S8 42.748749, _S8 -26.664000, _S8 42.676498, _S8 -26.582500, _S8 42.597752, _S8 -26.558250,
	8, _S8 42.337002, _S8 -26.479000, _S8 42.073002, _S8 -26.621500, _S8 41.787498, _S8 -26.474501,
	8, _S8 41.687000, _S8 -26.422750, _S8 41.526501, _S8 -26.468250, _S8 41.388248, _S8 -26.505501,
	8, _S8 40.980251, _S8 -26.615749, _S8 40.522999, _S8 -26.622000, _S8 40.100250, _S8 -26.450001,
	8, _S8 39.604000, _S8 -26.732250, _S8 39.014000, _S8 -26.586250, _S8 38.493752, _S8 -26.836500,
	8, _S8 38.479252, _S8 -26.843250, _S8 38.423752, _S8 -26.756750, _S8 38.405251, _S8 -26.763500,
	8, _S8 37.643749, _S8 -27.049749, _S8 36.708000, _S8 -26.979000, _S8 36.100250, _S8 -27.549999,
	8, _S8 35.493252, _S8 -27.653000, _S8 34.903999, _S8 -27.768499, _S8 34.297001, _S8 -27.938499,
	8, _S8 33.842499, _S8 -28.065750, _S8 33.490250, _S8 -28.313000, _S8 33.085251, _S8 -28.521000,
	8, _S8 32.741001, _S8 -28.698000, _S8 32.376751, _S8 -28.828501, _S8 31.993250, _S8 -28.921499,
	8, _S8 31.527500, _S8 -29.034500, _S8 31.069750, _S8 -29.006500, _S8 30.596500, _S8 -29.136499,
	8, _S8 30.573250, _S8 -29.142750, _S8 30.525249, _S8 -29.056749, _S8 30.504749, _S8 -29.063499,
	8, _S8 30.423750, _S8 -29.090500, _S8 30.351250, _S8 -29.236250, _S8 30.308500, _S8 -29.223000,
	8, _S8 29.888250, _S8 -29.092501, _S8 29.516251, _S8 -29.335501, _S8 29.100250, _S8 -29.250000,
	8, _S8 28.805750, _S8 -29.556000, _S8 28.373751, _S8 -29.494749, _S8 27.987249, _S8 -29.605249,
	8, _S8 27.246250, _S8 -29.817249, _S8 26.457750, _S8 -29.499750, _S8 25.700251, _S8 -29.750000,
	8, _S8 26.728500, _S8 -30.210501, _S8 27.900249, _S8 -29.902500, _S8 28.915751, _S8 -30.419750,
	8, _S8 29.497749, _S8 -30.716249, _S8 30.163250, _S8 -30.440750, _S8 30.805750, _S8 -30.630751,
	8, _S8 30.927500, _S8 -30.666750, _S8 31.100250, _S8 -30.717251, _S8 31.200251, _S8 -30.549999,
	8, _S8 31.233749, _S8 -30.583750, _S8 31.279249, _S8 -30.643499, _S8 31.293751, _S8 -30.636499,
	8, _S8 31.906250, _S8 -30.347250, _S8 32.485001, _S8 -30.028749, _S8 33.105499, _S8 -29.762251,
	8, _S8 33.190750, _S8 -29.725750, _S8 33.323750, _S8 -29.783751, _S8 33.386749, _S8 -29.733250,
	8, _S8 33.766750, _S8 -29.429251, _S8 34.252499, _S8 -29.455000, _S8 34.600250, _S8 -29.150000,
	8, _S8 35.024750, _S8 -29.275499, _S8 35.473000, _S8 -29.180500, _S8 35.905251, _S8 -29.336500,
	8, _S8 35.924500, _S8 -29.343250, _S8 35.983002, _S8 -29.257999, _S8 35.991249, _S8 -29.263500,
	8, _S8 36.273750, _S8 -29.450500, _S8 36.562500, _S8 -29.382750, _S8 36.785500, _S8 -29.306749,
	8, _S8 36.869999, _S8 -29.278000, _S8 37.035751, _S8 -29.216249, _S8 37.112000, _S8 -29.197750,
	8, _S8 37.393501, _S8 -29.128750, _S8 37.607498, _S8 -29.008751, _S8 37.902248, _S8 -28.962999,
	8, _S8 37.930752, _S8 -28.958500, _S8 37.977001, _S8 -29.043501, _S8 37.994999, _S8 -29.036501,
	8, _S8 38.275749, _S8 -28.927000, _S8 38.536251, _S8 -28.941000, _S8 38.700249, _S8 -28.650000,
	8, _S8 38.734001, _S8 -28.683750, _S8 38.775249, _S8 -28.743250, _S8 38.795750, _S8 -28.736500,
	8, _S8 39.052502, _S8 -28.652000, _S8 39.214748, _S8 -28.463249, _S8 39.490002, _S8 -28.403000,
	8, _S8 39.611252, _S8 -28.376499, _S8 39.764252, _S8 -28.219999, _S8 39.908249, _S8 -28.176001,
	8, _S8 40.506248, _S8 -27.993250, _S8 40.966999, _S8 -27.611000, _S8 41.515499, _S8 -27.387251,
	8, _S8 41.705250, _S8 -27.309750, _S8 41.924252, _S8 -27.251249, _S8 42.082500, _S8 -27.127251,
/* path_data105 ===========================================*/
	2, _S8 22.924000, _S8 -30.684750,
	8, _S8 22.294500, _S8 -31.115999, _S8 21.702499, _S8 -31.392500, _S8 21.091999, _S8 -31.839001,
	8, _S8 21.046749, _S8 -31.872250, _S8 20.956751, _S8 -31.829750, _S8 20.906250, _S8 -31.860250,
	8, _S8 20.654499, _S8 -32.012501, _S8 20.432501, _S8 -32.157749, _S8 20.187000, _S8 -32.331749,
	8, _S8 20.052250, _S8 -32.427250, _S8 19.847000, _S8 -32.424500, _S8 19.719999, _S8 -32.488998,
	8, _S8 19.084000, _S8 -32.812000, _S8 18.426750, _S8 -32.951500, _S8 17.799999, _S8 -33.250000,
	8, _S8 17.970501, _S8 -33.409500, _S8 18.250999, _S8 -33.348499, _S8 18.400000, _S8 -33.549999,
	8, _S8 18.448750, _S8 -33.480000, _S8 18.508249, _S8 -33.409000, _S8 18.596500, _S8 -33.456749,
	8, _S8 19.016001, _S8 -33.682751, _S8 19.478500, _S8 -33.721001, _S8 19.897499, _S8 -33.698502,
	8, _S8 20.323500, _S8 -33.675499, _S8 20.753500, _S8 -33.599251, _S8 21.197250, _S8 -33.531250,
	8, _S8 21.274000, _S8 -33.519501, _S8 21.323750, _S8 -33.388748, _S8 21.404499, _S8 -33.364498,
	8, _S8 21.961500, _S8 -33.198750, _S8 22.558750, _S8 -33.330002, _S8 23.088499, _S8 -33.120499,
	8, _S8 23.486250, _S8 -32.963249, _S8 23.878750, _S8 -32.757500, _S8 24.188499, _S8 -32.438751,
	8, _S8 24.251499, _S8 -32.373749, _S8 24.170250, _S8 -32.298500, _S8 24.100250, _S8 -32.250000,
	8, _S8 24.197250, _S8 -32.277248, _S8 24.265499, _S8 -32.225750, _S8 24.293249, _S8 -32.147499,
	8, _S8 24.314251, _S8 -32.087749, _S8 24.314251, _S8 -32.012249, _S8 24.293249, _S8 -31.952499,
	8, _S8 24.265249, _S8 -31.874500, _S8 24.195499, _S8 -31.849251, _S8 24.101999, _S8 -31.836500,
	8, _S8 23.750250, _S8 -31.789000, _S8 24.193251, _S8 -32.133999, _S8 24.018250, _S8 -32.021999,
	8, _S8 23.700001, _S8 -31.818501, _S8 23.886499, _S8 -31.466999, _S8 23.700251, _S8 -31.150000,
	8, _S8 23.630251, _S8 -31.198500, _S8 23.572750, _S8 -31.253000, _S8 23.600250, _S8 -31.350000,
	8, _S8 23.658751, _S8 -31.219500, _S8 23.508249, _S8 -31.146999, _S8 23.466249, _S8 -31.068001,
	8, _S8 23.370001, _S8 -30.886749, _S8 23.145250, _S8 -30.533001, _S8 22.924000, _S8 -30.684750,
/* path_data106 ===========================================*/
	2, _S8 14.799500, _S8 -28.847750,
	8, _S8 14.011000, _S8 -29.046249, _S8 13.248500, _S8 -29.017500, _S8 12.494500, _S8 -29.336500,
	8, _S8 12.477750, _S8 -29.343500, _S8 12.422000, _S8 -29.256750, _S8 12.406000, _S8 -29.263500,
	8, _S8 12.064500, _S8 -29.412001, _S8 11.835000, _S8 -29.653500, _S8 11.566000, _S8 -29.915001,
	8, _S8 11.337750, _S8 -30.136999, _S8 10.923250, _S8 -30.040251, _S8 10.604750, _S8 -30.162001,
	8, _S8 10.523750, _S8 -30.193001, _S8 10.473000, _S8 -30.320999, _S8 10.397750, _S8 -30.330750,
	8, _S8 10.093000, _S8 -30.370001, _S8 9.861250, _S8 -30.607250, _S8 9.600000, _S8 -30.750000,
	8, _S8 10.184000, _S8 -30.948750, _S8 10.786750, _S8 -30.941000, _S8 11.402250, _S8 -31.037001,
	8, _S8 11.430500, _S8 -31.041500, _S8 11.466750, _S8 -30.961250, _S8 11.500000, _S8 -30.961250,
	8, _S8 11.534000, _S8 -30.961250, _S8 11.566500, _S8 -31.016500, _S8 11.600000, _S8 -31.049999,
	8, _S8 11.648750, _S8 -30.980000, _S8 11.724250, _S8 -30.898500, _S8 11.788500, _S8 -30.962000,
	8, _S8 11.925500, _S8 -31.097000, _S8 12.064500, _S8 -31.049500, _S8 12.199500, _S8 -31.039499,
	8, _S8 12.235500, _S8 -31.037001, _S8 12.266750, _S8 -30.961250, _S8 12.300000, _S8 -30.961250,
	8, _S8 12.334000, _S8 -30.961250, _S8 12.366750, _S8 -31.039000, _S8 12.400000, _S8 -31.039000,
	8, _S8 12.434000, _S8 -31.038750, _S8 12.466750, _S8 -30.961250, _S8 12.500000, _S8 -30.961250,
	8, _S8 12.534000, _S8 -30.961250, _S8 12.566500, _S8 -31.016500, _S8 12.600000, _S8 -31.049999,
	8, _S8 12.773000, _S8 -30.854500, _S8 12.994250, _S8 -30.993000, _S8 13.199750, _S8 -30.948250,
	8, _S8 13.459250, _S8 -30.891500, _S8 13.526000, _S8 -30.604500, _S8 13.794500, _S8 -30.530001,
	8, _S8 14.973250, _S8 -30.204000, _S8 16.007500, _S8 -29.667749, _S8 17.098249, _S8 -29.146000,
	8, _S8 17.174999, _S8 -29.109249, _S8 17.227501, _S8 -29.047251, _S8 17.200001, _S8 -28.950001,
	8, _S8 17.266750, _S8 -28.950001, _S8 17.344999, _S8 -28.972000, _S8 17.392500, _S8 -28.938999,
	8, _S8 17.657000, _S8 -28.756001, _S8 17.917250, _S8 -28.618999, _S8 18.091499, _S8 -28.344500,
	8, _S8 18.145500, _S8 -28.259750, _S8 18.063250, _S8 -28.158001, _S8 18.004999, _S8 -28.171000,
	8, _S8 16.897751, _S8 -28.419750, _S8 15.896250, _S8 -28.571751, _S8 14.799500, _S8 -28.847750,
/* path_data107 ===========================================*/
	2, _S8 11.334500, _S8 -17.794750,
	8, _S8 10.936500, _S8 -18.099501, _S8 10.790500, _S8 -18.607250, _S8 10.508500, _S8 -19.055250,
	8, _S8 10.455000, _S8 -19.140249, _S8 10.523500, _S8 -19.218750, _S8 10.602750, _S8 -19.240999,
	8, _S8 10.742750, _S8 -19.280750, _S8 10.878500, _S8 -19.161249, _S8 10.980750, _S8 -19.110750,
	8, _S8 11.417000, _S8 -18.895250, _S8 11.800750, _S8 -18.584749, _S8 12.300000, _S8 -18.549999,
	8, _S8 12.797500, _S8 -17.991501, _S8 13.862500, _S8 -17.895250, _S8 13.864250, _S8 -17.049999,
	8, _S8 13.864500, _S8 -16.835251, _S8 13.507500, _S8 -17.064751, _S8 13.400000, _S8 -16.850000,
	8, _S8 12.787250, _S8 -17.100750, _S8 12.190000, _S8 -17.075001, _S8 11.595000, _S8 -17.441750,
	8, _S8 11.440750, _S8 -17.537001, _S8 11.523250, _S8 -17.650249, _S8 11.334500, _S8 -17.794750,
/* path_data108 ===========================================*/
	2, _S8 4.450000, _S8 -30.938999,
	8, _S8 4.483750, _S8 -30.938749, _S8 6.241500, _S8 -30.880501, _S8 6.237250, _S8 -30.851999,
	8, _S8 6.226000, _S8 -30.774750, _S8 4.293500, _S8 -30.512501, _S8 4.202500, _S8 -30.555000,
	8, _S8 4.161500, _S8 -30.573999, _S8 2.283500, _S8 -29.966499, _S8 2.250000, _S8 -30.000000,
	8, _S8 2.317000, _S8 -30.033751, _S8 4.383500, _S8 -30.938999, _S8 4.450000, _S8 -30.938999,
	0
};

/* path_data109 ===========================================*/
signed char path_data109[] = {
	2, _S8 8.300000, _S8 -28.500000,
	8, _S8 8.300000, _S8 -28.500000, _S8 4.600000, _S8 -28.049999, _S8 3.500000, _S8 -27.750000,
	8, _S8 2.400000, _S8 -27.450001, _S8 -2.250000, _S8 -25.549999, _S8 -3.000000, _S8 -25.049999,
	8, _S8 -3.000000, _S8 -25.049999, _S8 -6.350000, _S8 -23.700001, _S8 -10.600000, _S8 -18.700001,
	8, _S8 -10.600000, _S8 -18.700001, _S8 -8.700000, _S8 -19.549999, _S8 -8.150000, _S8 -20.250000,
	8, _S8 -8.150000, _S8 -20.250000, _S8 -4.750000, _S8 -23.400000, _S8 -4.800000, _S8 -22.750000,
	8, _S8 -4.800000, _S8 -22.750000, _S8 -1.750000, _S8 -24.900000, _S8 -1.900000, _S8 -24.350000,
	8, _S8 -1.900000, _S8 -24.350000, _S8 4.200000, _S8 -27.150000, _S8 3.700000, _S8 -26.350000,
	8, _S8 3.700000, _S8 -26.350000, _S8 9.100000, _S8 -27.500000, _S8 8.850000, _S8 -27.000000,
	8, _S8 8.850000, _S8 -27.000000, _S8 13.550000, _S8 -25.900000, _S8 12.850000, _S8 -25.850000,
	8, _S8 12.850000, _S8 -25.850000, _S8 11.400000, _S8 -25.549999, _S8 13.000000, _S8 -24.650000,
	8, _S8 13.000000, _S8 -24.650000, _S8 12.150000, _S8 -23.549999, _S8 10.800000, _S8 -24.549999,
	8, _S8 9.450000, _S8 -25.549999, _S8 10.200000, _S8 -25.000000, _S8 8.950000, _S8 -24.750000,
	8, _S8 8.950000, _S8 -24.750000, _S8 8.300000, _S8 -24.549999, _S8 7.150000, _S8 -25.549999,
	8, _S8 7.150000, _S8 -25.549999, _S8 5.750000, _S8 -26.700001, _S8 3.550000, _S8 -25.799999,
	8, _S8 3.550000, _S8 -25.799999, _S8 -4.100000, _S8 -22.650000, _S8 -4.600000, _S8 -22.500000,
	8, _S8 -4.600000, _S8 -22.500000, _S8 -5.500000, _S8 -21.799999, _S8 -6.100000, _S8 -20.900000,
	8, _S8 -6.100000, _S8 -20.900000, _S8 -7.550000, _S8 -19.799999, _S8 -8.300000, _S8 -19.450001,
	8, _S8 -8.300000, _S8 -19.450001, _S8 -11.500000, _S8 -16.549999, _S8 -11.800000, _S8 -16.200001,
	8, _S8 -11.800000, _S8 -16.200001, _S8 -12.650000, _S8 -14.900000, _S8 -12.850000, _S8 -14.800000,
	8, _S8 -12.850000, _S8 -14.800000, _S8 -11.250000, _S8 -15.750000, _S8 -10.750000, _S8 -16.250000,
	8, _S8 -10.750000, _S8 -16.250000, _S8 -7.250000, _S8 -18.750000, _S8 -5.900000, _S8 -18.950001,
	8, _S8 -5.900000, _S8 -18.950001, _S8 -4.800000, _S8 -19.700001, _S8 -4.600000, _S8 -20.049999,
	8, _S8 -4.600000, _S8 -20.049999, _S8 -1.000000, _S8 -22.350000, _S8 0.050000, _S8 -22.350000,
	8, _S8 0.050000, _S8 -22.350000, _S8 2.350000, _S8 -21.049999, _S8 2.950000, _S8 -22.799999,
	8, _S8 2.950000, _S8 -22.799999, _S8 4.400000, _S8 -23.250000, _S8 5.800000, _S8 -22.950001,
	8, _S8 5.800000, _S8 -22.950001, _S8 6.600000, _S8 -23.600000, _S8 6.400000, _S8 -24.150000,
	8, _S8 6.400000, _S8 -24.150000, _S8 6.800000, _S8 -24.600000, _S8 7.050000, _S8 -23.650000,
	8, _S8 7.050000, _S8 -23.650000, _S8 7.900000, _S8 -22.750000, _S8 9.100000, _S8 -23.250000,
	8, _S8 9.100000, _S8 -23.250000, _S8 10.100000, _S8 -23.299999, _S8 9.600000, _S8 -22.700001,
	8, _S8 9.600000, _S8 -22.700001, _S8 8.500000, _S8 -21.750000, _S8 5.550000, _S8 -21.700001,
	8, _S8 5.550000, _S8 -21.700001, _S8 2.450000, _S8 -21.549999, _S8 -1.650000, _S8 -19.650000,
	8, _S8 -1.650000, _S8 -19.650000, _S8 -9.100000, _S8 -17.049999, _S8 -11.400000, _S8 -14.450000,
	8, _S8 -11.400000, _S8 -14.450000, _S8 -13.000000, _S8 -12.250000, _S8 -14.350000, _S8 -11.950000,
	8, _S8 -14.350000, _S8 -11.950000, _S8 -15.800000, _S8 -11.750000, _S8 -17.299999, _S8 -9.900000,
	8, _S8 -17.299999, _S8 -9.900000, _S8 -14.850000, _S8 -11.350000, _S8 -12.600000, _S8 -11.350000,
	8, _S8 -12.600000, _S8 -11.350000, _S8 -11.600000, _S8 -11.950000, _S8 -12.550000, _S8 -11.050000,
	8, _S8 -12.550000, _S8 -11.050000, _S8 -13.450000, _S8 -9.150000, _S8 -13.050000, _S8 -7.800000,
	8, _S8 -13.050000, _S8 -7.800000, _S8 -13.200000, _S8 -6.500000, _S8 -13.400000, _S8 -6.100000,
	8, _S8 -13.400000, _S8 -6.100000, _S8 -15.350000, _S8 -2.900000, _S8 -15.350000, _S8 -2.300000,
	8, _S8 -15.350000, _S8 -1.700000, _S8 -15.050000, _S8 0.750000, _S8 -14.950000, _S8 0.900000,
	8, _S8 -14.850000, _S8 1.050000, _S8 -15.200000, _S8 0.500000, _S8 -14.250000, _S8 1.100000,
	8, _S8 -13.300000, _S8 1.700000, _S8 -12.600000, _S8 2.100000, _S8 -12.400000, _S8 2.800000,
	8, _S8 -12.200000, _S8 3.500000, _S8 -12.900000, _S8 1.450000, _S8 -12.950000, _S8 1.000000,
	8, _S8 -13.000000, _S8 0.550000, _S8 -14.050000, _S8 -1.250000, _S8 -13.850000, _S8 -1.850000,
	8, _S8 -13.850000, _S8 -1.850000, _S8 -13.600000, _S8 -1.600000, _S8 -13.400000, _S8 -1.250000,
	8, _S8 -13.400000, _S8 -1.250000, _S8 -13.550000, _S8 -1.400000, _S8 -13.400000, _S8 -2.300000,
	8, _S8 -13.400000, _S8 -2.300000, _S8 -13.200000, _S8 -3.600000, _S8 -12.850000, _S8 -4.400000,
	8, _S8 -12.500000, _S8 -5.200000, _S8 -12.000000, _S8 -6.150000, _S8 -11.900000, _S8 -6.350000,
	8, _S8 -11.800000, _S8 -6.550000, _S8 -11.800000, _S8 -8.000000, _S8 -11.450000, _S8 -7.350000,
	4, _S8 -10.600000, _S8 -6.700000,
	8, _S8 -10.600000, _S8 -6.700000, _S8 -11.300000, _S8 -7.350000, _S8 -10.750000, _S8 -7.900000,
	8, _S8 -10.750000, _S8 -7.900000, _S8 -11.000000, _S8 -9.300000, _S8 -10.550000, _S8 -9.950000,
	8, _S8 -10.550000, _S8 -9.950000, _S8 -8.800000, _S8 -12.050000, _S8 -8.400000, _S8 -12.300000,
	8, _S8 -8.000000, _S8 -12.550000, _S8 -8.350000, _S8 -12.450000, _S8 -8.350000, _S8 -12.450000,
	8, _S8 -8.350000, _S8 -12.450000, _S8 -6.850000, _S8 -13.500000, _S8 -8.300000, _S8 -13.100000,
	8, _S8 -8.300000, _S8 -13.100000, _S8 -9.300000, _S8 -12.700000, _S8 -10.050000, _S8 -12.700000,
	8, _S8 -10.050000, _S8 -12.700000, _S8 -11.950000, _S8 -12.200000, _S8 -10.950000, _S8 -13.250000,
	8, _S8 -9.950000, _S8 -14.300000, _S8 -7.450000, _S8 -15.650000, _S8 -6.500000, _S8 -15.600000,
	4, _S8 -6.300000, _S8 -15.200000,
	4, _S8 -3.500000, _S8 -15.800000,
	4, _S8 -3.800000, _S8 -15.600000,
	8, _S8 -3.800000, _S8 -15.600000, _S8 -3.850000, _S8 -15.650000, _S8 -2.800000, _S8 -15.750000,
	8, _S8 -1.750000, _S8 -15.850000, _S8 -0.300000, _S8 -15.500000, _S8 0.050000, _S8 -15.950000,
	8, _S8 0.400000, _S8 -16.400000, _S8 1.250000, _S8 -16.650000, _S8 1.150000, _S8 -16.299999,
	8, _S8 1.050000, _S8 -15.950000, _S8 1.000000, _S8 -15.450000, _S8 1.000000, _S8 -15.450000,
	8, _S8 1.000000, _S8 -15.450000, _S8 2.250000, _S8 -16.900000, _S8 2.100000, _S8 -16.350000,
	8, _S8 1.950000, _S8 -15.800000, _S8 -0.100000, _S8 -14.500000, _S8 -0.450000, _S8 -12.950000,
	4, _S8 2.150000, _S8 -15.000000,
	4, _S8 3.050000, _S8 -15.750000,
	8, _S8 3.050000, _S8 -15.750000, _S8 3.950000, _S8 -15.200000, _S8 4.000000, _S8 -15.600000,
	8, _S8 4.050000, _S8 -16.000000, _S8 5.200000, _S8 -17.450001, _S8 5.500000, _S8 -17.400000,
	8, _S8 5.800000, _S8 -17.350000, _S8 6.300000, _S8 -18.049999, _S8 6.250000, _S8 -17.400000,
	8, _S8 6.200000, _S8 -16.750000, _S8 8.100000, _S8 -15.400000, _S8 8.100000, _S8 -15.400000,
	8, _S8 8.100000, _S8 -15.400000, _S8 8.900000, _S8 -15.850000, _S8 9.250000, _S8 -15.500000,
	8, _S8 9.600000, _S8 -15.150000, _S8 10.650000, _S8 -20.450001, _S8 10.650000, _S8 -20.450001,
	4, _S8 16.900000, _S8 -23.100000,
	4, _S8 27.800249, _S8 -23.950001,
	4, _S8 23.550249, _S8 -25.650000,
	4, _S8 8.300000, _S8 -28.500000,
/* path_data110 ===========================================*/
	2, _S8 12.850000, _S8 21.250000,
	8, _S8 12.850000, _S8 21.250000, _S8 9.100000, _S8 17.049999, _S8 7.000000, _S8 16.400000,
	8, _S8 7.000000, _S8 16.400000, _S8 3.650000, _S8 14.700000, _S8 -2.500000, _S8 16.650000,
	0
};

/* path_data111 ===========================================*/
signed char path_data111[] = {
	2, _S8 6.200000, _S8 16.049999,
	8, _S8 6.200000, _S8 16.049999, _S8 -0.100000, _S8 14.050000, _S8 -3.950000, _S8 15.100000,
	8, _S8 -3.950000, _S8 15.100000, _S8 -8.550000, _S8 15.600000, _S8 -10.650000, _S8 19.049999,
	0
};

/* path_data112 ===========================================*/
signed char path_data112[] = {
	2, _S8 5.300000, _S8 15.750000,
	8, _S8 5.300000, _S8 15.750000, _S8 1.050000, _S8 13.950000, _S8 -2.650000, _S8 13.400000,
	8, _S8 -2.650000, _S8 13.400000, _S8 -6.800000, _S8 12.750000, _S8 -10.950000, _S8 14.550000,
	8, _S8 -10.950000, _S8 14.550000, _S8 -14.000000, _S8 16.049999, _S8 -15.350000, _S8 18.600000,
	0
};

/* path_data113 ===========================================*/
signed char path_data113[] = {
	2, _S8 5.550000, _S8 15.850000,
	8, _S8 5.550000, _S8 15.850000, _S8 1.700000, _S8 13.100000, _S8 1.450000, _S8 12.750000,
	8, _S8 1.450000, _S8 12.750000, _S8 -0.300000, _S8 10.000000, _S8 -3.550000, _S8 9.900000,
	8, _S8 -3.550000, _S8 9.900000, _S8 -8.900000, _S8 10.100000, _S8 -13.200000, _S8 12.100000,
/* path_data114 ===========================================*/
	2, _S8 5.223750, _S8 13.601750,
	8, _S8 5.609250, _S8 13.967500, _S8 12.350000, _S8 21.200001, _S8 12.350000, _S8 21.200001,
	8, _S8 21.150000, _S8 30.350250, _S8 14.150000, _S8 21.799999, _S8 14.150000, _S8 21.799999,
	8, _S8 12.250000, _S8 20.600000, _S8 9.950000, _S8 15.900000, _S8 9.950000, _S8 15.900000,
	8, _S8 9.650000, _S8 15.200000, _S8 13.450000, _S8 17.700001, _S8 13.450000, _S8 17.700001,
	8, _S8 14.450000, _S8 17.900000, _S8 17.850000, _S8 22.700001, _S8 17.850000, _S8 22.700001,
	8, _S8 16.150000, _S8 22.100000, _S8 17.350000, _S8 23.900000, _S8 17.350000, _S8 23.900000,
	8, _S8 18.049999, _S8 24.400000, _S8 23.150249, _S8 28.300249, _S8 23.150249, _S8 28.300249,
	8, _S8 24.050249, _S8 29.300249, _S8 25.050249, _S8 29.700251, _S8 25.050249, _S8 29.700251,
	8, _S8 28.550249, _S8 28.400249, _S8 26.950251, _S8 31.700251, _S8 26.950251, _S8 31.700251,
	8, _S8 27.550249, _S8 33.400249, _S8 28.950251, _S8 30.500250, _S8 28.950251, _S8 30.500250,
	8, _S8 31.750250, _S8 26.299999, _S8 27.650249, _S8 26.900249, _S8 27.650249, _S8 26.900249,
	8, _S8 20.150000, _S8 27.600250, _S8 18.450001, _S8 23.600000, _S8 18.450001, _S8 23.600000,
	8, _S8 17.850000, _S8 23.000000, _S8 20.049999, _S8 23.600000, _S8 20.049999, _S8 23.600000,
	8, _S8 22.150249, _S8 24.100000, _S8 18.250000, _S8 20.500000, _S8 18.250000, _S8 20.500000,
	8, _S8 18.850000, _S8 20.500000, _S8 21.150000, _S8 22.200001, _S8 21.150000, _S8 22.200001,
	8, _S8 23.750250, _S8 24.500000, _S8 24.250250, _S8 24.000000, _S8 24.250250, _S8 24.000000,
	8, _S8 28.750250, _S8 21.799999, _S8 31.350250, _S8 23.700001, _S8 31.350250, _S8 23.700001,
	8, _S8 31.850250, _S8 24.100000, _S8 30.450251, _S8 25.799999, _S8 30.850250, _S8 27.100250,
	8, _S8 31.250250, _S8 28.400249, _S8 32.450249, _S8 31.500250, _S8 32.450249, _S8 31.500250,
	8, _S8 31.850250, _S8 31.900249, _S8 31.950251, _S8 34.600250, _S8 31.950251, _S8 34.600250,
	8, _S8 36.150249, _S8 40.400249, _S8 33.750254, _S8 39.900249, _S8 33.750254, _S8 39.900249,
	8, _S8 29.850250, _S8 39.800251, _S8 33.550251, _S8 41.700249, _S8 33.550251, _S8 41.700249,
	8, _S8 34.350250, _S8 42.200249, _S8 36.550251, _S8 44.000254, _S8 36.550251, _S8 44.000254,
	8, _S8 35.850250, _S8 43.700249, _S8 35.450249, _S8 45.000254, _S8 35.450249, _S8 45.000254,
	8, _S8 36.650249, _S8 46.000254, _S8 35.950249, _S8 47.200249, _S8 35.950249, _S8 47.200249,
	8, _S8 34.450249, _S8 47.500254, _S8 34.150249, _S8 48.500254, _S8 34.150249, _S8 48.500254,
	8, _S8 35.850250, _S8 50.500254, _S8 33.350250, _S8 50.600250, _S8 33.350250, _S8 50.600250,
	8, _S8 34.250254, _S8 51.700249, _S8 33.050251, _S8 54.700249, _S8 33.050251, _S8 54.700249,
	8, _S8 31.850250, _S8 54.700249, _S8 30.250250, _S8 56.100250, _S8 30.250250, _S8 56.100250,
	8, _S8 30.850250, _S8 57.300251, _S8 28.250250, _S8 58.700249, _S8 28.250250, _S8 58.700249,
	8, _S8 26.150249, _S8 59.100250, _S8 26.850250, _S8 60.800251, _S8 26.850250, _S8 60.800251,
	8, _S8 24.850250, _S8 62.300251, _S8 24.250250, _S8 66.300247, _S8 24.250250, _S8 66.300247,
	8, _S8 24.050249, _S8 68.900253, _S8 23.450251, _S8 69.700249, _S8 24.750250, _S8 69.200249,
	8, _S8 26.050249, _S8 68.700249, _S8 25.850250, _S8 65.600250, _S8 25.850250, _S8 65.600250,
	8, _S8 24.650249, _S8 61.700249, _S8 35.350250, _S8 57.700249, _S8 35.350250, _S8 57.700249,
	8, _S8 36.350250, _S8 57.300251, _S8 36.550251, _S8 56.000254, _S8 36.550251, _S8 56.000254,
	8, _S8 37.050251, _S8 56.100250, _S8 39.250254, _S8 58.000254, _S8 39.250254, _S8 58.000254,
	8, _S8 41.150249, _S8 60.800251, _S8 41.250254, _S8 58.500254, _S8 41.250254, _S8 58.500254,
	8, _S8 41.550251, _S8 57.600250, _S8 41.150249, _S8 56.100250, _S8 41.150249, _S8 56.100250,
	8, _S8 42.650249, _S8 50.700249, _S8 39.150249, _S8 49.100250, _S8 39.150249, _S8 49.100250,
	8, _S8 36.650249, _S8 40.700249, _S8 40.150249, _S8 42.800251, _S8 40.150249, _S8 42.800251,
	8, _S8 40.850250, _S8 44.200249, _S8 43.550251, _S8 45.500254, _S8 43.550251, _S8 45.500254,
	4, _S8 44.450249, _S8 44.900249,
	8, _S8 44.050251, _S8 43.700249, _S8 46.150249, _S8 42.200249, _S8 46.150249, _S8 42.200249,
	8, _S8 46.850250, _S8 43.800251, _S8 48.350250, _S8 41.800251, _S8 48.350250, _S8 41.800251,
	8, _S8 49.250254, _S8 35.700249, _S8 52.350250, _S8 39.300251, _S8 52.350250, _S8 39.300251,
	8, _S8 53.350250, _S8 39.600250, _S8 53.650249, _S8 37.900249, _S8 53.650249, _S8 37.900249,
	8, _S8 54.550251, _S8 35.300251, _S8 53.650249, _S8 31.900249, _S8 53.650249, _S8 31.900249,
	8, _S8 54.550251, _S8 31.800249, _S8 56.950249, _S8 33.300251, _S8 56.950249, _S8 33.300251,
	8, _S8 57.650249, _S8 32.400249, _S8 55.350250, _S8 28.200251, _S8 56.350250, _S8 28.800249,
	8, _S8 57.350250, _S8 29.400249, _S8 58.450249, _S8 29.800249, _S8 58.450249, _S8 29.800249,
	8, _S8 58.650249, _S8 29.300249, _S8 56.150249, _S8 26.200251, _S8 56.150249, _S8 26.200251,
	8, _S8 55.050251, _S8 25.500000, _S8 53.750254, _S8 20.400000, _S8 53.750254, _S8 20.400000,
	8, _S8 55.550251, _S8 21.299999, _S8 53.050251, _S8 17.500000, _S8 53.050251, _S8 17.500000,
	8, _S8 53.050251, _S8 16.700001, _S8 54.550251, _S8 13.900000, _S8 54.550251, _S8 13.900000,
	8, _S8 54.350250, _S8 12.200000, _S8 54.550251, _S8 12.300000, _S8 54.550251, _S8 12.300000,
	8, _S8 55.250254, _S8 12.600000, _S8 57.250254, _S8 13.000000, _S8 55.550251, _S8 11.400000,
	8, _S8 53.850250, _S8 9.800000, _S8 55.750254, _S8 8.600000, _S8 55.750254, _S8 8.600000,
	8, _S8 56.850250, _S8 7.900000, _S8 53.450249, _S8 8.000000, _S8 53.450249, _S8 8.000000,
	8, _S8 52.150249, _S8 6.900000, _S8 52.250254, _S8 5.900000, _S8 52.250254, _S8 5.900000,
	8, _S8 54.250254, _S8 6.400000, _S8 50.650249, _S8 2.800000, _S8 50.050251, _S8 1.900000,
	8, _S8 49.450249, _S8 1.000000, _S8 51.850250, _S8 -0.300000, _S8 51.850250, _S8 -0.300000,
	8, _S8 55.150249, _S8 -1.200000, _S8 52.250254, _S8 -2.000000, _S8 52.250254, _S8 -2.000000,
	8, _S8 47.350250, _S8 -1.900000, _S8 50.050251, _S8 -4.600000, _S8 50.050251, _S8 -4.600000,
	8, _S8 51.550251, _S8 -4.500000, _S8 51.150249, _S8 -5.100000, _S8 51.150249, _S8 -5.100000,
	8, _S8 49.850250, _S8 -5.400000, _S8 47.450249, _S8 -7.000000, _S8 47.450249, _S8 -7.000000,
	8, _S8 46.450249, _S8 -7.900000, _S8 47.350250, _S8 -7.700000, _S8 47.350250, _S8 -7.700000,
	8, _S8 51.550251, _S8 -7.400000, _S8 44.350250, _S8 -10.200000, _S8 44.350250, _S8 -10.200000,
	8, _S8 46.350250, _S8 -10.200000, _S8 41.850250, _S8 -12.800000, _S8 41.850250, _S8 -12.800000,
	8, _S8 41.350250, _S8 -13.200000, _S8 40.550251, _S8 -15.100000, _S8 40.550251, _S8 -15.100000,
	8, _S8 39.050251, _S8 -16.400000, _S8 37.850250, _S8 -18.100000, _S8 37.850250, _S8 -18.100000,
	8, _S8 37.750254, _S8 -19.200001, _S8 36.550251, _S8 -20.400000, _S8 36.550251, _S8 -20.400000,
	8, _S8 33.650249, _S8 -23.799999, _S8 32.250254, _S8 -23.700001, _S8 32.250254, _S8 -23.700001,
	8, _S8 28.550249, _S8 -24.600000, _S8 27.250250, _S8 -24.400000, _S8 27.250250, _S8 -24.400000,
	4, _S8 14.050000, _S8 -23.299999,
	8, _S8 7.450000, _S8 -20.100000, _S8 9.400000, _S8 -14.850000, _S8 9.400000, _S8 -14.850000,
	8, _S8 11.000000, _S8 -12.750000, _S8 13.300000, _S8 -13.700000, _S8 13.300000, _S8 -13.700000,
	8, _S8 14.450000, _S8 -15.250000, _S8 17.350000, _S8 -14.700000, _S8 17.350000, _S8 -14.700000,
	8, _S8 22.450251, _S8 -13.900000, _S8 21.800249, _S8 -14.800000, _S8 21.800249, _S8 -14.800000,
	8, _S8 21.200251, _S8 -15.950000, _S8 17.150000, _S8 -17.500000, _S8 17.100000, _S8 -17.650000,
	8, _S8 17.049999, _S8 -17.799999, _S8 14.850000, _S8 -18.650000, _S8 14.850000, _S8 -18.650000,
	8, _S8 14.100000, _S8 -18.950001, _S8 13.000000, _S8 -21.250000, _S8 13.000000, _S8 -21.250000,
	8, _S8 12.200000, _S8 -22.100000, _S8 16.150000, _S8 -20.650000, _S8 16.150000, _S8 -20.650000,
	8, _S8 15.850000, _S8 -20.400000, _S8 17.700001, _S8 -19.400000, _S8 17.700001, _S8 -19.400000,
	8, _S8 22.050249, _S8 -19.650000, _S8 24.700251, _S8 -16.950001, _S8 24.700251, _S8 -16.950001,
	8, _S8 27.400249, _S8 -12.800000, _S8 27.450251, _S8 -14.850000, _S8 27.450251, _S8 -14.850000,
	8, _S8 28.150249, _S8 -17.200001, _S8 25.200251, _S8 -22.500000, _S8 25.200251, _S8 -22.500000,
	8, _S8 25.300249, _S8 -23.000000, _S8 27.350250, _S8 -21.350000, _S8 27.350250, _S8 -21.350000,
	8, _S8 27.700251, _S8 -21.850000, _S8 27.900249, _S8 -20.400000, _S8 27.900249, _S8 -20.400000,
	8, _S8 27.950251, _S8 -19.799999, _S8 28.900249, _S8 -17.799999, _S8 28.900249, _S8 -17.799999,
	8, _S8 29.600250, _S8 -14.550000, _S8 30.500250, _S8 -16.400000, _S8 30.500250, _S8 -16.400000,
	4, _S8 31.650249, _S8 -14.050000,
	8, _S8 32.000254, _S8 -13.400000, _S8 30.500250, _S8 -11.500000, _S8 30.500250, _S8 -11.500000,
	8, _S8 30.450251, _S8 -10.800000, _S8 30.650249, _S8 -10.850000, _S8 29.250250, _S8 -8.950000,
	8, _S8 27.850250, _S8 -7.050000, _S8 28.700251, _S8 -5.950000, _S8 28.700251, _S8 -5.950000,
	8, _S8 28.350250, _S8 -4.300000, _S8 30.550249, _S8 -4.400000, _S8 30.550249, _S8 -4.400000,
	8, _S8 31.200251, _S8 -3.850000, _S8 32.050251, _S8 -3.850000, _S8 32.050251, _S8 -3.850000,
	8, _S8 32.500254, _S8 -3.350000, _S8 33.100250, _S8 -3.500000, _S8 33.100250, _S8 -3.500000,
	8, _S8 33.500254, _S8 -4.450000, _S8 35.050251, _S8 -3.950000, _S8 35.050251, _S8 -3.950000,
	8, _S8 35.400249, _S8 -4.550000, _S8 37.450249, _S8 -4.650000, _S8 37.450249, _S8 -4.650000,
	8, _S8 37.700249, _S8 -5.300000, _S8 37.800251, _S8 -5.700000, _S8 38.650249, _S8 -5.850000,
	8, _S8 39.500254, _S8 -6.000000, _S8 33.350250, _S8 -16.750000, _S8 33.350250, _S8 -16.750000,
	8, _S8 34.950249, _S8 -16.950001, _S8 32.900249, _S8 -20.049999, _S8 32.900249, _S8 -20.049999,
	8, _S8 32.350250, _S8 -21.700001, _S8 35.200249, _S8 -18.049999, _S8 35.750254, _S8 -17.700001,
	8, _S8 36.300251, _S8 -17.350000, _S8 36.550251, _S8 -16.799999, _S8 36.150249, _S8 -16.850000,
	8, _S8 35.750254, _S8 -16.900000, _S8 35.300251, _S8 -16.350000, _S8 35.650249, _S8 -16.299999,
	8, _S8 36.000254, _S8 -16.250000, _S8 39.250254, _S8 -12.500000, _S8 40.100250, _S8 -9.950000,
	8, _S8 40.950249, _S8 -7.400000, _S8 42.450249, _S8 -6.400000, _S8 44.000254, _S8 -4.900000,
	8, _S8 45.550251, _S8 -3.400000, _S8 45.350250, _S8 2.650000, _S8 45.350250, _S8 2.650000,
	8, _S8 45.250254, _S8 4.850000, _S8 46.750254, _S8 7.500000, _S8 46.750254, _S8 7.500000,
	8, _S8 47.250254, _S8 8.450000, _S8 46.200249, _S8 13.000000, _S8 46.200249, _S8 13.000000,
	8, _S8 45.700249, _S8 13.550000, _S8 46.050251, _S8 13.750000, _S8 46.050251, _S8 13.750000,
	8, _S8 46.300251, _S8 14.050000, _S8 48.000254, _S8 17.350000, _S8 48.000254, _S8 17.350000,
	8, _S8 47.550251, _S8 17.299999, _S8 48.450249, _S8 18.200001, _S8 48.450249, _S8 18.200001,
	8, _S8 49.750254, _S8 19.700001, _S8 48.150249, _S8 18.950001, _S8 48.150249, _S8 18.950001,
	8, _S8 46.650249, _S8 18.549999, _S8 48.400249, _S8 21.000000, _S8 48.400249, _S8 21.000000,
	8, _S8 48.700249, _S8 21.450001, _S8 46.450249, _S8 20.299999, _S8 46.450249, _S8 20.299999,
	8, _S8 44.150249, _S8 20.150000, _S8 47.050251, _S8 21.950001, _S8 47.050251, _S8 21.950001,
	8, _S8 49.200249, _S8 23.750000, _S8 46.350250, _S8 22.650000, _S8 46.350250, _S8 22.650000,
	8, _S8 45.200249, _S8 22.200001, _S8 46.000254, _S8 23.900000, _S8 46.000254, _S8 23.900000,
	8, _S8 46.800251, _S8 24.299999, _S8 51.100250, _S8 26.049999, _S8 51.100250, _S8 26.049999,
	8, _S8 51.200249, _S8 27.000250, _S8 50.450249, _S8 28.250250, _S8 50.450249, _S8 28.250250,
	8, _S8 50.550251, _S8 29.250250, _S8 50.000254, _S8 30.100250, _S8 50.000254, _S8 30.100250,
	8, _S8 49.700249, _S8 32.150249, _S8 49.550251, _S8 32.350250, _S8 49.550251, _S8 32.350250,
	8, _S8 48.500254, _S8 32.400249, _S8 46.650249, _S8 35.850250, _S8 46.650249, _S8 35.850250,
	8, _S8 46.200249, _S8 36.500254, _S8 43.650249, _S8 39.500254, _S8 43.650249, _S8 39.500254,
	8, _S8 43.150249, _S8 41.250254, _S8 38.650249, _S8 39.450249, _S8 38.650249, _S8 39.450249,
	8, _S8 37.000254, _S8 40.300251, _S8 37.500254, _S8 39.450249, _S8 37.500254, _S8 39.450249,
	8, _S8 37.400249, _S8 38.900249, _S8 38.600250, _S8 37.400249, _S8 38.600250, _S8 37.400249,
	8, _S8 40.350250, _S8 36.750254, _S8 39.700249, _S8 34.050251, _S8 39.700249, _S8 34.050251,
	8, _S8 40.700249, _S8 33.700249, _S8 37.900249, _S8 33.000254, _S8 37.950249, _S8 32.700249,
	8, _S8 38.000254, _S8 32.400249, _S8 39.450249, _S8 32.050251, _S8 39.450249, _S8 32.050251,
	8, _S8 41.450249, _S8 31.550249, _S8 40.350250, _S8 30.950251, _S8 40.350250, _S8 30.950251,
	8, _S8 40.200249, _S8 29.950251, _S8 40.950249, _S8 28.550249, _S8 40.950249, _S8 28.550249,
	8, _S8 43.850250, _S8 28.350250, _S8 40.950249, _S8 24.299999, _S8 40.950249, _S8 24.299999,
	8, _S8 38.250254, _S8 22.400000, _S8 38.000254, _S8 20.950001, _S8 38.000254, _S8 20.950001,
	8, _S8 41.150249, _S8 18.900000, _S8 39.100250, _S8 15.800000, _S8 39.150249, _S8 14.900000,
	8, _S8 39.200249, _S8 14.000000, _S8 39.500254, _S8 8.600000, _S8 39.500254, _S8 8.600000,
	8, _S8 39.000254, _S8 7.050000, _S8 38.250254, _S8 3.650000, _S8 38.250254, _S8 3.650000,
	8, _S8 38.800251, _S8 2.350000, _S8 40.650249, _S8 -0.800000, _S8 40.650249, _S8 -0.800000,
	8, _S8 41.350250, _S8 -1.850000, _S8 43.550251, _S8 -3.050000, _S8 43.000254, _S8 -3.800000,
	8, _S8 42.450249, _S8 -4.550000, _S8 40.500254, _S8 -4.100000, _S8 40.500254, _S8 -4.100000,
	8, _S8 38.550251, _S8 -4.450000, _S8 38.700249, _S8 -3.150000, _S8 38.700249, _S8 -3.150000,
	8, _S8 38.300251, _S8 -2.900000, _S8 38.100250, _S8 -1.650000, _S8 38.100250, _S8 -1.650000,
	8, _S8 37.919998, _S8 0.333250, _S8 35.700249, _S8 1.900000, _S8 35.700249, _S8 1.900000,
	8, _S8 32.900249, _S8 3.450000, _S8 35.200249, _S8 4.450000, _S8 35.200249, _S8 4.450000,
	8, _S8 36.700249, _S8 6.100000, _S8 34.250254, _S8 6.150000, _S8 34.250254, _S8 6.150000,
	8, _S8 31.500250, _S8 5.700000, _S8 33.550251, _S8 8.250000, _S8 33.550251, _S8 8.250000,
	8, _S8 36.250254, _S8 11.450000, _S8 35.500254, _S8 12.150000, _S8 35.500254, _S8 12.150000,
	8, _S8 32.950249, _S8 12.400000, _S8 36.100250, _S8 14.700000, _S8 36.100250, _S8 14.700000,
	8, _S8 36.100250, _S8 14.700000, _S8 35.900249, _S8 14.200000, _S8 35.950249, _S8 14.650000,
	8, _S8 36.000254, _S8 15.100000, _S8 36.750254, _S8 16.150000, _S8 36.950249, _S8 16.650000,
	8, _S8 37.150249, _S8 17.150000, _S8 36.150249, _S8 17.200001, _S8 36.150249, _S8 17.200001,
	8, _S8 36.300251, _S8 19.600000, _S8 32.450249, _S8 18.549999, _S8 32.450249, _S8 18.549999,
	8, _S8 32.450249, _S8 18.549999, _S8 32.450249, _S8 18.549999, _S8 32.050251, _S8 18.600000,
	8, _S8 31.650249, _S8 18.650000, _S8 28.850250, _S8 18.450001, _S8 27.400249, _S8 17.900000,
	8, _S8 25.950251, _S8 17.350000, _S8 24.250250, _S8 17.350000, _S8 24.250250, _S8 17.350000,
	8, _S8 24.250250, _S8 17.350000, _S8 23.250250, _S8 17.799999, _S8 21.350000, _S8 17.750000,
	8, _S8 19.450001, _S8 17.700001, _S8 17.450001, _S8 18.400000, _S8 17.450001, _S8 18.400000,
	8, _S8 16.350000, _S8 18.299999, _S8 18.500000, _S8 17.200001, _S8 18.549999, _S8 17.250000,
	8, _S8 18.600000, _S8 17.299999, _S8 20.000000, _S8 15.900000, _S8 18.000000, _S8 16.049999,
	8, _S8 12.550750, _S8 16.458750, _S8 9.850000, _S8 13.900000, _S8 9.850000, _S8 13.900000,
	8, _S8 9.350000, _S8 13.550000, _S8 8.700000, _S8 12.850000, _S8 8.700000, _S8 12.850000,
	8, _S8 6.200000, _S8 12.350000, _S8 9.050000, _S8 15.950000, _S8 9.050000, _S8 15.950000,
	8, _S8 9.350000, _S8 16.299999, _S8 9.000000, _S8 16.549999, _S8 9.000000, _S8 16.549999,
	8, _S8 8.800000, _S8 16.150000, _S8 6.850000, _S8 14.800000, _S8 6.850000, _S8 14.800000,
	8, _S8 6.147250, _S8 14.556750, _S8 5.806500, _S8 14.223250, _S8 5.223750, _S8 13.601750,
	0
};

/* path_data115 ===========================================*/
signed char path_data115[] = {
	2, _S8 -0.750000, _S8 10.700000,
	8, _S8 -0.750000, _S8 10.700000, _S8 2.150000, _S8 12.100000, _S8 2.800000, _S8 12.800000,
	8, _S8 3.450000, _S8 13.500000, _S8 6.950000, _S8 16.350000, _S8 6.950000, _S8 16.350000,
	8, _S8 6.950000, _S8 16.350000, _S8 5.600000, _S8 15.850000, _S8 4.950000, _S8 15.400000,
	8, _S8 4.300000, _S8 14.950000, _S8 1.600000, _S8 12.900000, _S8 1.600000, _S8 12.900000,
	8, _S8 1.600000, _S8 12.900000, _S8 0.650000, _S8 11.400000, _S8 -0.750000, _S8 10.700000,
	0
};

/* path_data116 ===========================================*/
signed char path_data116[] = {
	2, _S8 -15.252250, _S8 2.900750,
	8, _S8 -15.168000, _S8 2.863750, _S8 -15.299000, _S8 2.185750, _S8 -15.350000, _S8 2.050000,
	8, _S8 -15.605500, _S8 1.368500, _S8 -17.850000, _S8 1.000000, _S8 -17.850000, _S8 1.000000,
	8, _S8 -17.906750, _S8 1.341250, _S8 -17.920500, _S8 1.740250, _S8 -17.893999, _S8 2.149750,
	8, _S8 -17.893999, _S8 2.149750, _S8 -16.677000, _S8 3.529500, _S8 -15.252250, _S8 2.900750,
	0
};

/* path_data117 ===========================================*/
signed char path_data117[] = {
	2, _S8 -15.252250, _S8 2.850750,
	8, _S8 -15.364500, _S8 2.890250, _S8 -15.256000, _S8 2.167250, _S8 -15.300000, _S8 2.050000,
	8, _S8 -15.555500, _S8 1.368500, _S8 -17.850000, _S8 0.975000, _S8 -17.850000, _S8 0.975000,
	8, _S8 -17.906750, _S8 1.316250, _S8 -17.920500, _S8 1.715250, _S8 -17.893999, _S8 2.124750,
	8, _S8 -17.893999, _S8 2.124750, _S8 -16.827000, _S8 3.404500, _S8 -15.252250, _S8 2.850750,
	0
};

/* path_data118 ===========================================*/
signed char path_data118[] = {
	2, _S8 -16.350000, _S8 3.736500,
	8, _S8 -18.506250, _S8 0.886500, _S8 -16.632750, _S8 0.601500, _S8 -16.632750, _S8 0.250000,
	8, _S8 -18.632750, _S8 0.898750, _S8 -16.506250, _S8 0.613750, _S8 -16.350000, _S8 0.613750,
	8, _S8 -18.193750, _S8 0.613750, _S8 -16.066999, _S8 0.898750, _S8 -16.066999, _S8 0.250000,
	8, _S8 -18.066999, _S8 0.601500, _S8 -16.193750, _S8 0.686500, _S8 -16.350000, _S8 0.686500,
/* path_data120 ===========================================*/
	2, _S8 -27.750000, _S8 27.400249,
	8, _S8 -27.750000, _S8 27.400249, _S8 -29.150000, _S8 29.900249, _S8 -22.950001, _S8 28.400249,
	8, _S8 -22.950001, _S8 28.400249, _S8 -19.450001, _S8 28.100250, _S8 -18.850000, _S8 27.500250,
	8, _S8 -18.549999, _S8 27.700251, _S8 -16.458500, _S8 28.433500, _S8 -15.750000, _S8 28.600250,
	8, _S8 -14.050000, _S8 29.000250, _S8 -11.950000, _S8 26.500000, _S8 -11.950000, _S8 26.500000,
	8, _S8 -11.950000, _S8 26.500000, _S8 -10.800000, _S8 23.875000, _S8 -10.100000, _S8 23.875000,
	8, _S8 -9.400000, _S8 23.875000, _S8 -10.200000, _S8 24.275000, _S8 -10.200000, _S8 24.275000,
	8, _S8 -10.200000, _S8 24.275000, _S8 -11.850000, _S8 26.800249, _S8 -11.750000, _S8 27.200251,
	8, _S8 -11.750000, _S8 27.200251, _S8 -13.050000, _S8 32.200249, _S8 -17.049999, _S8 32.400249,
	8, _S8 -17.049999, _S8 32.400249, _S8 -21.087500, _S8 32.637749, _S8 -20.750000, _S8 34.100250,
	8, _S8 -20.750000, _S8 34.100250, _S8 -18.549999, _S8 33.500254, _S8 -17.950001, _S8 34.100250,
	8, _S8 -17.950001, _S8 34.100250, _S8 -15.250000, _S8 34.000254, _S8 -17.250000, _S8 35.600250,
	4, _S8 -18.950001, _S8 38.500254,
	8, _S8 -18.950001, _S8 38.500254, _S8 -18.915001, _S8 39.479754, _S8 -21.450001, _S8 38.600250,
	8, _S8 -23.900000, _S8 37.750254, _S8 -26.475000, _S8 34.525249, _S8 -26.475000, _S8 34.525249,
	8, _S8 -26.475000, _S8 34.525249, _S8 -30.462500, _S8 30.887751, _S8 -27.750000, _S8 27.400249,
	0
};

/* path_data121 ===========================================*/
signed char path_data121[] = {
	2, _S8 -28.049999, _S8 28.400249,
	8, _S8 -28.049999, _S8 28.400249, _S8 -28.549999, _S8 30.800249, _S8 -19.350000, _S8 28.200251,
	8, _S8 -19.350000, _S8 28.200251, _S8 -18.250000, _S8 28.200251, _S8 -17.650000, _S8 28.400249,
	8, _S8 -17.049999, _S8 28.600250, _S8 -14.050000, _S8 29.300249, _S8 -13.550000, _S8 29.000250,
	8, _S8 -13.550000, _S8 29.000250, _S8 -15.350000, _S8 32.400249, _S8 -18.250000, _S8 32.000252,
	8, _S8 -18.250000, _S8 32.000252, _S8 -21.549999, _S8 32.400249, _S8 -21.450001, _S8 33.600250,
	8, _S8 -21.450001, _S8 33.600250, _S8 -20.450001, _S8 35.400249, _S8 -19.250000, _S8 36.000252,
	8, _S8 -19.250000, _S8 36.000252, _S8 -18.549999, _S8 36.600250, _S8 -18.650000, _S8 37.400249,
	8, _S8 -18.750000, _S8 38.200249, _S8 -19.450001, _S8 38.600250, _S8 -19.950001, _S8 38.800251,
	8, _S8 -20.450001, _S8 39.000252, _S8 -21.250000, _S8 38.200249, _S8 -21.650000, _S8 38.200249,
	8, _S8 -22.049999, _S8 38.200249, _S8 -24.150000, _S8 36.600250, _S8 -25.250000, _S8 35.400249,
	8, _S8 -26.350000, _S8 34.200249, _S8 -28.450001, _S8 31.200251, _S8 -28.350000, _S8 30.500250,
	8, _S8 -28.250000, _S8 29.800249, _S8 -28.049999, _S8 28.400249, _S8 -28.049999, _S8 28.400249,
	0
};

/* path_data122 ===========================================*/
signed char path_data122[] = {
	2, _S8 -27.250000, _S8 32.762749,
	8, _S8 -26.600000, _S8 33.750252, _S8 -25.799999, _S8 34.800251, _S8 -25.250000, _S8 35.400249,
	8, _S8 -24.150000, _S8 36.600250, _S8 -22.049999, _S8 38.200249, _S8 -21.650000, _S8 38.200249,
	8, _S8 -21.250000, _S8 38.200249, _S8 -20.450001, _S8 39.000252, _S8 -19.950001, _S8 38.800251,
	8, _S8 -19.450001, _S8 38.600250, _S8 -18.750000, _S8 38.200249, _S8 -18.650000, _S8 37.400249,
	8, _S8 -18.549999, _S8 36.600250, _S8 -19.250000, _S8 36.000252, _S8 -19.250000, _S8 36.000252,
	8, _S8 -20.016500, _S8 35.617001, _S8 -20.701500, _S8 34.743999, _S8 -21.096251, _S8 34.163250,
	8, _S8 -21.096251, _S8 34.163250, _S8 -21.049999, _S8 34.800251, _S8 -22.350000, _S8 34.600250,
	8, _S8 -23.650000, _S8 34.400249, _S8 -24.950001, _S8 33.700249, _S8 -25.350000, _S8 32.900249,
	8, _S8 -25.750000, _S8 32.100250, _S8 -26.350000, _S8 31.500250, _S8 -25.950001, _S8 32.400249,
	8, _S8 -25.549999, _S8 33.300251, _S8 -24.950001, _S8 34.200249, _S8 -24.549999, _S8 34.300251,
	8, _S8 -24.150000, _S8 34.400249, _S8 -24.250000, _S8 34.700249, _S8 -24.850000, _S8 34.600250,
	8, _S8 -25.450001, _S8 34.500252, _S8 -26.150000, _S8 34.400249, _S8 -27.250000, _S8 33.100250,
	0
};

/* path_data123 ===========================================*/
signed char path_data123[] = {
	2, _S8 -27.900000, _S8 27.500250,
	8, _S8 -27.900000, _S8 27.500250, _S8 -27.450001, _S8 24.100000, _S8 -27.150000, _S8 23.100000,
	8, _S8 -27.150000, _S8 23.100000, _S8 -27.350000, _S8 21.400000, _S8 -26.750000, _S8 20.350000,
	8, _S8 -26.150000, _S8 19.299999, _S8 -25.650000, _S8 17.750000, _S8 -24.900000, _S8 16.400000,
	8, _S8 -24.150000, _S8 15.050000, _S8 -24.100000, _S8 14.050000, _S8 -23.100000, _S8 13.650000,
	8, _S8 -22.100000, _S8 13.250000, _S8 -20.600000, _S8 11.100000, _S8 -19.900000, _S8 10.850000,
	8, _S8 -19.200001, _S8 10.600000, _S8 -19.250000, _S8 10.800000, _S8 -19.250000, _S8 10.800000,
	8, _S8 -19.250000, _S8 10.800000, _S8 -17.549999, _S8 7.100000, _S8 -14.150000, _S8 8.100000,
	8, _S8 -14.150000, _S8 8.100000, _S8 -18.200001, _S8 7.400000, _S8 -14.250000, _S8 5.050000,
	8, _S8 -14.250000, _S8 5.050000, _S8 -15.450000, _S8 5.325000, _S8 -14.625000, _S8 3.575000,
	8, _S8 -14.074750, _S8 2.408000, _S8 -14.200000, _S8 4.100000, _S8 -16.950001, _S8 7.050000,
	8, _S8 -16.950001, _S8 7.050000, _S8 -18.200001, _S8 9.200000, _S8 -19.500000, _S8 9.950000,
	8, _S8 -20.799999, _S8 10.700000, _S8 -23.799999, _S8 12.450000, _S8 -24.100000, _S8 13.400000,
	8, _S8 -24.400000, _S8 14.350000, _S8 -25.200001, _S8 15.800000, _S8 -25.700001, _S8 16.200001,
	8, _S8 -26.200001, _S8 16.600000, _S8 -26.900000, _S8 17.650000, _S8 -27.000000, _S8 18.500000,
	8, _S8 -27.000000, _S8 18.500000, _S8 -27.299999, _S8 19.500000, _S8 -27.650000, _S8 19.799999,
	8, _S8 -28.000000, _S8 20.100000, _S8 -28.049999, _S8 20.900000, _S8 -28.049999, _S8 21.400000,
	8, _S8 -28.049999, _S8 21.900000, _S8 -28.549999, _S8 22.600000, _S8 -28.500000, _S8 23.200001,
	8, _S8 -28.500000, _S8 23.200001, _S8 -28.299999, _S8 27.950251, _S8 -28.400000, _S8 28.450251,
	4, _S8 -27.900000, _S8 27.500250,
	0
};

/* path_data124 ===========================================*/
signed char path_data124[] = {
	2, _S8 -30.049999, _S8 28.650249,
	8, _S8 -30.049999, _S8 28.650249, _S8 -30.549999, _S8 28.300249, _S8 -31.650000, _S8 29.800249,
	8, _S8 -31.650000, _S8 29.800249, _S8 -29.825001, _S8 38.050251, _S8 -29.825001, _S8 38.400249,
	8, _S8 -29.825001, _S8 38.400249, _S8 -29.549999, _S8 37.875252, _S8 -29.875000, _S8 36.075249,
	8, _S8 -30.200001, _S8 34.275249, _S8 -30.424999, _S8 31.100250, _S8 -30.424999, _S8 31.100250,
	4, _S8 -30.049999, _S8 28.650249,
	0
};

/* path_data125 ===========================================*/
signed char path_data125[] = {
	2, _S8 -24.650000, _S8 13.500000,
	8, _S8 -24.650000, _S8 13.500000, _S8 -29.049999, _S8 14.300000, _S8 -28.950001, _S8 21.600000,
	4, _S8 -29.150000, _S8 27.800249,
	8, _S8 -29.150000, _S8 27.800249, _S8 -29.450001, _S8 21.400000, _S8 -29.750000, _S8 21.000000,
	8, _S8 -30.049999, _S8 20.600000, _S8 -29.049999, _S8 17.799999, _S8 -29.850000, _S8 19.299999,
	8, _S8 -29.850000, _S8 19.299999, _S8 -33.349998, _S8 22.799999, _S8 -31.350000, _S8 28.100250,
	8, _S8 -31.350000, _S8 28.100250, _S8 -30.975000, _S8 28.925249, _S8 -31.725000, _S8 27.775249,
	8, _S8 -31.725000, _S8 27.775249, _S8 -32.875000, _S8 24.625000, _S8 -32.599998, _S8 23.025000,
	8, _S8 -32.599998, _S8 23.025000, _S8 -32.549999, _S8 22.475000, _S8 -32.075001, _S8 21.775000,
	8, _S8 -32.075001, _S8 21.775000, _S8 -29.924999, _S8 18.850000, _S8 -29.250000, _S8 18.275000,
	8, _S8 -29.250000, _S8 18.275000, _S8 -28.799999, _S8 14.675000, _S8 -24.950001, _S8 13.375000,
	8, _S8 -24.950001, _S8 13.375000, _S8 -23.525000, _S8 12.800000, _S8 -24.650000, _S8 13.500000,
	0
};

/* path_data126 ===========================================*/
signed char path_data126[] = {
	2, _S8 10.200000, _S8 -3.050000,
	8, _S8 10.365000, _S8 -3.138500, _S8 10.362750, _S8 -3.381000, _S8 10.507750, _S8 -3.424250,
	8, _S8 10.795000, _S8 -3.510250, _S8 10.836000, _S8 -3.777000, _S8 10.965500, _S8 -3.973000,
	8, _S8 11.183750, _S8 -4.302750, _S8 11.232000, _S8 -4.686000, _S8 11.377500, _S8 -5.058750,
	8, _S8 11.445500, _S8 -5.233750, _S8 11.452250, _S8 -5.472500, _S8 11.374000, _S8 -5.637500,
	8, _S8 11.080500, _S8 -6.257750, _S8 10.905000, _S8 -6.870000, _S8 10.544500, _S8 -7.476500,
	8, _S8 10.477500, _S8 -7.589000, _S8 10.412000, _S8 -7.787500, _S8 10.361750, _S8 -7.937000,
	8, _S8 10.246000, _S8 -8.283000, _S8 9.931750, _S8 -8.530750, _S8 9.716750, _S8 -8.860750,
	8, _S8 9.644750, _S8 -8.971000, _S8 9.776000, _S8 -9.202250, _S8 9.597000, _S8 -9.223250,
	8, _S8 9.372750, _S8 -9.249500, _S8 9.010500, _S8 -9.394500, _S8 8.952250, _S8 -9.138000,
	8, _S8 8.805250, _S8 -8.491250, _S8 9.058000, _S8 -7.860500, _S8 9.300000, _S8 -7.250000,
	8, _S8 9.104500, _S8 -7.077000, _S8 9.188000, _S8 -6.846750, _S8 9.226000, _S8 -6.655000,
	8, _S8 9.403500, _S8 -5.753500, _S8 9.104000, _S8 -4.915500, _S8 8.913750, _S8 -4.047000,
	8, _S8 8.908000, _S8 -4.021000, _S8 8.993500, _S8 -3.971500, _S8 8.986500, _S8 -3.956000,
	8, _S8 8.681000, _S8 -3.284500, _S8 8.318000, _S8 -2.673250, _S8 7.863250, _S8 -2.078000,
	8, _S8 7.673750, _S8 -1.830000, _S8 7.455750, _S8 -1.601000, _S8 7.331500, _S8 -1.335250,
	8, _S8 7.239500, _S8 -1.138500, _S8 7.137500, _S8 -0.897000, _S8 7.200000, _S8 -0.650000,
	8, _S8 6.341250, _S8 0.045000, _S8 5.778750, _S8 1.006250, _S8 5.126000, _S8 1.967750,
	8, _S8 5.010500, _S8 2.137750, _S8 5.083250, _S8 2.440000, _S8 5.221000, _S8 2.507250,
	8, _S8 5.424250, _S8 2.606750, _S8 5.663250, _S8 2.350750, _S8 5.780750, _S8 2.139250,
	8, _S8 5.878000, _S8 1.964750, _S8 5.966250, _S8 1.802250, _S8 6.089000, _S8 1.641500,
	8, _S8 6.122250, _S8 1.597750, _S8 6.077500, _S8 1.493000, _S8 6.111250, _S8 1.462750,
	8, _S8 6.769500, _S8 0.876000, _S8 7.186750, _S8 0.142000, _S8 7.800000, _S8 -0.450000,
	8, _S8 8.287500, _S8 -0.532250, _S8 8.671750, _S8 -0.781750, _S8 9.108750, _S8 -1.035000,
	8, _S8 9.185750, _S8 -1.079750, _S8 9.316750, _S8 -1.017500, _S8 9.389250, _S8 -1.066250,
	8, _S8 9.827500, _S8 -1.360500, _S8 9.827000, _S8 -1.869500, _S8 9.853500, _S8 -2.347000,
	8, _S8 9.866000, _S8 -2.568000, _S8 9.915000, _S8 -2.897250, _S8 10.200000, _S8 -3.050000,
	0
};

/* path_data127 ===========================================*/
signed char path_data127[] = {
	2, _S8 7.989750, _S8 -4.166500,
	8, _S8 8.020750, _S8 -4.185750, _S8 7.982000, _S8 -4.291500, _S8 8.009250, _S8 -4.345500,
	8, _S8 8.049750, _S8 -4.426500, _S8 8.150500, _S8 -4.473500, _S8 8.191000, _S8 -4.554500,
	8, _S8 8.218250, _S8 -4.608500, _S8 8.177500, _S8 -4.703500, _S8 8.211500, _S8 -4.739000,
	8, _S8 8.794750, _S8 -5.350750, _S8 8.859000, _S8 -6.106750, _S8 8.600000, _S8 -6.850000,
	8, _S8 8.856000, _S8 -7.005000, _S8 8.871250, _S8 -7.320500, _S8 8.765000, _S8 -7.532250,
	8, _S8 8.551750, _S8 -7.957250, _S8 8.503500, _S8 -8.438750, _S8 8.259750, _S8 -8.824500,
	8, _S8 8.059250, _S8 -9.141750, _S8 7.664750, _S8 -9.452750, _S8 7.322000, _S8 -9.127000,
	8, _S8 7.216750, _S8 -9.027000, _S8 7.136500, _S8 -8.830250, _S8 7.206000, _S8 -8.652250,
	8, _S8 7.222000, _S8 -8.611500, _S8 7.293250, _S8 -8.575000, _S8 7.286500, _S8 -8.554500,
	8, _S8 7.259750, _S8 -8.473500, _S8 7.123250, _S8 -8.417500, _S8 7.121750, _S8 -8.349500,
	8, _S8 7.114250, _S8 -7.975500, _S8 6.875750, _S8 -7.597750, _S8 7.033250, _S8 -7.265500,
	8, _S8 7.226250, _S8 -6.858250, _S8 7.431000, _S8 -6.394000, _S8 7.600000, _S8 -5.950000,
	8, _S8 7.291500, _S8 -5.421000, _S8 7.549750, _S8 -4.808750, _S8 7.111500, _S8 -4.339500,
	8, _S8 7.077500, _S8 -4.303000, _S8 7.079750, _S8 -4.206500, _S8 7.110250, _S8 -4.156000,
	8, _S8 7.183250, _S8 -4.034500, _S8 7.284750, _S8 -3.933000, _S8 7.406250, _S8 -3.860000,
	8, _S8 7.456750, _S8 -3.829750, _S8 7.543750, _S8 -3.829250, _S8 7.593750, _S8 -3.860250,
	8, _S8 7.738250, _S8 -3.950750, _S8 7.837750, _S8 -4.072500, _S8 7.989750, _S8 -4.166500,
/* path_data128 ===========================================*/
	2, _S8 23.692751, _S8 -6.744250,
	8, _S8 24.040001, _S8 -6.296250, _S8 24.112499, _S8 -5.597500, _S8 23.600250, _S8 -5.250000,
	8, _S8 23.737749, _S8 -4.422750, _S8 24.575500, _S8 -4.917500, _S8 25.100250, _S8 -5.050000,
	8, _S8 25.073000, _S8 -5.147000, _S8 25.129749, _S8 -5.233000, _S8 25.200500, _S8 -5.234250,
	8, _S8 25.464750, _S8 -5.238000, _S8 25.634750, _S8 -5.496000, _S8 25.900249, _S8 -5.450000,
	8, _S8 26.008751, _S8 -5.839250, _S8 26.418249, _S8 -6.014750, _S8 26.579250, _S8 -6.359750,
	8, _S8 27.010750, _S8 -7.283500, _S8 26.863001, _S8 -8.351750, _S8 26.216999, _S8 -9.163250,
	8, _S8 26.166500, _S8 -9.226750, _S8 26.220751, _S8 -9.356000, _S8 26.189751, _S8 -9.446500,
	8, _S8 26.000750, _S8 -9.999250, _S8 25.483749, _S8 -10.078000, _S8 25.000250, _S8 -10.250000,
	8, _S8 24.705999, _S8 -11.218750, _S8 24.540751, _S8 -12.226500, _S8 24.100250, _S8 -13.150000,
	8, _S8 23.696751, _S8 -13.212500, _S8 23.522249, _S8 -13.647250, _S8 23.188000, _S8 -13.827250,
	8, _S8 22.854750, _S8 -14.007000, _S8 22.712749, _S8 -13.612250, _S8 22.723000, _S8 -13.350750,
	8, _S8 22.724751, _S8 -13.299500, _S8 22.837749, _S8 -13.243500, _S8 22.795250, _S8 -13.152250,
	8, _S8 22.776251, _S8 -13.111250, _S8 22.711250, _S8 -13.083500, _S8 22.711250, _S8 -13.050000,
	8, _S8 22.711500, _S8 -13.016250, _S8 22.766750, _S8 -12.983500, _S8 22.800249, _S8 -12.950000,
	8, _S8 22.570749, _S8 -12.745000, _S8 22.215000, _S8 -12.625750, _S8 22.141251, _S8 -12.339500,
	8, _S8 21.902750, _S8 -11.412000, _S8 22.546000, _S8 -10.630750, _S8 22.962999, _S8 -9.830500,
	8, _S8 23.110750, _S8 -9.546750, _S8 22.926750, _S8 -9.229000, _S8 22.736750, _S8 -8.927000,
	8, _S8 22.627251, _S8 -8.753250, _S8 22.654249, _S8 -8.471500, _S8 22.723249, _S8 -8.257500,
	8, _S8 22.911249, _S8 -7.674750, _S8 23.309000, _S8 -7.240000, _S8 23.692751, _S8 -6.744250,
/* path_data129 ===========================================*/
	2, _S8 14.402750, _S8 -2.147750,
	8, _S8 14.031000, _S8 -1.685000, _S8 13.178000, _S8 -1.042750, _S8 13.907250, _S8 -0.560750,
	8, _S8 13.955750, _S8 -0.528500, _S8 14.048250, _S8 -0.527500, _S8 14.091500, _S8 -0.561000,
	8, _S8 14.596750, _S8 -0.952250, _S8 15.097500, _S8 -1.178000, _S8 15.706500, _S8 -1.323500,
	8, _S8 15.737500, _S8 -1.330750, _S8 15.806000, _S8 -1.214000, _S8 15.898250, _S8 -1.254250,
	8, _S8 16.301500, _S8 -1.430000, _S8 16.804001, _S8 -1.415500, _S8 17.100000, _S8 -1.750000,
	8, _S8 18.041750, _S8 -1.694000, _S8 18.933001, _S8 -1.973000, _S8 19.780750, _S8 -2.300000,
	8, _S8 20.070999, _S8 -2.412000, _S8 20.388500, _S8 -2.551750, _S8 20.688749, _S8 -2.677250,
	8, _S8 21.032749, _S8 -2.821250, _S8 21.333750, _S8 -3.053250, _S8 21.611750, _S8 -3.338500,
	8, _S8 21.645000, _S8 -3.372500, _S8 21.733500, _S8 -3.350000, _S8 21.800249, _S8 -3.350000,
	8, _S8 21.790251, _S8 -3.565750, _S8 22.030750, _S8 -3.597500, _S8 22.092501, _S8 -3.753000,
	8, _S8 22.115499, _S8 -3.811000, _S8 22.077999, _S8 -3.910000, _S8 22.111250, _S8 -3.935500,
	8, _S8 22.645750, _S8 -4.343000, _S8 22.875750, _S8 -4.847500, _S8 22.583500, _S8 -5.441750,
	8, _S8 22.512251, _S8 -5.586250, _S8 22.450001, _S8 -5.740750, _S8 22.308500, _S8 -5.859750,
	8, _S8 22.037251, _S8 -6.087500, _S8 21.761749, _S8 -5.874000, _S8 21.500000, _S8 -5.950000,
	8, _S8 21.460251, _S8 -5.793000, _S8 21.278000, _S8 -5.836000, _S8 21.181499, _S8 -5.786500,
	8, _S8 20.966749, _S8 -5.676750, _S8 20.633499, _S8 -5.823000, _S8 20.418751, _S8 -5.713500,
	8, _S8 20.078251, _S8 -5.539750, _S8 19.768000, _S8 -5.497500, _S8 19.412500, _S8 -5.403250,
	8, _S8 19.334499, _S8 -5.382750, _S8 19.139999, _S8 -5.406750, _S8 19.100000, _S8 -5.250000,
	8, _S8 19.066500, _S8 -5.283500, _S8 19.029499, _S8 -5.342000, _S8 19.003000, _S8 -5.336500,
	8, _S8 18.525999, _S8 -5.237500, _S8 18.211000, _S8 -5.184000, _S8 17.885750, _S8 -4.761000,
	8, _S8 17.860001, _S8 -4.727750, _S8 17.749500, _S8 -4.772500, _S8 17.709749, _S8 -4.738750,
	8, _S8 17.470501, _S8 -4.536750, _S8 17.369249, _S8 -4.228250, _S8 17.094000, _S8 -4.060250,
	8, _S8 17.043751, _S8 -4.029500, _S8 16.955750, _S8 -4.071500, _S8 16.907249, _S8 -4.039250,
	8, _S8 16.745750, _S8 -3.931500, _S8 16.653999, _S8 -3.771250, _S8 16.493500, _S8 -3.659500,
	8, _S8 16.411249, _S8 -3.602250, _S8 16.311251, _S8 -3.683500, _S8 16.319250, _S8 -3.747500,
	8, _S8 16.380501, _S8 -4.234250, _S8 16.543751, _S8 -4.681000, _S8 16.400000, _S8 -5.150000,
	8, _S8 16.919250, _S8 -5.780000, _S8 17.548500, _S8 -6.267250, _S8 18.000000, _S8 -6.950000,
	8, _S8 18.003750, _S8 -7.491500, _S8 18.176750, _S8 -8.028000, _S8 18.148500, _S8 -8.547250,
	8, _S8 18.146000, _S8 -8.595500, _S8 18.073999, _S8 -8.778750, _S8 18.042500, _S8 -8.865500,
	8, _S8 17.964500, _S8 -9.079000, _S8 18.191000, _S8 -9.345500, _S8 17.980000, _S8 -9.526500,
	8, _S8 17.629000, _S8 -9.827250, _S8 17.306000, _S8 -9.608250, _S8 17.100000, _S8 -9.250000,
	8, _S8 16.640499, _S8 -9.152500, _S8 16.124001, _S8 -8.979250, _S8 15.729500, _S8 -9.287750,
	8, _S8 15.477750, _S8 -9.484500, _S8 15.333250, _S8 -9.711000, _S8 15.133500, _S8 -9.975000,
	8, _S8 14.887250, _S8 -10.300500, _S8 14.971000, _S8 -10.659500, _S8 14.988500, _S8 -11.050500,
	8, _S8 14.990000, _S8 -11.082500, _S8 14.911250, _S8 -11.116500, _S8 14.911250, _S8 -11.150000,
	8, _S8 14.911500, _S8 -11.183750, _S8 14.966500, _S8 -11.216500, _S8 15.000000, _S8 -11.250000,
	8, _S8 14.823500, _S8 -11.406500, _S8 14.754750, _S8 -11.671000, _S8 14.500000, _S8 -11.750000,
	8, _S8 14.576250, _S8 -12.023000, _S8 14.407250, _S8 -12.244000, _S8 14.189500, _S8 -12.319500,
	8, _S8 13.690750, _S8 -12.492250, _S8 13.271500, _S8 -12.014250, _S8 12.798500, _S8 -11.996000,
	8, _S8 12.670000, _S8 -11.991250, _S8 12.553250, _S8 -12.250750, _S8 12.391000, _S8 -12.332000,
	8, _S8 12.283000, _S8 -12.386000, _S8 12.107000, _S8 -12.394250, _S8 12.016500, _S8 -12.327750,
	8, _S8 11.844500, _S8 -12.201750, _S8 11.697250, _S8 -12.173250, _S8 11.507750, _S8 -12.122000,
	8, _S8 11.103500, _S8 -12.013000, _S8 10.784000, _S8 -11.739500, _S8 10.414000, _S8 -11.525750,
	8, _S8 10.042750, _S8 -11.311500, _S8 9.804000, _S8 -10.952250, _S8 9.534000, _S8 -10.622250,
	8, _S8 9.298750, _S8 -10.334250, _S8 9.264750, _S8 -9.730750, _S8 9.619750, _S8 -9.605750,
	8, _S8 10.080500, _S8 -9.443250, _S8 10.406500, _S8 -10.119000, _S8 10.898000, _S8 -10.037500,
	8, _S8 10.976000, _S8 -10.024750, _S8 11.027500, _S8 -9.947000, _S8 11.000000, _S8 -9.850000,
	8, _S8 11.097250, _S8 -9.822750, _S8 11.151750, _S8 -9.880000, _S8 11.200000, _S8 -9.950000,
	8, _S8 11.414500, _S8 -9.695250, _S8 11.705500, _S8 -9.611000, _S8 11.940000, _S8 -9.392750,
	8, _S8 12.182500, _S8 -9.166750, _S8 12.619000, _S8 -9.271250, _S8 12.872750, _S8 -9.022000,
	8, _S8 13.255000, _S8 -8.646500, _S8 13.115250, _S8 -7.976250, _S8 13.600000, _S8 -7.650000,
	8, _S8 13.453500, _S8 -7.321750, _S8 13.301750, _S8 -7.002500, _S8 13.218000, _S8 -6.645750,
	8, _S8 13.147500, _S8 -6.344250, _S8 13.396000, _S8 -6.045000, _S8 13.698750, _S8 -6.067750,
	8, _S8 14.013250, _S8 -6.091250, _S8 14.078750, _S8 -6.281000, _S8 14.200000, _S8 -6.550000,
	8, _S8 14.266750, _S8 -6.483250, _S8 14.384000, _S8 -6.409000, _S8 14.373750, _S8 -6.355000,
	8, _S8 14.259500, _S8 -5.758250, _S8 14.002750, _S8 -5.260000, _S8 13.888250, _S8 -4.652250,
	8, _S8 13.873500, _S8 -4.573000, _S8 13.797250, _S8 -4.522500, _S8 13.700000, _S8 -4.550000,
	8, _S8 13.583000, _S8 -3.512750, _S8 12.570000, _S8 -2.914250, _S8 11.933750, _S8 -2.123000,
	8, _S8 11.833000, _S8 -1.997500, _S8 11.832000, _S8 -1.685250, _S8 11.934250, _S8 -1.584500,
	8, _S8 12.285000, _S8 -1.237750, _S8 12.775000, _S8 -1.624250, _S8 13.200000, _S8 -1.750000,
	8, _S8 13.253250, _S8 -2.051500, _S8 13.468000, _S8 -2.287000, _S8 13.801000, _S8 -2.273000,
	8, _S8 13.865000, _S8 -2.270500, _S8 13.923750, _S8 -2.406000, _S8 14.004750, _S8 -2.438500,
	8, _S8 14.091750, _S8 -2.473000, _S8 14.217250, _S8 -2.417000, _S8 14.288750, _S8 -2.466500,
	8, _S8 14.721000, _S8 -2.765250, _S8 15.073000, _S8 -3.041750, _S8 15.507500, _S8 -3.339000,
	8, _S8 15.555500, _S8 -3.371750, _S8 15.641500, _S8 -3.332000, _S8 15.695500, _S8 -3.359000,
	8, _S8 15.776750, _S8 -3.399500, _S8 15.823500, _S8 -3.496250, _S8 15.904250, _S8 -3.542500,
	8, _S8 15.991250, _S8 -3.592500, _S8 16.051750, _S8 -3.520000, _S8 16.100000, _S8 -3.450000,
	8, _S8 15.938500, _S8 -3.362750, _S8 15.937500, _S8 -3.123500, _S8 15.792000, _S8 -3.073000,
	8, _S8 15.598250, _S8 -3.006000, _S8 15.458000, _S8 -2.877750, _S8 15.289500, _S8 -2.766000,
	8, _S8 15.216500, _S8 -2.717750, _S8 15.051750, _S8 -2.779750, _S8 15.025750, _S8 -2.735000,
	8, _S8 14.876250, _S8 -2.478000, _S8 14.580250, _S8 -2.368500, _S8 14.402750, _S8 -2.147750,
/* path_data130 ===========================================*/
	2, _S8 0.550000, _S8 -14.500000,
	8, _S8 0.550000, _S8 -14.500000, _S8 -1.759500, _S8 -15.218000, _S8 -4.550000, _S8 -8.800000,
	8, _S8 -4.550000, _S8 -8.800000, _S8 -5.150000, _S8 -7.500000, _S8 -5.750000, _S8 -7.000000,
	8, _S8 -6.350000, _S8 -6.500000, _S8 -9.150000, _S8 -5.600000, _S8 -9.650000, _S8 -4.600000,
	4, _S8 -12.250000, _S8 -0.600000,
	8, _S8 -12.250000, _S8 -0.600000, _S8 -8.550000, _S8 -4.600000, _S8 -7.750000, _S8 -5.200000,
	8, _S8 -7.750000, _S8 -5.200000, _S8 -5.750000, _S8 -7.300000, _S8 -6.550000, _S8 -5.600000,
	8, _S8 -6.550000, _S8 -5.600000, _S8 -10.050000, _S8 -2.900000, _S8 -9.750000, _S8 -0.600000,
	8, _S8 -9.750000, _S8 -0.600000, _S8 -11.150000, _S8 3.000000, _S8 -11.350000, _S8 3.500000,
	8, _S8 -11.350000, _S8 3.500000, _S8 -7.350000, _S8 -4.500000, _S8 -6.750000, _S8 -4.800000,
	8, _S8 -6.150000, _S8 -5.100000, _S8 -5.850000, _S8 -5.100000, _S8 -6.150000, _S8 -4.200000,
	8, _S8 -6.450000, _S8 -3.300000, _S8 -6.550000, _S8 0.800000, _S8 -7.250000, _S8 1.300000,
	8, _S8 -7.250000, _S8 1.300000, _S8 -5.250000, _S8 -3.800000, _S8 -5.450000, _S8 -4.600000,
	8, _S8 -5.450000, _S8 -4.600000, _S8 -4.650000, _S8 -5.500000, _S8 -4.050000, _S8 -4.200000,
	4, _S8 -4.350000, _S8 -0.200000,
	4, _S8 -3.250000, _S8 2.800000,
	8, _S8 -3.250000, _S8 2.800000, _S8 -3.850000, _S8 0.000000, _S8 -3.450000, _S8 -3.900000,
	8, _S8 -3.450000, _S8 -3.900000, _S8 -3.950000, _S8 -6.500000, _S8 -2.950000, _S8 -5.100000,
	8, _S8 -1.950000, _S8 -3.700000, _S8 0.450000, _S8 -2.200000, _S8 0.450000, _S8 -1.000000,
	8, _S8 0.450000, _S8 -1.000000, _S8 -0.850000, _S8 -5.400000, _S8 -3.150000, _S8 -6.600000,
	4, _S8 -4.150000, _S8 -5.100000,
	4, _S8 -4.450000, _S8 -5.600000,
	8, _S8 -4.450000, _S8 -5.600000, _S8 -5.350000, _S8 -5.800000, _S8 -4.250000, _S8 -7.500000,
	8, _S8 -3.150000, _S8 -9.200000, _S8 -3.250000, _S8 -9.400000, _S8 -3.250000, _S8 -9.400000,
	8, _S8 -3.250000, _S8 -9.400000, _S8 -1.650000, _S8 -7.600000, _S8 -1.250000, _S8 -7.600000,
	8, _S8 -1.250000, _S8 -7.600000, _S8 2.050000, _S8 -9.500000, _S8 2.350000, _S8 -3.400000,
	8, _S8 2.350000, _S8 -3.400000, _S8 4.050000, _S8 -7.000000, _S8 1.750000, _S8 -8.700000,
	8, _S8 1.750000, _S8 -8.700000, _S8 -1.950000, _S8 -9.200000, _S8 -1.650000, _S8 -10.500000,
	4, _S8 0.150000, _S8 -13.600000,
	8, _S8 1.050000, _S8 -14.900000, _S8 0.650000, _S8 -14.200000, _S8 0.650000, _S8 -14.200000,
	0
};

/* path_data131 ===========================================*/
signed char path_data131[] = {
	2, _S8 -4.450000, _S8 -10.400000,
	8, _S8 -4.450000, _S8 -10.400000, _S8 -7.650000, _S8 -10.400000, _S8 -8.450000, _S8 -9.100000,
	4, _S8 -10.250000, _S8 -6.700000,
	8, _S8 -10.250000, _S8 -6.700000, _S8 -5.950000, _S8 -9.200000, _S8 -4.950000, _S8 -9.500000,
	8, _S8 -3.950000, _S8 -9.800000, _S8 -4.450000, _S8 -10.400000, _S8 -4.450000, _S8 -10.400000,
	0
};

/* path_data132 ===========================================*/
signed char path_data132[] = {
	2, _S8 -14.450000, _S8 -8.800000,
	8, _S8 -14.450000, _S8 -8.800000, _S8 -14.950000, _S8 -8.500000, _S8 -15.050000, _S8 -7.800000,
	8, _S8 -15.150000, _S8 -7.100000, _S8 -15.750000, _S8 -7.000000, _S8 -15.550000, _S8 -6.300000,
	8, _S8 -15.350000, _S8 -5.600000, _S8 -14.850000, _S8 -5.000000, _S8 -14.850000, _S8 -6.000000,
	8, _S8 -14.850000, _S8 -7.000000, _S8 -14.450000, _S8 -7.500000, _S8 -14.250000, _S8 -7.800000,
	8, _S8 -14.050000, _S8 -8.100000, _S8 -13.650000, _S8 -9.200000, _S8 -14.450000, _S8 -8.800000,
/* path_data133 ===========================================*/
	2, _S8 -16.650000, _S8 6.500000,
	8, _S8 -16.650000, _S8 6.500000, _S8 -18.750000, _S8 5.500000, _S8 -19.549999, _S8 4.600000,
	8, _S8 -20.350000, _S8 3.700000, _S8 -20.237000, _S8 4.991500, _S8 -21.450001, _S8 4.900000,
	8, _S8 -22.911751, _S8 4.789750, _S8 -22.650000, _S8 0.800000, _S8 -22.650000, _S8 0.800000,
	4, _S8 -23.650000, _S8 2.700000,
	8, _S8 -23.650000, _S8 2.700000, _S8 -23.950001, _S8 6.300000, _S8 -21.950001, _S8 5.700000,
	8, _S8 -20.973249, _S8 5.407000, _S8 -20.650000, _S8 5.800000, _S8 -21.049999, _S8 6.000000,
	8, _S8 -21.450001, _S8 6.200000, _S8 -19.650000, _S8 6.300000, _S8 -20.350000, _S8 6.700000,
	8, _S8 -21.049999, _S8 7.100000, _S8 -17.450001, _S8 5.800000, _S8 -18.049999, _S8 8.400000,
	4, _S8 -16.650000, _S8 6.500000,
/* path_data134 ===========================================*/
	2, _S8 -19.799999, _S8 10.100000,
	8, _S8 -19.799999, _S8 10.100000, _S8 -23.650000, _S8 11.200000, _S8 -24.549999, _S8 8.800000,
	8, _S8 -24.549999, _S8 8.800000, _S8 -25.750000, _S8 9.400000, _S8 -25.200001, _S8 10.150000,
	8, _S8 -24.650000, _S8 10.900000, _S8 -24.350000, _S8 11.000000, _S8 -24.350000, _S8 11.000000,
	8, _S8 -24.350000, _S8 11.000000, _S8 -23.000000, _S8 11.300000, _S8 -23.150000, _S8 11.500000,
	8, _S8 -23.299999, _S8 11.700000, _S8 -23.900000, _S8 12.550000, _S8 -23.900000, _S8 12.550000,
	8, _S8 -23.900000, _S8 12.550000, _S8 -21.350000, _S8 11.050000, _S8 -19.799999, _S8 10.100000,
	0
};

/* path_data135 ===========================================*/
signed char path_data135[] = {
	2, _S8 37.300251, _S8 29.650249,
	8, _S8 37.193501, _S8 30.183750, _S8 36.775749, _S8 30.384001, _S8 36.300251, _S8 30.550249,
	8, _S8 35.820999, _S8 30.310749, _S8 35.171501, _S8 29.534250, _S8 34.700249, _S8 30.050249,
	8, _S8 34.581749, _S8 29.930250, _S8 34.387001, _S8 29.915251, _S8 34.300999, _S8 29.749750,
	8, _S8 34.184750, _S8 29.525249, _S8 34.252750, _S8 29.263750, _S8 34.167252, _S8 29.064251,
	8, _S8 34.030998, _S8 28.746250, _S8 33.853748, _S8 28.404751, _S8 33.900249, _S8 28.050249,
	8, _S8 34.351749, _S8 27.872250, _S8 34.500500, _S8 27.395750, _S8 34.382000, _S8 26.955000,
	8, _S8 34.364750, _S8 26.890751, _S8 34.257500, _S8 26.841499, _S8 34.307499, _S8 26.754250,
	8, _S8 34.354000, _S8 26.673500, _S8 34.433498, _S8 26.616751, _S8 34.500252, _S8 26.549999,
	8, _S8 34.466499, _S8 26.583750, _S8 34.430248, _S8 26.642000, _S8 34.402500, _S8 26.636999,
	8, _S8 34.250000, _S8 26.610500, _S8 34.280998, _S8 26.451250, _S8 34.313499, _S8 26.354500,
	8, _S8 34.459751, _S8 25.917999, _S8 34.963249, _S8 25.851999, _S8 35.300251, _S8 26.150000,
	8, _S8 35.364250, _S8 26.008751, _S8 35.491501, _S8 26.057249, _S8 35.600250, _S8 26.049999,
	8, _S8 35.587749, _S8 25.905251, _S8 35.689751, _S8 25.773500, _S8 35.739250, _S8 25.668501,
	8, _S8 35.868752, _S8 25.393999, _S8 36.276001, _S8 25.670500, _S8 36.475250, _S8 25.517500,
	8, _S8 36.744251, _S8 25.311251, _S8 37.009998, _S8 25.136499, _S8 37.279499, _S8 25.287251,
	8, _S8 37.731750, _S8 25.540501, _S8 38.159000, _S8 25.843500, _S8 38.458752, _S8 26.278749,
	8, _S8 38.602501, _S8 26.487249, _S8 38.662498, _S8 26.807501, _S8 38.647999, _S8 27.047001,
	8, _S8 38.638500, _S8 27.208750, _S8 38.293251, _S8 27.120750, _S8 38.207500, _S8 27.353001,
	8, _S8 38.046249, _S8 27.790001, _S8 38.504002, _S8 27.919750, _S8 38.693001, _S8 28.254250,
	8, _S8 38.742500, _S8 28.341499, _S8 38.676498, _S8 28.417500, _S8 38.597752, _S8 28.441999,
	8, _S8 38.494999, _S8 28.474001, _S8 38.299000, _S8 28.426750, _S8 38.333500, _S8 28.540001,
	8, _S8 38.576500, _S8 29.338249, _S8 37.887501, _S8 29.507750, _S8 37.300251, _S8 29.650249,
/* path_data136 ===========================================*/
	2, _S8 34.900002, _S8 34.550251,
	8, _S8 34.898251, _S8 34.115749, _S8 34.498001, _S8 33.676750, _S8 34.800251, _S8 33.250252,
	8, _S8 34.834000, _S8 33.283749, _S8 34.866749, _S8 33.339001, _S8 34.900249, _S8 33.339001,
	8, _S8 34.933998, _S8 33.339001, _S8 34.966751, _S8 33.283749, _S8 35.000252, _S8 33.250252,
	8, _S8 35.374001, _S8 33.804249, _S8 36.286999, _S8 34.036251, _S8 36.251499, _S8 34.747749,
	8, _S8 36.245998, _S8 34.859501, _S8 35.974251, _S8 35.089001, _S8 36.200249, _S8 35.250252,
	8, _S8 35.747002, _S8 35.587250, _S8 35.733250, _S8 36.179749, _S8 35.500252, _S8 36.650249,
	8, _S8 35.190750, _S8 36.578751, _S8 34.887749, _S8 36.487999, _S8 34.600250, _S8 36.350250,
	8, _S8 34.688251, _S8 35.978748, _S8 34.659000, _S8 35.557751, _S8 34.863998, _S8 35.227749,
	8, _S8 34.972500, _S8 35.053249, _S8 34.900749, _S8 34.783501, _S8 34.900002, _S8 34.550251,
	0
};

/* path_data137 ===========================================*/
signed char path_data137[] = {
	2, _S8 -6.650000, _S8 32.300251,
	8, _S8 -6.650000, _S8 32.300251, _S8 -10.864500, _S8 34.834251, _S8 -7.350000, _S8 31.000250,
	8, _S8 -5.150000, _S8 28.600250, _S8 -2.650000, _S8 27.200251, _S8 -2.650000, _S8 27.200251,
	8, _S8 -2.650000, _S8 27.200251, _S8 -0.050000, _S8 26.100000, _S8 0.850000, _S8 25.799999,
	8, _S8 1.750000, _S8 25.500000, _S8 5.550000, _S8 24.200001, _S8 6.350000, _S8 24.100000,
	8, _S8 7.150000, _S8 24.000000, _S8 9.550000, _S8 23.000000, _S8 11.250000, _S8 24.000000,
	8, _S8 12.950000, _S8 25.000000, _S8 14.950000, _S8 26.100000, _S8 14.950000, _S8 26.100000,
	8, _S8 14.950000, _S8 26.100000, _S8 10.850000, _S8 24.000000, _S8 9.950000, _S8 24.600000,
	8, _S8 9.050000, _S8 25.200001, _S8 7.250000, _S8 25.100000, _S8 5.750000, _S8 25.900000,
	8, _S8 5.750000, _S8 25.900000, _S8 2.050000, _S8 27.000250, _S8 1.250000, _S8 27.500250,
	8, _S8 0.450000, _S8 28.000250, _S8 -2.150000, _S8 30.900249, _S8 -2.550000, _S8 30.700251,
	8, _S8 -2.950000, _S8 30.500250, _S8 -2.450000, _S8 30.400249, _S8 -2.150000, _S8 29.700251,
	8, _S8 -1.850000, _S8 29.000250, _S8 -2.350000, _S8 28.600250, _S8 -4.350000, _S8 30.200251,
	8, _S8 -6.350000, _S8 31.800249, _S8 -6.650000, _S8 32.300251, _S8 -6.650000, _S8 32.300251,
	0
};

/* path_data138 ===========================================*/
signed char path_data138[] = {
	2, _S8 -4.798750, _S8 30.808500,
	8, _S8 -4.798750, _S8 30.808500, _S8 -4.446250, _S8 27.548500, _S8 -2.326750, _S8 27.964750,
	8, _S8 -2.326750, _S8 27.964750, _S8 -0.270250, _S8 26.922251, _S8 0.410250, _S8 26.430250,
	8, _S8 0.410250, _S8 26.430250, _S8 2.445000, _S8 26.004749, _S8 2.772500, _S8 25.850500,
	8, _S8 7.392250, _S8 23.675501, _S8 11.072000, _S8 24.805250, _S8 11.208750, _S8 24.525249,
	8, _S8 11.345250, _S8 24.245501, _S8 16.251499, _S8 26.024750, _S8 17.153749, _S8 27.046249,
	8, _S8 17.251499, _S8 27.157000, _S8 14.596000, _S8 25.646999, _S8 12.171500, _S8 25.174250,
	8, _S8 10.103250, _S8 24.770750, _S8 4.702750, _S8 25.236000, _S8 1.976250, _S8 26.620001,
	8, _S8 1.233000, _S8 26.997250, _S8 -1.003250, _S8 28.443251, _S8 -1.636000, _S8 28.415501,
	8, _S8 -2.268750, _S8 28.387501, _S8 -4.798750, _S8 30.808500, _S8 -4.798750, _S8 30.808500,
	0
};

/* path_data139 ===========================================*/
signed char path_data139[] = {
	2, _S8 -5.750000, _S8 37.200249,
	8, _S8 -5.750000, _S8 37.200249, _S8 -9.550000, _S8 36.600250, _S8 -5.350000, _S8 36.200249,
	8, _S8 -5.350000, _S8 36.200249, _S8 -0.850000, _S8 35.700249, _S8 0.150000, _S8 34.400249,
	8, _S8 0.150000, _S8 34.400249, _S8 3.550000, _S8 32.100250, _S8 4.250000, _S8 32.000252,
	8, _S8 4.950000, _S8 31.900249, _S8 12.450000, _S8 30.100250, _S8 12.550000, _S8 29.500250,
	8, _S8 12.650000, _S8 28.900249, _S8 14.050000, _S8 28.900249, _S8 14.450000, _S8 29.100250,
	8, _S8 14.850000, _S8 29.300249, _S8 14.650000, _S8 29.600250, _S8 13.950000, _S8 29.800249,
	8, _S8 13.250000, _S8 30.000250, _S8 5.450000, _S8 34.100250, _S8 3.850000, _S8 34.400249,
	8, _S8 2.250000, _S8 34.700249, _S8 -0.650000, _S8 36.600250, _S8 -1.850000, _S8 36.900249,
	8, _S8 -3.050000, _S8 37.200249, _S8 -5.750000, _S8 37.200249, _S8 -5.750000, _S8 37.200249,
	0
};

/* path_data140 ===========================================*/
signed char path_data140[] = {
	2, _S8 -0.870000, _S8 35.350750,
	8, _S8 -0.870000, _S8 35.350750, _S8 -3.015500, _S8 35.143501, _S8 -0.865250, _S8 34.938751,
	8, _S8 -0.865250, _S8 34.938751, _S8 1.338750, _S8 34.082748, _S8 1.850750, _S8 33.417000,
	8, _S8 1.850750, _S8 33.417000, _S8 3.591750, _S8 32.239250, _S8 3.950000, _S8 32.188251,
	8, _S8 4.308500, _S8 32.137001, _S8 7.798500, _S8 31.215250, _S8 7.849750, _S8 30.908251,
	8, _S8 7.901000, _S8 30.601000, _S8 16.417500, _S8 27.455750, _S8 17.522499, _S8 28.253250,
	8, _S8 18.250250, _S8 28.778500, _S8 15.775000, _S8 28.359249, _S8 13.366500, _S8 29.461750,
	8, _S8 13.027750, _S8 29.616751, _S8 4.564500, _S8 33.263500, _S8 3.745250, _S8 33.417000,
	8, _S8 2.926000, _S8 33.570751, _S8 1.441250, _S8 34.543499, _S8 0.826750, _S8 34.696999,
	8, _S8 0.212500, _S8 34.850750, _S8 -0.870000, _S8 35.350750, _S8 -0.870000, _S8 35.350750,
/* path_data141 ===========================================*/
	2, _S8 -2.850000, _S8 35.900249,
	8, _S8 -2.850000, _S8 35.900249, _S8 -1.550000, _S8 35.800251, _S8 -1.850000, _S8 36.200249,
	8, _S8 -2.150000, _S8 36.600250, _S8 -2.750000, _S8 36.400249, _S8 -2.750000, _S8 36.400249,
	4, _S8 -2.850000, _S8 35.900249,
/* path_data142 ===========================================*/
	2, _S8 -4.650000, _S8 36.300251,
	8, _S8 -4.650000, _S8 36.300251, _S8 -3.350000, _S8 36.200249, _S8 -3.650000, _S8 36.600250,
	8, _S8 -3.950000, _S8 37.000252, _S8 -4.550000, _S8 36.800251, _S8 -4.550000, _S8 36.800251,
	4, _S8 -4.650000, _S8 36.300251,
/* path_data143 ===========================================*/
	2, _S8 -7.250000, _S8 36.700249,
	8, _S8 -7.250000, _S8 36.700249, _S8 -5.950000, _S8 36.600250, _S8 -6.250000, _S8 37.000252,
	8, _S8 -6.550000, _S8 37.400249, _S8 -7.150000, _S8 37.200249, _S8 -7.150000, _S8 37.200249,
	4, _S8 -7.250000, _S8 36.700249,
/* path_data144 ===========================================*/
	2, _S8 -9.150000, _S8 36.900249,
	8, _S8 -9.150000, _S8 36.900249, _S8 -7.850000, _S8 36.800251, _S8 -8.150000, _S8 37.200249,
	8, _S8 -8.450000, _S8 37.600250, _S8 -9.050000, _S8 37.400249, _S8 -9.050000, _S8 37.400249,
	4, _S8 -9.150000, _S8 36.900249,
/* path_data145 ===========================================*/
	2, _S8 0.450000, _S8 27.000250,
	8, _S8 0.450000, _S8 27.000250, _S8 1.550000, _S8 27.000250, _S8 1.250000, _S8 27.400249,
	8, _S8 0.950000, _S8 27.800249, _S8 0.150000, _S8 27.700251, _S8 0.150000, _S8 27.700251,
	4, _S8 0.450000, _S8 27.000250,
/* path_data146 ===========================================*/
	2, _S8 -2.050000, _S8 28.400249,
	8, _S8 -2.050000, _S8 28.400249, _S8 -0.423500, _S8 27.865000, _S8 -1.050000, _S8 28.700251,
	8, _S8 -1.350000, _S8 29.100250, _S8 -1.950000, _S8 28.900249, _S8 -1.950000, _S8 28.900249,
	4, _S8 -2.050000, _S8 28.400249,
/* path_data147 ===========================================*/
	2, _S8 -4.850000, _S8 29.600250,
	8, _S8 -4.850000, _S8 29.600250, _S8 -3.550000, _S8 29.500250, _S8 -3.850000, _S8 29.900249,
	8, _S8 -4.150000, _S8 30.300249, _S8 -4.750000, _S8 30.100250, _S8 -4.750000, _S8 30.100250,
	4, _S8 -4.850000, _S8 29.600250,
/* path_data148 ===========================================*/
	2, _S8 -6.750000, _S8 31.100250,
	8, _S8 -6.750000, _S8 31.100250, _S8 -5.450000, _S8 31.000250, _S8 -5.750000, _S8 31.400249,
	8, _S8 -6.050000, _S8 31.800249, _S8 -6.650000, _S8 31.600250, _S8 -6.650000, _S8 31.600250,
	4, _S8 -6.750000, _S8 31.100250,
/* path_data149 ===========================================*/
	2, _S8 -8.450000, _S8 32.300251,
	8, _S8 -8.450000, _S8 32.300251, _S8 -7.150000, _S8 32.200249, _S8 -7.450000, _S8 32.600250,
	8, _S8 -7.750000, _S8 33.000252, _S8 -8.350000, _S8 32.800251, _S8 -8.350000, _S8 32.800251,
	4, _S8 -8.450000, _S8 32.300251,
	0
};

/* path_data150 ===========================================*/
signed char path_data150[] = {
	2, _S8 1.320500, _S8 33.899502,
	8, _S8 1.320500, _S8 33.899502, _S8 3.050750, _S8 33.766499, _S8 2.651500, _S8 34.298752,
	8, _S8 2.252250, _S8 34.831249, _S8 1.453500, _S8 34.564999, _S8 1.453500, _S8 34.564999,
	4, _S8 1.320500, _S8 33.899502,
/* path_data151 ===========================================*/
	2, _S8 3.920500, _S8 32.699501,
	8, _S8 3.920500, _S8 32.699501, _S8 5.650750, _S8 32.566502, _S8 5.251500, _S8 33.098751,
	8, _S8 4.852250, _S8 33.631248, _S8 4.053500, _S8 33.365002, _S8 4.053500, _S8 33.365002,
	4, _S8 3.920500, _S8 32.699501,
/* path_data152 ===========================================*/
	2, _S8 6.620500, _S8 31.599501,
	8, _S8 6.620500, _S8 31.599501, _S8 8.350750, _S8 31.466499, _S8 7.951500, _S8 31.998751,
	8, _S8 7.552250, _S8 32.531250, _S8 6.753500, _S8 32.264999, _S8 6.753500, _S8 32.264999,
	4, _S8 6.620500, _S8 31.599501,
/* path_data153 ===========================================*/
	2, _S8 9.220500, _S8 30.399500,
	8, _S8 9.220500, _S8 30.399500, _S8 10.950750, _S8 30.266500, _S8 10.551500, _S8 30.798750,
	8, _S8 10.152250, _S8 31.331249, _S8 9.353500, _S8 31.065001, _S8 9.353500, _S8 31.065001,
	4, _S8 9.220500, _S8 30.399500,
/* path_data154 ===========================================*/
	2, _S8 2.320500, _S8 25.899500,
	8, _S8 2.320500, _S8 25.899500, _S8 4.050750, _S8 25.766500, _S8 3.651500, _S8 26.298750,
	8, _S8 3.252250, _S8 26.831249, _S8 2.253500, _S8 26.764999, _S8 2.253500, _S8 26.764999,
	4, _S8 2.320500, _S8 25.899500,
/* path_data155 ===========================================*/
	2, _S8 4.820500, _S8 25.099501,
	8, _S8 4.820500, _S8 25.099501, _S8 6.550750, _S8 24.966499, _S8 6.151500, _S8 25.498751,
	8, _S8 5.752250, _S8 26.031250, _S8 4.653500, _S8 25.965000, _S8 4.653500, _S8 25.965000,
	4, _S8 4.820500, _S8 25.099501,
/* path_data156 ===========================================*/
	2, _S8 -0.850000, _S8 35.100250,
	8, _S8 -0.850000, _S8 35.100250, _S8 0.450000, _S8 35.000252, _S8 0.150000, _S8 35.400249,
	8, _S8 -0.150000, _S8 35.800251, _S8 -0.750000, _S8 35.600250, _S8 -0.750000, _S8 35.600250,
	4, _S8 -0.850000, _S8 35.100250,
	0
};

/* path_data157 ===========================================*/
signed char path_data157[] = {
	2, _S8 -19.150000, _S8 10.300000,
	8, _S8 -19.150000, _S8 10.300000, _S8 -20.250000, _S8 12.500000, _S8 -20.350000, _S8 13.300000,
	8, _S8 -20.350000, _S8 13.300000, _S8 -20.150000, _S8 11.100000, _S8 -19.850000, _S8 10.600000,
	8, _S8 -19.549999, _S8 10.100000, _S8 -19.150000, _S8 10.300000, _S8 -19.150000, _S8 10.300000,
/* path_data158 ===========================================*/
	2, _S8 -23.750000, _S8 13.800000,
	8, _S8 -23.750000, _S8 13.800000, _S8 -24.549999, _S8 17.400000, _S8 -24.450001, _S8 18.100000,
	8, _S8 -24.450001, _S8 18.100000, _S8 -24.750000, _S8 15.200000, _S8 -24.650000, _S8 14.900000,
	8, _S8 -24.549999, _S8 14.600000, _S8 -23.750000, _S8 13.800000, _S8 -23.750000, _S8 13.800000,
	0
};

/* path_data159 ===========================================*/
signed char path_data159[] = {
	2, _S8 -18.549999, _S8 -4.850000,
	4, _S8 -18.600000, _S8 -4.050000,
	4, _S8 -19.150000, _S8 -4.000000,
	8, _S8 -19.150000, _S8 -4.000000, _S8 -15.600000, _S8 -0.850000, _S8 -15.450000, _S8 1.050000,
	8, _S8 -15.450000, _S8 1.050000, _S8 -15.250000, _S8 -1.000000, _S8 -18.549999, _S8 -4.850000,
	0
};

/* path_data160 ===========================================*/
signed char path_data160[] = {
	2, _S8 -17.554001, _S8 -4.533750,
	8, _S8 -17.661751, _S8 -4.637750, _S8 -17.607000, _S8 -4.824000, _S8 -17.709000, _S8 -4.889000,
	8, _S8 -17.911249, _S8 -5.018000, _S8 -17.384501, _S8 -5.032250, _S8 -17.441500, _S8 -5.211250,
	8, _S8 -17.537251, _S8 -5.512750, _S8 -17.490499, _S8 -5.518000, _S8 -17.521000, _S8 -5.837000,
	8, _S8 -17.535250, _S8 -5.986500, _S8 -17.388250, _S8 -6.371500, _S8 -17.292000, _S8 -6.481500,
	8, _S8 -16.930500, _S8 -6.894500, _S8 -17.261499, _S8 -7.627500, _S8 -16.851500, _S8 -8.015250,
	8, _S8 -16.775499, _S8 -8.087500, _S8 -16.681499, _S8 -8.225500, _S8 -16.610250, _S8 -8.330000,
	8, _S8 -16.445499, _S8 -8.570750, _S8 -16.149500, _S8 -8.692750, _S8 -15.912000, _S8 -8.899750,
	8, _S8 -15.832500, _S8 -8.968750, _S8 -15.882750, _S8 -9.175500, _S8 -15.740500, _S8 -9.152500,
	8, _S8 -15.562000, _S8 -9.123750, _S8 -15.251750, _S8 -9.156250, _S8 -15.263000, _S8 -8.946000,
	8, _S8 -15.291250, _S8 -8.416000, _S8 -15.623500, _S8 -7.986000, _S8 -15.943500, _S8 -7.569000,
	8, _S8 -15.830750, _S8 -7.393000, _S8 -15.945250, _S8 -7.234250, _S8 -16.016251, _S8 -7.095000,
	8, _S8 -16.350000, _S8 -6.440000, _S8 -16.302750, _S8 -5.729750, _S8 -16.346251, _S8 -5.019750,
	8, _S8 -16.347500, _S8 -4.998500, _S8 -16.424250, _S8 -4.979000, _S8 -16.422251, _S8 -4.965750,
	8, _S8 -16.334000, _S8 -4.382000, _S8 -16.188000, _S8 -3.832250, _S8 -15.968250, _S8 -3.275000,
	8, _S8 -15.876750, _S8 -3.042500, _S8 -15.759000, _S8 -2.818750, _S8 -15.721500, _S8 -2.587000,
	8, _S8 -15.693750, _S8 -2.415500, _S8 -15.668000, _S8 -2.207250, _S8 -15.770000, _S8 -2.031000,
	8, _S8 -15.261250, _S8 -1.308500, _S8 -15.588500, _S8 -0.645750, _S8 -15.296250, _S8 0.237000,
	8, _S8 -15.244500, _S8 0.393250, _S8 -14.821500, _S8 0.871750, _S8 -14.937250, _S8 0.831500,
	8, _S8 -15.565500, _S8 0.613750, _S8 -15.593500, _S8 0.514250, _S8 -15.637750, _S8 0.326000,
	8, _S8 -15.674250, _S8 0.170250, _S8 -15.756750, _S8 -0.174000, _S8 -15.816000, _S8 -0.324500,
	8, _S8 -15.832000, _S8 -0.365500, _S8 -15.874750, _S8 -0.836500, _S8 -15.894250, _S8 -0.867000,
	8, _S8 -16.272499, _S8 -1.462500, _S8 -15.933000, _S8 -1.418500, _S8 -16.275499, _S8 -2.008000,
	8, _S8 -16.632500, _S8 -2.178000, _S8 -16.874001, _S8 -2.454000, _S8 -17.154751, _S8 -2.744500,
	8, _S8 -17.204250, _S8 -2.795500, _S8 -16.918501, _S8 -2.976500, _S8 -16.963751, _S8 -3.029750,
	8, _S8 -17.236750, _S8 -3.352000, _S8 -17.525000, _S8 -3.543750, _S8 -17.441000, _S8 -3.917000,
	8, _S8 -17.402250, _S8 -4.089500, _S8 -17.368000, _S8 -4.353750, _S8 -17.554001, _S8 -4.533750,
	0
};

/* path_data161 ===========================================*/
signed char path_data161[] = {
	2, _S8 -18.450001, _S8 -4.100000,
	8, _S8 -18.450001, _S8 -4.100000, _S8 -18.350000, _S8 -2.400000, _S8 -17.750000, _S8 -2.000000,
	8, _S8 -17.150000, _S8 -1.600000, _S8 -17.450001, _S8 -1.800000, _S8 -18.250000, _S8 -2.100000,
	8, _S8 -19.049999, _S8 -2.400000, _S8 -18.750000, _S8 -2.600000, _S8 -18.750000, _S8 -2.600000,
	8, _S8 -18.750000, _S8 -2.600000, _S8 -19.450001, _S8 -2.500000, _S8 -18.850000, _S8 -2.000000,
	8, _S8 -18.250000, _S8 -1.500000, _S8 -17.350000, _S8 -0.900000, _S8 -17.750000, _S8 -0.900000,
	8, _S8 -18.150000, _S8 -0.900000, _S8 -20.049999, _S8 -1.900000, _S8 -20.049999, _S8 -2.600000,
	8, _S8 -20.049999, _S8 -3.300000, _S8 -20.299999, _S8 -4.325000, _S8 -20.299999, _S8 -4.325000,
	8, _S8 -20.299999, _S8 -4.325000, _S8 -20.025000, _S8 -4.525000, _S8 -18.825001, _S8 -4.500000,
	8, _S8 -18.825001, _S8 -4.500000, _S8 -18.475000, _S8 -4.325000, _S8 -18.450001, _S8 -4.100000,
	0
};

/* path_data162 ===========================================*/
signed char path_data162[] = {
	2, _S8 -18.650000, _S8 0.550000,
	8, _S8 -18.650000, _S8 0.550000, _S8 -20.780001, _S8 -0.147750, _S8 -25.400000, _S8 0.700000,
	8, _S8 -25.400000, _S8 0.700000, _S8 -23.142250, _S8 0.180500, _S8 -18.450001, _S8 0.750000,
	8, _S8 -15.875000, _S8 1.062500, _S8 -18.650000, _S8 0.550000, _S8 -18.650000, _S8 0.550000,
	0
};

/* path_data163 ===========================================*/
signed char path_data163[] = {
	2, _S8 -18.125500, _S8 0.532250,
	8, _S8 -18.125500, _S8 0.532250, _S8 -20.187000, _S8 -0.347250, _S8 -24.863251, _S8 0.098000,
	8, _S8 -24.863251, _S8 0.098000, _S8 -22.568750, _S8 -0.224250, _S8 -17.943501, _S8 0.748750,
	8, _S8 -15.405000, _S8 1.282750, _S8 -18.125500, _S8 0.532250, _S8 -18.125500, _S8 0.532250,
	0
};

/* path_data164 ===========================================*/
signed char path_data164[] = {
	2, _S8 -17.678499, _S8 0.555500,
	8, _S8 -17.678499, _S8 0.555500, _S8 -19.669001, _S8 -0.474750, _S8 -24.365250, _S8 -0.378500,
	8, _S8 -24.365250, _S8 -0.378500, _S8 -22.053249, _S8 -0.529500, _S8 -17.513000, _S8 0.785000,
	8, _S8 -15.021500, _S8 1.506250, _S8 -17.678499, _S8 0.555500, _S8 -17.678499, _S8 0.555500,
	0
};

/* path_data165 ===========================================*/
signed char path_data165[] = {
	2, _S8 -17.361000, _S8 0.611250,
	8, _S8 -17.361000, _S8 0.611250, _S8 -19.066999, _S8 -0.465500, _S8 -23.285500, _S8 -0.740000,
	8, _S8 -23.285500, _S8 -0.740000, _S8 -21.200750, _S8 -0.697500, _S8 -17.230499, _S8 0.829750,
	8, _S8 -15.051500, _S8 1.668000, _S8 -17.361000, _S8 0.611250, _S8 -17.361000, _S8 0.611250,
	0
};

/* path_data166 ===========================================*/
signed char path_data166[] = {
	2, _S8 11.460000, _S8 3.240250,
	8, _S8 11.460000, _S8 3.240250, _S8 11.227500, _S8 3.401250, _S8 11.281000, _S8 3.106000,
	8, _S8 11.334750, _S8 2.810750, _S8 18.386749, _S8 -0.481750, _S8 19.290251, _S8 -0.419250,
	8, _S8 19.290251, _S8 -0.419250, _S8 11.728250, _S8 2.882250, _S8 11.460000, _S8 3.240250,
	0
};

/* path_data167 ===========================================*/
signed char path_data167[] = {
	2, _S8 10.611500, _S8 3.400000,
	8, _S8 10.611500, _S8 3.400000, _S8 10.392500, _S8 3.578750, _S8 10.422750, _S8 3.280250,
	8, _S8 10.453000, _S8 2.981750, _S8 17.224751, _S8 -0.854500, _S8 18.130251, _S8 -0.863000,
	8, _S8 18.130251, _S8 -0.863000, _S8 10.851000, _S8 3.022250, _S8 10.611500, _S8 3.400000,
	0
};

/* path_data168 ===========================================*/
signed char path_data168[] = {
	2, _S8 9.790000, _S8 3.743750,
	8, _S8 9.790000, _S8 3.743750, _S8 9.583000, _S8 3.936750, _S8 9.593500, _S8 3.636750,
	8, _S8 9.604000, _S8 3.337000, _S8 14.558250, _S8 -0.537250, _S8 17.011250, _S8 -1.005750,
	8, _S8 17.011250, _S8 -1.005750, _S8 12.503750, _S8 1.026000, _S8 9.790000, _S8 3.743750,
	0
};

/* path_data169 ===========================================*/
signed char path_data169[] = {
	2, _S8 9.071000, _S8 4.209500,
	8, _S8 9.071000, _S8 4.209500, _S8 8.884750, _S8 4.383000, _S8 8.894250, _S8 4.113250,
	8, _S8 8.903750, _S8 3.843250, _S8 13.362250, _S8 0.356500, _S8 15.570000, _S8 -0.065000,
	8, _S8 15.570000, _S8 -0.065000, _S8 11.513500, _S8 1.763500, _S8 9.071000, _S8 4.209500,
	0
};

/* path_data170 ===========================================*/
signed char path_data170[] = {
	2, _S8 1.150000, _S8 41.200249,
	8, _S8 1.150000, _S8 41.200249, _S8 -2.650000, _S8 40.600250, _S8 1.550000, _S8 40.200249,
	8, _S8 1.550000, _S8 40.200249, _S8 6.050000, _S8 39.700249, _S8 7.050000, _S8 38.400249,
	8, _S8 7.050000, _S8 38.400249, _S8 10.450000, _S8 36.100250, _S8 11.150000, _S8 36.000252,
	8, _S8 11.850000, _S8 35.900249, _S8 15.950000, _S8 35.000252, _S8 16.049999, _S8 34.400249,
	8, _S8 16.150000, _S8 33.800251, _S8 17.650000, _S8 33.200249, _S8 18.049999, _S8 33.400249,
	8, _S8 18.450001, _S8 33.600250, _S8 18.450001, _S8 35.900249, _S8 17.750000, _S8 36.100250,
	8, _S8 17.049999, _S8 36.300251, _S8 12.350000, _S8 38.100250, _S8 10.750000, _S8 38.400249,
	8, _S8 9.150000, _S8 38.700249, _S8 6.250000, _S8 40.600250, _S8 5.050000, _S8 40.900249,
	8, _S8 3.850000, _S8 41.200249, _S8 1.150000, _S8 41.200249, _S8 1.150000, _S8 41.200249,
	0
};

/* path_data171 ===========================================*/
signed char path_data171[] = {
	2, _S8 19.400000, _S8 31.850250,
	8, _S8 19.400000, _S8 31.850250, _S8 18.650000, _S8 32.250252, _S8 18.350000, _S8 32.900249,
	8, _S8 18.350000, _S8 32.900249, _S8 16.750000, _S8 35.550251, _S8 13.200000, _S8 36.350250,
	8, _S8 13.200000, _S8 36.350250, _S8 7.450000, _S8 38.600250, _S8 5.500000, _S8 39.100250,
	8, _S8 5.500000, _S8 39.100250, _S8 2.150000, _S8 40.350250, _S8 0.300000, _S8 40.150249,
	8, _S8 0.300000, _S8 40.150249, _S8 -1.450000, _S8 40.200249, _S8 0.100000, _S8 40.600250,
	8, _S8 0.100000, _S8 40.600250, _S8 5.150000, _S8 40.100250, _S8 6.000000, _S8 39.650249,
	8, _S8 6.000000, _S8 39.650249, _S8 9.900000, _S8 38.350250, _S8 10.650000, _S8 37.700249,
	8, _S8 11.400000, _S8 37.050251, _S8 15.950000, _S8 35.800251, _S8 16.500000, _S8 35.300251,
	8, _S8 17.049999, _S8 34.800251, _S8 19.500000, _S8 32.700249, _S8 19.400000, _S8 31.850250,
	0
};

/* path_data172 ===========================================*/
signed char path_data172[] = {
	2, _S8 4.720500, _S8 39.727749,
	8, _S8 4.720500, _S8 39.727749, _S8 6.027750, _S8 39.671249, _S8 5.739500, _S8 40.058498,
	8, _S8 5.451250, _S8 40.445999, _S8 4.839250, _S8 40.227501, _S8 4.839250, _S8 40.227501,
	4, _S8 4.720500, _S8 39.727749,
/* path_data173 ===========================================*/
	2, _S8 2.920000, _S8 40.065750,
	8, _S8 2.920000, _S8 40.065750, _S8 4.227000, _S8 40.009251, _S8 3.939000, _S8 40.396500,
	8, _S8 3.650750, _S8 40.784000, _S8 3.038750, _S8 40.565750, _S8 3.038750, _S8 40.565750,
	4, _S8 2.920000, _S8 40.065750,
/* path_data174 ===========================================*/
	2, _S8 0.312750, _S8 40.377750,
	8, _S8 0.312750, _S8 40.377750, _S8 1.620000, _S8 40.320999, _S8 1.331750, _S8 40.708500,
	8, _S8 1.043500, _S8 41.095749, _S8 0.431500, _S8 40.877499, _S8 0.431500, _S8 40.877499,
	4, _S8 0.312750, _S8 40.377750,
	0
};

/* path_data175 ===========================================*/
signed char path_data175[] = {
	2, _S8 -1.595750, _S8 40.513748,
	8, _S8 -1.595750, _S8 40.513748, _S8 -0.288500, _S8 40.457249, _S8 -0.576750, _S8 40.844501,
	8, _S8 -0.865000, _S8 41.231998, _S8 -1.477000, _S8 41.013500, _S8 -1.477000, _S8 41.013500,
	4, _S8 -1.595750, _S8 40.513748,
/* path_data176 ===========================================*/
	2, _S8 8.853750, _S8 37.878250,
	8, _S8 8.853750, _S8 37.878250, _S8 10.593750, _S8 37.803001, _S8 10.210000, _S8 38.318501,
	8, _S8 9.826500, _S8 38.834000, _S8 9.011750, _S8 38.543499, _S8 9.011750, _S8 38.543499,
	4, _S8 8.853750, _S8 37.878250,
/* path_data177 ===========================================*/
	2, _S8 11.432500, _S8 36.771999,
	8, _S8 11.432500, _S8 36.771999, _S8 12.922250, _S8 35.946751, _S8 12.788750, _S8 37.212250,
	8, _S8 12.721250, _S8 37.851250, _S8 11.590500, _S8 37.437248, _S8 11.590500, _S8 37.437248,
	4, _S8 11.432500, _S8 36.771999,
/* path_data178 ===========================================*/
	2, _S8 13.715500, _S8 36.068501,
	8, _S8 13.715500, _S8 36.068501, _S8 15.505250, _S8 35.143250, _S8 15.071750, _S8 36.508751,
	8, _S8 14.877250, _S8 37.121250, _S8 13.873250, _S8 36.733749, _S8 13.873250, _S8 36.733749,
	4, _S8 13.715500, _S8 36.068501,
/* path_data179 ===========================================*/
	2, _S8 16.094000, _S8 34.862251,
	8, _S8 16.094000, _S8 34.862251, _S8 17.183750, _S8 33.637001, _S8 17.450251, _S8 35.302502,
	8, _S8 17.551750, _S8 35.937000, _S8 16.252001, _S8 35.527500, _S8 16.252001, _S8 35.527500,
	4, _S8 16.094000, _S8 34.862251,
/* path_data180 ===========================================*/
	2, _S8 6.708500, _S8 38.999249,
	8, _S8 6.708500, _S8 38.999249, _S8 8.015500, _S8 38.942501, _S8 7.727500, _S8 39.330002,
	8, _S8 7.439250, _S8 39.717251, _S8 6.827000, _S8 39.499001, _S8 6.827000, _S8 39.499001,
	4, _S8 6.708500, _S8 38.999249,
	0
};

/* path_data181 ===========================================*/
signed char path_data181[] = {
	2, _S8 15.608500, _S8 8.650750,
	8, _S8 15.608500, _S8 8.650750, _S8 15.427000, _S8 8.817000, _S8 15.426750, _S8 8.549250,
	8, _S8 15.426750, _S8 8.281750, _S8 19.797750, _S8 4.965750, _S8 22.008499, _S8 4.619750,
	8, _S8 22.008499, _S8 4.619750, _S8 17.983749, _S8 6.302000, _S8 15.608500, _S8 8.650750,
	0
};

/* path_data182 ===========================================*/
signed char path_data182[] = {
	2, _S8 16.350000, _S8 24.600000,
	8, _S8 16.350000, _S8 24.600000, _S8 21.850250, _S8 30.200251, _S8 24.150249, _S8 31.100250,
	8, _S8 24.150249, _S8 31.100250, _S8 26.450251, _S8 33.900249, _S8 25.450251, _S8 40.400249,
	8, _S8 25.450251, _S8 40.400249, _S8 24.650249, _S8 42.300251, _S8 23.850250, _S8 37.100250,
	8, _S8 23.850250, _S8 37.100250, _S8 24.650249, _S8 30.800249, _S8 21.850250, _S8 34.800251,
	8, _S8 21.850250, _S8 34.800251, _S8 19.750000, _S8 32.325249, _S8 21.350000, _S8 32.400249,
	8, _S8 21.350000, _S8 32.400249, _S8 22.150249, _S8 32.900249, _S8 22.250250, _S8 32.500252,
	8, _S8 22.350250, _S8 32.100250, _S8 20.350000, _S8 28.700251, _S8 16.049999, _S8 25.100000,
	8, _S8 11.750000, _S8 21.500000, _S8 16.350000, _S8 24.600000, _S8 16.350000, _S8 24.600000,
	0
};

/* path_data183 ===========================================*/
signed char path_data183[] = {
	2, _S8 1.750000, _S8 34.300251,
	8, _S8 1.750000, _S8 34.300251, _S8 1.700000, _S8 33.850250, _S8 2.150000, _S8 34.050251,
	8, _S8 2.600000, _S8 34.250252, _S8 26.150249, _S8 35.800251, _S8 34.050251, _S8 41.800251,
	8, _S8 34.050251, _S8 41.800251, _S8 22.750250, _S8 36.000252, _S8 1.750000, _S8 34.300251,
/* path_data184 ===========================================*/
	2, _S8 4.350000, _S8 33.200249,
	8, _S8 4.350000, _S8 33.200249, _S8 4.300000, _S8 32.750252, _S8 4.750000, _S8 32.950249,
	8, _S8 5.200000, _S8 33.150249, _S8 39.350250, _S8 32.900249, _S8 45.250252, _S8 41.000252,
	8, _S8 45.250252, _S8 41.000252, _S8 39.750252, _S8 34.700249, _S8 4.350000, _S8 33.200249,
/* path_data185 ===========================================*/
	2, _S8 7.250000, _S8 32.200249,
	8, _S8 7.250000, _S8 32.200249, _S8 7.200000, _S8 31.750250, _S8 7.650000, _S8 31.950251,
	8, _S8 8.100000, _S8 32.150249, _S8 51.450249, _S8 28.900249, _S8 57.350250, _S8 37.000252,
	8, _S8 57.350250, _S8 37.000252, _S8 54.950249, _S8 30.600250, _S8 7.250000, _S8 32.200249,
/* path_data186 ===========================================*/
	2, _S8 9.750000, _S8 31.000250,
	8, _S8 9.750000, _S8 31.000250, _S8 9.700000, _S8 30.550249, _S8 10.150000, _S8 30.750250,
	8, _S8 10.600000, _S8 30.950251, _S8 41.150249, _S8 21.299999, _S8 47.050251, _S8 29.400249,
	8, _S8 47.050251, _S8 29.400249, _S8 43.700249, _S8 23.250000, _S8 9.750000, _S8 31.000250,
/* path_data187 ===========================================*/
	2, _S8 -4.750000, _S8 36.700249,
	8, _S8 -4.750000, _S8 36.700249, _S8 -4.800000, _S8 36.250252, _S8 -4.350000, _S8 36.450249,
	8, _S8 -3.900000, _S8 36.650249, _S8 0.550000, _S8 37.200249, _S8 1.050000, _S8 46.900249,
	8, _S8 1.050000, _S8 46.900249, _S8 -0.750000, _S8 36.400249, _S8 -4.750000, _S8 36.700249,
/* path_data188 ===========================================*/
	2, _S8 -6.950000, _S8 37.100250,
	8, _S8 -6.950000, _S8 37.100250, _S8 -7.000000, _S8 36.650249, _S8 -6.550000, _S8 36.850250,
	8, _S8 -6.100000, _S8 37.050251, _S8 -2.550000, _S8 35.900249, _S8 -3.250000, _S8 45.600250,
	8, _S8 -3.250000, _S8 45.600250, _S8 -2.950000, _S8 36.800251, _S8 -6.950000, _S8 37.100250,
/* path_data189 ===========================================*/
	2, _S8 -8.950000, _S8 37.200249,
	8, _S8 -8.950000, _S8 37.200249, _S8 -9.000000, _S8 36.750252, _S8 -8.550000, _S8 36.950249,
	8, _S8 -8.100000, _S8 37.150249, _S8 -4.250000, _S8 37.300251, _S8 -7.350000, _S8 42.900249,
	8, _S8 -7.350000, _S8 42.900249, _S8 -4.950000, _S8 36.900249, _S8 -8.950000, _S8 37.200249,
/* path_data190 ===========================================*/
	2, _S8 2.881500, _S8 26.116249,
	8, _S8 2.881500, _S8 26.116249, _S8 2.770500, _S8 26.615999, _S8 3.157750, _S8 26.311750,
	8, _S8 7.174750, _S8 23.155500, _S8 15.285250, _S8 8.430000, _S8 29.206499, _S8 7.021500,
	8, _S8 29.206499, _S8 7.021500, _S8 19.629499, _S8 3.994000, _S8 2.881500, _S8 26.116249,
/* path_data191 ===========================================*/
	2, _S8 5.681500, _S8 25.666250,
	8, _S8 5.681500, _S8 25.666250, _S8 5.340750, _S8 25.368000, _S8 5.807750, _S8 25.211750,
	8, _S8 6.274750, _S8 25.055500, _S8 34.385250, _S8 6.930000, _S8 44.206501, _S8 8.921500,
	8, _S8 44.206501, _S8 8.921500, _S8 37.429749, _S8 7.044000, _S8 5.681500, _S8 25.666250,
/* path_data192 ===========================================*/
	2, _S8 0.471250, _S8 27.191750,
	8, _S8 0.471250, _S8 27.191750, _S8 0.344000, _S8 27.591499, _S8 0.771750, _S8 27.347500,
	8, _S8 3.015500, _S8 26.067499, _S8 3.919250, _S8 11.764750, _S8 14.813500, _S8 11.451000,
	8, _S8 14.813500, _S8 11.451000, _S8 6.710750, _S8 7.772500, _S8 0.471250, _S8 27.191750,
	0
};

/* path_data193 ===========================================*/
signed char path_data193[] = {
	2, _S8 -4.509500, _S8 29.948250,
	8, _S8 -4.509500, _S8 29.948250, _S8 -4.778750, _S8 30.269751, _S8 -4.290500, _S8 30.206249,
	8, _S8 -1.729000, _S8 29.873249, _S8 3.622250, _S8 19.555500, _S8 14.732000, _S8 20.825251,
	8, _S8 14.732000, _S8 20.825251, _S8 6.740500, _S8 17.238750, _S8 -4.509500, _S8 29.948250,
	0
};

/* path_data194 ===========================================*/
signed char path_data194[] = {
	2, _S8 -1.700000, _S8 28.416750,
	8, _S8 -1.700000, _S8 28.416750, _S8 -1.902750, _S8 28.784000, _S8 -1.435500, _S8 28.627750,
	8, _S8 1.014250, _S8 27.809250, _S8 4.285250, _S8 16.656250, _S8 15.432250, _S8 15.769500,
	8, _S8 15.432250, _S8 15.769500, _S8 6.900750, _S8 13.783750, _S8 -1.700000, _S8 28.416750,
/* path_data195 ===========================================*/
	2, _S8 -6.269500, _S8 31.228001,
	8, _S8 -6.269500, _S8 31.228001, _S8 -6.487750, _S8 31.488501, _S8 -6.092250, _S8 31.437000,
	8, _S8 -4.017500, _S8 31.167250, _S8 0.317000, _S8 22.809999, _S8 9.316000, _S8 23.838499,
	8, _S8 9.316000, _S8 23.838499, _S8 2.842750, _S8 20.933500, _S8 -6.269500, _S8 31.228001,
	0
};

/* path_data196 ===========================================*/
signed char path_data196[] = {
	2, _S8 -8.169250, _S8 32.705250,
	8, _S8 -8.169250, _S8 32.705250, _S8 -8.420500, _S8 32.966499, _S8 -8.022750, _S8 32.937000,
	8, _S8 -6.980750, _S8 32.859749, _S8 0.678750, _S8 24.590000, _S8 5.295750, _S8 28.465500,
	8, _S8 5.295750, _S8 28.465500, _S8 2.292000, _S8 23.784750, _S8 -8.169250, _S8 32.705250,
/* path_data197 ===========================================*/
	2, _S8 9.213750, _S8 24.724501,
	8, _S8 9.213750, _S8 24.724501, _S8 8.913500, _S8 24.385750, _S8 9.396500, _S8 24.289499,
	8, _S8 9.879500, _S8 24.193501, _S8 40.055248, _S8 9.765250, _S8 49.546001, _S8 12.981750,
	8, _S8 49.546001, _S8 12.981750, _S8 43.060749, _S8 10.263250, _S8 9.213750, _S8 24.724501,
/* path_data198 ===========================================*/
	2, _S8 0.850000, _S8 40.800251,
	8, _S8 0.850000, _S8 40.800251, _S8 0.800000, _S8 40.350250, _S8 1.250000, _S8 40.550251,
	8, _S8 1.700000, _S8 40.750252, _S8 5.550000, _S8 40.900249, _S8 2.450000, _S8 46.500252,
	8, _S8 2.450000, _S8 46.500252, _S8 4.850000, _S8 40.500252, _S8 0.850000, _S8 40.800251,
/* path_data199 ===========================================*/
	2, _S8 3.450000, _S8 40.400249,
	8, _S8 3.450000, _S8 40.400249, _S8 3.400000, _S8 39.950249, _S8 3.850000, _S8 40.150249,
	8, _S8 4.300000, _S8 40.350250, _S8 8.750000, _S8 40.900249, _S8 9.250000, _S8 50.600250,
	8, _S8 9.250000, _S8 50.600250, _S8 7.450000, _S8 40.100250, _S8 3.450000, _S8 40.400249,
/* path_data200 ===========================================*/
	2, _S8 5.150000, _S8 40.000252,
	8, _S8 5.150000, _S8 40.000252, _S8 5.100000, _S8 39.550251, _S8 5.550000, _S8 39.750252,
	8, _S8 6.000000, _S8 39.950249, _S8 12.150000, _S8 40.800251, _S8 18.049999, _S8 48.900249,
	8, _S8 18.049999, _S8 48.900249, _S8 9.150000, _S8 39.700249, _S8 5.150000, _S8 40.000252,
/* path_data201 ===========================================*/
	2, _S8 7.056250, _S8 39.493000,
	8, _S8 7.056250, _S8 39.493000, _S8 6.947000, _S8 39.053501, _S8 7.419500, _S8 39.192001,
	8, _S8 7.892000, _S8 39.330502, _S8 13.000500, _S8 38.855751, _S8 22.524750, _S8 47.399750,
	8, _S8 22.524750, _S8 47.399750, _S8 10.981000, _S8 38.664001, _S8 7.056250, _S8 39.493000,
/* path_data202 ===========================================*/
	2, _S8 9.656250, _S8 38.393002,
	8, _S8 9.656250, _S8 38.393002, _S8 9.547000, _S8 37.953499, _S8 10.019500, _S8 38.091999,
	8, _S8 10.492000, _S8 38.230499, _S8 19.200500, _S8 39.355751, _S8 32.124748, _S8 48.099751,
	8, _S8 32.124748, _S8 48.099751, _S8 13.581000, _S8 37.563999, _S8 9.656250, _S8 38.393002,
	0
};

/* path_data203 ===========================================*/
signed char path_data203[] = {
	2, _S8 -0.450000, _S8 35.500252,
	8, _S8 -0.450000, _S8 35.500252, _S8 -0.500000, _S8 35.050251, _S8 -0.050000, _S8 35.250252,
	8, _S8 0.400000, _S8 35.450249, _S8 13.750000, _S8 36.100250, _S8 21.350000, _S8 42.800251,
	8, _S8 21.350000, _S8 42.800251, _S8 12.624750, _S8 36.606499, _S8 -0.450000, _S8 35.500252,
/* path_data204 ===========================================*/
	2, _S8 -2.950000, _S8 36.500252,
	8, _S8 -2.950000, _S8 36.500252, _S8 -3.000000, _S8 36.050251, _S8 -2.550000, _S8 36.250252,
	8, _S8 -2.100000, _S8 36.450249, _S8 4.050000, _S8 37.300251, _S8 9.950000, _S8 45.400249,
	8, _S8 9.950000, _S8 45.400249, _S8 1.050000, _S8 36.200249, _S8 -2.950000, _S8 36.500252,
/* path_data205 ===========================================*/
	2, _S8 12.375750, _S8 37.240501,
	8, _S8 12.375750, _S8 37.240501, _S8 12.234500, _S8 36.810249, _S8 12.716000, _S8 36.913750,
	8, _S8 13.197500, _S8 37.016998, _S8 21.965000, _S8 37.500999, _S8 35.495251, _S8 45.274502,
	8, _S8 35.495251, _S8 45.274502, _S8 16.079250, _S8 36.675999, _S8 12.375750, _S8 37.240501,
/* path_data206 ===========================================*/
	2, _S8 14.475750, _S8 36.640499,
	8, _S8 14.475750, _S8 36.640499, _S8 14.334500, _S8 36.210251, _S8 14.816000, _S8 36.313751,
	8, _S8 15.297500, _S8 36.417000, _S8 24.065001, _S8 36.901001, _S8 37.595249, _S8 44.674500,
	8, _S8 37.595249, _S8 44.674500, _S8 18.329250, _S8 35.976002, _S8 14.475750, _S8 36.640499,
/* path_data207 ===========================================*/
	2, _S8 16.875750, _S8 35.390499,
	8, _S8 16.875750, _S8 35.390499, _S8 16.734501, _S8 34.960251, _S8 17.216000, _S8 35.063751,
	8, _S8 17.697500, _S8 35.167000, _S8 28.465000, _S8 36.250999, _S8 50.895500, _S8 44.824501,
	8, _S8 50.895500, _S8 44.824501, _S8 20.729250, _S8 34.726002, _S8 16.875750, _S8 35.390499,
	0
};

/* path_data208 ===========================================*/
signed char path_data208[] = {
	2, _S8 -10.950000, _S8 37.100250,
	8, _S8 -10.950000, _S8 37.100250, _S8 -9.650000, _S8 37.000252, _S8 -9.950000, _S8 37.400249,
	8, _S8 -10.250000, _S8 37.800251, _S8 -10.850000, _S8 37.600250, _S8 -10.850000, _S8 37.600250,
	4, _S8 -10.950000, _S8 37.100250,
/* path_data209 ===========================================*/
	2, _S8 -3.250000, _S8 40.600250,
	8, _S8 -3.250000, _S8 40.600250, _S8 -1.950000, _S8 40.500252, _S8 -2.250000, _S8 40.900249,
	8, _S8 -2.550000, _S8 41.300251, _S8 -3.150000, _S8 41.100250, _S8 -3.150000, _S8 41.100250,
	4, _S8 -3.250000, _S8 40.600250,
/* path_data210 ===========================================*/
	2, _S8 -5.450000, _S8 40.500252,
	8, _S8 -5.450000, _S8 40.500252, _S8 -4.150000, _S8 40.400249, _S8 -4.450000, _S8 40.800251,
	8, _S8 -4.750000, _S8 41.200249, _S8 -5.350000, _S8 41.000252, _S8 -5.350000, _S8 41.000252,
	4, _S8 -5.450000, _S8 40.500252,
/* path_data211 ===========================================*/
	2, _S8 -29.292250, _S8 37.545502,
	8, _S8 -29.292250, _S8 37.545502, _S8 -28.031000, _S8 37.876251, _S8 -28.445499, _S8 38.155998,
	8, _S8 -28.859751, _S8 38.436001, _S8 -29.361500, _S8 38.050499, _S8 -29.361500, _S8 38.050499,
	4, _S8 -29.292250, _S8 37.545502,
/* path_data212 ===========================================*/
	2, _S8 -28.792250, _S8 35.145500,
	8, _S8 -28.792250, _S8 35.145500, _S8 -27.531000, _S8 35.476250, _S8 -27.945499, _S8 35.756001,
	8, _S8 -28.359751, _S8 36.035999, _S8 -28.861500, _S8 35.650501, _S8 -28.861500, _S8 35.650501,
	4, _S8 -28.792250, _S8 35.145500,
/* path_data213 ===========================================*/
	2, _S8 -30.592251, _S8 34.045502,
	8, _S8 -30.592251, _S8 34.045502, _S8 -29.330999, _S8 34.376251, _S8 -29.745501, _S8 34.655998,
	8, _S8 -30.159750, _S8 34.936001, _S8 -30.661501, _S8 34.550499, _S8 -30.661501, _S8 34.550499,
	4, _S8 -30.592251, _S8 34.045502,
	0
};

/* path_data214 ===========================================*/
signed char path_data214[] = {
	2, _S8 -10.650000, _S8 52.800251,
	8, _S8 -10.650000, _S8 52.800251, _S8 -11.050000, _S8 52.800251, _S8 -12.050000, _S8 53.300251,
	8, _S8 -12.550000, _S8 53.300251, _S8 -15.350000, _S8 54.200249, _S8 -16.750000, _S8 56.700249,
	8, _S8 -16.750000, _S8 56.700249, _S8 -13.650000, _S8 54.300251, _S8 -10.650000, _S8 52.800251,
/* path_data215 ===========================================*/
	2, _S8 11.279000, _S8 75.961746,
	8, _S8 11.314250, _S8 76.026253, _S8 11.328000, _S8 76.131248, _S8 11.401000, _S8 76.135498,
	8, _S8 11.565500, _S8 76.145500, _S8 11.873750, _S8 76.220749, _S8 11.842500, _S8 76.061752,
	8, _S8 11.630500, _S8 74.985252, _S8 11.412000, _S8 73.750999, _S8 10.378750, _S8 73.299248,
	8, _S8 10.219000, _S8 73.229500, _S8 9.858500, _S8 73.332748, _S8 9.840000, _S8 73.553749,
	8, _S8 9.808250, _S8 73.934753, _S8 9.779000, _S8 74.272003, _S8 9.856250, _S8 74.638496,
	8, _S8 9.931250, _S8 74.993752, _S8 10.470750, _S8 74.996246, _S8 10.700000, _S8 74.650253,
	8, _S8 10.934000, _S8 75.068253, _S8 11.042000, _S8 75.528999, _S8 11.279000, _S8 75.961746,
/* path_data216 ===========================================*/
	2, _S8 8.509500, _S8 77.145248,
	8, _S8 8.696500, _S8 77.498497, _S8 8.664750, _S8 77.963249, _S8 9.018500, _S8 78.103996,
	8, _S8 9.203500, _S8 78.177498, _S8 9.666000, _S8 77.933746, _S8 9.561500, _S8 77.665253,
	8, _S8 9.361000, _S8 77.150002, _S8 9.264000, _S8 76.590248, _S8 8.916750, _S8 76.137497,
	8, _S8 8.866750, _S8 76.071999, _S8 8.926750, _S8 75.938751, _S8 8.886750, _S8 75.856750,
	8, _S8 8.738250, _S8 75.551750, _S8 8.452000, _S8 75.367996, _S8 8.100000, _S8 75.450249,
	8, _S8 7.821250, _S8 76.000999, _S8 8.108250, _S8 76.533249, _S8 8.488750, _S8 76.960503,
	8, _S8 8.522750, _S8 76.998497, _S8 8.481250, _S8 77.092499, _S8 8.509500, _S8 77.145248,
/* path_data217 ===========================================*/
	2, _S8 -1.391000, _S8 75.847748,
	8, _S8 -1.418000, _S8 75.753502, _S8 -1.427500, _S8 75.637749, _S8 -1.386250, _S8 75.557503,
	8, _S8 -1.253500, _S8 75.299248, _S8 -1.055250, _S8 75.018753, _S8 -1.139500, _S8 74.763252,
	8, _S8 -1.226500, _S8 74.499252, _S8 -1.505500, _S8 74.544746, _S8 -1.668000, _S8 74.686996,
	8, _S8 -1.951750, _S8 74.935501, _S8 -1.964000, _S8 75.391998, _S8 -2.136750, _S8 75.731750,
	8, _S8 -2.185750, _S8 75.828247, _S8 -2.173000, _S8 75.971497, _S8 -2.283250, _S8 76.069252,
	8, _S8 -2.401750, _S8 76.174500, _S8 -2.511750, _S8 76.555496, _S8 -2.487750, _S8 76.698250,
	8, _S8 -2.474500, _S8 76.776497, _S8 -2.520250, _S8 79.253502, _S8 -2.464750, _S8 79.187752,
	8, _S8 -2.310000, _S8 79.004501, _S8 -1.547500, _S8 76.570999, _S8 -1.530250, _S8 76.348000,
	8, _S8 -1.516000, _S8 76.165253, _S8 -1.333000, _S8 76.049004, _S8 -1.391000, _S8 75.847748,
/* path_data218 ===========================================*/
	2, _S8 -7.800500, _S8 74.149750,
	8, _S8 -7.142000, _S8 73.525002, _S8 -6.444500, _S8 72.784752, _S8 -6.555000, _S8 71.856750,
	8, _S8 -6.584000, _S8 71.612747, _S8 -7.027750, _S8 71.744499, _S8 -7.074500, _S8 71.956001,
	8, _S8 -7.275000, _S8 72.862251, _S8 -7.784750, _S8 73.527496, _S8 -8.426750, _S8 74.125504,
	8, _S8 -8.975750, _S8 74.637253, _S8 -9.441250, _S8 76.223251, _S8 -9.500000, _S8 76.350250,
	8, _S8 -8.575750, _S8 75.036247, _S8 -8.011500, _S8 74.349747, _S8 -7.800500, _S8 74.149750,
/* path_data219 ===========================================*/
	2, _S8 -11.194000, _S8 72.658752,
	8, _S8 -11.063250, _S8 72.566254, _S8 -11.138750, _S8 72.443497, _S8 -11.084500, _S8 72.360497,
	8, _S8 -10.846250, _S8 71.996002, _S8 -10.521000, _S8 71.684502, _S8 -10.516500, _S8 71.250000,
	8, _S8 -10.515750, _S8 71.180748, _S8 -10.610250, _S8 71.103500, _S8 -10.694000, _S8 71.159500,
	8, _S8 -10.763250, _S8 71.205498, _S8 -10.848750, _S8 71.237999, _S8 -10.875750, _S8 71.270500,
	8, _S8 -11.383250, _S8 71.882751, _S8 -11.733250, _S8 72.550499, _S8 -12.094000, _S8 73.253502,
	8, _S8 -12.139750, _S8 73.342751, _S8 -12.425750, _S8 74.465500, _S8 -12.347500, _S8 74.493248,
	8, _S8 -12.287750, _S8 74.514503, _S8 -11.857750, _S8 73.469254, _S8 -11.805250, _S8 73.440750,
	8, _S8 -11.489500, _S8 73.269249, _S8 -11.486500, _S8 72.865501, _S8 -11.194000, _S8 72.658752,
/* path_data220 ===========================================*/
	2, _S8 -7.010750, _S8 77.544746,
	8, _S8 -6.899750, _S8 77.327499, _S8 -6.505750, _S8 77.027000, _S8 -6.534000, _S8 76.804749,
	8, _S8 -6.563500, _S8 76.572746, _S8 -6.446500, _S8 76.211998, _S8 -6.674500, _S8 76.384003,
	8, _S8 -6.988750, _S8 76.621002, _S8 -7.851000, _S8 76.958252, _S8 -7.918500, _S8 78.410248,
	8, _S8 -7.925000, _S8 78.553001, _S8 -7.181500, _S8 77.879753, _S8 -7.010750, _S8 77.544746,
/* path_data221 ===========================================*/
	2, _S8 -3.400000, _S8 73.250252,
	8, _S8 -3.300000, _S8 73.083252, _S8 -3.123000, _S8 73.201500, _S8 -3.008250, _S8 73.135750,
	8, _S8 -2.846250, _S8 73.042747, _S8 -2.693500, _S8 72.903252, _S8 -2.620500, _S8 72.740997,
	8, _S8 -2.378000, _S8 72.203751, _S8 -1.935750, _S8 71.748749, _S8 -1.900000, _S8 71.150253,
	8, _S8 -2.272750, _S8 70.799004, _S8 -2.442500, _S8 71.308998, _S8 -2.600000, _S8 71.550247,
	8, _S8 -2.930750, _S8 71.138496, _S8 -3.180500, _S8 71.607002, _S8 -3.505500, _S8 71.736748,
	8, _S8 -3.523000, _S8 71.743752, _S8 -3.576250, _S8 71.656998, _S8 -3.595000, _S8 71.663750,
	8, _S8 -3.889250, _S8 71.773750, _S8 -4.059250, _S8 72.043999, _S8 -4.308750, _S8 72.239250,
	8, _S8 -4.351500, _S8 72.272751, _S8 -4.452750, _S8 72.227753, _S8 -4.489500, _S8 72.261749,
	8, _S8 -4.652500, _S8 72.412498, _S8 -4.895750, _S8 72.493752, _S8 -4.965750, _S8 72.664253,
	8, _S8 -5.243250, _S8 73.341003, _S8 -6.028250, _S8 73.864754, _S8 -6.500000, _S8 75.750252,
	8, _S8 -6.404750, _S8 75.977501, _S8 -5.372000, _S8 74.089752, _S8 -5.250250, _S8 73.915253,
	8, _S8 -5.041250, _S8 73.616249, _S8 -5.011750, _S8 74.330498, _S8 -4.692750, _S8 74.164001,
	8, _S8 -4.680000, _S8 74.157249, _S8 -4.633500, _S8 74.216751, _S8 -4.600000, _S8 74.250252,
	8, _S8 -4.551500, _S8 74.180252, _S8 -4.497000, _S8 74.123001, _S8 -4.400000, _S8 74.150253,
	8, _S8 -4.400000, _S8 74.050247, _S8 -4.433500, _S8 73.911247, _S8 -4.383250, _S8 73.871498,
	8, _S8 -4.074000, _S8 73.627251, _S8 -4.095000, _S8 73.360252, _S8 -3.900000, _S8 73.050247,
	8, _S8 -3.785500, _S8 73.247498, _S8 -3.520250, _S8 73.067749, _S8 -3.400000, _S8 73.250252,
/* path_data222 ===========================================*/
	2, _S8 11.550000, _S8 86.850250,
	8, _S8 11.550000, _S8 86.850250, _S8 13.400000, _S8 81.750252, _S8 12.300000, _S8 78.950249,
	8, _S8 12.300000, _S8 78.950249, _S8 15.150000, _S8 84.350250, _S8 14.000000, _S8 87.150253,
	8, _S8 14.000000, _S8 87.150253, _S8 13.900000, _S8 84.550247, _S8 12.900000, _S8 83.300247,
	8, _S8 12.900000, _S8 83.300247, _S8 11.900000, _S8 86.500252, _S8 11.550000, _S8 86.850250,
/* path_data223 ===========================================*/
	2, _S8 7.850000, _S8 86.200249,
	8, _S8 7.850000, _S8 86.200249, _S8 9.200000, _S8 84.000252, _S8 7.200000, _S8 79.400253,
	8, _S8 7.200000, _S8 79.400253, _S8 7.000000, _S8 84.500252, _S8 5.300000, _S8 87.250252,
	8, _S8 5.300000, _S8 87.250252, _S8 8.850000, _S8 82.200249, _S8 7.850000, _S8 86.200249,
/* path_data224 ===========================================*/
	2, _S8 5.350000, _S8 85.700249,
	8, _S8 5.350000, _S8 85.700249, _S8 5.300000, _S8 80.700249, _S8 5.400000, _S8 79.950249,
	8, _S8 5.400000, _S8 79.950249, _S8 4.450000, _S8 84.100250, _S8 1.900000, _S8 86.500252,
	8, _S8 1.900000, _S8 86.500252, _S8 5.500000, _S8 83.500252, _S8 5.350000, _S8 85.700249,
/* path_data225 ===========================================*/
	2, _S8 2.950000, _S8 77.700249,
	8, _S8 2.950000, _S8 77.700249, _S8 4.450000, _S8 81.100250, _S8 1.950000, _S8 85.700249,
	8, _S8 1.950000, _S8 85.700249, _S8 3.550000, _S8 82.650253, _S8 2.350000, _S8 80.900253,
	8, _S8 2.350000, _S8 80.900253, _S8 3.000000, _S8 80.050247, _S8 2.950000, _S8 77.700249,
	0
};

/* path_data226 ===========================================*/
signed char path_data226[] = {
	2, _S8 -1.850000, _S8 85.600250,
	8, _S8 -1.850000, _S8 85.600250, _S8 -2.100000, _S8 81.700249, _S8 -1.650000, _S8 81.150253,
	8, _S8 -1.650000, _S8 81.150253, _S8 -1.600000, _S8 79.550247, _S8 -1.700000, _S8 79.300247,
	8, _S8 -1.700000, _S8 79.300247, _S8 -0.700000, _S8 77.750252, _S8 -0.650000, _S8 79.600250,
	8, _S8 -0.650000, _S8 79.600250, _S8 -0.300000, _S8 81.550247, _S8 0.400000, _S8 82.700249,
	8, _S8 0.400000, _S8 82.700249, _S8 1.300000, _S8 84.050247, _S8 1.250000, _S8 85.650253,
	8, _S8 1.250000, _S8 85.650253, _S8 -1.250000, _S8 78.100250, _S8 -1.850000, _S8 85.600250,
/* path_data227 ===========================================*/
	2, _S8 -2.750000, _S8 78.700249,
	8, _S8 -2.750000, _S8 78.700249, _S8 -4.400000, _S8 81.400253, _S8 -4.850000, _S8 86.150253,
	8, _S8 -4.850000, _S8 86.150253, _S8 -5.200000, _S8 84.600250, _S8 -4.250000, _S8 81.000252,
	8, _S8 -4.250000, _S8 81.000252, _S8 -3.200000, _S8 77.150253, _S8 -2.750000, _S8 78.700249,
/* path_data228 ===========================================*/
	2, _S8 -8.200000, _S8 83.650253,
	8, _S8 -8.200000, _S8 83.650253, _S8 -6.950000, _S8 82.300247, _S8 -6.600000, _S8 81.050247,
	8, _S8 -6.600000, _S8 81.050247, _S8 -5.700000, _S8 77.100250, _S8 -7.300000, _S8 79.250252,
	8, _S8 -7.300000, _S8 79.250252, _S8 -7.250000, _S8 81.250252, _S8 -9.300000, _S8 83.100250,
	8, _S8 -9.300000, _S8 83.100250, _S8 -8.100000, _S8 82.500252, _S8 -8.200000, _S8 83.650253,
/* path_data229 ===========================================*/
	2, _S8 -9.650000, _S8 82.400253,
	8, _S8 -9.650000, _S8 82.400253, _S8 -8.800000, _S8 78.050247, _S8 -8.600000, _S8 77.850250,
	8, _S8 -8.600000, _S8 77.850250, _S8 -8.150000, _S8 77.000252, _S8 -8.850000, _S8 77.800247,
	8, _S8 -8.850000, _S8 77.800247, _S8 -11.050000, _S8 82.600250, _S8 -12.050000, _S8 84.250252,
	8, _S8 -12.050000, _S8 84.250252, _S8 -10.050000, _S8 81.950249, _S8 -9.650000, _S8 82.400253,
/* path_data230 ===========================================*/
	2, _S8 -11.100000, _S8 78.250252,
	8, _S8 -11.100000, _S8 78.250252, _S8 -8.200000, _S8 72.650253, _S8 -13.650000, _S8 79.100250,
	8, _S8 -13.650000, _S8 79.100250, _S8 -10.900000, _S8 76.650253, _S8 -11.100000, _S8 78.250252,
/* path_data231 ===========================================*/
	2, _S8 -14.950000, _S8 74.600250,
	8, _S8 -14.950000, _S8 74.600250, _S8 -13.750000, _S8 69.900253, _S8 -13.100000, _S8 69.950249,
	8, _S8 -13.100000, _S8 69.950249, _S8 -11.050000, _S8 67.700249, _S8 -12.700000, _S8 70.350250,
	8, _S8 -12.700000, _S8 70.350250, _S8 -14.200000, _S8 72.750252, _S8 -14.050000, _S8 75.200249,
	8, _S8 -14.050000, _S8 75.200249, _S8 -14.200000, _S8 72.800247, _S8 -14.950000, _S8 74.600250,
/* path_data232 ===========================================*/
	2, _S8 67.625000, _S8 71.750000,
	8, _S8 67.625000, _S8 71.750000, _S8 64.625000, _S8 69.250000, _S8 64.000000, _S8 68.375000,
	8, _S8 64.000000, _S8 68.375000, _S8 67.375000, _S8 73.000000, _S8 67.375000, _S8 74.750000,
	8, _S8 67.375000, _S8 74.750000, _S8 68.000000, _S8 72.875000, _S8 67.625000, _S8 71.750000,
/* path_data233 ===========================================*/
	2, _S8 69.000000, _S8 66.250000,
	8, _S8 69.000000, _S8 66.250000, _S8 63.750000, _S8 62.500000, _S8 62.875000, _S8 60.625000,
	8, _S8 62.875000, _S8 60.625000, _S8 69.500000, _S8 68.000000, _S8 69.500000, _S8 69.125000,
	8, _S8 69.500000, _S8 69.125000, _S8 69.625000, _S8 66.875000, _S8 69.000000, _S8 66.250000,
/* path_data234 ===========================================*/
	2, _S8 73.250000, _S8 27.750000,
	8, _S8 73.250000, _S8 27.750000, _S8 70.250000, _S8 25.750000, _S8 69.875000, _S8 26.250000,
	8, _S8 69.875000, _S8 26.250000, _S8 72.500000, _S8 27.875000, _S8 73.125000, _S8 30.000000,
	8, _S8 73.125000, _S8 30.000000, _S8 72.750000, _S8 27.750000, _S8 73.250000, _S8 27.750000,
/* path_data235 ===========================================*/
	2, _S8 75.375000, _S8 47.875000,
	4, _S8 71.000000, _S8 44.875000,
	8, _S8 71.000000, _S8 44.875000, _S8 75.750000, _S8 49.125000, _S8 75.875000, _S8 50.125000,
	4, _S8 75.375000, _S8 47.875000,
	0
};

/* path_data236 ===========================================*/
signed char path_data236[] = {
	2, _S8 -22.312500, _S8 42.250000,
	4, _S8 -16.812500, _S8 43.437500,
/* path_data237 ===========================================*/
	2, _S8 -9.750000, _S8 82.750000,
	8, _S8 -9.750000, _S8 82.750000, _S8 -9.875000, _S8 81.875000, _S8 -12.125000, _S8 84.500000,
/* path_data238 ===========================================*/
	2, _S8 -8.375000, _S8 84.000000,
	8, _S8 -8.375000, _S8 84.000000, _S8 -7.875000, _S8 82.375000, _S8 -9.500000, _S8 83.500000,
/* path_data239 ===========================================*/
	2, _S8 5.125000, _S8 86.125000,
	8, _S8 5.125000, _S8 86.125000, _S8 5.500000, _S8 83.375000, _S8 2.625000, _S8 86.625000,
	0
};
#undef _S8

int pathCount = 131;

vg_lite_path_t path[131] = {
	{
		{-80, -40, 80, 90},	/* left, top, right,bottom */
		VG_LITE_HIGH,		/* quality */
		VG_LITE_S8,		/* -128 to 127 coordinate range */
		{0},			/* uploaded */
		sizeof(path_data0),	/* path length */
		path_data0,		/* path data */
		1		/* initially, path is changed for uploaded*/
	},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data8), path_data8, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data12), path_data12, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data13), path_data13, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data14), path_data14, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data15), path_data15, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data16), path_data16, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data17), path_data17, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data18), path_data18, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data19), path_data19, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data20), path_data20, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data21), path_data21, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data22), path_data22, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data23), path_data23, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data24), path_data24, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data25), path_data25, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data26), path_data26, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data27), path_data27, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data28), path_data28, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data29), path_data29, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data35), path_data35, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data36), path_data36, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data37), path_data37, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data38), path_data38, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data39), path_data39, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data40), path_data40, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data41), path_data41, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data42), path_data42, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data43), path_data43, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data44), path_data44, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data45), path_data45, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data46), path_data46, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data47), path_data47, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data48), path_data48, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data49), path_data49, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data51), path_data51, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data52), path_data52, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data54), path_data54, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data55), path_data55, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data56), path_data56, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data57), path_data57, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data58), path_data58, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data59), path_data59, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data60), path_data60, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data61), path_data61, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data62), path_data62, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data63), path_data63, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data64), path_data64, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data65), path_data65, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data66), path_data66, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data67), path_data67, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data68), path_data68, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data69), path_data69, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data70), path_data70, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data71), path_data71, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data72), path_data72, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data73), path_data73, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data74), path_data74, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data75), path_data75, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data76), path_data76, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data77), path_data77, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data78), path_data78, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data79), path_data79, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data80), path_data80, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data81), path_data81, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data82), path_data82, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data83), path_data83, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data84), path_data84, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data85), path_data85, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data86), path_data86, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data87), path_data87, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data89), path_data89, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data90), path_data90, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data91), path_data91, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data92), path_data92, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data93), path_data93, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data94), path_data94, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data95), path_data95, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data96), path_data96, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data101), path_data101, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data103), path_data103, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data109), path_data109, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data111), path_data111, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data112), path_data112, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data113), path_data113, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data115), path_data115, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data116), path_data116, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data117), path_data117, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data118), path_data118, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data121), path_data121, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data122), path_data122, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data123), path_data123, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data124), path_data124, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data125), path_data125, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data126), path_data126, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data127), path_data127, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data131), path_data131, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data132), path_data132, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data135), path_data135, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data137), path_data137, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data138), path_data138, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data139), path_data139, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data140), path_data140, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data150), path_data150, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data157), path_data157, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data159), path_data159, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data160), path_data160, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data161), path_data161, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data162), path_data162, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data163), path_data163, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data164), path_data164, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data165), path_data165, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data166), path_data166, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data167), path_data167, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data168), path_data168, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data169), path_data169, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data170), path_data170, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data171), path_data171, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data172), path_data172, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data175), path_data175, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data181), path_data181, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data182), path_data182, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data183), path_data183, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data193), path_data193, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data194), path_data194, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data196), path_data196, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data203), path_data203, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data208), path_data208, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data214), path_data214, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data226), path_data226, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data236), path_data236, 1}
};

uint32_t color_data[] = {
	/* path_data0 */   0xffffffff,
	/* path_data8 */   0xffffffff,
	/* path_data12 */  0xffffffff,
	/* path_data13 */  0xff2672cc,
	/* path_data14 */  0xff2672cc,
	/* path_data15 */  0xff3a7ee8,
	/* path_data16 */  0xff4d8ce9,
	/* path_data17 */  0xff6099eb,
	/* path_data18 */  0xff75a5ed,
	/* path_data19 */  0xff87b1f0,
	/* path_data20 */  0xff9cbff2,
	/* path_data21 */  0xffafccf4,
	/* path_data22 */  0xffc3d8f8,
	/* path_data23 */  0xffd6e4f9,
	/* path_data24 */  0xffebf2fb,
	/* path_data25 */  0xffffffff,
	/* path_data26 */  0xff000000,
	/* path_data27 */  0xffcccccc,
	/* path_data28 */  0xff000000,
	/* path_data29 */  0xffcccccc,
	/* path_data35 */  0xff000000,
	/* path_data36 */  0xff8c66e4,
	/* path_data37 */  0xff5931b1,
	/* path_data38 */  0xff4b26a5,
	/* path_data39 */  0xff7e72ff,
	/* path_data40 */  0xffccffff,
	/* path_data41 */  0xff4b3fcc,
	/* path_data42 */  0xff000000,
	/* path_data43 */  0xffccffff,
	/* path_data44 */  0xffccffff,
	/* path_data45 */  0xffccffff,
	/* path_data46 */  0xffccffff,
	/* path_data47 */  0xffccffff,
	/* path_data48 */  0xffccffff,
	/* path_data49 */  0xff000000,
	/* path_data51 */  0xffccffff,
	/* path_data52 */  0xff000000,
	/* path_data54 */  0xffb1b1b1,
	/* path_data55 */  0xffccffff,
	/* path_data56 */  0xffccffff,
	/* path_data57 */  0xffccffff,
	/* path_data58 */  0xff000000,
	/* path_data59 */  0xffccffff,
	/* path_data60 */  0xffccffff,
	/* path_data61 */  0xffccffff,
	/* path_data62 */  0xffccffff,
	/* path_data63 */  0xffccffff,
	/* path_data64 */  0xffb1e4e4,
	/* path_data65 */  0xffb1e4e4,
	/* path_data66 */  0xff2672cc,
	/* path_data67 */  0xff508ee9,
	/* path_data68 */  0xff7caaef,
	/* path_data69 */  0xffa8c6f4,
	/* path_data70 */  0xffd3e2f9,
	/* path_data71 */  0xffffffff,
	/* path_data72 */  0xffcccccc,
	/* path_data73 */  0xff000000,
	/* path_data74 */  0xff31cc99,
	/* path_data75 */  0xff009964,
	/* path_data76 */  0xffffffff,
	/* path_data77 */  0xff000000,
	/* path_data78 */  0xff2672cc,
	/* path_data79 */  0xffffffff,
	/* path_data80 */  0xff5b95eb,
	/* path_data81 */  0xff91b8f2,
	/* path_data82 */  0xffc8dbf8,
	/* path_data83 */  0xffffffff,
	/* path_data84 */  0xffcccccc,
	/* path_data85 */  0xff000000,
	/* path_data86 */  0xff31cc99,
	/* path_data87 */  0xff000000,
	/* path_data89 */  0xff000000,
	/* path_data90 */  0xff313131,
	/* path_data91 */  0xff666666,
	/* path_data92 */  0xff999999,
	/* path_data93 */  0xffcccccc,
	/* path_data94 */  0xffffffff,
	/* path_data95 */  0xff002699,
	/* path_data96 */  0xffcccccc,
	/* path_data101 */ 0xff000000,
	/* path_data103 */ 0xff2672cc,
	/* path_data109 */ 0xff000000,
	/* path_data111 */ 0xff000000,
	/* path_data112 */ 0xff000000,
	/* path_data113 */ 0xff000000,
	/* path_data115 */ 0xff00004b,
	/* path_data116 */ 0xff31cc99,
	/* path_data117 */ 0xff009964,
	/* path_data118 */ 0xff000000,
	/* path_data121 */ 0xff9999e4,
	/* path_data122 */ 0xff6464b1,
	/* path_data123 */ 0xff002699,
	/* path_data124 */ 0xffffffff,
	/* path_data125 */ 0xff002699,
	/* path_data126 */ 0xff000000,
	/* path_data127 */ 0xff000000,
	/* path_data131 */ 0xff000000,
	/* path_data132 */ 0xff000000,
	/* path_data135 */ 0xffffffff,
	/* path_data137 */ 0xffcccccc,
	/* path_data138 */ 0xff000000,
	/* path_data139 */ 0xffcccccc,
	/* path_data140 */ 0xff000000,
	/* path_data150 */ 0xff000000,
	/* path_data157 */ 0xff002699,
	/* path_data159 */ 0xffcccccc,
	/* path_data160 */ 0xff000000,
	/* path_data161 */ 0xff000000,
	/* path_data162 */ 0xffffffff,
	/* path_data163 */ 0xffffffff,
	/* path_data164 */ 0xffffffff,
	/* path_data165 */ 0xffffffff,
	/* path_data166 */ 0xffffffff,
	/* path_data167 */ 0xffffffff,
	/* path_data168 */ 0xffffffff,
	/* path_data169 */ 0xffffffff,
	/* path_data170 */ 0xffcccccc,
	/* path_data171 */ 0xff000000,
	/* path_data172 */ 0xff000000,
	/* path_data175 */ 0xff000000,
	/* path_data181 */ 0xffffffff,
	/* path_data182 */ 0xff000000,
	/* path_data183 */ 0xffffffff,
	/* path_data193 */ 0xffffffff,
	/* path_data194 */ 0xffffffff,
	/* path_data196 */ 0xffffffff,
	/* path_data203 */ 0xffffffff,
	/* path_data208 */ 0xff000000,
	/* path_data214 */ 0xffcccccc,
	/* path_data226 */ 0xffcccccc,
	/* path_data236 */ 0xff000000
};

#endif	/* __TIGER_PATHS_H__ */
