
This SDK has been patched by Embedded Artists for the iMXRT1166 Developer's Kit.
The SDK was released on 2024-04-16 and is based on NXP's 2.15.0 SDK (SDK_2_15_000_MIMXRT1166xxxxx.zip).

This is what has been patched:
* LWIP projects - added reading of the MAC address from I2C EEPROM either on the 100Mbit adapter
  or on the uCOM board
* Added an I2C driver for the gpio expander (PCA6416) and code to use it
* Added an I2C driver for the PWM gpio expander (PCA9530) and code to use it
* SDRAM size has been corrected to 32Mb (including linker files, MPU and DCD)
* The RTL8211F Ethernet PHY driver has been extended to also work with the AR8031DS PHY.
  The difference between the PHYs are minimal and extending the driver and letting the
  PHY ID decide which instructions to use makes switching PHYs seamless.
* SEMC projects - changed to correct settings for the SDRAM
* SEMC projects - changed algorithm for memory test and now test entire 32MB instead of only 4KB
* Examples using eLCDIF/LCDIFv2 have been updated to use PCA6416/PCA9530 for
  RST/PWR/BL signals
* BOARD_USER_BUTTON has been redirected to SW5/WAKEUP button on the uCOM Carrier Board
* USER_LED has been changed to the blue RGB LED using PCA6416
* Touch: I2C bus and GPIOs have been changed for RST/INT
* Camera pins
* Adjusted the USB interface number (it is different for host and device examples)
* Changed the Wi-Fi examples to use the Embedded Artists 1XK M.2 Module (EAR00385) as default
* Corrected the ethernet PHY addresses
* Changed CORE clock depending on speed grading of MCU (528MHz for Industrial, 600MHz for Commercial)
* Changed SEMC clock to be within maximum speed for SDRAM (now 148.5MHz, was 198MHz)
* Many of the projects have been updated to use a more complete pin_mux.c file where all
  necessary pins have been initialized. The SDK examples used to only configure the pins
  that they use (and often not every pin) and most of the time the configuration was only
  for MUX:ing and not the PAD settings (pull up/down/none, drive strength and slew).
* Converted the AzureRTOS examples to use the BOARD_NETWORK_USE_100M_ENET_PORT (same as all
  other networking examples) instead of using the old EXAMPLE_USE_1G_ENET_PORT


This has been added:
* HDMI support to most GUI examples. The default is the 4.3" Parallel RGB
  display as it is a part of the iMXRT1166 Developer's Kit. The switch to HDMI
  can be made per project in display_support.h/elcdif_support.h/lcdifv2_support.h.
* I2C probe example
* EDID reader example

Important things to note:
* Read section "8 - Known Issues" in docs/MCUXpresso SDK Release Notes for MIMXRT1160-EVK.pdf
  to see known issues with the current version of the SDK.
* For Iperf examples, set compiler optimization to -O3 or similar to improve performance.
* If the hardware seems unresponsive and the debugger cannot connect/flash/erase the current program
  then the most likely cause is the running program preventing the access. To stop the currently
  running program and regain control:
  1) Press and hold down the ISP_ENABLE button (SW1)
  2) Press and hold down the RESET button (SW3)
  3) Let go of the RESET button
  4) Wait an extra second or two
  5) Release the ISP_ENABLE button
  6) The hardware is now in a mode where programming/erasing it should work
* GUI applications using Parallel RGB display and the LCDIFv2 interface require
  a carrier board supporting the 24 bit mapping (like the uCOM Carrier Board rev B and later).
  If you don't have that then switch the interface to eLCDIF in the project's
  display_support.h/elcdif_support.h/lcdifv2_support.h file.

Connectors:
* J29 (micro USB) is the default UART for the CM7 core and unless specified otherwise it is setup for 115200 8/N/1
* J30 (micro USB) is the default UART for the CM4 core and unless specified otherwise it is setup for 115200 8/N/1
* For 1Gbit Ethernet examples, use connector J25 on uCOM Carrier Board
* For 100Mbit Ethernet examples, use ethernet adapter connected between Connector "D" on
  uCOM Carrier Board and J37 on the adapter. These four connections are also needed:
    1) uCOM Carrier Board, JP38:1 -> adapter JP37:1
    2) uCOM Carrier Board, JP38:2 -> adapter JP37:2
    3) uCOM Carrier Board, JP27:1 -> adapter JP39:2
    4) uCOM Carrier Board, JP27:2 -> adapter JP39:1
* The two CSI examples can use either an OV5640 camera in connector J23 or a camera in connector J24
* The EIQ examples that use a camera expects the camera in connector J24 (J23 might work for some
  of the examples but runs much slower)
* Some GUI examples are configured for the RK055AHD091 display which should be in connector "C" on
  the uCOM Carrier Board. Ignore the readme text about connecting extra 5V power.
* The default for GUI examples is to use an HDMI adapter in connector "C" on
  the uCOM Carrier Board. Ignore the readme text about connecting extra 5V power.


This example has been configured to use the 1XK M.2 module. To change which
module to use, replace WIFI_IW416_BOARD_MURATA_1XK_M2 in the app_config.h file
with one of the following and then rebuild the project:

    WIFI_IW416_BOARD_MURATA_1XK_ONBOARD - To use the 1XK chip on the uCOM board (special mounting option)
    WIFI_IW416_BOARD_MURATA_1XK_M2      - To use the 1XK M.2 module in connector J33
    WIFI_88W8801_BOARD_MURATA_2DS_M2    - To use the 2DS M.2 module in connector J33
    WIFI_88W8987_BOARD_MURATA_1ZM_M2    - To use the 1ZM M.2 module in connector J33

More information about the M.2 Modules can be found here: https://www.embeddedartists.com/m2/

It could be possible to use the other modules as shown in the original
readme text below, however that is untested and unsupported.

Note: The current version of the iMXRT1166 uCOM board has an onboard 1XK Wi-Fi
      so only option WIFI_IW416_BOARD_MURATA_1XK_ONBOARD is valid.


Everything below this line is the original content of the readme file.
=======================================================================



Overview
========
This is the Wi-Fi Test mode example to demonstrate the test mode support usage.

Before building the example application select Wi-Fi module macro in the app_config.h. (see #define WIFI_<SoC Name>_BOARD_<Module Name>).
For more information about Wi-Fi module connection see:
    readme_modules.txt
    Getting started guide on supported modules configuration:
    https://www.nxp.com/document/guide/getting-started-with-nxp-wi-fi-modules-using-i-mx-rt-platform:GS-WIFI-MODULES-IMXRT-PLATFORM



SDK version
===========
- Version: 2.15.000

Toolchain supported
===================
- IAR embedded Workbench  9.40.1
- Keil MDK  5.38.1
- GCC ARM Embedded  12.2
- MCUXpresso  11.8.0

Hardware requirements
=====================
- Micro USB cable
- MIMXRT1160-EVK board
- Personal Computer


Board settings
==============


Prepare the Demo
================
1.  Connect a micro USB cable between the PC host and the CMSIS DAP USB port on the board
2.  Open a serial terminal with the following settings:
    - 115200 baud rate
    - 8 data bits
    - No parity
    - One stop bit
    - No flow control
3.  Connect the Wi-Fi module.
4.  Download the program to the target board.
5.  Either press the reset button on your board or launch the debugger in your IDE to begin running the demo.

Running the demo
================
1. Add CLI init API in applications main function.
2. Add WLAN CLI init API once WLAN Connection Manager gets initialized correctly.
3. When the demo starts, a welcome message would appear on the terminal, press enter for command prompt:
   Press tab or type help to list out all available CLI commands.

wifi test mode demo
Initialize CLI
Initialize WLAN Driver
MAC Address: 00:13:43:91:8A:3D
[net] Initialized TCP/IP networking stack
app_cb: WLAN: received event 10
app_cb: WLAN initialized
WLAN Test Mode CLIs are initialized
CLIs Available:

help
wlan-version
wlan-mac
wlan-set-rf-test-mode
wlan-set-rf-channel <channel>
wlan-get-rf-channel
wlan-set-rf-band <band>
wlan-get-rf-band
wlan-set-rf-bandwidth <bandwidth>
wlan-get-rf-bandwidth
wlan-get-rf-per
wlan-set-rf-tx-cont-mode <enable_tx> <cw_mode> <payload_pattern> <cs_mode> <act_sub_ch> <tx_rate>
wlan-set-rf-tx-antenna <antenna>
wlan-get-rf-tx-antenna
wlan-set-rf-rx-antenna <antenna>
wlan-get-rf-rx-antenna
wlan-set-rf-tx-power <tx_power> <modulation> <path_id>
wlan-set-rf-tx-frame <start> <data_rate> <frame_pattern> <frame_len> <adjust_burst_sifs> <burst_sifs_in_us> <short_preamble> <act_sub_ch> <short_gi> <adv_coding> <tx_bf> <gf_mode> <stbc> <bssid>

#
# wlan-set-rf-test-mode
RF Test Mode configuration successful

#
# wlan-set-rf-channel 6
Channel configuration successful

# wlan-get-rf-channel
Configured channel is: 6

# wlan-set-rf-band 0
RF Band configuration successful

# wlan-get-rf-band
Configured RF Band is: 2.4G

# wlan-set-rf-bandwidth 0
Bandwidth configuration successful

# wlan-get-rf-bandwidth
Configured bandwidth is: 20MHz

#
# wlan-get-and-reset-rf-per
PER is as below:
  Total Rx Packet Count                    : 3
  Total Rx Multicast/Broadcast Packet Count: 3
  Total Rx Packets with FCS error          : 2

# wlan-set-rf-tx-antenna 1
Tx Antenna configuration successful

# wlan-get-rf-tx-antenna
Configured Tx Antenna is: Main

# wlan-set-rf-rx-antenna 2
Rx Antenna configuration successful

# wlan-get-rf-rx-antenna
Configured Rx Antenna is: Aux

# wlan-set-rf-tx-power 8 1 1
Tx Power configuration successful
  Power         : 8 dBm
  Modulation    : OFDM
  Path ID       : PathB

# wlan-set-rf-tx-frame 1 7 2730 256 0 0 0 0 0 0 0 0 0 ad:ad:23:12:45:57
Tx Frame configuration successful
  Enable                    : enable
  Tx Data Rate              : 7
  Payload Pattern           : 0x00000AAA
  Payload Length            : 0x00000100
  Adjust Burst SIFS3 Gap    : disable
  Burst SIFS in us          : 0 us
  Short Preamble            : disable
  Active SubChannel         : low
  Short GI                  : disable
  Adv Coding                : disable
  Beamforming               : disable
  GreenField Mode           : disable
  STBC                      : disable
  BSSID                     : AD:AD:23:12:45:57

