
This SDK has been patched by Embedded Artists for the iMXRT1166 Developer's Kit.
The SDK was released on 2024-04-16 and is based on NXP's 2.15.0 SDK (SDK_2_15_000_MIMXRT1166xxxxx.zip).

This is what has been patched:
* LWIP projects - added reading of the MAC address from I2C EEPROM either on the 100Mbit adapter
  or on the uCOM board
* Added an I2C driver for the gpio expander (PCA6416) and code to use it
* Added an I2C driver for the PWM gpio expander (PCA9530) and code to use it
* SDRAM size has been corrected to 32Mb (including linker files, MPU and DCD)
* The RTL8211F Ethernet PHY driver has been extended to also work with the AR8031DS PHY.
  The difference between the PHYs are minimal and extending the driver and letting the
  PHY ID decide which instructions to use makes switching PHYs seamless.
* SEMC projects - changed to correct settings for the SDRAM
* SEMC projects - changed algorithm for memory test and now test entire 32MB instead of only 4KB
* Examples using eLCDIF/LCDIFv2 have been updated to use PCA6416/PCA9530 for
  RST/PWR/BL signals
* BOARD_USER_BUTTON has been redirected to SW5/WAKEUP button on the uCOM Carrier Board
* USER_LED has been changed to the blue RGB LED using PCA6416
* Touch: I2C bus and GPIOs have been changed for RST/INT
* Camera pins
* Adjusted the USB interface number (it is different for host and device examples)
* Changed the Wi-Fi examples to use the Embedded Artists 1XK M.2 Module (EAR00385) as default
* Corrected the ethernet PHY addresses
* Changed CORE clock depending on speed grading of MCU (528MHz for Industrial, 600MHz for Commercial)
* Changed SEMC clock to be within maximum speed for SDRAM (now 148.5MHz, was 198MHz)
* Many of the projects have been updated to use a more complete pin_mux.c file where all
  necessary pins have been initialized. The SDK examples used to only configure the pins
  that they use (and often not every pin) and most of the time the configuration was only
  for MUX:ing and not the PAD settings (pull up/down/none, drive strength and slew).
* Converted the AzureRTOS examples to use the BOARD_NETWORK_USE_100M_ENET_PORT (same as all
  other networking examples) instead of using the old EXAMPLE_USE_1G_ENET_PORT


This has been added:
* HDMI support to most GUI examples. The default is the 4.3" Parallel RGB
  display as it is a part of the iMXRT1166 Developer's Kit. The switch to HDMI
  can be made per project in display_support.h/elcdif_support.h/lcdifv2_support.h.
* I2C probe example
* EDID reader example

Important things to note:
* Read section "8 - Known Issues" in docs/MCUXpresso SDK Release Notes for MIMXRT1160-EVK.pdf
  to see known issues with the current version of the SDK.
* For Iperf examples, set compiler optimization to -O3 or similar to improve performance.
* If the hardware seems unresponsive and the debugger cannot connect/flash/erase the current program
  then the most likely cause is the running program preventing the access. To stop the currently
  running program and regain control:
  1) Press and hold down the ISP_ENABLE button (SW1)
  2) Press and hold down the RESET button (SW3)
  3) Let go of the RESET button
  4) Wait an extra second or two
  5) Release the ISP_ENABLE button
  6) The hardware is now in a mode where programming/erasing it should work
* GUI applications using Parallel RGB display and the LCDIFv2 interface require
  a carrier board supporting the 24 bit mapping (like the uCOM Carrier Board rev B and later).
  If you don't have that then switch the interface to eLCDIF in the project's
  display_support.h/elcdif_support.h/lcdifv2_support.h file.

Connectors:
* J29 (micro USB) is the default UART for the CM7 core and unless specified otherwise it is setup for 115200 8/N/1
* J30 (micro USB) is the default UART for the CM4 core and unless specified otherwise it is setup for 115200 8/N/1
* For 1Gbit Ethernet examples, use connector J25 on uCOM Carrier Board
* For 100Mbit Ethernet examples, use ethernet adapter connected between Connector "D" on
  uCOM Carrier Board and J37 on the adapter. These four connections are also needed:
    1) uCOM Carrier Board, JP38:1 -> adapter JP37:1
    2) uCOM Carrier Board, JP38:2 -> adapter JP37:2
    3) uCOM Carrier Board, JP27:1 -> adapter JP39:2
    4) uCOM Carrier Board, JP27:2 -> adapter JP39:1
* The two CSI examples can use either an OV5640 camera in connector J23 or a camera in connector J24
* The EIQ examples that use a camera expects the camera in connector J24 (J23 might work for some
  of the examples but runs much slower)
* Some GUI examples are configured for the RK055AHD091 display which should be in connector "C" on
  the uCOM Carrier Board. Ignore the readme text about connecting extra 5V power.
* The default for GUI examples is to use an HDMI adapter in connector "C" on
  the uCOM Carrier Board. Ignore the readme text about connecting extra 5V power.


This example has been configured to use the 1XK M.2 module. To change which
module to use, replace WIFI_IW416_BOARD_MURATA_1XK_M2 in the app_config.h file
with one of the following and then rebuild the project:

    WIFI_IW416_BOARD_MURATA_1XK_ONBOARD - To use the 1XK chip on the uCOM board (special mounting option)
    WIFI_IW416_BOARD_MURATA_1XK_M2      - To use the 1XK M.2 module in connector J33
    WIFI_88W8801_BOARD_MURATA_2DS_M2    - To use the 2DS M.2 module in connector J33
    WIFI_88W8987_BOARD_MURATA_1ZM_M2    - To use the 1ZM M.2 module in connector J33

More information about the M.2 Modules can be found here: https://www.embeddedartists.com/m2/

It could be possible to use the other modules as shown in the original
readme text below, however that is untested and unsupported.

Note: The current version of the iMXRT1166 uCOM board has an onboard 1XK Wi-Fi
      so only option WIFI_IW416_BOARD_MURATA_1XK_ONBOARD is valid.


Everything below this line is the original content of the readme file.
=======================================================================



Overview
========
This demo implements a simple web based Wi-Fi configuration utility for connecting the board to the local Wireless network. 

Initially, the board doesn't have the credentials to join the local network, so it starts its own Access Point with SSID: "nxp_configuration_access_point" and password: "NXP0123456789".

The user can connect their device to this SSID and access the HTML UI under 192.168.1.1. The board will scan for the nearby Wi-Fi networks and display a list of them on this page. By clicking on the entries, the user can choose their network, enter the credentials and connect. The board will attempt to join this Wi-Fi network as a client and if it succeeds, it will disconnect its AP and save the credentials to its mflash memory.

On successive restarts, it checks the mflash memory and uses the saved credentials to directly connect to the local Wi-Fi network without starting the AP. 

A simple LED visualization is implemented. The board LED will be on if the device is in AP mode and turns off after the board changes to client mode.

The site allows the user to clear the credentials from the flash memory and reset the board to AP mode. If connection fails, user can also set device to AP mode through serial connection.

The source files for the web interface are located in the webui directory. Use the `<path_to_sdk>/middleware/lwip/src/apps/httpsrv/mkfs/mkfs.pl webui` Perl script in order to convert the webui files into the httpsrv_fs_data.c which is used in order to flash the static files onto the board. Make sure the mkfsl.pl script is executed from the same directory where the file httpsrv_fs_data.c and the directory webui are.

Note that Microsoft Internet Explorer is not supported by this webconfig example.

Before building the example application select Wi-Fi module macro in the app_config.h. (see #define WIFI_<SoC Name>_BOARD_<Module Name>).
For more information about Wi-Fi module connection see:
    readme_modules.txt
    Getting started guide on supported modules configuration:
    https://www.nxp.com/document/guide/getting-started-with-nxp-wi-fi-modules-using-i-mx-rt-platform:GS-WIFI-MODULES-IMXRT-PLATFORM



SDK version
===========
- Version: 2.15.000

Toolchain supported
===================
- IAR embedded Workbench  9.40.1
- Keil MDK  5.38.1
- GCC ARM Embedded  12.2
- MCUXpresso  11.8.0

Hardware requirements
=====================
- Micro USB cable
- MIMXRT1160-EVK board
- Personal Computer


Board settings
==============


Prepare the Demo
================
1.  Connect a micro USB cable between the PC host and the CMSIS DAP USB port on the board
2.  Open a serial terminal with the following settings:
    - 115200 baud rate
    - 8 data bits
    - No parity
    - One stop bit
    - No flow control
3.  Connect the WiFi module to SD card slot or M.2 slot.
4.  Download the program to the target board.
5.  Either press the reset button on your board or launch the debugger in your IDE to begin running the demo.


Running the demo
================
1. When the demo starts, basic initialization proceeds
2. After that, device will wait for connection and configuration:

+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
Starting webconfig DEMO
[i] Trying to load data from mflash.
[i] Nothing stored yet
[i] Initializing Wi-Fi connection...
MAC Address: 9C:50:D1:44:67:5F
[i] Successfully initialized Wi-Fi module
Starting Access Point: SSID: nxp_configuration_access_point, Chnl: 1
[wlcm] Warn: NOTE: uAP will automatically switch to the channel that station is on.
 Now join that network on your device and connect to this IP: 192.168.1.1
+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

3. Connect to the access point and in your web browser enter 192.168.1.1
4. Wait for the scan to finish - the demo terminal will print something like:

+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
Initiating scan...

nxptp
     BSSID         : B0:A7:B9:99:27:52
     RSSI          : -34dBm
     Channel       : 3
+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

5. In your web browser you should also see the scan results, click on the network
   you want to add, fill in the credentials and click connect.
6. After you send credentials, device will try connecting to the AP and if successful saves the credentials to the mflash.

+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
[i] Chosen ssid: nxptp
[i] Chosen passphrase: "NXP01234"
[i] Chosen security methods: "WPA2 WPA3_SAE"
[i] Joining: nxptp
[i] Successfully joined: nxptp
 Now join that network on your device and connect to this IP: 192.168.0.209
[i] mflash_save_file success
[i] Stopping AP!
+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

7. The device is now in station mode and is joined to the selected network.
   Now join this network on your PC and enter the IP from demo terminal.
8. You can try to join different networks or reset the board back to AP mode and start again.
