/*
 * Copyright 2016 Freescale Semiconductor, Inc.
 * Copyright 2016-2021 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef _FSL_IOMUXC_H_
#define _FSL_IOMUXC_H_

#include "fsl_common.h"

/*!
 * @addtogroup iomuxc_driver
 * @{
 */

/*! @file */

/*******************************************************************************
 * Definitions
 ******************************************************************************/
/* Component ID definition, used by tools. */
#ifndef FSL_COMPONENT_ID
#define FSL_COMPONENT_ID "platform.drivers.iomuxc"
#endif

/*! @name Driver version */
/*@{*/
/*! @brief IOMUXC driver version 2.0.0 */
#define FSL_IOMUXC_DRIVER_VERSION (MAKE_VERSION(2, 0, 0))
/*@}*/

/*!
 * @name Pin function ID
 * The pin function ID is a tuple of \<muxRegister muxMode inputRegister inputDaisy configRegister\>
 *
 * @{
 */
#define IOMUXC_GPIO_LPSR_00_FLEXCAN3_TX 0x40C08000U, 0x0U, 0, 0, 0x40C08040U
#define IOMUXC_GPIO_LPSR_00_MIC_CLK 0x40C08000U, 0x1U, 0, 0, 0x40C08040U
#define IOMUXC_GPIO_LPSR_00_MQS_RIGHT 0x40C08000U, 0x2U, 0, 0, 0x40C08040U
#define IOMUXC_GPIO_LPSR_00_ARM_CM4_EVENTO 0x40C08000U, 0x3U, 0, 0, 0x40C08040U
#define IOMUXC_GPIO_LPSR_00_GPIO_MUX6_IO00 0x40C08000U, 0x5U, 0, 0, 0x40C08040U
#define IOMUXC_GPIO_LPSR_00_LPUART12_TXD 0x40C08000U, 0x6U, 0x40C080B0U, 0x0U, 0x40C08040U
#define IOMUXC_GPIO_LPSR_00_SAI4_MCLK 0x40C08000U, 0x7U, 0x40C080C8U, 0x0U, 0x40C08040U
#define IOMUXC_GPIO_LPSR_00_GPIO12_IO00 0x40C08000U, 0xAU, 0, 0, 0x40C08040U

#define IOMUXC_GPIO_LPSR_01_FLEXCAN3_RX 0x40C08004U, 0x0U, 0x40C08080U, 0x0U, 0x40C08044U
#define IOMUXC_GPIO_LPSR_01_MIC_BITSTREAM0 0x40C08004U, 0x1U, 0x40C080B4U, 0x0U, 0x40C08044U
#define IOMUXC_GPIO_LPSR_01_MQS_LEFT 0x40C08004U, 0x2U, 0, 0, 0x40C08044U
#define IOMUXC_GPIO_LPSR_01_ARM_CM4_EVENTI 0x40C08004U, 0x3U, 0, 0, 0x40C08044U
#define IOMUXC_GPIO_LPSR_01_GPIO_MUX6_IO01 0x40C08004U, 0x5U, 0, 0, 0x40C08044U
#define IOMUXC_GPIO_LPSR_01_LPUART12_RXD 0x40C08004U, 0x6U, 0x40C080ACU, 0x0U, 0x40C08044U
#define IOMUXC_GPIO_LPSR_01_GPIO12_IO01 0x40C08004U, 0xAU, 0, 0, 0x40C08044U

#define IOMUXC_GPIO_LPSR_02_GPIO12_IO02 0x40C08008U, 0xAU, 0, 0, 0x40C08048U
#define IOMUXC_GPIO_LPSR_02_SRC_BOOT_MODE00 0x40C08008U, 0x0U, 0, 0, 0x40C08048U
#define IOMUXC_GPIO_LPSR_02_LPSPI5_SCK 0x40C08008U, 0x1U, 0x40C08098U, 0x0U, 0x40C08048U
#define IOMUXC_GPIO_LPSR_02_SAI4_TX_DATA 0x40C08008U, 0x2U, 0, 0, 0x40C08048U
#define IOMUXC_GPIO_LPSR_02_MQS_RIGHT 0x40C08008U, 0x3U, 0, 0, 0x40C08048U
#define IOMUXC_GPIO_LPSR_02_GPIO_MUX6_IO02 0x40C08008U, 0x5U, 0, 0, 0x40C08048U

#define IOMUXC_GPIO_LPSR_03_SRC_BOOT_MODE01 0x40C0800CU, 0x0U, 0, 0, 0x40C0804CU
#define IOMUXC_GPIO_LPSR_03_LPSPI5_PCS0 0x40C0800CU, 0x1U, 0x40C08094U, 0x0U, 0x40C0804CU
#define IOMUXC_GPIO_LPSR_03_SAI4_TX_SYNC 0x40C0800CU, 0x2U, 0x40C080DCU, 0x0U, 0x40C0804CU
#define IOMUXC_GPIO_LPSR_03_MQS_LEFT 0x40C0800CU, 0x3U, 0, 0, 0x40C0804CU
#define IOMUXC_GPIO_LPSR_03_GPIO_MUX6_IO03 0x40C0800CU, 0x5U, 0, 0, 0x40C0804CU
#define IOMUXC_GPIO_LPSR_03_GPIO12_IO03 0x40C0800CU, 0xAU, 0, 0, 0x40C0804CU

#define IOMUXC_GPIO_LPSR_04_LPI2C5_SDA 0x40C08010U, 0x0U, 0x40C08088U, 0x0U, 0x40C08050U
#define IOMUXC_GPIO_LPSR_04_LPSPI5_SOUT 0x40C08010U, 0x1U, 0x40C080A0U, 0x0U, 0x40C08050U
#define IOMUXC_GPIO_LPSR_04_SAI4_TX_BCLK 0x40C08010U, 0x2U, 0x40C080D8U, 0x0U, 0x40C08050U
#define IOMUXC_GPIO_LPSR_04_LPUART12_RTS_B 0x40C08010U, 0x3U, 0, 0, 0x40C08050U
#define IOMUXC_GPIO_LPSR_04_GPIO_MUX6_IO04 0x40C08010U, 0x5U, 0, 0, 0x40C08050U
#define IOMUXC_GPIO_LPSR_04_LPUART11_TXD 0x40C08010U, 0x6U, 0x40C080A8U, 0x0U, 0x40C08050U
#define IOMUXC_GPIO_LPSR_04_GPIO12_IO04 0x40C08010U, 0xAU, 0, 0, 0x40C08050U

#define IOMUXC_GPIO_LPSR_05_GPIO12_IO05 0x40C08014U, 0xAU, 0, 0, 0x40C08054U
#define IOMUXC_GPIO_LPSR_05_LPI2C5_SCL 0x40C08014U, 0x0U, 0x40C08084U, 0x0U, 0x40C08054U
#define IOMUXC_GPIO_LPSR_05_LPSPI5_SIN 0x40C08014U, 0x1U, 0x40C0809CU, 0x0U, 0x40C08054U
#define IOMUXC_GPIO_LPSR_05_SAI4_MCLK 0x40C08014U, 0x2U, 0x40C080C8U, 0x1U, 0x40C08054U
#define IOMUXC_GPIO_LPSR_05_LPUART12_CTS_B 0x40C08014U, 0x3U, 0, 0, 0x40C08054U
#define IOMUXC_GPIO_LPSR_05_GPIO_MUX6_IO05 0x40C08014U, 0x5U, 0, 0, 0x40C08054U
#define IOMUXC_GPIO_LPSR_05_LPUART11_RXD 0x40C08014U, 0x6U, 0x40C080A4U, 0x0U, 0x40C08054U
#define IOMUXC_GPIO_LPSR_05_NMI_GLUE_NMI 0x40C08014U, 0x7U, 0x40C080C4U, 0x0U, 0x40C08054U

#define IOMUXC_GPIO_LPSR_06_LPI2C6_SDA 0x40C08018U, 0x0U, 0x40C08090U, 0x0U, 0x40C08058U
#define IOMUXC_GPIO_LPSR_06_SAI4_RX_DATA 0x40C08018U, 0x2U, 0x40C080D0U, 0x0U, 0x40C08058U
#define IOMUXC_GPIO_LPSR_06_LPUART12_TXD 0x40C08018U, 0x3U, 0x40C080B0U, 0x1U, 0x40C08058U
#define IOMUXC_GPIO_LPSR_06_LPSPI6_PCS3 0x40C08018U, 0x4U, 0, 0, 0x40C08058U
#define IOMUXC_GPIO_LPSR_06_GPIO_MUX6_IO06 0x40C08018U, 0x5U, 0, 0, 0x40C08058U
#define IOMUXC_GPIO_LPSR_06_FLEXCAN3_TX 0x40C08018U, 0x6U, 0, 0, 0x40C08058U
#define IOMUXC_GPIO_LPSR_06_PIT2_TRIGGER3 0x40C08018U, 0x7U, 0, 0, 0x40C08058U
#define IOMUXC_GPIO_LPSR_06_LPSPI5_PCS1 0x40C08018U, 0x8U, 0, 0, 0x40C08058U
#define IOMUXC_GPIO_LPSR_06_GPIO12_IO06 0x40C08018U, 0xAU, 0, 0, 0x40C08058U

#define IOMUXC_GPIO_LPSR_07_LPI2C6_SCL 0x40C0801CU, 0x0U, 0x40C0808CU, 0x0U, 0x40C0805CU
#define IOMUXC_GPIO_LPSR_07_SAI4_RX_BCLK 0x40C0801CU, 0x2U, 0x40C080CCU, 0x0U, 0x40C0805CU
#define IOMUXC_GPIO_LPSR_07_LPUART12_RXD 0x40C0801CU, 0x3U, 0x40C080ACU, 0x1U, 0x40C0805CU
#define IOMUXC_GPIO_LPSR_07_LPSPI6_PCS2 0x40C0801CU, 0x4U, 0, 0, 0x40C0805CU
#define IOMUXC_GPIO_LPSR_07_GPIO_MUX6_IO07 0x40C0801CU, 0x5U, 0, 0, 0x40C0805CU
#define IOMUXC_GPIO_LPSR_07_FLEXCAN3_RX 0x40C0801CU, 0x6U, 0x40C08080U, 0x1U, 0x40C0805CU
#define IOMUXC_GPIO_LPSR_07_PIT2_TRIGGER2 0x40C0801CU, 0x7U, 0, 0, 0x40C0805CU
#define IOMUXC_GPIO_LPSR_07_LPSPI5_PCS2 0x40C0801CU, 0x8U, 0, 0, 0x40C0805CU
#define IOMUXC_GPIO_LPSR_07_GPIO12_IO07 0x40C0801CU, 0xAU, 0, 0, 0x40C0805CU

#define IOMUXC_GPIO_LPSR_08_GPIO12_IO08 0x40C08020U, 0xAU, 0, 0, 0x40C08060U
#define IOMUXC_GPIO_LPSR_08_LPUART11_TXD 0x40C08020U, 0x0U, 0x40C080A8U, 0x1U, 0x40C08060U
#define IOMUXC_GPIO_LPSR_08_FLEXCAN3_TX 0x40C08020U, 0x1U, 0, 0, 0x40C08060U
#define IOMUXC_GPIO_LPSR_08_SAI4_RX_SYNC 0x40C08020U, 0x2U, 0x40C080D4U, 0x0U, 0x40C08060U
#define IOMUXC_GPIO_LPSR_08_MIC_CLK 0x40C08020U, 0x3U, 0, 0, 0x40C08060U
#define IOMUXC_GPIO_LPSR_08_LPSPI6_PCS1 0x40C08020U, 0x4U, 0, 0, 0x40C08060U
#define IOMUXC_GPIO_LPSR_08_GPIO_MUX6_IO08 0x40C08020U, 0x5U, 0, 0, 0x40C08060U
#define IOMUXC_GPIO_LPSR_08_LPI2C5_SDA 0x40C08020U, 0x6U, 0x40C08088U, 0x1U, 0x40C08060U
#define IOMUXC_GPIO_LPSR_08_PIT2_TRIGGER1 0x40C08020U, 0x7U, 0, 0, 0x40C08060U
#define IOMUXC_GPIO_LPSR_08_LPSPI5_PCS3 0x40C08020U, 0x8U, 0, 0, 0x40C08060U

#define IOMUXC_GPIO_LPSR_09_GPIO12_IO09 0x40C08024U, 0xAU, 0, 0, 0x40C08064U
#define IOMUXC_GPIO_LPSR_09_LPUART11_RXD 0x40C08024U, 0x0U, 0x40C080A4U, 0x1U, 0x40C08064U
#define IOMUXC_GPIO_LPSR_09_FLEXCAN3_RX 0x40C08024U, 0x1U, 0x40C08080U, 0x2U, 0x40C08064U
#define IOMUXC_GPIO_LPSR_09_PIT2_TRIGGER0 0x40C08024U, 0x2U, 0, 0, 0x40C08064U
#define IOMUXC_GPIO_LPSR_09_MIC_BITSTREAM0 0x40C08024U, 0x3U, 0x40C080B4U, 0x1U, 0x40C08064U
#define IOMUXC_GPIO_LPSR_09_LPSPI6_PCS0 0x40C08024U, 0x4U, 0, 0, 0x40C08064U
#define IOMUXC_GPIO_LPSR_09_GPIO_MUX6_IO09 0x40C08024U, 0x5U, 0, 0, 0x40C08064U
#define IOMUXC_GPIO_LPSR_09_LPI2C5_SCL 0x40C08024U, 0x6U, 0x40C08084U, 0x1U, 0x40C08064U
#define IOMUXC_GPIO_LPSR_09_SAI4_TX_DATA 0x40C08024U, 0x7U, 0, 0, 0x40C08064U

#define IOMUXC_GPIO_LPSR_10_GPIO12_IO10 0x40C08028U, 0xAU, 0, 0, 0x40C08068U
#define IOMUXC_GPIO_LPSR_10_JTAG_MUX_TRSTB 0x40C08028U, 0x0U, 0, 0, 0x40C08068U
#define IOMUXC_GPIO_LPSR_10_LPUART11_CTS_B 0x40C08028U, 0x1U, 0, 0, 0x40C08068U
#define IOMUXC_GPIO_LPSR_10_LPI2C6_SDA 0x40C08028U, 0x2U, 0x40C08090U, 0x1U, 0x40C08068U
#define IOMUXC_GPIO_LPSR_10_MIC_BITSTREAM1 0x40C08028U, 0x3U, 0x40C080B8U, 0x0U, 0x40C08068U
#define IOMUXC_GPIO_LPSR_10_LPSPI6_SCK 0x40C08028U, 0x4U, 0, 0, 0x40C08068U
#define IOMUXC_GPIO_LPSR_10_GPIO_MUX6_IO10 0x40C08028U, 0x5U, 0, 0, 0x40C08068U
#define IOMUXC_GPIO_LPSR_10_LPI2C5_SCLS 0x40C08028U, 0x6U, 0, 0, 0x40C08068U
#define IOMUXC_GPIO_LPSR_10_SAI4_TX_SYNC 0x40C08028U, 0x7U, 0x40C080DCU, 0x1U, 0x40C08068U
#define IOMUXC_GPIO_LPSR_10_LPUART12_TXD 0x40C08028U, 0x8U, 0x40C080B0U, 0x2U, 0x40C08068U

#define IOMUXC_GPIO_LPSR_11_JTAG_MUX_TDO 0x40C0802CU, 0x0U, 0, 0, 0x40C0806CU
#define IOMUXC_GPIO_LPSR_11_LPUART11_RTS_B 0x40C0802CU, 0x1U, 0, 0, 0x40C0806CU
#define IOMUXC_GPIO_LPSR_11_LPI2C6_SCL 0x40C0802CU, 0x2U, 0x40C0808CU, 0x1U, 0x40C0806CU
#define IOMUXC_GPIO_LPSR_11_MIC_BITSTREAM2 0x40C0802CU, 0x3U, 0x40C080BCU, 0x0U, 0x40C0806CU
#define IOMUXC_GPIO_LPSR_11_LPSPI6_SOUT 0x40C0802CU, 0x4U, 0, 0, 0x40C0806CU
#define IOMUXC_GPIO_LPSR_11_GPIO_MUX6_IO11 0x40C0802CU, 0x5U, 0, 0, 0x40C0806CU
#define IOMUXC_GPIO_LPSR_11_LPI2C5_SDAS 0x40C0802CU, 0x6U, 0, 0, 0x40C0806CU
#define IOMUXC_GPIO_LPSR_11_ARM_TRACE_SWO 0x40C0802CU, 0x7U, 0, 0, 0x40C0806CU
#define IOMUXC_GPIO_LPSR_11_LPUART12_RXD 0x40C0802CU, 0x8U, 0x40C080ACU, 0x2U, 0x40C0806CU
#define IOMUXC_GPIO_LPSR_11_GPIO12_IO11 0x40C0802CU, 0xAU, 0, 0, 0x40C0806CU

#define IOMUXC_GPIO_LPSR_12_GPIO12_IO12 0x40C08030U, 0xAU, 0, 0, 0x40C08070U
#define IOMUXC_GPIO_LPSR_12_JTAG_MUX_TDI 0x40C08030U, 0x0U, 0, 0, 0x40C08070U
#define IOMUXC_GPIO_LPSR_12_PIT2_TRIGGER0 0x40C08030U, 0x1U, 0, 0, 0x40C08070U
#define IOMUXC_GPIO_LPSR_12_MIC_BITSTREAM3 0x40C08030U, 0x3U, 0x40C080C0U, 0x0U, 0x40C08070U
#define IOMUXC_GPIO_LPSR_12_LPSPI6_SIN 0x40C08030U, 0x4U, 0, 0, 0x40C08070U
#define IOMUXC_GPIO_LPSR_12_GPIO_MUX6_IO12 0x40C08030U, 0x5U, 0, 0, 0x40C08070U
#define IOMUXC_GPIO_LPSR_12_LPI2C5_HREQ 0x40C08030U, 0x6U, 0, 0, 0x40C08070U
#define IOMUXC_GPIO_LPSR_12_SAI4_TX_BCLK 0x40C08030U, 0x7U, 0x40C080D8U, 0x1U, 0x40C08070U
#define IOMUXC_GPIO_LPSR_12_LPSPI5_SCK 0x40C08030U, 0x8U, 0x40C08098U, 0x1U, 0x40C08070U

#define IOMUXC_GPIO_LPSR_13_GPIO12_IO13 0x40C08034U, 0xAU, 0, 0, 0x40C08074U
#define IOMUXC_GPIO_LPSR_13_JTAG_MUX_MOD 0x40C08034U, 0x0U, 0, 0, 0x40C08074U
#define IOMUXC_GPIO_LPSR_13_MIC_BITSTREAM1 0x40C08034U, 0x1U, 0x40C080B8U, 0x1U, 0x40C08074U
#define IOMUXC_GPIO_LPSR_13_PIT2_TRIGGER1 0x40C08034U, 0x2U, 0, 0, 0x40C08074U
#define IOMUXC_GPIO_LPSR_13_GPIO_MUX6_IO13 0x40C08034U, 0x5U, 0, 0, 0x40C08074U
#define IOMUXC_GPIO_LPSR_13_SAI4_RX_DATA 0x40C08034U, 0x7U, 0x40C080D0U, 0x1U, 0x40C08074U
#define IOMUXC_GPIO_LPSR_13_LPSPI5_PCS0 0x40C08034U, 0x8U, 0x40C08094U, 0x1U, 0x40C08074U

#define IOMUXC_GPIO_LPSR_14_JTAG_MUX_TCK 0x40C08038U, 0x0U, 0, 0, 0x40C08078U
#define IOMUXC_GPIO_LPSR_14_MIC_BITSTREAM2 0x40C08038U, 0x1U, 0x40C080BCU, 0x1U, 0x40C08078U
#define IOMUXC_GPIO_LPSR_14_PIT2_TRIGGER2 0x40C08038U, 0x2U, 0, 0, 0x40C08078U
#define IOMUXC_GPIO_LPSR_14_GPIO_MUX6_IO14 0x40C08038U, 0x5U, 0, 0, 0x40C08078U
#define IOMUXC_GPIO_LPSR_14_SAI4_RX_BCLK 0x40C08038U, 0x7U, 0x40C080CCU, 0x1U, 0x40C08078U
#define IOMUXC_GPIO_LPSR_14_LPSPI5_SOUT 0x40C08038U, 0x8U, 0x40C080A0U, 0x1U, 0x40C08078U
#define IOMUXC_GPIO_LPSR_14_GPIO12_IO14 0x40C08038U, 0xAU, 0, 0, 0x40C08078U

#define IOMUXC_GPIO_LPSR_15_GPIO12_IO15 0x40C0803CU, 0xAU, 0, 0, 0x40C0807CU
#define IOMUXC_GPIO_LPSR_15_JTAG_MUX_TMS 0x40C0803CU, 0x0U, 0, 0, 0x40C0807CU
#define IOMUXC_GPIO_LPSR_15_MIC_BITSTREAM3 0x40C0803CU, 0x1U, 0x40C080C0U, 0x1U, 0x40C0807CU
#define IOMUXC_GPIO_LPSR_15_PIT2_TRIGGER3 0x40C0803CU, 0x2U, 0, 0, 0x40C0807CU
#define IOMUXC_GPIO_LPSR_15_GPIO_MUX6_IO15 0x40C0803CU, 0x5U, 0, 0, 0x40C0807CU
#define IOMUXC_GPIO_LPSR_15_SAI4_RX_SYNC 0x40C0803CU, 0x7U, 0x40C080D4U, 0x1U, 0x40C0807CU
#define IOMUXC_GPIO_LPSR_15_LPSPI5_SIN 0x40C0803CU, 0x8U, 0x40C0809CU, 0x1U, 0x40C0807CU

#define IOMUXC_WAKEUP_DIG_GPIO13_IO00 0x40C94000U, 0x5U, 0, 0, 0x40C94040U
#define IOMUXC_WAKEUP_DIG_NMI_GLUE_NMI 0x40C94000U, 0x7U, 0x40C080C4U, 0x1U, 0x40C94040U

#define IOMUXC_PMIC_ON_REQ_DIG_SNVS_LP_PMIC_ON_REQ 0x40C94004U, 0x0U, 0, 0, 0x40C94044U
#define IOMUXC_PMIC_ON_REQ_DIG_GPIO13_IO01 0x40C94004U, 0x5U, 0, 0, 0x40C94044U

#define IOMUXC_PMIC_STBY_REQ_DIG_CCM_PMIC_VSTBY_REQ 0x40C94008U, 0x0U, 0, 0, 0x40C94048U
#define IOMUXC_PMIC_STBY_REQ_DIG_GPIO13_IO02 0x40C94008U, 0x5U, 0, 0, 0x40C94048U

#define IOMUXC_GPIO_SNVS_00_DIG_SNVS_TAMPER0 0x40C9400CU, 0x0U, 0, 0, 0x40C9404CU
#define IOMUXC_GPIO_SNVS_00_DIG_GPIO13_IO03 0x40C9400CU, 0x5U, 0, 0, 0x40C9404CU

#define IOMUXC_GPIO_SNVS_01_DIG_SNVS_TAMPER1 0x40C94010U, 0x0U, 0, 0, 0x40C94050U
#define IOMUXC_GPIO_SNVS_01_DIG_GPIO13_IO04 0x40C94010U, 0x5U, 0, 0, 0x40C94050U

#define IOMUXC_GPIO_SNVS_02_DIG_SNVS_TAMPER2 0x40C94014U, 0x0U, 0, 0, 0x40C94054U
#define IOMUXC_GPIO_SNVS_02_DIG_GPIO13_IO05 0x40C94014U, 0x5U, 0, 0, 0x40C94054U

#define IOMUXC_GPIO_SNVS_03_DIG_SNVS_TAMPER3 0x40C94018U, 0x0U, 0, 0, 0x40C94058U
#define IOMUXC_GPIO_SNVS_03_DIG_GPIO13_IO06 0x40C94018U, 0x5U, 0, 0, 0x40C94058U

#define IOMUXC_GPIO_SNVS_04_DIG_SNVS_TAMPER4 0x40C9401CU, 0x0U, 0, 0, 0x40C9405CU
#define IOMUXC_GPIO_SNVS_04_DIG_GPIO13_IO07 0x40C9401CU, 0x5U, 0, 0, 0x40C9405CU

#define IOMUXC_GPIO_SNVS_05_DIG_SNVS_TAMPER5 0x40C94020U, 0x0U, 0, 0, 0x40C94060U
#define IOMUXC_GPIO_SNVS_05_DIG_GPIO13_IO08 0x40C94020U, 0x5U, 0, 0, 0x40C94060U

#define IOMUXC_GPIO_SNVS_06_DIG_SNVS_TAMPER6 0x40C94024U, 0x0U, 0, 0, 0x40C94064U
#define IOMUXC_GPIO_SNVS_06_DIG_GPIO13_IO09 0x40C94024U, 0x5U, 0, 0, 0x40C94064U

#define IOMUXC_GPIO_SNVS_07_DIG_SNVS_TAMPER7 0x40C94028U, 0x0U, 0, 0, 0x40C94068U
#define IOMUXC_GPIO_SNVS_07_DIG_GPIO13_IO10 0x40C94028U, 0x5U, 0, 0, 0x40C94068U

#define IOMUXC_GPIO_SNVS_08_DIG_SNVS_TAMPER8 0x40C9402CU, 0x0U, 0, 0, 0x40C9406CU
#define IOMUXC_GPIO_SNVS_08_DIG_GPIO13_IO11 0x40C9402CU, 0x5U, 0, 0, 0x40C9406CU

#define IOMUXC_GPIO_SNVS_09_DIG_SNVS_TAMPER9 0x40C94030U, 0x0U, 0, 0, 0x40C94070U
#define IOMUXC_GPIO_SNVS_09_DIG_GPIO13_IO12 0x40C94030U, 0x5U, 0, 0, 0x40C94070U

#define IOMUXC_TEST_MODE_DIG 0, 0, 0, 0, 0x40C94034U

#define IOMUXC_POR_B_DIG 0, 0, 0, 0, 0x40C94038U

#define IOMUXC_ONOFF_DIG 0, 0, 0, 0, 0x40C9403CU

#define IOMUXC_GPIO_EMC_B1_00_SEMC_DATA00 0x400E8010U, 0x0U, 0, 0, 0x400E8254U
#define IOMUXC_GPIO_EMC_B1_00_FLEXPWM4_PWM0_A 0x400E8010U, 0x1U, 0, 0, 0x400E8254U
#define IOMUXC_GPIO_EMC_B1_00_GPIO_MUX1_IO00 0x400E8010U, 0x5U, 0, 0, 0x400E8254U
#define IOMUXC_GPIO_EMC_B1_00_FLEXIO1_D00 0x400E8010U, 0x8U, 0, 0, 0x400E8254U
#define IOMUXC_GPIO_EMC_B1_00_GPIO7_IO00 0x400E8010U, 0xAU, 0, 0, 0x400E8254U

#define IOMUXC_GPIO_EMC_B1_01_GPIO7_IO01 0x400E8014U, 0xAU, 0, 0, 0x400E8258U
#define IOMUXC_GPIO_EMC_B1_01_SEMC_DATA01 0x400E8014U, 0x0U, 0, 0, 0x400E8258U
#define IOMUXC_GPIO_EMC_B1_01_FLEXPWM4_PWM0_B 0x400E8014U, 0x1U, 0, 0, 0x400E8258U
#define IOMUXC_GPIO_EMC_B1_01_GPIO_MUX1_IO01 0x400E8014U, 0x5U, 0, 0, 0x400E8258U
#define IOMUXC_GPIO_EMC_B1_01_FLEXIO1_D01 0x400E8014U, 0x8U, 0, 0, 0x400E8258U

#define IOMUXC_GPIO_EMC_B1_02_SEMC_DATA02 0x400E8018U, 0x0U, 0, 0, 0x400E825CU
#define IOMUXC_GPIO_EMC_B1_02_FLEXPWM4_PWM1_A 0x400E8018U, 0x1U, 0, 0, 0x400E825CU
#define IOMUXC_GPIO_EMC_B1_02_GPIO_MUX1_IO02 0x400E8018U, 0x5U, 0, 0, 0x400E825CU
#define IOMUXC_GPIO_EMC_B1_02_FLEXIO1_D02 0x400E8018U, 0x8U, 0, 0, 0x400E825CU
#define IOMUXC_GPIO_EMC_B1_02_GPIO7_IO02 0x400E8018U, 0xAU, 0, 0, 0x400E825CU

#define IOMUXC_GPIO_EMC_B1_03_SEMC_DATA03 0x400E801CU, 0x0U, 0, 0, 0x400E8260U
#define IOMUXC_GPIO_EMC_B1_03_FLEXPWM4_PWM1_B 0x400E801CU, 0x1U, 0, 0, 0x400E8260U
#define IOMUXC_GPIO_EMC_B1_03_GPIO_MUX1_IO03 0x400E801CU, 0x5U, 0, 0, 0x400E8260U
#define IOMUXC_GPIO_EMC_B1_03_FLEXIO1_D03 0x400E801CU, 0x8U, 0, 0, 0x400E8260U
#define IOMUXC_GPIO_EMC_B1_03_GPIO7_IO03 0x400E801CU, 0xAU, 0, 0, 0x400E8260U

#define IOMUXC_GPIO_EMC_B1_04_GPIO7_IO04 0x400E8020U, 0xAU, 0, 0, 0x400E8264U
#define IOMUXC_GPIO_EMC_B1_04_SEMC_DATA04 0x400E8020U, 0x0U, 0, 0, 0x400E8264U
#define IOMUXC_GPIO_EMC_B1_04_FLEXPWM4_PWM2_A 0x400E8020U, 0x1U, 0, 0, 0x400E8264U
#define IOMUXC_GPIO_EMC_B1_04_GPIO_MUX1_IO04 0x400E8020U, 0x5U, 0, 0, 0x400E8264U
#define IOMUXC_GPIO_EMC_B1_04_FLEXIO1_D04 0x400E8020U, 0x8U, 0, 0, 0x400E8264U

#define IOMUXC_GPIO_EMC_B1_05_SEMC_DATA05 0x400E8024U, 0x0U, 0, 0, 0x400E8268U
#define IOMUXC_GPIO_EMC_B1_05_FLEXPWM4_PWM2_B 0x400E8024U, 0x1U, 0, 0, 0x400E8268U
#define IOMUXC_GPIO_EMC_B1_05_GPIO_MUX1_IO05 0x400E8024U, 0x5U, 0, 0, 0x400E8268U
#define IOMUXC_GPIO_EMC_B1_05_FLEXIO1_D05 0x400E8024U, 0x8U, 0, 0, 0x400E8268U
#define IOMUXC_GPIO_EMC_B1_05_GPIO7_IO05 0x400E8024U, 0xAU, 0, 0, 0x400E8268U

#define IOMUXC_GPIO_EMC_B1_06_SEMC_DATA06 0x400E8028U, 0x0U, 0, 0, 0x400E826CU
#define IOMUXC_GPIO_EMC_B1_06_FLEXPWM2_PWM0_A 0x400E8028U, 0x1U, 0x400E8518U, 0x0U, 0x400E826CU
#define IOMUXC_GPIO_EMC_B1_06_GPIO_MUX1_IO06 0x400E8028U, 0x5U, 0, 0, 0x400E826CU
#define IOMUXC_GPIO_EMC_B1_06_FLEXIO1_D06 0x400E8028U, 0x8U, 0, 0, 0x400E826CU
#define IOMUXC_GPIO_EMC_B1_06_GPIO7_IO06 0x400E8028U, 0xAU, 0, 0, 0x400E826CU

#define IOMUXC_GPIO_EMC_B1_07_GPIO7_IO07 0x400E802CU, 0xAU, 0, 0, 0x400E8270U
#define IOMUXC_GPIO_EMC_B1_07_SEMC_DATA07 0x400E802CU, 0x0U, 0, 0, 0x400E8270U
#define IOMUXC_GPIO_EMC_B1_07_FLEXPWM2_PWM0_B 0x400E802CU, 0x1U, 0x400E8524U, 0x0U, 0x400E8270U
#define IOMUXC_GPIO_EMC_B1_07_GPIO_MUX1_IO07 0x400E802CU, 0x5U, 0, 0, 0x400E8270U
#define IOMUXC_GPIO_EMC_B1_07_FLEXIO1_D07 0x400E802CU, 0x8U, 0, 0, 0x400E8270U

#define IOMUXC_GPIO_EMC_B1_08_SEMC_DM00 0x400E8030U, 0x0U, 0, 0, 0x400E8274U
#define IOMUXC_GPIO_EMC_B1_08_FLEXPWM2_PWM1_A 0x400E8030U, 0x1U, 0x400E851CU, 0x0U, 0x400E8274U
#define IOMUXC_GPIO_EMC_B1_08_GPIO_MUX1_IO08 0x400E8030U, 0x5U, 0, 0, 0x400E8274U
#define IOMUXC_GPIO_EMC_B1_08_FLEXIO1_D08 0x400E8030U, 0x8U, 0, 0, 0x400E8274U
#define IOMUXC_GPIO_EMC_B1_08_GPIO7_IO08 0x400E8030U, 0xAU, 0, 0, 0x400E8274U

#define IOMUXC_GPIO_EMC_B1_09_SEMC_ADDR00 0x400E8034U, 0x0U, 0, 0, 0x400E8278U
#define IOMUXC_GPIO_EMC_B1_09_FLEXPWM2_PWM1_B 0x400E8034U, 0x1U, 0x400E8528U, 0x0U, 0x400E8278U
#define IOMUXC_GPIO_EMC_B1_09_GPT5_CAPTURE1 0x400E8034U, 0x2U, 0, 0, 0x400E8278U
#define IOMUXC_GPIO_EMC_B1_09_GPIO_MUX1_IO09 0x400E8034U, 0x5U, 0, 0, 0x400E8278U
#define IOMUXC_GPIO_EMC_B1_09_FLEXIO1_D09 0x400E8034U, 0x8U, 0, 0, 0x400E8278U
#define IOMUXC_GPIO_EMC_B1_09_GPIO7_IO09 0x400E8034U, 0xAU, 0, 0, 0x400E8278U

#define IOMUXC_GPIO_EMC_B1_10_SEMC_ADDR01 0x400E8038U, 0x0U, 0, 0, 0x400E827CU
#define IOMUXC_GPIO_EMC_B1_10_FLEXPWM2_PWM2_A 0x400E8038U, 0x1U, 0x400E8520U, 0x0U, 0x400E827CU
#define IOMUXC_GPIO_EMC_B1_10_GPT5_CAPTURE2 0x400E8038U, 0x2U, 0, 0, 0x400E827CU
#define IOMUXC_GPIO_EMC_B1_10_GPIO_MUX1_IO10 0x400E8038U, 0x5U, 0, 0, 0x400E827CU
#define IOMUXC_GPIO_EMC_B1_10_FLEXIO1_D10 0x400E8038U, 0x8U, 0, 0, 0x400E827CU
#define IOMUXC_GPIO_EMC_B1_10_GPIO7_IO10 0x400E8038U, 0xAU, 0, 0, 0x400E827CU

#define IOMUXC_GPIO_EMC_B1_11_GPIO7_IO11 0x400E803CU, 0xAU, 0, 0, 0x400E8280U
#define IOMUXC_GPIO_EMC_B1_11_SEMC_ADDR02 0x400E803CU, 0x0U, 0, 0, 0x400E8280U
#define IOMUXC_GPIO_EMC_B1_11_FLEXPWM2_PWM2_B 0x400E803CU, 0x1U, 0x400E852CU, 0x0U, 0x400E8280U
#define IOMUXC_GPIO_EMC_B1_11_GPT5_COMPARE1 0x400E803CU, 0x2U, 0, 0, 0x400E8280U
#define IOMUXC_GPIO_EMC_B1_11_GPIO_MUX1_IO11 0x400E803CU, 0x5U, 0, 0, 0x400E8280U
#define IOMUXC_GPIO_EMC_B1_11_FLEXIO1_D11 0x400E803CU, 0x8U, 0, 0, 0x400E8280U

#define IOMUXC_GPIO_EMC_B1_12_SEMC_ADDR03 0x400E8040U, 0x0U, 0, 0, 0x400E8284U
#define IOMUXC_GPIO_EMC_B1_12_XBAR1_INOUT04 0x400E8040U, 0x1U, 0, 0, 0x400E8284U
#define IOMUXC_GPIO_EMC_B1_12_GPT5_COMPARE2 0x400E8040U, 0x2U, 0, 0, 0x400E8284U
#define IOMUXC_GPIO_EMC_B1_12_GPIO_MUX1_IO12 0x400E8040U, 0x5U, 0, 0, 0x400E8284U
#define IOMUXC_GPIO_EMC_B1_12_FLEXIO1_D12 0x400E8040U, 0x8U, 0, 0, 0x400E8284U
#define IOMUXC_GPIO_EMC_B1_12_GPIO7_IO12 0x400E8040U, 0xAU, 0, 0, 0x400E8284U

#define IOMUXC_GPIO_EMC_B1_13_SEMC_ADDR04 0x400E8044U, 0x0U, 0, 0, 0x400E8288U
#define IOMUXC_GPIO_EMC_B1_13_XBAR1_INOUT05 0x400E8044U, 0x1U, 0, 0, 0x400E8288U
#define IOMUXC_GPIO_EMC_B1_13_GPT5_COMPARE3 0x400E8044U, 0x2U, 0, 0, 0x400E8288U
#define IOMUXC_GPIO_EMC_B1_13_GPIO_MUX1_IO13 0x400E8044U, 0x5U, 0, 0, 0x400E8288U
#define IOMUXC_GPIO_EMC_B1_13_FLEXIO1_D13 0x400E8044U, 0x8U, 0, 0, 0x400E8288U
#define IOMUXC_GPIO_EMC_B1_13_GPIO7_IO13 0x400E8044U, 0xAU, 0, 0, 0x400E8288U

#define IOMUXC_GPIO_EMC_B1_14_GPIO7_IO14 0x400E8048U, 0xAU, 0, 0, 0x400E828CU
#define IOMUXC_GPIO_EMC_B1_14_SEMC_ADDR05 0x400E8048U, 0x0U, 0, 0, 0x400E828CU
#define IOMUXC_GPIO_EMC_B1_14_XBAR1_INOUT06 0x400E8048U, 0x1U, 0, 0, 0x400E828CU
#define IOMUXC_GPIO_EMC_B1_14_GPT5_CLK 0x400E8048U, 0x2U, 0, 0, 0x400E828CU
#define IOMUXC_GPIO_EMC_B1_14_GPIO_MUX1_IO14 0x400E8048U, 0x5U, 0, 0, 0x400E828CU
#define IOMUXC_GPIO_EMC_B1_14_FLEXIO1_D14 0x400E8048U, 0x8U, 0, 0, 0x400E828CU

#define IOMUXC_GPIO_EMC_B1_15_SEMC_ADDR06 0x400E804CU, 0x0U, 0, 0, 0x400E8290U
#define IOMUXC_GPIO_EMC_B1_15_XBAR1_INOUT07 0x400E804CU, 0x1U, 0, 0, 0x400E8290U
#define IOMUXC_GPIO_EMC_B1_15_GPIO_MUX1_IO15 0x400E804CU, 0x5U, 0, 0, 0x400E8290U
#define IOMUXC_GPIO_EMC_B1_15_FLEXIO1_D15 0x400E804CU, 0x8U, 0, 0, 0x400E8290U
#define IOMUXC_GPIO_EMC_B1_15_GPIO7_IO15 0x400E804CU, 0xAU, 0, 0, 0x400E8290U

#define IOMUXC_GPIO_EMC_B1_16_SEMC_ADDR07 0x400E8050U, 0x0U, 0, 0, 0x400E8294U
#define IOMUXC_GPIO_EMC_B1_16_XBAR1_INOUT08 0x400E8050U, 0x1U, 0, 0, 0x400E8294U
#define IOMUXC_GPIO_EMC_B1_16_GPIO_MUX1_IO16 0x400E8050U, 0x5U, 0, 0, 0x400E8294U
#define IOMUXC_GPIO_EMC_B1_16_FLEXIO1_D16 0x400E8050U, 0x8U, 0, 0, 0x400E8294U
#define IOMUXC_GPIO_EMC_B1_16_GPIO7_IO16 0x400E8050U, 0xAU, 0, 0, 0x400E8294U

#define IOMUXC_GPIO_EMC_B1_17_GPIO7_IO17 0x400E8054U, 0xAU, 0, 0, 0x400E8298U
#define IOMUXC_GPIO_EMC_B1_17_SEMC_ADDR08 0x400E8054U, 0x0U, 0, 0, 0x400E8298U
#define IOMUXC_GPIO_EMC_B1_17_FLEXPWM4_PWM3_A 0x400E8054U, 0x1U, 0, 0, 0x400E8298U
#define IOMUXC_GPIO_EMC_B1_17_TMR1_TIMER0 0x400E8054U, 0x2U, 0x400E863CU, 0x0U, 0x400E8298U
#define IOMUXC_GPIO_EMC_B1_17_GPIO_MUX1_IO17 0x400E8054U, 0x5U, 0, 0, 0x400E8298U
#define IOMUXC_GPIO_EMC_B1_17_FLEXIO1_D17 0x400E8054U, 0x8U, 0, 0, 0x400E8298U

#define IOMUXC_GPIO_EMC_B1_18_SEMC_ADDR09 0x400E8058U, 0x0U, 0, 0, 0x400E829CU
#define IOMUXC_GPIO_EMC_B1_18_FLEXPWM4_PWM3_B 0x400E8058U, 0x1U, 0, 0, 0x400E829CU
#define IOMUXC_GPIO_EMC_B1_18_TMR2_TIMER0 0x400E8058U, 0x2U, 0x400E8648U, 0x0U, 0x400E829CU
#define IOMUXC_GPIO_EMC_B1_18_GPIO_MUX1_IO18 0x400E8058U, 0x5U, 0, 0, 0x400E829CU
#define IOMUXC_GPIO_EMC_B1_18_FLEXIO1_D18 0x400E8058U, 0x8U, 0, 0, 0x400E829CU
#define IOMUXC_GPIO_EMC_B1_18_GPIO7_IO18 0x400E8058U, 0xAU, 0, 0, 0x400E829CU

#define IOMUXC_GPIO_EMC_B1_19_SEMC_ADDR11 0x400E805CU, 0x0U, 0, 0, 0x400E82A0U
#define IOMUXC_GPIO_EMC_B1_19_FLEXPWM2_PWM3_A 0x400E805CU, 0x1U, 0, 0, 0x400E82A0U
#define IOMUXC_GPIO_EMC_B1_19_TMR3_TIMER0 0x400E805CU, 0x2U, 0x400E8654U, 0x0U, 0x400E82A0U
#define IOMUXC_GPIO_EMC_B1_19_GPIO_MUX1_IO19 0x400E805CU, 0x5U, 0, 0, 0x400E82A0U
#define IOMUXC_GPIO_EMC_B1_19_FLEXIO1_D19 0x400E805CU, 0x8U, 0, 0, 0x400E82A0U
#define IOMUXC_GPIO_EMC_B1_19_GPIO7_IO19 0x400E805CU, 0xAU, 0, 0, 0x400E82A0U

#define IOMUXC_GPIO_EMC_B1_20_SEMC_ADDR12 0x400E8060U, 0x0U, 0, 0, 0x400E82A4U
#define IOMUXC_GPIO_EMC_B1_20_FLEXPWM2_PWM3_B 0x400E8060U, 0x1U, 0, 0, 0x400E82A4U
#define IOMUXC_GPIO_EMC_B1_20_TMR4_TIMER0 0x400E8060U, 0x2U, 0x400E8660U, 0x0U, 0x400E82A4U
#define IOMUXC_GPIO_EMC_B1_20_GPIO_MUX1_IO20 0x400E8060U, 0x5U, 0, 0, 0x400E82A4U
#define IOMUXC_GPIO_EMC_B1_20_FLEXIO1_D20 0x400E8060U, 0x8U, 0, 0, 0x400E82A4U
#define IOMUXC_GPIO_EMC_B1_20_GPIO7_IO20 0x400E8060U, 0xAU, 0, 0, 0x400E82A4U

#define IOMUXC_GPIO_EMC_B1_21_GPIO7_IO21 0x400E8064U, 0xAU, 0, 0, 0x400E82A8U
#define IOMUXC_GPIO_EMC_B1_21_SEMC_BA0 0x400E8064U, 0x0U, 0, 0, 0x400E82A8U
#define IOMUXC_GPIO_EMC_B1_21_FLEXPWM3_PWM3_A 0x400E8064U, 0x1U, 0x400E853CU, 0x0U, 0x400E82A8U
#define IOMUXC_GPIO_EMC_B1_21_GPIO_MUX1_IO21 0x400E8064U, 0x5U, 0, 0, 0x400E82A8U
#define IOMUXC_GPIO_EMC_B1_21_FLEXIO1_D21 0x400E8064U, 0x8U, 0, 0, 0x400E82A8U

#define IOMUXC_GPIO_EMC_B1_22_GPIO7_IO22 0x400E8068U, 0xAU, 0, 0, 0x400E82ACU
#define IOMUXC_GPIO_EMC_B1_22_SEMC_BA1 0x400E8068U, 0x0U, 0, 0, 0x400E82ACU
#define IOMUXC_GPIO_EMC_B1_22_FLEXPWM3_PWM3_B 0x400E8068U, 0x1U, 0x400E854CU, 0x0U, 0x400E82ACU
#define IOMUXC_GPIO_EMC_B1_22_GPIO_MUX1_IO22 0x400E8068U, 0x5U, 0, 0, 0x400E82ACU
#define IOMUXC_GPIO_EMC_B1_22_FLEXIO1_D22 0x400E8068U, 0x8U, 0, 0, 0x400E82ACU

#define IOMUXC_GPIO_EMC_B1_23_SEMC_ADDR10 0x400E806CU, 0x0U, 0, 0, 0x400E82B0U
#define IOMUXC_GPIO_EMC_B1_23_FLEXPWM1_PWM0_A 0x400E806CU, 0x1U, 0x400E8500U, 0x0U, 0x400E82B0U
#define IOMUXC_GPIO_EMC_B1_23_GPIO_MUX1_IO23 0x400E806CU, 0x5U, 0, 0, 0x400E82B0U
#define IOMUXC_GPIO_EMC_B1_23_FLEXIO1_D23 0x400E806CU, 0x8U, 0, 0, 0x400E82B0U
#define IOMUXC_GPIO_EMC_B1_23_GPIO7_IO23 0x400E806CU, 0xAU, 0, 0, 0x400E82B0U

#define IOMUXC_GPIO_EMC_B1_24_GPIO7_IO24 0x400E8070U, 0xAU, 0, 0, 0x400E82B4U
#define IOMUXC_GPIO_EMC_B1_24_SEMC_CAS 0x400E8070U, 0x0U, 0, 0, 0x400E82B4U
#define IOMUXC_GPIO_EMC_B1_24_FLEXPWM1_PWM0_B 0x400E8070U, 0x1U, 0x400E850CU, 0x0U, 0x400E82B4U
#define IOMUXC_GPIO_EMC_B1_24_GPIO_MUX1_IO24 0x400E8070U, 0x5U, 0, 0, 0x400E82B4U
#define IOMUXC_GPIO_EMC_B1_24_FLEXIO1_D24 0x400E8070U, 0x8U, 0, 0, 0x400E82B4U

#define IOMUXC_GPIO_EMC_B1_25_GPIO7_IO25 0x400E8074U, 0xAU, 0, 0, 0x400E82B8U
#define IOMUXC_GPIO_EMC_B1_25_SEMC_RAS 0x400E8074U, 0x0U, 0, 0, 0x400E82B8U
#define IOMUXC_GPIO_EMC_B1_25_FLEXPWM1_PWM1_A 0x400E8074U, 0x1U, 0x400E8504U, 0x0U, 0x400E82B8U
#define IOMUXC_GPIO_EMC_B1_25_GPIO_MUX1_IO25 0x400E8074U, 0x5U, 0, 0, 0x400E82B8U
#define IOMUXC_GPIO_EMC_B1_25_FLEXIO1_D25 0x400E8074U, 0x8U, 0, 0, 0x400E82B8U

#define IOMUXC_GPIO_EMC_B1_26_SEMC_CLK 0x400E8078U, 0x0U, 0, 0, 0x400E82BCU
#define IOMUXC_GPIO_EMC_B1_26_FLEXPWM1_PWM1_B 0x400E8078U, 0x1U, 0x400E8510U, 0x0U, 0x400E82BCU
#define IOMUXC_GPIO_EMC_B1_26_GPIO_MUX1_IO26 0x400E8078U, 0x5U, 0, 0, 0x400E82BCU
#define IOMUXC_GPIO_EMC_B1_26_FLEXIO1_D26 0x400E8078U, 0x8U, 0, 0, 0x400E82BCU
#define IOMUXC_GPIO_EMC_B1_26_GPIO7_IO26 0x400E8078U, 0xAU, 0, 0, 0x400E82BCU

#define IOMUXC_GPIO_EMC_B1_27_GPIO7_IO27 0x400E807CU, 0xAU, 0, 0, 0x400E82C0U
#define IOMUXC_GPIO_EMC_B1_27_SEMC_CKE 0x400E807CU, 0x0U, 0, 0, 0x400E82C0U
#define IOMUXC_GPIO_EMC_B1_27_FLEXPWM1_PWM2_A 0x400E807CU, 0x1U, 0x400E8508U, 0x0U, 0x400E82C0U
#define IOMUXC_GPIO_EMC_B1_27_GPIO_MUX1_IO27 0x400E807CU, 0x5U, 0, 0, 0x400E82C0U
#define IOMUXC_GPIO_EMC_B1_27_FLEXIO1_D27 0x400E807CU, 0x8U, 0, 0, 0x400E82C0U

#define IOMUXC_GPIO_EMC_B1_28_GPIO7_IO28 0x400E8080U, 0xAU, 0, 0, 0x400E82C4U
#define IOMUXC_GPIO_EMC_B1_28_SEMC_WE 0x400E8080U, 0x0U, 0, 0, 0x400E82C4U
#define IOMUXC_GPIO_EMC_B1_28_FLEXPWM1_PWM2_B 0x400E8080U, 0x1U, 0x400E8514U, 0x0U, 0x400E82C4U
#define IOMUXC_GPIO_EMC_B1_28_GPIO_MUX1_IO28 0x400E8080U, 0x5U, 0, 0, 0x400E82C4U
#define IOMUXC_GPIO_EMC_B1_28_FLEXIO1_D28 0x400E8080U, 0x8U, 0, 0, 0x400E82C4U

#define IOMUXC_GPIO_EMC_B1_29_SEMC_CS0 0x400E8084U, 0x0U, 0, 0, 0x400E82C8U
#define IOMUXC_GPIO_EMC_B1_29_FLEXPWM3_PWM0_A 0x400E8084U, 0x1U, 0x400E8530U, 0x0U, 0x400E82C8U
#define IOMUXC_GPIO_EMC_B1_29_GPIO_MUX1_IO29 0x400E8084U, 0x5U, 0, 0, 0x400E82C8U
#define IOMUXC_GPIO_EMC_B1_29_FLEXIO1_D29 0x400E8084U, 0x8U, 0, 0, 0x400E82C8U
#define IOMUXC_GPIO_EMC_B1_29_GPIO7_IO29 0x400E8084U, 0xAU, 0, 0, 0x400E82C8U

#define IOMUXC_GPIO_EMC_B1_30_SEMC_DATA08 0x400E8088U, 0x0U, 0, 0, 0x400E82CCU
#define IOMUXC_GPIO_EMC_B1_30_FLEXPWM3_PWM0_B 0x400E8088U, 0x1U, 0x400E8540U, 0x0U, 0x400E82CCU
#define IOMUXC_GPIO_EMC_B1_30_GPIO_MUX1_IO30 0x400E8088U, 0x5U, 0, 0, 0x400E82CCU
#define IOMUXC_GPIO_EMC_B1_30_FLEXIO1_D30 0x400E8088U, 0x8U, 0, 0, 0x400E82CCU
#define IOMUXC_GPIO_EMC_B1_30_GPIO7_IO30 0x400E8088U, 0xAU, 0, 0, 0x400E82CCU

#define IOMUXC_GPIO_EMC_B1_31_GPIO7_IO31 0x400E808CU, 0xAU, 0, 0, 0x400E82D0U
#define IOMUXC_GPIO_EMC_B1_31_SEMC_DATA09 0x400E808CU, 0x0U, 0, 0, 0x400E82D0U
#define IOMUXC_GPIO_EMC_B1_31_FLEXPWM3_PWM1_A 0x400E808CU, 0x1U, 0x400E8534U, 0x0U, 0x400E82D0U
#define IOMUXC_GPIO_EMC_B1_31_GPIO_MUX1_IO31 0x400E808CU, 0x5U, 0, 0, 0x400E82D0U
#define IOMUXC_GPIO_EMC_B1_31_FLEXIO1_D31 0x400E808CU, 0x8U, 0, 0, 0x400E82D0U

#define IOMUXC_GPIO_EMC_B1_32_GPIO8_IO00 0x400E8090U, 0xAU, 0, 0, 0x400E82D4U
#define IOMUXC_GPIO_EMC_B1_32_SEMC_DATA10 0x400E8090U, 0x0U, 0, 0, 0x400E82D4U
#define IOMUXC_GPIO_EMC_B1_32_FLEXPWM3_PWM1_B 0x400E8090U, 0x1U, 0x400E8544U, 0x0U, 0x400E82D4U
#define IOMUXC_GPIO_EMC_B1_32_GPIO_MUX2_IO00 0x400E8090U, 0x5U, 0, 0, 0x400E82D4U

#define IOMUXC_GPIO_EMC_B1_33_SEMC_DATA11 0x400E8094U, 0x0U, 0, 0, 0x400E82D8U
#define IOMUXC_GPIO_EMC_B1_33_FLEXPWM3_PWM2_A 0x400E8094U, 0x1U, 0x400E8538U, 0x0U, 0x400E82D8U
#define IOMUXC_GPIO_EMC_B1_33_GPIO_MUX2_IO01 0x400E8094U, 0x5U, 0, 0, 0x400E82D8U
#define IOMUXC_GPIO_EMC_B1_33_GPIO8_IO01 0x400E8094U, 0xAU, 0, 0, 0x400E82D8U

#define IOMUXC_GPIO_EMC_B1_34_GPIO8_IO02 0x400E8098U, 0xAU, 0, 0, 0x400E82DCU
#define IOMUXC_GPIO_EMC_B1_34_SEMC_DATA12 0x400E8098U, 0x0U, 0, 0, 0x400E82DCU
#define IOMUXC_GPIO_EMC_B1_34_FLEXPWM3_PWM2_B 0x400E8098U, 0x1U, 0x400E8548U, 0x0U, 0x400E82DCU
#define IOMUXC_GPIO_EMC_B1_34_GPIO_MUX2_IO02 0x400E8098U, 0x5U, 0, 0, 0x400E82DCU

#define IOMUXC_GPIO_EMC_B1_35_GPIO8_IO03 0x400E809CU, 0xAU, 0, 0, 0x400E82E0U
#define IOMUXC_GPIO_EMC_B1_35_SEMC_DATA13 0x400E809CU, 0x0U, 0, 0, 0x400E82E0U
#define IOMUXC_GPIO_EMC_B1_35_XBAR1_INOUT09 0x400E809CU, 0x1U, 0, 0, 0x400E82E0U
#define IOMUXC_GPIO_EMC_B1_35_GPIO_MUX2_IO03 0x400E809CU, 0x5U, 0, 0, 0x400E82E0U

#define IOMUXC_GPIO_EMC_B1_36_SEMC_DATA14 0x400E80A0U, 0x0U, 0, 0, 0x400E82E4U
#define IOMUXC_GPIO_EMC_B1_36_XBAR1_INOUT10 0x400E80A0U, 0x1U, 0, 0, 0x400E82E4U
#define IOMUXC_GPIO_EMC_B1_36_GPIO_MUX2_IO04 0x400E80A0U, 0x5U, 0, 0, 0x400E82E4U
#define IOMUXC_GPIO_EMC_B1_36_GPIO8_IO04 0x400E80A0U, 0xAU, 0, 0, 0x400E82E4U

#define IOMUXC_GPIO_EMC_B1_37_GPIO8_IO05 0x400E80A4U, 0xAU, 0, 0, 0x400E82E8U
#define IOMUXC_GPIO_EMC_B1_37_SEMC_DATA15 0x400E80A4U, 0x0U, 0, 0, 0x400E82E8U
#define IOMUXC_GPIO_EMC_B1_37_XBAR1_INOUT11 0x400E80A4U, 0x1U, 0, 0, 0x400E82E8U
#define IOMUXC_GPIO_EMC_B1_37_GPIO_MUX2_IO05 0x400E80A4U, 0x5U, 0, 0, 0x400E82E8U

#define IOMUXC_GPIO_EMC_B1_38_GPIO8_IO06 0x400E80A8U, 0xAU, 0, 0, 0x400E82ECU
#define IOMUXC_GPIO_EMC_B1_38_SEMC_DM01 0x400E80A8U, 0x0U, 0, 0, 0x400E82ECU
#define IOMUXC_GPIO_EMC_B1_38_FLEXPWM1_PWM3_A 0x400E80A8U, 0x1U, 0, 0, 0x400E82ECU
#define IOMUXC_GPIO_EMC_B1_38_TMR1_TIMER1 0x400E80A8U, 0x2U, 0x400E8640U, 0x0U, 0x400E82ECU
#define IOMUXC_GPIO_EMC_B1_38_GPIO_MUX2_IO06 0x400E80A8U, 0x5U, 0, 0, 0x400E82ECU

#define IOMUXC_GPIO_EMC_B1_39_SEMC_DQS 0x400E80ACU, 0x0U, 0, 0, 0x400E82F0U
#define IOMUXC_GPIO_EMC_B1_39_FLEXPWM1_PWM3_B 0x400E80ACU, 0x1U, 0, 0, 0x400E82F0U
#define IOMUXC_GPIO_EMC_B1_39_TMR2_TIMER1 0x400E80ACU, 0x2U, 0x400E864CU, 0x0U, 0x400E82F0U
#define IOMUXC_GPIO_EMC_B1_39_GPIO_MUX2_IO07 0x400E80ACU, 0x5U, 0, 0, 0x400E82F0U
#define IOMUXC_GPIO_EMC_B1_39_GPIO8_IO07 0x400E80ACU, 0xAU, 0, 0, 0x400E82F0U

#define IOMUXC_GPIO_EMC_B1_40_SEMC_RDY 0x400E80B0U, 0x0U, 0, 0, 0x400E82F4U
#define IOMUXC_GPIO_EMC_B1_40_XBAR1_INOUT12 0x400E80B0U, 0x1U, 0, 0, 0x400E82F4U
#define IOMUXC_GPIO_EMC_B1_40_MQS_RIGHT 0x400E80B0U, 0x2U, 0, 0, 0x400E82F4U
#define IOMUXC_GPIO_EMC_B1_40_LPUART6_TXD 0x400E80B0U, 0x3U, 0, 0, 0x400E82F4U
#define IOMUXC_GPIO_EMC_B1_40_GPIO_MUX2_IO08 0x400E80B0U, 0x5U, 0, 0, 0x400E82F4U
#define IOMUXC_GPIO_EMC_B1_40_ENET_1G_MDC 0x400E80B0U, 0x7U, 0, 0, 0x400E82F4U
#define IOMUXC_GPIO_EMC_B1_40_CCM_CLKO1 0x400E80B0U, 0x9U, 0, 0, 0x400E82F4U
#define IOMUXC_GPIO_EMC_B1_40_GPIO8_IO08 0x400E80B0U, 0xAU, 0, 0, 0x400E82F4U

#define IOMUXC_GPIO_EMC_B1_41_GPIO8_IO09 0x400E80B4U, 0xAU, 0, 0, 0x400E82F8U
#define IOMUXC_GPIO_EMC_B1_41_SEMC_CSX00 0x400E80B4U, 0x0U, 0, 0, 0x400E82F8U
#define IOMUXC_GPIO_EMC_B1_41_XBAR1_INOUT13 0x400E80B4U, 0x1U, 0, 0, 0x400E82F8U
#define IOMUXC_GPIO_EMC_B1_41_MQS_LEFT 0x400E80B4U, 0x2U, 0, 0, 0x400E82F8U
#define IOMUXC_GPIO_EMC_B1_41_LPUART6_RXD 0x400E80B4U, 0x3U, 0, 0, 0x400E82F8U
#define IOMUXC_GPIO_EMC_B1_41_FLEXSPI2_B_DATA07 0x400E80B4U, 0x4U, 0, 0, 0x400E82F8U
#define IOMUXC_GPIO_EMC_B1_41_GPIO_MUX2_IO09 0x400E80B4U, 0x5U, 0, 0, 0x400E82F8U
#define IOMUXC_GPIO_EMC_B1_41_ENET_1G_MDIO 0x400E80B4U, 0x7U, 0x400E84C8U, 0x0U, 0x400E82F8U
#define IOMUXC_GPIO_EMC_B1_41_CCM_CLKO2 0x400E80B4U, 0x9U, 0, 0, 0x400E82F8U

#define IOMUXC_GPIO_EMC_B2_00_SEMC_DATA16 0x400E80B8U, 0x0U, 0, 0, 0x400E82FCU
#define IOMUXC_GPIO_EMC_B2_00_CCM_ENET_REF_CLK_25M 0x400E80B8U, 0x1U, 0, 0, 0x400E82FCU
#define IOMUXC_GPIO_EMC_B2_00_TMR3_TIMER1 0x400E80B8U, 0x2U, 0x400E8658U, 0x0U, 0x400E82FCU
#define IOMUXC_GPIO_EMC_B2_00_LPUART6_CTS_B 0x400E80B8U, 0x3U, 0, 0, 0x400E82FCU
#define IOMUXC_GPIO_EMC_B2_00_FLEXSPI2_B_DATA06 0x400E80B8U, 0x4U, 0, 0, 0x400E82FCU
#define IOMUXC_GPIO_EMC_B2_00_GPIO_MUX2_IO10 0x400E80B8U, 0x5U, 0, 0, 0x400E82FCU
#define IOMUXC_GPIO_EMC_B2_00_XBAR1_INOUT20 0x400E80B8U, 0x6U, 0x400E86D8U, 0x0U, 0x400E82FCU
#define IOMUXC_GPIO_EMC_B2_00_ENET_QOS_1588_EVENT1_OUT 0x400E80B8U, 0x7U, 0, 0, 0x400E82FCU
#define IOMUXC_GPIO_EMC_B2_00_LPSPI1_SCK 0x400E80B8U, 0x8U, 0x400E85D0U, 0x0U, 0x400E82FCU
#define IOMUXC_GPIO_EMC_B2_00_LPI2C2_SCL 0x400E80B8U, 0x9U, 0x400E85B4U, 0x0U, 0x400E82FCU
#define IOMUXC_GPIO_EMC_B2_00_GPIO8_IO10 0x400E80B8U, 0xAU, 0, 0, 0x400E82FCU
#define IOMUXC_GPIO_EMC_B2_00_FLEXPWM3_PWM0_A 0x400E80B8U, 0xBU, 0x400E8530U, 0x1U, 0x400E82FCU

#define IOMUXC_GPIO_EMC_B2_01_SEMC_DATA17 0x400E80BCU, 0x0U, 0, 0, 0x400E8300U
#define IOMUXC_GPIO_EMC_B2_01_USDHC2_CD_B 0x400E80BCU, 0x1U, 0x400E86D0U, 0x0U, 0x400E8300U
#define IOMUXC_GPIO_EMC_B2_01_TMR4_TIMER1 0x400E80BCU, 0x2U, 0x400E8664U, 0x0U, 0x400E8300U
#define IOMUXC_GPIO_EMC_B2_01_LPUART6_RTS_B 0x400E80BCU, 0x3U, 0, 0, 0x400E8300U
#define IOMUXC_GPIO_EMC_B2_01_FLEXSPI2_B_DATA05 0x400E80BCU, 0x4U, 0, 0, 0x400E8300U
#define IOMUXC_GPIO_EMC_B2_01_GPIO_MUX2_IO11 0x400E80BCU, 0x5U, 0, 0, 0x400E8300U
#define IOMUXC_GPIO_EMC_B2_01_XBAR1_INOUT21 0x400E80BCU, 0x6U, 0x400E86DCU, 0x0U, 0x400E8300U
#define IOMUXC_GPIO_EMC_B2_01_ENET_QOS_1588_EVENT1_IN 0x400E80BCU, 0x7U, 0, 0, 0x400E8300U
#define IOMUXC_GPIO_EMC_B2_01_LPSPI1_PCS0 0x400E80BCU, 0x8U, 0x400E85CCU, 0x0U, 0x400E8300U
#define IOMUXC_GPIO_EMC_B2_01_LPI2C2_SDA 0x400E80BCU, 0x9U, 0x400E85B8U, 0x0U, 0x400E8300U
#define IOMUXC_GPIO_EMC_B2_01_GPIO8_IO11 0x400E80BCU, 0xAU, 0, 0, 0x400E8300U
#define IOMUXC_GPIO_EMC_B2_01_FLEXPWM3_PWM0_B 0x400E80BCU, 0xBU, 0x400E8540U, 0x1U, 0x400E8300U

#define IOMUXC_GPIO_EMC_B2_02_SEMC_DATA18 0x400E80C0U, 0x0U, 0, 0, 0x400E8304U
#define IOMUXC_GPIO_EMC_B2_02_USDHC2_WP 0x400E80C0U, 0x1U, 0x400E86D4U, 0x0U, 0x400E8304U
#define IOMUXC_GPIO_EMC_B2_02_VIDEO_MUX_CSI_DATA23 0x400E80C0U, 0x3U, 0, 0, 0x400E8304U
#define IOMUXC_GPIO_EMC_B2_02_FLEXSPI2_B_DATA04 0x400E80C0U, 0x4U, 0, 0, 0x400E8304U
#define IOMUXC_GPIO_EMC_B2_02_GPIO_MUX2_IO12 0x400E80C0U, 0x5U, 0, 0, 0x400E8304U
#define IOMUXC_GPIO_EMC_B2_02_XBAR1_INOUT22 0x400E80C0U, 0x6U, 0x400E86E0U, 0x0U, 0x400E8304U
#define IOMUXC_GPIO_EMC_B2_02_ENET_QOS_1588_EVENT1_AUX_IN 0x400E80C0U, 0x7U, 0, 0, 0x400E8304U
#define IOMUXC_GPIO_EMC_B2_02_LPSPI1_SOUT 0x400E80C0U, 0x8U, 0x400E85D8U, 0x0U, 0x400E8304U
#define IOMUXC_GPIO_EMC_B2_02_GPIO8_IO12 0x400E80C0U, 0xAU, 0, 0, 0x400E8304U
#define IOMUXC_GPIO_EMC_B2_02_FLEXPWM3_PWM1_A 0x400E80C0U, 0xBU, 0x400E8534U, 0x1U, 0x400E8304U

#define IOMUXC_GPIO_EMC_B2_03_SEMC_DATA19 0x400E80C4U, 0x0U, 0, 0, 0x400E8308U
#define IOMUXC_GPIO_EMC_B2_03_USDHC2_VSELECT 0x400E80C4U, 0x1U, 0, 0, 0x400E8308U
#define IOMUXC_GPIO_EMC_B2_03_VIDEO_MUX_CSI_DATA22 0x400E80C4U, 0x3U, 0, 0, 0x400E8308U
#define IOMUXC_GPIO_EMC_B2_03_FLEXSPI2_B_DATA03 0x400E80C4U, 0x4U, 0, 0, 0x400E8308U
#define IOMUXC_GPIO_EMC_B2_03_GPIO_MUX2_IO13 0x400E80C4U, 0x5U, 0, 0, 0x400E8308U
#define IOMUXC_GPIO_EMC_B2_03_XBAR1_INOUT23 0x400E80C4U, 0x6U, 0x400E86E4U, 0x0U, 0x400E8308U
#define IOMUXC_GPIO_EMC_B2_03_ENET_1G_TX_DATA03 0x400E80C4U, 0x7U, 0, 0, 0x400E8308U
#define IOMUXC_GPIO_EMC_B2_03_LPSPI1_SIN 0x400E80C4U, 0x8U, 0x400E85D4U, 0x0U, 0x400E8308U
#define IOMUXC_GPIO_EMC_B2_03_GPIO8_IO13 0x400E80C4U, 0xAU, 0, 0, 0x400E8308U
#define IOMUXC_GPIO_EMC_B2_03_FLEXPWM3_PWM1_B 0x400E80C4U, 0xBU, 0x400E8544U, 0x1U, 0x400E8308U

#define IOMUXC_GPIO_EMC_B2_04_SEMC_DATA20 0x400E80C8U, 0x0U, 0, 0, 0x400E830CU
#define IOMUXC_GPIO_EMC_B2_04_USDHC2_RESET_B 0x400E80C8U, 0x1U, 0, 0, 0x400E830CU
#define IOMUXC_GPIO_EMC_B2_04_SAI2_MCLK 0x400E80C8U, 0x2U, 0, 0, 0x400E830CU
#define IOMUXC_GPIO_EMC_B2_04_VIDEO_MUX_CSI_DATA21 0x400E80C8U, 0x3U, 0, 0, 0x400E830CU
#define IOMUXC_GPIO_EMC_B2_04_FLEXSPI2_B_DATA02 0x400E80C8U, 0x4U, 0, 0, 0x400E830CU
#define IOMUXC_GPIO_EMC_B2_04_GPIO_MUX2_IO14 0x400E80C8U, 0x5U, 0, 0, 0x400E830CU
#define IOMUXC_GPIO_EMC_B2_04_XBAR1_INOUT24 0x400E80C8U, 0x6U, 0x400E86E8U, 0x0U, 0x400E830CU
#define IOMUXC_GPIO_EMC_B2_04_ENET_1G_TX_DATA02 0x400E80C8U, 0x7U, 0, 0, 0x400E830CU
#define IOMUXC_GPIO_EMC_B2_04_LPSPI3_SCK 0x400E80C8U, 0x8U, 0x400E8600U, 0x0U, 0x400E830CU
#define IOMUXC_GPIO_EMC_B2_04_GPIO8_IO14 0x400E80C8U, 0xAU, 0, 0, 0x400E830CU
#define IOMUXC_GPIO_EMC_B2_04_FLEXPWM3_PWM2_A 0x400E80C8U, 0xBU, 0x400E8538U, 0x1U, 0x400E830CU

#define IOMUXC_GPIO_EMC_B2_05_SEMC_DATA21 0x400E80CCU, 0x0U, 0, 0, 0x400E8310U
#define IOMUXC_GPIO_EMC_B2_05_GPT3_CLK 0x400E80CCU, 0x1U, 0x400E8598U, 0x0U, 0x400E8310U
#define IOMUXC_GPIO_EMC_B2_05_SAI2_RX_SYNC 0x400E80CCU, 0x2U, 0, 0, 0x400E8310U
#define IOMUXC_GPIO_EMC_B2_05_VIDEO_MUX_CSI_DATA20 0x400E80CCU, 0x3U, 0, 0, 0x400E8310U
#define IOMUXC_GPIO_EMC_B2_05_FLEXSPI2_B_DATA01 0x400E80CCU, 0x4U, 0, 0, 0x400E8310U
#define IOMUXC_GPIO_EMC_B2_05_GPIO_MUX2_IO15 0x400E80CCU, 0x5U, 0, 0, 0x400E8310U
#define IOMUXC_GPIO_EMC_B2_05_XBAR1_INOUT25 0x400E80CCU, 0x6U, 0x400E86ECU, 0x0U, 0x400E8310U
#define IOMUXC_GPIO_EMC_B2_05_ENET_1G_RX_CLK 0x400E80CCU, 0x7U, 0x400E84CCU, 0x0U, 0x400E8310U
#define IOMUXC_GPIO_EMC_B2_05_LPSPI3_PCS0 0x400E80CCU, 0x8U, 0x400E85F0U, 0x0U, 0x400E8310U
#define IOMUXC_GPIO_EMC_B2_05_PIT1_TRIGGER0 0x400E80CCU, 0x9U, 0, 0, 0x400E8310U
#define IOMUXC_GPIO_EMC_B2_05_GPIO8_IO15 0x400E80CCU, 0xAU, 0, 0, 0x400E8310U
#define IOMUXC_GPIO_EMC_B2_05_FLEXPWM3_PWM2_B 0x400E80CCU, 0xBU, 0x400E8548U, 0x1U, 0x400E8310U

#define IOMUXC_GPIO_EMC_B2_06_SEMC_DATA22 0x400E80D0U, 0x0U, 0, 0, 0x400E8314U
#define IOMUXC_GPIO_EMC_B2_06_GPT3_CAPTURE1 0x400E80D0U, 0x1U, 0x400E8590U, 0x0U, 0x400E8314U
#define IOMUXC_GPIO_EMC_B2_06_GPIO8_IO16 0x400E80D0U, 0xAU, 0, 0, 0x400E8314U
#define IOMUXC_GPIO_EMC_B2_06_SAI2_RX_BCLK 0x400E80D0U, 0x2U, 0, 0, 0x400E8314U
#define IOMUXC_GPIO_EMC_B2_06_FLEXPWM3_PWM3_A 0x400E80D0U, 0xBU, 0x400E853CU, 0x1U, 0x400E8314U
#define IOMUXC_GPIO_EMC_B2_06_VIDEO_MUX_CSI_DATA19 0x400E80D0U, 0x3U, 0, 0, 0x400E8314U
#define IOMUXC_GPIO_EMC_B2_06_FLEXSPI2_B_DATA00 0x400E80D0U, 0x4U, 0, 0, 0x400E8314U
#define IOMUXC_GPIO_EMC_B2_06_GPIO_MUX2_IO16 0x400E80D0U, 0x5U, 0, 0, 0x400E8314U
#define IOMUXC_GPIO_EMC_B2_06_XBAR1_INOUT26 0x400E80D0U, 0x6U, 0x400E86F0U, 0x0U, 0x400E8314U
#define IOMUXC_GPIO_EMC_B2_06_ENET_1G_TX_ER 0x400E80D0U, 0x7U, 0, 0, 0x400E8314U
#define IOMUXC_GPIO_EMC_B2_06_LPSPI3_SOUT 0x400E80D0U, 0x8U, 0x400E8608U, 0x0U, 0x400E8314U
#define IOMUXC_GPIO_EMC_B2_06_PIT1_TRIGGER1 0x400E80D0U, 0x9U, 0, 0, 0x400E8314U

#define IOMUXC_GPIO_EMC_B2_07_SEMC_DATA23 0x400E80D4U, 0x0U, 0, 0, 0x400E8318U
#define IOMUXC_GPIO_EMC_B2_07_GPT3_CAPTURE2 0x400E80D4U, 0x1U, 0x400E8594U, 0x0U, 0x400E8318U
#define IOMUXC_GPIO_EMC_B2_07_SAI2_RX_DATA 0x400E80D4U, 0x2U, 0, 0, 0x400E8318U
#define IOMUXC_GPIO_EMC_B2_07_VIDEO_MUX_CSI_DATA18 0x400E80D4U, 0x3U, 0, 0, 0x400E8318U
#define IOMUXC_GPIO_EMC_B2_07_FLEXSPI2_B_DQS 0x400E80D4U, 0x4U, 0, 0, 0x400E8318U
#define IOMUXC_GPIO_EMC_B2_07_GPIO_MUX2_IO17 0x400E80D4U, 0x5U, 0, 0, 0x400E8318U
#define IOMUXC_GPIO_EMC_B2_07_XBAR1_INOUT27 0x400E80D4U, 0x6U, 0x400E86F4U, 0x0U, 0x400E8318U
#define IOMUXC_GPIO_EMC_B2_07_ENET_1G_RX_DATA03 0x400E80D4U, 0x7U, 0x400E84DCU, 0x0U, 0x400E8318U
#define IOMUXC_GPIO_EMC_B2_07_LPSPI3_SIN 0x400E80D4U, 0x8U, 0x400E8604U, 0x0U, 0x400E8318U
#define IOMUXC_GPIO_EMC_B2_07_PIT1_TRIGGER2 0x400E80D4U, 0x9U, 0, 0, 0x400E8318U
#define IOMUXC_GPIO_EMC_B2_07_GPIO8_IO17 0x400E80D4U, 0xAU, 0, 0, 0x400E8318U
#define IOMUXC_GPIO_EMC_B2_07_FLEXPWM3_PWM3_B 0x400E80D4U, 0xBU, 0x400E854CU, 0x1U, 0x400E8318U

#define IOMUXC_GPIO_EMC_B2_08_SEMC_DM02 0x400E80D8U, 0x0U, 0, 0, 0x400E831CU
#define IOMUXC_GPIO_EMC_B2_08_GPT3_COMPARE1 0x400E80D8U, 0x1U, 0, 0, 0x400E831CU
#define IOMUXC_GPIO_EMC_B2_08_SAI2_TX_DATA 0x400E80D8U, 0x2U, 0, 0, 0x400E831CU
#define IOMUXC_GPIO_EMC_B2_08_VIDEO_MUX_CSI_DATA17 0x400E80D8U, 0x3U, 0, 0, 0x400E831CU
#define IOMUXC_GPIO_EMC_B2_08_FLEXSPI2_B_SS0_B 0x400E80D8U, 0x4U, 0, 0, 0x400E831CU
#define IOMUXC_GPIO_EMC_B2_08_GPIO_MUX2_IO18 0x400E80D8U, 0x5U, 0, 0, 0x400E831CU
#define IOMUXC_GPIO_EMC_B2_08_XBAR1_INOUT28 0x400E80D8U, 0x6U, 0x400E86F8U, 0x0U, 0x400E831CU
#define IOMUXC_GPIO_EMC_B2_08_ENET_1G_RX_DATA02 0x400E80D8U, 0x7U, 0x400E84D8U, 0x0U, 0x400E831CU
#define IOMUXC_GPIO_EMC_B2_08_LPSPI3_PCS1 0x400E80D8U, 0x8U, 0x400E85F4U, 0x0U, 0x400E831CU
#define IOMUXC_GPIO_EMC_B2_08_PIT1_TRIGGER3 0x400E80D8U, 0x9U, 0, 0, 0x400E831CU
#define IOMUXC_GPIO_EMC_B2_08_GPIO8_IO18 0x400E80D8U, 0xAU, 0, 0, 0x400E831CU

#define IOMUXC_GPIO_EMC_B2_09_GPIO8_IO19 0x400E80DCU, 0xAU, 0, 0, 0x400E8320U
#define IOMUXC_GPIO_EMC_B2_09_SEMC_DATA24 0x400E80DCU, 0x0U, 0, 0, 0x400E8320U
#define IOMUXC_GPIO_EMC_B2_09_GPT3_COMPARE2 0x400E80DCU, 0x1U, 0, 0, 0x400E8320U
#define IOMUXC_GPIO_EMC_B2_09_SAI2_TX_BCLK 0x400E80DCU, 0x2U, 0, 0, 0x400E8320U
#define IOMUXC_GPIO_EMC_B2_09_VIDEO_MUX_CSI_DATA16 0x400E80DCU, 0x3U, 0, 0, 0x400E8320U
#define IOMUXC_GPIO_EMC_B2_09_FLEXSPI2_B_SCLK 0x400E80DCU, 0x4U, 0, 0, 0x400E8320U
#define IOMUXC_GPIO_EMC_B2_09_GPIO_MUX2_IO19 0x400E80DCU, 0x5U, 0, 0, 0x400E8320U
#define IOMUXC_GPIO_EMC_B2_09_XBAR1_INOUT29 0x400E80DCU, 0x6U, 0x400E86FCU, 0x0U, 0x400E8320U
#define IOMUXC_GPIO_EMC_B2_09_ENET_1G_CRS 0x400E80DCU, 0x7U, 0, 0, 0x400E8320U
#define IOMUXC_GPIO_EMC_B2_09_LPSPI3_PCS2 0x400E80DCU, 0x8U, 0x400E85F8U, 0x0U, 0x400E8320U
#define IOMUXC_GPIO_EMC_B2_09_TMR1_TIMER0 0x400E80DCU, 0x9U, 0x400E863CU, 0x1U, 0x400E8320U

#define IOMUXC_GPIO_EMC_B2_10_GPIO8_IO20 0x400E80E0U, 0xAU, 0, 0, 0x400E8324U
#define IOMUXC_GPIO_EMC_B2_10_SEMC_DATA25 0x400E80E0U, 0x0U, 0, 0, 0x400E8324U
#define IOMUXC_GPIO_EMC_B2_10_GPT3_COMPARE3 0x400E80E0U, 0x1U, 0, 0, 0x400E8324U
#define IOMUXC_GPIO_EMC_B2_10_SAI2_TX_SYNC 0x400E80E0U, 0x2U, 0, 0, 0x400E8324U
#define IOMUXC_GPIO_EMC_B2_10_VIDEO_MUX_CSI_FIELD 0x400E80E0U, 0x3U, 0, 0, 0x400E8324U
#define IOMUXC_GPIO_EMC_B2_10_FLEXSPI2_A_SCLK 0x400E80E0U, 0x4U, 0x400E858CU, 0x0U, 0x400E8324U
#define IOMUXC_GPIO_EMC_B2_10_GPIO_MUX2_IO20 0x400E80E0U, 0x5U, 0, 0, 0x400E8324U
#define IOMUXC_GPIO_EMC_B2_10_XBAR1_INOUT30 0x400E80E0U, 0x6U, 0x400E8700U, 0x0U, 0x400E8324U
#define IOMUXC_GPIO_EMC_B2_10_ENET_1G_COL 0x400E80E0U, 0x7U, 0, 0, 0x400E8324U
#define IOMUXC_GPIO_EMC_B2_10_LPSPI3_PCS3 0x400E80E0U, 0x8U, 0x400E85FCU, 0x0U, 0x400E8324U
#define IOMUXC_GPIO_EMC_B2_10_TMR1_TIMER1 0x400E80E0U, 0x9U, 0x400E8640U, 0x1U, 0x400E8324U

#define IOMUXC_GPIO_EMC_B2_11_SEMC_DATA26 0x400E80E4U, 0x0U, 0, 0, 0x400E8328U
#define IOMUXC_GPIO_EMC_B2_11_SPDIF_IN 0x400E80E4U, 0x1U, 0x400E86B4U, 0x0U, 0x400E8328U
#define IOMUXC_GPIO_EMC_B2_11_ENET_1G_TX_DATA00 0x400E80E4U, 0x2U, 0, 0, 0x400E8328U
#define IOMUXC_GPIO_EMC_B2_11_SAI3_RX_SYNC 0x400E80E4U, 0x3U, 0, 0, 0x400E8328U
#define IOMUXC_GPIO_EMC_B2_11_FLEXSPI2_A_SS0_B 0x400E80E4U, 0x4U, 0, 0, 0x400E8328U
#define IOMUXC_GPIO_EMC_B2_11_GPIO_MUX2_IO21 0x400E80E4U, 0x5U, 0, 0, 0x400E8328U
#define IOMUXC_GPIO_EMC_B2_11_XBAR1_INOUT31 0x400E80E4U, 0x6U, 0x400E8704U, 0x0U, 0x400E8328U
#define IOMUXC_GPIO_EMC_B2_11_EMVSIM1_IO 0x400E80E4U, 0x8U, 0x400E869CU, 0x0U, 0x400E8328U
#define IOMUXC_GPIO_EMC_B2_11_TMR1_TIMER2 0x400E80E4U, 0x9U, 0x400E8644U, 0x0U, 0x400E8328U
#define IOMUXC_GPIO_EMC_B2_11_GPIO8_IO21 0x400E80E4U, 0xAU, 0, 0, 0x400E8328U

#define IOMUXC_GPIO_EMC_B2_12_SEMC_DATA27 0x400E80E8U, 0x0U, 0, 0, 0x400E832CU
#define IOMUXC_GPIO_EMC_B2_12_SPDIF_OUT 0x400E80E8U, 0x1U, 0, 0, 0x400E832CU
#define IOMUXC_GPIO_EMC_B2_12_ENET_1G_TX_DATA01 0x400E80E8U, 0x2U, 0, 0, 0x400E832CU
#define IOMUXC_GPIO_EMC_B2_12_SAI3_RX_BCLK 0x400E80E8U, 0x3U, 0, 0, 0x400E832CU
#define IOMUXC_GPIO_EMC_B2_12_FLEXSPI2_A_DQS 0x400E80E8U, 0x4U, 0, 0, 0x400E832CU
#define IOMUXC_GPIO_EMC_B2_12_GPIO_MUX2_IO22 0x400E80E8U, 0x5U, 0, 0, 0x400E832CU
#define IOMUXC_GPIO_EMC_B2_12_XBAR1_INOUT32 0x400E80E8U, 0x6U, 0x400E8708U, 0x0U, 0x400E832CU
#define IOMUXC_GPIO_EMC_B2_12_EMVSIM1_CLK 0x400E80E8U, 0x8U, 0, 0, 0x400E832CU
#define IOMUXC_GPIO_EMC_B2_12_TMR1_TIMER3 0x400E80E8U, 0x9U, 0, 0, 0x400E832CU
#define IOMUXC_GPIO_EMC_B2_12_GPIO8_IO22 0x400E80E8U, 0xAU, 0, 0, 0x400E832CU

#define IOMUXC_GPIO_EMC_B2_13_GPIO8_IO23 0x400E80ECU, 0xAU, 0, 0, 0x400E8330U
#define IOMUXC_GPIO_EMC_B2_13_SEMC_DATA28 0x400E80ECU, 0x0U, 0, 0, 0x400E8330U
#define IOMUXC_GPIO_EMC_B2_13_ENET_1G_TX_EN 0x400E80ECU, 0x2U, 0, 0, 0x400E8330U
#define IOMUXC_GPIO_EMC_B2_13_SAI3_RX_DATA 0x400E80ECU, 0x3U, 0, 0, 0x400E8330U
#define IOMUXC_GPIO_EMC_B2_13_FLEXSPI2_A_DATA00 0x400E80ECU, 0x4U, 0x400E857CU, 0x0U, 0x400E8330U
#define IOMUXC_GPIO_EMC_B2_13_GPIO_MUX2_IO23 0x400E80ECU, 0x5U, 0, 0, 0x400E8330U
#define IOMUXC_GPIO_EMC_B2_13_XBAR1_INOUT33 0x400E80ECU, 0x6U, 0x400E870CU, 0x0U, 0x400E8330U
#define IOMUXC_GPIO_EMC_B2_13_EMVSIM1_RST 0x400E80ECU, 0x8U, 0, 0, 0x400E8330U
#define IOMUXC_GPIO_EMC_B2_13_TMR2_TIMER0 0x400E80ECU, 0x9U, 0x400E8648U, 0x1U, 0x400E8330U

#define IOMUXC_GPIO_EMC_B2_14_SEMC_DATA29 0x400E80F0U, 0x0U, 0, 0, 0x400E8334U
#define IOMUXC_GPIO_EMC_B2_14_ENET_1G_TX_CLK_IO 0x400E80F0U, 0x2U, 0x400E84E8U, 0x0U, 0x400E8334U
#define IOMUXC_GPIO_EMC_B2_14_SAI3_TX_DATA 0x400E80F0U, 0x3U, 0, 0, 0x400E8334U
#define IOMUXC_GPIO_EMC_B2_14_FLEXSPI2_A_DATA01 0x400E80F0U, 0x4U, 0x400E8580U, 0x0U, 0x400E8334U
#define IOMUXC_GPIO_EMC_B2_14_GPIO_MUX2_IO24 0x400E80F0U, 0x5U, 0, 0, 0x400E8334U
#define IOMUXC_GPIO_EMC_B2_14_XBAR1_INOUT34 0x400E80F0U, 0x6U, 0x400E8710U, 0x0U, 0x400E8334U
#define IOMUXC_GPIO_EMC_B2_14_SFA_ipp_do_atx_clk_under_test 0x400E80F0U, 0x7U, 0, 0, 0x400E8334U
#define IOMUXC_GPIO_EMC_B2_14_EMVSIM1_SVEN 0x400E80F0U, 0x8U, 0, 0, 0x400E8334U
#define IOMUXC_GPIO_EMC_B2_14_TMR2_TIMER1 0x400E80F0U, 0x9U, 0x400E864CU, 0x1U, 0x400E8334U
#define IOMUXC_GPIO_EMC_B2_14_GPIO8_IO24 0x400E80F0U, 0xAU, 0, 0, 0x400E8334U

#define IOMUXC_GPIO_EMC_B2_15_SEMC_DATA30 0x400E80F4U, 0x0U, 0, 0, 0x400E8338U
#define IOMUXC_GPIO_EMC_B2_15_ENET_1G_RX_DATA00 0x400E80F4U, 0x2U, 0x400E84D0U, 0x0U, 0x400E8338U
#define IOMUXC_GPIO_EMC_B2_15_SAI3_TX_BCLK 0x400E80F4U, 0x3U, 0, 0, 0x400E8338U
#define IOMUXC_GPIO_EMC_B2_15_FLEXSPI2_A_DATA02 0x400E80F4U, 0x4U, 0x400E8584U, 0x0U, 0x400E8338U
#define IOMUXC_GPIO_EMC_B2_15_GPIO_MUX2_IO25 0x400E80F4U, 0x5U, 0, 0, 0x400E8338U
#define IOMUXC_GPIO_EMC_B2_15_XBAR1_INOUT35 0x400E80F4U, 0x6U, 0x400E8714U, 0x0U, 0x400E8338U
#define IOMUXC_GPIO_EMC_B2_15_EMVSIM1_PD 0x400E80F4U, 0x8U, 0x400E86A0U, 0x0U, 0x400E8338U
#define IOMUXC_GPIO_EMC_B2_15_TMR2_TIMER2 0x400E80F4U, 0x9U, 0x400E8650U, 0x0U, 0x400E8338U
#define IOMUXC_GPIO_EMC_B2_15_GPIO8_IO25 0x400E80F4U, 0xAU, 0, 0, 0x400E8338U

#define IOMUXC_GPIO_EMC_B2_16_GPIO8_IO26 0x400E80F8U, 0xAU, 0, 0, 0x400E833CU
#define IOMUXC_GPIO_EMC_B2_16_SEMC_DATA31 0x400E80F8U, 0x0U, 0, 0, 0x400E833CU
#define IOMUXC_GPIO_EMC_B2_16_XBAR1_INOUT14 0x400E80F8U, 0x1U, 0, 0, 0x400E833CU
#define IOMUXC_GPIO_EMC_B2_16_ENET_1G_RX_DATA01 0x400E80F8U, 0x2U, 0x400E84D4U, 0x0U, 0x400E833CU
#define IOMUXC_GPIO_EMC_B2_16_SAI3_TX_SYNC 0x400E80F8U, 0x3U, 0, 0, 0x400E833CU
#define IOMUXC_GPIO_EMC_B2_16_FLEXSPI2_A_DATA03 0x400E80F8U, 0x4U, 0x400E8588U, 0x0U, 0x400E833CU
#define IOMUXC_GPIO_EMC_B2_16_GPIO_MUX2_IO26 0x400E80F8U, 0x5U, 0, 0, 0x400E833CU
#define IOMUXC_GPIO_EMC_B2_16_EMVSIM1_POWER_FAIL 0x400E80F8U, 0x8U, 0x400E86A4U, 0x0U, 0x400E833CU
#define IOMUXC_GPIO_EMC_B2_16_TMR2_TIMER3 0x400E80F8U, 0x9U, 0, 0, 0x400E833CU

#define IOMUXC_GPIO_EMC_B2_17_SEMC_DM03 0x400E80FCU, 0x0U, 0, 0, 0x400E8340U
#define IOMUXC_GPIO_EMC_B2_17_XBAR1_INOUT15 0x400E80FCU, 0x1U, 0, 0, 0x400E8340U
#define IOMUXC_GPIO_EMC_B2_17_ENET_1G_RX_EN 0x400E80FCU, 0x2U, 0x400E84E0U, 0x0U, 0x400E8340U
#define IOMUXC_GPIO_EMC_B2_17_SAI3_MCLK 0x400E80FCU, 0x3U, 0, 0, 0x400E8340U
#define IOMUXC_GPIO_EMC_B2_17_FLEXSPI2_A_DATA04 0x400E80FCU, 0x4U, 0, 0, 0x400E8340U
#define IOMUXC_GPIO_EMC_B2_17_GPIO_MUX2_IO27 0x400E80FCU, 0x5U, 0, 0, 0x400E8340U
#define IOMUXC_GPIO_EMC_B2_17_WDOG1_ANY 0x400E80FCU, 0x8U, 0, 0, 0x400E8340U
#define IOMUXC_GPIO_EMC_B2_17_TMR3_TIMER0 0x400E80FCU, 0x9U, 0x400E8654U, 0x1U, 0x400E8340U
#define IOMUXC_GPIO_EMC_B2_17_GPIO8_IO27 0x400E80FCU, 0xAU, 0, 0, 0x400E8340U

#define IOMUXC_GPIO_EMC_B2_18_SEMC_DQS4 0x400E8100U, 0x0U, 0, 0, 0x400E8344U
#define IOMUXC_GPIO_EMC_B2_18_XBAR1_INOUT16 0x400E8100U, 0x1U, 0, 0, 0x400E8344U
#define IOMUXC_GPIO_EMC_B2_18_ENET_1G_RX_ER 0x400E8100U, 0x2U, 0x400E84E4U, 0x0U, 0x400E8344U
#define IOMUXC_GPIO_EMC_B2_18_EWM_OUT_B 0x400E8100U, 0x3U, 0, 0, 0x400E8344U
#define IOMUXC_GPIO_EMC_B2_18_FLEXSPI2_A_DATA05 0x400E8100U, 0x4U, 0, 0, 0x400E8344U
#define IOMUXC_GPIO_EMC_B2_18_GPIO_MUX2_IO28 0x400E8100U, 0x5U, 0, 0, 0x400E8344U
#define IOMUXC_GPIO_EMC_B2_18_FLEXSPI1_A_DQS 0x400E8100U, 0x6U, 0x400E8550U, 0x0U, 0x400E8344U
#define IOMUXC_GPIO_EMC_B2_18_WDOG1_B 0x400E8100U, 0x8U, 0, 0, 0x400E8344U
#define IOMUXC_GPIO_EMC_B2_18_TMR3_TIMER1 0x400E8100U, 0x9U, 0x400E8658U, 0x1U, 0x400E8344U
#define IOMUXC_GPIO_EMC_B2_18_GPIO8_IO28 0x400E8100U, 0xAU, 0, 0, 0x400E8344U

#define IOMUXC_GPIO_EMC_B2_19_GPIO8_IO29 0x400E8104U, 0xAU, 0, 0, 0x400E8348U
#define IOMUXC_GPIO_EMC_B2_19_SEMC_CLKX00 0x400E8104U, 0x0U, 0, 0, 0x400E8348U
#define IOMUXC_GPIO_EMC_B2_19_ENET_MDC 0x400E8104U, 0x1U, 0, 0, 0x400E8348U
#define IOMUXC_GPIO_EMC_B2_19_ENET_1G_MDC 0x400E8104U, 0x2U, 0, 0, 0x400E8348U
#define IOMUXC_GPIO_EMC_B2_19_ENET_1G_REF_CLK 0x400E8104U, 0x3U, 0x400E84C4U, 0x0U, 0x400E8348U
#define IOMUXC_GPIO_EMC_B2_19_FLEXSPI2_A_DATA06 0x400E8104U, 0x4U, 0, 0, 0x400E8348U
#define IOMUXC_GPIO_EMC_B2_19_GPIO_MUX2_IO29 0x400E8104U, 0x5U, 0, 0, 0x400E8348U
#define IOMUXC_GPIO_EMC_B2_19_ENET_QOS_MDC 0x400E8104U, 0x8U, 0, 0, 0x400E8348U
#define IOMUXC_GPIO_EMC_B2_19_TMR3_TIMER2 0x400E8104U, 0x9U, 0x400E865CU, 0x0U, 0x400E8348U

#define IOMUXC_GPIO_EMC_B2_20_GPIO8_IO30 0x400E8108U, 0xAU, 0, 0, 0x400E834CU
#define IOMUXC_GPIO_EMC_B2_20_SEMC_CLKX01 0x400E8108U, 0x0U, 0, 0, 0x400E834CU
#define IOMUXC_GPIO_EMC_B2_20_ENET_MDIO 0x400E8108U, 0x1U, 0x400E84ACU, 0x0U, 0x400E834CU
#define IOMUXC_GPIO_EMC_B2_20_ENET_1G_MDIO 0x400E8108U, 0x2U, 0x400E84C8U, 0x1U, 0x400E834CU
#define IOMUXC_GPIO_EMC_B2_20_ENET_QOS_REF_CLK 0x400E8108U, 0x3U, 0x400E84A0U, 0x0U, 0x400E834CU
#define IOMUXC_GPIO_EMC_B2_20_FLEXSPI2_A_DATA07 0x400E8108U, 0x4U, 0, 0, 0x400E834CU
#define IOMUXC_GPIO_EMC_B2_20_GPIO_MUX2_IO30 0x400E8108U, 0x5U, 0, 0, 0x400E834CU
#define IOMUXC_GPIO_EMC_B2_20_ENET_QOS_MDIO 0x400E8108U, 0x8U, 0x400E84ECU, 0x0U, 0x400E834CU
#define IOMUXC_GPIO_EMC_B2_20_TMR3_TIMER3 0x400E8108U, 0x9U, 0, 0, 0x400E834CU

#define IOMUXC_GPIO_AD_00_GPIO8_IO31 0x400E810CU, 0xAU, 0, 0, 0x400E8350U
#define IOMUXC_GPIO_AD_00_EMVSIM1_IO 0x400E810CU, 0x0U, 0x400E869CU, 0x1U, 0x400E8350U
#define IOMUXC_GPIO_AD_00_FLEXCAN2_TX 0x400E810CU, 0x1U, 0, 0, 0x400E8350U
#define IOMUXC_GPIO_AD_00_ENET_1G_1588_EVENT1_IN 0x400E810CU, 0x2U, 0, 0, 0x400E8350U
#define IOMUXC_GPIO_AD_00_GPT2_CAPTURE1 0x400E810CU, 0x3U, 0, 0, 0x400E8350U
#define IOMUXC_GPIO_AD_00_FLEXPWM1_PWM0_A 0x400E810CU, 0x4U, 0x400E8500U, 0x1U, 0x400E8350U
#define IOMUXC_GPIO_AD_00_GPIO_MUX2_IO31 0x400E810CU, 0x5U, 0, 0, 0x400E8350U
#define IOMUXC_GPIO_AD_00_LPUART7_TXD 0x400E810CU, 0x6U, 0x400E8630U, 0x0U, 0x400E8350U
#define IOMUXC_GPIO_AD_00_FLEXIO2_D00 0x400E810CU, 0x8U, 0, 0, 0x400E8350U
#define IOMUXC_GPIO_AD_00_FLEXSPI2_B_SS1_B 0x400E810CU, 0x9U, 0, 0, 0x400E8350U

#define IOMUXC_GPIO_AD_01_GPIO9_IO00 0x400E8110U, 0xAU, 0, 0, 0x400E8354U
#define IOMUXC_GPIO_AD_01_EMVSIM1_CLK 0x400E8110U, 0x0U, 0, 0, 0x400E8354U
#define IOMUXC_GPIO_AD_01_FLEXCAN2_RX 0x400E8110U, 0x1U, 0x400E849CU, 0x0U, 0x400E8354U
#define IOMUXC_GPIO_AD_01_ENET_1G_1588_EVENT1_OUT 0x400E8110U, 0x2U, 0, 0, 0x400E8354U
#define IOMUXC_GPIO_AD_01_GPT2_CAPTURE2 0x400E8110U, 0x3U, 0, 0, 0x400E8354U
#define IOMUXC_GPIO_AD_01_FLEXPWM1_PWM0_B 0x400E8110U, 0x4U, 0x400E850CU, 0x1U, 0x400E8354U
#define IOMUXC_GPIO_AD_01_GPIO_MUX3_IO00 0x400E8110U, 0x5U, 0, 0, 0x400E8354U
#define IOMUXC_GPIO_AD_01_LPUART7_RXD 0x400E8110U, 0x6U, 0x400E862CU, 0x0U, 0x400E8354U
#define IOMUXC_GPIO_AD_01_FLEXIO2_D01 0x400E8110U, 0x8U, 0, 0, 0x400E8354U
#define IOMUXC_GPIO_AD_01_FLEXSPI2_A_SS1_B 0x400E8110U, 0x9U, 0, 0, 0x400E8354U

#define IOMUXC_GPIO_AD_02_GPIO9_IO01 0x400E8114U, 0xAU, 0, 0, 0x400E8358U
#define IOMUXC_GPIO_AD_02_EMVSIM1_RST 0x400E8114U, 0x0U, 0, 0, 0x400E8358U
#define IOMUXC_GPIO_AD_02_LPUART7_CTS_B 0x400E8114U, 0x1U, 0, 0, 0x400E8358U
#define IOMUXC_GPIO_AD_02_ENET_1G_1588_EVENT2_IN 0x400E8114U, 0x2U, 0, 0, 0x400E8358U
#define IOMUXC_GPIO_AD_02_GPT2_COMPARE1 0x400E8114U, 0x3U, 0, 0, 0x400E8358U
#define IOMUXC_GPIO_AD_02_FLEXPWM1_PWM1_A 0x400E8114U, 0x4U, 0x400E8504U, 0x1U, 0x400E8358U
#define IOMUXC_GPIO_AD_02_GPIO_MUX3_IO01 0x400E8114U, 0x5U, 0, 0, 0x400E8358U
#define IOMUXC_GPIO_AD_02_LPUART8_TXD 0x400E8114U, 0x6U, 0x400E8638U, 0x0U, 0x400E8358U
#define IOMUXC_GPIO_AD_02_FLEXIO2_D02 0x400E8114U, 0x8U, 0, 0, 0x400E8358U
#define IOMUXC_GPIO_AD_02_VIDEO_MUX_EXT_DCIC1 0x400E8114U, 0x9U, 0, 0, 0x400E8358U

#define IOMUXC_GPIO_AD_03_GPIO9_IO02 0x400E8118U, 0xAU, 0, 0, 0x400E835CU
#define IOMUXC_GPIO_AD_03_EMVSIM1_SVEN 0x400E8118U, 0x0U, 0, 0, 0x400E835CU
#define IOMUXC_GPIO_AD_03_LPUART7_RTS_B 0x400E8118U, 0x1U, 0, 0, 0x400E835CU
#define IOMUXC_GPIO_AD_03_ENET_1G_1588_EVENT2_OUT 0x400E8118U, 0x2U, 0, 0, 0x400E835CU
#define IOMUXC_GPIO_AD_03_GPT2_COMPARE2 0x400E8118U, 0x3U, 0, 0, 0x400E835CU
#define IOMUXC_GPIO_AD_03_FLEXPWM1_PWM1_B 0x400E8118U, 0x4U, 0x400E8510U, 0x1U, 0x400E835CU
#define IOMUXC_GPIO_AD_03_GPIO_MUX3_IO02 0x400E8118U, 0x5U, 0, 0, 0x400E835CU
#define IOMUXC_GPIO_AD_03_LPUART8_RXD 0x400E8118U, 0x6U, 0x400E8634U, 0x0U, 0x400E835CU
#define IOMUXC_GPIO_AD_03_FLEXIO2_D03 0x400E8118U, 0x8U, 0, 0, 0x400E835CU
#define IOMUXC_GPIO_AD_03_VIDEO_MUX_EXT_DCIC2 0x400E8118U, 0x9U, 0, 0, 0x400E835CU

#define IOMUXC_GPIO_AD_04_EMVSIM1_PD 0x400E811CU, 0x0U, 0x400E86A0U, 0x1U, 0x400E8360U
#define IOMUXC_GPIO_AD_04_LPUART8_CTS_B 0x400E811CU, 0x1U, 0, 0, 0x400E8360U
#define IOMUXC_GPIO_AD_04_ENET_1G_1588_EVENT3_IN 0x400E811CU, 0x2U, 0, 0, 0x400E8360U
#define IOMUXC_GPIO_AD_04_GPT2_COMPARE3 0x400E811CU, 0x3U, 0, 0, 0x400E8360U
#define IOMUXC_GPIO_AD_04_FLEXPWM1_PWM2_A 0x400E811CU, 0x4U, 0x400E8508U, 0x1U, 0x400E8360U
#define IOMUXC_GPIO_AD_04_GPIO_MUX3_IO03 0x400E811CU, 0x5U, 0, 0, 0x400E8360U
#define IOMUXC_GPIO_AD_04_WDOG1_B 0x400E811CU, 0x6U, 0, 0, 0x400E8360U
#define IOMUXC_GPIO_AD_04_FLEXIO2_D04 0x400E811CU, 0x8U, 0, 0, 0x400E8360U
#define IOMUXC_GPIO_AD_04_TMR4_TIMER0 0x400E811CU, 0x9U, 0x400E8660U, 0x1U, 0x400E8360U
#define IOMUXC_GPIO_AD_04_GPIO9_IO03 0x400E811CU, 0xAU, 0, 0, 0x400E8360U

#define IOMUXC_GPIO_AD_05_EMVSIM1_POWER_FAIL 0x400E8120U, 0x0U, 0x400E86A4U, 0x1U, 0x400E8364U
#define IOMUXC_GPIO_AD_05_LPUART8_RTS_B 0x400E8120U, 0x1U, 0, 0, 0x400E8364U
#define IOMUXC_GPIO_AD_05_ENET_1G_1588_EVENT3_OUT 0x400E8120U, 0x2U, 0, 0, 0x400E8364U
#define IOMUXC_GPIO_AD_05_GPT2_CLK 0x400E8120U, 0x3U, 0, 0, 0x400E8364U
#define IOMUXC_GPIO_AD_05_FLEXPWM1_PWM2_B 0x400E8120U, 0x4U, 0x400E8514U, 0x1U, 0x400E8364U
#define IOMUXC_GPIO_AD_05_GPIO_MUX3_IO04 0x400E8120U, 0x5U, 0, 0, 0x400E8364U
#define IOMUXC_GPIO_AD_05_WDOG2_B 0x400E8120U, 0x6U, 0, 0, 0x400E8364U
#define IOMUXC_GPIO_AD_05_FLEXIO2_D05 0x400E8120U, 0x8U, 0, 0, 0x400E8364U
#define IOMUXC_GPIO_AD_05_TMR4_TIMER1 0x400E8120U, 0x9U, 0x400E8664U, 0x1U, 0x400E8364U
#define IOMUXC_GPIO_AD_05_GPIO9_IO04 0x400E8120U, 0xAU, 0, 0, 0x400E8364U

#define IOMUXC_GPIO_AD_06_USB_OTG2_OC 0x400E8124U, 0x0U, 0x400E86B8U, 0x0U, 0x400E8368U
#define IOMUXC_GPIO_AD_06_FLEXCAN1_TX 0x400E8124U, 0x1U, 0, 0, 0x400E8368U
#define IOMUXC_GPIO_AD_06_EMVSIM2_IO 0x400E8124U, 0x2U, 0x400E86A8U, 0x0U, 0x400E8368U
#define IOMUXC_GPIO_AD_06_GPT3_CAPTURE1 0x400E8124U, 0x3U, 0x400E8590U, 0x1U, 0x400E8368U
#define IOMUXC_GPIO_AD_06_VIDEO_MUX_CSI_DATA15 0x400E8124U, 0x4U, 0, 0, 0x400E8368U
#define IOMUXC_GPIO_AD_06_GPIO_MUX3_IO05 0x400E8124U, 0x5U, 0, 0, 0x400E8368U
#define IOMUXC_GPIO_AD_06_ENET_1588_EVENT1_IN 0x400E8124U, 0x6U, 0, 0, 0x400E8368U
#define IOMUXC_GPIO_AD_06_FLEXIO2_D06 0x400E8124U, 0x8U, 0, 0, 0x400E8368U
#define IOMUXC_GPIO_AD_06_TMR4_TIMER2 0x400E8124U, 0x9U, 0x400E8668U, 0x0U, 0x400E8368U
#define IOMUXC_GPIO_AD_06_GPIO9_IO05 0x400E8124U, 0xAU, 0, 0, 0x400E8368U
#define IOMUXC_GPIO_AD_06_FLEXPWM1_PWM0_X 0x400E8124U, 0xBU, 0, 0, 0x400E8368U

#define IOMUXC_GPIO_AD_07_USB_OTG2_PWR 0x400E8128U, 0x0U, 0, 0, 0x400E836CU
#define IOMUXC_GPIO_AD_07_FLEXCAN1_RX 0x400E8128U, 0x1U, 0x400E8498U, 0x0U, 0x400E836CU
#define IOMUXC_GPIO_AD_07_EMVSIM2_CLK 0x400E8128U, 0x2U, 0, 0, 0x400E836CU
#define IOMUXC_GPIO_AD_07_GPT3_CAPTURE2 0x400E8128U, 0x3U, 0x400E8594U, 0x1U, 0x400E836CU
#define IOMUXC_GPIO_AD_07_VIDEO_MUX_CSI_DATA14 0x400E8128U, 0x4U, 0, 0, 0x400E836CU
#define IOMUXC_GPIO_AD_07_GPIO_MUX3_IO06 0x400E8128U, 0x5U, 0, 0, 0x400E836CU
#define IOMUXC_GPIO_AD_07_ENET_1588_EVENT1_OUT 0x400E8128U, 0x6U, 0, 0, 0x400E836CU
#define IOMUXC_GPIO_AD_07_FLEXIO2_D07 0x400E8128U, 0x8U, 0, 0, 0x400E836CU
#define IOMUXC_GPIO_AD_07_TMR4_TIMER3 0x400E8128U, 0x9U, 0, 0, 0x400E836CU
#define IOMUXC_GPIO_AD_07_GPIO9_IO06 0x400E8128U, 0xAU, 0, 0, 0x400E836CU
#define IOMUXC_GPIO_AD_07_FLEXPWM1_PWM1_X 0x400E8128U, 0xBU, 0, 0, 0x400E836CU

#define IOMUXC_GPIO_AD_08_USBPHY2_OTG_ID 0x400E812CU, 0x0U, 0x400E86C4U, 0x0U, 0x400E8370U
#define IOMUXC_GPIO_AD_08_LPI2C1_SCL 0x400E812CU, 0x1U, 0x400E85ACU, 0x0U, 0x400E8370U
#define IOMUXC_GPIO_AD_08_EMVSIM2_RST 0x400E812CU, 0x2U, 0, 0, 0x400E8370U
#define IOMUXC_GPIO_AD_08_GPT3_COMPARE1 0x400E812CU, 0x3U, 0, 0, 0x400E8370U
#define IOMUXC_GPIO_AD_08_VIDEO_MUX_CSI_DATA13 0x400E812CU, 0x4U, 0, 0, 0x400E8370U
#define IOMUXC_GPIO_AD_08_GPIO_MUX3_IO07 0x400E812CU, 0x5U, 0, 0, 0x400E8370U
#define IOMUXC_GPIO_AD_08_ENET_1588_EVENT2_IN 0x400E812CU, 0x6U, 0, 0, 0x400E8370U
#define IOMUXC_GPIO_AD_08_FLEXIO2_D08 0x400E812CU, 0x8U, 0, 0, 0x400E8370U
#define IOMUXC_GPIO_AD_08_GPIO9_IO07 0x400E812CU, 0xAU, 0, 0, 0x400E8370U
#define IOMUXC_GPIO_AD_08_FLEXPWM1_PWM2_X 0x400E812CU, 0xBU, 0, 0, 0x400E8370U

#define IOMUXC_GPIO_AD_09_USBPHY1_OTG_ID 0x400E8130U, 0x0U, 0x400E86C0U, 0x0U, 0x400E8374U
#define IOMUXC_GPIO_AD_09_LPI2C1_SDA 0x400E8130U, 0x1U, 0x400E85B0U, 0x0U, 0x400E8374U
#define IOMUXC_GPIO_AD_09_EMVSIM2_SVEN 0x400E8130U, 0x2U, 0, 0, 0x400E8374U
#define IOMUXC_GPIO_AD_09_GPT3_COMPARE2 0x400E8130U, 0x3U, 0, 0, 0x400E8374U
#define IOMUXC_GPIO_AD_09_VIDEO_MUX_CSI_DATA12 0x400E8130U, 0x4U, 0, 0, 0x400E8374U
#define IOMUXC_GPIO_AD_09_GPIO_MUX3_IO08 0x400E8130U, 0x5U, 0, 0, 0x400E8374U
#define IOMUXC_GPIO_AD_09_ENET_1588_EVENT2_OUT 0x400E8130U, 0x6U, 0, 0, 0x400E8374U
#define IOMUXC_GPIO_AD_09_FLEXIO2_D09 0x400E8130U, 0x8U, 0, 0, 0x400E8374U
#define IOMUXC_GPIO_AD_09_GPIO9_IO08 0x400E8130U, 0xAU, 0, 0, 0x400E8374U
#define IOMUXC_GPIO_AD_09_FLEXPWM1_PWM3_X 0x400E8130U, 0xBU, 0, 0, 0x400E8374U

#define IOMUXC_GPIO_AD_10_USB_OTG1_PWR 0x400E8134U, 0x0U, 0, 0, 0x400E8378U
#define IOMUXC_GPIO_AD_10_LPI2C1_SCLS 0x400E8134U, 0x1U, 0, 0, 0x400E8378U
#define IOMUXC_GPIO_AD_10_EMVSIM2_PD 0x400E8134U, 0x2U, 0x400E86ACU, 0x0U, 0x400E8378U
#define IOMUXC_GPIO_AD_10_GPT3_COMPARE3 0x400E8134U, 0x3U, 0, 0, 0x400E8378U
#define IOMUXC_GPIO_AD_10_VIDEO_MUX_CSI_DATA11 0x400E8134U, 0x4U, 0, 0, 0x400E8378U
#define IOMUXC_GPIO_AD_10_GPIO_MUX3_IO09 0x400E8134U, 0x5U, 0, 0, 0x400E8378U
#define IOMUXC_GPIO_AD_10_ENET_1588_EVENT3_IN 0x400E8134U, 0x6U, 0, 0, 0x400E8378U
#define IOMUXC_GPIO_AD_10_FLEXIO2_D10 0x400E8134U, 0x8U, 0, 0, 0x400E8378U
#define IOMUXC_GPIO_AD_10_GPIO9_IO09 0x400E8134U, 0xAU, 0, 0, 0x400E8378U
#define IOMUXC_GPIO_AD_10_FLEXPWM2_PWM0_X 0x400E8134U, 0xBU, 0, 0, 0x400E8378U

#define IOMUXC_GPIO_AD_11_USB_OTG1_OC 0x400E8138U, 0x0U, 0x400E86BCU, 0x0U, 0x400E837CU
#define IOMUXC_GPIO_AD_11_LPI2C1_SDAS 0x400E8138U, 0x1U, 0, 0, 0x400E837CU
#define IOMUXC_GPIO_AD_11_EMVSIM2_POWER_FAIL 0x400E8138U, 0x2U, 0x400E86B0U, 0x0U, 0x400E837CU
#define IOMUXC_GPIO_AD_11_GPT3_CLK 0x400E8138U, 0x3U, 0x400E8598U, 0x1U, 0x400E837CU
#define IOMUXC_GPIO_AD_11_VIDEO_MUX_CSI_DATA10 0x400E8138U, 0x4U, 0, 0, 0x400E837CU
#define IOMUXC_GPIO_AD_11_GPIO_MUX3_IO10 0x400E8138U, 0x5U, 0, 0, 0x400E837CU
#define IOMUXC_GPIO_AD_11_ENET_1588_EVENT3_OUT 0x400E8138U, 0x6U, 0, 0, 0x400E837CU
#define IOMUXC_GPIO_AD_11_FLEXIO2_D11 0x400E8138U, 0x8U, 0, 0, 0x400E837CU
#define IOMUXC_GPIO_AD_11_GPIO9_IO10 0x400E8138U, 0xAU, 0, 0, 0x400E837CU
#define IOMUXC_GPIO_AD_11_FLEXPWM2_PWM1_X 0x400E8138U, 0xBU, 0, 0, 0x400E837CU

#define IOMUXC_GPIO_AD_12_SPDIF_LOCK 0x400E813CU, 0x0U, 0, 0, 0x400E8380U
#define IOMUXC_GPIO_AD_12_LPI2C1_HREQ 0x400E813CU, 0x1U, 0, 0, 0x400E8380U
#define IOMUXC_GPIO_AD_12_GPT1_CAPTURE1 0x400E813CU, 0x2U, 0, 0, 0x400E8380U
#define IOMUXC_GPIO_AD_12_FLEXSPI1_B_DATA03 0x400E813CU, 0x3U, 0x400E8570U, 0x0U, 0x400E8380U
#define IOMUXC_GPIO_AD_12_VIDEO_MUX_CSI_PIXCLK 0x400E813CU, 0x4U, 0, 0, 0x400E8380U
#define IOMUXC_GPIO_AD_12_GPIO_MUX3_IO11 0x400E813CU, 0x5U, 0, 0, 0x400E8380U
#define IOMUXC_GPIO_AD_12_ENET_TX_DATA03 0x400E813CU, 0x6U, 0, 0, 0x400E8380U
#define IOMUXC_GPIO_AD_12_FLEXIO2_D12 0x400E813CU, 0x8U, 0, 0, 0x400E8380U
#define IOMUXC_GPIO_AD_12_EWM_OUT_B 0x400E813CU, 0x9U, 0, 0, 0x400E8380U
#define IOMUXC_GPIO_AD_12_GPIO9_IO11 0x400E813CU, 0xAU, 0, 0, 0x400E8380U
#define IOMUXC_GPIO_AD_12_FLEXPWM2_PWM2_X 0x400E813CU, 0xBU, 0, 0, 0x400E8380U

#define IOMUXC_GPIO_AD_13_SPDIF_SR_CLK 0x400E8140U, 0x0U, 0, 0, 0x400E8384U
#define IOMUXC_GPIO_AD_13_PIT1_TRIGGER0 0x400E8140U, 0x1U, 0, 0, 0x400E8384U
#define IOMUXC_GPIO_AD_13_GPT1_CAPTURE2 0x400E8140U, 0x2U, 0, 0, 0x400E8384U
#define IOMUXC_GPIO_AD_13_FLEXSPI1_B_DATA02 0x400E8140U, 0x3U, 0x400E856CU, 0x0U, 0x400E8384U
#define IOMUXC_GPIO_AD_13_VIDEO_MUX_CSI_MCLK 0x400E8140U, 0x4U, 0, 0, 0x400E8384U
#define IOMUXC_GPIO_AD_13_GPIO_MUX3_IO12 0x400E8140U, 0x5U, 0, 0, 0x400E8384U
#define IOMUXC_GPIO_AD_13_ENET_TX_DATA02 0x400E8140U, 0x6U, 0, 0, 0x400E8384U
#define IOMUXC_GPIO_AD_13_FLEXIO2_D13 0x400E8140U, 0x8U, 0, 0, 0x400E8384U
#define IOMUXC_GPIO_AD_13_REF_CLK_32K 0x400E8140U, 0x9U, 0, 0, 0x400E8384U
#define IOMUXC_GPIO_AD_13_GPIO9_IO12 0x400E8140U, 0xAU, 0, 0, 0x400E8384U
#define IOMUXC_GPIO_AD_13_FLEXPWM2_PWM3_X 0x400E8140U, 0xBU, 0, 0, 0x400E8384U

#define IOMUXC_GPIO_AD_14_SPDIF_EXT_CLK 0x400E8144U, 0x0U, 0, 0, 0x400E8388U
#define IOMUXC_GPIO_AD_14_REF_CLK_24M 0x400E8144U, 0x1U, 0, 0, 0x400E8388U
#define IOMUXC_GPIO_AD_14_GPT1_COMPARE1 0x400E8144U, 0x2U, 0, 0, 0x400E8388U
#define IOMUXC_GPIO_AD_14_FLEXSPI1_B_DATA01 0x400E8144U, 0x3U, 0x400E8568U, 0x0U, 0x400E8388U
#define IOMUXC_GPIO_AD_14_VIDEO_MUX_CSI_VSYNC 0x400E8144U, 0x4U, 0, 0, 0x400E8388U
#define IOMUXC_GPIO_AD_14_GPIO_MUX3_IO13 0x400E8144U, 0x5U, 0, 0, 0x400E8388U
#define IOMUXC_GPIO_AD_14_ENET_RX_CLK 0x400E8144U, 0x6U, 0, 0, 0x400E8388U
#define IOMUXC_GPIO_AD_14_FLEXIO2_D14 0x400E8144U, 0x8U, 0, 0, 0x400E8388U
#define IOMUXC_GPIO_AD_14_CCM_ENET_REF_CLK_25M 0x400E8144U, 0x9U, 0, 0, 0x400E8388U
#define IOMUXC_GPIO_AD_14_GPIO9_IO13 0x400E8144U, 0xAU, 0, 0, 0x400E8388U
#define IOMUXC_GPIO_AD_14_FLEXPWM3_PWM0_X 0x400E8144U, 0xBU, 0, 0, 0x400E8388U

#define IOMUXC_GPIO_AD_15_GPIO9_IO14 0x400E8148U, 0xAU, 0, 0, 0x400E838CU
#define IOMUXC_GPIO_AD_15_FLEXPWM3_PWM1_X 0x400E8148U, 0xBU, 0, 0, 0x400E838CU
#define IOMUXC_GPIO_AD_15_SPDIF_IN 0x400E8148U, 0x0U, 0x400E86B4U, 0x1U, 0x400E838CU
#define IOMUXC_GPIO_AD_15_LPUART10_TXD 0x400E8148U, 0x1U, 0x400E8628U, 0x0U, 0x400E838CU
#define IOMUXC_GPIO_AD_15_GPT1_COMPARE2 0x400E8148U, 0x2U, 0, 0, 0x400E838CU
#define IOMUXC_GPIO_AD_15_FLEXSPI1_B_DATA00 0x400E8148U, 0x3U, 0x400E8564U, 0x0U, 0x400E838CU
#define IOMUXC_GPIO_AD_15_VIDEO_MUX_CSI_HSYNC 0x400E8148U, 0x4U, 0, 0, 0x400E838CU
#define IOMUXC_GPIO_AD_15_GPIO_MUX3_IO14 0x400E8148U, 0x5U, 0, 0, 0x400E838CU
#define IOMUXC_GPIO_AD_15_ENET_TX_ER 0x400E8148U, 0x6U, 0, 0, 0x400E838CU
#define IOMUXC_GPIO_AD_15_FLEXIO2_D15 0x400E8148U, 0x8U, 0, 0, 0x400E838CU

#define IOMUXC_GPIO_AD_16_SPDIF_OUT 0x400E814CU, 0x0U, 0, 0, 0x400E8390U
#define IOMUXC_GPIO_AD_16_LPUART10_RXD 0x400E814CU, 0x1U, 0x400E8624U, 0x0U, 0x400E8390U
#define IOMUXC_GPIO_AD_16_GPT1_COMPARE3 0x400E814CU, 0x2U, 0, 0, 0x400E8390U
#define IOMUXC_GPIO_AD_16_FLEXSPI1_B_SCLK 0x400E814CU, 0x3U, 0x400E8578U, 0x0U, 0x400E8390U
#define IOMUXC_GPIO_AD_16_VIDEO_MUX_CSI_DATA09 0x400E814CU, 0x4U, 0, 0, 0x400E8390U
#define IOMUXC_GPIO_AD_16_GPIO_MUX3_IO15 0x400E814CU, 0x5U, 0, 0, 0x400E8390U
#define IOMUXC_GPIO_AD_16_ENET_RX_DATA03 0x400E814CU, 0x6U, 0, 0, 0x400E8390U
#define IOMUXC_GPIO_AD_16_FLEXIO2_D16 0x400E814CU, 0x8U, 0, 0, 0x400E8390U
#define IOMUXC_GPIO_AD_16_ENET_1G_MDC 0x400E814CU, 0x9U, 0, 0, 0x400E8390U
#define IOMUXC_GPIO_AD_16_GPIO9_IO15 0x400E814CU, 0xAU, 0, 0, 0x400E8390U
#define IOMUXC_GPIO_AD_16_FLEXPWM3_PWM2_X 0x400E814CU, 0xBU, 0, 0, 0x400E8390U

#define IOMUXC_GPIO_AD_17_SAI1_MCLK 0x400E8150U, 0x0U, 0x400E866CU, 0x0U, 0x400E8394U
#define IOMUXC_GPIO_AD_17_ACMP1_OUT 0x400E8150U, 0x1U, 0, 0, 0x400E8394U
#define IOMUXC_GPIO_AD_17_GPT1_CLK 0x400E8150U, 0x2U, 0, 0, 0x400E8394U
#define IOMUXC_GPIO_AD_17_FLEXSPI1_A_DQS 0x400E8150U, 0x3U, 0x400E8550U, 0x1U, 0x400E8394U
#define IOMUXC_GPIO_AD_17_VIDEO_MUX_CSI_DATA08 0x400E8150U, 0x4U, 0, 0, 0x400E8394U
#define IOMUXC_GPIO_AD_17_GPIO_MUX3_IO16 0x400E8150U, 0x5U, 0, 0, 0x400E8394U
#define IOMUXC_GPIO_AD_17_ENET_RX_DATA02 0x400E8150U, 0x6U, 0, 0, 0x400E8394U
#define IOMUXC_GPIO_AD_17_FLEXIO2_D17 0x400E8150U, 0x8U, 0, 0, 0x400E8394U
#define IOMUXC_GPIO_AD_17_ENET_1G_MDIO 0x400E8150U, 0x9U, 0x400E84C8U, 0x2U, 0x400E8394U
#define IOMUXC_GPIO_AD_17_GPIO9_IO16 0x400E8150U, 0xAU, 0, 0, 0x400E8394U
#define IOMUXC_GPIO_AD_17_FLEXPWM3_PWM3_X 0x400E8150U, 0xBU, 0, 0, 0x400E8394U

#define IOMUXC_GPIO_AD_18_GPIO9_IO17 0x400E8154U, 0xAU, 0, 0, 0x400E8398U
#define IOMUXC_GPIO_AD_18_FLEXPWM4_PWM0_X 0x400E8154U, 0xBU, 0, 0, 0x400E8398U
#define IOMUXC_GPIO_AD_18_SAI1_RX_SYNC 0x400E8154U, 0x0U, 0x400E8678U, 0x0U, 0x400E8398U
#define IOMUXC_GPIO_AD_18_ACMP2_OUT 0x400E8154U, 0x1U, 0, 0, 0x400E8398U
#define IOMUXC_GPIO_AD_18_LPSPI1_PCS1 0x400E8154U, 0x2U, 0, 0, 0x400E8398U
#define IOMUXC_GPIO_AD_18_FLEXSPI1_A_SS0_B 0x400E8154U, 0x3U, 0, 0, 0x400E8398U
#define IOMUXC_GPIO_AD_18_VIDEO_MUX_CSI_DATA07 0x400E8154U, 0x4U, 0, 0, 0x400E8398U
#define IOMUXC_GPIO_AD_18_GPIO_MUX3_IO17 0x400E8154U, 0x5U, 0, 0, 0x400E8398U
#define IOMUXC_GPIO_AD_18_ENET_CRS 0x400E8154U, 0x6U, 0, 0, 0x400E8398U
#define IOMUXC_GPIO_AD_18_FLEXIO2_D18 0x400E8154U, 0x8U, 0, 0, 0x400E8398U
#define IOMUXC_GPIO_AD_18_LPI2C2_SCL 0x400E8154U, 0x9U, 0x400E85B4U, 0x1U, 0x400E8398U

#define IOMUXC_GPIO_AD_19_SAI1_RX_BCLK 0x400E8158U, 0x0U, 0x400E8670U, 0x0U, 0x400E839CU
#define IOMUXC_GPIO_AD_19_ACMP3_OUT 0x400E8158U, 0x1U, 0, 0, 0x400E839CU
#define IOMUXC_GPIO_AD_19_LPSPI1_PCS2 0x400E8158U, 0x2U, 0, 0, 0x400E839CU
#define IOMUXC_GPIO_AD_19_FLEXSPI1_A_SCLK 0x400E8158U, 0x3U, 0x400E8574U, 0x0U, 0x400E839CU
#define IOMUXC_GPIO_AD_19_VIDEO_MUX_CSI_DATA06 0x400E8158U, 0x4U, 0, 0, 0x400E839CU
#define IOMUXC_GPIO_AD_19_GPIO_MUX3_IO18 0x400E8158U, 0x5U, 0, 0, 0x400E839CU
#define IOMUXC_GPIO_AD_19_ENET_COL 0x400E8158U, 0x6U, 0, 0, 0x400E839CU
#define IOMUXC_GPIO_AD_19_FLEXIO2_D19 0x400E8158U, 0x8U, 0, 0, 0x400E839CU
#define IOMUXC_GPIO_AD_19_LPI2C2_SDA 0x400E8158U, 0x9U, 0x400E85B8U, 0x1U, 0x400E839CU
#define IOMUXC_GPIO_AD_19_GPIO9_IO18 0x400E8158U, 0xAU, 0, 0, 0x400E839CU
#define IOMUXC_GPIO_AD_19_FLEXPWM4_PWM1_X 0x400E8158U, 0xBU, 0, 0, 0x400E839CU

#define IOMUXC_GPIO_AD_20_SAI1_RX_DATA00 0x400E815CU, 0x0U, 0x400E8674U, 0x0U, 0x400E83A0U
#define IOMUXC_GPIO_AD_20_ACMP4_OUT 0x400E815CU, 0x1U, 0, 0, 0x400E83A0U
#define IOMUXC_GPIO_AD_20_LPSPI1_PCS3 0x400E815CU, 0x2U, 0, 0, 0x400E83A0U
#define IOMUXC_GPIO_AD_20_FLEXSPI1_A_DATA00 0x400E815CU, 0x3U, 0x400E8554U, 0x0U, 0x400E83A0U
#define IOMUXC_GPIO_AD_20_VIDEO_MUX_CSI_DATA05 0x400E815CU, 0x4U, 0, 0, 0x400E83A0U
#define IOMUXC_GPIO_AD_20_GPIO_MUX3_IO19 0x400E815CU, 0x5U, 0, 0, 0x400E83A0U
#define IOMUXC_GPIO_AD_20_KPP_ROW07 0x400E815CU, 0x6U, 0x400E85A8U, 0x0U, 0x400E83A0U
#define IOMUXC_GPIO_AD_20_FLEXIO2_D20 0x400E815CU, 0x8U, 0, 0, 0x400E83A0U
#define IOMUXC_GPIO_AD_20_ENET_QOS_1588_EVENT2_OUT 0x400E815CU, 0x9U, 0, 0, 0x400E83A0U
#define IOMUXC_GPIO_AD_20_GPIO9_IO19 0x400E815CU, 0xAU, 0, 0, 0x400E83A0U
#define IOMUXC_GPIO_AD_20_FLEXPWM4_PWM2_X 0x400E815CU, 0xBU, 0, 0, 0x400E83A0U

#define IOMUXC_GPIO_AD_21_SAI1_TX_DATA00 0x400E8160U, 0x0U, 0, 0, 0x400E83A4U
#define IOMUXC_GPIO_AD_21_LPSPI2_PCS1 0x400E8160U, 0x2U, 0x400E85E0U, 0x0U, 0x400E83A4U
#define IOMUXC_GPIO_AD_21_FLEXSPI1_A_DATA01 0x400E8160U, 0x3U, 0x400E8558U, 0x0U, 0x400E83A4U
#define IOMUXC_GPIO_AD_21_VIDEO_MUX_CSI_DATA04 0x400E8160U, 0x4U, 0, 0, 0x400E83A4U
#define IOMUXC_GPIO_AD_21_GPIO_MUX3_IO20 0x400E8160U, 0x5U, 0, 0, 0x400E83A4U
#define IOMUXC_GPIO_AD_21_KPP_COL07 0x400E8160U, 0x6U, 0x400E85A0U, 0x0U, 0x400E83A4U
#define IOMUXC_GPIO_AD_21_FLEXIO2_D21 0x400E8160U, 0x8U, 0, 0, 0x400E83A4U
#define IOMUXC_GPIO_AD_21_ENET_QOS_1588_EVENT2_IN 0x400E8160U, 0x9U, 0, 0, 0x400E83A4U
#define IOMUXC_GPIO_AD_21_GPIO9_IO20 0x400E8160U, 0xAU, 0, 0, 0x400E83A4U
#define IOMUXC_GPIO_AD_21_FLEXPWM4_PWM3_X 0x400E8160U, 0xBU, 0, 0, 0x400E83A4U

#define IOMUXC_GPIO_AD_22_GPIO9_IO21 0x400E8164U, 0xAU, 0, 0, 0x400E83A8U
#define IOMUXC_GPIO_AD_22_SAI1_TX_BCLK 0x400E8164U, 0x0U, 0x400E867CU, 0x0U, 0x400E83A8U
#define IOMUXC_GPIO_AD_22_LPSPI2_PCS2 0x400E8164U, 0x2U, 0, 0, 0x400E83A8U
#define IOMUXC_GPIO_AD_22_FLEXSPI1_A_DATA02 0x400E8164U, 0x3U, 0x400E855CU, 0x0U, 0x400E83A8U
#define IOMUXC_GPIO_AD_22_VIDEO_MUX_CSI_DATA03 0x400E8164U, 0x4U, 0, 0, 0x400E83A8U
#define IOMUXC_GPIO_AD_22_GPIO_MUX3_IO21 0x400E8164U, 0x5U, 0, 0, 0x400E83A8U
#define IOMUXC_GPIO_AD_22_KPP_ROW06 0x400E8164U, 0x6U, 0x400E85A4U, 0x0U, 0x400E83A8U
#define IOMUXC_GPIO_AD_22_FLEXIO2_D22 0x400E8164U, 0x8U, 0, 0, 0x400E83A8U
#define IOMUXC_GPIO_AD_22_ENET_QOS_1588_EVENT3_OUT 0x400E8164U, 0x9U, 0, 0, 0x400E83A8U

#define IOMUXC_GPIO_AD_23_SAI1_TX_SYNC 0x400E8168U, 0x0U, 0x400E8680U, 0x0U, 0x400E83ACU
#define IOMUXC_GPIO_AD_23_LPSPI2_PCS3 0x400E8168U, 0x2U, 0, 0, 0x400E83ACU
#define IOMUXC_GPIO_AD_23_FLEXSPI1_A_DATA03 0x400E8168U, 0x3U, 0x400E8560U, 0x0U, 0x400E83ACU
#define IOMUXC_GPIO_AD_23_VIDEO_MUX_CSI_DATA02 0x400E8168U, 0x4U, 0, 0, 0x400E83ACU
#define IOMUXC_GPIO_AD_23_GPIO_MUX3_IO22 0x400E8168U, 0x5U, 0, 0, 0x400E83ACU
#define IOMUXC_GPIO_AD_23_KPP_COL06 0x400E8168U, 0x6U, 0x400E859CU, 0x0U, 0x400E83ACU
#define IOMUXC_GPIO_AD_23_FLEXIO2_D23 0x400E8168U, 0x8U, 0, 0, 0x400E83ACU
#define IOMUXC_GPIO_AD_23_ENET_QOS_1588_EVENT3_IN 0x400E8168U, 0x9U, 0, 0, 0x400E83ACU
#define IOMUXC_GPIO_AD_23_GPIO9_IO22 0x400E8168U, 0xAU, 0, 0, 0x400E83ACU

#define IOMUXC_GPIO_AD_24_LPUART1_TXD 0x400E816CU, 0x0U, 0x400E8620U, 0x0U, 0x400E83B0U
#define IOMUXC_GPIO_AD_24_LPSPI2_SCK 0x400E816CU, 0x1U, 0x400E85E4U, 0x0U, 0x400E83B0U
#define IOMUXC_GPIO_AD_24_VIDEO_MUX_CSI_DATA00 0x400E816CU, 0x2U, 0, 0, 0x400E83B0U
#define IOMUXC_GPIO_AD_24_ENET_RX_EN 0x400E816CU, 0x3U, 0x400E84B8U, 0x0U, 0x400E83B0U
#define IOMUXC_GPIO_AD_24_FLEXPWM2_PWM0_A 0x400E816CU, 0x4U, 0x400E8518U, 0x1U, 0x400E83B0U
#define IOMUXC_GPIO_AD_24_GPIO_MUX3_IO23 0x400E816CU, 0x5U, 0, 0, 0x400E83B0U
#define IOMUXC_GPIO_AD_24_KPP_ROW05 0x400E816CU, 0x6U, 0, 0, 0x400E83B0U
#define IOMUXC_GPIO_AD_24_FLEXIO2_D24 0x400E816CU, 0x8U, 0, 0, 0x400E83B0U
#define IOMUXC_GPIO_AD_24_LPI2C4_SCL 0x400E816CU, 0x9U, 0x400E85C4U, 0x0U, 0x400E83B0U
#define IOMUXC_GPIO_AD_24_GPIO9_IO23 0x400E816CU, 0xAU, 0, 0, 0x400E83B0U

#define IOMUXC_GPIO_AD_25_GPIO9_IO24 0x400E8170U, 0xAU, 0, 0, 0x400E83B4U
#define IOMUXC_GPIO_AD_25_LPUART1_RXD 0x400E8170U, 0x0U, 0x400E861CU, 0x0U, 0x400E83B4U
#define IOMUXC_GPIO_AD_25_LPSPI2_PCS0 0x400E8170U, 0x1U, 0x400E85DCU, 0x0U, 0x400E83B4U
#define IOMUXC_GPIO_AD_25_VIDEO_MUX_CSI_DATA01 0x400E8170U, 0x2U, 0, 0, 0x400E83B4U
#define IOMUXC_GPIO_AD_25_ENET_RX_ER 0x400E8170U, 0x3U, 0x400E84BCU, 0x0U, 0x400E83B4U
#define IOMUXC_GPIO_AD_25_FLEXPWM2_PWM0_B 0x400E8170U, 0x4U, 0x400E8524U, 0x1U, 0x400E83B4U
#define IOMUXC_GPIO_AD_25_GPIO_MUX3_IO24 0x400E8170U, 0x5U, 0, 0, 0x400E83B4U
#define IOMUXC_GPIO_AD_25_KPP_COL05 0x400E8170U, 0x6U, 0, 0, 0x400E83B4U
#define IOMUXC_GPIO_AD_25_FLEXIO2_D25 0x400E8170U, 0x8U, 0, 0, 0x400E83B4U
#define IOMUXC_GPIO_AD_25_LPI2C4_SDA 0x400E8170U, 0x9U, 0x400E85C8U, 0x0U, 0x400E83B4U

#define IOMUXC_GPIO_AD_26_LPUART1_CTS_B 0x400E8174U, 0x0U, 0, 0, 0x400E83B8U
#define IOMUXC_GPIO_AD_26_LPSPI2_SOUT 0x400E8174U, 0x1U, 0x400E85ECU, 0x0U, 0x400E83B8U
#define IOMUXC_GPIO_AD_26_SEMC_CSX01 0x400E8174U, 0x2U, 0, 0, 0x400E83B8U
#define IOMUXC_GPIO_AD_26_ENET_RX_DATA00 0x400E8174U, 0x3U, 0x400E84B0U, 0x0U, 0x400E83B8U
#define IOMUXC_GPIO_AD_26_FLEXPWM2_PWM1_A 0x400E8174U, 0x4U, 0x400E851CU, 0x1U, 0x400E83B8U
#define IOMUXC_GPIO_AD_26_GPIO_MUX3_IO25 0x400E8174U, 0x5U, 0, 0, 0x400E83B8U
#define IOMUXC_GPIO_AD_26_KPP_ROW04 0x400E8174U, 0x6U, 0, 0, 0x400E83B8U
#define IOMUXC_GPIO_AD_26_FLEXIO2_D26 0x400E8174U, 0x8U, 0, 0, 0x400E83B8U
#define IOMUXC_GPIO_AD_26_ENET_QOS_MDC 0x400E8174U, 0x9U, 0, 0, 0x400E83B8U
#define IOMUXC_GPIO_AD_26_GPIO9_IO25 0x400E8174U, 0xAU, 0, 0, 0x400E83B8U
#define IOMUXC_GPIO_AD_26_USDHC2_CD_B 0x400E8174U, 0xBU, 0x400E86D0U, 0x1U, 0x400E83B8U

#define IOMUXC_GPIO_AD_27_LPUART1_RTS_B 0x400E8178U, 0x0U, 0, 0, 0x400E83BCU
#define IOMUXC_GPIO_AD_27_LPSPI2_SIN 0x400E8178U, 0x1U, 0x400E85E8U, 0x0U, 0x400E83BCU
#define IOMUXC_GPIO_AD_27_SEMC_CSX02 0x400E8178U, 0x2U, 0, 0, 0x400E83BCU
#define IOMUXC_GPIO_AD_27_ENET_RX_DATA01 0x400E8178U, 0x3U, 0x400E84B4U, 0x0U, 0x400E83BCU
#define IOMUXC_GPIO_AD_27_FLEXPWM2_PWM1_B 0x400E8178U, 0x4U, 0x400E8528U, 0x1U, 0x400E83BCU
#define IOMUXC_GPIO_AD_27_GPIO_MUX3_IO26 0x400E8178U, 0x5U, 0, 0, 0x400E83BCU
#define IOMUXC_GPIO_AD_27_KPP_COL04 0x400E8178U, 0x6U, 0, 0, 0x400E83BCU
#define IOMUXC_GPIO_AD_27_FLEXIO2_D27 0x400E8178U, 0x8U, 0, 0, 0x400E83BCU
#define IOMUXC_GPIO_AD_27_ENET_QOS_MDIO 0x400E8178U, 0x9U, 0x400E84ECU, 0x1U, 0x400E83BCU
#define IOMUXC_GPIO_AD_27_GPIO9_IO26 0x400E8178U, 0xAU, 0, 0, 0x400E83BCU
#define IOMUXC_GPIO_AD_27_USDHC2_WP 0x400E8178U, 0xBU, 0x400E86D4U, 0x1U, 0x400E83BCU

#define IOMUXC_GPIO_AD_28_GPIO9_IO27 0x400E817CU, 0xAU, 0, 0, 0x400E83C0U
#define IOMUXC_GPIO_AD_28_USDHC2_VSELECT 0x400E817CU, 0xBU, 0, 0, 0x400E83C0U
#define IOMUXC_GPIO_AD_28_LPSPI1_SCK 0x400E817CU, 0x0U, 0x400E85D0U, 0x1U, 0x400E83C0U
#define IOMUXC_GPIO_AD_28_LPUART5_TXD 0x400E817CU, 0x1U, 0, 0, 0x400E83C0U
#define IOMUXC_GPIO_AD_28_SEMC_CSX03 0x400E817CU, 0x2U, 0, 0, 0x400E83C0U
#define IOMUXC_GPIO_AD_28_ENET_TX_EN 0x400E817CU, 0x3U, 0, 0, 0x400E83C0U
#define IOMUXC_GPIO_AD_28_FLEXPWM2_PWM2_A 0x400E817CU, 0x4U, 0x400E8520U, 0x1U, 0x400E83C0U
#define IOMUXC_GPIO_AD_28_GPIO_MUX3_IO27 0x400E817CU, 0x5U, 0, 0, 0x400E83C0U
#define IOMUXC_GPIO_AD_28_KPP_ROW03 0x400E817CU, 0x6U, 0, 0, 0x400E83C0U
#define IOMUXC_GPIO_AD_28_FLEXIO2_D28 0x400E817CU, 0x8U, 0, 0, 0x400E83C0U
#define IOMUXC_GPIO_AD_28_VIDEO_MUX_EXT_DCIC1 0x400E817CU, 0x9U, 0, 0, 0x400E83C0U

#define IOMUXC_GPIO_AD_29_LPSPI1_PCS0 0x400E8180U, 0x0U, 0x400E85CCU, 0x1U, 0x400E83C4U
#define IOMUXC_GPIO_AD_29_LPUART5_RXD 0x400E8180U, 0x1U, 0, 0, 0x400E83C4U
#define IOMUXC_GPIO_AD_29_ENET_REF_CLK 0x400E8180U, 0x2U, 0x400E84A8U, 0x0U, 0x400E83C4U
#define IOMUXC_GPIO_AD_29_ENET_TX_CLK 0x400E8180U, 0x3U, 0x400E84C0U, 0x0U, 0x400E83C4U
#define IOMUXC_GPIO_AD_29_FLEXPWM2_PWM2_B 0x400E8180U, 0x4U, 0x400E852CU, 0x1U, 0x400E83C4U
#define IOMUXC_GPIO_AD_29_GPIO_MUX3_IO28 0x400E8180U, 0x5U, 0, 0, 0x400E83C4U
#define IOMUXC_GPIO_AD_29_KPP_COL03 0x400E8180U, 0x6U, 0, 0, 0x400E83C4U
#define IOMUXC_GPIO_AD_29_FLEXIO2_D29 0x400E8180U, 0x8U, 0, 0, 0x400E83C4U
#define IOMUXC_GPIO_AD_29_VIDEO_MUX_EXT_DCIC2 0x400E8180U, 0x9U, 0, 0, 0x400E83C4U
#define IOMUXC_GPIO_AD_29_GPIO9_IO28 0x400E8180U, 0xAU, 0, 0, 0x400E83C4U
#define IOMUXC_GPIO_AD_29_USDHC2_RESET_B 0x400E8180U, 0xBU, 0, 0, 0x400E83C4U

#define IOMUXC_GPIO_AD_30_LPSPI1_SOUT 0x400E8184U, 0x0U, 0x400E85D8U, 0x1U, 0x400E83C8U
#define IOMUXC_GPIO_AD_30_USB_OTG2_OC 0x400E8184U, 0x1U, 0x400E86B8U, 0x1U, 0x400E83C8U
#define IOMUXC_GPIO_AD_30_FLEXCAN2_TX 0x400E8184U, 0x2U, 0, 0, 0x400E83C8U
#define IOMUXC_GPIO_AD_30_ENET_TX_DATA00 0x400E8184U, 0x3U, 0, 0, 0x400E83C8U
#define IOMUXC_GPIO_AD_30_LPUART3_TXD 0x400E8184U, 0x4U, 0, 0, 0x400E83C8U
#define IOMUXC_GPIO_AD_30_GPIO_MUX3_IO29 0x400E8184U, 0x5U, 0, 0, 0x400E83C8U
#define IOMUXC_GPIO_AD_30_KPP_ROW02 0x400E8184U, 0x6U, 0, 0, 0x400E83C8U
#define IOMUXC_GPIO_AD_30_FLEXIO2_D30 0x400E8184U, 0x8U, 0, 0, 0x400E83C8U
#define IOMUXC_GPIO_AD_30_WDOG2_RESET_B_DEB 0x400E8184U, 0x9U, 0, 0, 0x400E83C8U
#define IOMUXC_GPIO_AD_30_GPIO9_IO29 0x400E8184U, 0xAU, 0, 0, 0x400E83C8U

#define IOMUXC_GPIO_AD_31_LPSPI1_SIN 0x400E8188U, 0x0U, 0x400E85D4U, 0x1U, 0x400E83CCU
#define IOMUXC_GPIO_AD_31_USB_OTG2_PWR 0x400E8188U, 0x1U, 0, 0, 0x400E83CCU
#define IOMUXC_GPIO_AD_31_FLEXCAN2_RX 0x400E8188U, 0x2U, 0x400E849CU, 0x1U, 0x400E83CCU
#define IOMUXC_GPIO_AD_31_ENET_TX_DATA01 0x400E8188U, 0x3U, 0, 0, 0x400E83CCU
#define IOMUXC_GPIO_AD_31_LPUART3_RXD 0x400E8188U, 0x4U, 0, 0, 0x400E83CCU
#define IOMUXC_GPIO_AD_31_GPIO_MUX3_IO30 0x400E8188U, 0x5U, 0, 0, 0x400E83CCU
#define IOMUXC_GPIO_AD_31_KPP_COL02 0x400E8188U, 0x6U, 0, 0, 0x400E83CCU
#define IOMUXC_GPIO_AD_31_FLEXIO2_D31 0x400E8188U, 0x8U, 0, 0, 0x400E83CCU
#define IOMUXC_GPIO_AD_31_WDOG1_RESET_B_DEB 0x400E8188U, 0x9U, 0, 0, 0x400E83CCU
#define IOMUXC_GPIO_AD_31_GPIO9_IO30 0x400E8188U, 0xAU, 0, 0, 0x400E83CCU

#define IOMUXC_GPIO_AD_32_GPIO9_IO31 0x400E818CU, 0xAU, 0, 0, 0x400E83D0U
#define IOMUXC_GPIO_AD_32_LPI2C1_SCL 0x400E818CU, 0x0U, 0x400E85ACU, 0x1U, 0x400E83D0U
#define IOMUXC_GPIO_AD_32_USBPHY2_OTG_ID 0x400E818CU, 0x1U, 0x400E86C4U, 0x1U, 0x400E83D0U
#define IOMUXC_GPIO_AD_32_PGMC_PMIC_RDY 0x400E818CU, 0x2U, 0, 0, 0x400E83D0U
#define IOMUXC_GPIO_AD_32_ENET_MDC 0x400E818CU, 0x3U, 0, 0, 0x400E83D0U
#define IOMUXC_GPIO_AD_32_USDHC1_CD_B 0x400E818CU, 0x4U, 0x400E86C8U, 0x0U, 0x400E83D0U
#define IOMUXC_GPIO_AD_32_GPIO_MUX3_IO31 0x400E818CU, 0x5U, 0, 0, 0x400E83D0U
#define IOMUXC_GPIO_AD_32_KPP_ROW01 0x400E818CU, 0x6U, 0, 0, 0x400E83D0U
#define IOMUXC_GPIO_AD_32_LPUART10_TXD 0x400E818CU, 0x8U, 0x400E8628U, 0x1U, 0x400E83D0U
#define IOMUXC_GPIO_AD_32_ENET_1G_MDC 0x400E818CU, 0x9U, 0, 0, 0x400E83D0U

#define IOMUXC_GPIO_AD_33_LPI2C1_SDA 0x400E8190U, 0x0U, 0x400E85B0U, 0x1U, 0x400E83D4U
#define IOMUXC_GPIO_AD_33_USBPHY1_OTG_ID 0x400E8190U, 0x1U, 0x400E86C0U, 0x1U, 0x400E83D4U
#define IOMUXC_GPIO_AD_33_XBAR1_INOUT17 0x400E8190U, 0x2U, 0, 0, 0x400E83D4U
#define IOMUXC_GPIO_AD_33_ENET_MDIO 0x400E8190U, 0x3U, 0x400E84ACU, 0x1U, 0x400E83D4U
#define IOMUXC_GPIO_AD_33_USDHC1_WP 0x400E8190U, 0x4U, 0x400E86CCU, 0x0U, 0x400E83D4U
#define IOMUXC_GPIO_AD_33_GPIO_MUX4_IO00 0x400E8190U, 0x5U, 0, 0, 0x400E83D4U
#define IOMUXC_GPIO_AD_33_KPP_COL01 0x400E8190U, 0x6U, 0, 0, 0x400E83D4U
#define IOMUXC_GPIO_AD_33_LPUART10_RXD 0x400E8190U, 0x8U, 0x400E8624U, 0x1U, 0x400E83D4U
#define IOMUXC_GPIO_AD_33_ENET_1G_MDIO 0x400E8190U, 0x9U, 0x400E84C8U, 0x3U, 0x400E83D4U
#define IOMUXC_GPIO_AD_33_GPIO10_IO00 0x400E8190U, 0xAU, 0, 0, 0x400E83D4U

#define IOMUXC_GPIO_AD_34_ENET_1G_1588_EVENT0_IN 0x400E8194U, 0x0U, 0, 0, 0x400E83D8U
#define IOMUXC_GPIO_AD_34_USB_OTG1_PWR 0x400E8194U, 0x1U, 0, 0, 0x400E83D8U
#define IOMUXC_GPIO_AD_34_XBAR1_INOUT18 0x400E8194U, 0x2U, 0, 0, 0x400E83D8U
#define IOMUXC_GPIO_AD_34_ENET_1588_EVENT0_IN 0x400E8194U, 0x3U, 0, 0, 0x400E83D8U
#define IOMUXC_GPIO_AD_34_USDHC1_VSELECT 0x400E8194U, 0x4U, 0, 0, 0x400E83D8U
#define IOMUXC_GPIO_AD_34_GPIO_MUX4_IO01 0x400E8194U, 0x5U, 0, 0, 0x400E83D8U
#define IOMUXC_GPIO_AD_34_KPP_ROW00 0x400E8194U, 0x6U, 0, 0, 0x400E83D8U
#define IOMUXC_GPIO_AD_34_LPUART10_CTS_B 0x400E8194U, 0x8U, 0, 0, 0x400E83D8U
#define IOMUXC_GPIO_AD_34_WDOG1_ANY 0x400E8194U, 0x9U, 0, 0, 0x400E83D8U
#define IOMUXC_GPIO_AD_34_GPIO10_IO01 0x400E8194U, 0xAU, 0, 0, 0x400E83D8U

#define IOMUXC_GPIO_AD_35_GPIO10_IO02 0x400E8198U, 0xAU, 0, 0, 0x400E83DCU
#define IOMUXC_GPIO_AD_35_ENET_1G_1588_EVENT0_OUT 0x400E8198U, 0x0U, 0, 0, 0x400E83DCU
#define IOMUXC_GPIO_AD_35_USB_OTG1_OC 0x400E8198U, 0x1U, 0x400E86BCU, 0x1U, 0x400E83DCU
#define IOMUXC_GPIO_AD_35_XBAR1_INOUT19 0x400E8198U, 0x2U, 0, 0, 0x400E83DCU
#define IOMUXC_GPIO_AD_35_ENET_1588_EVENT0_OUT 0x400E8198U, 0x3U, 0, 0, 0x400E83DCU
#define IOMUXC_GPIO_AD_35_USDHC1_RESET_B 0x400E8198U, 0x4U, 0, 0, 0x400E83DCU
#define IOMUXC_GPIO_AD_35_GPIO_MUX4_IO02 0x400E8198U, 0x5U, 0, 0, 0x400E83DCU
#define IOMUXC_GPIO_AD_35_KPP_COL00 0x400E8198U, 0x6U, 0, 0, 0x400E83DCU
#define IOMUXC_GPIO_AD_35_LPUART10_RTS_B 0x400E8198U, 0x8U, 0, 0, 0x400E83DCU
#define IOMUXC_GPIO_AD_35_FLEXSPI1_B_SS1_B 0x400E8198U, 0x9U, 0, 0, 0x400E83DCU

#define IOMUXC_GPIO_SD_B1_00_USDHC1_CMD 0x400E819CU, 0x0U, 0, 0, 0x400E83E0U
#define IOMUXC_GPIO_SD_B1_00_XBAR1_INOUT20 0x400E819CU, 0x2U, 0x400E86D8U, 0x1U, 0x400E83E0U
#define IOMUXC_GPIO_SD_B1_00_GPT4_CAPTURE1 0x400E819CU, 0x3U, 0, 0, 0x400E83E0U
#define IOMUXC_GPIO_SD_B1_00_GPIO_MUX4_IO03 0x400E819CU, 0x5U, 0, 0, 0x400E83E0U
#define IOMUXC_GPIO_SD_B1_00_FLEXSPI2_A_SS0_B 0x400E819CU, 0x6U, 0, 0, 0x400E83E0U
#define IOMUXC_GPIO_SD_B1_00_KPP_ROW07 0x400E819CU, 0x8U, 0x400E85A8U, 0x1U, 0x400E83E0U
#define IOMUXC_GPIO_SD_B1_00_GPIO10_IO03 0x400E819CU, 0xAU, 0, 0, 0x400E83E0U

#define IOMUXC_GPIO_SD_B1_01_USDHC1_CLK 0x400E81A0U, 0x0U, 0, 0, 0x400E83E4U
#define IOMUXC_GPIO_SD_B1_01_XBAR1_INOUT21 0x400E81A0U, 0x2U, 0x400E86DCU, 0x1U, 0x400E83E4U
#define IOMUXC_GPIO_SD_B1_01_GPT4_CAPTURE2 0x400E81A0U, 0x3U, 0, 0, 0x400E83E4U
#define IOMUXC_GPIO_SD_B1_01_GPIO_MUX4_IO04 0x400E81A0U, 0x5U, 0, 0, 0x400E83E4U
#define IOMUXC_GPIO_SD_B1_01_FLEXSPI2_A_SCLK 0x400E81A0U, 0x6U, 0x400E858CU, 0x1U, 0x400E83E4U
#define IOMUXC_GPIO_SD_B1_01_KPP_COL07 0x400E81A0U, 0x8U, 0x400E85A0U, 0x1U, 0x400E83E4U
#define IOMUXC_GPIO_SD_B1_01_GPIO10_IO04 0x400E81A0U, 0xAU, 0, 0, 0x400E83E4U

#define IOMUXC_GPIO_SD_B1_02_GPIO10_IO05 0x400E81A4U, 0xAU, 0, 0, 0x400E83E8U
#define IOMUXC_GPIO_SD_B1_02_USDHC1_DATA0 0x400E81A4U, 0x0U, 0, 0, 0x400E83E8U
#define IOMUXC_GPIO_SD_B1_02_XBAR1_INOUT22 0x400E81A4U, 0x2U, 0x400E86E0U, 0x1U, 0x400E83E8U
#define IOMUXC_GPIO_SD_B1_02_GPT4_COMPARE1 0x400E81A4U, 0x3U, 0, 0, 0x400E83E8U
#define IOMUXC_GPIO_SD_B1_02_GPIO_MUX4_IO05 0x400E81A4U, 0x5U, 0, 0, 0x400E83E8U
#define IOMUXC_GPIO_SD_B1_02_FLEXSPI2_A_DATA00 0x400E81A4U, 0x6U, 0x400E857CU, 0x1U, 0x400E83E8U
#define IOMUXC_GPIO_SD_B1_02_KPP_ROW06 0x400E81A4U, 0x8U, 0x400E85A4U, 0x1U, 0x400E83E8U
#define IOMUXC_GPIO_SD_B1_02_FLEXSPI1_A_SS1_B 0x400E81A4U, 0x9U, 0, 0, 0x400E83E8U

#define IOMUXC_GPIO_SD_B1_03_USDHC1_DATA1 0x400E81A8U, 0x0U, 0, 0, 0x400E83ECU
#define IOMUXC_GPIO_SD_B1_03_XBAR1_INOUT23 0x400E81A8U, 0x2U, 0x400E86E4U, 0x1U, 0x400E83ECU
#define IOMUXC_GPIO_SD_B1_03_GPT4_COMPARE2 0x400E81A8U, 0x3U, 0, 0, 0x400E83ECU
#define IOMUXC_GPIO_SD_B1_03_GPIO_MUX4_IO06 0x400E81A8U, 0x5U, 0, 0, 0x400E83ECU
#define IOMUXC_GPIO_SD_B1_03_FLEXSPI2_A_DATA01 0x400E81A8U, 0x6U, 0x400E8580U, 0x1U, 0x400E83ECU
#define IOMUXC_GPIO_SD_B1_03_KPP_COL06 0x400E81A8U, 0x8U, 0x400E859CU, 0x1U, 0x400E83ECU
#define IOMUXC_GPIO_SD_B1_03_FLEXSPI1_B_SS1_B 0x400E81A8U, 0x9U, 0, 0, 0x400E83ECU
#define IOMUXC_GPIO_SD_B1_03_GPIO10_IO06 0x400E81A8U, 0xAU, 0, 0, 0x400E83ECU

#define IOMUXC_GPIO_SD_B1_04_USDHC1_DATA2 0x400E81ACU, 0x0U, 0, 0, 0x400E83F0U
#define IOMUXC_GPIO_SD_B1_04_XBAR1_INOUT24 0x400E81ACU, 0x2U, 0x400E86E8U, 0x1U, 0x400E83F0U
#define IOMUXC_GPIO_SD_B1_04_GPT4_COMPARE3 0x400E81ACU, 0x3U, 0, 0, 0x400E83F0U
#define IOMUXC_GPIO_SD_B1_04_GPIO_MUX4_IO07 0x400E81ACU, 0x5U, 0, 0, 0x400E83F0U
#define IOMUXC_GPIO_SD_B1_04_FLEXSPI2_A_DATA02 0x400E81ACU, 0x6U, 0x400E8584U, 0x1U, 0x400E83F0U
#define IOMUXC_GPIO_SD_B1_04_FLEXSPI1_B_SS0_B 0x400E81ACU, 0x8U, 0, 0, 0x400E83F0U
#define IOMUXC_GPIO_SD_B1_04_ENET_QOS_1588_EVENT2_AUX_IN 0x400E81ACU, 0x9U, 0, 0, 0x400E83F0U
#define IOMUXC_GPIO_SD_B1_04_GPIO10_IO07 0x400E81ACU, 0xAU, 0, 0, 0x400E83F0U

#define IOMUXC_GPIO_SD_B1_05_GPIO10_IO08 0x400E81B0U, 0xAU, 0, 0, 0x400E83F4U
#define IOMUXC_GPIO_SD_B1_05_USDHC1_DATA3 0x400E81B0U, 0x0U, 0, 0, 0x400E83F4U
#define IOMUXC_GPIO_SD_B1_05_XBAR1_INOUT25 0x400E81B0U, 0x2U, 0x400E86ECU, 0x1U, 0x400E83F4U
#define IOMUXC_GPIO_SD_B1_05_GPT4_CLK 0x400E81B0U, 0x3U, 0, 0, 0x400E83F4U
#define IOMUXC_GPIO_SD_B1_05_GPIO_MUX4_IO08 0x400E81B0U, 0x5U, 0, 0, 0x400E83F4U
#define IOMUXC_GPIO_SD_B1_05_FLEXSPI2_A_DATA03 0x400E81B0U, 0x6U, 0x400E8588U, 0x1U, 0x400E83F4U
#define IOMUXC_GPIO_SD_B1_05_FLEXSPI1_B_DQS 0x400E81B0U, 0x8U, 0, 0, 0x400E83F4U
#define IOMUXC_GPIO_SD_B1_05_ENET_QOS_1588_EVENT3_AUX_IN 0x400E81B0U, 0x9U, 0, 0, 0x400E83F4U

#define IOMUXC_GPIO_SD_B2_00_GPIO10_IO09 0x400E81B4U, 0xAU, 0, 0, 0x400E83F8U
#define IOMUXC_GPIO_SD_B2_00_USDHC2_DATA3 0x400E81B4U, 0x0U, 0, 0, 0x400E83F8U
#define IOMUXC_GPIO_SD_B2_00_FLEXSPI1_B_DATA03 0x400E81B4U, 0x1U, 0x400E8570U, 0x1U, 0x400E83F8U
#define IOMUXC_GPIO_SD_B2_00_ENET_1G_RX_EN 0x400E81B4U, 0x2U, 0x400E84E0U, 0x1U, 0x400E83F8U
#define IOMUXC_GPIO_SD_B2_00_LPUART9_TXD 0x400E81B4U, 0x3U, 0, 0, 0x400E83F8U
#define IOMUXC_GPIO_SD_B2_00_LPSPI4_SCK 0x400E81B4U, 0x4U, 0x400E8610U, 0x0U, 0x400E83F8U
#define IOMUXC_GPIO_SD_B2_00_GPIO_MUX4_IO09 0x400E81B4U, 0x5U, 0, 0, 0x400E83F8U

#define IOMUXC_GPIO_SD_B2_01_USDHC2_DATA2 0x400E81B8U, 0x0U, 0, 0, 0x400E83FCU
#define IOMUXC_GPIO_SD_B2_01_FLEXSPI1_B_DATA02 0x400E81B8U, 0x1U, 0x400E856CU, 0x1U, 0x400E83FCU
#define IOMUXC_GPIO_SD_B2_01_ENET_1G_RX_CLK 0x400E81B8U, 0x2U, 0x400E84CCU, 0x1U, 0x400E83FCU
#define IOMUXC_GPIO_SD_B2_01_LPUART9_RXD 0x400E81B8U, 0x3U, 0, 0, 0x400E83FCU
#define IOMUXC_GPIO_SD_B2_01_LPSPI4_PCS0 0x400E81B8U, 0x4U, 0x400E860CU, 0x0U, 0x400E83FCU
#define IOMUXC_GPIO_SD_B2_01_GPIO_MUX4_IO10 0x400E81B8U, 0x5U, 0, 0, 0x400E83FCU
#define IOMUXC_GPIO_SD_B2_01_GPIO10_IO10 0x400E81B8U, 0xAU, 0, 0, 0x400E83FCU

#define IOMUXC_GPIO_SD_B2_02_GPIO10_IO11 0x400E81BCU, 0xAU, 0, 0, 0x400E8400U
#define IOMUXC_GPIO_SD_B2_02_USDHC2_DATA1 0x400E81BCU, 0x0U, 0, 0, 0x400E8400U
#define IOMUXC_GPIO_SD_B2_02_FLEXSPI1_B_DATA01 0x400E81BCU, 0x1U, 0x400E8568U, 0x1U, 0x400E8400U
#define IOMUXC_GPIO_SD_B2_02_ENET_1G_RX_DATA00 0x400E81BCU, 0x2U, 0x400E84D0U, 0x1U, 0x400E8400U
#define IOMUXC_GPIO_SD_B2_02_LPUART9_CTS_B 0x400E81BCU, 0x3U, 0, 0, 0x400E8400U
#define IOMUXC_GPIO_SD_B2_02_LPSPI4_SOUT 0x400E81BCU, 0x4U, 0x400E8618U, 0x0U, 0x400E8400U
#define IOMUXC_GPIO_SD_B2_02_GPIO_MUX4_IO11 0x400E81BCU, 0x5U, 0, 0, 0x400E8400U

#define IOMUXC_GPIO_SD_B2_03_GPIO10_IO12 0x400E81C0U, 0xAU, 0, 0, 0x400E8404U
#define IOMUXC_GPIO_SD_B2_03_USDHC2_DATA0 0x400E81C0U, 0x0U, 0, 0, 0x400E8404U
#define IOMUXC_GPIO_SD_B2_03_FLEXSPI1_B_DATA00 0x400E81C0U, 0x1U, 0x400E8564U, 0x1U, 0x400E8404U
#define IOMUXC_GPIO_SD_B2_03_ENET_1G_RX_DATA01 0x400E81C0U, 0x2U, 0x400E84D4U, 0x1U, 0x400E8404U
#define IOMUXC_GPIO_SD_B2_03_LPUART9_RTS_B 0x400E81C0U, 0x3U, 0, 0, 0x400E8404U
#define IOMUXC_GPIO_SD_B2_03_LPSPI4_SIN 0x400E81C0U, 0x4U, 0x400E8614U, 0x0U, 0x400E8404U
#define IOMUXC_GPIO_SD_B2_03_GPIO_MUX4_IO12 0x400E81C0U, 0x5U, 0, 0, 0x400E8404U

#define IOMUXC_GPIO_SD_B2_04_USDHC2_CLK 0x400E81C4U, 0x0U, 0, 0, 0x400E8408U
#define IOMUXC_GPIO_SD_B2_04_FLEXSPI1_B_SCLK 0x400E81C4U, 0x1U, 0x400E8578U, 0x1U, 0x400E8408U
#define IOMUXC_GPIO_SD_B2_04_ENET_1G_RX_DATA02 0x400E81C4U, 0x2U, 0x400E84D8U, 0x1U, 0x400E8408U
#define IOMUXC_GPIO_SD_B2_04_FLEXSPI1_A_SS1_B 0x400E81C4U, 0x3U, 0, 0, 0x400E8408U
#define IOMUXC_GPIO_SD_B2_04_LPSPI4_PCS1 0x400E81C4U, 0x4U, 0, 0, 0x400E8408U
#define IOMUXC_GPIO_SD_B2_04_GPIO_MUX4_IO13 0x400E81C4U, 0x5U, 0, 0, 0x400E8408U
#define IOMUXC_GPIO_SD_B2_04_GPIO10_IO13 0x400E81C4U, 0xAU, 0, 0, 0x400E8408U

#define IOMUXC_GPIO_SD_B2_05_GPIO10_IO14 0x400E81C8U, 0xAU, 0, 0, 0x400E840CU
#define IOMUXC_GPIO_SD_B2_05_USDHC2_CMD 0x400E81C8U, 0x0U, 0, 0, 0x400E840CU
#define IOMUXC_GPIO_SD_B2_05_FLEXSPI1_A_DQS 0x400E81C8U, 0x1U, 0x400E8550U, 0x2U, 0x400E840CU
#define IOMUXC_GPIO_SD_B2_05_ENET_1G_RX_DATA03 0x400E81C8U, 0x2U, 0x400E84DCU, 0x1U, 0x400E840CU
#define IOMUXC_GPIO_SD_B2_05_FLEXSPI1_B_SS0_B 0x400E81C8U, 0x3U, 0, 0, 0x400E840CU
#define IOMUXC_GPIO_SD_B2_05_LPSPI4_PCS2 0x400E81C8U, 0x4U, 0, 0, 0x400E840CU
#define IOMUXC_GPIO_SD_B2_05_GPIO_MUX4_IO14 0x400E81C8U, 0x5U, 0, 0, 0x400E840CU

#define IOMUXC_GPIO_SD_B2_06_GPIO10_IO15 0x400E81CCU, 0xAU, 0, 0, 0x400E8410U
#define IOMUXC_GPIO_SD_B2_06_USDHC2_RESET_B 0x400E81CCU, 0x0U, 0, 0, 0x400E8410U
#define IOMUXC_GPIO_SD_B2_06_FLEXSPI1_A_SS0_B 0x400E81CCU, 0x1U, 0, 0, 0x400E8410U
#define IOMUXC_GPIO_SD_B2_06_ENET_1G_TX_DATA03 0x400E81CCU, 0x2U, 0, 0, 0x400E8410U
#define IOMUXC_GPIO_SD_B2_06_LPSPI4_PCS3 0x400E81CCU, 0x3U, 0, 0, 0x400E8410U
#define IOMUXC_GPIO_SD_B2_06_GPT6_CAPTURE1 0x400E81CCU, 0x4U, 0, 0, 0x400E8410U
#define IOMUXC_GPIO_SD_B2_06_GPIO_MUX4_IO15 0x400E81CCU, 0x5U, 0, 0, 0x400E8410U

#define IOMUXC_GPIO_SD_B2_07_USDHC2_STROBE 0x400E81D0U, 0x0U, 0, 0, 0x400E8414U
#define IOMUXC_GPIO_SD_B2_07_FLEXSPI1_A_SCLK 0x400E81D0U, 0x1U, 0x400E8574U, 0x1U, 0x400E8414U
#define IOMUXC_GPIO_SD_B2_07_ENET_1G_TX_DATA02 0x400E81D0U, 0x2U, 0, 0, 0x400E8414U
#define IOMUXC_GPIO_SD_B2_07_LPUART3_CTS_B 0x400E81D0U, 0x3U, 0, 0, 0x400E8414U
#define IOMUXC_GPIO_SD_B2_07_GPT6_CAPTURE2 0x400E81D0U, 0x4U, 0, 0, 0x400E8414U
#define IOMUXC_GPIO_SD_B2_07_GPIO_MUX4_IO16 0x400E81D0U, 0x5U, 0, 0, 0x400E8414U
#define IOMUXC_GPIO_SD_B2_07_LPSPI2_SCK 0x400E81D0U, 0x6U, 0x400E85E4U, 0x1U, 0x400E8414U
#define IOMUXC_GPIO_SD_B2_07_ENET_TX_ER 0x400E81D0U, 0x8U, 0, 0, 0x400E8414U
#define IOMUXC_GPIO_SD_B2_07_ENET_QOS_REF_CLK 0x400E81D0U, 0x9U, 0x400E84A0U, 0x1U, 0x400E8414U
#define IOMUXC_GPIO_SD_B2_07_GPIO10_IO16 0x400E81D0U, 0xAU, 0, 0, 0x400E8414U

#define IOMUXC_GPIO_SD_B2_08_GPIO10_IO17 0x400E81D4U, 0xAU, 0, 0, 0x400E8418U
#define IOMUXC_GPIO_SD_B2_08_USDHC2_DATA4 0x400E81D4U, 0x0U, 0, 0, 0x400E8418U
#define IOMUXC_GPIO_SD_B2_08_FLEXSPI1_A_DATA00 0x400E81D4U, 0x1U, 0x400E8554U, 0x1U, 0x400E8418U
#define IOMUXC_GPIO_SD_B2_08_ENET_1G_TX_DATA01 0x400E81D4U, 0x2U, 0, 0, 0x400E8418U
#define IOMUXC_GPIO_SD_B2_08_LPUART3_RTS_B 0x400E81D4U, 0x3U, 0, 0, 0x400E8418U
#define IOMUXC_GPIO_SD_B2_08_GPT6_COMPARE1 0x400E81D4U, 0x4U, 0, 0, 0x400E8418U
#define IOMUXC_GPIO_SD_B2_08_GPIO_MUX4_IO17 0x400E81D4U, 0x5U, 0, 0, 0x400E8418U
#define IOMUXC_GPIO_SD_B2_08_LPSPI2_PCS0 0x400E81D4U, 0x6U, 0x400E85DCU, 0x1U, 0x400E8418U

#define IOMUXC_GPIO_SD_B2_09_GPIO10_IO18 0x400E81D8U, 0xAU, 0, 0, 0x400E841CU
#define IOMUXC_GPIO_SD_B2_09_USDHC2_DATA5 0x400E81D8U, 0x0U, 0, 0, 0x400E841CU
#define IOMUXC_GPIO_SD_B2_09_FLEXSPI1_A_DATA01 0x400E81D8U, 0x1U, 0x400E8558U, 0x1U, 0x400E841CU
#define IOMUXC_GPIO_SD_B2_09_ENET_1G_TX_DATA00 0x400E81D8U, 0x2U, 0, 0, 0x400E841CU
#define IOMUXC_GPIO_SD_B2_09_LPUART5_CTS_B 0x400E81D8U, 0x3U, 0, 0, 0x400E841CU
#define IOMUXC_GPIO_SD_B2_09_GPT6_COMPARE2 0x400E81D8U, 0x4U, 0, 0, 0x400E841CU
#define IOMUXC_GPIO_SD_B2_09_GPIO_MUX4_IO18 0x400E81D8U, 0x5U, 0, 0, 0x400E841CU
#define IOMUXC_GPIO_SD_B2_09_LPSPI2_SOUT 0x400E81D8U, 0x6U, 0x400E85ECU, 0x1U, 0x400E841CU

#define IOMUXC_GPIO_SD_B2_10_GPIO10_IO19 0x400E81DCU, 0xAU, 0, 0, 0x400E8420U
#define IOMUXC_GPIO_SD_B2_10_USDHC2_DATA6 0x400E81DCU, 0x0U, 0, 0, 0x400E8420U
#define IOMUXC_GPIO_SD_B2_10_FLEXSPI1_A_DATA02 0x400E81DCU, 0x1U, 0x400E855CU, 0x1U, 0x400E8420U
#define IOMUXC_GPIO_SD_B2_10_ENET_1G_TX_EN 0x400E81DCU, 0x2U, 0, 0, 0x400E8420U
#define IOMUXC_GPIO_SD_B2_10_LPUART5_RTS_B 0x400E81DCU, 0x3U, 0, 0, 0x400E8420U
#define IOMUXC_GPIO_SD_B2_10_GPT6_COMPARE3 0x400E81DCU, 0x4U, 0, 0, 0x400E8420U
#define IOMUXC_GPIO_SD_B2_10_GPIO_MUX4_IO19 0x400E81DCU, 0x5U, 0, 0, 0x400E8420U
#define IOMUXC_GPIO_SD_B2_10_LPSPI2_SIN 0x400E81DCU, 0x6U, 0x400E85E8U, 0x1U, 0x400E8420U

#define IOMUXC_GPIO_SD_B2_11_USDHC2_DATA7 0x400E81E0U, 0x0U, 0, 0, 0x400E8424U
#define IOMUXC_GPIO_SD_B2_11_FLEXSPI1_A_DATA03 0x400E81E0U, 0x1U, 0x400E8560U, 0x1U, 0x400E8424U
#define IOMUXC_GPIO_SD_B2_11_ENET_1G_TX_CLK_IO 0x400E81E0U, 0x2U, 0x400E84E8U, 0x1U, 0x400E8424U
#define IOMUXC_GPIO_SD_B2_11_ENET_1G_REF_CLK 0x400E81E0U, 0x3U, 0x400E84C4U, 0x1U, 0x400E8424U
#define IOMUXC_GPIO_SD_B2_11_GPT6_CLK 0x400E81E0U, 0x4U, 0, 0, 0x400E8424U
#define IOMUXC_GPIO_SD_B2_11_GPIO_MUX4_IO20 0x400E81E0U, 0x5U, 0, 0, 0x400E8424U
#define IOMUXC_GPIO_SD_B2_11_LPSPI2_PCS1 0x400E81E0U, 0x6U, 0x400E85E0U, 0x1U, 0x400E8424U
#define IOMUXC_GPIO_SD_B2_11_GPIO10_IO20 0x400E81E0U, 0xAU, 0, 0, 0x400E8424U

#define IOMUXC_GPIO_DISP_B1_00_VIDEO_MUX_LCDIF_CLK 0x400E81E4U, 0x0U, 0, 0, 0x400E8428U
#define IOMUXC_GPIO_DISP_B1_00_ENET_1G_RX_EN 0x400E81E4U, 0x1U, 0x400E84E0U, 0x2U, 0x400E8428U
#define IOMUXC_GPIO_DISP_B1_00_TMR1_TIMER0 0x400E81E4U, 0x3U, 0x400E863CU, 0x2U, 0x400E8428U
#define IOMUXC_GPIO_DISP_B1_00_XBAR1_INOUT26 0x400E81E4U, 0x4U, 0x400E86F0U, 0x1U, 0x400E8428U
#define IOMUXC_GPIO_DISP_B1_00_GPIO_MUX4_IO21 0x400E81E4U, 0x5U, 0, 0, 0x400E8428U
#define IOMUXC_GPIO_DISP_B1_00_ENET_QOS_RX_EN 0x400E81E4U, 0x8U, 0x400E84F8U, 0x0U, 0x400E8428U
#define IOMUXC_GPIO_DISP_B1_00_GPIO10_IO21 0x400E81E4U, 0xAU, 0, 0, 0x400E8428U

#define IOMUXC_GPIO_DISP_B1_01_VIDEO_MUX_LCDIF_ENABLE 0x400E81E8U, 0x0U, 0, 0, 0x400E842CU
#define IOMUXC_GPIO_DISP_B1_01_ENET_1G_RX_CLK 0x400E81E8U, 0x1U, 0x400E84CCU, 0x2U, 0x400E842CU
#define IOMUXC_GPIO_DISP_B1_01_ENET_1G_RX_ER 0x400E81E8U, 0x2U, 0x400E84E4U, 0x1U, 0x400E842CU
#define IOMUXC_GPIO_DISP_B1_01_TMR1_TIMER1 0x400E81E8U, 0x3U, 0x400E8640U, 0x2U, 0x400E842CU
#define IOMUXC_GPIO_DISP_B1_01_XBAR1_INOUT27 0x400E81E8U, 0x4U, 0x400E86F4U, 0x1U, 0x400E842CU
#define IOMUXC_GPIO_DISP_B1_01_GPIO_MUX4_IO22 0x400E81E8U, 0x5U, 0, 0, 0x400E842CU
#define IOMUXC_GPIO_DISP_B1_01_ENET_QOS_RX_CLK 0x400E81E8U, 0x8U, 0, 0, 0x400E842CU
#define IOMUXC_GPIO_DISP_B1_01_ENET_QOS_RX_ER 0x400E81E8U, 0x9U, 0x400E84FCU, 0x0U, 0x400E842CU
#define IOMUXC_GPIO_DISP_B1_01_GPIO10_IO22 0x400E81E8U, 0xAU, 0, 0, 0x400E842CU

#define IOMUXC_GPIO_DISP_B1_02_GPIO10_IO23 0x400E81ECU, 0xAU, 0, 0, 0x400E8430U
#define IOMUXC_GPIO_DISP_B1_02_VIDEO_MUX_LCDIF_HSYNC 0x400E81ECU, 0x0U, 0, 0, 0x400E8430U
#define IOMUXC_GPIO_DISP_B1_02_ENET_1G_RX_DATA00 0x400E81ECU, 0x1U, 0x400E84D0U, 0x2U, 0x400E8430U
#define IOMUXC_GPIO_DISP_B1_02_LPI2C3_SCL 0x400E81ECU, 0x2U, 0x400E85BCU, 0x0U, 0x400E8430U
#define IOMUXC_GPIO_DISP_B1_02_TMR1_TIMER2 0x400E81ECU, 0x3U, 0x400E8644U, 0x1U, 0x400E8430U
#define IOMUXC_GPIO_DISP_B1_02_XBAR1_INOUT28 0x400E81ECU, 0x4U, 0x400E86F8U, 0x1U, 0x400E8430U
#define IOMUXC_GPIO_DISP_B1_02_GPIO_MUX4_IO23 0x400E81ECU, 0x5U, 0, 0, 0x400E8430U
#define IOMUXC_GPIO_DISP_B1_02_ENET_QOS_RX_DATA00 0x400E81ECU, 0x8U, 0x400E84F0U, 0x0U, 0x400E8430U
#define IOMUXC_GPIO_DISP_B1_02_LPUART1_TXD 0x400E81ECU, 0x9U, 0x400E8620U, 0x1U, 0x400E8430U

#define IOMUXC_GPIO_DISP_B1_03_VIDEO_MUX_LCDIF_VSYNC 0x400E81F0U, 0x0U, 0, 0, 0x400E8434U
#define IOMUXC_GPIO_DISP_B1_03_ENET_1G_RX_DATA01 0x400E81F0U, 0x1U, 0x400E84D4U, 0x2U, 0x400E8434U
#define IOMUXC_GPIO_DISP_B1_03_LPI2C3_SDA 0x400E81F0U, 0x2U, 0x400E85C0U, 0x0U, 0x400E8434U
#define IOMUXC_GPIO_DISP_B1_03_TMR2_TIMER0 0x400E81F0U, 0x3U, 0x400E8648U, 0x2U, 0x400E8434U
#define IOMUXC_GPIO_DISP_B1_03_XBAR1_INOUT29 0x400E81F0U, 0x4U, 0x400E86FCU, 0x1U, 0x400E8434U
#define IOMUXC_GPIO_DISP_B1_03_GPIO_MUX4_IO24 0x400E81F0U, 0x5U, 0, 0, 0x400E8434U
#define IOMUXC_GPIO_DISP_B1_03_ENET_QOS_RX_DATA01 0x400E81F0U, 0x8U, 0x400E84F4U, 0x0U, 0x400E8434U
#define IOMUXC_GPIO_DISP_B1_03_LPUART1_RXD 0x400E81F0U, 0x9U, 0x400E861CU, 0x1U, 0x400E8434U
#define IOMUXC_GPIO_DISP_B1_03_GPIO10_IO24 0x400E81F0U, 0xAU, 0, 0, 0x400E8434U

#define IOMUXC_GPIO_DISP_B1_04_VIDEO_MUX_LCDIF_DATA00 0x400E81F4U, 0x0U, 0, 0, 0x400E8438U
#define IOMUXC_GPIO_DISP_B1_04_ENET_1G_RX_DATA02 0x400E81F4U, 0x1U, 0x400E84D8U, 0x2U, 0x400E8438U
#define IOMUXC_GPIO_DISP_B1_04_LPUART4_RXD 0x400E81F4U, 0x2U, 0, 0, 0x400E8438U
#define IOMUXC_GPIO_DISP_B1_04_TMR2_TIMER1 0x400E81F4U, 0x3U, 0x400E864CU, 0x2U, 0x400E8438U
#define IOMUXC_GPIO_DISP_B1_04_XBAR1_INOUT30 0x400E81F4U, 0x4U, 0x400E8700U, 0x1U, 0x400E8438U
#define IOMUXC_GPIO_DISP_B1_04_GPIO_MUX4_IO25 0x400E81F4U, 0x5U, 0, 0, 0x400E8438U
#define IOMUXC_GPIO_DISP_B1_04_ENET_QOS_RX_DATA02 0x400E81F4U, 0x8U, 0, 0, 0x400E8438U
#define IOMUXC_GPIO_DISP_B1_04_LPSPI3_SCK 0x400E81F4U, 0x9U, 0x400E8600U, 0x1U, 0x400E8438U
#define IOMUXC_GPIO_DISP_B1_04_GPIO10_IO25 0x400E81F4U, 0xAU, 0, 0, 0x400E8438U

#define IOMUXC_GPIO_DISP_B1_05_GPIO10_IO26 0x400E81F8U, 0xAU, 0, 0, 0x400E843CU
#define IOMUXC_GPIO_DISP_B1_05_VIDEO_MUX_LCDIF_DATA01 0x400E81F8U, 0x0U, 0, 0, 0x400E843CU
#define IOMUXC_GPIO_DISP_B1_05_ENET_1G_RX_DATA03 0x400E81F8U, 0x1U, 0x400E84DCU, 0x2U, 0x400E843CU
#define IOMUXC_GPIO_DISP_B1_05_LPUART4_CTS_B 0x400E81F8U, 0x2U, 0, 0, 0x400E843CU
#define IOMUXC_GPIO_DISP_B1_05_TMR2_TIMER2 0x400E81F8U, 0x3U, 0x400E8650U, 0x1U, 0x400E843CU
#define IOMUXC_GPIO_DISP_B1_05_XBAR1_INOUT31 0x400E81F8U, 0x4U, 0x400E8704U, 0x1U, 0x400E843CU
#define IOMUXC_GPIO_DISP_B1_05_GPIO_MUX4_IO26 0x400E81F8U, 0x5U, 0, 0, 0x400E843CU
#define IOMUXC_GPIO_DISP_B1_05_ENET_QOS_RX_DATA03 0x400E81F8U, 0x8U, 0, 0, 0x400E843CU
#define IOMUXC_GPIO_DISP_B1_05_LPSPI3_SIN 0x400E81F8U, 0x9U, 0x400E8604U, 0x1U, 0x400E843CU

#define IOMUXC_GPIO_DISP_B1_06_VIDEO_MUX_LCDIF_DATA02 0x400E81FCU, 0x0U, 0, 0, 0x400E8440U
#define IOMUXC_GPIO_DISP_B1_06_ENET_1G_TX_DATA03 0x400E81FCU, 0x1U, 0, 0, 0x400E8440U
#define IOMUXC_GPIO_DISP_B1_06_LPUART4_TXD 0x400E81FCU, 0x2U, 0, 0, 0x400E8440U
#define IOMUXC_GPIO_DISP_B1_06_TMR3_TIMER0 0x400E81FCU, 0x3U, 0x400E8654U, 0x2U, 0x400E8440U
#define IOMUXC_GPIO_DISP_B1_06_XBAR1_INOUT32 0x400E81FCU, 0x4U, 0x400E8708U, 0x1U, 0x400E8440U
#define IOMUXC_GPIO_DISP_B1_06_GPIO_MUX4_IO27 0x400E81FCU, 0x5U, 0, 0, 0x400E8440U
#define IOMUXC_GPIO_DISP_B1_06_SRC_BT_CFG00 0x400E81FCU, 0x6U, 0, 0, 0x400E8440U
#define IOMUXC_GPIO_DISP_B1_06_ENET_QOS_TX_DATA03 0x400E81FCU, 0x8U, 0, 0, 0x400E8440U
#define IOMUXC_GPIO_DISP_B1_06_LPSPI3_SOUT 0x400E81FCU, 0x9U, 0x400E8608U, 0x1U, 0x400E8440U
#define IOMUXC_GPIO_DISP_B1_06_GPIO10_IO27 0x400E81FCU, 0xAU, 0, 0, 0x400E8440U

#define IOMUXC_GPIO_DISP_B1_07_VIDEO_MUX_LCDIF_DATA03 0x400E8200U, 0x0U, 0, 0, 0x400E8444U
#define IOMUXC_GPIO_DISP_B1_07_ENET_1G_TX_DATA02 0x400E8200U, 0x1U, 0, 0, 0x400E8444U
#define IOMUXC_GPIO_DISP_B1_07_LPUART4_RTS_B 0x400E8200U, 0x2U, 0, 0, 0x400E8444U
#define IOMUXC_GPIO_DISP_B1_07_TMR3_TIMER1 0x400E8200U, 0x3U, 0x400E8658U, 0x2U, 0x400E8444U
#define IOMUXC_GPIO_DISP_B1_07_XBAR1_INOUT33 0x400E8200U, 0x4U, 0x400E870CU, 0x1U, 0x400E8444U
#define IOMUXC_GPIO_DISP_B1_07_GPIO_MUX4_IO28 0x400E8200U, 0x5U, 0, 0, 0x400E8444U
#define IOMUXC_GPIO_DISP_B1_07_SRC_BT_CFG01 0x400E8200U, 0x6U, 0, 0, 0x400E8444U
#define IOMUXC_GPIO_DISP_B1_07_ENET_QOS_TX_DATA02 0x400E8200U, 0x8U, 0, 0, 0x400E8444U
#define IOMUXC_GPIO_DISP_B1_07_LPSPI3_PCS0 0x400E8200U, 0x9U, 0x400E85F0U, 0x1U, 0x400E8444U
#define IOMUXC_GPIO_DISP_B1_07_GPIO10_IO28 0x400E8200U, 0xAU, 0, 0, 0x400E8444U

#define IOMUXC_GPIO_DISP_B1_08_GPIO10_IO29 0x400E8204U, 0xAU, 0, 0, 0x400E8448U
#define IOMUXC_GPIO_DISP_B1_08_VIDEO_MUX_LCDIF_DATA04 0x400E8204U, 0x0U, 0, 0, 0x400E8448U
#define IOMUXC_GPIO_DISP_B1_08_ENET_1G_TX_DATA01 0x400E8204U, 0x1U, 0, 0, 0x400E8448U
#define IOMUXC_GPIO_DISP_B1_08_USDHC1_CD_B 0x400E8204U, 0x2U, 0x400E86C8U, 0x1U, 0x400E8448U
#define IOMUXC_GPIO_DISP_B1_08_TMR3_TIMER2 0x400E8204U, 0x3U, 0x400E865CU, 0x1U, 0x400E8448U
#define IOMUXC_GPIO_DISP_B1_08_XBAR1_INOUT34 0x400E8204U, 0x4U, 0x400E8710U, 0x1U, 0x400E8448U
#define IOMUXC_GPIO_DISP_B1_08_GPIO_MUX4_IO29 0x400E8204U, 0x5U, 0, 0, 0x400E8448U
#define IOMUXC_GPIO_DISP_B1_08_SRC_BT_CFG02 0x400E8204U, 0x6U, 0, 0, 0x400E8448U
#define IOMUXC_GPIO_DISP_B1_08_ENET_QOS_TX_DATA01 0x400E8204U, 0x8U, 0, 0, 0x400E8448U
#define IOMUXC_GPIO_DISP_B1_08_LPSPI3_PCS1 0x400E8204U, 0x9U, 0x400E85F4U, 0x1U, 0x400E8448U

#define IOMUXC_GPIO_DISP_B1_09_VIDEO_MUX_LCDIF_DATA05 0x400E8208U, 0x0U, 0, 0, 0x400E844CU
#define IOMUXC_GPIO_DISP_B1_09_ENET_1G_TX_DATA00 0x400E8208U, 0x1U, 0, 0, 0x400E844CU
#define IOMUXC_GPIO_DISP_B1_09_USDHC1_WP 0x400E8208U, 0x2U, 0x400E86CCU, 0x1U, 0x400E844CU
#define IOMUXC_GPIO_DISP_B1_09_TMR4_TIMER0 0x400E8208U, 0x3U, 0x400E8660U, 0x2U, 0x400E844CU
#define IOMUXC_GPIO_DISP_B1_09_XBAR1_INOUT35 0x400E8208U, 0x4U, 0x400E8714U, 0x1U, 0x400E844CU
#define IOMUXC_GPIO_DISP_B1_09_GPIO_MUX4_IO30 0x400E8208U, 0x5U, 0, 0, 0x400E844CU
#define IOMUXC_GPIO_DISP_B1_09_SRC_BT_CFG03 0x400E8208U, 0x6U, 0, 0, 0x400E844CU
#define IOMUXC_GPIO_DISP_B1_09_ENET_QOS_TX_DATA00 0x400E8208U, 0x8U, 0, 0, 0x400E844CU
#define IOMUXC_GPIO_DISP_B1_09_LPSPI3_PCS2 0x400E8208U, 0x9U, 0x400E85F8U, 0x1U, 0x400E844CU
#define IOMUXC_GPIO_DISP_B1_09_GPIO10_IO30 0x400E8208U, 0xAU, 0, 0, 0x400E844CU

#define IOMUXC_GPIO_DISP_B1_10_VIDEO_MUX_LCDIF_DATA06 0x400E820CU, 0x0U, 0, 0, 0x400E8450U
#define IOMUXC_GPIO_DISP_B1_10_ENET_1G_TX_EN 0x400E820CU, 0x1U, 0, 0, 0x400E8450U
#define IOMUXC_GPIO_DISP_B1_10_USDHC1_RESET_B 0x400E820CU, 0x2U, 0, 0, 0x400E8450U
#define IOMUXC_GPIO_DISP_B1_10_TMR4_TIMER1 0x400E820CU, 0x3U, 0x400E8664U, 0x2U, 0x400E8450U
#define IOMUXC_GPIO_DISP_B1_10_XBAR1_INOUT36 0x400E820CU, 0x4U, 0, 0, 0x400E8450U
#define IOMUXC_GPIO_DISP_B1_10_GPIO_MUX4_IO31 0x400E820CU, 0x5U, 0, 0, 0x400E8450U
#define IOMUXC_GPIO_DISP_B1_10_SRC_BT_CFG04 0x400E820CU, 0x6U, 0, 0, 0x400E8450U
#define IOMUXC_GPIO_DISP_B1_10_ENET_QOS_TX_EN 0x400E820CU, 0x8U, 0, 0, 0x400E8450U
#define IOMUXC_GPIO_DISP_B1_10_LPSPI3_PCS3 0x400E820CU, 0x9U, 0x400E85FCU, 0x1U, 0x400E8450U
#define IOMUXC_GPIO_DISP_B1_10_GPIO10_IO31 0x400E820CU, 0xAU, 0, 0, 0x400E8450U

#define IOMUXC_GPIO_DISP_B1_11_VIDEO_MUX_LCDIF_DATA07 0x400E8210U, 0x0U, 0, 0, 0x400E8454U
#define IOMUXC_GPIO_DISP_B1_11_ENET_1G_TX_CLK_IO 0x400E8210U, 0x1U, 0x400E84E8U, 0x2U, 0x400E8454U
#define IOMUXC_GPIO_DISP_B1_11_ENET_1G_REF_CLK 0x400E8210U, 0x2U, 0x400E84C4U, 0x2U, 0x400E8454U
#define IOMUXC_GPIO_DISP_B1_11_TMR4_TIMER2 0x400E8210U, 0x3U, 0x400E8668U, 0x1U, 0x400E8454U
#define IOMUXC_GPIO_DISP_B1_11_XBAR1_INOUT37 0x400E8210U, 0x4U, 0, 0, 0x400E8454U
#define IOMUXC_GPIO_DISP_B1_11_GPIO_MUX5_IO00 0x400E8210U, 0x5U, 0, 0, 0x400E8454U
#define IOMUXC_GPIO_DISP_B1_11_SRC_BT_CFG05 0x400E8210U, 0x6U, 0, 0, 0x400E8454U
#define IOMUXC_GPIO_DISP_B1_11_ENET_QOS_TX_CLK 0x400E8210U, 0x8U, 0x400E84A4U, 0x0U, 0x400E8454U
#define IOMUXC_GPIO_DISP_B1_11_ENET_QOS_REF_CLK 0x400E8210U, 0x9U, 0x400E84A0U, 0x2U, 0x400E8454U
#define IOMUXC_GPIO_DISP_B1_11_GPIO11_IO00 0x400E8210U, 0xAU, 0, 0, 0x400E8454U

#define IOMUXC_GPIO_DISP_B2_00_GPIO11_IO01 0x400E8214U, 0xAU, 0, 0, 0x400E8458U
#define IOMUXC_GPIO_DISP_B2_00_VIDEO_MUX_LCDIF_DATA08 0x400E8214U, 0x0U, 0, 0, 0x400E8458U
#define IOMUXC_GPIO_DISP_B2_00_WDOG1_B 0x400E8214U, 0x1U, 0, 0, 0x400E8458U
#define IOMUXC_GPIO_DISP_B2_00_MQS_RIGHT 0x400E8214U, 0x2U, 0, 0, 0x400E8458U
#define IOMUXC_GPIO_DISP_B2_00_ENET_1G_TX_ER 0x400E8214U, 0x3U, 0, 0, 0x400E8458U
#define IOMUXC_GPIO_DISP_B2_00_SAI1_TX_DATA03 0x400E8214U, 0x4U, 0, 0, 0x400E8458U
#define IOMUXC_GPIO_DISP_B2_00_GPIO_MUX5_IO01 0x400E8214U, 0x5U, 0, 0, 0x400E8458U
#define IOMUXC_GPIO_DISP_B2_00_SRC_BT_CFG06 0x400E8214U, 0x6U, 0, 0, 0x400E8458U
#define IOMUXC_GPIO_DISP_B2_00_ENET_QOS_TX_ER 0x400E8214U, 0x8U, 0, 0, 0x400E8458U

#define IOMUXC_GPIO_DISP_B2_01_VIDEO_MUX_LCDIF_DATA09 0x400E8218U, 0x0U, 0, 0, 0x400E845CU
#define IOMUXC_GPIO_DISP_B2_01_USDHC1_VSELECT 0x400E8218U, 0x1U, 0, 0, 0x400E845CU
#define IOMUXC_GPIO_DISP_B2_01_MQS_LEFT 0x400E8218U, 0x2U, 0, 0, 0x400E845CU
#define IOMUXC_GPIO_DISP_B2_01_WDOG2_B 0x400E8218U, 0x3U, 0, 0, 0x400E845CU
#define IOMUXC_GPIO_DISP_B2_01_SAI1_TX_DATA02 0x400E8218U, 0x4U, 0, 0, 0x400E845CU
#define IOMUXC_GPIO_DISP_B2_01_GPIO_MUX5_IO02 0x400E8218U, 0x5U, 0, 0, 0x400E845CU
#define IOMUXC_GPIO_DISP_B2_01_SRC_BT_CFG07 0x400E8218U, 0x6U, 0, 0, 0x400E845CU
#define IOMUXC_GPIO_DISP_B2_01_EWM_OUT_B 0x400E8218U, 0x8U, 0, 0, 0x400E845CU
#define IOMUXC_GPIO_DISP_B2_01_CCM_ENET_REF_CLK_25M 0x400E8218U, 0x9U, 0, 0, 0x400E845CU
#define IOMUXC_GPIO_DISP_B2_01_GPIO11_IO02 0x400E8218U, 0xAU, 0, 0, 0x400E845CU

#define IOMUXC_GPIO_DISP_B2_02_GPIO11_IO03 0x400E821CU, 0xAU, 0, 0, 0x400E8460U
#define IOMUXC_GPIO_DISP_B2_02_VIDEO_MUX_LCDIF_DATA10 0x400E821CU, 0x0U, 0, 0, 0x400E8460U
#define IOMUXC_GPIO_DISP_B2_02_ENET_TX_DATA00 0x400E821CU, 0x1U, 0, 0, 0x400E8460U
#define IOMUXC_GPIO_DISP_B2_02_PIT1_TRIGGER3 0x400E821CU, 0x2U, 0, 0, 0x400E8460U
#define IOMUXC_GPIO_DISP_B2_02_ARM_TRACE00 0x400E821CU, 0x3U, 0, 0, 0x400E8460U
#define IOMUXC_GPIO_DISP_B2_02_SAI1_TX_DATA01 0x400E821CU, 0x4U, 0, 0, 0x400E8460U
#define IOMUXC_GPIO_DISP_B2_02_GPIO_MUX5_IO03 0x400E821CU, 0x5U, 0, 0, 0x400E8460U
#define IOMUXC_GPIO_DISP_B2_02_SRC_BT_CFG08 0x400E821CU, 0x6U, 0, 0, 0x400E8460U
#define IOMUXC_GPIO_DISP_B2_02_ENET_QOS_TX_DATA00 0x400E821CU, 0x8U, 0, 0, 0x400E8460U

#define IOMUXC_GPIO_DISP_B2_03_GPIO11_IO04 0x400E8220U, 0xAU, 0, 0, 0x400E8464U
#define IOMUXC_GPIO_DISP_B2_03_VIDEO_MUX_LCDIF_DATA11 0x400E8220U, 0x0U, 0, 0, 0x400E8464U
#define IOMUXC_GPIO_DISP_B2_03_ENET_TX_DATA01 0x400E8220U, 0x1U, 0, 0, 0x400E8464U
#define IOMUXC_GPIO_DISP_B2_03_PIT1_TRIGGER2 0x400E8220U, 0x2U, 0, 0, 0x400E8464U
#define IOMUXC_GPIO_DISP_B2_03_ARM_TRACE01 0x400E8220U, 0x3U, 0, 0, 0x400E8464U
#define IOMUXC_GPIO_DISP_B2_03_SAI1_MCLK 0x400E8220U, 0x4U, 0x400E866CU, 0x1U, 0x400E8464U
#define IOMUXC_GPIO_DISP_B2_03_GPIO_MUX5_IO04 0x400E8220U, 0x5U, 0, 0, 0x400E8464U
#define IOMUXC_GPIO_DISP_B2_03_SRC_BT_CFG09 0x400E8220U, 0x6U, 0, 0, 0x400E8464U
#define IOMUXC_GPIO_DISP_B2_03_ENET_QOS_TX_DATA01 0x400E8220U, 0x8U, 0, 0, 0x400E8464U

#define IOMUXC_GPIO_DISP_B2_04_VIDEO_MUX_LCDIF_DATA12 0x400E8224U, 0x0U, 0, 0, 0x400E8468U
#define IOMUXC_GPIO_DISP_B2_04_ENET_TX_EN 0x400E8224U, 0x1U, 0, 0, 0x400E8468U
#define IOMUXC_GPIO_DISP_B2_04_PIT1_TRIGGER1 0x400E8224U, 0x2U, 0, 0, 0x400E8468U
#define IOMUXC_GPIO_DISP_B2_04_ARM_TRACE02 0x400E8224U, 0x3U, 0, 0, 0x400E8468U
#define IOMUXC_GPIO_DISP_B2_04_SAI1_RX_SYNC 0x400E8224U, 0x4U, 0x400E8678U, 0x1U, 0x400E8468U
#define IOMUXC_GPIO_DISP_B2_04_GPIO_MUX5_IO05 0x400E8224U, 0x5U, 0, 0, 0x400E8468U
#define IOMUXC_GPIO_DISP_B2_04_SRC_BT_CFG10 0x400E8224U, 0x6U, 0, 0, 0x400E8468U
#define IOMUXC_GPIO_DISP_B2_04_ENET_QOS_TX_EN 0x400E8224U, 0x8U, 0, 0, 0x400E8468U
#define IOMUXC_GPIO_DISP_B2_04_GPIO11_IO05 0x400E8224U, 0xAU, 0, 0, 0x400E8468U

#define IOMUXC_GPIO_DISP_B2_05_GPIO11_IO06 0x400E8228U, 0xAU, 0, 0, 0x400E846CU
#define IOMUXC_GPIO_DISP_B2_05_VIDEO_MUX_LCDIF_DATA13 0x400E8228U, 0x0U, 0, 0, 0x400E846CU
#define IOMUXC_GPIO_DISP_B2_05_ENET_TX_CLK 0x400E8228U, 0x1U, 0x400E84C0U, 0x1U, 0x400E846CU
#define IOMUXC_GPIO_DISP_B2_05_ENET_REF_CLK 0x400E8228U, 0x2U, 0x400E84A8U, 0x1U, 0x400E846CU
#define IOMUXC_GPIO_DISP_B2_05_ARM_TRACE03 0x400E8228U, 0x3U, 0, 0, 0x400E846CU
#define IOMUXC_GPIO_DISP_B2_05_SAI1_RX_BCLK 0x400E8228U, 0x4U, 0x400E8670U, 0x1U, 0x400E846CU
#define IOMUXC_GPIO_DISP_B2_05_GPIO_MUX5_IO06 0x400E8228U, 0x5U, 0, 0, 0x400E846CU
#define IOMUXC_GPIO_DISP_B2_05_SRC_BT_CFG11 0x400E8228U, 0x6U, 0, 0, 0x400E846CU
#define IOMUXC_GPIO_DISP_B2_05_ENET_QOS_TX_CLK 0x400E8228U, 0x8U, 0x400E84A4U, 0x1U, 0x400E846CU

#define IOMUXC_GPIO_DISP_B2_06_GPIO11_IO07 0x400E822CU, 0xAU, 0, 0, 0x400E8470U
#define IOMUXC_GPIO_DISP_B2_06_VIDEO_MUX_LCDIF_DATA14 0x400E822CU, 0x0U, 0, 0, 0x400E8470U
#define IOMUXC_GPIO_DISP_B2_06_ENET_RX_DATA00 0x400E822CU, 0x1U, 0x400E84B0U, 0x1U, 0x400E8470U
#define IOMUXC_GPIO_DISP_B2_06_LPUART7_TXD 0x400E822CU, 0x2U, 0x400E8630U, 0x1U, 0x400E8470U
#define IOMUXC_GPIO_DISP_B2_06_ARM_TRACE_CLK 0x400E822CU, 0x3U, 0, 0, 0x400E8470U
#define IOMUXC_GPIO_DISP_B2_06_SAI1_RX_DATA00 0x400E822CU, 0x4U, 0x400E8674U, 0x1U, 0x400E8470U
#define IOMUXC_GPIO_DISP_B2_06_GPIO_MUX5_IO07 0x400E822CU, 0x5U, 0, 0, 0x400E8470U
#define IOMUXC_GPIO_DISP_B2_06_ENET_QOS_RX_DATA00 0x400E822CU, 0x8U, 0x400E84F0U, 0x1U, 0x400E8470U

#define IOMUXC_GPIO_DISP_B2_07_VIDEO_MUX_LCDIF_DATA15 0x400E8230U, 0x0U, 0, 0, 0x400E8474U
#define IOMUXC_GPIO_DISP_B2_07_ENET_RX_DATA01 0x400E8230U, 0x1U, 0x400E84B4U, 0x1U, 0x400E8474U
#define IOMUXC_GPIO_DISP_B2_07_LPUART7_RXD 0x400E8230U, 0x2U, 0x400E862CU, 0x1U, 0x400E8474U
#define IOMUXC_GPIO_DISP_B2_07_ARM_TRACE_SWO 0x400E8230U, 0x3U, 0, 0, 0x400E8474U
#define IOMUXC_GPIO_DISP_B2_07_SAI1_TX_DATA00 0x400E8230U, 0x4U, 0, 0, 0x400E8474U
#define IOMUXC_GPIO_DISP_B2_07_GPIO_MUX5_IO08 0x400E8230U, 0x5U, 0, 0, 0x400E8474U
#define IOMUXC_GPIO_DISP_B2_07_ENET_QOS_RX_DATA01 0x400E8230U, 0x8U, 0x400E84F4U, 0x1U, 0x400E8474U
#define IOMUXC_GPIO_DISP_B2_07_GPIO11_IO08 0x400E8230U, 0xAU, 0, 0, 0x400E8474U

#define IOMUXC_GPIO_DISP_B2_08_GPIO11_IO09 0x400E8234U, 0xAU, 0, 0, 0x400E8478U
#define IOMUXC_GPIO_DISP_B2_08_VIDEO_MUX_LCDIF_DATA16 0x400E8234U, 0x0U, 0, 0, 0x400E8478U
#define IOMUXC_GPIO_DISP_B2_08_ENET_RX_EN 0x400E8234U, 0x1U, 0x400E84B8U, 0x1U, 0x400E8478U
#define IOMUXC_GPIO_DISP_B2_08_LPUART8_TXD 0x400E8234U, 0x2U, 0x400E8638U, 0x1U, 0x400E8478U
#define IOMUXC_GPIO_DISP_B2_08_ARM_CM7_EVENTO 0x400E8234U, 0x3U, 0, 0, 0x400E8478U
#define IOMUXC_GPIO_DISP_B2_08_SAI1_TX_BCLK 0x400E8234U, 0x4U, 0x400E867CU, 0x1U, 0x400E8478U
#define IOMUXC_GPIO_DISP_B2_08_GPIO_MUX5_IO09 0x400E8234U, 0x5U, 0, 0, 0x400E8478U
#define IOMUXC_GPIO_DISP_B2_08_ENET_QOS_RX_EN 0x400E8234U, 0x8U, 0x400E84F8U, 0x1U, 0x400E8478U
#define IOMUXC_GPIO_DISP_B2_08_LPUART1_TXD 0x400E8234U, 0x9U, 0x400E8620U, 0x2U, 0x400E8478U

#define IOMUXC_GPIO_DISP_B2_09_GPIO11_IO10 0x400E8238U, 0xAU, 0, 0, 0x400E847CU
#define IOMUXC_GPIO_DISP_B2_09_VIDEO_MUX_LCDIF_DATA17 0x400E8238U, 0x0U, 0, 0, 0x400E847CU
#define IOMUXC_GPIO_DISP_B2_09_ENET_RX_ER 0x400E8238U, 0x1U, 0x400E84BCU, 0x1U, 0x400E847CU
#define IOMUXC_GPIO_DISP_B2_09_LPUART8_RXD 0x400E8238U, 0x2U, 0x400E8634U, 0x1U, 0x400E847CU
#define IOMUXC_GPIO_DISP_B2_09_ARM_CM7_EVENTI 0x400E8238U, 0x3U, 0, 0, 0x400E847CU
#define IOMUXC_GPIO_DISP_B2_09_SAI1_TX_SYNC 0x400E8238U, 0x4U, 0x400E8680U, 0x1U, 0x400E847CU
#define IOMUXC_GPIO_DISP_B2_09_GPIO_MUX5_IO10 0x400E8238U, 0x5U, 0, 0, 0x400E847CU
#define IOMUXC_GPIO_DISP_B2_09_ENET_QOS_RX_ER 0x400E8238U, 0x8U, 0x400E84FCU, 0x1U, 0x400E847CU
#define IOMUXC_GPIO_DISP_B2_09_LPUART1_RXD 0x400E8238U, 0x9U, 0x400E861CU, 0x2U, 0x400E847CU

#define IOMUXC_GPIO_DISP_B2_10_GPIO11_IO11 0x400E823CU, 0xAU, 0, 0, 0x400E8480U
#define IOMUXC_GPIO_DISP_B2_10_VIDEO_MUX_LCDIF_DATA18 0x400E823CU, 0x0U, 0, 0, 0x400E8480U
#define IOMUXC_GPIO_DISP_B2_10_EMVSIM2_IO 0x400E823CU, 0x1U, 0x400E86A8U, 0x1U, 0x400E8480U
#define IOMUXC_GPIO_DISP_B2_10_LPUART2_TXD 0x400E823CU, 0x2U, 0, 0, 0x400E8480U
#define IOMUXC_GPIO_DISP_B2_10_WDOG2_RESET_B_DEB 0x400E823CU, 0x3U, 0, 0, 0x400E8480U
#define IOMUXC_GPIO_DISP_B2_10_XBAR1_INOUT38 0x400E823CU, 0x4U, 0, 0, 0x400E8480U
#define IOMUXC_GPIO_DISP_B2_10_GPIO_MUX5_IO11 0x400E823CU, 0x5U, 0, 0, 0x400E8480U
#define IOMUXC_GPIO_DISP_B2_10_LPI2C3_SCL 0x400E823CU, 0x6U, 0x400E85BCU, 0x1U, 0x400E8480U
#define IOMUXC_GPIO_DISP_B2_10_ENET_QOS_RX_ER 0x400E823CU, 0x8U, 0x400E84FCU, 0x2U, 0x400E8480U
#define IOMUXC_GPIO_DISP_B2_10_SPDIF_IN 0x400E823CU, 0x9U, 0x400E86B4U, 0x2U, 0x400E8480U

#define IOMUXC_GPIO_DISP_B2_11_VIDEO_MUX_LCDIF_DATA19 0x400E8240U, 0x0U, 0, 0, 0x400E8484U
#define IOMUXC_GPIO_DISP_B2_11_EMVSIM2_CLK 0x400E8240U, 0x1U, 0, 0, 0x400E8484U
#define IOMUXC_GPIO_DISP_B2_11_LPUART2_RXD 0x400E8240U, 0x2U, 0, 0, 0x400E8484U
#define IOMUXC_GPIO_DISP_B2_11_WDOG1_RESET_B_DEB 0x400E8240U, 0x3U, 0, 0, 0x400E8484U
#define IOMUXC_GPIO_DISP_B2_11_XBAR1_INOUT39 0x400E8240U, 0x4U, 0, 0, 0x400E8484U
#define IOMUXC_GPIO_DISP_B2_11_GPIO_MUX5_IO12 0x400E8240U, 0x5U, 0, 0, 0x400E8484U
#define IOMUXC_GPIO_DISP_B2_11_LPI2C3_SDA 0x400E8240U, 0x6U, 0x400E85C0U, 0x1U, 0x400E8484U
#define IOMUXC_GPIO_DISP_B2_11_ENET_QOS_CRS 0x400E8240U, 0x8U, 0, 0, 0x400E8484U
#define IOMUXC_GPIO_DISP_B2_11_SPDIF_OUT 0x400E8240U, 0x9U, 0, 0, 0x400E8484U
#define IOMUXC_GPIO_DISP_B2_11_GPIO11_IO12 0x400E8240U, 0xAU, 0, 0, 0x400E8484U

#define IOMUXC_GPIO_DISP_B2_12_GPIO11_IO13 0x400E8244U, 0xAU, 0, 0, 0x400E8488U
#define IOMUXC_GPIO_DISP_B2_12_VIDEO_MUX_LCDIF_DATA20 0x400E8244U, 0x0U, 0, 0, 0x400E8488U
#define IOMUXC_GPIO_DISP_B2_12_EMVSIM2_RST 0x400E8244U, 0x1U, 0, 0, 0x400E8488U
#define IOMUXC_GPIO_DISP_B2_12_FLEXCAN1_TX 0x400E8244U, 0x2U, 0, 0, 0x400E8488U
#define IOMUXC_GPIO_DISP_B2_12_LPUART2_CTS_B 0x400E8244U, 0x3U, 0, 0, 0x400E8488U
#define IOMUXC_GPIO_DISP_B2_12_XBAR1_INOUT40 0x400E8244U, 0x4U, 0, 0, 0x400E8488U
#define IOMUXC_GPIO_DISP_B2_12_GPIO_MUX5_IO13 0x400E8244U, 0x5U, 0, 0, 0x400E8488U
#define IOMUXC_GPIO_DISP_B2_12_LPI2C4_SCL 0x400E8244U, 0x6U, 0x400E85C4U, 0x1U, 0x400E8488U
#define IOMUXC_GPIO_DISP_B2_12_ENET_QOS_COL 0x400E8244U, 0x8U, 0, 0, 0x400E8488U
#define IOMUXC_GPIO_DISP_B2_12_LPSPI4_SCK 0x400E8244U, 0x9U, 0x400E8610U, 0x1U, 0x400E8488U

#define IOMUXC_GPIO_DISP_B2_13_GPIO11_IO14 0x400E8248U, 0xAU, 0, 0, 0x400E848CU
#define IOMUXC_GPIO_DISP_B2_13_VIDEO_MUX_LCDIF_DATA21 0x400E8248U, 0x0U, 0, 0, 0x400E848CU
#define IOMUXC_GPIO_DISP_B2_13_EMVSIM2_SVEN 0x400E8248U, 0x1U, 0, 0, 0x400E848CU
#define IOMUXC_GPIO_DISP_B2_13_FLEXCAN1_RX 0x400E8248U, 0x2U, 0x400E8498U, 0x1U, 0x400E848CU
#define IOMUXC_GPIO_DISP_B2_13_LPUART2_RTS_B 0x400E8248U, 0x3U, 0, 0, 0x400E848CU
#define IOMUXC_GPIO_DISP_B2_13_ENET_REF_CLK 0x400E8248U, 0x4U, 0x400E84A8U, 0x2U, 0x400E848CU
#define IOMUXC_GPIO_DISP_B2_13_GPIO_MUX5_IO14 0x400E8248U, 0x5U, 0, 0, 0x400E848CU
#define IOMUXC_GPIO_DISP_B2_13_LPI2C4_SDA 0x400E8248U, 0x6U, 0x400E85C8U, 0x1U, 0x400E848CU
#define IOMUXC_GPIO_DISP_B2_13_ENET_QOS_1588_EVENT0_OUT 0x400E8248U, 0x8U, 0, 0, 0x400E848CU
#define IOMUXC_GPIO_DISP_B2_13_LPSPI4_SIN 0x400E8248U, 0x9U, 0x400E8614U, 0x1U, 0x400E848CU

#define IOMUXC_GPIO_DISP_B2_14_GPIO_MUX5_IO15 0x400E824CU, 0x5U, 0, 0, 0x400E8490U
#define IOMUXC_GPIO_DISP_B2_14_FLEXCAN1_TX 0x400E824CU, 0x6U, 0, 0, 0x400E8490U
#define IOMUXC_GPIO_DISP_B2_14_ENET_QOS_1588_EVENT0_IN 0x400E824CU, 0x8U, 0, 0, 0x400E8490U
#define IOMUXC_GPIO_DISP_B2_14_LPSPI4_SOUT 0x400E824CU, 0x9U, 0x400E8618U, 0x1U, 0x400E8490U
#define IOMUXC_GPIO_DISP_B2_14_GPIO11_IO15 0x400E824CU, 0xAU, 0, 0, 0x400E8490U
#define IOMUXC_GPIO_DISP_B2_14_VIDEO_MUX_LCDIF_DATA22 0x400E824CU, 0x0U, 0, 0, 0x400E8490U
#define IOMUXC_GPIO_DISP_B2_14_EMVSIM2_PD 0x400E824CU, 0x1U, 0x400E86ACU, 0x1U, 0x400E8490U
#define IOMUXC_GPIO_DISP_B2_14_WDOG2_B 0x400E824CU, 0x2U, 0, 0, 0x400E8490U
#define IOMUXC_GPIO_DISP_B2_14_VIDEO_MUX_EXT_DCIC1 0x400E824CU, 0x3U, 0, 0, 0x400E8490U
#define IOMUXC_GPIO_DISP_B2_14_ENET_1G_REF_CLK 0x400E824CU, 0x4U, 0x400E84C4U, 0x3U, 0x400E8490U

#define IOMUXC_GPIO_DISP_B2_15_VIDEO_MUX_LCDIF_DATA23 0x400E8250U, 0x0U, 0, 0, 0x400E8494U
#define IOMUXC_GPIO_DISP_B2_15_EMVSIM2_POWER_FAIL 0x400E8250U, 0x1U, 0x400E86B0U, 0x1U, 0x400E8494U
#define IOMUXC_GPIO_DISP_B2_15_WDOG1_B 0x400E8250U, 0x2U, 0, 0, 0x400E8494U
#define IOMUXC_GPIO_DISP_B2_15_VIDEO_MUX_EXT_DCIC2 0x400E8250U, 0x3U, 0, 0, 0x400E8494U
#define IOMUXC_GPIO_DISP_B2_15_PIT1_TRIGGER0 0x400E8250U, 0x4U, 0, 0, 0x400E8494U
#define IOMUXC_GPIO_DISP_B2_15_GPIO_MUX5_IO16 0x400E8250U, 0x5U, 0, 0, 0x400E8494U
#define IOMUXC_GPIO_DISP_B2_15_FLEXCAN1_RX 0x400E8250U, 0x6U, 0x400E8498U, 0x2U, 0x400E8494U
#define IOMUXC_GPIO_DISP_B2_15_ENET_QOS_1588_EVENT0_AUX_IN 0x400E8250U, 0x8U, 0, 0, 0x400E8494U
#define IOMUXC_GPIO_DISP_B2_15_LPSPI4_PCS0 0x400E8250U, 0x9U, 0x400E860CU, 0x1U, 0x400E8494U
#define IOMUXC_GPIO_DISP_B2_15_GPIO11_IO16 0x400E8250U, 0xAU, 0, 0, 0x400E8494U

/*@}*/

#define IOMUXC_GPR_SAIMCLK_LOWBITMASK (0x7U)
#define IOMUXC_GPR_SAIMCLK_HIGHBITMASK (0x3U)

typedef enum _iomuxc_gpr_saimclk
{
    kIOMUXC_GPR_SAI1MClk1Sel = IOMUXC_GPR_GPR0_SAI1_MCLK1_SEL_SHIFT,
    kIOMUXC_GPR_SAI1MClk2Sel = IOMUXC_GPR_GPR0_SAI1_MCLK2_SEL_SHIFT,
    kIOMUXC_GPR_SAI1MClk3Sel = IOMUXC_GPR_GPR0_SAI1_MCLK3_SEL_SHIFT,
    kIOMUXC_GPR_SAI2MClk3Sel = IOMUXC_GPR_GPR1_SAI2_MCLK3_SEL_SHIFT + 8U,
    kIOMUXC_GPR_SAI3MClk3Sel = IOMUXC_GPR_GPR2_SAI3_MCLK3_SEL_SHIFT + 10U,
} iomuxc_gpr_saimclk_t;

typedef enum _iomuxc_mqs_pwm_oversample_rate
{
    kIOMUXC_MqsPwmOverSampleRate32 = 0, /* MQS PWM over sampling rate 32. */
    kIOMUXC_MqsPwmOverSampleRate64 = 1  /* MQS PWM over sampling rate 64. */
} iomuxc_mqs_pwm_oversample_rate_t;

#if defined(__cplusplus)
extern "C" {
#endif /*_cplusplus */

/*! @name Configuration */
/*@{*/

/*!
 * @brief Sets the IOMUXC pin mux mode.
 * @note The first five parameters can be filled with the pin function ID macros.
 *
 * This is an example to set the PTA6 as the lpuart0_tx:
 * @code
 * IOMUXC_SetPinMux(IOMUXC_PTA6_LPUART0_TX, 0);
 * @endcode
 *
 * This is an example to set the PTA0 as GPIOA0:
 * @code
 * IOMUXC_SetPinMux(IOMUXC_PTA0_GPIOA0, 0);
 * @endcode
 *
 * @param muxRegister  The pin mux register.
 * @param muxMode      The pin mux mode.
 * @param inputRegister The select input register.
 * @param inputDaisy   The input daisy.
 * @param configRegister  The config register.
 * @param inputOnfield   Software input on field.
 */
static inline void IOMUXC_SetPinMux(uint32_t muxRegister,
                                    uint32_t muxMode,
                                    uint32_t inputRegister,
                                    uint32_t inputDaisy,
                                    uint32_t configRegister,
                                    uint32_t inputOnfield)
{
    *((volatile uint32_t *)muxRegister) =
        IOMUXC_SW_MUX_CTL_PAD_MUX_MODE(muxMode) | IOMUXC_SW_MUX_CTL_PAD_SION(inputOnfield);

    if (inputRegister != 0UL)
    {
        *((volatile uint32_t *)inputRegister) = inputDaisy;
    }
}

/*!
 * @brief Sets the IOMUXC pin configuration.
 * @note The previous five parameters can be filled with the pin function ID macros.
 *
 * This is an example to set pin configuration for IOMUXC_PTA3_LPI2C0_SCLS:
 * @code
 * IOMUXC_SetPinConfig(IOMUXC_PTA3_LPI2C0_SCLS,IOMUXC_SW_PAD_CTL_PAD_PUS_MASK|IOMUXC_SW_PAD_CTL_PAD_PUS(2U))
 * @endcode
 *
 * @param muxRegister  The pin mux register.
 * @param muxMode      The pin mux mode.
 * @param inputRegister The select input register.
 * @param inputDaisy   The input daisy.
 * @param configRegister  The config register.
 * @param configValue   The pin config value.
 */
static inline void IOMUXC_SetPinConfig(uint32_t muxRegister,
                                       uint32_t muxMode,
                                       uint32_t inputRegister,
                                       uint32_t inputDaisy,
                                       uint32_t configRegister,
                                       uint32_t configValue)
{
    if (configRegister != 0UL)
    {
        *((volatile uint32_t *)configRegister) = configValue;
    }
}

/*!
 * @brief Sets IOMUXC general configuration for SAI MCLK selection.
 *
 * @param base     The IOMUXC GPR base address.
 * @param mclk     The SAI MCLK.
 * @param clkSrc   The clock source. Take refer to register setting details for the clock source in RM.
 */
static inline void IOMUXC_SetSaiMClkClockSource(IOMUXC_GPR_Type *base, iomuxc_gpr_saimclk_t mclk, uint8_t clkSrc)
{
    uint32_t gpr;

    if (mclk > kIOMUXC_GPR_SAI2MClk3Sel)
    {
        gpr        = base->GPR2 & ~(IOMUXC_GPR_SAIMCLK_HIGHBITMASK);
        base->GPR2 = ((uint32_t)clkSrc & IOMUXC_GPR_SAIMCLK_HIGHBITMASK) | gpr;
    }
    else if (mclk > kIOMUXC_GPR_SAI1MClk3Sel)
    {
        gpr        = base->GPR1 & ~(IOMUXC_GPR_SAIMCLK_HIGHBITMASK);
        base->GPR1 = ((uint32_t)clkSrc & IOMUXC_GPR_SAIMCLK_HIGHBITMASK) | gpr;
    }
    else if (mclk > kIOMUXC_GPR_SAI1MClk2Sel)
    {
        gpr = base->GPR0 & ~((uint32_t)IOMUXC_GPR_SAIMCLK_HIGHBITMASK << (uint32_t)mclk);
        base->GPR0 = (((uint32_t)clkSrc & IOMUXC_GPR_SAIMCLK_HIGHBITMASK) << (uint32_t)mclk) | gpr;
    }
    else
    {
        gpr = base->GPR0 & ~((uint32_t)IOMUXC_GPR_SAIMCLK_LOWBITMASK << (uint32_t)mclk);
        base->GPR0 = (((uint32_t)clkSrc & IOMUXC_GPR_SAIMCLK_LOWBITMASK) << (uint32_t)mclk) | gpr;
    }
}

/*!
 * @brief Enters or exit MQS software reset.
 *
 * @param base     The IOMUXC GPR base address.
 * @param enable   Enter or exit MQS software reset.
 */
static inline void IOMUXC_MQSEnterSoftwareReset(IOMUXC_GPR_Type *base, bool enable)
{
    if (enable)
    {
        base->GPR3 |= IOMUXC_GPR_GPR3_MQS_SW_RST_MASK;
    }
    else
    {
        base->GPR3 &= ~IOMUXC_GPR_GPR3_MQS_SW_RST_MASK;
    }
}

/*!
 * @brief Enables or disables MQS.
 *
 * @param base     The IOMUXC GPR base address.
 * @param enable   Enable or disable the MQS.
 */
static inline void IOMUXC_MQSEnable(IOMUXC_GPR_Type *base, bool enable)
{
    if (enable)
    {
        base->GPR3 |= IOMUXC_GPR_GPR3_MQS_EN_MASK;
    }
    else
    {
        base->GPR3 &= ~IOMUXC_GPR_GPR3_MQS_EN_MASK;
    }
}

/*!
 * @brief Configure MQS PWM oversampling rate compared with mclk and divider ratio control for mclk from hmclk.
 *
 * @param base     The IOMUXC GPR base address.
 * @param rate     The MQS PWM oversampling rate, refer to "iomuxc_mqs_pwm_oversample_rate_t".
 * @param divider  The divider ratio control for mclk from hmclk. mclk freq = 1 /(divider + 1) * hmclk freq.
 */

static inline void IOMUXC_MQSConfig(IOMUXC_GPR_Type *base, iomuxc_mqs_pwm_oversample_rate_t rate, uint8_t divider)
{
    uint32_t gpr = base->GPR3 & ~(IOMUXC_GPR_GPR3_MQS_OVERSAMPLE_MASK | IOMUXC_GPR_GPR3_MQS_CLK_DIV_MASK);

    base->GPR3 = gpr | IOMUXC_GPR_GPR3_MQS_OVERSAMPLE(rate) | IOMUXC_GPR_GPR3_MQS_CLK_DIV(divider);
}

/*@}*/

#if defined(__cplusplus)
}
#endif /*_cplusplus */

/*! @}*/

#endif /* _FSL_IOMUXC_H_ */
