/*
 * Copyright 2018-2020 NXP
 * All rights reserved.
 *
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef _RTE_DEVICE_H
#define _RTE_DEVICE_H

#include "pin_mux.h"

/* Driver name mapping. */
/* User needs to provide the implementation of LPUARTX_GetFreq/LPUARTX_InitPins/LPUARTX_DeinitPins for the enabled
 * LPUART instance. */
#define RTE_USART1        1
#define RTE_USART1_DMA_EN 0
#define RTE_USART2        0
#define RTE_USART2_DMA_EN 0
#define RTE_USART3        0
#define RTE_USART3_DMA_EN 0
#define RTE_USART4        0
#define RTE_USART4_DMA_EN 0
#define RTE_USART5        0
#define RTE_USART5_DMA_EN 0
#define RTE_USART6        0
#define RTE_USART6_DMA_EN 0
#define RTE_USART7        0
#define RTE_USART7_DMA_EN 0
#define RTE_USART8        1
#define RTE_USART8_DMA_EN 0

/* UART configuration. */
#define RTE_USART1_PIN_INIT        LPUART1_InitPins
#define RTE_USART1_PIN_DEINIT      LPUART1_DeinitPins
#define RTE_USART1_DMA_TX_CH       0
#define RTE_USART1_DMA_TX_PERI_SEL (uint8_t) kDmaRequestMuxLPUART1Tx
#if __CORTEX_M == 7
#define RTE_USART1_DMA_TX_DMAMUX_BASE DMAMUX0
#define RTE_USART1_DMA_TX_DMA_BASE    DMA0
#else
#define RTE_USART1_DMA_TX_DMAMUX_BASE DMAMUX1
#define RTE_USART1_DMA_TX_DMA_BASE    DMA1
#endif
#define RTE_USART1_DMA_RX_CH       1
#define RTE_USART1_DMA_RX_PERI_SEL (uint8_t) kDmaRequestMuxLPUART1Rx
#if __CORTEX_M == 7
#define RTE_USART1_DMA_RX_DMAMUX_BASE DMAMUX0
#define RTE_USART1_DMA_RX_DMA_BASE    DMA0
#else
#define RTE_USART1_DMA_RX_DMAMUX_BASE DMAMUX1
#define RTE_USART1_DMA_RX_DMA_BASE    DMA1
#endif

#define RTE_USART2_PIN_INIT        LPUART2_InitPins
#define RTE_USART2_PIN_DEINIT      LPUART2_DeinitPins
#define RTE_USART2_DMA_TX_CH       0
#define RTE_USART2_DMA_TX_PERI_SEL (uint8_t) kDmaRequestMuxLPUART2Tx
#if __CORTEX_M == 7
#define RTE_USART2_DMA_TX_DMAMUX_BASE DMAMUX0
#define RTE_USART2_DMA_TX_DMA_BASE    DMA0
#else
#define RTE_USART2_DMA_TX_DMAMUX_BASE DMAMUX1
#define RTE_USART2_DMA_TX_DMA_BASE    DMA1
#endif
#define RTE_USART2_DMA_RX_CH       1
#define RTE_USART2_DMA_RX_PERI_SEL (uint8_t) kDmaRequestMuxLPUART2Rx
#if __CORTEX_M == 7
#define RTE_USART2_DMA_RX_DMAMUX_BASE DMAMUX0
#define RTE_USART2_DMA_RX_DMA_BASE    DMA0
#else
#define RTE_USART2_DMA_RX_DMAMUX_BASE DMAMUX1
#define RTE_USART2_DMA_RX_DMA_BASE    DMA1
#endif

#define RTE_USART3_PIN_INIT        LPUART3_InitPins
#define RTE_USART3_PIN_DEINIT      LPUART3_DeinitPins
#define RTE_USART3_DMA_TX_CH       0
#define RTE_USART3_DMA_TX_PERI_SEL (uint8_t) kDmaRequestMuxLPUART3Tx
#if __CORTEX_M == 7
#define RTE_USART3_DMA_TX_DMAMUX_BASE DMAMUX0
#define RTE_USART3_DMA_TX_DMA_BASE    DMA0
#else
#define RTE_USART3_DMA_TX_DMAMUX_BASE DMAMUX1
#define RTE_USART3_DMA_TX_DMA_BASE    DMA1
#endif
#define RTE_USART3_DMA_RX_CH       1
#define RTE_USART3_DMA_RX_PERI_SEL (uint8_t) kDmaRequestMuxLPUART3Rx
#if __CORTEX_M == 7
#define RTE_USART3_DMA_RX_DMAMUX_BASE DMAMUX0
#define RTE_USART3_DMA_RX_DMA_BASE    DMA0
#else
#define RTE_USART3_DMA_RX_DMAMUX_BASE DMAMUX1
#define RTE_USART3_DMA_RX_DMA_BASE    DMA1
#endif

#define RTE_USART4_PIN_INIT        LPUART4_InitPins
#define RTE_USART4_PIN_DEINIT      LPUART4_DeinitPins
#define RTE_USART4_DMA_TX_CH       0
#define RTE_USART4_DMA_TX_PERI_SEL (uint8_t) kDmaRequestMuxLPUART4Tx
#if __CORTEX_M == 7
#define RTE_USART4_DMA_TX_DMAMUX_BASE DMAMUX0
#define RTE_USART4_DMA_TX_DMA_BASE    DMA0
#else
#define RTE_USART4_DMA_TX_DMAMUX_BASE DMAMUX1
#define RTE_USART4_DMA_TX_DMA_BASE    DMA1
#endif
#define RTE_USART4_DMA_RX_CH       1
#define RTE_USART4_DMA_RX_PERI_SEL (uint8_t) kDmaRequestMuxLPUART4Rx
#if __CORTEX_M == 7
#define RTE_USART4_DMA_RX_DMAMUX_BASE DMAMUX0
#define RTE_USART4_DMA_RX_DMA_BASE    DMA0
#else
#define RTE_USART4_DMA_RX_DMAMUX_BASE DMAMUX1
#define RTE_USART4_DMA_RX_DMA_BASE    DMA1
#endif

#define RTE_USART5_PIN_INIT        LPUART5_InitPins
#define RTE_USART5_PIN_DEINIT      LPUART5_DeinitPins
#define RTE_USART5_DMA_TX_CH       0
#define RTE_USART5_DMA_TX_PERI_SEL (uint8_t) kDmaRequestMuxLPUART5Tx
#if __CORTEX_M == 7
#define RTE_USART5_DMA_TX_DMAMUX_BASE DMAMUX0
#define RTE_USART5_DMA_TX_DMA_BASE    DMA0
#else
#define RTE_USART5_DMA_TX_DMAMUX_BASE DMAMUX1
#define RTE_USART5_DMA_TX_DMA_BASE    DMA1
#endif
#define RTE_USART5_DMA_RX_CH       1
#define RTE_USART5_DMA_RX_PERI_SEL (uint8_t) kDmaRequestMuxLPUART5Rx
#if __CORTEX_M == 7
#define RTE_USART5_DMA_RX_DMAMUX_BASE DMAMUX0
#define RTE_USART5_DMA_RX_DMA_BASE    DMA0
#else
#define RTE_USART5_DMA_RX_DMAMUX_BASE DMAMUX1
#define RTE_USART5_DMA_RX_DMA_BASE    DMA1
#endif

#define RTE_USART6_PIN_INIT        LPUART6_InitPins
#define RTE_USART6_PIN_DEINIT      LPUART6_DeinitPins
#define RTE_USART6_DMA_TX_CH       0
#define RTE_USART6_DMA_TX_PERI_SEL (uint8_t) kDmaRequestMuxLPUART6Tx
#if __CORTEX_M == 7
#define RTE_USART6_DMA_TX_DMAMUX_BASE DMAMUX0
#define RTE_USART6_DMA_TX_DMA_BASE    DMA0
#else
#define RTE_USART6_DMA_TX_DMAMUX_BASE DMAMUX1
#define RTE_USART6_DMA_TX_DMA_BASE    DMA1
#endif
#define RTE_USART6_DMA_RX_CH       1
#define RTE_USART6_DMA_RX_PERI_SEL (uint8_t) kDmaRequestMuxLPUART6Rx
#if __CORTEX_M == 7
#define RTE_USART6_DMA_RX_DMAMUX_BASE DMAMUX0
#define RTE_USART6_DMA_RX_DMA_BASE    DMA0
#else
#define RTE_USART6_DMA_RX_DMAMUX_BASE DMAMUX1
#define RTE_USART6_DMA_RX_DMA_BASE    DMA1
#endif

#define RTE_USART7_PIN_INIT        LPUART7_InitPins
#define RTE_USART7_PIN_DEINIT      LPUART7_DeinitPins
#define RTE_USART7_DMA_TX_CH       0
#define RTE_USART7_DMA_TX_PERI_SEL (uint8_t) kDmaRequestMuxLPUART7Tx
#if __CORTEX_M == 7
#define RTE_USART7_DMA_TX_DMAMUX_BASE DMAMUX0
#define RTE_USART7_DMA_TX_DMA_BASE    DMA0
#else
#define RTE_USART7_DMA_TX_DMAMUX_BASE DMAMUX1
#define RTE_USART7_DMA_TX_DMA_BASE    DMA1
#endif
#define RTE_USART7_DMA_RX_CH       1
#define RTE_USART7_DMA_RX_PERI_SEL (uint8_t) kDmaRequestMuxLPUART7Rx
#if __CORTEX_M == 7
#define RTE_USART7_DMA_RX_DMAMUX_BASE DMAMUX0
#define RTE_USART7_DMA_RX_DMA_BASE    DMA0
#else
#define RTE_USART7_DMA_RX_DMAMUX_BASE DMAMUX1
#define RTE_USART7_DMA_RX_DMA_BASE    DMA1
#endif

#define RTE_USART8_PIN_INIT        LPUART8_InitPins
#define RTE_USART8_PIN_DEINIT      LPUART8_DeinitPins
#define RTE_USART8_DMA_TX_CH       0
#define RTE_USART8_DMA_TX_PERI_SEL (uint8_t) kDmaRequestMuxLPUART8Tx
#if __CORTEX_M == 7
#define RTE_USART8_DMA_TX_DMAMUX_BASE DMAMUX0
#define RTE_USART8_DMA_TX_DMA_BASE    DMA0
#else
#define RTE_USART8_DMA_TX_DMAMUX_BASE DMAMUX1
#define RTE_USART8_DMA_TX_DMA_BASE    DMA1
#endif
#define RTE_USART8_DMA_RX_CH       1
#define RTE_USART8_DMA_RX_PERI_SEL (uint8_t) kDmaRequestMuxLPUART8Rx
#if __CORTEX_M == 7
#define RTE_USART8_DMA_RX_DMAMUX_BASE DMAMUX0
#define RTE_USART8_DMA_RX_DMA_BASE    DMA0
#else
#define RTE_USART8_DMA_RX_DMAMUX_BASE DMAMUX1
#define RTE_USART8_DMA_RX_DMA_BASE    DMA1
#endif

/* ENET configuration. */
#define RTE_ENET             1
#define RTE_ENET_PHY_ADDRESS 0  /* Make sure this value is the same as BOARD_ENET1_PHY_ADDRESS in board.h */
#define RTE_ENET_MII         0
#define RTE_ENET_RMII        1
#define RTE_ENET_RGMII       1

#endif /* _RTE_DEVICE_H */
