/*******************************************************************************
* Copyright (c) 2018-2022 Cadence Design Systems, Inc.
*
* Permission is hereby granted, free of charge, to any person obtaining
* a copy of this software and associated documentation files (the
* "Software"), to use this Software with Cadence processor cores only and
* not with any other processors and platforms, subject to
* the following conditions:
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
* EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
* IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
* CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
* TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
* SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************/

#define FIX_INV_Q31(x)  (int)((((unsigned int)1<<31)/((double)x)) + (double)0.999999)

/* 1/num in Q31 format for num = 0 - 1024 */
const int inv_256_tbl[1025] = {
    0,
           0x7fffffff, FIX_INV_Q31(   2), FIX_INV_Q31(   3), FIX_INV_Q31(   4),
    FIX_INV_Q31(   5), FIX_INV_Q31(   6), FIX_INV_Q31(   7), FIX_INV_Q31(   8),
    FIX_INV_Q31(   9), FIX_INV_Q31(  10), FIX_INV_Q31(  11), FIX_INV_Q31(  12),
    FIX_INV_Q31(  13), FIX_INV_Q31(  14), FIX_INV_Q31(  15), FIX_INV_Q31(  16),
    FIX_INV_Q31(  17), FIX_INV_Q31(  18), FIX_INV_Q31(  19), FIX_INV_Q31(  20),
    FIX_INV_Q31(  21), FIX_INV_Q31(  22), FIX_INV_Q31(  23), FIX_INV_Q31(  24),
    FIX_INV_Q31(  25), FIX_INV_Q31(  26), FIX_INV_Q31(  27), FIX_INV_Q31(  28),
    FIX_INV_Q31(  29), FIX_INV_Q31(  30), FIX_INV_Q31(  31), FIX_INV_Q31(  32),
    FIX_INV_Q31(  33), FIX_INV_Q31(  34), FIX_INV_Q31(  35), FIX_INV_Q31(  36),
    FIX_INV_Q31(  37), FIX_INV_Q31(  38), FIX_INV_Q31(  39), FIX_INV_Q31(  40),
    FIX_INV_Q31(  41), FIX_INV_Q31(  42), FIX_INV_Q31(  43), FIX_INV_Q31(  44),
    FIX_INV_Q31(  45), FIX_INV_Q31(  46), FIX_INV_Q31(  47), FIX_INV_Q31(  48),
    FIX_INV_Q31(  49), FIX_INV_Q31(  50), FIX_INV_Q31(  51), FIX_INV_Q31(  52),
    FIX_INV_Q31(  53), FIX_INV_Q31(  54), FIX_INV_Q31(  55), FIX_INV_Q31(  56),
    FIX_INV_Q31(  57), FIX_INV_Q31(  58), FIX_INV_Q31(  59), FIX_INV_Q31(  60),
    FIX_INV_Q31(  61), FIX_INV_Q31(  62), FIX_INV_Q31(  63), FIX_INV_Q31(  64),
    FIX_INV_Q31(  65), FIX_INV_Q31(  66), FIX_INV_Q31(  67), FIX_INV_Q31(  68),
    FIX_INV_Q31(  69), FIX_INV_Q31(  70), FIX_INV_Q31(  71), FIX_INV_Q31(  72),
    FIX_INV_Q31(  73), FIX_INV_Q31(  74), FIX_INV_Q31(  75), FIX_INV_Q31(  76),
    FIX_INV_Q31(  77), FIX_INV_Q31(  78), FIX_INV_Q31(  79), FIX_INV_Q31(  80),
    FIX_INV_Q31(  81), FIX_INV_Q31(  82), FIX_INV_Q31(  83), FIX_INV_Q31(  84),
    FIX_INV_Q31(  85), FIX_INV_Q31(  86), FIX_INV_Q31(  87), FIX_INV_Q31(  88),
    FIX_INV_Q31(  89), FIX_INV_Q31(  90), FIX_INV_Q31(  91), FIX_INV_Q31(  92),
    FIX_INV_Q31(  93), FIX_INV_Q31(  94), FIX_INV_Q31(  95), FIX_INV_Q31(  96),
    FIX_INV_Q31(  97), FIX_INV_Q31(  98), FIX_INV_Q31(  99), FIX_INV_Q31( 100),
    FIX_INV_Q31( 101), FIX_INV_Q31( 102), FIX_INV_Q31( 103), FIX_INV_Q31( 104),
    FIX_INV_Q31( 105), FIX_INV_Q31( 106), FIX_INV_Q31( 107), FIX_INV_Q31( 108),
    FIX_INV_Q31( 109), FIX_INV_Q31( 110), FIX_INV_Q31( 111), FIX_INV_Q31( 112),
    FIX_INV_Q31( 113), FIX_INV_Q31( 114), FIX_INV_Q31( 115), FIX_INV_Q31( 116),
    FIX_INV_Q31( 117), FIX_INV_Q31( 118), FIX_INV_Q31( 119), FIX_INV_Q31( 120),
    FIX_INV_Q31( 121), FIX_INV_Q31( 122), FIX_INV_Q31( 123), FIX_INV_Q31( 124),
    FIX_INV_Q31( 125), FIX_INV_Q31( 126), FIX_INV_Q31( 127), FIX_INV_Q31( 128),
    FIX_INV_Q31( 129), FIX_INV_Q31( 130), FIX_INV_Q31( 131), FIX_INV_Q31( 132),
    FIX_INV_Q31( 133), FIX_INV_Q31( 134), FIX_INV_Q31( 135), FIX_INV_Q31( 136),
    FIX_INV_Q31( 137), FIX_INV_Q31( 138), FIX_INV_Q31( 139), FIX_INV_Q31( 140),
    FIX_INV_Q31( 141), FIX_INV_Q31( 142), FIX_INV_Q31( 143), FIX_INV_Q31( 144),
    FIX_INV_Q31( 145), FIX_INV_Q31( 146), FIX_INV_Q31( 147), FIX_INV_Q31( 148),
    FIX_INV_Q31( 149), FIX_INV_Q31( 150), FIX_INV_Q31( 151), FIX_INV_Q31( 152),
    FIX_INV_Q31( 153), FIX_INV_Q31( 154), FIX_INV_Q31( 155), FIX_INV_Q31( 156),
    FIX_INV_Q31( 157), FIX_INV_Q31( 158), FIX_INV_Q31( 159), FIX_INV_Q31( 160),
    FIX_INV_Q31( 161), FIX_INV_Q31( 162), FIX_INV_Q31( 163), FIX_INV_Q31( 164),
    FIX_INV_Q31( 165), FIX_INV_Q31( 166), FIX_INV_Q31( 167), FIX_INV_Q31( 168),
    FIX_INV_Q31( 169), FIX_INV_Q31( 170), FIX_INV_Q31( 171), FIX_INV_Q31( 172),
    FIX_INV_Q31( 173), FIX_INV_Q31( 174), FIX_INV_Q31( 175), FIX_INV_Q31( 176),
    FIX_INV_Q31( 177), FIX_INV_Q31( 178), FIX_INV_Q31( 179), FIX_INV_Q31( 180),
    FIX_INV_Q31( 181), FIX_INV_Q31( 182), FIX_INV_Q31( 183), FIX_INV_Q31( 184),
    FIX_INV_Q31( 185), FIX_INV_Q31( 186), FIX_INV_Q31( 187), FIX_INV_Q31( 188),
    FIX_INV_Q31( 189), FIX_INV_Q31( 190), FIX_INV_Q31( 191), FIX_INV_Q31( 192),
    FIX_INV_Q31( 193), FIX_INV_Q31( 194), FIX_INV_Q31( 195), FIX_INV_Q31( 196),
    FIX_INV_Q31( 197), FIX_INV_Q31( 198), FIX_INV_Q31( 199), FIX_INV_Q31( 200),
    FIX_INV_Q31( 201), FIX_INV_Q31( 202), FIX_INV_Q31( 203), FIX_INV_Q31( 204),
    FIX_INV_Q31( 205), FIX_INV_Q31( 206), FIX_INV_Q31( 207), FIX_INV_Q31( 208),
    FIX_INV_Q31( 209), FIX_INV_Q31( 210), FIX_INV_Q31( 211), FIX_INV_Q31( 212),
    FIX_INV_Q31( 213), FIX_INV_Q31( 214), FIX_INV_Q31( 215), FIX_INV_Q31( 216),
    FIX_INV_Q31( 217), FIX_INV_Q31( 218), FIX_INV_Q31( 219), FIX_INV_Q31( 220),
    FIX_INV_Q31( 221), FIX_INV_Q31( 222), FIX_INV_Q31( 223), FIX_INV_Q31( 224),
    FIX_INV_Q31( 225), FIX_INV_Q31( 226), FIX_INV_Q31( 227), FIX_INV_Q31( 228),
    FIX_INV_Q31( 229), FIX_INV_Q31( 230), FIX_INV_Q31( 231), FIX_INV_Q31( 232),
    FIX_INV_Q31( 233), FIX_INV_Q31( 234), FIX_INV_Q31( 235), FIX_INV_Q31( 236),
    FIX_INV_Q31( 237), FIX_INV_Q31( 238), FIX_INV_Q31( 239), FIX_INV_Q31( 240),
    FIX_INV_Q31( 241), FIX_INV_Q31( 242), FIX_INV_Q31( 243), FIX_INV_Q31( 244),
    FIX_INV_Q31( 245), FIX_INV_Q31( 246), FIX_INV_Q31( 247), FIX_INV_Q31( 248),
    FIX_INV_Q31( 249), FIX_INV_Q31( 250), FIX_INV_Q31( 251), FIX_INV_Q31( 252),
    FIX_INV_Q31( 253), FIX_INV_Q31( 254), FIX_INV_Q31( 255), FIX_INV_Q31( 256),
    FIX_INV_Q31( 257), FIX_INV_Q31( 258), FIX_INV_Q31( 259), FIX_INV_Q31( 260),
    FIX_INV_Q31( 261), FIX_INV_Q31( 262), FIX_INV_Q31( 263), FIX_INV_Q31( 264),
    FIX_INV_Q31( 265), FIX_INV_Q31( 266), FIX_INV_Q31( 267), FIX_INV_Q31( 268),
    FIX_INV_Q31( 269), FIX_INV_Q31( 270), FIX_INV_Q31( 271), FIX_INV_Q31( 272),
    FIX_INV_Q31( 273), FIX_INV_Q31( 274), FIX_INV_Q31( 275), FIX_INV_Q31( 276),
    FIX_INV_Q31( 277), FIX_INV_Q31( 278), FIX_INV_Q31( 279), FIX_INV_Q31( 280),
    FIX_INV_Q31( 281), FIX_INV_Q31( 282), FIX_INV_Q31( 283), FIX_INV_Q31( 284),
    FIX_INV_Q31( 285), FIX_INV_Q31( 286), FIX_INV_Q31( 287), FIX_INV_Q31( 288),
    FIX_INV_Q31( 289), FIX_INV_Q31( 290), FIX_INV_Q31( 291), FIX_INV_Q31( 292),
    FIX_INV_Q31( 293), FIX_INV_Q31( 294), FIX_INV_Q31( 295), FIX_INV_Q31( 296),
    FIX_INV_Q31( 297), FIX_INV_Q31( 298), FIX_INV_Q31( 299), FIX_INV_Q31( 300),
    FIX_INV_Q31( 301), FIX_INV_Q31( 302), FIX_INV_Q31( 303), FIX_INV_Q31( 304),
    FIX_INV_Q31( 305), FIX_INV_Q31( 306), FIX_INV_Q31( 307), FIX_INV_Q31( 308),
    FIX_INV_Q31( 309), FIX_INV_Q31( 310), FIX_INV_Q31( 311), FIX_INV_Q31( 312),
    FIX_INV_Q31( 313), FIX_INV_Q31( 314), FIX_INV_Q31( 315), FIX_INV_Q31( 316),
    FIX_INV_Q31( 317), FIX_INV_Q31( 318), FIX_INV_Q31( 319), FIX_INV_Q31( 320),
    FIX_INV_Q31( 321), FIX_INV_Q31( 322), FIX_INV_Q31( 323), FIX_INV_Q31( 324),
    FIX_INV_Q31( 325), FIX_INV_Q31( 326), FIX_INV_Q31( 327), FIX_INV_Q31( 328),
    FIX_INV_Q31( 329), FIX_INV_Q31( 330), FIX_INV_Q31( 331), FIX_INV_Q31( 332),
    FIX_INV_Q31( 333), FIX_INV_Q31( 334), FIX_INV_Q31( 335), FIX_INV_Q31( 336),
    FIX_INV_Q31( 337), FIX_INV_Q31( 338), FIX_INV_Q31( 339), FIX_INV_Q31( 340),
    FIX_INV_Q31( 341), FIX_INV_Q31( 342), FIX_INV_Q31( 343), FIX_INV_Q31( 344),
    FIX_INV_Q31( 345), FIX_INV_Q31( 346), FIX_INV_Q31( 347), FIX_INV_Q31( 348),
    FIX_INV_Q31( 349), FIX_INV_Q31( 350), FIX_INV_Q31( 351), FIX_INV_Q31( 352),
    FIX_INV_Q31( 353), FIX_INV_Q31( 354), FIX_INV_Q31( 355), FIX_INV_Q31( 356),
    FIX_INV_Q31( 357), FIX_INV_Q31( 358), FIX_INV_Q31( 359), FIX_INV_Q31( 360),
    FIX_INV_Q31( 361), FIX_INV_Q31( 362), FIX_INV_Q31( 363), FIX_INV_Q31( 364),
    FIX_INV_Q31( 365), FIX_INV_Q31( 366), FIX_INV_Q31( 367), FIX_INV_Q31( 368),
    FIX_INV_Q31( 369), FIX_INV_Q31( 370), FIX_INV_Q31( 371), FIX_INV_Q31( 372),
    FIX_INV_Q31( 373), FIX_INV_Q31( 374), FIX_INV_Q31( 375), FIX_INV_Q31( 376),
    FIX_INV_Q31( 377), FIX_INV_Q31( 378), FIX_INV_Q31( 379), FIX_INV_Q31( 380),
    FIX_INV_Q31( 381), FIX_INV_Q31( 382), FIX_INV_Q31( 383), FIX_INV_Q31( 384),
    FIX_INV_Q31( 385), FIX_INV_Q31( 386), FIX_INV_Q31( 387), FIX_INV_Q31( 388),
    FIX_INV_Q31( 389), FIX_INV_Q31( 390), FIX_INV_Q31( 391), FIX_INV_Q31( 392),
    FIX_INV_Q31( 393), FIX_INV_Q31( 394), FIX_INV_Q31( 395), FIX_INV_Q31( 396),
    FIX_INV_Q31( 397), FIX_INV_Q31( 398), FIX_INV_Q31( 399), FIX_INV_Q31( 400),
    FIX_INV_Q31( 401), FIX_INV_Q31( 402), FIX_INV_Q31( 403), FIX_INV_Q31( 404),
    FIX_INV_Q31( 405), FIX_INV_Q31( 406), FIX_INV_Q31( 407), FIX_INV_Q31( 408),
    FIX_INV_Q31( 409), FIX_INV_Q31( 410), FIX_INV_Q31( 411), FIX_INV_Q31( 412),
    FIX_INV_Q31( 413), FIX_INV_Q31( 414), FIX_INV_Q31( 415), FIX_INV_Q31( 416),
    FIX_INV_Q31( 417), FIX_INV_Q31( 418), FIX_INV_Q31( 419), FIX_INV_Q31( 420),
    FIX_INV_Q31( 421), FIX_INV_Q31( 422), FIX_INV_Q31( 423), FIX_INV_Q31( 424),
    FIX_INV_Q31( 425), FIX_INV_Q31( 426), FIX_INV_Q31( 427), FIX_INV_Q31( 428),
    FIX_INV_Q31( 429), FIX_INV_Q31( 430), FIX_INV_Q31( 431), FIX_INV_Q31( 432),
    FIX_INV_Q31( 433), FIX_INV_Q31( 434), FIX_INV_Q31( 435), FIX_INV_Q31( 436),
    FIX_INV_Q31( 437), FIX_INV_Q31( 438), FIX_INV_Q31( 439), FIX_INV_Q31( 440),
    FIX_INV_Q31( 441), FIX_INV_Q31( 442), FIX_INV_Q31( 443), FIX_INV_Q31( 444),
    FIX_INV_Q31( 445), FIX_INV_Q31( 446), FIX_INV_Q31( 447), FIX_INV_Q31( 448),
    FIX_INV_Q31( 449), FIX_INV_Q31( 450), FIX_INV_Q31( 451), FIX_INV_Q31( 452),
    FIX_INV_Q31( 453), FIX_INV_Q31( 454), FIX_INV_Q31( 455), FIX_INV_Q31( 456),
    FIX_INV_Q31( 457), FIX_INV_Q31( 458), FIX_INV_Q31( 459), FIX_INV_Q31( 460),
    FIX_INV_Q31( 461), FIX_INV_Q31( 462), FIX_INV_Q31( 463), FIX_INV_Q31( 464),
    FIX_INV_Q31( 465), FIX_INV_Q31( 466), FIX_INV_Q31( 467), FIX_INV_Q31( 468),
    FIX_INV_Q31( 469), FIX_INV_Q31( 470), FIX_INV_Q31( 471), FIX_INV_Q31( 472),
    FIX_INV_Q31( 473), FIX_INV_Q31( 474), FIX_INV_Q31( 475), FIX_INV_Q31( 476),
    FIX_INV_Q31( 477), FIX_INV_Q31( 478), FIX_INV_Q31( 479), FIX_INV_Q31( 480),
    FIX_INV_Q31( 481), FIX_INV_Q31( 482), FIX_INV_Q31( 483), FIX_INV_Q31( 484),
    FIX_INV_Q31( 485), FIX_INV_Q31( 486), FIX_INV_Q31( 487), FIX_INV_Q31( 488),
    FIX_INV_Q31( 489), FIX_INV_Q31( 490), FIX_INV_Q31( 491), FIX_INV_Q31( 492),
    FIX_INV_Q31( 493), FIX_INV_Q31( 494), FIX_INV_Q31( 495), FIX_INV_Q31( 496),
    FIX_INV_Q31( 497), FIX_INV_Q31( 498), FIX_INV_Q31( 499), FIX_INV_Q31( 500),
    FIX_INV_Q31( 501), FIX_INV_Q31( 502), FIX_INV_Q31( 503), FIX_INV_Q31( 504),
    FIX_INV_Q31( 505), FIX_INV_Q31( 506), FIX_INV_Q31( 507), FIX_INV_Q31( 508),
    FIX_INV_Q31( 509), FIX_INV_Q31( 510), FIX_INV_Q31( 511), FIX_INV_Q31( 512),
    FIX_INV_Q31( 513), FIX_INV_Q31( 514), FIX_INV_Q31( 515), FIX_INV_Q31( 516),
    FIX_INV_Q31( 517), FIX_INV_Q31( 518), FIX_INV_Q31( 519), FIX_INV_Q31( 520),
    FIX_INV_Q31( 521), FIX_INV_Q31( 522), FIX_INV_Q31( 523), FIX_INV_Q31( 524),
    FIX_INV_Q31( 525), FIX_INV_Q31( 526), FIX_INV_Q31( 527), FIX_INV_Q31( 528),
    FIX_INV_Q31( 529), FIX_INV_Q31( 530), FIX_INV_Q31( 531), FIX_INV_Q31( 532),
    FIX_INV_Q31( 533), FIX_INV_Q31( 534), FIX_INV_Q31( 535), FIX_INV_Q31( 536),
    FIX_INV_Q31( 537), FIX_INV_Q31( 538), FIX_INV_Q31( 539), FIX_INV_Q31( 540),
    FIX_INV_Q31( 541), FIX_INV_Q31( 542), FIX_INV_Q31( 543), FIX_INV_Q31( 544),
    FIX_INV_Q31( 545), FIX_INV_Q31( 546), FIX_INV_Q31( 547), FIX_INV_Q31( 548),
    FIX_INV_Q31( 549), FIX_INV_Q31( 550), FIX_INV_Q31( 551), FIX_INV_Q31( 552),
    FIX_INV_Q31( 553), FIX_INV_Q31( 554), FIX_INV_Q31( 555), FIX_INV_Q31( 556),
    FIX_INV_Q31( 557), FIX_INV_Q31( 558), FIX_INV_Q31( 559), FIX_INV_Q31( 560),
    FIX_INV_Q31( 561), FIX_INV_Q31( 562), FIX_INV_Q31( 563), FIX_INV_Q31( 564),
    FIX_INV_Q31( 565), FIX_INV_Q31( 566), FIX_INV_Q31( 567), FIX_INV_Q31( 568),
    FIX_INV_Q31( 569), FIX_INV_Q31( 570), FIX_INV_Q31( 571), FIX_INV_Q31( 572),
    FIX_INV_Q31( 573), FIX_INV_Q31( 574), FIX_INV_Q31( 575), FIX_INV_Q31( 576),
    FIX_INV_Q31( 577), FIX_INV_Q31( 578), FIX_INV_Q31( 579), FIX_INV_Q31( 580),
    FIX_INV_Q31( 581), FIX_INV_Q31( 582), FIX_INV_Q31( 583), FIX_INV_Q31( 584),
    FIX_INV_Q31( 585), FIX_INV_Q31( 586), FIX_INV_Q31( 587), FIX_INV_Q31( 588),
    FIX_INV_Q31( 589), FIX_INV_Q31( 590), FIX_INV_Q31( 591), FIX_INV_Q31( 592),
    FIX_INV_Q31( 593), FIX_INV_Q31( 594), FIX_INV_Q31( 595), FIX_INV_Q31( 596),
    FIX_INV_Q31( 597), FIX_INV_Q31( 598), FIX_INV_Q31( 599), FIX_INV_Q31( 600),
    FIX_INV_Q31( 601), FIX_INV_Q31( 602), FIX_INV_Q31( 603), FIX_INV_Q31( 604),
    FIX_INV_Q31( 605), FIX_INV_Q31( 606), FIX_INV_Q31( 607), FIX_INV_Q31( 608),
    FIX_INV_Q31( 609), FIX_INV_Q31( 610), FIX_INV_Q31( 611), FIX_INV_Q31( 612),
    FIX_INV_Q31( 613), FIX_INV_Q31( 614), FIX_INV_Q31( 615), FIX_INV_Q31( 616),
    FIX_INV_Q31( 617), FIX_INV_Q31( 618), FIX_INV_Q31( 619), FIX_INV_Q31( 620),
    FIX_INV_Q31( 621), FIX_INV_Q31( 622), FIX_INV_Q31( 623), FIX_INV_Q31( 624),
    FIX_INV_Q31( 625), FIX_INV_Q31( 626), FIX_INV_Q31( 627), FIX_INV_Q31( 628),
    FIX_INV_Q31( 629), FIX_INV_Q31( 630), FIX_INV_Q31( 631), FIX_INV_Q31( 632),
    FIX_INV_Q31( 633), FIX_INV_Q31( 634), FIX_INV_Q31( 635), FIX_INV_Q31( 636),
    FIX_INV_Q31( 637), FIX_INV_Q31( 638), FIX_INV_Q31( 639), FIX_INV_Q31( 640),
    FIX_INV_Q31( 641), FIX_INV_Q31( 642), FIX_INV_Q31( 643), FIX_INV_Q31( 644),
    FIX_INV_Q31( 645), FIX_INV_Q31( 646), FIX_INV_Q31( 647), FIX_INV_Q31( 648),
    FIX_INV_Q31( 649), FIX_INV_Q31( 650), FIX_INV_Q31( 651), FIX_INV_Q31( 652),
    FIX_INV_Q31( 653), FIX_INV_Q31( 654), FIX_INV_Q31( 655), FIX_INV_Q31( 656),
    FIX_INV_Q31( 657), FIX_INV_Q31( 658), FIX_INV_Q31( 659), FIX_INV_Q31( 660),
    FIX_INV_Q31( 661), FIX_INV_Q31( 662), FIX_INV_Q31( 663), FIX_INV_Q31( 664),
    FIX_INV_Q31( 665), FIX_INV_Q31( 666), FIX_INV_Q31( 667), FIX_INV_Q31( 668),
    FIX_INV_Q31( 669), FIX_INV_Q31( 670), FIX_INV_Q31( 671), FIX_INV_Q31( 672),
    FIX_INV_Q31( 673), FIX_INV_Q31( 674), FIX_INV_Q31( 675), FIX_INV_Q31( 676),
    FIX_INV_Q31( 677), FIX_INV_Q31( 678), FIX_INV_Q31( 679), FIX_INV_Q31( 680),
    FIX_INV_Q31( 681), FIX_INV_Q31( 682), FIX_INV_Q31( 683), FIX_INV_Q31( 684),
    FIX_INV_Q31( 685), FIX_INV_Q31( 686), FIX_INV_Q31( 687), FIX_INV_Q31( 688),
    FIX_INV_Q31( 689), FIX_INV_Q31( 690), FIX_INV_Q31( 691), FIX_INV_Q31( 692),
    FIX_INV_Q31( 693), FIX_INV_Q31( 694), FIX_INV_Q31( 695), FIX_INV_Q31( 696),
    FIX_INV_Q31( 697), FIX_INV_Q31( 698), FIX_INV_Q31( 699), FIX_INV_Q31( 700),
    FIX_INV_Q31( 701), FIX_INV_Q31( 702), FIX_INV_Q31( 703), FIX_INV_Q31( 704),
    FIX_INV_Q31( 705), FIX_INV_Q31( 706), FIX_INV_Q31( 707), FIX_INV_Q31( 708),
    FIX_INV_Q31( 709), FIX_INV_Q31( 710), FIX_INV_Q31( 711), FIX_INV_Q31( 712),
    FIX_INV_Q31( 713), FIX_INV_Q31( 714), FIX_INV_Q31( 715), FIX_INV_Q31( 716),
    FIX_INV_Q31( 717), FIX_INV_Q31( 718), FIX_INV_Q31( 719), FIX_INV_Q31( 720),
    FIX_INV_Q31( 721), FIX_INV_Q31( 722), FIX_INV_Q31( 723), FIX_INV_Q31( 724),
    FIX_INV_Q31( 725), FIX_INV_Q31( 726), FIX_INV_Q31( 727), FIX_INV_Q31( 728),
    FIX_INV_Q31( 729), FIX_INV_Q31( 730), FIX_INV_Q31( 731), FIX_INV_Q31( 732),
    FIX_INV_Q31( 733), FIX_INV_Q31( 734), FIX_INV_Q31( 735), FIX_INV_Q31( 736),
    FIX_INV_Q31( 737), FIX_INV_Q31( 738), FIX_INV_Q31( 739), FIX_INV_Q31( 740),
    FIX_INV_Q31( 741), FIX_INV_Q31( 742), FIX_INV_Q31( 743), FIX_INV_Q31( 744),
    FIX_INV_Q31( 745), FIX_INV_Q31( 746), FIX_INV_Q31( 747), FIX_INV_Q31( 748),
    FIX_INV_Q31( 749), FIX_INV_Q31( 750), FIX_INV_Q31( 751), FIX_INV_Q31( 752),
    FIX_INV_Q31( 753), FIX_INV_Q31( 754), FIX_INV_Q31( 755), FIX_INV_Q31( 756),
    FIX_INV_Q31( 757), FIX_INV_Q31( 758), FIX_INV_Q31( 759), FIX_INV_Q31( 760),
    FIX_INV_Q31( 761), FIX_INV_Q31( 762), FIX_INV_Q31( 763), FIX_INV_Q31( 764),
    FIX_INV_Q31( 765), FIX_INV_Q31( 766), FIX_INV_Q31( 767), FIX_INV_Q31( 768),
    FIX_INV_Q31( 769), FIX_INV_Q31( 770), FIX_INV_Q31( 771), FIX_INV_Q31( 772),
    FIX_INV_Q31( 773), FIX_INV_Q31( 774), FIX_INV_Q31( 775), FIX_INV_Q31( 776),
    FIX_INV_Q31( 777), FIX_INV_Q31( 778), FIX_INV_Q31( 779), FIX_INV_Q31( 780),
    FIX_INV_Q31( 781), FIX_INV_Q31( 782), FIX_INV_Q31( 783), FIX_INV_Q31( 784),
    FIX_INV_Q31( 785), FIX_INV_Q31( 786), FIX_INV_Q31( 787), FIX_INV_Q31( 788),
    FIX_INV_Q31( 789), FIX_INV_Q31( 790), FIX_INV_Q31( 791), FIX_INV_Q31( 792),
    FIX_INV_Q31( 793), FIX_INV_Q31( 794), FIX_INV_Q31( 795), FIX_INV_Q31( 796),
    FIX_INV_Q31( 797), FIX_INV_Q31( 798), FIX_INV_Q31( 799), FIX_INV_Q31( 800),
    FIX_INV_Q31( 801), FIX_INV_Q31( 802), FIX_INV_Q31( 803), FIX_INV_Q31( 804),
    FIX_INV_Q31( 805), FIX_INV_Q31( 806), FIX_INV_Q31( 807), FIX_INV_Q31( 808),
    FIX_INV_Q31( 809), FIX_INV_Q31( 810), FIX_INV_Q31( 811), FIX_INV_Q31( 812),
    FIX_INV_Q31( 813), FIX_INV_Q31( 814), FIX_INV_Q31( 815), FIX_INV_Q31( 816),
    FIX_INV_Q31( 817), FIX_INV_Q31( 818), FIX_INV_Q31( 819), FIX_INV_Q31( 820),
    FIX_INV_Q31( 821), FIX_INV_Q31( 822), FIX_INV_Q31( 823), FIX_INV_Q31( 824),
    FIX_INV_Q31( 825), FIX_INV_Q31( 826), FIX_INV_Q31( 827), FIX_INV_Q31( 828),
    FIX_INV_Q31( 829), FIX_INV_Q31( 830), FIX_INV_Q31( 831), FIX_INV_Q31( 832),
    FIX_INV_Q31( 833), FIX_INV_Q31( 834), FIX_INV_Q31( 835), FIX_INV_Q31( 836),
    FIX_INV_Q31( 837), FIX_INV_Q31( 838), FIX_INV_Q31( 839), FIX_INV_Q31( 840),
    FIX_INV_Q31( 841), FIX_INV_Q31( 842), FIX_INV_Q31( 843), FIX_INV_Q31( 844),
    FIX_INV_Q31( 845), FIX_INV_Q31( 846), FIX_INV_Q31( 847), FIX_INV_Q31( 848),
    FIX_INV_Q31( 849), FIX_INV_Q31( 850), FIX_INV_Q31( 851), FIX_INV_Q31( 852),
    FIX_INV_Q31( 853), FIX_INV_Q31( 854), FIX_INV_Q31( 855), FIX_INV_Q31( 856),
    FIX_INV_Q31( 857), FIX_INV_Q31( 858), FIX_INV_Q31( 859), FIX_INV_Q31( 860),
    FIX_INV_Q31( 861), FIX_INV_Q31( 862), FIX_INV_Q31( 863), FIX_INV_Q31( 864),
    FIX_INV_Q31( 865), FIX_INV_Q31( 866), FIX_INV_Q31( 867), FIX_INV_Q31( 868),
    FIX_INV_Q31( 869), FIX_INV_Q31( 870), FIX_INV_Q31( 871), FIX_INV_Q31( 872),
    FIX_INV_Q31( 873), FIX_INV_Q31( 874), FIX_INV_Q31( 875), FIX_INV_Q31( 876),
    FIX_INV_Q31( 877), FIX_INV_Q31( 878), FIX_INV_Q31( 879), FIX_INV_Q31( 880),
    FIX_INV_Q31( 881), FIX_INV_Q31( 882), FIX_INV_Q31( 883), FIX_INV_Q31( 884),
    FIX_INV_Q31( 885), FIX_INV_Q31( 886), FIX_INV_Q31( 887), FIX_INV_Q31( 888),
    FIX_INV_Q31( 889), FIX_INV_Q31( 890), FIX_INV_Q31( 891), FIX_INV_Q31( 892),
    FIX_INV_Q31( 893), FIX_INV_Q31( 894), FIX_INV_Q31( 895), FIX_INV_Q31( 896),
    FIX_INV_Q31( 897), FIX_INV_Q31( 898), FIX_INV_Q31( 899), FIX_INV_Q31( 900),
    FIX_INV_Q31( 901), FIX_INV_Q31( 902), FIX_INV_Q31( 903), FIX_INV_Q31( 904),
    FIX_INV_Q31( 905), FIX_INV_Q31( 906), FIX_INV_Q31( 907), FIX_INV_Q31( 908),
    FIX_INV_Q31( 909), FIX_INV_Q31( 910), FIX_INV_Q31( 911), FIX_INV_Q31( 912),
    FIX_INV_Q31( 913), FIX_INV_Q31( 914), FIX_INV_Q31( 915), FIX_INV_Q31( 916),
    FIX_INV_Q31( 917), FIX_INV_Q31( 918), FIX_INV_Q31( 919), FIX_INV_Q31( 920),
    FIX_INV_Q31( 921), FIX_INV_Q31( 922), FIX_INV_Q31( 923), FIX_INV_Q31( 924),
    FIX_INV_Q31( 925), FIX_INV_Q31( 926), FIX_INV_Q31( 927), FIX_INV_Q31( 928),
    FIX_INV_Q31( 929), FIX_INV_Q31( 930), FIX_INV_Q31( 931), FIX_INV_Q31( 932),
    FIX_INV_Q31( 933), FIX_INV_Q31( 934), FIX_INV_Q31( 935), FIX_INV_Q31( 936),
    FIX_INV_Q31( 937), FIX_INV_Q31( 938), FIX_INV_Q31( 939), FIX_INV_Q31( 940),
    FIX_INV_Q31( 941), FIX_INV_Q31( 942), FIX_INV_Q31( 943), FIX_INV_Q31( 944),
    FIX_INV_Q31( 945), FIX_INV_Q31( 946), FIX_INV_Q31( 947), FIX_INV_Q31( 948),
    FIX_INV_Q31( 949), FIX_INV_Q31( 950), FIX_INV_Q31( 951), FIX_INV_Q31( 952),
    FIX_INV_Q31( 953), FIX_INV_Q31( 954), FIX_INV_Q31( 955), FIX_INV_Q31( 956),
    FIX_INV_Q31( 957), FIX_INV_Q31( 958), FIX_INV_Q31( 959), FIX_INV_Q31( 960),
    FIX_INV_Q31( 961), FIX_INV_Q31( 962), FIX_INV_Q31( 963), FIX_INV_Q31( 964),
    FIX_INV_Q31( 965), FIX_INV_Q31( 966), FIX_INV_Q31( 967), FIX_INV_Q31( 968),
    FIX_INV_Q31( 969), FIX_INV_Q31( 970), FIX_INV_Q31( 971), FIX_INV_Q31( 972),
    FIX_INV_Q31( 973), FIX_INV_Q31( 974), FIX_INV_Q31( 975), FIX_INV_Q31( 976),
    FIX_INV_Q31( 977), FIX_INV_Q31( 978), FIX_INV_Q31( 979), FIX_INV_Q31( 980),
    FIX_INV_Q31( 981), FIX_INV_Q31( 982), FIX_INV_Q31( 983), FIX_INV_Q31( 984),
    FIX_INV_Q31( 985), FIX_INV_Q31( 986), FIX_INV_Q31( 987), FIX_INV_Q31( 988),
    FIX_INV_Q31( 989), FIX_INV_Q31( 990), FIX_INV_Q31( 991), FIX_INV_Q31( 992),
    FIX_INV_Q31( 993), FIX_INV_Q31( 994), FIX_INV_Q31( 995), FIX_INV_Q31( 996),
    FIX_INV_Q31( 997), FIX_INV_Q31( 998), FIX_INV_Q31( 999), FIX_INV_Q31(1000),
    FIX_INV_Q31(1001), FIX_INV_Q31(1002), FIX_INV_Q31(1003), FIX_INV_Q31(1004),
    FIX_INV_Q31(1005), FIX_INV_Q31(1006), FIX_INV_Q31(1007), FIX_INV_Q31(1008),
    FIX_INV_Q31(1009), FIX_INV_Q31(1010), FIX_INV_Q31(1011), FIX_INV_Q31(1012),
    FIX_INV_Q31(1013), FIX_INV_Q31(1014), FIX_INV_Q31(1015), FIX_INV_Q31(1016),
    FIX_INV_Q31(1017), FIX_INV_Q31(1018), FIX_INV_Q31(1019), FIX_INV_Q31(1020),
    FIX_INV_Q31(1021), FIX_INV_Q31(1022), FIX_INV_Q31(1023), FIX_INV_Q31(1024)
};
