/*
 * Copyright (c) 2014-2016, Freescale Semiconductor, Inc.
 * Copyright 2016 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

/*
 * Generated by erpcgen 1.12.0 on Wed Oct 25 10:00:57 2023.
 *
 * AUTOGENERATED - DO NOT EDIT
 */


#if ERPC_ALLOCATION_POLICY == ERPC_ALLOCATION_POLICY_DYNAMIC
#include "erpc_port.h"
#endif
#include "erpc_codec.hpp"
#include "erpc_matrix_multiply_client.hpp"
#include "erpc_manually_constructed.hpp"

#if 11200 != ERPC_VERSION_NUMBER
#error "The generated shim code version is different to the rest of eRPC code."
#endif

using namespace erpc;
using namespace std;
using namespace erpcShim;


// Constant variable definitions
#if defined(__MINGW32__)
__declspec( selectany )
#else
#pragma weak matrix_size
#endif
extern const int32_t matrix_size = 5;



MatrixMultiplyService_client::MatrixMultiplyService_client(ClientManager *manager)
:m_clientManager(manager)
{
}

MatrixMultiplyService_client::~MatrixMultiplyService_client()
{
}

// MatrixMultiplyService interface erpcMatrixMultiply function client shim.
void MatrixMultiplyService_client::erpcMatrixMultiply(Matrix matrix1, Matrix matrix2, Matrix result_matrix)
{
    erpc_status_t err = kErpcStatus_Success;


#if ERPC_PRE_POST_ACTION
    pre_post_action_cb preCB = m_clientManager->getPreCB();
    if (preCB)
    {
        preCB();
    }
#endif

    // Get a new request.
    RequestContext request = m_clientManager->createRequest(false);

    // Encode the request.
    Codec * codec = request.getCodec();

    if (codec == NULL)
    {
        err = kErpcStatus_MemoryError;
    }
    else
    {
        codec->startWriteMessage(message_type_t::kInvocationMessage, m_serviceId, m_erpcMatrixMultiplyId, request.getSequence());

        for (uint32_t arrayCount0 = 0U; arrayCount0 < 5U; ++arrayCount0)
        {
            for (uint32_t arrayCount1 = 0U; arrayCount1 < 5U; ++arrayCount1)
            {
                codec->write(matrix1[arrayCount0][arrayCount1]);
            }
        }

        for (uint32_t arrayCount0 = 0U; arrayCount0 < 5U; ++arrayCount0)
        {
            for (uint32_t arrayCount1 = 0U; arrayCount1 < 5U; ++arrayCount1)
            {
                codec->write(matrix2[arrayCount0][arrayCount1]);
            }
        }

        // Send message to server
        // Codec status is checked inside this function.
        m_clientManager->performRequest(request);

        for (uint32_t arrayCount0 = 0U; arrayCount0 < 5U; ++arrayCount0)
        {
            for (uint32_t arrayCount1 = 0U; arrayCount1 < 5U; ++arrayCount1)
            {
                codec->read(result_matrix[arrayCount0][arrayCount1]);
            }
        }

        err = codec->getStatus();
    }

    // Dispose of the request.
    m_clientManager->releaseRequest(request);

    // Invoke error handler callback function
    m_clientManager->callErrorHandler(err, m_erpcMatrixMultiplyId);

#if ERPC_PRE_POST_ACTION
    pre_post_action_cb postCB = m_clientManager->getPostCB();
    if (postCB)
    {
        postCB();
    }
#endif


    return;
}
