/*
 * Copyright (c) 2014-2016, Freescale Semiconductor, Inc.
 * Copyright 2016 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

/*
 * Generated by erpcgen 1.12.0 on Wed Oct 25 10:00:57 2023.
 *
 * AUTOGENERATED - DO NOT EDIT
 */


#include "erpc_matrix_multiply_server.hpp"
#if ERPC_ALLOCATION_POLICY == ERPC_ALLOCATION_POLICY_DYNAMIC
#include <new>
#include "erpc_port.h"
#endif
#include "erpc_manually_constructed.hpp"

#if 11200 != ERPC_VERSION_NUMBER
#error "The generated shim code version is different to the rest of eRPC code."
#endif

using namespace erpc;
using namespace std;
using namespace erpcShim;

#if ERPC_NESTED_CALLS_DETECTION
extern bool nestingDetection;
#endif



// Constant variable definitions
#if defined(__MINGW32__)
__declspec( selectany )
#else
#pragma weak matrix_size
#endif
extern const int32_t matrix_size = 5;


MatrixMultiplyService_service::MatrixMultiplyService_service(MatrixMultiplyService_interface *_MatrixMultiplyService_interface)
    : erpc::Service(MatrixMultiplyService_interface::m_serviceId)
    , m_handler(_MatrixMultiplyService_interface)
{
}

MatrixMultiplyService_service::~MatrixMultiplyService_service()
{
}

// return service interface handler.
MatrixMultiplyService_interface* MatrixMultiplyService_service::getHandler(void)
{
    return m_handler;
}

// Call the correct server shim based on method unique ID.
erpc_status_t MatrixMultiplyService_service::handleInvocation(uint32_t methodId, uint32_t sequence, Codec * codec, MessageBufferFactory *messageFactory, Transport * transport)
{
    erpc_status_t erpcStatus;
    switch (methodId)
    {
        case MatrixMultiplyService_interface::m_erpcMatrixMultiplyId:
        {
            erpcStatus = erpcMatrixMultiply_shim(codec, messageFactory, transport, sequence);
            break;
        }

        default:
        {
            erpcStatus = kErpcStatus_InvalidArgument;
            break;
        }
    }

    return erpcStatus;
}

// Server shim for erpcMatrixMultiply of MatrixMultiplyService interface.
erpc_status_t MatrixMultiplyService_service::erpcMatrixMultiply_shim(Codec * codec, MessageBufferFactory *messageFactory, Transport * transport, uint32_t sequence)
{
    erpc_status_t err = kErpcStatus_Success;

    Matrix matrix1;
    Matrix matrix2;
    Matrix result_matrix;

    // startReadMessage() was already called before this shim was invoked.

    for (uint32_t arrayCount0 = 0U; arrayCount0 < 5U; ++arrayCount0)
    {
        for (uint32_t arrayCount1 = 0U; arrayCount1 < 5U; ++arrayCount1)
        {
            codec->read(matrix1[arrayCount0][arrayCount1]);
        }
    }

    for (uint32_t arrayCount0 = 0U; arrayCount0 < 5U; ++arrayCount0)
    {
        for (uint32_t arrayCount1 = 0U; arrayCount1 < 5U; ++arrayCount1)
        {
            codec->read(matrix2[arrayCount0][arrayCount1]);
        }
    }

    err = codec->getStatus();
    if (err == kErpcStatus_Success)
    {
        // Invoke the actual served function.
#if ERPC_NESTED_CALLS_DETECTION
        nestingDetection = true;
#endif
        m_handler->erpcMatrixMultiply(matrix1, matrix2, result_matrix);
#if ERPC_NESTED_CALLS_DETECTION
        nestingDetection = false;
#endif

        // preparing MessageBuffer for serializing data
        err = messageFactory->prepareServerBufferForSend(codec->getBufferRef(), transport->reserveHeaderSize());
    }

    if (err == kErpcStatus_Success)
    {
        // preparing codec for serializing data
        codec->reset(transport->reserveHeaderSize());

        // Build response message.
        codec->startWriteMessage(message_type_t::kReplyMessage, MatrixMultiplyService_interface::m_serviceId, MatrixMultiplyService_interface::m_erpcMatrixMultiplyId, sequence);

        for (uint32_t arrayCount0 = 0U; arrayCount0 < 5U; ++arrayCount0)
        {
            for (uint32_t arrayCount1 = 0U; arrayCount1 < 5U; ++arrayCount1)
            {
                codec->write(result_matrix[arrayCount0][arrayCount1]);
            }
        }

        err = codec->getStatus();
    }

    return err;
}
