/*
 * Copyright 2018,2023 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

/*
 * Generated by erpcgen 1.12.0 on Wed Oct 25 10:00:57 2023.
 *
 * AUTOGENERATED - DO NOT EDIT
 */


#if ERPC_ALLOCATION_POLICY == ERPC_ALLOCATION_POLICY_DYNAMIC
#include "erpc_port.h"
#endif
#include "erpc_codec.hpp"
#include "erpc_two_way_rpc_Core0Interface_client.hpp"
#include "erpc_manually_constructed.hpp"

#if 11200 != ERPC_VERSION_NUMBER
#error "The generated shim code version is different to the rest of eRPC code."
#endif

using namespace erpc;
using namespace std;
using namespace erpcShim;



Core0Interface_client::Core0Interface_client(ClientManager *manager)
:m_clientManager(manager)
{
}

Core0Interface_client::~Core0Interface_client()
{
}

// Core0Interface interface setGetNumberFunction function client shim.
void Core0Interface_client::setGetNumberFunction(const getNumberCallback_t getNumberCallbackParam)
{
    erpc_status_t err = kErpcStatus_Success;


#if ERPC_PRE_POST_ACTION
    pre_post_action_cb preCB = m_clientManager->getPreCB();
    if (preCB)
    {
        preCB();
    }
#endif

    // Get a new request.
    RequestContext request = m_clientManager->createRequest(true);

    // Encode the request.
    Codec * codec = request.getCodec();

    if (codec == NULL)
    {
        err = kErpcStatus_MemoryError;
    }
    else
    {
        codec->startWriteMessage(message_type_t::kOnewayMessage, m_serviceId, m_setGetNumberFunctionId, request.getSequence());

        /* No need to serialize code for getNumberCallbackParam when only one cb exists. */
        // (void)Core0Interface_interface::get_callbackIdx_getNumberCallback_t(&getNumberCallbackParam, _tmp_local_u16);
        // codec->write(_tmp_local_u16);

        // Send message to server
        // Codec status is checked inside this function.
        m_clientManager->performRequest(request);

        err = codec->getStatus();
    }

    // Dispose of the request.
    m_clientManager->releaseRequest(request);

    // Invoke error handler callback function
    m_clientManager->callErrorHandler(err, m_setGetNumberFunctionId);

#if ERPC_PRE_POST_ACTION
    pre_post_action_cb postCB = m_clientManager->getPostCB();
    if (postCB)
    {
        postCB();
    }
#endif


    return;
}

// Core0Interface interface getGetNumberFunction function client shim.
void Core0Interface_client::getGetNumberFunction(getNumberCallback_t * getNumberCallbackParam)
{
    erpc_status_t err = kErpcStatus_Success;


#if ERPC_PRE_POST_ACTION
    pre_post_action_cb preCB = m_clientManager->getPreCB();
    if (preCB)
    {
        preCB();
    }
#endif

    // Get a new request.
    RequestContext request = m_clientManager->createRequest(false);

    // Encode the request.
    Codec * codec = request.getCodec();

    if (codec == NULL)
    {
        err = kErpcStatus_MemoryError;
    }
    else
    {
        codec->startWriteMessage(message_type_t::kInvocationMessage, m_serviceId, m_getGetNumberFunctionId, request.getSequence());

        // Send message to server
        // Codec status is checked inside this function.
        m_clientManager->performRequest(request);

        *getNumberCallbackParam = &Core0Interface_interface::getNumberFromCore1;

        err = codec->getStatus();
    }

    // Dispose of the request.
    m_clientManager->releaseRequest(request);

    // Invoke error handler callback function
    m_clientManager->callErrorHandler(err, m_getGetNumberFunctionId);

#if ERPC_PRE_POST_ACTION
    pre_post_action_cb postCB = m_clientManager->getPostCB();
    if (postCB)
    {
        postCB();
    }
#endif


    return;
}

// Core0Interface interface nestedCallGetNumber function client shim.
void Core0Interface_client::nestedCallGetNumber(const getNumberCallback_t getNumberCallbackParam)
{
    erpc_status_t err = kErpcStatus_Success;


#if ERPC_PRE_POST_ACTION
    pre_post_action_cb preCB = m_clientManager->getPreCB();
    if (preCB)
    {
        preCB();
    }
#endif

    // Get a new request.
    RequestContext request = m_clientManager->createRequest(false);

    // Encode the request.
    Codec * codec = request.getCodec();

    if (codec == NULL)
    {
        err = kErpcStatus_MemoryError;
    }
    else
    {
        codec->startWriteMessage(message_type_t::kInvocationMessage, m_serviceId, m_nestedCallGetNumberId, request.getSequence());

        /* No need to serialize code for getNumberCallbackParam when only one cb exists. */
        // (void)Core0Interface_interface::get_callbackIdx_getNumberCallback_t(&getNumberCallbackParam, _tmp_local_u16);
        // codec->write(_tmp_local_u16);

        // Send message to server
        // Codec status is checked inside this function.
        m_clientManager->performRequest(request);

        err = codec->getStatus();
    }

    // Dispose of the request.
    m_clientManager->releaseRequest(request);

    // Invoke error handler callback function
    m_clientManager->callErrorHandler(err, m_nestedCallGetNumberId);

#if ERPC_PRE_POST_ACTION
    pre_post_action_cb postCB = m_clientManager->getPostCB();
    if (postCB)
    {
        postCB();
    }
#endif


    return;
}

// Core0Interface interface getNumberFromCore1 function client shim.
void Core0Interface_client::getNumberFromCore1(uint32_t * number)
{
    erpc_status_t err = kErpcStatus_Success;


#if ERPC_PRE_POST_ACTION
    pre_post_action_cb preCB = m_clientManager->getPreCB();
    if (preCB)
    {
        preCB();
    }
#endif

    // Get a new request.
    RequestContext request = m_clientManager->createRequest(false);

    // Encode the request.
    Codec * codec = request.getCodec();

    if (codec == NULL)
    {
        err = kErpcStatus_MemoryError;
    }
    else
    {
        codec->startWriteMessage(message_type_t::kInvocationMessage, m_serviceId, m_getNumberFromCore1Id, request.getSequence());

        // Send message to server
        // Codec status is checked inside this function.
        m_clientManager->performRequest(request);

        codec->read(*number);

        err = codec->getStatus();
    }

    // Dispose of the request.
    m_clientManager->releaseRequest(request);

    // Invoke error handler callback function
    m_clientManager->callErrorHandler(err, m_getNumberFromCore1Id);

#if ERPC_PRE_POST_ACTION
    pre_post_action_cb postCB = m_clientManager->getPostCB();
    if (postCB)
    {
        postCB();
    }
#endif


    return;
}
