/*
 * Copyright 2018,2023 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

/*
 * Generated by erpcgen 1.12.0 on Wed Oct 25 10:00:57 2023.
 *
 * AUTOGENERATED - DO NOT EDIT
 */


#include "erpc_two_way_rpc_Core0Interface_server.hpp"
#if ERPC_ALLOCATION_POLICY == ERPC_ALLOCATION_POLICY_DYNAMIC
#include <new>
#include "erpc_port.h"
#endif
#include "erpc_manually_constructed.hpp"

#if 11200 != ERPC_VERSION_NUMBER
#error "The generated shim code version is different to the rest of eRPC code."
#endif

using namespace erpc;
using namespace std;
using namespace erpcShim;

#if ERPC_NESTED_CALLS_DETECTION
extern bool nestingDetection;
#endif



Core0Interface_service::Core0Interface_service(Core0Interface_interface *_Core0Interface_interface)
    : erpc::Service(Core0Interface_interface::m_serviceId)
    , m_handler(_Core0Interface_interface)
{
}

Core0Interface_service::~Core0Interface_service()
{
}

// return service interface handler.
Core0Interface_interface* Core0Interface_service::getHandler(void)
{
    return m_handler;
}

// Call the correct server shim based on method unique ID.
erpc_status_t Core0Interface_service::handleInvocation(uint32_t methodId, uint32_t sequence, Codec * codec, MessageBufferFactory *messageFactory, Transport * transport)
{
    erpc_status_t erpcStatus;
    switch (methodId)
    {
        case Core0Interface_interface::m_setGetNumberFunctionId:
        {
            erpcStatus = setGetNumberFunction_shim(codec, messageFactory, transport, sequence);
            break;
        }

        case Core0Interface_interface::m_getGetNumberFunctionId:
        {
            erpcStatus = getGetNumberFunction_shim(codec, messageFactory, transport, sequence);
            break;
        }

        case Core0Interface_interface::m_nestedCallGetNumberId:
        {
            erpcStatus = nestedCallGetNumber_shim(codec, messageFactory, transport, sequence);
            break;
        }

        case Core0Interface_interface::m_getNumberFromCore1Id:
        {
            erpcStatus = getNumberFromCore1_shim(codec, messageFactory, transport, sequence);
            break;
        }

        default:
        {
            erpcStatus = kErpcStatus_InvalidArgument;
            break;
        }
    }

    return erpcStatus;
}

// Server shim for setGetNumberFunction of Core0Interface interface.
erpc_status_t Core0Interface_service::setGetNumberFunction_shim(Codec * codec, MessageBufferFactory *messageFactory, Transport * transport, uint32_t sequence)
{
    erpc_status_t err = kErpcStatus_Success;

    Core0Interface_interface::getNumberCallback_t getNumberCallbackParam;

    // startReadMessage() was already called before this shim was invoked.

    getNumberCallbackParam = &Core0Interface_interface::getNumberFromCore1;

    err = codec->getStatus();
    if (err == kErpcStatus_Success)
    {
        // Invoke the actual served function.
#if ERPC_NESTED_CALLS_DETECTION
        nestingDetection = true;
#endif
        m_handler->setGetNumberFunction(getNumberCallbackParam);
#if ERPC_NESTED_CALLS_DETECTION
        nestingDetection = false;
#endif
    }

    return err;
}

// Server shim for getGetNumberFunction of Core0Interface interface.
erpc_status_t Core0Interface_service::getGetNumberFunction_shim(Codec * codec, MessageBufferFactory *messageFactory, Transport * transport, uint32_t sequence)
{
    erpc_status_t err = kErpcStatus_Success;

    Core0Interface_interface::getNumberCallback_t getNumberCallbackParam;

    // startReadMessage() was already called before this shim was invoked.

    err = codec->getStatus();
    if (err == kErpcStatus_Success)
    {
        // Invoke the actual served function.
#if ERPC_NESTED_CALLS_DETECTION
        nestingDetection = true;
#endif
        m_handler->getGetNumberFunction(&getNumberCallbackParam);
#if ERPC_NESTED_CALLS_DETECTION
        nestingDetection = false;
#endif

        // preparing MessageBuffer for serializing data
        err = messageFactory->prepareServerBufferForSend(codec->getBufferRef(), transport->reserveHeaderSize());
    }

    if (err == kErpcStatus_Success)
    {
        // preparing codec for serializing data
        codec->reset(transport->reserveHeaderSize());

        // Build response message.
        codec->startWriteMessage(message_type_t::kReplyMessage, Core0Interface_interface::m_serviceId, Core0Interface_interface::m_getGetNumberFunctionId, sequence);

        /* No need to serialize code for getNumberCallbackParam when only one cb exists. */
        // (void)Core0Interface_interface::get_callbackIdx_getNumberCallback_t(&getNumberCallbackParam, _tmp_local_u16);
        // codec->write(_tmp_local_u16);

        err = codec->getStatus();
    }

    return err;
}

// Server shim for nestedCallGetNumber of Core0Interface interface.
erpc_status_t Core0Interface_service::nestedCallGetNumber_shim(Codec * codec, MessageBufferFactory *messageFactory, Transport * transport, uint32_t sequence)
{
    erpc_status_t err = kErpcStatus_Success;

    Core0Interface_interface::getNumberCallback_t getNumberCallbackParam;

    // startReadMessage() was already called before this shim was invoked.

    getNumberCallbackParam = &Core0Interface_interface::getNumberFromCore1;

    err = codec->getStatus();
    if (err == kErpcStatus_Success)
    {
        // Invoke the actual served function.
#if ERPC_NESTED_CALLS_DETECTION
        nestingDetection = true;
#endif
        m_handler->nestedCallGetNumber(getNumberCallbackParam);
#if ERPC_NESTED_CALLS_DETECTION
        nestingDetection = false;
#endif

        // preparing MessageBuffer for serializing data
        err = messageFactory->prepareServerBufferForSend(codec->getBufferRef(), transport->reserveHeaderSize());
    }

    if (err == kErpcStatus_Success)
    {
        // preparing codec for serializing data
        codec->reset(transport->reserveHeaderSize());

        // Build response message.
        codec->startWriteMessage(message_type_t::kReplyMessage, Core0Interface_interface::m_serviceId, Core0Interface_interface::m_nestedCallGetNumberId, sequence);

        err = codec->getStatus();
    }

    return err;
}

// Server shim for getNumberFromCore1 of Core0Interface interface.
erpc_status_t Core0Interface_service::getNumberFromCore1_shim(Codec * codec, MessageBufferFactory *messageFactory, Transport * transport, uint32_t sequence)
{
    erpc_status_t err = kErpcStatus_Success;

    uint32_t number;

    // startReadMessage() was already called before this shim was invoked.

    err = codec->getStatus();
    if (err == kErpcStatus_Success)
    {
        // Invoke the actual served function.
#if ERPC_NESTED_CALLS_DETECTION
        nestingDetection = true;
#endif
        m_handler->getNumberFromCore1(&number);
#if ERPC_NESTED_CALLS_DETECTION
        nestingDetection = false;
#endif

        // preparing MessageBuffer for serializing data
        err = messageFactory->prepareServerBufferForSend(codec->getBufferRef(), transport->reserveHeaderSize());
    }

    if (err == kErpcStatus_Success)
    {
        // preparing codec for serializing data
        codec->reset(transport->reserveHeaderSize());

        // Build response message.
        codec->startWriteMessage(message_type_t::kReplyMessage, Core0Interface_interface::m_serviceId, Core0Interface_interface::m_getNumberFromCore1Id, sequence);

        codec->write(number);

        err = codec->getStatus();
    }

    return err;
}
