/*
 * RC4 stream cipher
 * Copyright (c) 2002-2005, Jouni Malinen <j@w1.fi>
 *
 * This software may be distributed under the terms of the BSD license.
 * See README for more details.
 */

#include "includes.h"

#include "utils/common.h"
#include "crypto.h"

#ifdef CONFIG_INTERNAL_RC4

#define S_SWAP(a, b) \
    do               \
    {                \
        u8 t = S[a]; \
        S[a] = S[b]; \
        S[b] = t;    \
    } while (0)

int rc4_skip(const u8 *key, size_t keylen, size_t skip, u8 *data, size_t data_len)
{
    u32 i, j, k;
    u8 S[256], *pos;
    size_t kpos;

    /* Setup RC4 state */
    for (i = 0; i < 256; i++)
        S[i] = i;
    j    = 0;
    kpos = 0;
    for (i = 0; i < 256; i++)
    {
        j = (j + S[i] + key[kpos]) & 0xff;
        kpos++;
        if (kpos >= keylen)
            kpos = 0;
        S_SWAP(i, j);
    }

    /* Skip the start of the stream */
    i = j = 0;
    for (k = 0; k < skip; k++)
    {
        i = (i + 1) & 0xff;
        j = (j + S[i]) & 0xff;
        S_SWAP(i, j);
    }

    /* Apply RC4 to data */
    pos = data;
    for (k = 0; k < data_len; k++)
    {
        i = (i + 1) & 0xff;
        j = (j + S[i]) & 0xff;
        S_SWAP(i, j);
        *pos++ ^= S[(S[i] + S[j]) & 0xff];
    }

    return 0;
}
#endif
