/*
 * Copyright 2020-2021 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

/***********************************************************************************************************************
 * This file was generated by the MCUXpresso Config Tools. Any manual edits made to this file
 * will be overwritten if the respective MCUXpresso Config Tools is used to update this file.
 **********************************************************************************************************************/

/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
!!GlobalInfo
product: Pins v9.0
processor: MIMXRT1176xxxxx
package_id: MIMXRT1176DVMAA
mcu_data: ksdk2_0
processor_version: 0.9.6
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */

#include "fsl_common.h"
#include "fsl_iomuxc.h"
#include "pin_mux.h"

/* FUNCTION ************************************************************************************************************
 * 
 * Function Name : BOARD_InitBootPins
 * Description   : Calls initialization functions.
 * 
 * END ****************************************************************************************************************/
void BOARD_InitBootPins(void) {
    BOARD_InitPins();
}

/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
BOARD_InitPins:
- options: {callFromInitBoot: 'true', coreID: cm7, enableClock: 'true'}
- pin_list:
  - {pin_num: F3, peripheral: SEMC, signal: 'DATA, 00', pin_signal: GPIO_EMC_B1_00, software_input_on: Disable, pull_down_pull_up_config: Pull_Down, pdrv_config: High_Driver,
    open_drain: Disable}
  - {pin_num: F2, peripheral: SEMC, signal: 'DATA, 01', pin_signal: GPIO_EMC_B1_01, software_input_on: Disable, pull_down_pull_up_config: Pull_Down, pdrv_config: High_Driver,
    open_drain: Disable}
  - {pin_num: G4, peripheral: SEMC, signal: 'DATA, 02', pin_signal: GPIO_EMC_B1_02, software_input_on: Disable, pull_down_pull_up_config: Pull_Down, pdrv_config: High_Driver,
    open_drain: Disable}
  - {pin_num: E4, peripheral: SEMC, signal: 'DATA, 03', pin_signal: GPIO_EMC_B1_03, software_input_on: Disable, pull_down_pull_up_config: Pull_Down, pdrv_config: High_Driver,
    open_drain: Disable}
  - {pin_num: H5, peripheral: SEMC, signal: 'DATA, 04', pin_signal: GPIO_EMC_B1_04, software_input_on: Disable, pull_down_pull_up_config: Pull_Down, pdrv_config: High_Driver,
    open_drain: Disable}
  - {pin_num: F4, peripheral: SEMC, signal: 'DATA, 05', pin_signal: GPIO_EMC_B1_05, software_input_on: Disable, pull_down_pull_up_config: Pull_Down, pdrv_config: High_Driver,
    open_drain: Disable}
  - {pin_num: H4, peripheral: SEMC, signal: 'DATA, 06', pin_signal: GPIO_EMC_B1_06, software_input_on: Disable, pull_down_pull_up_config: Pull_Down, pdrv_config: High_Driver,
    open_drain: Disable}
  - {pin_num: H3, peripheral: SEMC, signal: 'DATA, 07', pin_signal: GPIO_EMC_B1_07, software_input_on: Disable, pull_down_pull_up_config: Pull_Down, pdrv_config: High_Driver,
    open_drain: Disable}
  - {pin_num: K1, peripheral: SEMC, signal: semc_rdy, pin_signal: GPIO_EMC_B1_40, software_input_on: Disable, pull_down_pull_up_config: Pull_Down, pdrv_config: High_Driver,
    open_drain: Disable}
  - {pin_num: B4, peripheral: SEMC, signal: 'ADDR, 09', pin_signal: GPIO_EMC_B1_18, software_input_on: Disable, pull_down_pull_up_config: Pull_Down, pdrv_config: High_Driver,
    open_drain: Disable}
  - {pin_num: H2, peripheral: SEMC, signal: 'BA, 1', pin_signal: GPIO_EMC_B1_22, software_input_on: Disable, pull_down_pull_up_config: Pull_Down, pdrv_config: High_Driver,
    open_drain: Disable}
  - {pin_num: C4, peripheral: SEMC, signal: 'ADDR, 11', pin_signal: GPIO_EMC_B1_19, software_input_on: Disable, pull_down_pull_up_config: Pull_Down, pdrv_config: High_Driver,
    open_drain: Disable}
  - {pin_num: C3, peripheral: SEMC, signal: 'ADDR, 12', pin_signal: GPIO_EMC_B1_20, software_input_on: Disable, pull_down_pull_up_config: Pull_Down, pdrv_config: High_Driver,
    open_drain: Disable}
  - {pin_num: M15, peripheral: LPUART1, signal: RXD, pin_signal: GPIO_AD_25, software_input_on: Disable, open_drain: Disable}
  - {pin_num: L13, peripheral: LPUART1, signal: TXD, pin_signal: GPIO_AD_24, software_input_on: Disable, open_drain: Disable}
  - {pin_num: L1, peripheral: SEMC, signal: 'CSX, 0', pin_signal: GPIO_EMC_B1_41, software_input_on: Disable, pull_down_pull_up_config: Pull_Down, pdrv_config: High_Driver,
    open_drain: Disable}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitPins, assigned for the Cortex-M7F core.
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
void BOARD_InitPins(void) {
  CLOCK_EnableClock(kCLOCK_Iomuxc);           /* LPCG on: LPCG is ON. */

  IOMUXC_SetPinMux(
      IOMUXC_GPIO_AD_24_LPUART1_TXD,          /* GPIO_AD_24 is configured as LPUART1_TXD */
      0U);                                    /* Software Input On Field: Input Path is determined by functionality */
  IOMUXC_SetPinMux(
      IOMUXC_GPIO_AD_25_LPUART1_RXD,          /* GPIO_AD_25 is configured as LPUART1_RXD */
      0U);                                    /* Software Input On Field: Input Path is determined by functionality */
  IOMUXC_SetPinMux(
      IOMUXC_GPIO_EMC_B1_00_SEMC_DATA00,      /* GPIO_EMC_B1_00 is configured as SEMC_DATA00 */
      0U);                                    /* Software Input On Field: Input Path is determined by functionality */
  IOMUXC_SetPinMux(
      IOMUXC_GPIO_EMC_B1_01_SEMC_DATA01,      /* GPIO_EMC_B1_01 is configured as SEMC_DATA01 */
      0U);                                    /* Software Input On Field: Input Path is determined by functionality */
  IOMUXC_SetPinMux(
      IOMUXC_GPIO_EMC_B1_02_SEMC_DATA02,      /* GPIO_EMC_B1_02 is configured as SEMC_DATA02 */
      0U);                                    /* Software Input On Field: Input Path is determined by functionality */
  IOMUXC_SetPinMux(
      IOMUXC_GPIO_EMC_B1_03_SEMC_DATA03,      /* GPIO_EMC_B1_03 is configured as SEMC_DATA03 */
      0U);                                    /* Software Input On Field: Input Path is determined by functionality */
  IOMUXC_SetPinMux(
      IOMUXC_GPIO_EMC_B1_04_SEMC_DATA04,      /* GPIO_EMC_B1_04 is configured as SEMC_DATA04 */
      0U);                                    /* Software Input On Field: Input Path is determined by functionality */
  IOMUXC_SetPinMux(
      IOMUXC_GPIO_EMC_B1_05_SEMC_DATA05,      /* GPIO_EMC_B1_05 is configured as SEMC_DATA05 */
      0U);                                    /* Software Input On Field: Input Path is determined by functionality */
  IOMUXC_SetPinMux(
      IOMUXC_GPIO_EMC_B1_06_SEMC_DATA06,      /* GPIO_EMC_B1_06 is configured as SEMC_DATA06 */
      0U);                                    /* Software Input On Field: Input Path is determined by functionality */
  IOMUXC_SetPinMux(
      IOMUXC_GPIO_EMC_B1_07_SEMC_DATA07,      /* GPIO_EMC_B1_07 is configured as SEMC_DATA07 */
      0U);                                    /* Software Input On Field: Input Path is determined by functionality */
  IOMUXC_SetPinMux(
      IOMUXC_GPIO_EMC_B1_18_SEMC_ADDR09,      /* GPIO_EMC_B1_18 is configured as SEMC_ADDR09 */
      0U);                                    /* Software Input On Field: Input Path is determined by functionality */
  IOMUXC_SetPinMux(
      IOMUXC_GPIO_EMC_B1_19_SEMC_ADDR11,      /* GPIO_EMC_B1_19 is configured as SEMC_ADDR11 */
      0U);                                    /* Software Input On Field: Input Path is determined by functionality */
  IOMUXC_SetPinMux(
      IOMUXC_GPIO_EMC_B1_20_SEMC_ADDR12,      /* GPIO_EMC_B1_20 is configured as SEMC_ADDR12 */
      0U);                                    /* Software Input On Field: Input Path is determined by functionality */
  IOMUXC_SetPinMux(
      IOMUXC_GPIO_EMC_B1_22_SEMC_BA1,         /* GPIO_EMC_B1_22 is configured as SEMC_BA1 */
      0U);                                    /* Software Input On Field: Input Path is determined by functionality */
  IOMUXC_SetPinMux(
      IOMUXC_GPIO_EMC_B1_40_SEMC_RDY,         /* GPIO_EMC_B1_40 is configured as SEMC_RDY */
      0U);                                    /* Software Input On Field: Input Path is determined by functionality */
  IOMUXC_SetPinMux(
      IOMUXC_GPIO_EMC_B1_41_SEMC_CSX00,       /* GPIO_EMC_B1_41 is configured as SEMC_CSX00 */
      0U);                                    /* Software Input On Field: Input Path is determined by functionality */
  IOMUXC_SetPinConfig(
      IOMUXC_GPIO_AD_24_LPUART1_TXD,          /* GPIO_AD_24 PAD functional properties : */
      0x06U);                                 /* Slew Rate Field: Slow Slew Rate
                                                 Drive Strength Field: high drive strength
                                                 Pull / Keep Select Field: Pull Enable
                                                 Pull Up / Down Config. Field: Weak pull down
                                                 Open Drain Field: Disabled
                                                 Domain write protection: Both cores are allowed
                                                 Domain write protection lock: Neither of DWP bits is locked */
  IOMUXC_SetPinConfig(
      IOMUXC_GPIO_AD_25_LPUART1_RXD,          /* GPIO_AD_25 PAD functional properties : */
      0x06U);                                 /* Slew Rate Field: Slow Slew Rate
                                                 Drive Strength Field: high drive strength
                                                 Pull / Keep Select Field: Pull Enable
                                                 Pull Up / Down Config. Field: Weak pull down
                                                 Open Drain Field: Disabled
                                                 Domain write protection: Both cores are allowed
                                                 Domain write protection lock: Neither of DWP bits is locked */
  IOMUXC_SetPinConfig(
      IOMUXC_GPIO_EMC_B1_00_SEMC_DATA00,      /* GPIO_EMC_B1_00 PAD functional properties : */
      0x08U);                                 /* PDRV Field: high drive strength
                                                 Pull Down Pull Up Field: Internal pulldown resistor enabled
                                                 Open Drain Field: Disabled
                                                 Domain write protection: Both cores are allowed
                                                 Domain write protection lock: Neither of DWP bits is locked */
  IOMUXC_SetPinConfig(
      IOMUXC_GPIO_EMC_B1_01_SEMC_DATA01,      /* GPIO_EMC_B1_01 PAD functional properties : */
      0x08U);                                 /* PDRV Field: high drive strength
                                                 Pull Down Pull Up Field: Internal pulldown resistor enabled
                                                 Open Drain Field: Disabled
                                                 Domain write protection: Both cores are allowed
                                                 Domain write protection lock: Neither of DWP bits is locked */
  IOMUXC_SetPinConfig(
      IOMUXC_GPIO_EMC_B1_02_SEMC_DATA02,      /* GPIO_EMC_B1_02 PAD functional properties : */
      0x08U);                                 /* PDRV Field: high drive strength
                                                 Pull Down Pull Up Field: Internal pulldown resistor enabled
                                                 Open Drain Field: Disabled
                                                 Domain write protection: Both cores are allowed
                                                 Domain write protection lock: Neither of DWP bits is locked */
  IOMUXC_SetPinConfig(
      IOMUXC_GPIO_EMC_B1_03_SEMC_DATA03,      /* GPIO_EMC_B1_03 PAD functional properties : */
      0x08U);                                 /* PDRV Field: high drive strength
                                                 Pull Down Pull Up Field: Internal pulldown resistor enabled
                                                 Open Drain Field: Disabled
                                                 Domain write protection: Both cores are allowed
                                                 Domain write protection lock: Neither of DWP bits is locked */
  IOMUXC_SetPinConfig(
      IOMUXC_GPIO_EMC_B1_04_SEMC_DATA04,      /* GPIO_EMC_B1_04 PAD functional properties : */
      0x08U);                                 /* PDRV Field: high drive strength
                                                 Pull Down Pull Up Field: Internal pulldown resistor enabled
                                                 Open Drain Field: Disabled
                                                 Domain write protection: Both cores are allowed
                                                 Domain write protection lock: Neither of DWP bits is locked */
  IOMUXC_SetPinConfig(
      IOMUXC_GPIO_EMC_B1_05_SEMC_DATA05,      /* GPIO_EMC_B1_05 PAD functional properties : */
      0x08U);                                 /* PDRV Field: high drive strength
                                                 Pull Down Pull Up Field: Internal pulldown resistor enabled
                                                 Open Drain Field: Disabled
                                                 Domain write protection: Both cores are allowed
                                                 Domain write protection lock: Neither of DWP bits is locked */
  IOMUXC_SetPinConfig(
      IOMUXC_GPIO_EMC_B1_06_SEMC_DATA06,      /* GPIO_EMC_B1_06 PAD functional properties : */
      0x08U);                                 /* PDRV Field: high drive strength
                                                 Pull Down Pull Up Field: Internal pulldown resistor enabled
                                                 Open Drain Field: Disabled
                                                 Domain write protection: Both cores are allowed
                                                 Domain write protection lock: Neither of DWP bits is locked */
  IOMUXC_SetPinConfig(
      IOMUXC_GPIO_EMC_B1_07_SEMC_DATA07,      /* GPIO_EMC_B1_07 PAD functional properties : */
      0x08U);                                 /* PDRV Field: high drive strength
                                                 Pull Down Pull Up Field: Internal pulldown resistor enabled
                                                 Open Drain Field: Disabled
                                                 Domain write protection: Both cores are allowed
                                                 Domain write protection lock: Neither of DWP bits is locked */
  IOMUXC_SetPinConfig(
      IOMUXC_GPIO_EMC_B1_18_SEMC_ADDR09,      /* GPIO_EMC_B1_18 PAD functional properties : */
      0x08U);                                 /* PDRV Field: high drive strength
                                                 Pull Down Pull Up Field: Internal pulldown resistor enabled
                                                 Open Drain Field: Disabled
                                                 Domain write protection: Both cores are allowed
                                                 Domain write protection lock: Neither of DWP bits is locked */
  IOMUXC_SetPinConfig(
      IOMUXC_GPIO_EMC_B1_19_SEMC_ADDR11,      /* GPIO_EMC_B1_19 PAD functional properties : */
      0x08U);                                 /* PDRV Field: high drive strength
                                                 Pull Down Pull Up Field: Internal pulldown resistor enabled
                                                 Open Drain Field: Disabled
                                                 Domain write protection: Both cores are allowed
                                                 Domain write protection lock: Neither of DWP bits is locked */
  IOMUXC_SetPinConfig(
      IOMUXC_GPIO_EMC_B1_20_SEMC_ADDR12,      /* GPIO_EMC_B1_20 PAD functional properties : */
      0x08U);                                 /* PDRV Field: high drive strength
                                                 Pull Down Pull Up Field: Internal pulldown resistor enabled
                                                 Open Drain Field: Disabled
                                                 Domain write protection: Both cores are allowed
                                                 Domain write protection lock: Neither of DWP bits is locked */
  IOMUXC_SetPinConfig(
      IOMUXC_GPIO_EMC_B1_22_SEMC_BA1,         /* GPIO_EMC_B1_22 PAD functional properties : */
      0x08U);                                 /* PDRV Field: high drive strength
                                                 Pull Down Pull Up Field: Internal pulldown resistor enabled
                                                 Open Drain Field: Disabled
                                                 Domain write protection: Both cores are allowed
                                                 Domain write protection lock: Neither of DWP bits is locked */
  IOMUXC_SetPinConfig(
      IOMUXC_GPIO_EMC_B1_40_SEMC_RDY,         /* GPIO_EMC_B1_40 PAD functional properties : */
      0x08U);                                 /* PDRV Field: high drive strength
                                                 Pull Down Pull Up Field: Internal pulldown resistor enabled
                                                 Open Drain Field: Disabled
                                                 Domain write protection: Both cores are allowed
                                                 Domain write protection lock: Neither of DWP bits is locked */
  IOMUXC_SetPinConfig(
      IOMUXC_GPIO_EMC_B1_41_SEMC_CSX00,       /* GPIO_EMC_B1_41 PAD functional properties : */
      0x08U);                                 /* PDRV Field: high drive strength
                                                 Pull Down Pull Up Field: Internal pulldown resistor enabled
                                                 Open Drain Field: Disabled
                                                 Domain write protection: Both cores are allowed
                                                 Domain write protection lock: Neither of DWP bits is locked */
}

/***********************************************************************************************************************
 * EOF
 **********************************************************************************************************************/
