/*
 * Copyright 2020 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

/***********************************************************************************************************************
 * This file was generated by the MCUXpresso Config Tools. Any manual edits made to this file
 * will be overwritten if the respective MCUXpresso Config Tools is used to update this file.
 **********************************************************************************************************************/

/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
!!GlobalInfo
product: Pins v8.0
processor: MIMXRT1176xxxxx
package_id: MIMXRT1176DVMAA
mcu_data: ksdk2_0
processor_version: 9.0.1
pin_labels:
- {pin_num: T17, pin_signal: GPIO_AD_07, label: TP, identifier: TP}
- {pin_num: R15, pin_signal: GPIO_AD_08, label: TP, identifier: TP}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */

#include "fsl_common.h"
#include "fsl_xbara.h"
#include "fsl_iomuxc.h"
#include "fsl_gpio.h"
#include "pin_mux.h"

/* FUNCTION ************************************************************************************************************
 * 
 * Function Name : BOARD_InitBootPins
 * Description   : Calls initialization functions.
 * 
 * END ****************************************************************************************************************/
void BOARD_InitBootPins(void) {
    BOARD_InitPins();
    BOARD_InitLPUART();
    BOARD_InitPWM();
    BOARD_InitADC();
    BOARD_InitENC();
}

/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
BOARD_InitPins:
- options: {callFromInitBoot: 'true', coreID: cm7, enableClock: 'true'}
- pin_list:
  - {pin_num: R15, peripheral: GPIO9, signal: 'gpio_io, 07', pin_signal: GPIO_AD_08, direction: OUTPUT}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitPins, assigned for the Cortex-M7F core.
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
void BOARD_InitPins(void) {
  CLOCK_EnableClock(kCLOCK_Iomuxc);           /* LPCG on: LPCG is ON. */

  /* GPIO configuration of TP on GPIO_AD_08 (pin R15) */
  gpio_pin_config_t TP_config = {
      .direction = kGPIO_DigitalOutput,
      .outputLogic = 0U,
      .interruptMode = kGPIO_NoIntmode
  };
  /* Initialize GPIO functionality on GPIO_AD_08 (pin R15) */
  GPIO_PinInit(GPIO9, 7U, &TP_config);

  IOMUXC_SetPinMux(
      IOMUXC_GPIO_AD_08_GPIO9_IO07,           /* GPIO_AD_08 is configured as GPIO9_IO07 */
      0U);                                    /* Software Input On Field: Input Path is determined by functionality */
}


/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
BOARD_InitLPUART:
- options: {callFromInitBoot: 'true', coreID: cm7, enableClock: 'true'}
- pin_list:
  - {pin_num: M15, peripheral: LPUART1, signal: RXD, pin_signal: GPIO_AD_25}
  - {pin_num: L13, peripheral: LPUART1, signal: TXD, pin_signal: GPIO_AD_24}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitLPUART, assigned for the Cortex-M7F core.
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
void BOARD_InitLPUART(void) {
  CLOCK_EnableClock(kCLOCK_Iomuxc);           /* LPCG on: LPCG is ON. */

  IOMUXC_SetPinMux(
      IOMUXC_GPIO_AD_24_LPUART1_TXD,          /* GPIO_AD_24 is configured as LPUART1_TXD */
      0U);                                    /* Software Input On Field: Input Path is determined by functionality */
  IOMUXC_SetPinMux(
      IOMUXC_GPIO_AD_25_LPUART1_RXD,          /* GPIO_AD_25 is configured as LPUART1_RXD */
      0U);                                    /* Software Input On Field: Input Path is determined by functionality */
}


/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
BOARD_InitPWM:
- options: {callFromInitBoot: 'true', coreID: cm7, enableClock: 'true'}
- pin_list:
  - {pin_num: N12, peripheral: PWM1, signal: 'A, 0', pin_signal: GPIO_AD_00}
  - {pin_num: R14, peripheral: PWM1, signal: 'B, 0', pin_signal: GPIO_AD_01}
  - {pin_num: R13, peripheral: PWM1, signal: 'A, 1', pin_signal: GPIO_AD_02}
  - {pin_num: P15, peripheral: PWM1, signal: 'B, 1', pin_signal: GPIO_AD_03}
  - {pin_num: M13, peripheral: PWM1, signal: 'A, 2', pin_signal: GPIO_AD_04}
  - {pin_num: P13, peripheral: PWM1, signal: 'B, 2', pin_signal: GPIO_AD_05}
  - {peripheral: PWM1, signal: 'FAULT, 0', pin_signal: ACMP3_OUT}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitPWM, assigned for the Cortex-M7F core.
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
void BOARD_InitPWM(void) {
  CLOCK_EnableClock(kCLOCK_Iomuxc);           /* LPCG on: LPCG is ON. */
  CLOCK_EnableClock(kCLOCK_Xbar1);            /* LPCG on: LPCG is ON. */

  IOMUXC_SetPinMux(
      IOMUXC_GPIO_AD_00_FLEXPWM1_PWM0_A,      /* GPIO_AD_00 is configured as FLEXPWM1_PWM0_A */
      0U);                                    /* Software Input On Field: Input Path is determined by functionality */
  IOMUXC_SetPinMux(
      IOMUXC_GPIO_AD_01_FLEXPWM1_PWM0_B,      /* GPIO_AD_01 is configured as FLEXPWM1_PWM0_B */
      0U);                                    /* Software Input On Field: Input Path is determined by functionality */
  IOMUXC_SetPinMux(
      IOMUXC_GPIO_AD_02_FLEXPWM1_PWM1_A,      /* GPIO_AD_02 is configured as FLEXPWM1_PWM1_A */
      0U);                                    /* Software Input On Field: Input Path is determined by functionality */
  IOMUXC_SetPinMux(
      IOMUXC_GPIO_AD_03_FLEXPWM1_PWM1_B,      /* GPIO_AD_03 is configured as FLEXPWM1_PWM1_B */
      0U);                                    /* Software Input On Field: Input Path is determined by functionality */
  IOMUXC_SetPinMux(
      IOMUXC_GPIO_AD_04_FLEXPWM1_PWM2_A,      /* GPIO_AD_04 is configured as FLEXPWM1_PWM2_A */
      0U);                                    /* Software Input On Field: Input Path is determined by functionality */
  IOMUXC_SetPinMux(
      IOMUXC_GPIO_AD_05_FLEXPWM1_PWM2_B,      /* GPIO_AD_05 is configured as FLEXPWM1_PWM2_B */
      0U);                                    /* Software Input On Field: Input Path is determined by functionality */
  XBARA_SetSignalsConnection(XBARA1, kXBARA1_InputAcmp3Out, kXBARA1_OutputFlexpwm1Fault0); /* ACMP3_OUT output assigned to XBARA1_IN44 input is connected to XBARA1_OUT58 output assigned to FLEXPWM1_FAULT0 */
}


/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
BOARD_InitADC:
- options: {callFromInitBoot: 'true', coreID: cm7, enableClock: 'true'}
- pin_list:
  - {pin_num: R17, peripheral: LPADC1, signal: 'A, 1_2', pin_signal: GPIO_AD_10}
  - {pin_num: P16, peripheral: LPADC1, signal: 'B, 1_2', pin_signal: GPIO_AD_11}
  - {pin_num: P17, peripheral: LPADC1, signal: 'A, 1_3', pin_signal: GPIO_AD_12}
  - {pin_num: L12, peripheral: LPADC1, signal: 'B, 1_3', pin_signal: GPIO_AD_13}
  - {pin_num: P17, peripheral: LPADC2, signal: 'A, 2_3', pin_signal: GPIO_AD_12}
  - {pin_num: L12, peripheral: LPADC2, signal: 'B, 2_3', pin_signal: GPIO_AD_13}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitADC, assigned for the Cortex-M7F core.
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
void BOARD_InitADC(void) {
  CLOCK_EnableClock(kCLOCK_Iomuxc);           /* LPCG on: LPCG is ON. */

  IOMUXC_SetPinMux(
      IOMUXC_GPIO_AD_10_GPIO_MUX3_IO09,       /* GPIO_AD_10 is configured as GPIO_MUX3_IO09 */
      0U);                                    /* Software Input On Field: Input Path is determined by functionality */
  IOMUXC_SetPinMux(
      IOMUXC_GPIO_AD_11_GPIO_MUX3_IO10,       /* GPIO_AD_11 is configured as GPIO_MUX3_IO10 */
      0U);                                    /* Software Input On Field: Input Path is determined by functionality */
  IOMUXC_SetPinMux(
      IOMUXC_GPIO_AD_12_GPIO_MUX3_IO11,       /* GPIO_AD_12 is configured as GPIO_MUX3_IO11 */
      0U);                                    /* Software Input On Field: Input Path is determined by functionality */
  IOMUXC_SetPinMux(
      IOMUXC_GPIO_AD_13_GPIO_MUX3_IO12,       /* GPIO_AD_13 is configured as GPIO_MUX3_IO12 */
      0U);                                    /* Software Input On Field: Input Path is determined by functionality */
}


/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
BOARD_InitENC:
- options: {callFromInitBoot: 'true', coreID: cm7, enableClock: 'true'}
- pin_list:
  - {pin_num: D9, peripheral: ENC1, signal: 'PHASE, A', pin_signal: GPIO_DISP_B2_10}
  - {pin_num: A6, peripheral: ENC1, signal: 'PHASE, B', pin_signal: GPIO_DISP_B2_11}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitENC, assigned for the Cortex-M7F core.
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
void BOARD_InitENC(void) {
  CLOCK_EnableClock(kCLOCK_Iomuxc);           /* LPCG on: LPCG is ON. */
  CLOCK_EnableClock(kCLOCK_Xbar1);            /* LPCG on: LPCG is ON. */

  IOMUXC_SetPinMux(
      IOMUXC_GPIO_DISP_B2_10_XBAR1_INOUT38,   /* GPIO_DISP_B2_10 is configured as XBAR1_INOUT38 */
      0U);                                    /* Software Input On Field: Input Path is determined by functionality */
  IOMUXC_SetPinMux(
      IOMUXC_GPIO_DISP_B2_11_XBAR1_INOUT39,   /* GPIO_DISP_B2_11 is configured as XBAR1_INOUT39 */
      0U);                                    /* Software Input On Field: Input Path is determined by functionality */
  IOMUXC_GPR->GPR21 = ((IOMUXC_GPR->GPR21 &
    (~(IOMUXC_GPR_GPR21_IOMUXC_XBAR_DIR_SEL_38_MASK | IOMUXC_GPR_GPR21_IOMUXC_XBAR_DIR_SEL_39_MASK))) /* Mask bits to zero which are setting */
      | IOMUXC_GPR_GPR21_IOMUXC_XBAR_DIR_SEL_38(0x00U) /* IOMUXC XBAR_INOUT38 function direction select: 0x00U */
      | IOMUXC_GPR_GPR21_IOMUXC_XBAR_DIR_SEL_39(0x00U) /* IOMUXC XBAR_INOUT39 function direction select: 0x00U */
    );
  XBARA_SetSignalsConnection(XBARA1, kXBARA1_InputIomuxXbarInout38, kXBARA1_OutputDec1Phasea); /* IOMUX_XBAR_INOUT38 output assigned to XBARA1_IN38 input is connected to XBARA1_OUT108 output assigned to DEC1_PHASEA */
  XBARA_SetSignalsConnection(XBARA1, kXBARA1_InputIomuxXbarInout39, kXBARA1_OutputDec1Phaseb); /* IOMUX_XBAR_INOUT39 output assigned to XBARA1_IN39 input is connected to XBARA1_OUT109 output assigned to DEC1_PHASEB */
}


/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
BOARD_InitCMP:
- options: {callFromInitBoot: 'false', coreID: cm7, enableClock: 'true'}
- pin_list:
  - {pin_num: K17, peripheral: CMP3, signal: 'IN, 3', pin_signal: GPIO_AD_30}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitCMP, assigned for the Cortex-M7F core.
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
void BOARD_InitCMP(void) {
  CLOCK_EnableClock(kCLOCK_Iomuxc);           /* LPCG on: LPCG is ON. */

  IOMUXC_SetPinMux(
      IOMUXC_GPIO_AD_30_GPIO_MUX3_IO29,       /* GPIO_AD_30 is configured as GPIO_MUX3_IO29 */
      0U);                                    /* Software Input On Field: Input Path is determined by functionality */
}

/***********************************************************************************************************************
 * EOF
 **********************************************************************************************************************/
