/*
 * Copyright 2021 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */
#ifndef _ELCDIF_SUPPORT_H_
#define _ELCDIF_SUPPORT_H_

#include "fsl_mipi_dsi.h"

/*******************************************************************************
 * Definitions
 ******************************************************************************/
#define MIPI_PANEL_RK055AHD091        1   /* 720 * 1280 */
#define MIPI_PANEL_RK055IQH091        2   /* 540 * 960 */
#define MIPI_PANEL_RK055MHD091        3   /* 720 * 1280 */
#define MIPI_PANEL_RK043FN02HC        4   /* 480 * 272 */
#define MIPI_PANEL_KD050WVTPA045      5   /* 800 * 480 */
#define MIPI_PANEL_HDMI_720X480_60   10
#define MIPI_PANEL_HDMI_720X576_50   11
#define MIPI_PANEL_HDMI_800X480_60   12
#define MIPI_PANEL_HDMI_1024X768_60  13
#define MIPI_PANEL_HDMI_1280X720_60  14

#define APP_ELCDIF            LCDIF
#define APP_ELCDIF_IRQn       eLCDIF_IRQn
#define APP_ELCDIF_IRQHandler eLCDIF_IRQHandler

#ifndef USE_MIPI_PANEL
#define USE_MIPI_PANEL   MIPI_PANEL_HDMI_1024X768_60
#endif

#if (MIPI_PANEL_RK055AHD091 == USE_MIPI_PANEL)

  #define APP_PANEL_WIDTH  (720)
  #define APP_PANEL_HEIGHT (1280)
  #define APP_PANEL_NAME   "RK055AHD091"

  #define APP_HSW 8
  #define APP_HFP 32
  #define APP_HBP 32
  #define APP_VSW 2
  #define APP_VFP 16
  #define APP_VBP 14

#elif (MIPI_PANEL_RK055IQH091 == USE_MIPI_PANEL)

  #define APP_PANEL_WIDTH  (540)
  #define APP_PANEL_HEIGHT (960)
  #define APP_PANEL_NAME   "RK055IQH091"

  #define APP_HSW 2
  #define APP_HFP 32
  #define APP_HBP 30
  #define APP_VSW 2
  #define APP_VFP 16
  #define APP_VBP 14

#elif (MIPI_PANEL_RK055AHD091 == USE_MIPI_PANEL)

  #define APP_PANEL_WIDTH  (720)
  #define APP_PANEL_HEIGHT (1280)
  #define APP_PANEL_NAME   "RK055AHD091"

  #define APP_HSW 6
  #define APP_HFP 12
  #define APP_HBP 24
  #define APP_VSW 2
  #define APP_VFP 16
  #define APP_VBP 14

#elif (MIPI_PANEL_RK043FN02HC == USE_MIPI_PANEL)

  #define APP_PANEL_WIDTH  (480)
  #define APP_PANEL_HEIGHT (272)
  #define APP_PANEL_NAME   "RK043FN02HC"

  #define APP_HSW 2
  #define APP_HFP 32
  #define APP_HBP 30
  #define APP_VSW 2
  #define APP_VFP 16
  #define APP_VBP 14

#elif (MIPI_PANEL_KD050WVTPA045 == USE_MIPI_PANEL)

  #define APP_PANEL_WIDTH  (800)
  #define APP_PANEL_HEIGHT (480)
  #define APP_PANEL_NAME   "KD050WVTPA045"

  #define APP_HSW 48
  #define APP_HFP 40
  #define APP_HBP 40
  #define APP_VSW 3
  #define APP_VFP 141
  #define APP_VBP 29

#elif (MIPI_PANEL_HDMI_720X480_60 == USE_MIPI_PANEL)

  #define APP_PANEL_WIDTH  (720)
  #define APP_PANEL_HEIGHT (480)
  #define APP_PANEL_NAME   "HDMI_720X480_60"

  #define APP_HSW 62
  #define APP_HBP 60
  #define APP_HFP 16
  #define APP_VSW 6
  #define APP_VBP 30
  #define APP_VFP 9

  #define DEMO_VIDEO_FREQ_KHZ    594000
  #define DEMO_PIXEL_CLOCK_DIV   22
  #define DEMO_MIPI_DPY_REF_DIV  22

#elif (MIPI_PANEL_HDMI_720X576_50 == USE_MIPI_PANEL)

  #define APP_PANEL_WIDTH  (720)
  #define APP_PANEL_HEIGHT (576)
  #define APP_PANEL_NAME   "HDMI_720X576_50"

  #define APP_HSW 64
  #define APP_HBP 68
  #define APP_HFP 12
  #define APP_VSW 5
  #define APP_VBP 39
  #define APP_VFP 5

  #define DEMO_VIDEO_FREQ_KHZ    594000
  #define DEMO_PIXEL_CLOCK_DIV   22
  #define DEMO_MIPI_DPY_REF_DIV  22

#elif (MIPI_PANEL_HDMI_800X480_60 == USE_MIPI_PANEL)

  #define APP_PANEL_WIDTH  (800)
  #define APP_PANEL_HEIGHT (480)
  #define APP_PANEL_NAME   "HDMI_800X480_60"

  #define APP_HSW 20
  #define APP_HFP 70
  #define APP_HBP 26
  #define APP_VSW 2
  #define APP_VFP 7
  #define APP_VBP 21

  #define DEMO_VIDEO_FREQ_KHZ    594000
  #define DEMO_PIXEL_CLOCK_DIV   22
  #define DEMO_MIPI_DPY_REF_DIV  22

#elif (MIPI_PANEL_HDMI_1024X768_60 == USE_MIPI_PANEL)

  #define APP_PANEL_WIDTH  (1024)
  #define APP_PANEL_HEIGHT (768)
  #define APP_PANEL_NAME   "HDMI_1024X768_60"

  #define APP_HSW 136
  #define APP_HBP 160
  #define APP_HFP 24
  #define APP_VSW 6
  #define APP_VBP 29
  #define APP_VFP 3

  #define DEMO_VIDEO_FREQ_KHZ    260000
  #define DEMO_PIXEL_CLOCK_DIV   4
  #define DEMO_MIPI_DPY_REF_DIV  10

#elif (MIPI_PANEL_HDMI_1280X720_60 == USE_MIPI_PANEL)

  #define APP_PANEL_WIDTH  (1280)
  #define APP_PANEL_HEIGHT (720)
  #define APP_PANEL_NAME   "HDMI_1280X720_60"

  #define APP_HSW 40
  #define APP_HBP 220
  #define APP_HFP 110
  #define APP_VSW 5
  #define APP_VBP 20
  #define APP_VFP 5

  #define DEMO_VIDEO_FREQ_KHZ    594000
  #define DEMO_PIXEL_CLOCK_DIV   8
  #define DEMO_MIPI_DPY_REF_DIV  22

#else
  #error Must set USE_MIPI_PANEL to one of the valid MIPI_PANEL_* values
#endif

#define IS_HDMI_PANEL()  (USE_MIPI_PANEL >= 10)
#define USE_FT5406_TOUCH()      (MIPI_PANEL_RK043FN02HC == USE_MIPI_PANEL)
#define USE_GT911_TOUCH()       ((MIPI_PANEL_RK055AHD091 == USE_MIPI_PANEL) || (MIPI_PANEL_RK055IQH091 == USE_MIPI_PANEL) || (MIPI_PANEL_RK055MHD091 == USE_MIPI_PANEL))
#define IS_TOUCH_SUPPORTED()    (USE_FT5406_TOUCH() || USE_GT911_TOUCH())
#define IS_PARALLEL_RGB_PANEL() ((MIPI_PANEL_RK043FN02HC == USE_MIPI_PANEL) || (MIPI_PANEL_KD050WVTPA045 == USE_MIPI_PANEL))

#if (MIPI_PANEL_RK043FN02HC == USE_MIPI_PANEL)
  #define APP_POL_FLAGS \
    (kELCDIF_DataEnableActiveHigh | kELCDIF_VsyncActiveLow | kELCDIF_HsyncActiveLow | kELCDIF_DriveDataOnRisingClkEdge)
#else
  #define APP_POL_FLAGS \
    (kELCDIF_DataEnableActiveHigh | kELCDIF_VsyncActiveLow | kELCDIF_HsyncActiveLow | kELCDIF_DriveDataOnFallingClkEdge)
#endif

/* Frame buffer data alignment, for better performance, the LCDIF frame buffer should be 64B align. */
#define FRAME_BUFFER_ALIGN 64
#define APP_IMG_HEIGHT     APP_PANEL_HEIGHT
#define APP_IMG_WIDTH      APP_PANEL_WIDTH

extern const MIPI_DSI_Type g_mipiDsi;

/* Should call BOARD_InitDisplayInterface to initialize display interface. */
#define APP_ELCDIF_HAS_DISPLAY_INTERFACE 1

#if IS_PARALLEL_RGB_PANEL()
  /* When working with Parallel RGB, the output pixel is 16-bit pixel */
  #define APP_DATA_BUS       16
  #define APP_LCDIF_DATA_BUS kELCDIF_DataBus16Bit
#else
  /* When working with MIPI DSI, the output pixel is 24-bit pixel */
  #define APP_DATA_BUS       24
  #define APP_LCDIF_DATA_BUS kELCDIF_DataBus24Bit
#endif

/*******************************************************************************
 * Prototypes
 ******************************************************************************/
#if defined(__cplusplus)
extern "C" {
#endif /* __cplusplus */

status_t BOARD_InitDisplayInterface(void);
void BOARD_InitLcdifClock(void);

#if defined(__cplusplus)
}
#endif /* __cplusplus */

#endif /* _ELCDIF_SUPPORT_H_ */
