/*
 * Copyright 2020-2021 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

/***********************************************************************************************************************
 * This file was generated by the MCUXpresso Config Tools. Any manual edits made to this file
 * will be overwritten if the respective MCUXpresso Config Tools is used to update this file.
 **********************************************************************************************************************/

/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
!!GlobalInfo
product: Pins v9.0
processor: MIMXRT1176xxxxx
package_id: MIMXRT1176DVMAA
mcu_data: ksdk2_0
processor_version: 0.9.6
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */

#include "fsl_common.h"
#include "fsl_iomuxc.h"
#include "pin_mux.h"

/* FUNCTION ************************************************************************************************************
 * 
 * Function Name : BOARD_InitBootPins
 * Description   : Calls initialization functions.
 * 
 * END ****************************************************************************************************************/
void BOARD_InitBootPins(void) {
    BOARD_InitPins();
}

/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
BOARD_InitPins:
- options: {callFromInitBoot: 'true', coreID: cm7, enableClock: 'true'}
- pin_list:
  - {pin_num: M15, peripheral: LPUART1, signal: RXD, pin_signal: GPIO_AD_25, software_input_on: Disable, pull_up_down_config: Pull_Down, pull_keeper_select: Pull,
    open_drain: Disable, drive_strength: High, slew_rate: Slow}
  - {pin_num: L13, peripheral: LPUART1, signal: TXD, pin_signal: GPIO_AD_24, software_input_on: Disable, pull_up_down_config: Pull_Down, pull_keeper_select: Pull,
    open_drain: Disable, drive_strength: High, slew_rate: Slow}
  - {pin_num: F3, peripheral: SEMC, signal: 'DATA, 00', pin_signal: GPIO_EMC_B1_00, software_input_on: Disable, pull_down_pull_up_config: Pull_Down, pdrv_config: High_Driver,
    open_drain: Disable}
  - {pin_num: F2, peripheral: SEMC, signal: 'DATA, 01', pin_signal: GPIO_EMC_B1_01, software_input_on: Disable, pull_down_pull_up_config: Pull_Down, pdrv_config: High_Driver,
    open_drain: Disable}
  - {pin_num: G4, peripheral: SEMC, signal: 'DATA, 02', pin_signal: GPIO_EMC_B1_02, software_input_on: Disable, pull_down_pull_up_config: Pull_Down, pdrv_config: High_Driver,
    open_drain: Disable}
  - {pin_num: E4, peripheral: SEMC, signal: 'DATA, 03', pin_signal: GPIO_EMC_B1_03, software_input_on: Disable, pull_down_pull_up_config: Pull_Down, pdrv_config: High_Driver,
    open_drain: Disable}
  - {pin_num: H5, peripheral: SEMC, signal: 'DATA, 04', pin_signal: GPIO_EMC_B1_04, software_input_on: Disable, pull_down_pull_up_config: Pull_Down, pdrv_config: High_Driver,
    open_drain: Disable}
  - {pin_num: F4, peripheral: SEMC, signal: 'DATA, 05', pin_signal: GPIO_EMC_B1_05, software_input_on: Disable, pull_down_pull_up_config: Pull_Down, pdrv_config: High_Driver,
    open_drain: Disable}
  - {pin_num: H4, peripheral: SEMC, signal: 'DATA, 06', pin_signal: GPIO_EMC_B1_06, software_input_on: Disable, pull_down_pull_up_config: Pull_Down, pdrv_config: High_Driver,
    open_drain: Disable}
  - {pin_num: H3, peripheral: SEMC, signal: 'DATA, 07', pin_signal: GPIO_EMC_B1_07, software_input_on: Disable, pull_down_pull_up_config: Pull_Down, pdrv_config: High_Driver,
    open_drain: Disable}
  - {pin_num: E3, peripheral: SEMC, signal: 'DATA, 08', pin_signal: GPIO_EMC_B1_30, software_input_on: Disable, pull_down_pull_up_config: Pull_Down, pdrv_config: High_Driver,
    open_drain: Disable}
  - {pin_num: D2, peripheral: SEMC, signal: 'DATA, 09', pin_signal: GPIO_EMC_B1_31, software_input_on: Disable, pull_down_pull_up_config: Pull_Down, pdrv_config: High_Driver,
    open_drain: Disable}
  - {pin_num: D1, peripheral: SEMC, signal: 'DATA, 10', pin_signal: GPIO_EMC_B1_32, software_input_on: Disable, pull_down_pull_up_config: Pull_Down, pdrv_config: High_Driver,
    open_drain: Disable}
  - {pin_num: E2, peripheral: SEMC, signal: 'DATA, 11', pin_signal: GPIO_EMC_B1_33, software_input_on: Disable, pull_down_pull_up_config: Pull_Down, pdrv_config: High_Driver,
    open_drain: Disable}
  - {pin_num: E1, peripheral: SEMC, signal: 'DATA, 12', pin_signal: GPIO_EMC_B1_34, software_input_on: Disable, pull_down_pull_up_config: Pull_Down, pdrv_config: High_Driver,
    open_drain: Disable}
  - {pin_num: F1, peripheral: SEMC, signal: 'DATA, 13', pin_signal: GPIO_EMC_B1_35, software_input_on: Disable, pull_down_pull_up_config: Pull_Down, pdrv_config: High_Driver,
    open_drain: Disable}
  - {pin_num: G1, peripheral: SEMC, signal: 'DATA, 14', pin_signal: GPIO_EMC_B1_36, software_input_on: Disable, pull_down_pull_up_config: Pull_Down, pdrv_config: High_Driver,
    open_drain: Disable}
  - {pin_num: H1, peripheral: SEMC, signal: 'DATA, 15', pin_signal: GPIO_EMC_B1_37, software_input_on: Disable, pull_down_pull_up_config: Pull_Down, pdrv_config: High_Driver,
    open_drain: Disable}
  - {pin_num: A3, peripheral: SEMC, signal: 'ADDR, 00', pin_signal: GPIO_EMC_B1_09, software_input_on: Disable, pull_down_pull_up_config: Pull_Down, pdrv_config: High_Driver,
    open_drain: Disable}
  - {pin_num: A2, peripheral: SEMC, signal: 'ADDR, 01', pin_signal: GPIO_EMC_B1_10, software_input_on: Disable, pull_down_pull_up_config: Pull_Down, pdrv_config: High_Driver,
    open_drain: Disable}
  - {pin_num: C2, peripheral: SEMC, signal: 'ADDR, 02', pin_signal: GPIO_EMC_B1_11, software_input_on: Disable, pull_down_pull_up_config: Pull_Down, pdrv_config: High_Driver,
    open_drain: Disable}
  - {pin_num: C5, peripheral: SEMC, signal: 'ADDR, 03', pin_signal: GPIO_EMC_B1_12, software_input_on: Disable, pull_down_pull_up_config: Pull_Down, pdrv_config: High_Driver,
    open_drain: Disable}
  - {pin_num: D5, peripheral: SEMC, signal: 'ADDR, 04', pin_signal: GPIO_EMC_B1_13, software_input_on: Disable, pull_down_pull_up_config: Pull_Down, pdrv_config: High_Driver,
    open_drain: Disable}
  - {pin_num: B1, peripheral: SEMC, signal: 'ADDR, 05', pin_signal: GPIO_EMC_B1_14, software_input_on: Disable, pull_down_pull_up_config: Pull_Down, pdrv_config: High_Driver,
    open_drain: Disable}
  - {pin_num: C1, peripheral: SEMC, signal: 'ADDR, 06', pin_signal: GPIO_EMC_B1_15, software_input_on: Disable, pull_down_pull_up_config: Pull_Down, pdrv_config: High_Driver,
    open_drain: Disable}
  - {pin_num: D3, peripheral: SEMC, signal: 'ADDR, 07', pin_signal: GPIO_EMC_B1_16, software_input_on: Disable, pull_down_pull_up_config: Pull_Down, pdrv_config: High_Driver,
    open_drain: Disable}
  - {pin_num: B3, peripheral: SEMC, signal: 'ADDR, 08', pin_signal: GPIO_EMC_B1_17, software_input_on: Disable, pull_down_pull_up_config: Pull_Down, pdrv_config: High_Driver,
    open_drain: Disable}
  - {pin_num: B4, peripheral: SEMC, signal: 'ADDR, 09', pin_signal: GPIO_EMC_B1_18, software_input_on: Disable, pull_down_pull_up_config: Pull_Down, pdrv_config: High_Driver,
    open_drain: Disable}
  - {pin_num: B2, peripheral: SEMC, signal: 'ADDR, 10', pin_signal: GPIO_EMC_B1_23, software_input_on: Disable, pull_down_pull_up_config: Pull_Down, pdrv_config: High_Driver,
    open_drain: Disable}
  - {pin_num: C4, peripheral: SEMC, signal: 'ADDR, 11', pin_signal: GPIO_EMC_B1_19, software_input_on: Disable, pull_down_pull_up_config: Pull_Down, pdrv_config: High_Driver,
    open_drain: Disable}
  - {pin_num: C3, peripheral: SEMC, signal: 'ADDR, 12', pin_signal: GPIO_EMC_B1_20, software_input_on: Disable, pull_down_pull_up_config: Pull_Down, pdrv_config: High_Driver,
    open_drain: Disable}
  - {pin_num: G2, peripheral: SEMC, signal: 'BA, 0', pin_signal: GPIO_EMC_B1_21, software_input_on: Disable, pull_down_pull_up_config: Pull_Down, pdrv_config: High_Driver,
    open_drain: Disable}
  - {pin_num: H2, peripheral: SEMC, signal: 'BA, 1', pin_signal: GPIO_EMC_B1_22, software_input_on: Disable, pull_down_pull_up_config: Pull_Down, pdrv_config: High_Driver,
    open_drain: Disable}
  - {pin_num: J3, peripheral: SEMC, signal: semc_clk, pin_signal: GPIO_EMC_B1_26, software_input_on: Disable, pull_down_pull_up_config: Pull_Down, pdrv_config: High_Driver,
    open_drain: Disable}
  - {pin_num: E5, peripheral: SEMC, signal: semc_we, pin_signal: GPIO_EMC_B1_28, software_input_on: Disable, pull_down_pull_up_config: Pull_Down, pdrv_config: High_Driver,
    open_drain: Disable}
  - {pin_num: J5, peripheral: SEMC, signal: semc_cas, pin_signal: GPIO_EMC_B1_24, software_input_on: Disable, pull_down_pull_up_config: Pull_Down, pdrv_config: High_Driver,
    open_drain: Disable}
  - {pin_num: J4, peripheral: SEMC, signal: semc_ras, pin_signal: GPIO_EMC_B1_25, software_input_on: Disable, pull_down_pull_up_config: Pull_Down, pdrv_config: High_Driver,
    open_drain: Disable}
  - {pin_num: F5, peripheral: SEMC, signal: 'DM, 0', pin_signal: GPIO_EMC_B1_08, software_input_on: Disable, pull_down_pull_up_config: Pull_Down, pdrv_config: High_Driver,
    open_drain: Disable}
  - {pin_num: J1, peripheral: SEMC, signal: 'DM, 1', pin_signal: GPIO_EMC_B1_38, software_input_on: Disable, pull_down_pull_up_config: Pull_Down, pdrv_config: High_Driver,
    open_drain: Disable}
  - {pin_num: K2, peripheral: SEMC, signal: 'DATA, 16', pin_signal: GPIO_EMC_B2_00, software_input_on: Disable, pull_down_pull_up_config: Pull_Down, pdrv_config: High_Driver,
    open_drain: Disable}
  - {pin_num: K4, peripheral: SEMC, signal: 'DATA, 17', pin_signal: GPIO_EMC_B2_01, software_input_on: Disable, pull_down_pull_up_config: Pull_Down, pdrv_config: High_Driver,
    open_drain: Disable}
  - {pin_num: K3, peripheral: SEMC, signal: 'DATA, 18', pin_signal: GPIO_EMC_B2_02, software_input_on: Disable, pull_down_pull_up_config: Pull_Down, pdrv_config: High_Driver,
    open_drain: Disable}
  - {pin_num: R1, peripheral: SEMC, signal: 'DATA, 19', pin_signal: GPIO_EMC_B2_03, software_input_on: Disable, pull_down_pull_up_config: Pull_Down, pdrv_config: High_Driver,
    open_drain: Disable}
  - {pin_num: M1, peripheral: SEMC, signal: 'DATA, 20', pin_signal: GPIO_EMC_B2_04, software_input_on: Disable, pull_down_pull_up_config: Pull_Down, pdrv_config: High_Driver,
    open_drain: Disable}
  - {pin_num: N1, peripheral: SEMC, signal: 'DATA, 21', pin_signal: GPIO_EMC_B2_05, software_input_on: Disable, pull_down_pull_up_config: Pull_Down, pdrv_config: High_Driver,
    open_drain: Disable}
  - {pin_num: T1, peripheral: SEMC, signal: 'DATA, 22', pin_signal: GPIO_EMC_B2_06, software_input_on: Disable, pull_down_pull_up_config: Pull_Down, pdrv_config: High_Driver,
    open_drain: Disable}
  - {pin_num: M3, peripheral: SEMC, signal: 'DATA, 23', pin_signal: GPIO_EMC_B2_07, software_input_on: Disable, pull_down_pull_up_config: Pull_Down, pdrv_config: High_Driver,
    open_drain: Disable}
  - {pin_num: N2, peripheral: SEMC, signal: 'DATA, 24', pin_signal: GPIO_EMC_B2_09, software_input_on: Disable, pull_down_pull_up_config: Pull_Down, pdrv_config: High_Driver,
    open_drain: Disable}
  - {pin_num: R2, peripheral: SEMC, signal: 'DATA, 25', pin_signal: GPIO_EMC_B2_10, software_input_on: Disable, pull_down_pull_up_config: Pull_Down, pdrv_config: High_Driver,
    open_drain: Disable}
  - {pin_num: L4, peripheral: SEMC, signal: 'DATA, 26', pin_signal: GPIO_EMC_B2_11, software_input_on: Disable, pull_down_pull_up_config: Pull_Up, pdrv_config: High_Driver,
    open_drain: Disable}
  - {pin_num: M2, peripheral: SEMC, signal: 'DATA, 27', pin_signal: GPIO_EMC_B2_12, software_input_on: Disable, pull_down_pull_up_config: Pull_Down, pdrv_config: High_Driver,
    open_drain: Disable}
  - {pin_num: K5, peripheral: SEMC, signal: 'DATA, 28', pin_signal: GPIO_EMC_B2_13, software_input_on: Disable, pull_down_pull_up_config: Pull_Down, pdrv_config: High_Driver,
    open_drain: Disable}
  - {pin_num: M4, peripheral: SEMC, signal: 'DATA, 29', pin_signal: GPIO_EMC_B2_14, software_input_on: Disable, pull_down_pull_up_config: Pull_Down, pdrv_config: High_Driver,
    open_drain: Disable}
  - {pin_num: L2, peripheral: SEMC, signal: 'DATA, 30', pin_signal: GPIO_EMC_B2_15, software_input_on: Disable, pull_down_pull_up_config: Pull_Down, pdrv_config: High_Driver,
    open_drain: Disable}
  - {pin_num: P2, peripheral: SEMC, signal: 'DATA, 31', pin_signal: GPIO_EMC_B2_16, software_input_on: Disable, pull_down_pull_up_config: Pull_Down, pdrv_config: High_Driver,
    open_drain: Disable}
  - {pin_num: P1, peripheral: SEMC, signal: 'DM, 2', pin_signal: GPIO_EMC_B2_08, software_input_on: Disable, pull_down_pull_up_config: Pull_Up, pdrv_config: High_Driver,
    open_drain: Disable}
  - {pin_num: T2, peripheral: SEMC, signal: 'DM, 3', pin_signal: GPIO_EMC_B2_17, software_input_on: Disable, pull_down_pull_up_config: Pull_Down, pdrv_config: High_Driver,
    open_drain: Disable}
  - {pin_num: G5, peripheral: SEMC, signal: semc_cke, pin_signal: GPIO_EMC_B1_27, software_input_on: Disable, pull_down_pull_up_config: Pull_Down, pdrv_config: High_Driver,
    open_drain: Disable}
  - {pin_num: E6, peripheral: SEMC, signal: 'CS, 0', pin_signal: GPIO_EMC_B1_29, software_input_on: Disable, pull_down_pull_up_config: Pull_Down, pdrv_config: High_Driver,
    open_drain: Disable}
  - {pin_num: J2, peripheral: SEMC, signal: semc_dqs, pin_signal: GPIO_EMC_B1_39, software_input_on: Enable, pull_down_pull_up_config: Pull_Down, pdrv_config: High_Driver,
    open_drain: Disable}
  - {pin_num: K1, peripheral: SEMC, signal: semc_rdy, pin_signal: GPIO_EMC_B1_40, software_input_on: Disable, pull_down_pull_up_config: Pull_Down, pdrv_config: High_Driver,
    open_drain: Disable}
  - {pin_num: U2, peripheral: SEMC, signal: 'CLKX, 0', pin_signal: GPIO_EMC_B2_19, software_input_on: Disable, pull_down_pull_up_config: Pull_Down, pdrv_config: High_Driver,
    open_drain: Disable}
  - {pin_num: R3, peripheral: SEMC, signal: 'CLKX, 1', pin_signal: GPIO_EMC_B2_20, software_input_on: Disable, pull_down_pull_up_config: Pull_Down, pdrv_config: High_Driver,
    open_drain: Disable}
  - {pin_num: L1, peripheral: SEMC, signal: 'CSX, 0', pin_signal: GPIO_EMC_B1_41, software_input_on: Disable, pull_down_pull_up_config: Pull_Down, pdrv_config: High_Driver,
    open_drain: Disable}
  - {pin_num: N3, peripheral: SEMC, signal: semc_dqs4, pin_signal: GPIO_EMC_B2_18, software_input_on: Disable, pull_down_pull_up_config: Pull_Down, pdrv_config: High_Driver,
    open_drain: Disable}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitPins, assigned for the Cortex-M7F core.
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
void BOARD_InitPins(void) {
  CLOCK_EnableClock(kCLOCK_Iomuxc);           /* LPCG on: LPCG is ON. */

  IOMUXC_SetPinMux(
      IOMUXC_GPIO_AD_24_LPUART1_TXD,          /* GPIO_AD_24 is configured as LPUART1_TXD */
      0U);                                    /* Software Input On Field: Input Path is determined by functionality */
  IOMUXC_SetPinMux(
      IOMUXC_GPIO_AD_25_LPUART1_RXD,          /* GPIO_AD_25 is configured as LPUART1_RXD */
      0U);                                    /* Software Input On Field: Input Path is determined by functionality */
  IOMUXC_SetPinMux(
      IOMUXC_GPIO_EMC_B1_00_SEMC_DATA00,      /* GPIO_EMC_B1_00 is configured as SEMC_DATA00 */
      0U);                                    /* Software Input On Field: Input Path is determined by functionality */
  IOMUXC_SetPinMux(
      IOMUXC_GPIO_EMC_B1_01_SEMC_DATA01,      /* GPIO_EMC_B1_01 is configured as SEMC_DATA01 */
      0U);                                    /* Software Input On Field: Input Path is determined by functionality */
  IOMUXC_SetPinMux(
      IOMUXC_GPIO_EMC_B1_02_SEMC_DATA02,      /* GPIO_EMC_B1_02 is configured as SEMC_DATA02 */
      0U);                                    /* Software Input On Field: Input Path is determined by functionality */
  IOMUXC_SetPinMux(
      IOMUXC_GPIO_EMC_B1_03_SEMC_DATA03,      /* GPIO_EMC_B1_03 is configured as SEMC_DATA03 */
      0U);                                    /* Software Input On Field: Input Path is determined by functionality */
  IOMUXC_SetPinMux(
      IOMUXC_GPIO_EMC_B1_04_SEMC_DATA04,      /* GPIO_EMC_B1_04 is configured as SEMC_DATA04 */
      0U);                                    /* Software Input On Field: Input Path is determined by functionality */
  IOMUXC_SetPinMux(
      IOMUXC_GPIO_EMC_B1_05_SEMC_DATA05,      /* GPIO_EMC_B1_05 is configured as SEMC_DATA05 */
      0U);                                    /* Software Input On Field: Input Path is determined by functionality */
  IOMUXC_SetPinMux(
      IOMUXC_GPIO_EMC_B1_06_SEMC_DATA06,      /* GPIO_EMC_B1_06 is configured as SEMC_DATA06 */
      0U);                                    /* Software Input On Field: Input Path is determined by functionality */
  IOMUXC_SetPinMux(
      IOMUXC_GPIO_EMC_B1_07_SEMC_DATA07,      /* GPIO_EMC_B1_07 is configured as SEMC_DATA07 */
      0U);                                    /* Software Input On Field: Input Path is determined by functionality */
  IOMUXC_SetPinMux(
      IOMUXC_GPIO_EMC_B1_08_SEMC_DM00,        /* GPIO_EMC_B1_08 is configured as SEMC_DM00 */
      0U);                                    /* Software Input On Field: Input Path is determined by functionality */
  IOMUXC_SetPinMux(
      IOMUXC_GPIO_EMC_B1_09_SEMC_ADDR00,      /* GPIO_EMC_B1_09 is configured as SEMC_ADDR00 */
      0U);                                    /* Software Input On Field: Input Path is determined by functionality */
  IOMUXC_SetPinMux(
      IOMUXC_GPIO_EMC_B1_10_SEMC_ADDR01,      /* GPIO_EMC_B1_10 is configured as SEMC_ADDR01 */
      0U);                                    /* Software Input On Field: Input Path is determined by functionality */
  IOMUXC_SetPinMux(
      IOMUXC_GPIO_EMC_B1_11_SEMC_ADDR02,      /* GPIO_EMC_B1_11 is configured as SEMC_ADDR02 */
      0U);                                    /* Software Input On Field: Input Path is determined by functionality */
  IOMUXC_SetPinMux(
      IOMUXC_GPIO_EMC_B1_12_SEMC_ADDR03,      /* GPIO_EMC_B1_12 is configured as SEMC_ADDR03 */
      0U);                                    /* Software Input On Field: Input Path is determined by functionality */
  IOMUXC_SetPinMux(
      IOMUXC_GPIO_EMC_B1_13_SEMC_ADDR04,      /* GPIO_EMC_B1_13 is configured as SEMC_ADDR04 */
      0U);                                    /* Software Input On Field: Input Path is determined by functionality */
  IOMUXC_SetPinMux(
      IOMUXC_GPIO_EMC_B1_14_SEMC_ADDR05,      /* GPIO_EMC_B1_14 is configured as SEMC_ADDR05 */
      0U);                                    /* Software Input On Field: Input Path is determined by functionality */
  IOMUXC_SetPinMux(
      IOMUXC_GPIO_EMC_B1_15_SEMC_ADDR06,      /* GPIO_EMC_B1_15 is configured as SEMC_ADDR06 */
      0U);                                    /* Software Input On Field: Input Path is determined by functionality */
  IOMUXC_SetPinMux(
      IOMUXC_GPIO_EMC_B1_16_SEMC_ADDR07,      /* GPIO_EMC_B1_16 is configured as SEMC_ADDR07 */
      0U);                                    /* Software Input On Field: Input Path is determined by functionality */
  IOMUXC_SetPinMux(
      IOMUXC_GPIO_EMC_B1_17_SEMC_ADDR08,      /* GPIO_EMC_B1_17 is configured as SEMC_ADDR08 */
      0U);                                    /* Software Input On Field: Input Path is determined by functionality */
  IOMUXC_SetPinMux(
      IOMUXC_GPIO_EMC_B1_18_SEMC_ADDR09,      /* GPIO_EMC_B1_18 is configured as SEMC_ADDR09 */
      0U);                                    /* Software Input On Field: Input Path is determined by functionality */
  IOMUXC_SetPinMux(
      IOMUXC_GPIO_EMC_B1_19_SEMC_ADDR11,      /* GPIO_EMC_B1_19 is configured as SEMC_ADDR11 */
      0U);                                    /* Software Input On Field: Input Path is determined by functionality */
  IOMUXC_SetPinMux(
      IOMUXC_GPIO_EMC_B1_20_SEMC_ADDR12,      /* GPIO_EMC_B1_20 is configured as SEMC_ADDR12 */
      0U);                                    /* Software Input On Field: Input Path is determined by functionality */
  IOMUXC_SetPinMux(
      IOMUXC_GPIO_EMC_B1_21_SEMC_BA0,         /* GPIO_EMC_B1_21 is configured as SEMC_BA0 */
      0U);                                    /* Software Input On Field: Input Path is determined by functionality */
  IOMUXC_SetPinMux(
      IOMUXC_GPIO_EMC_B1_22_SEMC_BA1,         /* GPIO_EMC_B1_22 is configured as SEMC_BA1 */
      0U);                                    /* Software Input On Field: Input Path is determined by functionality */
  IOMUXC_SetPinMux(
      IOMUXC_GPIO_EMC_B1_23_SEMC_ADDR10,      /* GPIO_EMC_B1_23 is configured as SEMC_ADDR10 */
      0U);                                    /* Software Input On Field: Input Path is determined by functionality */
  IOMUXC_SetPinMux(
      IOMUXC_GPIO_EMC_B1_24_SEMC_CAS,         /* GPIO_EMC_B1_24 is configured as SEMC_CAS */
      0U);                                    /* Software Input On Field: Input Path is determined by functionality */
  IOMUXC_SetPinMux(
      IOMUXC_GPIO_EMC_B1_25_SEMC_RAS,         /* GPIO_EMC_B1_25 is configured as SEMC_RAS */
      0U);                                    /* Software Input On Field: Input Path is determined by functionality */
  IOMUXC_SetPinMux(
      IOMUXC_GPIO_EMC_B1_26_SEMC_CLK,         /* GPIO_EMC_B1_26 is configured as SEMC_CLK */
      0U);                                    /* Software Input On Field: Input Path is determined by functionality */
  IOMUXC_SetPinMux(
      IOMUXC_GPIO_EMC_B1_27_SEMC_CKE,         /* GPIO_EMC_B1_27 is configured as SEMC_CKE */
      0U);                                    /* Software Input On Field: Input Path is determined by functionality */
  IOMUXC_SetPinMux(
      IOMUXC_GPIO_EMC_B1_28_SEMC_WE,          /* GPIO_EMC_B1_28 is configured as SEMC_WE */
      0U);                                    /* Software Input On Field: Input Path is determined by functionality */
  IOMUXC_SetPinMux(
      IOMUXC_GPIO_EMC_B1_29_SEMC_CS0,         /* GPIO_EMC_B1_29 is configured as SEMC_CS0 */
      0U);                                    /* Software Input On Field: Input Path is determined by functionality */
  IOMUXC_SetPinMux(
      IOMUXC_GPIO_EMC_B1_30_SEMC_DATA08,      /* GPIO_EMC_B1_30 is configured as SEMC_DATA08 */
      0U);                                    /* Software Input On Field: Input Path is determined by functionality */
  IOMUXC_SetPinMux(
      IOMUXC_GPIO_EMC_B1_31_SEMC_DATA09,      /* GPIO_EMC_B1_31 is configured as SEMC_DATA09 */
      0U);                                    /* Software Input On Field: Input Path is determined by functionality */
  IOMUXC_SetPinMux(
      IOMUXC_GPIO_EMC_B1_32_SEMC_DATA10,      /* GPIO_EMC_B1_32 is configured as SEMC_DATA10 */
      0U);                                    /* Software Input On Field: Input Path is determined by functionality */
  IOMUXC_SetPinMux(
      IOMUXC_GPIO_EMC_B1_33_SEMC_DATA11,      /* GPIO_EMC_B1_33 is configured as SEMC_DATA11 */
      0U);                                    /* Software Input On Field: Input Path is determined by functionality */
  IOMUXC_SetPinMux(
      IOMUXC_GPIO_EMC_B1_34_SEMC_DATA12,      /* GPIO_EMC_B1_34 is configured as SEMC_DATA12 */
      0U);                                    /* Software Input On Field: Input Path is determined by functionality */
  IOMUXC_SetPinMux(
      IOMUXC_GPIO_EMC_B1_35_SEMC_DATA13,      /* GPIO_EMC_B1_35 is configured as SEMC_DATA13 */
      0U);                                    /* Software Input On Field: Input Path is determined by functionality */
  IOMUXC_SetPinMux(
      IOMUXC_GPIO_EMC_B1_36_SEMC_DATA14,      /* GPIO_EMC_B1_36 is configured as SEMC_DATA14 */
      0U);                                    /* Software Input On Field: Input Path is determined by functionality */
  IOMUXC_SetPinMux(
      IOMUXC_GPIO_EMC_B1_37_SEMC_DATA15,      /* GPIO_EMC_B1_37 is configured as SEMC_DATA15 */
      0U);                                    /* Software Input On Field: Input Path is determined by functionality */
  IOMUXC_SetPinMux(
      IOMUXC_GPIO_EMC_B1_38_SEMC_DM01,        /* GPIO_EMC_B1_38 is configured as SEMC_DM01 */
      0U);                                    /* Software Input On Field: Input Path is determined by functionality */
  IOMUXC_SetPinMux(
      IOMUXC_GPIO_EMC_B1_39_SEMC_DQS,         /* GPIO_EMC_B1_39 is configured as SEMC_DQS */
      1U);                                    /* Software Input On Field: Force input path of pad GPIO_EMC_B1_39 */
  IOMUXC_SetPinMux(
      IOMUXC_GPIO_EMC_B1_40_SEMC_RDY,         /* GPIO_EMC_B1_40 is configured as SEMC_RDY */
      0U);                                    /* Software Input On Field: Input Path is determined by functionality */
  IOMUXC_SetPinMux(
      IOMUXC_GPIO_EMC_B1_41_SEMC_CSX00,       /* GPIO_EMC_B1_41 is configured as SEMC_CSX00 */
      0U);                                    /* Software Input On Field: Input Path is determined by functionality */
  IOMUXC_SetPinMux(
      IOMUXC_GPIO_EMC_B2_00_SEMC_DATA16,      /* GPIO_EMC_B2_00 is configured as SEMC_DATA16 */
      0U);                                    /* Software Input On Field: Input Path is determined by functionality */
  IOMUXC_SetPinMux(
      IOMUXC_GPIO_EMC_B2_01_SEMC_DATA17,      /* GPIO_EMC_B2_01 is configured as SEMC_DATA17 */
      0U);                                    /* Software Input On Field: Input Path is determined by functionality */
  IOMUXC_SetPinMux(
      IOMUXC_GPIO_EMC_B2_02_SEMC_DATA18,      /* GPIO_EMC_B2_02 is configured as SEMC_DATA18 */
      0U);                                    /* Software Input On Field: Input Path is determined by functionality */
  IOMUXC_SetPinMux(
      IOMUXC_GPIO_EMC_B2_03_SEMC_DATA19,      /* GPIO_EMC_B2_03 is configured as SEMC_DATA19 */
      0U);                                    /* Software Input On Field: Input Path is determined by functionality */
  IOMUXC_SetPinMux(
      IOMUXC_GPIO_EMC_B2_04_SEMC_DATA20,      /* GPIO_EMC_B2_04 is configured as SEMC_DATA20 */
      0U);                                    /* Software Input On Field: Input Path is determined by functionality */
  IOMUXC_SetPinMux(
      IOMUXC_GPIO_EMC_B2_05_SEMC_DATA21,      /* GPIO_EMC_B2_05 is configured as SEMC_DATA21 */
      0U);                                    /* Software Input On Field: Input Path is determined by functionality */
  IOMUXC_SetPinMux(
      IOMUXC_GPIO_EMC_B2_06_SEMC_DATA22,      /* GPIO_EMC_B2_06 is configured as SEMC_DATA22 */
      0U);                                    /* Software Input On Field: Input Path is determined by functionality */
  IOMUXC_SetPinMux(
      IOMUXC_GPIO_EMC_B2_07_SEMC_DATA23,      /* GPIO_EMC_B2_07 is configured as SEMC_DATA23 */
      0U);                                    /* Software Input On Field: Input Path is determined by functionality */
  IOMUXC_SetPinMux(
      IOMUXC_GPIO_EMC_B2_08_SEMC_DM02,        /* GPIO_EMC_B2_08 is configured as SEMC_DM02 */
      0U);                                    /* Software Input On Field: Input Path is determined by functionality */
  IOMUXC_SetPinMux(
      IOMUXC_GPIO_EMC_B2_09_SEMC_DATA24,      /* GPIO_EMC_B2_09 is configured as SEMC_DATA24 */
      0U);                                    /* Software Input On Field: Input Path is determined by functionality */
  IOMUXC_SetPinMux(
      IOMUXC_GPIO_EMC_B2_10_SEMC_DATA25,      /* GPIO_EMC_B2_10 is configured as SEMC_DATA25 */
      0U);                                    /* Software Input On Field: Input Path is determined by functionality */
  IOMUXC_SetPinMux(
      IOMUXC_GPIO_EMC_B2_11_SEMC_DATA26,      /* GPIO_EMC_B2_11 is configured as SEMC_DATA26 */
      0U);                                    /* Software Input On Field: Input Path is determined by functionality */
  IOMUXC_SetPinMux(
      IOMUXC_GPIO_EMC_B2_12_SEMC_DATA27,      /* GPIO_EMC_B2_12 is configured as SEMC_DATA27 */
      0U);                                    /* Software Input On Field: Input Path is determined by functionality */
  IOMUXC_SetPinMux(
      IOMUXC_GPIO_EMC_B2_13_SEMC_DATA28,      /* GPIO_EMC_B2_13 is configured as SEMC_DATA28 */
      0U);                                    /* Software Input On Field: Input Path is determined by functionality */
  IOMUXC_SetPinMux(
      IOMUXC_GPIO_EMC_B2_14_SEMC_DATA29,      /* GPIO_EMC_B2_14 is configured as SEMC_DATA29 */
      0U);                                    /* Software Input On Field: Input Path is determined by functionality */
  IOMUXC_SetPinMux(
      IOMUXC_GPIO_EMC_B2_15_SEMC_DATA30,      /* GPIO_EMC_B2_15 is configured as SEMC_DATA30 */
      0U);                                    /* Software Input On Field: Input Path is determined by functionality */
  IOMUXC_SetPinMux(
      IOMUXC_GPIO_EMC_B2_16_SEMC_DATA31,      /* GPIO_EMC_B2_16 is configured as SEMC_DATA31 */
      0U);                                    /* Software Input On Field: Input Path is determined by functionality */
  IOMUXC_SetPinMux(
      IOMUXC_GPIO_EMC_B2_17_SEMC_DM03,        /* GPIO_EMC_B2_17 is configured as SEMC_DM03 */
      0U);                                    /* Software Input On Field: Input Path is determined by functionality */
  IOMUXC_SetPinMux(
      IOMUXC_GPIO_EMC_B2_18_SEMC_DQS4,        /* GPIO_EMC_B2_18 is configured as SEMC_DQS4 */
      0U);                                    /* Software Input On Field: Input Path is determined by functionality */
  IOMUXC_SetPinMux(
      IOMUXC_GPIO_EMC_B2_19_SEMC_CLKX00,      /* GPIO_EMC_B2_19 is configured as SEMC_CLKX00 */
      0U);                                    /* Software Input On Field: Input Path is determined by functionality */
  IOMUXC_SetPinMux(
      IOMUXC_GPIO_EMC_B2_20_SEMC_CLKX01,      /* GPIO_EMC_B2_20 is configured as SEMC_CLKX01 */
      0U);                                    /* Software Input On Field: Input Path is determined by functionality */
  IOMUXC_SetPinConfig(
      IOMUXC_GPIO_AD_24_LPUART1_TXD,          /* GPIO_AD_24 PAD functional properties : */
      0x06U);                                 /* Slew Rate Field: Slow Slew Rate
                                                 Drive Strength Field: high drive strength
                                                 Pull / Keep Select Field: Pull Enable
                                                 Pull Up / Down Config. Field: Weak pull down
                                                 Open Drain Field: Disabled
                                                 Domain write protection: Both cores are allowed
                                                 Domain write protection lock: Neither of DWP bits is locked */
  IOMUXC_SetPinConfig(
      IOMUXC_GPIO_AD_25_LPUART1_RXD,          /* GPIO_AD_25 PAD functional properties : */
      0x06U);                                 /* Slew Rate Field: Slow Slew Rate
                                                 Drive Strength Field: high drive strength
                                                 Pull / Keep Select Field: Pull Enable
                                                 Pull Up / Down Config. Field: Weak pull down
                                                 Open Drain Field: Disabled
                                                 Domain write protection: Both cores are allowed
                                                 Domain write protection lock: Neither of DWP bits is locked */
  IOMUXC_SetPinConfig(
      IOMUXC_GPIO_EMC_B1_00_SEMC_DATA00,      /* GPIO_EMC_B1_00 PAD functional properties : */
      0x08U);                                 /* PDRV Field: high drive strength
                                                 Pull Down Pull Up Field: Internal pulldown resistor enabled
                                                 Open Drain Field: Disabled
                                                 Domain write protection: Both cores are allowed
                                                 Domain write protection lock: Neither of DWP bits is locked */
  IOMUXC_SetPinConfig(
      IOMUXC_GPIO_EMC_B1_01_SEMC_DATA01,      /* GPIO_EMC_B1_01 PAD functional properties : */
      0x08U);                                 /* PDRV Field: high drive strength
                                                 Pull Down Pull Up Field: Internal pulldown resistor enabled
                                                 Open Drain Field: Disabled
                                                 Domain write protection: Both cores are allowed
                                                 Domain write protection lock: Neither of DWP bits is locked */
  IOMUXC_SetPinConfig(
      IOMUXC_GPIO_EMC_B1_02_SEMC_DATA02,      /* GPIO_EMC_B1_02 PAD functional properties : */
      0x08U);                                 /* PDRV Field: high drive strength
                                                 Pull Down Pull Up Field: Internal pulldown resistor enabled
                                                 Open Drain Field: Disabled
                                                 Domain write protection: Both cores are allowed
                                                 Domain write protection lock: Neither of DWP bits is locked */
  IOMUXC_SetPinConfig(
      IOMUXC_GPIO_EMC_B1_03_SEMC_DATA03,      /* GPIO_EMC_B1_03 PAD functional properties : */
      0x08U);                                 /* PDRV Field: high drive strength
                                                 Pull Down Pull Up Field: Internal pulldown resistor enabled
                                                 Open Drain Field: Disabled
                                                 Domain write protection: Both cores are allowed
                                                 Domain write protection lock: Neither of DWP bits is locked */
  IOMUXC_SetPinConfig(
      IOMUXC_GPIO_EMC_B1_04_SEMC_DATA04,      /* GPIO_EMC_B1_04 PAD functional properties : */
      0x08U);                                 /* PDRV Field: high drive strength
                                                 Pull Down Pull Up Field: Internal pulldown resistor enabled
                                                 Open Drain Field: Disabled
                                                 Domain write protection: Both cores are allowed
                                                 Domain write protection lock: Neither of DWP bits is locked */
  IOMUXC_SetPinConfig(
      IOMUXC_GPIO_EMC_B1_05_SEMC_DATA05,      /* GPIO_EMC_B1_05 PAD functional properties : */
      0x08U);                                 /* PDRV Field: high drive strength
                                                 Pull Down Pull Up Field: Internal pulldown resistor enabled
                                                 Open Drain Field: Disabled
                                                 Domain write protection: Both cores are allowed
                                                 Domain write protection lock: Neither of DWP bits is locked */
  IOMUXC_SetPinConfig(
      IOMUXC_GPIO_EMC_B1_06_SEMC_DATA06,      /* GPIO_EMC_B1_06 PAD functional properties : */
      0x08U);                                 /* PDRV Field: high drive strength
                                                 Pull Down Pull Up Field: Internal pulldown resistor enabled
                                                 Open Drain Field: Disabled
                                                 Domain write protection: Both cores are allowed
                                                 Domain write protection lock: Neither of DWP bits is locked */
  IOMUXC_SetPinConfig(
      IOMUXC_GPIO_EMC_B1_07_SEMC_DATA07,      /* GPIO_EMC_B1_07 PAD functional properties : */
      0x08U);                                 /* PDRV Field: high drive strength
                                                 Pull Down Pull Up Field: Internal pulldown resistor enabled
                                                 Open Drain Field: Disabled
                                                 Domain write protection: Both cores are allowed
                                                 Domain write protection lock: Neither of DWP bits is locked */
  IOMUXC_SetPinConfig(
      IOMUXC_GPIO_EMC_B1_08_SEMC_DM00,        /* GPIO_EMC_B1_08 PAD functional properties : */
      0x08U);                                 /* PDRV Field: high drive strength
                                                 Pull Down Pull Up Field: Internal pulldown resistor enabled
                                                 Open Drain Field: Disabled
                                                 Domain write protection: Both cores are allowed
                                                 Domain write protection lock: Neither of DWP bits is locked */
  IOMUXC_SetPinConfig(
      IOMUXC_GPIO_EMC_B1_09_SEMC_ADDR00,      /* GPIO_EMC_B1_09 PAD functional properties : */
      0x08U);                                 /* PDRV Field: high drive strength
                                                 Pull Down Pull Up Field: Internal pulldown resistor enabled
                                                 Open Drain Field: Disabled
                                                 Domain write protection: Both cores are allowed
                                                 Domain write protection lock: Neither of DWP bits is locked */
  IOMUXC_SetPinConfig(
      IOMUXC_GPIO_EMC_B1_10_SEMC_ADDR01,      /* GPIO_EMC_B1_10 PAD functional properties : */
      0x08U);                                 /* PDRV Field: high drive strength
                                                 Pull Down Pull Up Field: Internal pulldown resistor enabled
                                                 Open Drain Field: Disabled
                                                 Domain write protection: Both cores are allowed
                                                 Domain write protection lock: Neither of DWP bits is locked */
  IOMUXC_SetPinConfig(
      IOMUXC_GPIO_EMC_B1_11_SEMC_ADDR02,      /* GPIO_EMC_B1_11 PAD functional properties : */
      0x08U);                                 /* PDRV Field: high drive strength
                                                 Pull Down Pull Up Field: Internal pulldown resistor enabled
                                                 Open Drain Field: Disabled
                                                 Domain write protection: Both cores are allowed
                                                 Domain write protection lock: Neither of DWP bits is locked */
  IOMUXC_SetPinConfig(
      IOMUXC_GPIO_EMC_B1_12_SEMC_ADDR03,      /* GPIO_EMC_B1_12 PAD functional properties : */
      0x08U);                                 /* PDRV Field: high drive strength
                                                 Pull Down Pull Up Field: Internal pulldown resistor enabled
                                                 Open Drain Field: Disabled
                                                 Domain write protection: Both cores are allowed
                                                 Domain write protection lock: Neither of DWP bits is locked */
  IOMUXC_SetPinConfig(
      IOMUXC_GPIO_EMC_B1_13_SEMC_ADDR04,      /* GPIO_EMC_B1_13 PAD functional properties : */
      0x08U);                                 /* PDRV Field: high drive strength
                                                 Pull Down Pull Up Field: Internal pulldown resistor enabled
                                                 Open Drain Field: Disabled
                                                 Domain write protection: Both cores are allowed
                                                 Domain write protection lock: Neither of DWP bits is locked */
  IOMUXC_SetPinConfig(
      IOMUXC_GPIO_EMC_B1_14_SEMC_ADDR05,      /* GPIO_EMC_B1_14 PAD functional properties : */
      0x08U);                                 /* PDRV Field: high drive strength
                                                 Pull Down Pull Up Field: Internal pulldown resistor enabled
                                                 Open Drain Field: Disabled
                                                 Domain write protection: Both cores are allowed
                                                 Domain write protection lock: Neither of DWP bits is locked */
  IOMUXC_SetPinConfig(
      IOMUXC_GPIO_EMC_B1_15_SEMC_ADDR06,      /* GPIO_EMC_B1_15 PAD functional properties : */
      0x08U);                                 /* PDRV Field: high drive strength
                                                 Pull Down Pull Up Field: Internal pulldown resistor enabled
                                                 Open Drain Field: Disabled
                                                 Domain write protection: Both cores are allowed
                                                 Domain write protection lock: Neither of DWP bits is locked */
  IOMUXC_SetPinConfig(
      IOMUXC_GPIO_EMC_B1_16_SEMC_ADDR07,      /* GPIO_EMC_B1_16 PAD functional properties : */
      0x08U);                                 /* PDRV Field: high drive strength
                                                 Pull Down Pull Up Field: Internal pulldown resistor enabled
                                                 Open Drain Field: Disabled
                                                 Domain write protection: Both cores are allowed
                                                 Domain write protection lock: Neither of DWP bits is locked */
  IOMUXC_SetPinConfig(
      IOMUXC_GPIO_EMC_B1_17_SEMC_ADDR08,      /* GPIO_EMC_B1_17 PAD functional properties : */
      0x08U);                                 /* PDRV Field: high drive strength
                                                 Pull Down Pull Up Field: Internal pulldown resistor enabled
                                                 Open Drain Field: Disabled
                                                 Domain write protection: Both cores are allowed
                                                 Domain write protection lock: Neither of DWP bits is locked */
  IOMUXC_SetPinConfig(
      IOMUXC_GPIO_EMC_B1_18_SEMC_ADDR09,      /* GPIO_EMC_B1_18 PAD functional properties : */
      0x08U);                                 /* PDRV Field: high drive strength
                                                 Pull Down Pull Up Field: Internal pulldown resistor enabled
                                                 Open Drain Field: Disabled
                                                 Domain write protection: Both cores are allowed
                                                 Domain write protection lock: Neither of DWP bits is locked */
  IOMUXC_SetPinConfig(
      IOMUXC_GPIO_EMC_B1_19_SEMC_ADDR11,      /* GPIO_EMC_B1_19 PAD functional properties : */
      0x08U);                                 /* PDRV Field: high drive strength
                                                 Pull Down Pull Up Field: Internal pulldown resistor enabled
                                                 Open Drain Field: Disabled
                                                 Domain write protection: Both cores are allowed
                                                 Domain write protection lock: Neither of DWP bits is locked */
  IOMUXC_SetPinConfig(
      IOMUXC_GPIO_EMC_B1_20_SEMC_ADDR12,      /* GPIO_EMC_B1_20 PAD functional properties : */
      0x08U);                                 /* PDRV Field: high drive strength
                                                 Pull Down Pull Up Field: Internal pulldown resistor enabled
                                                 Open Drain Field: Disabled
                                                 Domain write protection: Both cores are allowed
                                                 Domain write protection lock: Neither of DWP bits is locked */
  IOMUXC_SetPinConfig(
      IOMUXC_GPIO_EMC_B1_21_SEMC_BA0,         /* GPIO_EMC_B1_21 PAD functional properties : */
      0x08U);                                 /* PDRV Field: high drive strength
                                                 Pull Down Pull Up Field: Internal pulldown resistor enabled
                                                 Open Drain Field: Disabled
                                                 Domain write protection: Both cores are allowed
                                                 Domain write protection lock: Neither of DWP bits is locked */
  IOMUXC_SetPinConfig(
      IOMUXC_GPIO_EMC_B1_22_SEMC_BA1,         /* GPIO_EMC_B1_22 PAD functional properties : */
      0x08U);                                 /* PDRV Field: high drive strength
                                                 Pull Down Pull Up Field: Internal pulldown resistor enabled
                                                 Open Drain Field: Disabled
                                                 Domain write protection: Both cores are allowed
                                                 Domain write protection lock: Neither of DWP bits is locked */
  IOMUXC_SetPinConfig(
      IOMUXC_GPIO_EMC_B1_23_SEMC_ADDR10,      /* GPIO_EMC_B1_23 PAD functional properties : */
      0x08U);                                 /* PDRV Field: high drive strength
                                                 Pull Down Pull Up Field: Internal pulldown resistor enabled
                                                 Open Drain Field: Disabled
                                                 Domain write protection: Both cores are allowed
                                                 Domain write protection lock: Neither of DWP bits is locked */
  IOMUXC_SetPinConfig(
      IOMUXC_GPIO_EMC_B1_24_SEMC_CAS,         /* GPIO_EMC_B1_24 PAD functional properties : */
      0x08U);                                 /* PDRV Field: high drive strength
                                                 Pull Down Pull Up Field: Internal pulldown resistor enabled
                                                 Open Drain Field: Disabled
                                                 Domain write protection: Both cores are allowed
                                                 Domain write protection lock: Neither of DWP bits is locked */
  IOMUXC_SetPinConfig(
      IOMUXC_GPIO_EMC_B1_25_SEMC_RAS,         /* GPIO_EMC_B1_25 PAD functional properties : */
      0x08U);                                 /* PDRV Field: high drive strength
                                                 Pull Down Pull Up Field: Internal pulldown resistor enabled
                                                 Open Drain Field: Disabled
                                                 Domain write protection: Both cores are allowed
                                                 Domain write protection lock: Neither of DWP bits is locked */
  IOMUXC_SetPinConfig(
      IOMUXC_GPIO_EMC_B1_26_SEMC_CLK,         /* GPIO_EMC_B1_26 PAD functional properties : */
      0x08U);                                 /* PDRV Field: high drive strength
                                                 Pull Down Pull Up Field: Internal pulldown resistor enabled
                                                 Open Drain Field: Disabled
                                                 Domain write protection: Both cores are allowed
                                                 Domain write protection lock: Neither of DWP bits is locked */
  IOMUXC_SetPinConfig(
      IOMUXC_GPIO_EMC_B1_27_SEMC_CKE,         /* GPIO_EMC_B1_27 PAD functional properties : */
      0x08U);                                 /* PDRV Field: high drive strength
                                                 Pull Down Pull Up Field: Internal pulldown resistor enabled
                                                 Open Drain Field: Disabled
                                                 Domain write protection: Both cores are allowed
                                                 Domain write protection lock: Neither of DWP bits is locked */
  IOMUXC_SetPinConfig(
      IOMUXC_GPIO_EMC_B1_28_SEMC_WE,          /* GPIO_EMC_B1_28 PAD functional properties : */
      0x08U);                                 /* PDRV Field: high drive strength
                                                 Pull Down Pull Up Field: Internal pulldown resistor enabled
                                                 Open Drain Field: Disabled
                                                 Domain write protection: Both cores are allowed
                                                 Domain write protection lock: Neither of DWP bits is locked */
  IOMUXC_SetPinConfig(
      IOMUXC_GPIO_EMC_B1_29_SEMC_CS0,         /* GPIO_EMC_B1_29 PAD functional properties : */
      0x08U);                                 /* PDRV Field: high drive strength
                                                 Pull Down Pull Up Field: Internal pulldown resistor enabled
                                                 Open Drain Field: Disabled
                                                 Domain write protection: Both cores are allowed
                                                 Domain write protection lock: Neither of DWP bits is locked */
  IOMUXC_SetPinConfig(
      IOMUXC_GPIO_EMC_B1_30_SEMC_DATA08,      /* GPIO_EMC_B1_30 PAD functional properties : */
      0x08U);                                 /* PDRV Field: high drive strength
                                                 Pull Down Pull Up Field: Internal pulldown resistor enabled
                                                 Open Drain Field: Disabled
                                                 Domain write protection: Both cores are allowed
                                                 Domain write protection lock: Neither of DWP bits is locked */
  IOMUXC_SetPinConfig(
      IOMUXC_GPIO_EMC_B1_31_SEMC_DATA09,      /* GPIO_EMC_B1_31 PAD functional properties : */
      0x08U);                                 /* PDRV Field: high drive strength
                                                 Pull Down Pull Up Field: Internal pulldown resistor enabled
                                                 Open Drain Field: Disabled
                                                 Domain write protection: Both cores are allowed
                                                 Domain write protection lock: Neither of DWP bits is locked */
  IOMUXC_SetPinConfig(
      IOMUXC_GPIO_EMC_B1_32_SEMC_DATA10,      /* GPIO_EMC_B1_32 PAD functional properties : */
      0x08U);                                 /* PDRV Field: high drive strength
                                                 Pull Down Pull Up Field: Internal pulldown resistor enabled
                                                 Open Drain Field: Disabled
                                                 Domain write protection: Both cores are allowed
                                                 Domain write protection lock: Neither of DWP bits is locked */
  IOMUXC_SetPinConfig(
      IOMUXC_GPIO_EMC_B1_33_SEMC_DATA11,      /* GPIO_EMC_B1_33 PAD functional properties : */
      0x08U);                                 /* PDRV Field: high drive strength
                                                 Pull Down Pull Up Field: Internal pulldown resistor enabled
                                                 Open Drain Field: Disabled
                                                 Domain write protection: Both cores are allowed
                                                 Domain write protection lock: Neither of DWP bits is locked */
  IOMUXC_SetPinConfig(
      IOMUXC_GPIO_EMC_B1_34_SEMC_DATA12,      /* GPIO_EMC_B1_34 PAD functional properties : */
      0x08U);                                 /* PDRV Field: high drive strength
                                                 Pull Down Pull Up Field: Internal pulldown resistor enabled
                                                 Open Drain Field: Disabled
                                                 Domain write protection: Both cores are allowed
                                                 Domain write protection lock: Neither of DWP bits is locked */
  IOMUXC_SetPinConfig(
      IOMUXC_GPIO_EMC_B1_35_SEMC_DATA13,      /* GPIO_EMC_B1_35 PAD functional properties : */
      0x08U);                                 /* PDRV Field: high drive strength
                                                 Pull Down Pull Up Field: Internal pulldown resistor enabled
                                                 Open Drain Field: Disabled
                                                 Domain write protection: Both cores are allowed
                                                 Domain write protection lock: Neither of DWP bits is locked */
  IOMUXC_SetPinConfig(
      IOMUXC_GPIO_EMC_B1_36_SEMC_DATA14,      /* GPIO_EMC_B1_36 PAD functional properties : */
      0x08U);                                 /* PDRV Field: high drive strength
                                                 Pull Down Pull Up Field: Internal pulldown resistor enabled
                                                 Open Drain Field: Disabled
                                                 Domain write protection: Both cores are allowed
                                                 Domain write protection lock: Neither of DWP bits is locked */
  IOMUXC_SetPinConfig(
      IOMUXC_GPIO_EMC_B1_37_SEMC_DATA15,      /* GPIO_EMC_B1_37 PAD functional properties : */
      0x08U);                                 /* PDRV Field: high drive strength
                                                 Pull Down Pull Up Field: Internal pulldown resistor enabled
                                                 Open Drain Field: Disabled
                                                 Domain write protection: Both cores are allowed
                                                 Domain write protection lock: Neither of DWP bits is locked */
  IOMUXC_SetPinConfig(
      IOMUXC_GPIO_EMC_B1_38_SEMC_DM01,        /* GPIO_EMC_B1_38 PAD functional properties : */
      0x08U);                                 /* PDRV Field: high drive strength
                                                 Pull Down Pull Up Field: Internal pulldown resistor enabled
                                                 Open Drain Field: Disabled
                                                 Domain write protection: Both cores are allowed
                                                 Domain write protection lock: Neither of DWP bits is locked */
  IOMUXC_SetPinConfig(
      IOMUXC_GPIO_EMC_B1_39_SEMC_DQS,         /* GPIO_EMC_B1_39 PAD functional properties : */
      0x08U);                                 /* PDRV Field: high drive strength
                                                 Pull Down Pull Up Field: Internal pulldown resistor enabled
                                                 Open Drain Field: Disabled
                                                 Domain write protection: Both cores are allowed
                                                 Domain write protection lock: Neither of DWP bits is locked */
  IOMUXC_SetPinConfig(
      IOMUXC_GPIO_EMC_B1_40_SEMC_RDY,         /* GPIO_EMC_B1_40 PAD functional properties : */
      0x08U);                                 /* PDRV Field: high drive strength
                                                 Pull Down Pull Up Field: Internal pulldown resistor enabled
                                                 Open Drain Field: Disabled
                                                 Domain write protection: Both cores are allowed
                                                 Domain write protection lock: Neither of DWP bits is locked */
  IOMUXC_SetPinConfig(
      IOMUXC_GPIO_EMC_B1_41_SEMC_CSX00,       /* GPIO_EMC_B1_41 PAD functional properties : */
      0x08U);                                 /* PDRV Field: high drive strength
                                                 Pull Down Pull Up Field: Internal pulldown resistor enabled
                                                 Open Drain Field: Disabled
                                                 Domain write protection: Both cores are allowed
                                                 Domain write protection lock: Neither of DWP bits is locked */
  IOMUXC_SetPinConfig(
      IOMUXC_GPIO_EMC_B2_00_SEMC_DATA16,      /* GPIO_EMC_B2_00 PAD functional properties : */
      0x08U);                                 /* PDRV Field: high drive strength
                                                 Pull Down Pull Up Field: Internal pulldown resistor enabled
                                                 Open Drain Field: Disabled
                                                 Domain write protection: Both cores are allowed
                                                 Domain write protection lock: Neither of DWP bits is locked */
  IOMUXC_SetPinConfig(
      IOMUXC_GPIO_EMC_B2_01_SEMC_DATA17,      /* GPIO_EMC_B2_01 PAD functional properties : */
      0x08U);                                 /* PDRV Field: high drive strength
                                                 Pull Down Pull Up Field: Internal pulldown resistor enabled
                                                 Open Drain Field: Disabled
                                                 Domain write protection: Both cores are allowed
                                                 Domain write protection lock: Neither of DWP bits is locked */
  IOMUXC_SetPinConfig(
      IOMUXC_GPIO_EMC_B2_02_SEMC_DATA18,      /* GPIO_EMC_B2_02 PAD functional properties : */
      0x08U);                                 /* PDRV Field: high drive strength
                                                 Pull Down Pull Up Field: Internal pulldown resistor enabled
                                                 Open Drain Field: Disabled
                                                 Domain write protection: Both cores are allowed
                                                 Domain write protection lock: Neither of DWP bits is locked */
  IOMUXC_SetPinConfig(
      IOMUXC_GPIO_EMC_B2_03_SEMC_DATA19,      /* GPIO_EMC_B2_03 PAD functional properties : */
      0x08U);                                 /* PDRV Field: high drive strength
                                                 Pull Down Pull Up Field: Internal pulldown resistor enabled
                                                 Open Drain Field: Disabled
                                                 Domain write protection: Both cores are allowed
                                                 Domain write protection lock: Neither of DWP bits is locked */
  IOMUXC_SetPinConfig(
      IOMUXC_GPIO_EMC_B2_04_SEMC_DATA20,      /* GPIO_EMC_B2_04 PAD functional properties : */
      0x08U);                                 /* PDRV Field: high drive strength
                                                 Pull Down Pull Up Field: Internal pulldown resistor enabled
                                                 Open Drain Field: Disabled
                                                 Domain write protection: Both cores are allowed
                                                 Domain write protection lock: Neither of DWP bits is locked */
  IOMUXC_SetPinConfig(
      IOMUXC_GPIO_EMC_B2_05_SEMC_DATA21,      /* GPIO_EMC_B2_05 PAD functional properties : */
      0x08U);                                 /* PDRV Field: high drive strength
                                                 Pull Down Pull Up Field: Internal pulldown resistor enabled
                                                 Open Drain Field: Disabled
                                                 Domain write protection: Both cores are allowed
                                                 Domain write protection lock: Neither of DWP bits is locked */
  IOMUXC_SetPinConfig(
      IOMUXC_GPIO_EMC_B2_06_SEMC_DATA22,      /* GPIO_EMC_B2_06 PAD functional properties : */
      0x08U);                                 /* PDRV Field: high drive strength
                                                 Pull Down Pull Up Field: Internal pulldown resistor enabled
                                                 Open Drain Field: Disabled
                                                 Domain write protection: Both cores are allowed
                                                 Domain write protection lock: Neither of DWP bits is locked */
  IOMUXC_SetPinConfig(
      IOMUXC_GPIO_EMC_B2_07_SEMC_DATA23,      /* GPIO_EMC_B2_07 PAD functional properties : */
      0x08U);                                 /* PDRV Field: high drive strength
                                                 Pull Down Pull Up Field: Internal pulldown resistor enabled
                                                 Open Drain Field: Disabled
                                                 Domain write protection: Both cores are allowed
                                                 Domain write protection lock: Neither of DWP bits is locked */
  IOMUXC_SetPinConfig(
      IOMUXC_GPIO_EMC_B2_08_SEMC_DM02,        /* GPIO_EMC_B2_08 PAD functional properties : */
      0x04U);                                 /* PDRV Field: high drive strength
                                                 Pull Down Pull Up Field: Internal pullup resistor enabled
                                                 Open Drain Field: Disabled
                                                 Domain write protection: Both cores are allowed
                                                 Domain write protection lock: Neither of DWP bits is locked */
  IOMUXC_SetPinConfig(
      IOMUXC_GPIO_EMC_B2_09_SEMC_DATA24,      /* GPIO_EMC_B2_09 PAD functional properties : */
      0x08U);                                 /* PDRV Field: high drive strength
                                                 Pull Down Pull Up Field: Internal pulldown resistor enabled
                                                 Open Drain Field: Disabled
                                                 Domain write protection: Both cores are allowed
                                                 Domain write protection lock: Neither of DWP bits is locked */
  IOMUXC_SetPinConfig(
      IOMUXC_GPIO_EMC_B2_10_SEMC_DATA25,      /* GPIO_EMC_B2_10 PAD functional properties : */
      0x08U);                                 /* PDRV Field: high drive strength
                                                 Pull Down Pull Up Field: Internal pulldown resistor enabled
                                                 Open Drain Field: Disabled
                                                 Domain write protection: Both cores are allowed
                                                 Domain write protection lock: Neither of DWP bits is locked */
  IOMUXC_SetPinConfig(
      IOMUXC_GPIO_EMC_B2_11_SEMC_DATA26,      /* GPIO_EMC_B2_11 PAD functional properties : */
      0x04U);                                 /* PDRV Field: high drive strength
                                                 Pull Down Pull Up Field: Internal pullup resistor enabled
                                                 Open Drain Field: Disabled
                                                 Domain write protection: Both cores are allowed
                                                 Domain write protection lock: Neither of DWP bits is locked */
  IOMUXC_SetPinConfig(
      IOMUXC_GPIO_EMC_B2_12_SEMC_DATA27,      /* GPIO_EMC_B2_12 PAD functional properties : */
      0x08U);                                 /* PDRV Field: high drive strength
                                                 Pull Down Pull Up Field: Internal pulldown resistor enabled
                                                 Open Drain Field: Disabled
                                                 Domain write protection: Both cores are allowed
                                                 Domain write protection lock: Neither of DWP bits is locked */
  IOMUXC_SetPinConfig(
      IOMUXC_GPIO_EMC_B2_13_SEMC_DATA28,      /* GPIO_EMC_B2_13 PAD functional properties : */
      0x08U);                                 /* PDRV Field: high drive strength
                                                 Pull Down Pull Up Field: Internal pulldown resistor enabled
                                                 Open Drain Field: Disabled
                                                 Domain write protection: Both cores are allowed
                                                 Domain write protection lock: Neither of DWP bits is locked */
  IOMUXC_SetPinConfig(
      IOMUXC_GPIO_EMC_B2_14_SEMC_DATA29,      /* GPIO_EMC_B2_14 PAD functional properties : */
      0x08U);                                 /* PDRV Field: high drive strength
                                                 Pull Down Pull Up Field: Internal pulldown resistor enabled
                                                 Open Drain Field: Disabled
                                                 Domain write protection: Both cores are allowed
                                                 Domain write protection lock: Neither of DWP bits is locked */
  IOMUXC_SetPinConfig(
      IOMUXC_GPIO_EMC_B2_15_SEMC_DATA30,      /* GPIO_EMC_B2_15 PAD functional properties : */
      0x08U);                                 /* PDRV Field: high drive strength
                                                 Pull Down Pull Up Field: Internal pulldown resistor enabled
                                                 Open Drain Field: Disabled
                                                 Domain write protection: Both cores are allowed
                                                 Domain write protection lock: Neither of DWP bits is locked */
  IOMUXC_SetPinConfig(
      IOMUXC_GPIO_EMC_B2_16_SEMC_DATA31,      /* GPIO_EMC_B2_16 PAD functional properties : */
      0x08U);                                 /* PDRV Field: high drive strength
                                                 Pull Down Pull Up Field: Internal pulldown resistor enabled
                                                 Open Drain Field: Disabled
                                                 Domain write protection: Both cores are allowed
                                                 Domain write protection lock: Neither of DWP bits is locked */
  IOMUXC_SetPinConfig(
      IOMUXC_GPIO_EMC_B2_17_SEMC_DM03,        /* GPIO_EMC_B2_17 PAD functional properties : */
      0x08U);                                 /* PDRV Field: high drive strength
                                                 Pull Down Pull Up Field: Internal pulldown resistor enabled
                                                 Open Drain Field: Disabled
                                                 Domain write protection: Both cores are allowed
                                                 Domain write protection lock: Neither of DWP bits is locked */
  IOMUXC_SetPinConfig(
      IOMUXC_GPIO_EMC_B2_18_SEMC_DQS4,        /* GPIO_EMC_B2_18 PAD functional properties : */
      0x08U);                                 /* PDRV Field: high drive strength
                                                 Pull Down Pull Up Field: Internal pulldown resistor enabled
                                                 Open Drain Field: Disabled
                                                 Domain write protection: Both cores are allowed
                                                 Domain write protection lock: Neither of DWP bits is locked */
  IOMUXC_SetPinConfig(
      IOMUXC_GPIO_EMC_B2_19_SEMC_CLKX00,      /* GPIO_EMC_B2_19 PAD functional properties : */
      0x08U);                                 /* PDRV Field: high drive strength
                                                 Pull Down Pull Up Field: Internal pulldown resistor enabled
                                                 Open Drain Field: Disabled
                                                 Domain write protection: Both cores are allowed
                                                 Domain write protection lock: Neither of DWP bits is locked */
  IOMUXC_SetPinConfig(
      IOMUXC_GPIO_EMC_B2_20_SEMC_CLKX01,      /* GPIO_EMC_B2_20 PAD functional properties : */
      0x08U);                                 /* PDRV Field: high drive strength
                                                 Pull Down Pull Up Field: Internal pulldown resistor enabled
                                                 Open Drain Field: Disabled
                                                 Domain write protection: Both cores are allowed
                                                 Domain write protection lock: Neither of DWP bits is locked */
}

/***********************************************************************************************************************
 * EOF
 **********************************************************************************************************************/
