/*
 * Copyright 2019 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

/*
 * Description: This file implements the ISSDK FXAS21002 and FXOS8700 sensor
   drivers. It is used for reading data from FXAS21002 and FXOS8700 sensors.
 */

#ifndef GET_SENSOR_DATA_H_
#define GET_SENSOR_DATA_H_

#ifdef  __cplusplus
extern "C"
{
#endif

#include "stdbool.h"

#include "fsl_fxos.h"
#include "model.h"

/*! @brief This structure defines the fxos8700 raw data buffer.*/
typedef struct
{
    uint32_t timestamp; /*! The time, this sample was recorded.  */
    int16_t accel[3];   /*!< The accel data */
    int16_t mag[3];     /*!< The mag data */
} fxos8700_accelmagdata_t;

status_t SENSOR_Init(void);
status_t SENSOR_Run(fxos8700_accelmagdata_t *rawDataAccel);
status_t SENSOR_GetData(uint8_t *dstData, tensor_type_t inputType, bool *skip);
status_t SENSOR_CollectData(void);

#ifdef  __cplusplus
}
#endif

#endif /* GET_SENSOR_DATA_H_ */
