/*
 *  Copyright 2020-2021 NXP
 *  All rights reserved.
 *
 *  SPDX-License-Identifier: BSD-3-Clause
 */

#define USB_HOST_CONFIG_EHCI (2U)
#define CONTROLLER_ID        kUSB_ControllerEhci0

#define FLASH_ADAPTER_SIZE 0x4000

/* Controller config
 * Supported controller list,
 * WIFI_IW416_BOARD_AW_AM457_USD
 * WIFI_IW416_BOARD_AW_AM510MA
 * WIFI_88W8987_BOARD_AW_CM358MA
 * WIFI_IW416_BOARD_MURATA_1XK_USD
 * WIFI_IW416_BOARD_MURATA_1XK_M2
 * WIFI_IW416_BOARD_MURATA_1XK_ONBOARD
 * WIFI_88W8987_BOARD_MURATA_1ZM_USD
 * WIFI_88W8987_BOARD_MURATA_1ZM_M2
 *
 * If aw am457 uSD is used, define macro WIFI_IW416_BOARD_AW_AM457_USD below.
 * If aw am510 M.2 is used, define macro WIFI_IW416_BOARD_AW_AM510MA below.
 * If aw cm358 M.2 is used, define macro WIFI_88W8987_BOARD_AW_CM358MA below.
 * If Murata Type 1XK module with uSD-M2 adapter is used, define macro WIFI_IW416_BOARD_MURATA_1XK_USD below.
 * If Murata Type 1XK module (EAR00385 M2 only) is used, define macro WIFI_IW416_BOARD_MURATA_1XK_M2 below.
 * If Murata Type 1XK module onboard the iMXRT1176 uCOM board is used, define macro WIFI_IW416_BOARD_MURATA_1XK_ONBOARD below.
 * If Murata Type 1ZM module with uSD-M2 adapter is used, define macro WIFI_88W8987_BOARD_MURATA_1ZM_USD below.
 * If Murata Type 1ZM module (EAR00364 M2 only) is used, define macro WIFI_88W8987_BOARD_MURATA_1ZM_M2 below.
 */

/* @TEST_ANCHOR */
#define WIFI_IW416_BOARD_MURATA_1XK_ONBOARD
/* @END_TEST_ANCHOR */
/*#define WIFI_IW416_BOARD_AW_AM457_USD*/
/*#define WIFI_88W8987_BOARD_AW_CM358MA*/
/*#define WIFI_IW416_BOARD_MURATA_1XK_USD*/
/*#define WIFI_IW416_BOARD_MURATA_1XK_M2*/
/*#define WIFI_IW416_BOARD_MURATA_1XK_ONBOARD*/
/*#define WIFI_88W8987_BOARD_MURATA_1ZM_USD*/
/*#define WIFI_88W8987_BOARD_MURATA_1ZM_M2*/

#if (defined(WIFI_IW416_BOARD_AW_AM510MA) || defined(WIFI_88W8987_BOARD_AW_CM358MA) ||          \
     defined(WIFI_IW416_BOARD_MURATA_1XK_USD) || defined(WIFI_IW416_BOARD_MURATA_1XK_M2) || defined(WIFI_IW416_BOARD_MURATA_1XK_ONBOARD) ||     \
     defined(WIFI_88W8987_BOARD_MURATA_1ZM_USD) || defined(WIFI_88W8987_BOARD_MURATA_1ZM_M2) || \
     defined(WIFI_IW416_BOARD_AW_AM457_USD))
#include "bt_module_config.h"
#include "wifi_config.h"
#else
#error The Wi-Fi module is unsupported
#endif

#define CONFIG_BT_A2DP      1
#define CONFIG_BT_A2DP_SINK 1

#include "edgefast_bluetooth_config.h"

/* For convenience - sets WIFI_BOARD_NAME as string */
#if defined(WIFI_IW416_BOARD_AW_AM457_USD)
   #define WIFI_BOARD_NAME  "WIFI_IW416_BOARD_AW_AM457_USD"
#elif defined(WIFI_IW416_BOARD_AW_AM510MA)
   #define WIFI_BOARD_NAME  "WIFI_IW416_BOARD_AW_AM510MA"
#elif defined(WIFI_88W8987_BOARD_AW_CM358MA)
   #define WIFI_BOARD_NAME  "WIFI_88W8987_BOARD_AW_CM358MA"
#elif defined(WIFI_IW416_BOARD_MURATA_1XK_USD)
   #define WIFI_BOARD_NAME  "WIFI_IW416_BOARD_MURATA_1XK_USD"
#elif defined(WIFI_IW416_BOARD_MURATA_1XK_M2)
   #define WIFI_BOARD_NAME  "WIFI_IW416_BOARD_MURATA_1XK_M2"
#elif defined(WIFI_IW416_BOARD_MURATA_1XK_ONBOARD)
   #define WIFI_BOARD_NAME  "WIFI_IW416_BOARD_MURATA_1XK_ONBOARD"
#elif defined(WIFI_88W8987_BOARD_MURATA_1ZM_USD)
   #define WIFI_BOARD_NAME  "WIFI_88W8987_BOARD_MURATA_1ZM_USD"
#elif defined(WIFI_88W8987_BOARD_MURATA_1ZM_M2)
   #define WIFI_BOARD_NAME  "WIFI_88W8987_BOARD_MURATA_1ZM_M2"
#endif
