
/**
 *  \file db_gen.c
 *
 *  [DBG Version: 1.1.1] This is a generated file.
 *  Created On : Mon Feb 08 01:02:50 2021
 */

/* Header File Inclusion */
#include "db_gen.h"

#ifdef SDP_SERVER

/* --------------------------------------------- Global Variables */

/* Static SDP database for memory constrained implementations */
SDP_RECORD dbase[DB_MAX_RECORDS];

/* Total number of records in the database */
UINT16 num_records;

/* Total number of UUIDS stored in the global uuid array */
UINT16 num_128_ids;

/** Total number of Service Class UUIDs in the static SDDB */
UINT16 num_service_class_uuids;

/**
 *   Record 00  : SDP Record
 *   Record 01  : SAP
 *   Record 02  : SPP
 *   Record 03  : SPP_VS
 *   Record 04  : FTP
 *   Record 05  : HFU
 *   Record 06  : HFAG
 *   Record 07  : HID
 *   Record 08  : A2DP Sink
 *   Record 09  : A2DP Source
 *   Record 10  : OPP
 *   Record 11  : NAP
 *   Record 12  : GN
 *   Record 13  : PANU
 *   Record 14  : BIP
 *   Record 15  : RO
 *   Record 16  : Archived Objects
 *   Record 17  : BPP
 *   Record 18  : Basic Printing Referenced Objects
 *   Record 19  : Printer Administrative User Interface
 *   Record 20  : AVRCP Controller
 *   Record 21  : AVRCP Target
 *   Record 22  : PBAP_PCE
 *   Record 23  : PBAP_PSE
 *   Record 24  : DID
 *   Record 25  : DID
 *   Record 26  : HDP
 *   Record 27  : MAP_MCE
 *   Record 28  : MAP_MSE
 *   Record 29  : MAP_MSE
 *   Record 30  : MPS
 *   Record 31  : GAP
 *   Record 32  : GATT
 *   Record 33  : DIS
 *   Record 34  : BAS
 *   Record 35  : RSC
 *   Record 36  : CSC
 *   Record 37  : CPS
 *   Record 38  : HPS
 *   Record 39  : CTS
 *   Record 40  : CTN_CCE
 *   Record 41  : CTN_CSE
 *   Record 42  : CTN_CSE
 */

/**
 *   Data Size Calculation (For ARM Processor):
 *
 *   Number of SDP records (n_rec) = 43
 *   Number of attributes (n_attr) = 394
 *   UUID List Length (uuid_list_len) = 202
 *   Number of UUIDS (n_uuid) = 65
 *   Total attribute value length (attr_len) = 3602 Bytes
 *   Other Global variables (other): Two UINT16 type variable = 4 Bytes
 *
 *   Read Only (RO) data = uuid_list_len + (n_uuid * 16)
 *                       = 1242 (0x4DA) Bytes
 *
 *   Read Write (RW) data = (n_attr * 8) + (attr_len)
 *                        = 6754 (0x1A62) Bytes
 *
 *   Zero Initialized (ZI) data = (n_rec * 12) + (other)
 *                              = 520 (0x208) Bytes
 */

/* UUID indices array */
const UCHAR uuid_indices_arr[] = {
                                /** Service Record 0 */
                                10,
                                /** Service Record 1 */
                                0, 9, 11, 37, 51,
                                /** Service Record 2 */
                                0, 9, 11, 12,
                                /** Service Record 3 */
                                0, 9, 11, 12, 64,
                                /** Service Record 4 */
                                0, 2, 9, 11, 14,
                                /** Service Record 5 */
                                0, 9, 11, 30, 50,
                                /** Service Record 6 */
                                0, 9, 11, 30, 31, 50,
                                /** Service Record 7 */
                                4, 9, 11, 36,
                                /** Service Record 8 */
                                6, 9, 11, 16, 18,
                                /** Service Record 9 */
                                6, 9, 11, 15, 18,
                                /** Service Record 10 */
                                0, 2, 9, 11, 13,
                                /** Service Record 11 */
                                3, 9, 11, 22,
                                /** Service Record 12 */
                                3, 9, 11, 23,
                                /** Service Record 13 */
                                3, 9, 11, 21,
                                /** Service Record 14 */
                                0, 2, 9, 11, 26, 27,
                                /** Service Record 15 */
                                0, 2, 9, 11, 26, 29,
                                /** Service Record 16 */
                                0, 2, 9, 11, 26, 28,
                                /** Service Record 17 */
                                0, 2, 9, 11, 24, 25, 34, 35,
                                /** Service Record 18 */
                                0, 2, 9, 11, 32, 34,
                                /** Service Record 19 */
                                0, 2, 9, 11, 33,
                                /** Service Record 20 */
                                5, 9, 11, 19, 20,
                                /** Service Record 21 */
                                2, 5, 9, 11, 17, 19,
                                /** Service Record 22 */
                                11, 38, 40,
                                /** Service Record 23 */
                                0, 2, 9, 11, 39, 40,
                                /** Service Record 24 */
                                11, 49,
                                /** Service Record 25 */
                                11, 49,
                                /** Service Record 26 */
                                7, 8, 9, 11, 52, 53, 54,
                                /** Service Record 27 */
                                0, 2, 9, 11, 42, 43,
                                /** Service Record 28 */
                                0, 2, 9, 11, 41, 43,
                                /** Service Record 29 */
                                0, 2, 9, 11, 41, 43,
                                /** Service Record 30 */
                                11, 44, 45,
                                /** Service Record 31 */
                                1, 9, 11, 55,
                                /** Service Record 32 */
                                1, 9, 11, 56,
                                /** Service Record 33 */
                                1, 9, 11, 58,
                                /** Service Record 34 */
                                1, 9, 11, 59,
                                /** Service Record 35 */
                                1, 9, 11, 60,
                                /** Service Record 36 */
                                1, 9, 11, 61,
                                /** Service Record 37 */
                                1, 9, 11, 62,
                                /** Service Record 38 */
                                1, 9, 11, 63,
                                /** Service Record 39 */
                                1, 9, 11, 57,
                                /** Service Record 40 */
                                2, 9, 11, 47, 48,
                                /** Service Record 41 */
                                2, 9, 11, 46, 48,
                                /** Service Record 42 */
                                2, 9, 11, 46, 48
                                 };

#ifdef BT_EIR
/* Service Class UUID indices array */
const UCHAR service_class_uuid_indices_arr[SERVICE_CLASS_UUID_INDICES_MAX] =
{
    10, 12, 13, 14, 15, 16, 17, 19,
    20, 21, 22, 23, 24, 25, 27, 28,
    29, 30, 31, 32, 33, 35, 36, 37,
    38, 39, 41, 42, 45, 46, 47, 49,
    50, 51, 53, 54, 55, 56, 57, 58,
    59, 60, 61, 62, 63, 64
};
#endif /* BT_EIR */

/* Attribute value array */
UCHAR value_arr[] = {
    /** Service Record 0 */

    /* ServiceRecordHandle */
    0x0A,0x00,0x00,0x00,0x00,

    /* ServiceClassIDList */
    0x35,0x03,0x19,0x10,0x00,

    /* VersionNumberList */
    0x35,0x03,0x09,0x01,0x00,

    /** Service Record 1 */

    /* ServiceRecordHandle */
    0x0A, 0x00, 0x09, 0x00, 0x01,

    /* ServiceClassIDList */
    0x35, 0x06, 0x19, 0x11, 0x2D, 0x19, 0x12, 0x04,

    /* ProtocolDescriptorList */
    0x35, 0x0C, 0x35, 0x03, 0x19, 0x01, 0x00, 0x35, 0x05, 0x19,
    0x00, 0x03, 0x08, 0x01,

    /* BrowseGroupList  */
    0x35, 0x03, 0x19, 0x10, 0x02,

    /* LanguageBaseAttributeIDList  */
    0x35, 0x09, 0x09, 0x65, 0x6E, 0x09, 0x00, 0x6A, 0x09, 0x01,
    0x00,

    /* BluetoothProfileDescriptorList */
    0x35, 0x08, 0x35, 0x06, 0x19, 0x11, 0x2D, 0x09, 0x01, 0x01,

    /* ServiceName */
    0x25, 0x0B, 0x53, 0x49, 0x4D, 0x20, 0x41, 0x63, 0x63, 0x65,
    0x73, 0x73, 0x00,

    /** Service Record 2 */

    /* ServiceRecordHandle */
    0x0A, 0x00, 0x09, 0x00, 0x02,

    /* ServiceClassIDList */
    0x35, 0x03, 0x19, 0x11, 0x01,

    /* ProtocolDescriptorList */
    0x35, 0x0C, 0x35, 0x03, 0x19, 0x01, 0x00, 0x35, 0x05, 0x19,
    0x00, 0x03, 0x08, 0x02,

    /* BrowseGroupList  */
    0x35, 0x03, 0x19, 0x10, 0x02,

    /* LanguageBaseAttributeIDList  */
    0x35, 0x09, 0x09, 0x65, 0x6E, 0x09, 0x00, 0x6A, 0x09, 0x01,
    0x00,

    /* BluetoothProfileDescriptorList */
    0x35, 0x08, 0x35, 0x06, 0x19, 0x11, 0x01, 0x09, 0x01, 0x02,

    /* ServiceName */
    0x25, 0x05, 0x43, 0x4F, 0x4D, 0x35, 0x00,

    /** Service Record 3 */

    /* ServiceRecordHandle */
    0x0A, 0x00, 0x09, 0x00, 0x03,

    /* ServiceClassIDList */
    0x35, 0x14, 0x1C, 0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77,
    0x88, 0x99, 0xAA, 0xBB, 0xCC, 0xDD, 0xEE, 0xFF, 0x00, 0x19,
    0x11, 0x01,

    /* ProtocolDescriptorList */
    0x35, 0x0C, 0x35, 0x03, 0x19, 0x01, 0x00, 0x35, 0x05, 0x19,
    0x00, 0x03, 0x08, 0x03,

    /* BrowseGroupList  */
    0x35, 0x03, 0x19, 0x10, 0x02,

    /* LanguageBaseAttributeIDList  */
    0x35, 0x09, 0x09, 0x65, 0x6E, 0x09, 0x00, 0x6A, 0x09, 0x01,
    0x00,

    /* BluetoothProfileDescriptorList */
    0x35, 0x08, 0x35, 0x06, 0x19, 0x11, 0x01, 0x09, 0x01, 0x02,

    /* ServiceName */
    0x25, 0x05, 0x43, 0x4F, 0x4D, 0x36, 0x00,

    /** Service Record 4 */

    /* ServiceRecordHandle */
    0x0A, 0x00, 0x09, 0x00, 0x04,

    /* ServiceClassIDList */
    0x35, 0x03, 0x19, 0x11, 0x06,

    /* ProtocolDescriptorList */
    0x35, 0x11, 0x35, 0x03, 0x19, 0x01, 0x00, 0x35, 0x05, 0x19,
    0x00, 0x03, 0x08, 0x04, 0x35, 0x03, 0x19, 0x00, 0x08,

    /* BrowseGroupList  */
    0x35, 0x03, 0x19, 0x10, 0x02,

    /* LanguageBaseAttributeIDList  */
    0x35, 0x09, 0x09, 0x65, 0x6E, 0x09, 0x00, 0x6A, 0x09, 0x01,
    0x00,

    /* BluetoothProfileDescriptorList */
    0x35, 0x08, 0x35, 0x06, 0x19, 0x11, 0x06, 0x09, 0x01, 0x03,

    /* ServiceName */
    0x25, 0x13, 0x4F, 0x42, 0x45, 0x58, 0x20, 0x46, 0x69, 0x6C,
    0x65, 0x20, 0x54, 0x72, 0x61, 0x6E, 0x73, 0x66, 0x65, 0x72,
    0x00,

    /* HIDDeviceReleaseNumber */
    0x09, 0x82, 0x03,

    /** Service Record 5 */

    /* ServiceRecordHandle */
    0x0A, 0x00, 0x09, 0x00, 0x05,

    /* ServiceClassIDList */
    0x35, 0x06, 0x19, 0x11, 0x1E, 0x19, 0x12, 0x03,

    /* ProtocolDescriptorList */
    0x35, 0x0C, 0x35, 0x03, 0x19, 0x01, 0x00, 0x35, 0x05, 0x19,
    0x00, 0x03, 0x08, 0x05,

    /* BrowseGroupList  */
    0x35, 0x03, 0x19, 0x10, 0x02,

    /* LanguageBaseAttributeIDList  */
    0x35, 0x09, 0x09, 0x65, 0x6E, 0x09, 0x00, 0x6A, 0x09, 0x01,
    0x00,

    /* BluetoothProfileDescriptorList */
    0x35, 0x08, 0x35, 0x06, 0x19, 0x11, 0x1E, 0x09, 0x01, 0x08,

    /* ServiceName */
    0x25, 0x04, 0x48, 0x46, 0x55, 0x00,

    /* SupportedFeatures */
    0x09, 0x00, 0x00,

    /** Service Record 6 */

    /* ServiceRecordHandle */
    0x0A, 0x00, 0x09, 0x00, 0x06,

    /* ServiceClassIDList */
    0x35, 0x06, 0x19, 0x11, 0x1F, 0x19, 0x12, 0x03,

    /* ProtocolDescriptorList */
    0x35, 0x0C, 0x35, 0x03, 0x19, 0x01, 0x00, 0x35, 0x05, 0x19,
    0x00, 0x03, 0x08, 0x06,

    /* BrowseGroupList  */
    0x35, 0x03, 0x19, 0x10, 0x02,

    /* LanguageBaseAttributeIDList  */
    0x35, 0x09, 0x09, 0x65, 0x6E, 0x09, 0x00, 0x6A, 0x09, 0x01,
    0x00,

    /* BluetoothProfileDescriptorList */
    0x35, 0x08, 0x35, 0x06, 0x19, 0x11, 0x1E, 0x09, 0x01, 0x08,

    /* ServiceName */
    0x25, 0x0E, 0x56, 0x6F, 0x69, 0x63, 0x65, 0x20, 0x67, 0x61,
    0x74, 0x65, 0x77, 0x61, 0x79, 0x00,

    /* Supported Data Stores List */
    0x08, 0x01,

    /* SupportedFeatures */
    0x09, 0x00, 0xDE,

    /** Service Record 7 */

    /* ServiceRecordHandle */
    0x0A, 0x00, 0x09, 0x00, 0x07,

    /* ServiceClassIDList */
    0x35, 0x03, 0x19, 0x11, 0x24,

    /* ProtocolDescriptorList */
    0x35, 0x11, 0x35, 0x0F, 0x35, 0x08, 0x19, 0x01, 0x00, 0x09,
    0x00, 0x11, 0x35, 0x05, 0x35, 0x03, 0x19, 0x00, 0x11,

    /* BrowseGroupList  */
    0x35, 0x03, 0x19, 0x10, 0x02,

    /* LanguageBaseAttributeIDList  */
    0x35, 0x09, 0x09, 0x65, 0x6E, 0x09, 0x00, 0x6A, 0x09, 0x01,
    0x00,

    /* BluetoothProfileDescriptorList */
    0x35, 0x08, 0x35, 0x06, 0x19, 0x11, 0x24, 0x09, 0x01, 0x00,

    /* AdditionalProtocolDescriptorLists */
    0x35, 0x13, 0x35, 0x11, 0x35, 0x0F, 0x35, 0x08, 0x19, 0x01,
    0x00, 0x09, 0x00, 0x13, 0x35, 0x05, 0x35, 0x03, 0x19, 0x00,
    0x11,

    /** Service Record 8 */

    /* ServiceRecordHandle */
    0x0A, 0x00, 0x09, 0x00, 0x08,

    /* ServiceClassIDList */
    0x35, 0x03, 0x19, 0x11, 0x0B,

    /* ProtocolDescriptorList */
    0x35, 0x10, 0x35, 0x06, 0x19, 0x01, 0x00, 0x09, 0x00, 0x19,
    0x35, 0x06, 0x19, 0x00, 0x19, 0x09, 0x01, 0x00,

    /* BrowseGroupList  */
    0x35, 0x03, 0x19, 0x10, 0x02,

    /* LanguageBaseAttributeIDList  */
    0x35, 0x09, 0x09, 0x65, 0x6E, 0x09, 0x00, 0x6A, 0x09, 0x01,
    0x00,

    /* BluetoothProfileDescriptorList */
    0x35, 0x08, 0x35, 0x06, 0x19, 0x11, 0x0D, 0x09, 0x01, 0x03,

    /* ServiceName */
    0x25, 0x09, 0x41, 0x32, 0x44, 0x50, 0x53, 0x69, 0x6E, 0x6B,
    0x00,

    /* ProviderName */
    0x25, 0x09, 0x4D, 0x69, 0x6E, 0x64, 0x54, 0x72, 0x65, 0x65,
    0x00,

    /* SupportedFeatures */
    0x09, 0x00, 0x01,

    /** Service Record 9 */

    /* ServiceRecordHandle */
    0x0A, 0x00, 0x09, 0x00, 0x09,

    /* ServiceClassIDList */
    0x35, 0x03, 0x19, 0x11, 0x0A,

    /* ProtocolDescriptorList */
    0x35, 0x10, 0x35, 0x06, 0x19, 0x01, 0x00, 0x09, 0x00, 0x19,
    0x35, 0x06, 0x19, 0x00, 0x19, 0x09, 0x01, 0x00,

    /* BrowseGroupList  */
    0x35, 0x03, 0x19, 0x10, 0x02,

    /* LanguageBaseAttributeIDList  */
    0x35, 0x09, 0x09, 0x65, 0x6E, 0x09, 0x00, 0x6A, 0x09, 0x01,
    0x00,

    /* BluetoothProfileDescriptorList */
    0x35, 0x08, 0x35, 0x06, 0x19, 0x11, 0x0D, 0x09, 0x01, 0x03,

    /* ServiceName */
    0x25, 0x0B, 0x41, 0x32, 0x44, 0x50, 0x53, 0x6F, 0x75, 0x72,
    0x63, 0x65, 0x00,

    /* ProviderName */
    0x25, 0x09, 0x4D, 0x69, 0x6E, 0x64, 0x54, 0x72, 0x65, 0x65,
    0x00,

    /* SupportedFeatures */
    0x09, 0x00, 0x01,

    /** Service Record 10 */

    /* ServiceRecordHandle */
    0x0A, 0x00, 0x09, 0x00, 0x0A,

    /* ServiceClassIDList */
    0x35, 0x03, 0x19, 0x11, 0x05,

    /* ProtocolDescriptorList */
    0x35, 0x11, 0x35, 0x03, 0x19, 0x01, 0x00, 0x35, 0x05, 0x19,
    0x00, 0x03, 0x08, 0x07, 0x35, 0x03, 0x19, 0x00, 0x08,

    /* BrowseGroupList  */
    0x35, 0x03, 0x19, 0x10, 0x02,

    /* LanguageBaseAttributeIDList  */
    0x35, 0x09, 0x09, 0x65, 0x6E, 0x09, 0x00, 0x6A, 0x09, 0x01,
    0x00,

    /* BluetoothProfileDescriptorList */
    0x35, 0x08, 0x35, 0x06, 0x19, 0x11, 0x05, 0x09, 0x01, 0x02,

    /* ServiceName */
    0x25, 0x04, 0x4F, 0x50, 0x50, 0x00,

    /* HIDDeviceReleaseNumber */
    0x09, 0x84, 0x03,

    /* SupportedFormatsList */
    0x35, 0x04, 0x08, 0x01, 0x08, 0x03,

    /** Service Record 11 */

    /* ServiceRecordHandle */
    0x0A, 0x00, 0x09, 0x00, 0x0B,

    /* ServiceClassIDList */
    0x35, 0x03, 0x19, 0x11, 0x16,

    /* ProtocolDescriptorList */
    0x35, 0x1E, 0x35, 0x06, 0x19, 0x01, 0x00, 0x09, 0x00, 0x0F,
    0x35, 0x14, 0x19, 0x00, 0x0F, 0x09, 0x01, 0x00, 0x35, 0x0C,
    0x09, 0x08, 0x00, 0x09, 0x08, 0x06, 0x09, 0x86, 0xDD, 0x09,
    0x88, 0x0B,

    /* BrowseGroupList  */
    0x35, 0x03, 0x19, 0x10, 0x02,

    /* LanguageBaseAttributeIDList  */
    0x35, 0x09, 0x09, 0x65, 0x6E, 0x09, 0x00, 0x6A, 0x09, 0x01,
    0x00,

    /* ServiceAvailability */
    0x08, 0xFF,

    /* BluetoothProfileDescriptorList */
    0x35, 0x08, 0x35, 0x06, 0x19, 0x11, 0x16, 0x09, 0x01, 0x00,

    /* ServiceName */
    0x25, 0x1D, 0x4E, 0x65, 0x74, 0x77, 0x6F, 0x72, 0x6B, 0x20,
    0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x20, 0x50, 0x6F, 0x69,
    0x6E, 0x74, 0x20, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
    0x00,

    /* ServiceDescription */
    0x25, 0x20, 0x50, 0x65, 0x72, 0x73, 0x6F, 0x6E, 0x61, 0x6C,
    0x20, 0x41, 0x64, 0x2D, 0x68, 0x6F, 0x63, 0x20, 0x4E, 0x65,
    0x74, 0x77, 0x6F, 0x72, 0x6B, 0x20, 0x53, 0x65, 0x72, 0x76,
    0x69, 0x63, 0x65, 0x00,

    /* SecurityDescription */
    0x09, 0x00, 0x00,

    /* NetAccessType */
    0x09, 0x00, 0x00,

    /* MaxNetAccessrate */
    0x0A, 0x00, 0x00, 0x00, 0x01,

    /* IPv4Subnet */
    0x25, 0x0B, 0x31, 0x30, 0x2E, 0x30, 0x2E, 0x30, 0x2E, 0x30,
    0x2F, 0x38, 0x00,

    /* IPv6Subnet */
    0x25, 0x0A, 0x66, 0x65, 0x38, 0x30, 0x3A, 0x3A, 0x2F, 0x34,
    0x38, 0x00,

    /** Service Record 12 */

    /* ServiceRecordHandle */
    0x0A, 0x00, 0x09, 0x00, 0x0C,

    /* ServiceClassIDList */
    0x35, 0x03, 0x19, 0x11, 0x17,

    /* ProtocolDescriptorList */
    0x35, 0x1E, 0x35, 0x06, 0x19, 0x01, 0x00, 0x09, 0x00, 0x0F,
    0x35, 0x14, 0x19, 0x00, 0x0F, 0x09, 0x01, 0x00, 0x35, 0x0C,
    0x09, 0x08, 0x00, 0x09, 0x08, 0x06, 0x09, 0x86, 0xDD, 0x09,
    0x88, 0x0B,

    /* BrowseGroupList  */
    0x35, 0x03, 0x19, 0x10, 0x02,

    /* LanguageBaseAttributeIDList  */
    0x35, 0x09, 0x09, 0x65, 0x6E, 0x09, 0x00, 0x6A, 0x09, 0x01,
    0x00,

    /* ServiceAvailability */
    0x08, 0xFF,

    /* BluetoothProfileDescriptorList */
    0x35, 0x08, 0x35, 0x06, 0x19, 0x11, 0x17, 0x09, 0x01, 0x00,

    /* ServiceName */
    0x25, 0x1D, 0x47, 0x72, 0x6F, 0x75, 0x70, 0x20, 0x41, 0x64,
    0x2D, 0x68, 0x6F, 0x63, 0x20, 0x4E, 0x65, 0x74, 0x77, 0x6F,
    0x72, 0x6B, 0x20, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
    0x00,

    /* ServiceDescription */
    0x25, 0x26, 0x50, 0x65, 0x72, 0x73, 0x6F, 0x6E, 0x61, 0x6C,
    0x20, 0x47, 0x72, 0x6F, 0x75, 0x70, 0x20, 0x41, 0x64, 0x2D,
    0x68, 0x6F, 0x63, 0x20, 0x4E, 0x65, 0x74, 0x77, 0x6F, 0x72,
    0x6B, 0x20, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x00,

    /* SecurityDescription */
    0x09, 0x00, 0x00,

    /* IPv4Subnet */
    0x25, 0x0B, 0x31, 0x30, 0x2E, 0x30, 0x2E, 0x30, 0x2E, 0x30,
    0x2F, 0x38, 0x00,

    /* IPv6Subnet */
    0x25, 0x0A, 0x66, 0x65, 0x38, 0x30, 0x3A, 0x3A, 0x2F, 0x34,
    0x38, 0x00,

    /** Service Record 13 */

    /* ServiceRecordHandle */
    0x0A, 0x00, 0x09, 0x00, 0x0D,

    /* ServiceClassIDList */
    0x35, 0x03, 0x19, 0x11, 0x15,

    /* ProtocolDescriptorList */
    0x35, 0x1E, 0x35, 0x06, 0x19, 0x01, 0x00, 0x09, 0x00, 0x0F,
    0x35, 0x14, 0x19, 0x00, 0x0F, 0x09, 0x01, 0x00, 0x35, 0x0C,
    0x09, 0x08, 0x00, 0x09, 0x08, 0x06, 0x09, 0x86, 0xDD, 0x09,
    0x88, 0x0B,

    /* BrowseGroupList  */
    0x35, 0x03, 0x19, 0x10, 0x02,

    /* LanguageBaseAttributeIDList  */
    0x35, 0x09, 0x09, 0x65, 0x6E, 0x09, 0x00, 0x6A, 0x09, 0x01,
    0x00,

    /* ServiceAvailability */
    0x08, 0xFF,

    /* BluetoothProfileDescriptorList */
    0x35, 0x08, 0x35, 0x06, 0x19, 0x11, 0x15, 0x09, 0x01, 0x00,

    /* ServiceName */
    0x25, 0x1D, 0x50, 0x65, 0x72, 0x73, 0x6F, 0x6E, 0x61, 0x6C,
    0x20, 0x41, 0x64, 0x2D, 0x68, 0x6F, 0x63, 0x20, 0x55, 0x73,
    0x65, 0x72, 0x20, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
    0x00,

    /* ServiceDescription */
    0x25, 0x1D, 0x50, 0x65, 0x72, 0x73, 0x6F, 0x6E, 0x61, 0x6C,
    0x20, 0x41, 0x64, 0x2D, 0x68, 0x6F, 0x63, 0x20, 0x55, 0x73,
    0x65, 0x72, 0x20, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
    0x00,

    /* SecurityDescription */
    0x09, 0x00, 0x00,

    /** Service Record 14 */

    /* ServiceRecordHandle */
    0x0A, 0x00, 0x09, 0x00, 0x0E,

    /* ServiceClassIDList */
    0x35, 0x03, 0x19, 0x11, 0x1B,

    /* ProtocolDescriptorList */
    0x35, 0x11, 0x35, 0x03, 0x19, 0x01, 0x00, 0x35, 0x05, 0x19,
    0x00, 0x03, 0x08, 0x08, 0x35, 0x03, 0x19, 0x00, 0x08,

    /* BrowseGroupList  */
    0x35, 0x03, 0x19, 0x10, 0x02,

    /* LanguageBaseAttributeIDList  */
    0x35, 0x09, 0x09, 0x65, 0x6E, 0x09, 0x00, 0x6A, 0x09, 0x01,
    0x00,

    /* BluetoothProfileDescriptorList */
    0x35, 0x08, 0x35, 0x06, 0x19, 0x11, 0x1A, 0x09, 0x01, 0x02,

    /* ServiceName */
    0x25, 0x08, 0x49, 0x6D, 0x61, 0x67, 0x69, 0x6E, 0x67, 0x00,

    /* HIDDeviceReleaseNumber */
    0x09, 0x86, 0x09,

    /* SupportedCapabalities */
    0x08, 0x01,

    /* SupportedFeatures */
    0x09, 0x00, 0x01,

    /* SupportedFunctions */
    0x0A, 0x00, 0x00, 0x00, 0x0F,

    /* TotalImagingDataCapacity */
    0x0B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    /** Service Record 15 */

    /* ServiceRecordHandle */
    0x0A, 0x00, 0x09, 0x00, 0x0F,

    /* ServiceClassIDList */
    0x35, 0x03, 0x19, 0x11, 0x1D,

    /* ServiceID */
    0x19, 0x01, 0x00,

    /* ProtocolDescriptorList */
    0x35, 0x11, 0x35, 0x03, 0x19, 0x01, 0x00, 0x35, 0x05, 0x19,
    0x00, 0x03, 0x08, 0x09, 0x35, 0x03, 0x19, 0x00, 0x08,

    /* BrowseGroupList  */
    0x35, 0x03, 0x19, 0x10, 0x02,

    /* LanguageBaseAttributeIDList  */
    0x35, 0x09, 0x09, 0x65, 0x6E, 0x09, 0x00, 0x6A, 0x09, 0x01,
    0x00,

    /* BluetoothProfileDescriptorList */
    0x35, 0x08, 0x35, 0x06, 0x19, 0x11, 0x1A, 0x09, 0x01, 0x02,

    /* ServiceName */
    0x25, 0x1B, 0x49, 0x6D, 0x61, 0x67, 0x69, 0x6E, 0x67, 0x20,
    0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6E, 0x63, 0x65, 0x64,
    0x20, 0x4F, 0x62, 0x6A, 0x65, 0x63, 0x74, 0x73, 0x00,

    /* HIDDeviceReleaseNumber */
    0x09, 0x86, 0x09,

    /* SupportedFunctions */
    0x0A, 0x00, 0x00, 0x00, 0x01,

    /** Service Record 16 */

    /* ServiceRecordHandle */
    0x0A, 0x00, 0x09, 0x00, 0x10,

    /* ServiceClassIDList */
    0x35, 0x03, 0x19, 0x11, 0x1C,

    /* ServiceID */
    0x19, 0x01, 0x00,

    /* ProtocolDescriptorList */
    0x35, 0x11, 0x35, 0x03, 0x19, 0x01, 0x00, 0x35, 0x05, 0x19,
    0x00, 0x03, 0x08, 0x0A, 0x35, 0x03, 0x19, 0x00, 0x08,

    /* BrowseGroupList  */
    0x35, 0x03, 0x19, 0x10, 0x02,

    /* LanguageBaseAttributeIDList  */
    0x35, 0x09, 0x09, 0x65, 0x6E, 0x09, 0x00, 0x6A, 0x09, 0x01,
    0x00,

    /* BluetoothProfileDescriptorList */
    0x35, 0x08, 0x35, 0x06, 0x19, 0x11, 0x1A, 0x09, 0x01, 0x02,

    /* ServiceName */
    0x25, 0x1A, 0x49, 0x6D, 0x61, 0x67, 0x69, 0x6E, 0x67, 0x20,
    0x41, 0x75, 0x74, 0x6F, 0x6D, 0x61, 0x74, 0x69, 0x63, 0x20,
    0x41, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x00,

    /* HIDDeviceReleaseNumber */
    0x09, 0x86, 0x0B,

    /* SupportedFunctions */
    0x0A, 0x00, 0x00, 0x00, 0x01,

    /** Service Record 17 */

    /* ServiceRecordHandle */
    0x0A, 0x00, 0x09, 0x00, 0x11,

    /* ServiceClassIDList */
    0x35, 0x09, 0x19, 0x11, 0x19, 0x19, 0x11, 0x23, 0x19, 0x11,
    0x18,

    /* ProtocolDescriptorList */
    0x35, 0x11, 0x35, 0x03, 0x19, 0x01, 0x00, 0x35, 0x05, 0x19,
    0x00, 0x03, 0x08, 0x0B, 0x35, 0x03, 0x19, 0x00, 0x08,

    /* BrowseGroupList  */
    0x35, 0x03, 0x19, 0x10, 0x02,

    /* LanguageBaseAttributeIDList  */
    0x35, 0x09, 0x09, 0x65, 0x6E, 0x09, 0x00, 0x6A, 0x09, 0x01,
    0x00,

    /* BluetoothProfileDescriptorList */
    0x35, 0x08, 0x35, 0x06, 0x19, 0x11, 0x22, 0x09, 0x01, 0x00,

    /* AdditionalProtocolDescriptorLists */
    0x35, 0x13, 0x35, 0x11, 0x35, 0x03, 0x19, 0x01, 0x00, 0x35,
    0x05, 0x19, 0x00, 0x03, 0x08, 0x0C, 0x35, 0x03, 0x19, 0x00,
    0x08,

    /* ServiceName */
    0x25, 0x0F, 0x42, 0x61, 0x73, 0x69, 0x63, 0x20, 0x50, 0x72,
    0x69, 0x6E, 0x74, 0x69, 0x6E, 0x67, 0x00,

    /* DocumentFormatsSupported */
    0x25, 0x0B, 0x42, 0x61, 0x73, 0x69, 0x63, 0x20, 0x54, 0x65,
    0x78, 0x74, 0x00,

    /* CharacterRepertoiresSupported */
    0x0C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,

    /* XHTML-PrintImageFormatsSupported */
    0x25, 0x0C, 0x58, 0x48, 0x54, 0x4D, 0x4C, 0x2D, 0x50, 0x72,
    0x69, 0x6E, 0x74, 0x00,

    /* ColorSupported */
    0x28, 0x01,

    /* 1284ID */
    0x25, 0x08, 0x31, 0x32, 0x38, 0x34, 0x20, 0x49, 0x44, 0x00,

    /* PrinterName */
    0x25, 0x04, 0x58, 0x59, 0x5A, 0x00,

    /* PrinterLocation */
    0x25, 0x04, 0x41, 0x42, 0x43, 0x00,

    /* DuplexSupported */
    0x28, 0x00,

    /* MediaTypesSupported */
    0x25, 0x0B, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6F, 0x6E, 0x65,
    0x72, 0x79, 0x00,

    /* MaxMediaWidth */
    0x09, 0x00, 0x10,

    /* MaxMediaLength */
    0x09, 0x00, 0x10,

    /* EnhancedLayoutSupported */
    0x28, 0x00,

    /* ReferencePrintingRUISupported */
    0x28, 0x00,

    /* DirectPrintingRUISupported */
    0x28, 0x00,

    /* ReferencePrintingTopURL */
    0x45, 0x04, 0x78, 0x79, 0x7A, 0x00,

    /* DirectPrintingTopURL */
    0x45, 0x04, 0x78, 0x79, 0x7A, 0x00,

    /** Service Record 18 */

    /* ServiceRecordHandle */
    0x0A, 0x00, 0x09, 0x00, 0x12,

    /* ServiceClassIDList */
    0x35, 0x03, 0x19, 0x11, 0x20,

    /* ProtocolDescriptorList */
    0x35, 0x11, 0x35, 0x03, 0x19, 0x01, 0x00, 0x35, 0x05, 0x19,
    0x00, 0x03, 0x08, 0x0D, 0x35, 0x03, 0x19, 0x00, 0x08,

    /* BrowseGroupList  */
    0x35, 0x03, 0x19, 0x10, 0x02,

    /* LanguageBaseAttributeIDList  */
    0x35, 0x09, 0x09, 0x65, 0x6E, 0x09, 0x00, 0x6A, 0x09, 0x01,
    0x00,

    /* BluetoothProfileDescriptorList */
    0x35, 0x08, 0x35, 0x06, 0x19, 0x11, 0x22, 0x09, 0x01, 0x00,

    /* AdditionalProtocolDescriptorLists */
    0x35, 0x13, 0x35, 0x11, 0x35, 0x03, 0x19, 0x01, 0x00, 0x35,
    0x05, 0x19, 0x00, 0x03, 0x08, 0x0E, 0x35, 0x03, 0x19, 0x00,
    0x08,

    /* ServiceName */
    0x25, 0x1B, 0x42, 0x61, 0x73, 0x69, 0x63, 0x20, 0x50, 0x72,
    0x69, 0x6E, 0x74, 0x69, 0x6E, 0x67, 0x20, 0x52, 0x65, 0x66,
    0x20, 0x4F, 0x62, 0x6A, 0x65, 0x63, 0x74, 0x73, 0x00,

    /** Service Record 19 */

    /* ServiceRecordHandle */
    0x0A, 0x00, 0x09, 0x00, 0x13,

    /* ServiceClassIDList */
    0x35, 0x03, 0x19, 0x11, 0x21,

    /* ProtocolDescriptorList */
    0x35, 0x11, 0x35, 0x03, 0x19, 0x01, 0x00, 0x35, 0x05, 0x19,
    0x00, 0x03, 0x08, 0x0F, 0x35, 0x03, 0x19, 0x00, 0x08,

    /* BrowseGroupList  */
    0x35, 0x03, 0x19, 0x10, 0x02,

    /* LanguageBaseAttributeIDList  */
    0x35, 0x09, 0x09, 0x65, 0x6E, 0x09, 0x00, 0x6A, 0x09, 0x01,
    0x00,

    /* ServiceName */
    0x25, 0x26, 0x50, 0x72, 0x69, 0x6E, 0x74, 0x65, 0x72, 0x20,
    0x41, 0x64, 0x6D, 0x69, 0x6E, 0x69, 0x73, 0x74, 0x72, 0x61,
    0x74, 0x69, 0x76, 0x65, 0x20, 0x55, 0x73, 0x65, 0x72, 0x20,
    0x49, 0x6E, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x00,

    /* RUIFormatsSupported */
    0x25, 0x04, 0x41, 0x42, 0x43, 0x00,

    /* PrinterAdminRUITopURL */
    0x45, 0x04, 0x41, 0x42, 0x43, 0x00,

    /** Service Record 20 */

    /* ServiceRecordHandle */
    0x0A, 0x00, 0x09, 0x00, 0x14,

    /* ServiceClassIDList */
    0x35, 0x06, 0x19, 0x11, 0x0E, 0x19, 0x11, 0x0F,

    /* ProtocolDescriptorList */
    0x35, 0x10, 0x35, 0x06, 0x19, 0x01, 0x00, 0x09, 0x00, 0x17,
    0x35, 0x06, 0x19, 0x00, 0x17, 0x09, 0x01, 0x04,

    /* BrowseGroupList  */
    0x35, 0x03, 0x19, 0x10, 0x02,

    /* LanguageBaseAttributeIDList  */
    0x35, 0x09, 0x09, 0x65, 0x6E, 0x09, 0x00, 0x6A, 0x09, 0x01,
    0x00,

    /* BluetoothProfileDescriptorList */
    0x35, 0x08, 0x35, 0x06, 0x19, 0x11, 0x0E, 0x09, 0x01, 0x06,

    /* AdditionalProtocolDescriptorLists */
    0x35, 0x12, 0x35, 0x10, 0x35, 0x06, 0x19, 0x01, 0x00, 0x09,
    0x00, 0x1B, 0x35, 0x06, 0x19, 0x00, 0x17, 0x09, 0x01, 0x04,

    /* ServiceName */
    0x25, 0x11, 0x41, 0x56, 0x52, 0x43, 0x50, 0x20, 0x43, 0x6F,
    0x6E, 0x74, 0x72, 0x6F, 0x6C, 0x6C, 0x65, 0x72, 0x00,

    /* ProviderName */
    0x25, 0x09, 0x4D, 0x69, 0x6E, 0x64, 0x54, 0x72, 0x65, 0x65,
    0x00,

    /* SupportedFeatures */
    0x09, 0x03, 0xCF,

    /** Service Record 21 */

    /* ServiceRecordHandle */
    0x0A, 0x00, 0x09, 0x00, 0x15,

    /* ServiceClassIDList */
    0x35, 0x03, 0x19, 0x11, 0x0C,

    /* ProtocolDescriptorList */
    0x35, 0x10, 0x35, 0x06, 0x19, 0x01, 0x00, 0x09, 0x00, 0x17,
    0x35, 0x06, 0x19, 0x00, 0x17, 0x09, 0x01, 0x04,

    /* BrowseGroupList  */
    0x35, 0x03, 0x19, 0x10, 0x02,

    /* LanguageBaseAttributeIDList  */
    0x35, 0x09, 0x09, 0x65, 0x6E, 0x09, 0x00, 0x6A, 0x09, 0x01,
    0x00,

    /* BluetoothProfileDescriptorList */
    0x35, 0x08, 0x35, 0x06, 0x19, 0x11, 0x0E, 0x09, 0x01, 0x06,

    /* AdditionalProtocolDescriptorLists */
    0x35, 0x21, 0x35, 0x1F, 0x35, 0x06, 0x19, 0x01, 0x00, 0x09,
    0x00, 0x1B, 0x35, 0x08, 0x19, 0x00, 0x17, 0x09, 0x01, 0x04,
    0x35, 0x0D, 0x35, 0x06, 0x19, 0x01, 0x00, 0x09, 0x84, 0x01,
    0x35, 0x03, 0x19, 0x00, 0x08,

    /* ServiceName */
    0x25, 0x0D, 0x41, 0x56, 0x52, 0x43, 0x50, 0x20, 0x54, 0x61,
    0x72, 0x67, 0x65, 0x74, 0x00,

    /* ProviderName */
    0x25, 0x09, 0x4D, 0x69, 0x6E, 0x64, 0x54, 0x72, 0x65, 0x65,
    0x00,

    /* SupportedFeatures */
    0x09, 0x01, 0xFF,

    /** Service Record 22 */

    /* ServiceRecordHandle */
    0x0A, 0x00, 0x09, 0x00, 0x16,

    /* ServiceClassIDList */
    0x35, 0x03, 0x19, 0x11, 0x2E,

    /* BrowseGroupList  */
    0x35, 0x03, 0x19, 0x10, 0x02,

    /* LanguageBaseAttributeIDList  */
    0x35, 0x09, 0x09, 0x65, 0x6E, 0x09, 0x00, 0x6A, 0x09, 0x01,
    0x00,

    /* BluetoothProfileDescriptorList */
    0x35, 0x08, 0x35, 0x06, 0x19, 0x11, 0x30, 0x09, 0x01, 0x02,

    /* ServiceName */
    0x25, 0x16, 0x50, 0x68, 0x6F, 0x6E, 0x65, 0x62, 0x6F, 0x6F,
    0x6B, 0x20, 0x41, 0x63, 0x63, 0x63, 0x65, 0x73, 0x73, 0x20,
    0x50, 0x43, 0x45, 0x00,

    /** Service Record 23 */

    /* ServiceRecordHandle */
    0x0A, 0x00, 0x09, 0x00, 0x17,

    /* ServiceClassIDList */
    0x35, 0x03, 0x19, 0x11, 0x2F,

    /* ProtocolDescriptorList */
    0x35, 0x11, 0x35, 0x03, 0x19, 0x01, 0x00, 0x35, 0x05, 0x19,
    0x00, 0x03, 0x08, 0x10, 0x35, 0x03, 0x19, 0x00, 0x08,

    /* BrowseGroupList  */
    0x35, 0x03, 0x19, 0x10, 0x02,

    /* LanguageBaseAttributeIDList  */
    0x35, 0x09, 0x09, 0x65, 0x6E, 0x09, 0x00, 0x6A, 0x09, 0x01,
    0x00,

    /* BluetoothProfileDescriptorList */
    0x35, 0x08, 0x35, 0x06, 0x19, 0x11, 0x30, 0x09, 0x01, 0x02,

    /* ServiceName */
    0x25, 0x16, 0x50, 0x68, 0x6F, 0x6E, 0x65, 0x62, 0x6F, 0x6F,
    0x6B, 0x20, 0x41, 0x63, 0x63, 0x63, 0x65, 0x73, 0x73, 0x20,
    0x50, 0x53, 0x45, 0x00,

    /* HIDDeviceReleaseNumber */
    0x09, 0x88, 0x03,

    /* SupportedRepositories */
    0x08, 0x0F,

    /* MapSupportedFeatures */
    0x0A, 0x00, 0x00, 0x03, 0xFF,

    /** Service Record 24 */

    /* ServiceRecordHandle */
    0x0A, 0x00, 0x09, 0x00, 0x18,

    /* ServiceClassIDList */
    0x35, 0x03, 0x19, 0x12, 0x00,

    /* BrowseGroupList  */
    0x35, 0x03, 0x19, 0x10, 0x02,

    /* LanguageBaseAttributeIDList  */
    0x35, 0x09, 0x09, 0x65, 0x6E, 0x09, 0x00, 0x6A, 0x09, 0x01,
    0x00,

    /* DocumentationURL */
    0x45, 0x12, 0x75, 0x72, 0x6C, 0x20, 0x64, 0x6F, 0x63, 0x75,
    0x6D, 0x65, 0x6E, 0x74, 0x61, 0x74, 0x69, 0x6F, 0x6E, 0x00,

    /* ClientExecutableURL */
    0x45, 0x0F, 0x75, 0x72, 0x6C, 0x20, 0x65, 0x78, 0x65, 0x63,
    0x75, 0x74, 0x61, 0x62, 0x6C, 0x65, 0x00,

    /* ServiceDescription */
    0x25, 0x09, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x49, 0x44,
    0x00,

    /* HIDDeviceReleaseNumber */
    0x09, 0x01, 0x02,

    /* HIDProfileVersion */
    0x09, 0xFF, 0xFF,

    /* HIDDeviceSubclass */
    0x09, 0xFF, 0xFF,

    /* HIDCountryCode */
    0x09, 0x06, 0x20,

    /* HIDVirtualCable */
    0x28, 0x01,

    /* HIDReconnectInitiate */
    0x09, 0x00, 0x01,

    /** Service Record 25 */

    /* ServiceRecordHandle */
    0x0A, 0x00, 0x09, 0x00, 0x19,

    /* ServiceClassIDList */
    0x35, 0x03, 0x19, 0x12, 0x00,

    /* BrowseGroupList  */
    0x35, 0x03, 0x19, 0x10, 0x02,

    /* LanguageBaseAttributeIDList  */
    0x35, 0x09, 0x09, 0x65, 0x6E, 0x09, 0x00, 0x6A, 0x09, 0x01,
    0x00,

    /* DocumentationURL */
    0x45, 0x14, 0x75, 0x72, 0x6C, 0x20, 0x64, 0x6F, 0x63, 0x75,
    0x6D, 0x65, 0x6E, 0x74, 0x61, 0x74, 0x69, 0x6F, 0x6E, 0x20,
    0x32, 0x00,

    /* ClientExecutableURL */
    0x45, 0x11, 0x75, 0x72, 0x6C, 0x20, 0x65, 0x78, 0x65, 0x63,
    0x75, 0x74, 0x61, 0x62, 0x6C, 0x65, 0x20, 0x32, 0x00,

    /* ServiceDescription */
    0x25, 0x0B, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x49, 0x44,
    0x20, 0x32, 0x00,

    /* HIDDeviceReleaseNumber */
    0x09, 0x01, 0x02,

    /* HIDProfileVersion */
    0x09, 0xFF, 0xFF,

    /* HIDDeviceSubclass */
    0x09, 0xFF, 0xFF,

    /* HIDCountryCode */
    0x09, 0x06, 0x20,

    /* HIDVirtualCable */
    0x28, 0x00,

    /* HIDReconnectInitiate */
    0x09, 0x00, 0x02,

    /** Service Record 26 */

    /* ServiceRecordHandle */
    0x0A, 0x00, 0x09, 0x00, 0x1A,

    /* ServiceClassIDList */
    0x35, 0x06, 0x19, 0x14, 0x02, 0x19, 0x14, 0x01,

    /* ProtocolDescriptorList */
    0x35, 0x10, 0x35, 0x06, 0x19, 0x01, 0x00, 0x09, 0x10, 0x03,
    0x35, 0x06, 0x19, 0x00, 0x1E, 0x09, 0x01, 0x00,

    /* BrowseGroupList  */
    0x35, 0x03, 0x19, 0x10, 0x02,

    /* LanguageBaseAttributeIDList  */
    0x35, 0x09, 0x09, 0x65, 0x6E, 0x09, 0x00, 0x6A, 0x09, 0x01,
    0x00,

    /* BluetoothProfileDescriptorList */
    0x35, 0x08, 0x35, 0x06, 0x19, 0x14, 0x00, 0x09, 0x01, 0x01,

    /* AdditionalProtocolDescriptorLists */
    0x35, 0x0F, 0x35, 0x0D, 0x35, 0x06, 0x19, 0x01, 0x00, 0x09,
    0x10, 0x05, 0x35, 0x03, 0x19, 0x00, 0x1F,

    /* ServiceName */
    0x25, 0x0F, 0x50, 0x75, 0x6C, 0x73, 0x65, 0x20, 0x4F, 0x78,
    0x69, 0x6D, 0x65, 0x74, 0x65, 0x72, 0x00,

    /* ServiceDescription */
    0x25, 0x12, 0x50, 0x75, 0x6C, 0x73, 0x65, 0x20, 0x4D, 0x65,
    0x61, 0x73, 0x75, 0x72, 0x65, 0x6D, 0x65, 0x6E, 0x74, 0x00,

    /* ProviderName */
    0x25, 0x09, 0x4D, 0x69, 0x6E, 0x64, 0x74, 0x72, 0x65, 0x65,
    0x00,

    /* HIDDeviceReleaseNumber */
    0x09, 0x00, 0x00, 0x35, 0x1B, 0x08, 0x01, 0x09, 0x10, 0x04,
    0x08, 0x00, 0x25, 0x12, 0x50, 0x75, 0x6C, 0x73, 0x65, 0x20,
    0x4D, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6D, 0x65, 0x6E,
    0x74, 0x00,

    /* Supported Data Stores List */
    0x08, 0x01,

    /* MCAPSupportedProcedures */
    0x08, 0x1E,

    /** Service Record 27 */

    /* ServiceRecordHandle */
    0x0A, 0x00, 0x09, 0x00, 0x1B,

    /* ServiceClassIDList */
    0x35, 0x03, 0x19, 0x11, 0x33,

    /* ProtocolDescriptorList */
    0x35, 0x11, 0x35, 0x03, 0x19, 0x01, 0x00, 0x35, 0x05, 0x19,
    0x00, 0x03, 0x08, 0x11, 0x35, 0x03, 0x19, 0x00, 0x08,

    /* BrowseGroupList  */
    0x35, 0x03, 0x19, 0x10, 0x02,

    /* LanguageBaseAttributeIDList  */
    0x35, 0x09, 0x09, 0x65, 0x6E, 0x09, 0x00, 0x6A, 0x09, 0x01,
    0x00,

    /* BluetoothProfileDescriptorList */
    0x35, 0x08, 0x35, 0x06, 0x19, 0x11, 0x34, 0x09, 0x01, 0x04,

    /* ServiceName */
    0x25, 0x19, 0x4D, 0x41, 0x50, 0x20, 0x4E, 0x6F, 0x74, 0x69,
    0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6F, 0x6E, 0x20, 0x53,
    0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x00,

    /* HIDDeviceReleaseNumber */
    0x09, 0x86, 0x03,

    /* MapSupportedFeatures */
    0x0A, 0x00, 0x77, 0xFF, 0xFF,

    /** Service Record 28 */

    /* ServiceRecordHandle */
    0x0A, 0x00, 0x09, 0x00, 0x1C,

    /* ServiceClassIDList */
    0x35, 0x03, 0x19, 0x11, 0x32,

    /* ProtocolDescriptorList */
    0x35, 0x11, 0x35, 0x03, 0x19, 0x01, 0x00, 0x35, 0x05, 0x19,
    0x00, 0x03, 0x08, 0x12, 0x35, 0x03, 0x19, 0x00, 0x08,

    /* BrowseGroupList  */
    0x35, 0x03, 0x19, 0x10, 0x02,

    /* LanguageBaseAttributeIDList  */
    0x35, 0x09, 0x09, 0x65, 0x6E, 0x09, 0x00, 0x6A, 0x09, 0x01,
    0x00,

    /* BluetoothProfileDescriptorList */
    0x35, 0x08, 0x35, 0x06, 0x19, 0x11, 0x34, 0x09, 0x01, 0x04,

    /* ServiceName */
    0x25, 0x13, 0x4D, 0x41, 0x50, 0x20, 0x41, 0x63, 0x63, 0x65,
    0x73, 0x73, 0x20, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
    0x00,

    /* HIDDeviceReleaseNumber */
    0x09, 0x86, 0x03,

    /* MASInstanceID */
    0x08, 0x00,

    /* SupportedMessageTypes */
    0x08, 0x1F,

    /* MapSupportedFeatures */
    0x0A, 0x00, 0x7F, 0xFF, 0xFF,

    /** Service Record 29 */

    /* ServiceRecordHandle */
    0x0A, 0x00, 0x09, 0x00, 0x1D,

    /* ServiceClassIDList */
    0x35, 0x03, 0x19, 0x11, 0x32,

    /* ProtocolDescriptorList */
    0x35, 0x11, 0x35, 0x03, 0x19, 0x01, 0x00, 0x35, 0x05, 0x19,
    0x00, 0x03, 0x08, 0x13, 0x35, 0x03, 0x19, 0x00, 0x08,

    /* BrowseGroupList  */
    0x35, 0x03, 0x19, 0x10, 0x02,

    /* LanguageBaseAttributeIDList  */
    0x35, 0x09, 0x09, 0x65, 0x6E, 0x09, 0x00, 0x6A, 0x09, 0x01,
    0x00,

    /* BluetoothProfileDescriptorList */
    0x35, 0x08, 0x35, 0x06, 0x19, 0x11, 0x34, 0x09, 0x01, 0x04,

    /* ServiceName */
    0x25, 0x13, 0x4D, 0x41, 0x50, 0x20, 0x41, 0x63, 0x63, 0x65,
    0x73, 0x73, 0x20, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
    0x00,

    /* HIDDeviceReleaseNumber */
    0x09, 0x86, 0x05,

    /* MASInstanceID */
    0x08, 0x00,

    /* SupportedMessageTypes */
    0x08, 0x1F,

    /* MapSupportedFeatures */
    0x0A, 0x00, 0x7F, 0xFF, 0xFF,

    /** Service Record 30 */

    /* ServiceRecordHandle */
    0x0A, 0x00, 0x09, 0x00, 0x1E,

    /* ServiceClassIDList */
    0x35, 0x03, 0x19, 0x11, 0x3B,

    /* BrowseGroupList  */
    0x35, 0x03, 0x19, 0x10, 0x02,

    /* LanguageBaseAttributeIDList  */
    0x35, 0x09, 0x09, 0x65, 0x6E, 0x09, 0x00, 0x6A, 0x09, 0x01,
    0x00,

    /* BluetoothProfileDescriptorList */
    0x35, 0x08, 0x35, 0x06, 0x19, 0x11, 0x3A, 0x09, 0x01, 0x00,

    /* HIDDeviceReleaseNumber */
    0x0B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    /* HIDProfileVersion */
    0x0B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    /* HIDDeviceSubclass */
    0x09, 0x00, 0x00,

    /** Service Record 31 */

    /* ServiceRecordHandle */
    0x0A, 0x00, 0x09, 0x00, 0x1F,

    /* ServiceClassIDList */
    0x35, 0x03, 0x19, 0x18, 0x00,

    /* ProtocolDescriptorList */
    0x35, 0x13, 0x35, 0x06, 0x19, 0x01, 0x00, 0x09, 0x00, 0x1F,
    0x35, 0x09, 0x19, 0x00, 0x07, 0x09, 0x00, 0x01, 0x09, 0x00,
    0x05,

    /* BrowseGroupList  */
    0x35, 0x03, 0x19, 0x10, 0x02,

    /* LanguageBaseAttributeIDList  */
    0x35, 0x09, 0x09, 0x65, 0x6E, 0x09, 0x00, 0x6A, 0x09, 0x01,
    0x00,

    /** Service Record 32 */

    /* ServiceRecordHandle */
    0x0A, 0x00, 0x09, 0x00, 0x20,

    /* ServiceClassIDList */
    0x35, 0x03, 0x19, 0x18, 0x01,

    /* ProtocolDescriptorList */
    0x35, 0x13, 0x35, 0x06, 0x19, 0x01, 0x00, 0x09, 0x00, 0x1F,
    0x35, 0x09, 0x19, 0x00, 0x07, 0x09, 0x00, 0x06, 0x09, 0x00,
    0x09,

    /* BrowseGroupList  */
    0x35, 0x03, 0x19, 0x10, 0x02,

    /* LanguageBaseAttributeIDList  */
    0x35, 0x09, 0x09, 0x65, 0x6E, 0x09, 0x00, 0x6A, 0x09, 0x01,
    0x00,

    /** Service Record 33 */

    /* ServiceRecordHandle */
    0x0A, 0x00, 0x09, 0x00, 0x21,

    /* ServiceClassIDList */
    0x35, 0x03, 0x19, 0x18, 0x0A,

    /* ProtocolDescriptorList */
    0x35, 0x13, 0x35, 0x06, 0x19, 0x01, 0x00, 0x09, 0x00, 0x1F,
    0x35, 0x09, 0x19, 0x00, 0x07, 0x09, 0x00, 0x0A, 0x09, 0x00,
    0x1A,

    /* BrowseGroupList  */
    0x35, 0x03, 0x19, 0x10, 0x02,

    /* LanguageBaseAttributeIDList  */
    0x35, 0x09, 0x09, 0x65, 0x6E, 0x09, 0x00, 0x6A, 0x09, 0x01,
    0x00,

    /** Service Record 34 */

    /* ServiceRecordHandle */
    0x0A, 0x00, 0x09, 0x00, 0x22,

    /* ServiceClassIDList */
    0x35, 0x03, 0x19, 0x18, 0x0F,

    /* ProtocolDescriptorList */
    0x35, 0x13, 0x35, 0x06, 0x19, 0x01, 0x00, 0x09, 0x00, 0x1F,
    0x35, 0x09, 0x19, 0x00, 0x07, 0x09, 0x00, 0x1B, 0x09, 0x00,
    0x1D,

    /* BrowseGroupList  */
    0x35, 0x03, 0x19, 0x10, 0x02,

    /* LanguageBaseAttributeIDList  */
    0x35, 0x09, 0x09, 0x65, 0x6E, 0x09, 0x00, 0x6A, 0x09, 0x01,
    0x00,

    /** Service Record 35 */

    /* ServiceRecordHandle */
    0x0A, 0x00, 0x09, 0x00, 0x23,

    /* ServiceClassIDList */
    0x35, 0x03, 0x19, 0x18, 0x14,

    /* ProtocolDescriptorList */
    0x35, 0x13, 0x35, 0x06, 0x19, 0x01, 0x00, 0x09, 0x00, 0x1F,
    0x35, 0x09, 0x19, 0x00, 0x07, 0x09, 0x00, 0x1E, 0x09, 0x00,
    0x28,

    /* BrowseGroupList  */
    0x35, 0x03, 0x19, 0x10, 0x02,

    /* LanguageBaseAttributeIDList  */
    0x35, 0x09, 0x09, 0x65, 0x6E, 0x09, 0x00, 0x6A, 0x09, 0x01,
    0x00,

    /** Service Record 36 */

    /* ServiceRecordHandle */
    0x0A, 0x00, 0x09, 0x00, 0x24,

    /* ServiceClassIDList */
    0x35, 0x03, 0x19, 0x18, 0x16,

    /* ProtocolDescriptorList */
    0x35, 0x13, 0x35, 0x06, 0x19, 0x01, 0x00, 0x09, 0x00, 0x1F,
    0x35, 0x09, 0x19, 0x00, 0x07, 0x09, 0x00, 0x1E, 0x09, 0x00,
    0x28,

    /* BrowseGroupList  */
    0x35, 0x03, 0x19, 0x10, 0x02,

    /* LanguageBaseAttributeIDList  */
    0x35, 0x09, 0x09, 0x65, 0x6E, 0x09, 0x00, 0x6A, 0x09, 0x01,
    0x00,

    /** Service Record 37 */

    /* ServiceRecordHandle */
    0x0A, 0x00, 0x09, 0x00, 0x25,

    /* ServiceClassIDList */
    0x35, 0x03, 0x19, 0x18, 0x18,

    /* ProtocolDescriptorList */
    0x35, 0x13, 0x35, 0x06, 0x19, 0x01, 0x00, 0x09, 0x00, 0x1F,
    0x35, 0x09, 0x19, 0x00, 0x07, 0x09, 0x00, 0x1E, 0x09, 0x00,
    0x28,

    /* BrowseGroupList  */
    0x35, 0x03, 0x19, 0x10, 0x02,

    /* LanguageBaseAttributeIDList  */
    0x35, 0x09, 0x09, 0x65, 0x6E, 0x09, 0x00, 0x6A, 0x09, 0x01,
    0x00,

    /** Service Record 38 */

    /* ServiceRecordHandle */
    0x0A, 0x00, 0x09, 0x00, 0x26,

    /* ServiceClassIDList */
    0x35, 0x03, 0x19, 0x18, 0x23,

    /* ProtocolDescriptorList */
    0x35, 0x13, 0x35, 0x06, 0x19, 0x01, 0x00, 0x09, 0x00, 0x1F,
    0x35, 0x09, 0x19, 0x00, 0x07, 0x09, 0x00, 0x1E, 0x09, 0x00,
    0x28,

    /* BrowseGroupList  */
    0x35, 0x03, 0x19, 0x10, 0x02,

    /* LanguageBaseAttributeIDList  */
    0x35, 0x09, 0x09, 0x65, 0x6E, 0x09, 0x00, 0x6A, 0x09, 0x01,
    0x00,

    /** Service Record 39 */

    /* ServiceRecordHandle */
    0x0A, 0x00, 0x09, 0x00, 0x27,

    /* ServiceClassIDList */
    0x35, 0x03, 0x19, 0x18, 0x05,

    /* ProtocolDescriptorList */
    0x35, 0x13, 0x35, 0x06, 0x19, 0x01, 0x00, 0x09, 0x00, 0x1F,
    0x35, 0x09, 0x19, 0x00, 0x07, 0x09, 0x00, 0x1E, 0x09, 0x00,
    0x28,

    /* BrowseGroupList  */
    0x35, 0x03, 0x19, 0x10, 0x02,

    /* LanguageBaseAttributeIDList  */
    0x35, 0x09, 0x09, 0x65, 0x6E, 0x09, 0x00, 0x6A, 0x09, 0x01,
    0x00,

    /** Service Record 40 */

    /* ServiceRecordHandle */
    0x0A, 0x00, 0x09, 0x00, 0x28,

    /* ServiceClassIDList */
    0x35, 0x03, 0x19, 0x11, 0x3D,

    /* ProtocolDescriptorList */
    0x35, 0x0D, 0x35, 0x06, 0x19, 0x01, 0x00, 0x09, 0x80, 0x03,
    0x35, 0x03, 0x19, 0x00, 0x08,

    /* BrowseGroupList  */
    0x35, 0x03, 0x19, 0x10, 0x02,

    /* LanguageBaseAttributeIDList  */
    0x35, 0x09, 0x09, 0x65, 0x6E, 0x09, 0x00, 0x6A, 0x09, 0x01,
    0x00,

    /* BluetoothProfileDescriptorList */
    0x35, 0x08, 0x35, 0x06, 0x19, 0x11, 0x3E, 0x09, 0x01, 0x00,

    /* ServiceName */
    0x25, 0x19, 0x43, 0x54, 0x4E, 0x20, 0x4E, 0x6F, 0x74, 0x69,
    0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6F, 0x6E, 0x20, 0x53,
    0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x00,

    /* MapSupportedFeatures */
    0x0A, 0x00, 0x00, 0x00, 0x7F,

    /** Service Record 41 */

    /* ServiceRecordHandle */
    0x0A, 0x00, 0x09, 0x00, 0x29,

    /* ServiceClassIDList */
    0x35, 0x03, 0x19, 0x11, 0x3C,

    /* ProtocolDescriptorList */
    0x35, 0x0D, 0x35, 0x06, 0x19, 0x01, 0x00, 0x09, 0x80, 0x03,
    0x35, 0x03, 0x19, 0x00, 0x08,

    /* BrowseGroupList  */
    0x35, 0x03, 0x19, 0x10, 0x02,

    /* LanguageBaseAttributeIDList  */
    0x35, 0x09, 0x09, 0x65, 0x6E, 0x09, 0x00, 0x6A, 0x09, 0x01,
    0x00,

    /* BluetoothProfileDescriptorList */
    0x35, 0x08, 0x35, 0x06, 0x19, 0x11, 0x3E, 0x09, 0x01, 0x00,

    /* ServiceName */
    0x25, 0x13, 0x43, 0x54, 0x4E, 0x20, 0x41, 0x63, 0x63, 0x65,
    0x73, 0x73, 0x20, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
    0x00,

    /* MASInstanceID */
    0x08, 0x00,

    /* MapSupportedFeatures */
    0x0A, 0x00, 0x00, 0x00, 0x7F,

    /** Service Record 42 */

    /* ServiceRecordHandle */
    0x0A, 0x00, 0x09, 0x00, 0x2A,

    /* ServiceClassIDList */
    0x35, 0x03, 0x19, 0x11, 0x3C,

    /* ProtocolDescriptorList */
    0x35, 0x0D, 0x35, 0x06, 0x19, 0x01, 0x00, 0x09, 0x80, 0x05,
    0x35, 0x03, 0x19, 0x00, 0x08,

    /* BrowseGroupList  */
    0x35, 0x03, 0x19, 0x10, 0x02,

    /* LanguageBaseAttributeIDList  */
    0x35, 0x09, 0x09, 0x65, 0x6E, 0x09, 0x00, 0x6A, 0x09, 0x01,
    0x00,

    /* BluetoothProfileDescriptorList */
    0x35, 0x08, 0x35, 0x06, 0x19, 0x11, 0x3E, 0x09, 0x01, 0x00,

    /* ServiceName */
    0x25, 0x13, 0x43, 0x54, 0x4E, 0x20, 0x41, 0x63, 0x63, 0x65,
    0x73, 0x73, 0x20, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
    0x00,

    /* MASInstanceID */
    0x08, 0x00,

    /* MapSupportedFeatures */
    0x0A, 0x00, 0x00, 0x00, 0x7F
};

/* Attribute structure array */
struct attr attr_arr[] = {
    /** Service Record 0 */

    /* ServiceRecordHandle */
    {0x0000, 0x0005, value_arr + 0x0000},

    /* ServiceClassIDList */
    {0x0001, 0x0005, value_arr + 0x0005},

    /* VersionNumberList */
    {0x0200, 0x0005, value_arr + 0x000A},

    /** Service Record 1 */
    /* ServiceRecordHandle */
    {0x0000, 0x0005, value_arr + 0x000F},

    /* ServiceClassIDList */
    {0x0001, 0x0008, value_arr + 0x0014},

    /* ProtocolDescriptorList */
    {0x0004, 0x000E, value_arr + 0x001C},

    /* BrowseGroupList  */
    {0x0005, 0x0005, value_arr + 0x002A},

    /* LanguageBaseAttributeIDList  */
    {0x0006, 0x000B, value_arr + 0x002F},

    /* BluetoothProfileDescriptorList */
    {0x0009, 0x000A, value_arr + 0x003A},

    /* ServiceName */
    {0x0100, 0x000D, value_arr + 0x0044},

    /** Service Record 2 */
    /* ServiceRecordHandle */
    {0x0000, 0x0005, value_arr + 0x0051},

    /* ServiceClassIDList */
    {0x0001, 0x0005, value_arr + 0x0056},

    /* ProtocolDescriptorList */
    {0x0004, 0x000E, value_arr + 0x005B},

    /* BrowseGroupList  */
    {0x0005, 0x0005, value_arr + 0x0069},

    /* LanguageBaseAttributeIDList  */
    {0x0006, 0x000B, value_arr + 0x006E},

    /* BluetoothProfileDescriptorList */
    {0x0009, 0x000A, value_arr + 0x0079},

    /* ServiceName */
    {0x0100, 0x0007, value_arr + 0x0083},

    /** Service Record 3 */
    /* ServiceRecordHandle */
    {0x0000, 0x0005, value_arr + 0x008A},

    /* ServiceClassIDList */
    {0x0001, 0x0016, value_arr + 0x008F},

    /* ProtocolDescriptorList */
    {0x0004, 0x000E, value_arr + 0x00A5},

    /* BrowseGroupList  */
    {0x0005, 0x0005, value_arr + 0x00B3},

    /* LanguageBaseAttributeIDList  */
    {0x0006, 0x000B, value_arr + 0x00B8},

    /* BluetoothProfileDescriptorList */
    {0x0009, 0x000A, value_arr + 0x00C3},

    /* ServiceName */
    {0x0100, 0x0007, value_arr + 0x00CD},

    /** Service Record 4 */
    /* ServiceRecordHandle */
    {0x0000, 0x0005, value_arr + 0x00D4},

    /* ServiceClassIDList */
    {0x0001, 0x0005, value_arr + 0x00D9},

    /* ProtocolDescriptorList */
    {0x0004, 0x0013, value_arr + 0x00DE},

    /* BrowseGroupList  */
    {0x0005, 0x0005, value_arr + 0x00F1},

    /* LanguageBaseAttributeIDList  */
    {0x0006, 0x000B, value_arr + 0x00F6},

    /* BluetoothProfileDescriptorList */
    {0x0009, 0x000A, value_arr + 0x0101},

    /* ServiceName */
    {0x0100, 0x0015, value_arr + 0x010B},

    /* HIDDeviceReleaseNumber */
    {0x0200, 0x0003, value_arr + 0x0120},

    /** Service Record 5 */
    /* ServiceRecordHandle */
    {0x0000, 0x0005, value_arr + 0x0123},

    /* ServiceClassIDList */
    {0x0001, 0x0008, value_arr + 0x0128},

    /* ProtocolDescriptorList */
    {0x0004, 0x000E, value_arr + 0x0130},

    /* BrowseGroupList  */
    {0x0005, 0x0005, value_arr + 0x013E},

    /* LanguageBaseAttributeIDList  */
    {0x0006, 0x000B, value_arr + 0x0143},

    /* BluetoothProfileDescriptorList */
    {0x0009, 0x000A, value_arr + 0x014E},

    /* ServiceName */
    {0x0100, 0x0006, value_arr + 0x0158},

    /* SupportedFeatures */
    {0x0311, 0x0003, value_arr + 0x015E},

    /** Service Record 6 */
    /* ServiceRecordHandle */
    {0x0000, 0x0005, value_arr + 0x0161},

    /* ServiceClassIDList */
    {0x0001, 0x0008, value_arr + 0x0166},

    /* ProtocolDescriptorList */
    {0x0004, 0x000E, value_arr + 0x016E},

    /* BrowseGroupList  */
    {0x0005, 0x0005, value_arr + 0x017C},

    /* LanguageBaseAttributeIDList  */
    {0x0006, 0x000B, value_arr + 0x0181},

    /* BluetoothProfileDescriptorList */
    {0x0009, 0x000A, value_arr + 0x018C},

    /* ServiceName */
    {0x0100, 0x0010, value_arr + 0x0196},

    /* Supported Data Stores List */
    {0x0301, 0x0002, value_arr + 0x01A6},

    /* SupportedFeatures */
    {0x0311, 0x0003, value_arr + 0x01A8},

    /** Service Record 7 */
    /* ServiceRecordHandle */
    {0x0000, 0x0005, value_arr + 0x01AB},

    /* ServiceClassIDList */
    {0x0001, 0x0005, value_arr + 0x01B0},

    /* ProtocolDescriptorList */
    {0x0004, 0x0013, value_arr + 0x01B5},

    /* BrowseGroupList  */
    {0x0005, 0x0005, value_arr + 0x01C8},

    /* LanguageBaseAttributeIDList  */
    {0x0006, 0x000B, value_arr + 0x01CD},

    /* BluetoothProfileDescriptorList */
    {0x0009, 0x000A, value_arr + 0x01D8},

    /* AdditionalProtocolDescriptorLists */
    {0x000D, 0x0015, value_arr + 0x01E2},

    /* ServiceName */
    {0x0100, 0x0000, NULL},

    /* ServiceDescription */
    {0x0101, 0x0000, NULL},

    /* ProviderName */
    {0x0102, 0x0000, NULL},

    /* HIDDeviceReleaseNumber */
    {0x0200, 0x0000, NULL},

    /* HIDProfileVersion */
    {0x0201, 0x0000, NULL},

    /* HIDDeviceSubclass */
    {0x0202, 0x0000, NULL},

    /* HIDCountryCode */
    {0x0203, 0x0000, NULL},

    /* HIDVirtualCable */
    {0x0204, 0x0000, NULL},

    /* HIDReconnectInitiate */
    {0x0205, 0x0000, NULL},

    /* HIDDescriptorList */
    {0x0206, 0x0000, NULL},

    /* HIDLANGIDBaseList */
    {0x0207, 0x0000, NULL},

    /* HIDSDPDisable */
    {0x0208, 0x0000, NULL},

    /* HIDBatteryPower */
    {0x0209, 0x0000, NULL},

    /* HIDRemoteWake */
    {0x020A, 0x0000, NULL},

    /* HIDParserVersion */
    {0x020B, 0x0000, NULL},

    /* HIDSupervisionTimeout */
    {0x020C, 0x0000, NULL},

    /* HIDNormallyConnectable */
    {0x020D, 0x0000, NULL},

    /* HIDBootDevice */
    {0x020E, 0x0000, NULL},

    /** Service Record 8 */
    /* ServiceRecordHandle */
    {0x0000, 0x0005, value_arr + 0x01F7},

    /* ServiceClassIDList */
    {0x0001, 0x0005, value_arr + 0x01FC},

    /* ProtocolDescriptorList */
    {0x0004, 0x0012, value_arr + 0x0201},

    /* BrowseGroupList  */
    {0x0005, 0x0005, value_arr + 0x0213},

    /* LanguageBaseAttributeIDList  */
    {0x0006, 0x000B, value_arr + 0x0218},

    /* BluetoothProfileDescriptorList */
    {0x0009, 0x000A, value_arr + 0x0223},

    /* ServiceName */
    {0x0100, 0x000B, value_arr + 0x022D},

    /* ProviderName */
    {0x0102, 0x000B, value_arr + 0x0238},

    /* SupportedFeatures */
    {0x0311, 0x0003, value_arr + 0x0243},

    /** Service Record 9 */
    /* ServiceRecordHandle */
    {0x0000, 0x0005, value_arr + 0x0246},

    /* ServiceClassIDList */
    {0x0001, 0x0005, value_arr + 0x024B},

    /* ProtocolDescriptorList */
    {0x0004, 0x0012, value_arr + 0x0250},

    /* BrowseGroupList  */
    {0x0005, 0x0005, value_arr + 0x0262},

    /* LanguageBaseAttributeIDList  */
    {0x0006, 0x000B, value_arr + 0x0267},

    /* BluetoothProfileDescriptorList */
    {0x0009, 0x000A, value_arr + 0x0272},

    /* ServiceName */
    {0x0100, 0x000D, value_arr + 0x027C},

    /* ProviderName */
    {0x0102, 0x000B, value_arr + 0x0289},

    /* SupportedFeatures */
    {0x0311, 0x0003, value_arr + 0x0294},

    /** Service Record 10 */
    /* ServiceRecordHandle */
    {0x0000, 0x0005, value_arr + 0x0297},

    /* ServiceClassIDList */
    {0x0001, 0x0005, value_arr + 0x029C},

    /* ProtocolDescriptorList */
    {0x0004, 0x0013, value_arr + 0x02A1},

    /* BrowseGroupList  */
    {0x0005, 0x0005, value_arr + 0x02B4},

    /* LanguageBaseAttributeIDList  */
    {0x0006, 0x000B, value_arr + 0x02B9},

    /* BluetoothProfileDescriptorList */
    {0x0009, 0x000A, value_arr + 0x02C4},

    /* ServiceName */
    {0x0100, 0x0006, value_arr + 0x02CE},

    /* HIDDeviceReleaseNumber */
    {0x0200, 0x0003, value_arr + 0x02D4},

    /* SupportedFormatsList */
    {0x0303, 0x0006, value_arr + 0x02D7},

    /** Service Record 11 */
    /* ServiceRecordHandle */
    {0x0000, 0x0005, value_arr + 0x02DD},

    /* ServiceClassIDList */
    {0x0001, 0x0005, value_arr + 0x02E2},

    /* ProtocolDescriptorList */
    {0x0004, 0x0020, value_arr + 0x02E7},

    /* BrowseGroupList  */
    {0x0005, 0x0005, value_arr + 0x0307},

    /* LanguageBaseAttributeIDList  */
    {0x0006, 0x000B, value_arr + 0x030C},

    /* ServiceAvailability */
    {0x0008, 0x0002, value_arr + 0x0317},

    /* BluetoothProfileDescriptorList */
    {0x0009, 0x000A, value_arr + 0x0319},

    /* ServiceName */
    {0x0100, 0x001F, value_arr + 0x0323},

    /* ServiceDescription */
    {0x0101, 0x0022, value_arr + 0x0342},

    /* SecurityDescription */
    {0x030A, 0x0003, value_arr + 0x0364},

    /* NetAccessType */
    {0x030B, 0x0003, value_arr + 0x0367},

    /* MaxNetAccessrate */
    {0x030C, 0x0005, value_arr + 0x036A},

    /* IPv4Subnet */
    {0x030D, 0x000D, value_arr + 0x036F},

    /* IPv6Subnet */
    {0x030E, 0x000C, value_arr + 0x037C},

    /** Service Record 12 */
    /* ServiceRecordHandle */
    {0x0000, 0x0005, value_arr + 0x0388},

    /* ServiceClassIDList */
    {0x0001, 0x0005, value_arr + 0x038D},

    /* ProtocolDescriptorList */
    {0x0004, 0x0020, value_arr + 0x0392},

    /* BrowseGroupList  */
    {0x0005, 0x0005, value_arr + 0x03B2},

    /* LanguageBaseAttributeIDList  */
    {0x0006, 0x000B, value_arr + 0x03B7},

    /* ServiceAvailability */
    {0x0008, 0x0002, value_arr + 0x03C2},

    /* BluetoothProfileDescriptorList */
    {0x0009, 0x000A, value_arr + 0x03C4},

    /* ServiceName */
    {0x0100, 0x001F, value_arr + 0x03CE},

    /* ServiceDescription */
    {0x0101, 0x0028, value_arr + 0x03ED},

    /* SecurityDescription */
    {0x030A, 0x0003, value_arr + 0x0415},

    /* IPv4Subnet */
    {0x030D, 0x000D, value_arr + 0x0418},

    /* IPv6Subnet */
    {0x030E, 0x000C, value_arr + 0x0425},

    /** Service Record 13 */
    /* ServiceRecordHandle */
    {0x0000, 0x0005, value_arr + 0x0431},

    /* ServiceClassIDList */
    {0x0001, 0x0005, value_arr + 0x0436},

    /* ProtocolDescriptorList */
    {0x0004, 0x0020, value_arr + 0x043B},

    /* BrowseGroupList  */
    {0x0005, 0x0005, value_arr + 0x045B},

    /* LanguageBaseAttributeIDList  */
    {0x0006, 0x000B, value_arr + 0x0460},

    /* ServiceAvailability */
    {0x0008, 0x0002, value_arr + 0x046B},

    /* BluetoothProfileDescriptorList */
    {0x0009, 0x000A, value_arr + 0x046D},

    /* ServiceName */
    {0x0100, 0x001F, value_arr + 0x0477},

    /* ServiceDescription */
    {0x0101, 0x001F, value_arr + 0x0496},

    /* SecurityDescription */
    {0x030A, 0x0003, value_arr + 0x04B5},

    /** Service Record 14 */
    /* ServiceRecordHandle */
    {0x0000, 0x0005, value_arr + 0x04B8},

    /* ServiceClassIDList */
    {0x0001, 0x0005, value_arr + 0x04BD},

    /* ProtocolDescriptorList */
    {0x0004, 0x0013, value_arr + 0x04C2},

    /* BrowseGroupList  */
    {0x0005, 0x0005, value_arr + 0x04D5},

    /* LanguageBaseAttributeIDList  */
    {0x0006, 0x000B, value_arr + 0x04DA},

    /* BluetoothProfileDescriptorList */
    {0x0009, 0x000A, value_arr + 0x04E5},

    /* ServiceName */
    {0x0100, 0x000A, value_arr + 0x04EF},

    /* HIDDeviceReleaseNumber */
    {0x0200, 0x0003, value_arr + 0x04F9},

    /* SupportedCapabalities */
    {0x0310, 0x0002, value_arr + 0x04FC},

    /* SupportedFeatures */
    {0x0311, 0x0003, value_arr + 0x04FE},

    /* SupportedFunctions */
    {0x0312, 0x0005, value_arr + 0x0501},

    /* TotalImagingDataCapacity */
    {0x0313, 0x0009, value_arr + 0x0506},

    /** Service Record 15 */
    /* ServiceRecordHandle */
    {0x0000, 0x0005, value_arr + 0x050F},

    /* ServiceClassIDList */
    {0x0001, 0x0005, value_arr + 0x0514},

    /* ServiceID */
    {0x0003, 0x0003, value_arr + 0x0519},

    /* ProtocolDescriptorList */
    {0x0004, 0x0013, value_arr + 0x051C},

    /* BrowseGroupList  */
    {0x0005, 0x0005, value_arr + 0x052F},

    /* LanguageBaseAttributeIDList  */
    {0x0006, 0x000B, value_arr + 0x0534},

    /* BluetoothProfileDescriptorList */
    {0x0009, 0x000A, value_arr + 0x053F},

    /* ServiceName */
    {0x0100, 0x001D, value_arr + 0x0549},

    /* HIDDeviceReleaseNumber */
    {0x0200, 0x0003, value_arr + 0x0566},

    /* SupportedFunctions */
    {0x0312, 0x0005, value_arr + 0x0569},

    /** Service Record 16 */
    /* ServiceRecordHandle */
    {0x0000, 0x0005, value_arr + 0x056E},

    /* ServiceClassIDList */
    {0x0001, 0x0005, value_arr + 0x0573},

    /* ServiceID */
    {0x0003, 0x0003, value_arr + 0x0578},

    /* ProtocolDescriptorList */
    {0x0004, 0x0013, value_arr + 0x057B},

    /* BrowseGroupList  */
    {0x0005, 0x0005, value_arr + 0x058E},

    /* LanguageBaseAttributeIDList  */
    {0x0006, 0x000B, value_arr + 0x0593},

    /* BluetoothProfileDescriptorList */
    {0x0009, 0x000A, value_arr + 0x059E},

    /* ServiceName */
    {0x0100, 0x001C, value_arr + 0x05A8},

    /* HIDDeviceReleaseNumber */
    {0x0200, 0x0003, value_arr + 0x05C4},

    /* SupportedFunctions */
    {0x0312, 0x0005, value_arr + 0x05C7},

    /** Service Record 17 */
    /* ServiceRecordHandle */
    {0x0000, 0x0005, value_arr + 0x05CC},

    /* ServiceClassIDList */
    {0x0001, 0x000B, value_arr + 0x05D1},

    /* ProtocolDescriptorList */
    {0x0004, 0x0013, value_arr + 0x05DC},

    /* BrowseGroupList  */
    {0x0005, 0x0005, value_arr + 0x05EF},

    /* LanguageBaseAttributeIDList  */
    {0x0006, 0x000B, value_arr + 0x05F4},

    /* BluetoothProfileDescriptorList */
    {0x0009, 0x000A, value_arr + 0x05FF},

    /* AdditionalProtocolDescriptorLists */
    {0x000D, 0x0015, value_arr + 0x0609},

    /* ServiceName */
    {0x0100, 0x0011, value_arr + 0x061E},

    /* DocumentFormatsSupported */
    {0x0350, 0x000D, value_arr + 0x062F},

    /* CharacterRepertoiresSupported */
    {0x0352, 0x0011, value_arr + 0x063C},

    /* XHTML-PrintImageFormatsSupported */
    {0x0354, 0x000E, value_arr + 0x064D},

    /* ColorSupported */
    {0x0356, 0x0002, value_arr + 0x065B},

    /* 1284ID */
    {0x0358, 0x000A, value_arr + 0x065D},

    /* PrinterName */
    {0x035A, 0x0006, value_arr + 0x0667},

    /* PrinterLocation */
    {0x035C, 0x0006, value_arr + 0x066D},

    /* DuplexSupported */
    {0x035E, 0x0002, value_arr + 0x0673},

    /* MediaTypesSupported */
    {0x0360, 0x000D, value_arr + 0x0675},

    /* MaxMediaWidth */
    {0x0362, 0x0003, value_arr + 0x0682},

    /* MaxMediaLength */
    {0x0364, 0x0003, value_arr + 0x0685},

    /* EnhancedLayoutSupported */
    {0x0366, 0x0002, value_arr + 0x0688},

    /* ReferencePrintingRUISupported */
    {0x0370, 0x0002, value_arr + 0x068A},

    /* DirectPrintingRUISupported */
    {0x0372, 0x0002, value_arr + 0x068C},

    /* ReferencePrintingTopURL */
    {0x0374, 0x0006, value_arr + 0x068E},

    /* DirectPrintingTopURL */
    {0x0376, 0x0006, value_arr + 0x0694},

    /** Service Record 18 */
    /* ServiceRecordHandle */
    {0x0000, 0x0005, value_arr + 0x069A},

    /* ServiceClassIDList */
    {0x0001, 0x0005, value_arr + 0x069F},

    /* ProtocolDescriptorList */
    {0x0004, 0x0013, value_arr + 0x06A4},

    /* BrowseGroupList  */
    {0x0005, 0x0005, value_arr + 0x06B7},

    /* LanguageBaseAttributeIDList  */
    {0x0006, 0x000B, value_arr + 0x06BC},

    /* BluetoothProfileDescriptorList */
    {0x0009, 0x000A, value_arr + 0x06C7},

    /* AdditionalProtocolDescriptorLists */
    {0x000D, 0x0015, value_arr + 0x06D1},

    /* ServiceName */
    {0x0100, 0x001D, value_arr + 0x06E6},

    /** Service Record 19 */
    /* ServiceRecordHandle */
    {0x0000, 0x0005, value_arr + 0x0703},

    /* ServiceClassIDList */
    {0x0001, 0x0005, value_arr + 0x0708},

    /* ProtocolDescriptorList */
    {0x0004, 0x0013, value_arr + 0x070D},

    /* BrowseGroupList  */
    {0x0005, 0x0005, value_arr + 0x0720},

    /* LanguageBaseAttributeIDList  */
    {0x0006, 0x000B, value_arr + 0x0725},

    /* ServiceName */
    {0x0100, 0x0028, value_arr + 0x0730},

    /* RUIFormatsSupported */
    {0x0368, 0x0006, value_arr + 0x0758},

    /* PrinterAdminRUITopURL */
    {0x0378, 0x0006, value_arr + 0x075E},

    /** Service Record 20 */
    /* ServiceRecordHandle */
    {0x0000, 0x0005, value_arr + 0x0764},

    /* ServiceClassIDList */
    {0x0001, 0x0008, value_arr + 0x0769},

    /* ProtocolDescriptorList */
    {0x0004, 0x0012, value_arr + 0x0771},

    /* BrowseGroupList  */
    {0x0005, 0x0005, value_arr + 0x0783},

    /* LanguageBaseAttributeIDList  */
    {0x0006, 0x000B, value_arr + 0x0788},

    /* BluetoothProfileDescriptorList */
    {0x0009, 0x000A, value_arr + 0x0793},

    /* AdditionalProtocolDescriptorLists */
    {0x000D, 0x0014, value_arr + 0x079D},

    /* ServiceName */
    {0x0100, 0x0013, value_arr + 0x07B1},

    /* ProviderName */
    {0x0102, 0x000B, value_arr + 0x07C4},

    /* SupportedFeatures */
    {0x0311, 0x0003, value_arr + 0x07CF},

    /** Service Record 21 */
    /* ServiceRecordHandle */
    {0x0000, 0x0005, value_arr + 0x07D2},

    /* ServiceClassIDList */
    {0x0001, 0x0005, value_arr + 0x07D7},

    /* ProtocolDescriptorList */
    {0x0004, 0x0012, value_arr + 0x07DC},

    /* BrowseGroupList  */
    {0x0005, 0x0005, value_arr + 0x07EE},

    /* LanguageBaseAttributeIDList  */
    {0x0006, 0x000B, value_arr + 0x07F3},

    /* BluetoothProfileDescriptorList */
    {0x0009, 0x000A, value_arr + 0x07FE},

    /* AdditionalProtocolDescriptorLists */
    {0x000D, 0x0023, value_arr + 0x0808},

    /* ServiceName */
    {0x0100, 0x000F, value_arr + 0x082B},

    /* ProviderName */
    {0x0102, 0x000B, value_arr + 0x083A},

    /* SupportedFeatures */
    {0x0311, 0x0003, value_arr + 0x0845},

    /** Service Record 22 */
    /* ServiceRecordHandle */
    {0x0000, 0x0005, value_arr + 0x0848},

    /* ServiceClassIDList */
    {0x0001, 0x0005, value_arr + 0x084D},

    /* BrowseGroupList  */
    {0x0005, 0x0005, value_arr + 0x0852},

    /* LanguageBaseAttributeIDList  */
    {0x0006, 0x000B, value_arr + 0x0857},

    /* BluetoothProfileDescriptorList */
    {0x0009, 0x000A, value_arr + 0x0862},

    /* ServiceName */
    {0x0100, 0x0018, value_arr + 0x086C},

    /** Service Record 23 */
    /* ServiceRecordHandle */
    {0x0000, 0x0005, value_arr + 0x0884},

    /* ServiceClassIDList */
    {0x0001, 0x0005, value_arr + 0x0889},

    /* ProtocolDescriptorList */
    {0x0004, 0x0013, value_arr + 0x088E},

    /* BrowseGroupList  */
    {0x0005, 0x0005, value_arr + 0x08A1},

    /* LanguageBaseAttributeIDList  */
    {0x0006, 0x000B, value_arr + 0x08A6},

    /* BluetoothProfileDescriptorList */
    {0x0009, 0x000A, value_arr + 0x08B1},

    /* ServiceName */
    {0x0100, 0x0018, value_arr + 0x08BB},

    /* HIDDeviceReleaseNumber */
    {0x0200, 0x0003, value_arr + 0x08D3},

    /* SupportedRepositories */
    {0x0314, 0x0002, value_arr + 0x08D6},

    /* MapSupportedFeatures */
    {0x0317, 0x0005, value_arr + 0x08D8},

    /** Service Record 24 */
    /* ServiceRecordHandle */
    {0x0000, 0x0005, value_arr + 0x08DD},

    /* ServiceClassIDList */
    {0x0001, 0x0005, value_arr + 0x08E2},

    /* BrowseGroupList  */
    {0x0005, 0x0005, value_arr + 0x08E7},

    /* LanguageBaseAttributeIDList  */
    {0x0006, 0x000B, value_arr + 0x08EC},

    /* DocumentationURL */
    {0x000A, 0x0014, value_arr + 0x08F7},

    /* ClientExecutableURL */
    {0x000B, 0x0011, value_arr + 0x090B},

    /* ServiceDescription */
    {0x0101, 0x000B, value_arr + 0x091C},

    /* HIDDeviceReleaseNumber */
    {0x0200, 0x0003, value_arr + 0x0927},

    /* HIDProfileVersion */
    {0x0201, 0x0003, value_arr + 0x092A},

    /* HIDDeviceSubclass */
    {0x0202, 0x0003, value_arr + 0x092D},

    /* HIDCountryCode */
    {0x0203, 0x0003, value_arr + 0x0930},

    /* HIDVirtualCable */
    {0x0204, 0x0002, value_arr + 0x0933},

    /* HIDReconnectInitiate */
    {0x0205, 0x0003, value_arr + 0x0935},

    /** Service Record 25 */
    /* ServiceRecordHandle */
    {0x0000, 0x0005, value_arr + 0x0938},

    /* ServiceClassIDList */
    {0x0001, 0x0005, value_arr + 0x093D},

    /* BrowseGroupList  */
    {0x0005, 0x0005, value_arr + 0x0942},

    /* LanguageBaseAttributeIDList  */
    {0x0006, 0x000B, value_arr + 0x0947},

    /* DocumentationURL */
    {0x000A, 0x0016, value_arr + 0x0952},

    /* ClientExecutableURL */
    {0x000B, 0x0013, value_arr + 0x0968},

    /* ServiceDescription */
    {0x0101, 0x000D, value_arr + 0x097B},

    /* HIDDeviceReleaseNumber */
    {0x0200, 0x0003, value_arr + 0x0988},

    /* HIDProfileVersion */
    {0x0201, 0x0003, value_arr + 0x098B},

    /* HIDDeviceSubclass */
    {0x0202, 0x0003, value_arr + 0x098E},

    /* HIDCountryCode */
    {0x0203, 0x0003, value_arr + 0x0991},

    /* HIDVirtualCable */
    {0x0204, 0x0002, value_arr + 0x0994},

    /* HIDReconnectInitiate */
    {0x0205, 0x0003, value_arr + 0x0996},

    /** Service Record 26 */
    /* ServiceRecordHandle */
    {0x0000, 0x0005, value_arr + 0x0999},

    /* ServiceClassIDList */
    {0x0001, 0x0008, value_arr + 0x099E},

    /* ProtocolDescriptorList */
    {0x0004, 0x0012, value_arr + 0x09A6},

    /* BrowseGroupList  */
    {0x0005, 0x0005, value_arr + 0x09B8},

    /* LanguageBaseAttributeIDList  */
    {0x0006, 0x000B, value_arr + 0x09BD},

    /* BluetoothProfileDescriptorList */
    {0x0009, 0x000A, value_arr + 0x09C8},

    /* AdditionalProtocolDescriptorLists */
    {0x000D, 0x0011, value_arr + 0x09D2},

    /* ServiceName */
    {0x0100, 0x0011, value_arr + 0x09E3},

    /* ServiceDescription */
    {0x0101, 0x0014, value_arr + 0x09F4},

    /* ProviderName */
    {0x0102, 0x000B, value_arr + 0x0A08},

    /* HIDDeviceReleaseNumber */
    {0x0200, 0x0020, value_arr + 0x0A13},

    /* Supported Data Stores List */
    {0x0301, 0x0002, value_arr + 0x0A33},

    /* MCAPSupportedProcedures */
    {0x0302, 0x0002, value_arr + 0x0A35},

    /** Service Record 27 */
    /* ServiceRecordHandle */
    {0x0000, 0x0005, value_arr + 0x0A37},

    /* ServiceClassIDList */
    {0x0001, 0x0005, value_arr + 0x0A3C},

    /* ProtocolDescriptorList */
    {0x0004, 0x0013, value_arr + 0x0A41},

    /* BrowseGroupList  */
    {0x0005, 0x0005, value_arr + 0x0A54},

    /* LanguageBaseAttributeIDList  */
    {0x0006, 0x000B, value_arr + 0x0A59},

    /* BluetoothProfileDescriptorList */
    {0x0009, 0x000A, value_arr + 0x0A64},

    /* ServiceName */
    {0x0100, 0x001B, value_arr + 0x0A6E},

    /* HIDDeviceReleaseNumber */
    {0x0200, 0x0003, value_arr + 0x0A89},

    /* MapSupportedFeatures */
    {0x0317, 0x0005, value_arr + 0x0A8C},

    /** Service Record 28 */
    /* ServiceRecordHandle */
    {0x0000, 0x0005, value_arr + 0x0A91},

    /* ServiceClassIDList */
    {0x0001, 0x0005, value_arr + 0x0A96},

    /* ProtocolDescriptorList */
    {0x0004, 0x0013, value_arr + 0x0A9B},

    /* BrowseGroupList  */
    {0x0005, 0x0005, value_arr + 0x0AAE},

    /* LanguageBaseAttributeIDList  */
    {0x0006, 0x000B, value_arr + 0x0AB3},

    /* BluetoothProfileDescriptorList */
    {0x0009, 0x000A, value_arr + 0x0ABE},

    /* ServiceName */
    {0x0100, 0x0015, value_arr + 0x0AC8},

    /* HIDDeviceReleaseNumber */
    {0x0200, 0x0003, value_arr + 0x0ADD},

    /* MASInstanceID */
    {0x0315, 0x0002, value_arr + 0x0AE0},

    /* SupportedMessageTypes */
    {0x0316, 0x0002, value_arr + 0x0AE2},

    /* MapSupportedFeatures */
    {0x0317, 0x0005, value_arr + 0x0AE4},

    /** Service Record 29 */
    /* ServiceRecordHandle */
    {0x0000, 0x0005, value_arr + 0x0AE9},

    /* ServiceClassIDList */
    {0x0001, 0x0005, value_arr + 0x0AEE},

    /* ProtocolDescriptorList */
    {0x0004, 0x0013, value_arr + 0x0AF3},

    /* BrowseGroupList  */
    {0x0005, 0x0005, value_arr + 0x0B06},

    /* LanguageBaseAttributeIDList  */
    {0x0006, 0x000B, value_arr + 0x0B0B},

    /* BluetoothProfileDescriptorList */
    {0x0009, 0x000A, value_arr + 0x0B16},

    /* ServiceName */
    {0x0100, 0x0015, value_arr + 0x0B20},

    /* HIDDeviceReleaseNumber */
    {0x0200, 0x0003, value_arr + 0x0B35},

    /* MASInstanceID */
    {0x0315, 0x0002, value_arr + 0x0B38},

    /* SupportedMessageTypes */
    {0x0316, 0x0002, value_arr + 0x0B3A},

    /* MapSupportedFeatures */
    {0x0317, 0x0005, value_arr + 0x0B3C},

    /** Service Record 30 */
    /* ServiceRecordHandle */
    {0x0000, 0x0005, value_arr + 0x0B41},

    /* ServiceClassIDList */
    {0x0001, 0x0005, value_arr + 0x0B46},

    /* BrowseGroupList  */
    {0x0005, 0x0005, value_arr + 0x0B4B},

    /* LanguageBaseAttributeIDList  */
    {0x0006, 0x000B, value_arr + 0x0B50},

    /* BluetoothProfileDescriptorList */
    {0x0009, 0x000A, value_arr + 0x0B5B},

    /* HIDDeviceReleaseNumber */
    {0x0200, 0x0009, value_arr + 0x0B65},

    /* HIDProfileVersion */
    {0x0201, 0x0009, value_arr + 0x0B6E},

    /* HIDDeviceSubclass */
    {0x0202, 0x0003, value_arr + 0x0B77},

    /** Service Record 31 */
    /* ServiceRecordHandle */
    {0x0000, 0x0005, value_arr + 0x0B7A},

    /* ServiceClassIDList */
    {0x0001, 0x0005, value_arr + 0x0B7F},

    /* ProtocolDescriptorList */
    {0x0004, 0x0015, value_arr + 0x0B84},

    /* BrowseGroupList  */
    {0x0005, 0x0005, value_arr + 0x0B99},

    /* LanguageBaseAttributeIDList  */
    {0x0006, 0x000B, value_arr + 0x0B9E},

    /** Service Record 32 */
    /* ServiceRecordHandle */
    {0x0000, 0x0005, value_arr + 0x0BA9},

    /* ServiceClassIDList */
    {0x0001, 0x0005, value_arr + 0x0BAE},

    /* ProtocolDescriptorList */
    {0x0004, 0x0015, value_arr + 0x0BB3},

    /* BrowseGroupList  */
    {0x0005, 0x0005, value_arr + 0x0BC8},

    /* LanguageBaseAttributeIDList  */
    {0x0006, 0x000B, value_arr + 0x0BCD},

    /** Service Record 33 */
    /* ServiceRecordHandle */
    {0x0000, 0x0005, value_arr + 0x0BD8},

    /* ServiceClassIDList */
    {0x0001, 0x0005, value_arr + 0x0BDD},

    /* ProtocolDescriptorList */
    {0x0004, 0x0015, value_arr + 0x0BE2},

    /* BrowseGroupList  */
    {0x0005, 0x0005, value_arr + 0x0BF7},

    /* LanguageBaseAttributeIDList  */
    {0x0006, 0x000B, value_arr + 0x0BFC},

    /** Service Record 34 */
    /* ServiceRecordHandle */
    {0x0000, 0x0005, value_arr + 0x0C07},

    /* ServiceClassIDList */
    {0x0001, 0x0005, value_arr + 0x0C0C},

    /* ProtocolDescriptorList */
    {0x0004, 0x0015, value_arr + 0x0C11},

    /* BrowseGroupList  */
    {0x0005, 0x0005, value_arr + 0x0C26},

    /* LanguageBaseAttributeIDList  */
    {0x0006, 0x000B, value_arr + 0x0C2B},

    /** Service Record 35 */
    /* ServiceRecordHandle */
    {0x0000, 0x0005, value_arr + 0x0C36},

    /* ServiceClassIDList */
    {0x0001, 0x0005, value_arr + 0x0C3B},

    /* ProtocolDescriptorList */
    {0x0004, 0x0015, value_arr + 0x0C40},

    /* BrowseGroupList  */
    {0x0005, 0x0005, value_arr + 0x0C55},

    /* LanguageBaseAttributeIDList  */
    {0x0006, 0x000B, value_arr + 0x0C5A},

    /** Service Record 36 */
    /* ServiceRecordHandle */
    {0x0000, 0x0005, value_arr + 0x0C65},

    /* ServiceClassIDList */
    {0x0001, 0x0005, value_arr + 0x0C6A},

    /* ProtocolDescriptorList */
    {0x0004, 0x0015, value_arr + 0x0C6F},

    /* BrowseGroupList  */
    {0x0005, 0x0005, value_arr + 0x0C84},

    /* LanguageBaseAttributeIDList  */
    {0x0006, 0x000B, value_arr + 0x0C89},

    /** Service Record 37 */
    /* ServiceRecordHandle */
    {0x0000, 0x0005, value_arr + 0x0C94},

    /* ServiceClassIDList */
    {0x0001, 0x0005, value_arr + 0x0C99},

    /* ProtocolDescriptorList */
    {0x0004, 0x0015, value_arr + 0x0C9E},

    /* BrowseGroupList  */
    {0x0005, 0x0005, value_arr + 0x0CB3},

    /* LanguageBaseAttributeIDList  */
    {0x0006, 0x000B, value_arr + 0x0CB8},

    /** Service Record 38 */
    /* ServiceRecordHandle */
    {0x0000, 0x0005, value_arr + 0x0CC3},

    /* ServiceClassIDList */
    {0x0001, 0x0005, value_arr + 0x0CC8},

    /* ProtocolDescriptorList */
    {0x0004, 0x0015, value_arr + 0x0CCD},

    /* BrowseGroupList  */
    {0x0005, 0x0005, value_arr + 0x0CE2},

    /* LanguageBaseAttributeIDList  */
    {0x0006, 0x000B, value_arr + 0x0CE7},

    /** Service Record 39 */
    /* ServiceRecordHandle */
    {0x0000, 0x0005, value_arr + 0x0CF2},

    /* ServiceClassIDList */
    {0x0001, 0x0005, value_arr + 0x0CF7},

    /* ProtocolDescriptorList */
    {0x0004, 0x0015, value_arr + 0x0CFC},

    /* BrowseGroupList  */
    {0x0005, 0x0005, value_arr + 0x0D11},

    /* LanguageBaseAttributeIDList  */
    {0x0006, 0x000B, value_arr + 0x0D16},

    /** Service Record 40 */
    /* ServiceRecordHandle */
    {0x0000, 0x0005, value_arr + 0x0D21},

    /* ServiceClassIDList */
    {0x0001, 0x0005, value_arr + 0x0D26},

    /* ProtocolDescriptorList */
    {0x0004, 0x000F, value_arr + 0x0D2B},

    /* BrowseGroupList  */
    {0x0005, 0x0005, value_arr + 0x0D3A},

    /* LanguageBaseAttributeIDList  */
    {0x0006, 0x000B, value_arr + 0x0D3F},

    /* BluetoothProfileDescriptorList */
    {0x0009, 0x000A, value_arr + 0x0D4A},

    /* ServiceName */
    {0x0100, 0x001B, value_arr + 0x0D54},

    /* MapSupportedFeatures */
    {0x0317, 0x0005, value_arr + 0x0D6F},

    /** Service Record 41 */
    /* ServiceRecordHandle */
    {0x0000, 0x0005, value_arr + 0x0D74},

    /* ServiceClassIDList */
    {0x0001, 0x0005, value_arr + 0x0D79},

    /* ProtocolDescriptorList */
    {0x0004, 0x000F, value_arr + 0x0D7E},

    /* BrowseGroupList  */
    {0x0005, 0x0005, value_arr + 0x0D8D},

    /* LanguageBaseAttributeIDList  */
    {0x0006, 0x000B, value_arr + 0x0D92},

    /* BluetoothProfileDescriptorList */
    {0x0009, 0x000A, value_arr + 0x0D9D},

    /* ServiceName */
    {0x0100, 0x0015, value_arr + 0x0DA7},

    /* MASInstanceID */
    {0x0315, 0x0002, value_arr + 0x0DBC},

    /* MapSupportedFeatures */
    {0x0317, 0x0005, value_arr + 0x0DBE},

    /** Service Record 42 */
    /* ServiceRecordHandle */
    {0x0000, 0x0005, value_arr + 0x0DC3},

    /* ServiceClassIDList */
    {0x0001, 0x0005, value_arr + 0x0DC8},

    /* ProtocolDescriptorList */
    {0x0004, 0x000F, value_arr + 0x0DCD},

    /* BrowseGroupList  */
    {0x0005, 0x0005, value_arr + 0x0DDC},

    /* LanguageBaseAttributeIDList  */
    {0x0006, 0x000B, value_arr + 0x0DE1},

    /* BluetoothProfileDescriptorList */
    {0x0009, 0x000A, value_arr + 0x0DEC},

    /* ServiceName */
    {0x0100, 0x0015, value_arr + 0x0DF6},

    /* MASInstanceID */
    {0x0315, 0x0002, value_arr + 0x0E0B},

    /* MapSupportedFeatures */
    {0x0317, 0x0005, value_arr + 0x0E0D}
};

/* Functions */

/**
 *  \fn BT_dbase_init
 *
 *  \brief Ethermind SDP dbase initializer
 *
 *  \par Description:
 *  This function initializes SDP dbase records statically.
 *  It is called as a part of EtherMind stack initialization.
 *
 *  \param None
 *
 *  \return None
 *
 */

void BT_dbase_init(void)
{

    /*
     *    SDP Record
     *       Of
     *   SDP Server
     */
    dbase[0].rec_handle     = 0x00000000;
    dbase[0].active = DB_RECORD_ACTIVE;
    dbase[0].num_uuids      = 1;
    dbase[0].num_attrs      = 3;
    dbase[0].attr_offset     = 0;


    /*
     *     SDP Record
     *        Of
     *  SAP Profile
     */
    dbase[1].rec_handle = 0x00090001;
    dbase[1].active = DB_RECORD_INACTIVE;
    dbase[1].num_uuids = 5;
    dbase[1].num_attrs = 7;
    dbase[1].attr_offset = 3;

    /*
     *     SDP Record
     *        Of
     *  SPP Profile
     */
    dbase[2].rec_handle = 0x00090002;
    dbase[2].active = DB_RECORD_INACTIVE;
    dbase[2].num_uuids = 4;
    dbase[2].num_attrs = 7;
    dbase[2].attr_offset = 10;

    /*
     *     SDP Record
     *        Of
     *  SPP_VS Profile
     */
    dbase[3].rec_handle = 0x00090003;
    dbase[3].active = DB_RECORD_INACTIVE;
    dbase[3].num_uuids = 5;
    dbase[3].num_attrs = 7;
    dbase[3].attr_offset = 17;

    /*
     *     SDP Record
     *        Of
     *  FTP Profile
     */
    dbase[4].rec_handle = 0x00090004;
    dbase[4].active = DB_RECORD_INACTIVE;
    dbase[4].num_uuids = 5;
    dbase[4].num_attrs = 8;
    dbase[4].attr_offset = 24;

    /*
     *     SDP Record
     *        Of
     *  HFU Profile
     */
    dbase[5].rec_handle = 0x00090005;
    dbase[5].active = DB_RECORD_INACTIVE;
    dbase[5].num_uuids = 5;
    dbase[5].num_attrs = 8;
    dbase[5].attr_offset = 32;

    /*
     *     SDP Record
     *        Of
     *  HFAG Profile
     */
    dbase[6].rec_handle = 0x00090006;
    dbase[6].active = DB_RECORD_INACTIVE;
    dbase[6].num_uuids = 6;
    dbase[6].num_attrs = 9;
    dbase[6].attr_offset = 40;

    /*
     *     SDP Record
     *        Of
     *  HID Profile
     */
    dbase[7].rec_handle = 0x00090007;
    dbase[7].active = DB_RECORD_INACTIVE;
    dbase[7].num_uuids = 4;
    dbase[7].num_attrs = 25;
    dbase[7].attr_offset = 49;

    /*
     *     SDP Record
     *        Of
     *  A2DP Sink Profile
     */
    dbase[8].rec_handle = 0x00090008;
    dbase[8].active = DB_RECORD_INACTIVE;
    dbase[8].num_uuids = 5;
    dbase[8].num_attrs = 9;
    dbase[8].attr_offset = 74;

    /*
     *     SDP Record
     *        Of
     *  A2DP Source Profile
     */
    dbase[9].rec_handle = 0x00090009;
    dbase[9].active = DB_RECORD_INACTIVE;
    dbase[9].num_uuids = 5;
    dbase[9].num_attrs = 9;
    dbase[9].attr_offset = 83;

    /*
     *     SDP Record
     *        Of
     *  OPP Profile
     */
    dbase[10].rec_handle = 0x0009000A;
    dbase[10].active = DB_RECORD_INACTIVE;
    dbase[10].num_uuids = 5;
    dbase[10].num_attrs = 9;
    dbase[10].attr_offset = 92;

    /*
     *     SDP Record
     *        Of
     *  NAP Profile
     */
    dbase[11].rec_handle = 0x0009000B;
    dbase[11].active = DB_RECORD_INACTIVE;
    dbase[11].num_uuids = 4;
    dbase[11].num_attrs = 14;
    dbase[11].attr_offset = 101;

    /*
     *     SDP Record
     *        Of
     *  GN Profile
     */
    dbase[12].rec_handle = 0x0009000C;
    dbase[12].active = DB_RECORD_INACTIVE;
    dbase[12].num_uuids = 4;
    dbase[12].num_attrs = 12;
    dbase[12].attr_offset = 115;

    /*
     *     SDP Record
     *        Of
     *  PANU Profile
     */
    dbase[13].rec_handle = 0x0009000D;
    dbase[13].active = DB_RECORD_INACTIVE;
    dbase[13].num_uuids = 4;
    dbase[13].num_attrs = 10;
    dbase[13].attr_offset = 127;

    /*
     *     SDP Record
     *        Of
     *  BIP Profile
     */
    dbase[14].rec_handle = 0x0009000E;
    dbase[14].active = DB_RECORD_INACTIVE;
    dbase[14].num_uuids = 6;
    dbase[14].num_attrs = 12;
    dbase[14].attr_offset = 137;

    /*
     *     SDP Record
     *        Of
     *  RO Profile
     */
    dbase[15].rec_handle = 0x0009000F;
    dbase[15].active = DB_RECORD_INACTIVE;
    dbase[15].num_uuids = 6;
    dbase[15].num_attrs = 10;
    dbase[15].attr_offset = 149;

    /*
     *     SDP Record
     *        Of
     *  Archived Objects Profile
     */
    dbase[16].rec_handle = 0x00090010;
    dbase[16].active = DB_RECORD_INACTIVE;
    dbase[16].num_uuids = 6;
    dbase[16].num_attrs = 10;
    dbase[16].attr_offset = 159;

    /*
     *     SDP Record
     *        Of
     *  BPP Profile
     */
    dbase[17].rec_handle = 0x00090011;
    dbase[17].active = DB_RECORD_INACTIVE;
    dbase[17].num_uuids = 8;
    dbase[17].num_attrs = 24;
    dbase[17].attr_offset = 169;

    /*
     *     SDP Record
     *        Of
     *  Basic Printing Referenced Objects Profile
     */
    dbase[18].rec_handle = 0x00090012;
    dbase[18].active = DB_RECORD_INACTIVE;
    dbase[18].num_uuids = 6;
    dbase[18].num_attrs = 8;
    dbase[18].attr_offset = 193;

    /*
     *     SDP Record
     *        Of
     *  Printer Administrative User Interface Profile
     */
    dbase[19].rec_handle = 0x00090013;
    dbase[19].active = DB_RECORD_INACTIVE;
    dbase[19].num_uuids = 5;
    dbase[19].num_attrs = 8;
    dbase[19].attr_offset = 201;

    /*
     *     SDP Record
     *        Of
     *  AVRCP Controller Profile
     */
    dbase[20].rec_handle = 0x00090014;
    dbase[20].active = DB_RECORD_INACTIVE;
    dbase[20].num_uuids = 5;
    dbase[20].num_attrs = 10;
    dbase[20].attr_offset = 209;

    /*
     *     SDP Record
     *        Of
     *  AVRCP Target Profile
     */
    dbase[21].rec_handle = 0x00090015;
    dbase[21].active = DB_RECORD_INACTIVE;
    dbase[21].num_uuids = 6;
    dbase[21].num_attrs = 10;
    dbase[21].attr_offset = 219;

    /*
     *     SDP Record
     *        Of
     *  PBAP_PCE Profile
     */
    dbase[22].rec_handle = 0x00090016;
    dbase[22].active = DB_RECORD_INACTIVE;
    dbase[22].num_uuids = 3;
    dbase[22].num_attrs = 6;
    dbase[22].attr_offset = 229;

    /*
     *     SDP Record
     *        Of
     *  PBAP_PSE Profile
     */
    dbase[23].rec_handle = 0x00090017;
    dbase[23].active = DB_RECORD_INACTIVE;
    dbase[23].num_uuids = 6;
    dbase[23].num_attrs = 10;
    dbase[23].attr_offset = 235;

    /*
     *     SDP Record
     *        Of
     *  DID Profile
     */
    dbase[24].rec_handle = 0x00090018;
    dbase[24].active = DB_RECORD_INACTIVE;
    dbase[24].num_uuids = 2;
    dbase[24].num_attrs = 13;
    dbase[24].attr_offset = 245;

    /*
     *     SDP Record
     *        Of
     *  DID Profile
     */
    dbase[25].rec_handle = 0x00090019;
    dbase[25].active = DB_RECORD_INACTIVE;
    dbase[25].num_uuids = 2;
    dbase[25].num_attrs = 13;
    dbase[25].attr_offset = 258;

    /*
     *     SDP Record
     *        Of
     *  HDP Profile
     */
    dbase[26].rec_handle = 0x0009001A;
    dbase[26].active = DB_RECORD_INACTIVE;
    dbase[26].num_uuids = 7;
    dbase[26].num_attrs = 13;
    dbase[26].attr_offset = 271;

    /*
     *     SDP Record
     *        Of
     *  MAP_MCE Profile
     */
    dbase[27].rec_handle = 0x0009001B;
    dbase[27].active = DB_RECORD_INACTIVE;
    dbase[27].num_uuids = 6;
    dbase[27].num_attrs = 9;
    dbase[27].attr_offset = 284;

    /*
     *     SDP Record
     *        Of
     *  MAP_MSE Profile
     */
    dbase[28].rec_handle = 0x0009001C;
    dbase[28].active = DB_RECORD_INACTIVE;
    dbase[28].num_uuids = 6;
    dbase[28].num_attrs = 11;
    dbase[28].attr_offset = 293;

    /*
     *     SDP Record
     *        Of
     *  MAP_MSE Profile
     */
    dbase[29].rec_handle = 0x0009001D;
    dbase[29].active = DB_RECORD_INACTIVE;
    dbase[29].num_uuids = 6;
    dbase[29].num_attrs = 11;
    dbase[29].attr_offset = 304;

    /*
     *     SDP Record
     *        Of
     *  MPS Profile
     */
    dbase[30].rec_handle = 0x0009001E;
    dbase[30].active = DB_RECORD_INACTIVE;
    dbase[30].num_uuids = 3;
    dbase[30].num_attrs = 8;
    dbase[30].attr_offset = 315;

    /*
     *     SDP Record
     *        Of
     *  GAP Profile
     */
    dbase[31].rec_handle = 0x0009001F;
    dbase[31].active = DB_RECORD_INACTIVE;
    dbase[31].num_uuids = 4;
    dbase[31].num_attrs = 5;
    dbase[31].attr_offset = 323;

    /*
     *     SDP Record
     *        Of
     *  GATT Profile
     */
    dbase[32].rec_handle = 0x00090020;
    dbase[32].active = DB_RECORD_INACTIVE;
    dbase[32].num_uuids = 4;
    dbase[32].num_attrs = 5;
    dbase[32].attr_offset = 328;

    /*
     *     SDP Record
     *        Of
     *  DIS Profile
     */
    dbase[33].rec_handle = 0x00090021;
    dbase[33].active = DB_RECORD_INACTIVE;
    dbase[33].num_uuids = 4;
    dbase[33].num_attrs = 5;
    dbase[33].attr_offset = 333;

    /*
     *     SDP Record
     *        Of
     *  BAS Profile
     */
    dbase[34].rec_handle = 0x00090022;
    dbase[34].active = DB_RECORD_INACTIVE;
    dbase[34].num_uuids = 4;
    dbase[34].num_attrs = 5;
    dbase[34].attr_offset = 338;

    /*
     *     SDP Record
     *        Of
     *  RSC Profile
     */
    dbase[35].rec_handle = 0x00090023;
    dbase[35].active = DB_RECORD_INACTIVE;
    dbase[35].num_uuids = 4;
    dbase[35].num_attrs = 5;
    dbase[35].attr_offset = 343;

    /*
     *     SDP Record
     *        Of
     *  CSC Profile
     */
    dbase[36].rec_handle = 0x00090024;
    dbase[36].active = DB_RECORD_INACTIVE;
    dbase[36].num_uuids = 4;
    dbase[36].num_attrs = 5;
    dbase[36].attr_offset = 348;

    /*
     *     SDP Record
     *        Of
     *  CPS Profile
     */
    dbase[37].rec_handle = 0x00090025;
    dbase[37].active = DB_RECORD_INACTIVE;
    dbase[37].num_uuids = 4;
    dbase[37].num_attrs = 5;
    dbase[37].attr_offset = 353;

    /*
     *     SDP Record
     *        Of
     *  HPS Profile
     */
    dbase[38].rec_handle = 0x00090026;
    dbase[38].active = DB_RECORD_INACTIVE;
    dbase[38].num_uuids = 4;
    dbase[38].num_attrs = 5;
    dbase[38].attr_offset = 358;

    /*
     *     SDP Record
     *        Of
     *  CTS Profile
     */
    dbase[39].rec_handle = 0x00090027;
    dbase[39].active = DB_RECORD_INACTIVE;
    dbase[39].num_uuids = 4;
    dbase[39].num_attrs = 5;
    dbase[39].attr_offset = 363;

    /*
     *     SDP Record
     *        Of
     *  CTN_CCE Profile
     */
    dbase[40].rec_handle = 0x00090028;
    dbase[40].active = DB_RECORD_INACTIVE;
    dbase[40].num_uuids = 5;
    dbase[40].num_attrs = 8;
    dbase[40].attr_offset = 368;

    /*
     *     SDP Record
     *        Of
     *  CTN_CSE Profile
     */
    dbase[41].rec_handle = 0x00090029;
    dbase[41].active = DB_RECORD_INACTIVE;
    dbase[41].num_uuids = 5;
    dbase[41].num_attrs = 9;
    dbase[41].attr_offset = 376;

    /*
     *     SDP Record
     *        Of
     *  CTN_CSE Profile
     */
    dbase[42].rec_handle = 0x0009002A;
    dbase[42].active = DB_RECORD_INACTIVE;
    dbase[42].num_uuids = 5;
    dbase[42].num_attrs = 9;
    dbase[42].attr_offset = 385;

    /* Number of SDP records */
    num_records = 43;

    /* UUID List */
    num_128_ids = 65;

    /* Total number of Service Class UUIDs */
    num_service_class_uuids = SERVICE_CLASS_UUID_INDICES_MAX;
}



/** List of all required UUIDs */
const UCHAR uuid_128_arr[DB_MAX_UUIDS][16] =
{
    /**
     *  UUID Index 00 :
     *  ( 0x0003 ) -> RFCOMM
     */
    {0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x10, 0x00,
     0x80, 0x00, 0x00, 0x80, 0x5F, 0x9B, 0x34, 0xFB},

    /**
     *  UUID Index 01 :
     *  ( 0x0007 ) -> ATT
     */
    {0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x10, 0x00,
     0x80, 0x00, 0x00, 0x80, 0x5F, 0x9B, 0x34, 0xFB},

    /**
     *  UUID Index 02 :
     *  ( 0x0008 ) -> OBEX
     */
    {0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x10, 0x00,
     0x80, 0x00, 0x00, 0x80, 0x5F, 0x9B, 0x34, 0xFB},

    /**
     *  UUID Index 03 :
     *  ( 0x000F ) -> BNEP
     */
    {0x00, 0x00, 0x00, 0x0F, 0x00, 0x00, 0x10, 0x00,
     0x80, 0x00, 0x00, 0x80, 0x5F, 0x9B, 0x34, 0xFB},

    /**
     *  UUID Index 04 :
     *  ( 0x0011 ) -> HIDP
     */
    {0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x10, 0x00,
     0x80, 0x00, 0x00, 0x80, 0x5F, 0x9B, 0x34, 0xFB},

    /**
     *  UUID Index 05 :
     *  ( 0x0017 ) -> AVCTP
     */
    {0x00, 0x00, 0x00, 0x17, 0x00, 0x00, 0x10, 0x00,
     0x80, 0x00, 0x00, 0x80, 0x5F, 0x9B, 0x34, 0xFB},

    /**
     *  UUID Index 06 :
     *  ( 0x0019 ) -> AVDTP
     */
    {0x00, 0x00, 0x00, 0x19, 0x00, 0x00, 0x10, 0x00,
     0x80, 0x00, 0x00, 0x80, 0x5F, 0x9B, 0x34, 0xFB},

    /**
     *  UUID Index 07 :
     *  ( 0x001E ) -> MCAPControlChannel
     */
    {0x00, 0x00, 0x00, 0x1E, 0x00, 0x00, 0x10, 0x00,
     0x80, 0x00, 0x00, 0x80, 0x5F, 0x9B, 0x34, 0xFB},

    /**
     *  UUID Index 08 :
     *  ( 0x001F ) -> MCAPDataChannel
     */
    {0x00, 0x00, 0x00, 0x1F, 0x00, 0x00, 0x10, 0x00,
     0x80, 0x00, 0x00, 0x80, 0x5F, 0x9B, 0x34, 0xFB},

    /**
     *  UUID Index 09 :
     *  ( 0x0100 ) -> L2CAP
     */
    {0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x10, 0x00,
     0x80, 0x00, 0x00, 0x80, 0x5F, 0x9B, 0x34, 0xFB},

    /**
     *  UUID Index 10 :
     *  ( 0x1000 ) -> ServiceDiscoveryServerServiceClassID
     */
    {0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x10, 0x00,
     0x80, 0x00, 0x00, 0x80, 0x5F, 0x9B, 0x34, 0xFB},

    /**
     *  UUID Index 11 :
     *  ( 0x1002 ) -> PublicBrowseGroup
     */
    {0x00, 0x00, 0x10, 0x02, 0x00, 0x00, 0x10, 0x00,
     0x80, 0x00, 0x00, 0x80, 0x5F, 0x9B, 0x34, 0xFB},

    /**
     *  UUID Index 12 :
     *  ( 0x1101 ) -> SerialPort
     */
    {0x00, 0x00, 0x11, 0x01, 0x00, 0x00, 0x10, 0x00,
     0x80, 0x00, 0x00, 0x80, 0x5F, 0x9B, 0x34, 0xFB},

    /**
     *  UUID Index 13 :
     *  ( 0x1105 ) -> OBEXObjectPush
     */
    {0x00, 0x00, 0x11, 0x05, 0x00, 0x00, 0x10, 0x00,
     0x80, 0x00, 0x00, 0x80, 0x5F, 0x9B, 0x34, 0xFB},

    /**
     *  UUID Index 14 :
     *  ( 0x1106 ) -> OBEXFileTransfer
     */
    {0x00, 0x00, 0x11, 0x06, 0x00, 0x00, 0x10, 0x00,
     0x80, 0x00, 0x00, 0x80, 0x5F, 0x9B, 0x34, 0xFB},

    /**
     *  UUID Index 15 :
     *  ( 0x110A ) -> AudioSource
     */
    {0x00, 0x00, 0x11, 0x0A, 0x00, 0x00, 0x10, 0x00,
     0x80, 0x00, 0x00, 0x80, 0x5F, 0x9B, 0x34, 0xFB},

    /**
     *  UUID Index 16 :
     *  ( 0x110B ) -> AudioSink
     */
    {0x00, 0x00, 0x11, 0x0B, 0x00, 0x00, 0x10, 0x00,
     0x80, 0x00, 0x00, 0x80, 0x5F, 0x9B, 0x34, 0xFB},

    /**
     *  UUID Index 17 :
     *  ( 0x110C ) -> AV_RemoteControlTarget
     */
    {0x00, 0x00, 0x11, 0x0C, 0x00, 0x00, 0x10, 0x00,
     0x80, 0x00, 0x00, 0x80, 0x5F, 0x9B, 0x34, 0xFB},

    /**
     *  UUID Index 18 :
     *  ( 0x110D ) -> AdvancedAudioDistribution
     */
    {0x00, 0x00, 0x11, 0x0D, 0x00, 0x00, 0x10, 0x00,
     0x80, 0x00, 0x00, 0x80, 0x5F, 0x9B, 0x34, 0xFB},

    /**
     *  UUID Index 19 :
     *  ( 0x110E ) -> AV_RemoteControl
     */
    {0x00, 0x00, 0x11, 0x0E, 0x00, 0x00, 0x10, 0x00,
     0x80, 0x00, 0x00, 0x80, 0x5F, 0x9B, 0x34, 0xFB},

    /**
     *  UUID Index 20 :
     *  ( 0x110F ) -> AV_RemoteControlController
     */
    {0x00, 0x00, 0x11, 0x0F, 0x00, 0x00, 0x10, 0x00,
     0x80, 0x00, 0x00, 0x80, 0x5F, 0x9B, 0x34, 0xFB},

    /**
     *  UUID Index 21 :
     *  ( 0x1115 ) -> PANU
     */
    {0x00, 0x00, 0x11, 0x15, 0x00, 0x00, 0x10, 0x00,
     0x80, 0x00, 0x00, 0x80, 0x5F, 0x9B, 0x34, 0xFB},

    /**
     *  UUID Index 22 :
     *  ( 0x1116 ) -> NAP
     */
    {0x00, 0x00, 0x11, 0x16, 0x00, 0x00, 0x10, 0x00,
     0x80, 0x00, 0x00, 0x80, 0x5F, 0x9B, 0x34, 0xFB},

    /**
     *  UUID Index 23 :
     *  ( 0x1117 ) -> GN
     */
    {0x00, 0x00, 0x11, 0x17, 0x00, 0x00, 0x10, 0x00,
     0x80, 0x00, 0x00, 0x80, 0x5F, 0x9B, 0x34, 0xFB},

    /**
     *  UUID Index 24 :
     *  ( 0x1118 ) -> DirectPrinting
     */
    {0x00, 0x00, 0x11, 0x18, 0x00, 0x00, 0x10, 0x00,
     0x80, 0x00, 0x00, 0x80, 0x5F, 0x9B, 0x34, 0xFB},

    /**
     *  UUID Index 25 :
     *  ( 0x1119 ) -> ReferencePrinting
     */
    {0x00, 0x00, 0x11, 0x19, 0x00, 0x00, 0x10, 0x00,
     0x80, 0x00, 0x00, 0x80, 0x5F, 0x9B, 0x34, 0xFB},

    /**
     *  UUID Index 26 :
     *  ( 0x111A ) -> Imaging
     */
    {0x00, 0x00, 0x11, 0x1A, 0x00, 0x00, 0x10, 0x00,
     0x80, 0x00, 0x00, 0x80, 0x5F, 0x9B, 0x34, 0xFB},

    /**
     *  UUID Index 27 :
     *  ( 0x111B ) -> ImagingResponder
     */
    {0x00, 0x00, 0x11, 0x1B, 0x00, 0x00, 0x10, 0x00,
     0x80, 0x00, 0x00, 0x80, 0x5F, 0x9B, 0x34, 0xFB},

    /**
     *  UUID Index 28 :
     *  ( 0x111C ) -> ImagingAutomaticArchive
     */
    {0x00, 0x00, 0x11, 0x1C, 0x00, 0x00, 0x10, 0x00,
     0x80, 0x00, 0x00, 0x80, 0x5F, 0x9B, 0x34, 0xFB},

    /**
     *  UUID Index 29 :
     *  ( 0x111D ) -> ImagingReferencedObjects
     */
    {0x00, 0x00, 0x11, 0x1D, 0x00, 0x00, 0x10, 0x00,
     0x80, 0x00, 0x00, 0x80, 0x5F, 0x9B, 0x34, 0xFB},

    /**
     *  UUID Index 30 :
     *  ( 0x111E ) -> Handsfree
     */
    {0x00, 0x00, 0x11, 0x1E, 0x00, 0x00, 0x10, 0x00,
     0x80, 0x00, 0x00, 0x80, 0x5F, 0x9B, 0x34, 0xFB},

    /**
     *  UUID Index 31 :
     *  ( 0x111F ) -> HandsfreeAudioGateway
     */
    {0x00, 0x00, 0x11, 0x1F, 0x00, 0x00, 0x10, 0x00,
     0x80, 0x00, 0x00, 0x80, 0x5F, 0x9B, 0x34, 0xFB},

    /**
     *  UUID Index 32 :
     *  ( 0x1120 ) -> DirectPrintingReferenceObjectsService
     */
    {0x00, 0x00, 0x11, 0x20, 0x00, 0x00, 0x10, 0x00,
     0x80, 0x00, 0x00, 0x80, 0x5F, 0x9B, 0x34, 0xFB},

    /**
     *  UUID Index 33 :
     *  ( 0x1121 ) -> ReflectedUI
     */
    {0x00, 0x00, 0x11, 0x21, 0x00, 0x00, 0x10, 0x00,
     0x80, 0x00, 0x00, 0x80, 0x5F, 0x9B, 0x34, 0xFB},

    /**
     *  UUID Index 34 :
     *  ( 0x1122 ) -> BasicPrinting
     */
    {0x00, 0x00, 0x11, 0x22, 0x00, 0x00, 0x10, 0x00,
     0x80, 0x00, 0x00, 0x80, 0x5F, 0x9B, 0x34, 0xFB},

    /**
     *  UUID Index 35 :
     *  ( 0x1123 ) -> PrintingStatus
     */
    {0x00, 0x00, 0x11, 0x23, 0x00, 0x00, 0x10, 0x00,
     0x80, 0x00, 0x00, 0x80, 0x5F, 0x9B, 0x34, 0xFB},

    /**
     *  UUID Index 36 :
     *  ( 0x1124 ) -> HumanInterfaceDeviceService
     */
    {0x00, 0x00, 0x11, 0x24, 0x00, 0x00, 0x10, 0x00,
     0x80, 0x00, 0x00, 0x80, 0x5F, 0x9B, 0x34, 0xFB},

    /**
     *  UUID Index 37 :
     *  ( 0x112D ) -> SIM Access
     */
    {0x00, 0x00, 0x11, 0x2D, 0x00, 0x00, 0x10, 0x00,
     0x80, 0x00, 0x00, 0x80, 0x5F, 0x9B, 0x34, 0xFB},

    /**
     *  UUID Index 38 :
     *  ( 0x112E ) -> Phonebook Access Client
     */
    {0x00, 0x00, 0x11, 0x2E, 0x00, 0x00, 0x10, 0x00,
     0x80, 0x00, 0x00, 0x80, 0x5F, 0x9B, 0x34, 0xFB},

    /**
     *  UUID Index 39 :
     *  ( 0x112F ) -> Phonebook Access Server
     */
    {0x00, 0x00, 0x11, 0x2F, 0x00, 0x00, 0x10, 0x00,
     0x80, 0x00, 0x00, 0x80, 0x5F, 0x9B, 0x34, 0xFB},

    /**
     *  UUID Index 40 :
     *  ( 0x1130 ) -> Phonebook Access
     */
    {0x00, 0x00, 0x11, 0x30, 0x00, 0x00, 0x10, 0x00,
     0x80, 0x00, 0x00, 0x80, 0x5F, 0x9B, 0x34, 0xFB},

    /**
     *  UUID Index 41 :
     *  ( 0x1132 ) -> Message Access Server
     */
    {0x00, 0x00, 0x11, 0x32, 0x00, 0x00, 0x10, 0x00,
     0x80, 0x00, 0x00, 0x80, 0x5F, 0x9B, 0x34, 0xFB},

    /**
     *  UUID Index 42 :
     *  ( 0x1133 ) -> Message Notification Server
     */
    {0x00, 0x00, 0x11, 0x33, 0x00, 0x00, 0x10, 0x00,
     0x80, 0x00, 0x00, 0x80, 0x5F, 0x9B, 0x34, 0xFB},

    /**
     *  UUID Index 43 :
     *  ( 0x1134 ) -> Message Access Profile
     */
    {0x00, 0x00, 0x11, 0x34, 0x00, 0x00, 0x10, 0x00,
     0x80, 0x00, 0x00, 0x80, 0x5F, 0x9B, 0x34, 0xFB},

    /**
     *  UUID Index 44 :
     *  ( 0x113A ) -> MPS_Profile_UUID
     */
    {0x00, 0x00, 0x11, 0x3A, 0x00, 0x00, 0x10, 0x00,
     0x80, 0x00, 0x00, 0x80, 0x5F, 0x9B, 0x34, 0xFB},

    /**
     *  UUID Index 45 :
     *  ( 0x113B ) -> MPS_SC_UUID
     */
    {0x00, 0x00, 0x11, 0x3B, 0x00, 0x00, 0x10, 0x00,
     0x80, 0x00, 0x00, 0x80, 0x5F, 0x9B, 0x34, 0xFB},

    /**
     *  UUID Index 46 :
     *  ( 0x113C ) -> CTNAccessService
     */
    {0x00, 0x00, 0x11, 0x3C, 0x00, 0x00, 0x10, 0x00,
     0x80, 0x00, 0x00, 0x80, 0x5F, 0x9B, 0x34, 0xFB},

    /**
     *  UUID Index 47 :
     *  ( 0x113D ) -> CTNNotificationService
     */
    {0x00, 0x00, 0x11, 0x3D, 0x00, 0x00, 0x10, 0x00,
     0x80, 0x00, 0x00, 0x80, 0x5F, 0x9B, 0x34, 0xFB},

    /**
     *  UUID Index 48 :
     *  ( 0x113E ) -> CTNProfile
     */
    {0x00, 0x00, 0x11, 0x3E, 0x00, 0x00, 0x10, 0x00,
     0x80, 0x00, 0x00, 0x80, 0x5F, 0x9B, 0x34, 0xFB},

    /**
     *  UUID Index 49 :
     *  ( 0x1200 ) -> PnPInformation
     */
    {0x00, 0x00, 0x12, 0x00, 0x00, 0x00, 0x10, 0x00,
     0x80, 0x00, 0x00, 0x80, 0x5F, 0x9B, 0x34, 0xFB},

    /**
     *  UUID Index 50 :
     *  ( 0x1203 ) -> GenericAudio
     */
    {0x00, 0x00, 0x12, 0x03, 0x00, 0x00, 0x10, 0x00,
     0x80, 0x00, 0x00, 0x80, 0x5F, 0x9B, 0x34, 0xFB},

    /**
     *  UUID Index 51 :
     *  ( 0x1204 ) -> GenericTelephony
     */
    {0x00, 0x00, 0x12, 0x04, 0x00, 0x00, 0x10, 0x00,
     0x80, 0x00, 0x00, 0x80, 0x5F, 0x9B, 0x34, 0xFB},

    /**
     *  UUID Index 52 :
     *  ( 0x1400 ) -> HDPProfile
     */
    {0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x10, 0x00,
     0x80, 0x00, 0x00, 0x80, 0x5F, 0x9B, 0x34, 0xFB},

    /**
     *  UUID Index 53 :
     *  ( 0x1401 ) -> HDPSource
     */
    {0x00, 0x00, 0x14, 0x01, 0x00, 0x00, 0x10, 0x00,
     0x80, 0x00, 0x00, 0x80, 0x5F, 0x9B, 0x34, 0xFB},

    /**
     *  UUID Index 54 :
     *  ( 0x1402 ) -> HDPSink
     */
    {0x00, 0x00, 0x14, 0x02, 0x00, 0x00, 0x10, 0x00,
     0x80, 0x00, 0x00, 0x80, 0x5F, 0x9B, 0x34, 0xFB},

    /**
     *  UUID Index 55 :
     *  ( 0x1800 ) -> GenericAccessProfile
     */
    {0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x10, 0x00,
     0x80, 0x00, 0x00, 0x80, 0x5F, 0x9B, 0x34, 0xFB},

    /**
     *  UUID Index 56 :
     *  ( 0x1801 ) -> GenericAttributeProfile
     */
    {0x00, 0x00, 0x18, 0x01, 0x00, 0x00, 0x10, 0x00,
     0x80, 0x00, 0x00, 0x80, 0x5F, 0x9B, 0x34, 0xFB},

    /**
     *  UUID Index 57 :
     *  ( 0x1805 ) -> CurrentTimeService
     */
    {0x00, 0x00, 0x18, 0x05, 0x00, 0x00, 0x10, 0x00,
     0x80, 0x00, 0x00, 0x80, 0x5F, 0x9B, 0x34, 0xFB},

    /**
     *  UUID Index 58 :
     *  ( 0x180A ) -> DeviceInformationService
     */
    {0x00, 0x00, 0x18, 0x0A, 0x00, 0x00, 0x10, 0x00,
     0x80, 0x00, 0x00, 0x80, 0x5F, 0x9B, 0x34, 0xFB},

    /**
     *  UUID Index 59 :
     *  ( 0x180F ) -> BatteryService
     */
    {0x00, 0x00, 0x18, 0x0F, 0x00, 0x00, 0x10, 0x00,
     0x80, 0x00, 0x00, 0x80, 0x5F, 0x9B, 0x34, 0xFB},

    /**
     *  UUID Index 60 :
     *  ( 0x1814 ) -> RunningSpeedAndCadence
     */
    {0x00, 0x00, 0x18, 0x14, 0x00, 0x00, 0x10, 0x00,
     0x80, 0x00, 0x00, 0x80, 0x5F, 0x9B, 0x34, 0xFB},

    /**
     *  UUID Index 61 :
     *  ( 0x1816 ) -> CyclingSpeedAndCadence
     */
    {0x00, 0x00, 0x18, 0x16, 0x00, 0x00, 0x10, 0x00,
     0x80, 0x00, 0x00, 0x80, 0x5F, 0x9B, 0x34, 0xFB},

    /**
     *  UUID Index 62 :
     *  ( 0x1818 ) -> CyclingPower
     */
    {0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x10, 0x00,
     0x80, 0x00, 0x00, 0x80, 0x5F, 0x9B, 0x34, 0xFB},

    /**
     *  UUID Index 63 :
     *  ( 0x1823 ) -> HTTPProxyService
     */
    {0x00, 0x00, 0x18, 0x23, 0x00, 0x00, 0x10, 0x00,
     0x80, 0x00, 0x00, 0x80, 0x5F, 0x9B, 0x34, 0xFB},

    /**
     *  UUID Index 64 :
     *  ( 0x112233445566778899AABBCCDDEEFF00 ) -> CustomUUID_0
     */
    {0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77, 0x88,
     0x99, 0xAA, 0xBB, 0xCC, 0xDD, 0xEE, 0xFF, 0x00}
};



/*
 *  Function Name:
 *    BT_dbase_get_record_handle
 *
 *  Description:
 *      This function returns the record handle in the database
 *      that is associated with a particular service type and its instance.
 *
 *  Input Parameters:
 *      UCHAR service_type      : Identifies the service type.
 *      UCHAR service_instance  : Identifies the instance of
 *                                a particular service type.
 *      UINT32 * rec_hdl        : Associated record handle returned by this API
 *
 *  Output Parameters:
 *       API_RESULT : API_SUCCESS in case of success, otherwise API_FAILURE
 */
API_RESULT BT_dbase_get_record_handle ( /* IN */  UCHAR service_type,
                                        /* IN */  UCHAR service_instance,
                                        /* OUT */ UINT32 *rec_hdl)
{
    if( NULL == rec_hdl)
    {
        return API_FAILURE;
    }

    *rec_hdl = 0xFFFFFFFF;

    switch(service_type)
    {
        case DB_RECORD_SDP:
        {
            *rec_hdl = 0x00000000;
        }
        break;

        case DB_RECORD_SAP:
        {
            *rec_hdl = 0x00090001;
        }
        break;

        case DB_RECORD_SPP:
        {
            *rec_hdl = 0x00090002;
        }
        break;

        case DB_RECORD_SPP_VS:
        {
            *rec_hdl = 0x00090003;
        }
        break;

        case DB_RECORD_FTP:
        {
            *rec_hdl = 0x00090004;
        }
        break;

        case DB_RECORD_HFU:
        {
            *rec_hdl = 0x00090005;
        }
        break;

        case DB_RECORD_HFAG:
        {
            *rec_hdl = 0x00090006;
        }
        break;

        case DB_RECORD_HID:
        {
            *rec_hdl = 0x00090007;
        }
        break;

        case DB_RECORD_A2DP_SINK:
        {
            *rec_hdl = 0x00090008;
        }
        break;

        case DB_RECORD_A2DP_SOURCE:
        {
            *rec_hdl = 0x00090009;
        }
        break;

        case DB_RECORD_OPP:
        {
            *rec_hdl = 0x0009000A;
        }
        break;

        case DB_RECORD_NAP:
        {
            *rec_hdl = 0x0009000B;
        }
        break;

        case DB_RECORD_GN:
        {
            *rec_hdl = 0x0009000C;
        }
        break;

        case DB_RECORD_PANU:
        {
            *rec_hdl = 0x0009000D;
        }
        break;

        case DB_RECORD_BIP:
        {
            *rec_hdl = 0x0009000E;
        }
        break;

        case DB_RECORD_RO:
        {
            *rec_hdl = 0x0009000F;
        }
        break;

        case DB_RECORD_ARCHIVED_OBJECTS:
        {
            *rec_hdl = 0x00090010;
        }
        break;

        case DB_RECORD_BPP:
        {
            *rec_hdl = 0x00090011;
        }
        break;

        case DB_RECORD_BASIC_PRINTING_REFERENCED_OBJECTS:
        {
            *rec_hdl = 0x00090012;
        }
        break;

        case DB_RECORD_PRINTER_ADMINISTRATIVE_USER_INTERFACE:
        {
            *rec_hdl = 0x00090013;
        }
        break;

        case DB_RECORD_AVRCP_CONTROLLER:
        {
            *rec_hdl = 0x00090014;
        }
        break;

        case DB_RECORD_AVRCP_TARGET:
        {
            *rec_hdl = 0x00090015;
        }
        break;

        case DB_RECORD_PBAP_PCE:
        {
            *rec_hdl = 0x00090016;
        }
        break;

        case DB_RECORD_PBAP_PSE:
        {
            *rec_hdl = 0x00090017;
        }
        break;

        case DB_RECORD_DID:
        {
            if( 0 == service_instance )
            {
                *rec_hdl = 0x00090018;
            }
            else if( 1 == service_instance )
            {
                *rec_hdl = 0x00090019;
            }
        }
        break;

        case DB_RECORD_HDP:
        {
            *rec_hdl = 0x0009001A;
        }
        break;

        case DB_RECORD_MAP_MCE:
        {
            *rec_hdl = 0x0009001B;
        }
        break;

        case DB_RECORD_MAP_MSE:
        {
            if( 0 == service_instance )
            {
            *rec_hdl = 0x0009001C;
        }
            else if( 1 == service_instance )
            {
                *rec_hdl = 0x0009001D;
            }
        }
        break;

        case DB_RECORD_MPS:
        {
            *rec_hdl = 0x0009001E;
        }
        break;

        case DB_RECORD_GAP:
        {
            *rec_hdl = 0x0009001F;
        }
        break;

        case DB_RECORD_GATT:
        {
            *rec_hdl = 0x00090020;
        }
        break;

        case DB_RECORD_DIS:
        {
            *rec_hdl = 0x00090021;
        }
        break;

        case DB_RECORD_BAS:
        {
            *rec_hdl = 0x00090022;
        }
        break;

        case DB_RECORD_RSC:
        {
            *rec_hdl = 0x00090023;
        }
        break;

        case DB_RECORD_CSC:
        {
            *rec_hdl = 0x00090024;
        }
        break;

        case DB_RECORD_CPS:
        {
            *rec_hdl = 0x00090025;
        }
        break;

        case DB_RECORD_HPS:
        {
            *rec_hdl = 0x00090026;
        }
        break;

        case DB_RECORD_CTS:
        {
            *rec_hdl = 0x00090027;
        }
        break;

        case DB_RECORD_CTN_CCE:
        {
            *rec_hdl = 0x00090028;
        }
        break;

        case DB_RECORD_CTN_CSE:
        {
            if( 0 == service_instance )
            {
                *rec_hdl = 0x00090029;
            }
            else if( 1 == service_instance )
            {
                *rec_hdl = 0x0009002A;
            }
        }
        break;

    }

    return API_SUCCESS;
}

#endif /* SDP_SERVER */

