/*
 * Copyright 2018 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

/*
 * Generated by erpcgen 1.9.0 on Thu Sep 23 10:39:08 2021.
 *
 * AUTOGENERATED - DO NOT EDIT
 */


#include "erpc_client_manager.h"
#if ERPC_ALLOCATION_POLICY == ERPC_ALLOCATION_POLICY_DYNAMIC
#include "erpc_port.h"
#endif
#include "erpc_codec.h"
extern "C"
{
#include "erpc_two_way_rpc_Core1Interface.h"
// import callbacks declaration from other groups
#include "erpc_two_way_rpc_Core0Interface.h"
}

#if 10900 != ERPC_VERSION_NUMBER
#error "The generated shim code version is different to the rest of eRPC code."
#endif

using namespace erpc;
using namespace std;

extern ClientManager *g_client;

static const getNumberCallback_t _getNumberCallback_t[] = { getNumberFromCore1, getNumberFromCore0 };


// Core1Interface interface increaseNumber function client shim.
void increaseNumber(uint32_t * number)
{
    erpc_status_t err = kErpcStatus_Success;

    // Get a new request.
    RequestContext request = g_client->createRequest(false);

    // Encode the request.
    Codec * codec = request.getCodec();

    if (codec == NULL)
    {
        err = kErpcStatus_MemoryError;
    }
    else
    {
        codec->startWriteMessage(kInvocationMessage, kCore1Interface_service_id, kCore1Interface_increaseNumber_id, request.getSequence());

        codec->write(*number);

        // Send message to server
        // Codec status is checked inside this function.
        g_client->performRequest(request);

        codec->read(number);

        err = codec->getStatus();
    }

    // Dispose of the request.
    g_client->releaseRequest(request);

    // Invoke error handler callback function
    g_client->callErrorHandler(err, kCore1Interface_increaseNumber_id);

    return;
}

// Core1Interface interface getGetCallbackFunction function client shim.
void getGetCallbackFunction(getNumberCallback_t * getNumberCallbackParam)
{
    erpc_status_t err = kErpcStatus_Success;

    // Get a new request.
    RequestContext request = g_client->createRequest(false);

    // Encode the request.
    Codec * codec = request.getCodec();

    if (codec == NULL)
    {
        err = kErpcStatus_MemoryError;
    }
    else
    {
        codec->startWriteMessage(kInvocationMessage, kCore1Interface_service_id, kCore1Interface_getGetCallbackFunction_id, request.getSequence());

        // Send message to server
        // Codec status is checked inside this function.
        g_client->performRequest(request);

        codec->readCallback((arrayOfFunPtr)(_getNumberCallback_t), 2, (funPtr *)(&*getNumberCallbackParam));

        err = codec->getStatus();
    }

    // Dispose of the request.
    g_client->releaseRequest(request);

    // Invoke error handler callback function
    g_client->callErrorHandler(err, kCore1Interface_getGetCallbackFunction_id);

    return;
}

// Core1Interface interface getNumberFromCore0 function client shim.
void getNumberFromCore0(uint32_t * number)
{
    erpc_status_t err = kErpcStatus_Success;

    // Get a new request.
    RequestContext request = g_client->createRequest(false);

    // Encode the request.
    Codec * codec = request.getCodec();

    if (codec == NULL)
    {
        err = kErpcStatus_MemoryError;
    }
    else
    {
        codec->startWriteMessage(kInvocationMessage, kCore1Interface_service_id, kCore1Interface_getNumberFromCore0_id, request.getSequence());

        // Send message to server
        // Codec status is checked inside this function.
        g_client->performRequest(request);

        codec->read(number);

        err = codec->getStatus();
    }

    // Dispose of the request.
    g_client->releaseRequest(request);

    // Invoke error handler callback function
    g_client->callErrorHandler(err, kCore1Interface_getNumberFromCore0_id);

    return;
}
