/*
 * Copyright 2021 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#include "wifi_bt_config.h"
#include "pin_mux.h"
#include "pca6416.h"

/*******************************************************************************
 * Definitions
 ******************************************************************************/
#ifdef WIFI_BT_USE_USD_INTERFACE
  /* The iMXRT1176 Developers Kit does not have support for the uSD connector
     so make sure to prevent selection of a module that use it. */
  #error "uSD interface is not supported on this board"
#endif

/*******************************************************************************
 * Prototypes
 ******************************************************************************/

/*******************************************************************************
 * Variables
 ******************************************************************************/

/*******************************************************************************
 * Code
 ******************************************************************************/

void BOARD_WIFI_BT_Enable(bool enable)
{
    if (enable)
    {
        /* Enable module */
#ifdef WIFI_BT_USE_M2_INTERFACE

        // Control WL_REG_ON. The PCA6416 control is for early iMXRT1176 silicon,
        // in later versions of the silicon it is possible to configure SNVS pins
        // as GPIOs. We control both here for backward compatibility.
        // Connected to both pins 23 and 56 on the M.2 connector.
        GPIO_PinWrite(GPIO13, 7, 1);
        PCA6416_SetPins(PCA_WL_REG_ON_3V3);

        // Control BT_REG_ON.
        // Connected to pin 54 on the M.2 connector
        GPIO_PinWrite(GPIO13, 4, 1);
        PCA6416_SetPins(PCA_BT_REG_ON_3V3);

#elif defined(WIFI_BT_USE_ONBOARD_MODULE)

        // Control WL_REG_ON.
        // Connected to both pins 23 and 56 on the M.2 connector.
        GPIO_PinWrite(GPIO13, 7, 1);

        // Control BT_REG_ON.
        // Connected to pin 54 on the M.2 connector
        GPIO_PinWrite(GPIO13, 4, 1);

#elif defined(WIFI_BT_USE_USD_INTERFACE)

        /* Enable power supply for SD */
        GPIO_PinWrite(BOARD_SDMMC_SD_POWER_RESET_GPIO_BASE, BOARD_SDMMC_SD_POWER_RESET_GPIO_PIN, 0);

#endif /* WIFI_BT_USE_M2_INTERFACE */

        vTaskDelay(pdMS_TO_TICKS(100));
    }
    else
    {
        /* Disable module */
#ifdef WIFI_BT_USE_M2_INTERFACE

        // Control WL_REG_ON. The PCA6416 control is for early iMXRT1176 silicon,
        // in later versions of the silicon it is possible to configure SNVS pins
        // as GPIOs. We control both here for backward compatibility.
        // Connected to both pins 23 and 56 on the M.2 connector.
        GPIO_PinWrite(GPIO13, 7, 0);
        PCA6416_ClearPins(PCA_WL_REG_ON_3V3);

        // Control BT_REG_ON.
        // Connected to pin 54 on the M.2 connector
        GPIO_PinWrite(GPIO13, 4, 0);
        PCA6416_ClearPins(PCA_BT_REG_ON_3V3);

#elif defined(WIFI_BT_USE_ONBOARD_MODULE)

        // Control WL_REG_ON.
        // Connected to both pins 23 and 56 on the M.2 connector.
        GPIO_PinWrite(GPIO13, 7, 0);

        // Control BT_REG_ON.
        // Connected to pin 54 on the M.2 connector
        GPIO_PinWrite(GPIO13, 4, 0);

#elif defined(WIFI_BT_USE_USD_INTERFACE)

        /* Disable power supply for SD */
        GPIO_PinWrite(BOARD_SDMMC_SD_POWER_RESET_GPIO_BASE, BOARD_SDMMC_SD_POWER_RESET_GPIO_PIN, 1);

#endif /* WIFI_BT_USE_M2_INTERFACE */

        vTaskDelay(pdMS_TO_TICKS(100));
    }
}

void BOARD_WIFI_BT_Config(void *card, sdio_int_t cardInt)
{
    BOARD_SDIO_Config(card, NULL, BOARD_SDMMC_SDIO_HOST_IRQ_PRIORITY, cardInt);

#ifdef WIFI_BT_USE_M2_INTERFACE
    ((sdio_card_t *)card)->usrParam.pwr = NULL;
    BOARD_InitPinsM2();
#endif
    BOARD_WIFI_BT_Enable(false);
}
