/*******************************************************************************
*
 * Copyright (c) 2013 - 2016, Freescale Semiconductor, Inc.
 * Copyright 2016-2021 NXP
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * o Redistributions of source code must retain the above copyright notice, this list
 *   of conditions and the following disclaimer.
 * o Redistributions in binary form must reproduce the above copyright notice, this
 *   list of conditions and the following disclaimer in the documentation and/or
 *   other materials provided with the distribution.
 *
 * o Neither the name of the copyright holder nor the names of its
 *   contributors may be used to endorse or promote products derived from this
 *   software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
*
****************************************************************************//*!
*
* @brief Main MCAA_LIB header file for devices with FPU.
*
*******************************************************************************/
#ifndef _MCAA_LIB_H_
#define _MCAA_LIB_H_

#if defined(__cplusplus)
extern "C" {
#endif

/*******************************************************************************
* Includes
*******************************************************************************/
#include "mcaa_estimrl.h"

/*******************************************************************************
* Macros
*******************************************************************************/
#if (defined(RAM_RELOCATION)) /* placed to RAM */
#define MCAA_EstimRLInit_FLT(u32SamplingFreq, psParam, psCtrl)                    \
        MCAA_EstimRLInit_FLT_CRam(u32SamplingFreq, psParam, psCtrl)
#define MCAA_EstimRL_FLT(fltUDcBus, psIAlBeFbck, psCtrl, psParam, psUAlBeReq)     \
        MCAA_EstimRL_FLT_CRam(fltUDcBus, psIAlBeFbck, psCtrl, psParam, psUAlBeReq)
#else  /* placed to ROM */
#define MCAA_EstimRLInit_FLT(u32SamplingFreq, psParam, psCtrl)                  \
        MCAA_EstimRLInit_FLT_C(u32SamplingFreq, psParam, psCtrl)
#define MCAA_EstimRL_FLT(fltUDcBus, psIAlBeFbck, psCtrl, psParam, psUAlBeReq)   \
        MCAA_EstimRL_FLT_C(fltUDcBus, psIAlBeFbck, psCtrl, psParam, psUAlBeReq)		
#endif /* defined(RAM_RELOCATION) */

#if defined(__cplusplus)
}
#endif

#endif /* _MCAA_LIB_H_ */
