set(QUL_COLOR_DEPTH 32)
set(MIMXRT1170 ON CACHE BOOL "")

# The QUL_PLATFORM_DEFAULT_SCREEN_HEIGHT/WIDTH are not used but must be set.
# The real control of resolution is done in display_support.h
set(QUL_PLATFORM_DEFAULT_SCREEN_HEIGHT 10)
set(QUL_PLATFORM_DEFAULT_SCREEN_WIDTH  10)

set(QUL_PLATFORM_DEFAULT_RESOURCE_PIXEL_FORMAT_ALPHA ARGB8888)
set(QUL_PLATFORM_DEFAULT_RESOURCE_PIXEL_FORMAT_OPAQUE XRGB8888)

set(QUL_OS "FreeRTOS" CACHE INTERNAL "Operating system")

if(NOT DEFINED FREERTOS_DIR)
    set(FREERTOS_DIR "${QUL_BOARD_SDK_DIR}/rtos/freertos/freertos_kernel")
    message(STATUS "FREERTOS_DIR cache entry not set. Using default: ${FREERTOS_DIR}")
endif()

set(QUL_PLATFORM_REQUIRED_IMAGE_ALIGNMENT "8")
set(QUL_PLATFORM_REQUIRED_PIXEL_WIDTH_ALIGNMENT "16")
set(QUL_PRIVATE_DEFAULT_RESOURCE_SPLIT_IMAGE_OPTIMIZATION OFF)
set(QUL_PLATFORM_DEFAULT_RESOURCE_ALPHA_OPTIONS "Never")
set(QUL_PRIVATE_DEFAULT_RESOURCE_PADDING "PadToForcedDimensions")

set(NXP_CHIP_NAME "MIMXRT1176xxxxx" CACHE STRING "NXP Chip name for flash tool")
set(NXP_CONNECT_SCRIPT "RT1170_connect_M7_wake_M4.scp" CACHE STRING "NXP connect script name for flash tool")
set(NXP_PARTFILES_DIR "${QUL_PLATFORM_BOARDS_DIR}/embeddedartists/EAIMXRT1176-freertos/cmake" CACHE STRING "Directory that contains the part description files for flashing")
set(NXP_RESET_SCRIPT "RT1170_reset.scp" CACHE STRING "NXP reset script name for flash tool")

set(QUL_PLATFORM_EXCLUDED_DEMOS "automotive;thermo;watch" CACHE STRING "List of excluded demos/examples from build")
set(QUL_PLATFORM_EXCLUDED_EXAMPLES "multiscreen" CACHE STRING "List of examples excluded from build")

set(QUL_PLATFORM_ARCHITECTURE "${QUL_PLATFORM}")
set(QUL_PLATFORM_ARCHITECTURE_FILE "${CMAKE_CURRENT_LIST_DIR}/../../../../architecture/cortex-m7-hf-fpv5-d16/${COMPILER_FOLDER_NAME}/architecture.cmake")

if(IAR)
    qul_platform_add_default_linker_script("${CMAKE_CURRENT_LIST_DIR}/${QUL_COMPILER_NAME}/MIMXRT1176xxxxx_cm7_flexspi_nor_sdram.icf")
else()
    qul_platform_add_default_linker_script("${CMAKE_CURRENT_LIST_DIR}/${QUL_COMPILER_NAME}/MIMXRT1176xxxxx_cm7_flexspi_nor_sdram.ld")
endif()

#set(EXCLUDED_TESTS "painteditem" CACHE STRING "List of tests excluded from build")
set(NXP_PARTFILES_DIR "${QUL_PLATFORM_DIR}/boards/embeddedartists/EAIMXRT1176-freertos/cmake" CACHE STRING "Directory that contains the part description files for flashing")
