/******************************************************************************
**
** Copyright (C) 2021 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of the Qt Quick Ultralite module.
**
** $QT_BEGIN_LICENSE:COMM$
**
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see http://www.qt.io/terms-conditions. For further
** information use the contact form at http://www.qt.io/contact-us.
**
** $QT_END_LICENSE$
**
******************************************************************************/

#include "noncacheableallocator.h"

using namespace Qul::Platform::Private;

#if defined(__ICCARM__)
#pragma section = "NCACHE_HEAP"
char *begin = reinterpret_cast<char *>(__section_begin("NCACHE_HEAP"));
char *end = reinterpret_cast<char *>(__section_end("NCACHE_HEAP"));
#else
extern unsigned char __noncacheheap_start;
extern unsigned char __noncacheheap_end;
char *begin = reinterpret_cast<char *>(&__noncacheheap_start);
char *end = reinterpret_cast<char *>(&__noncacheheap_end);
#endif

NonCacheableAllocator::NonCacheableAllocator()
    : FixedSizeBlockAllocator(begin, end)
{}
