file(TO_CMAKE_PATH "${MCUXPRESSO_IDE_PATH}" MCUXPRESSO_IDE_PATH)
find_program(nxp_flash_tool NAMES crt_emu_cm_redlink
    PATHS
        "/usr/local/mcuxpressoide/ide/binaries"
        "${MCUXPRESSO_IDE_PATH}/ide/binaries"
        # this is for MacOS
        "${MCUXPRESSO_IDE_PATH}/binaries"
)

if(NOT nxp_flash_tool)
    message(STATUS "NXP_Flash_tool not found, make flash targets will be disabled!")
    message(STATUS "To enable, provide MCUXPRESSO_IDE_PATH cache entry pointing to install path of MCUXpressoIDE")
endif()

function(add_executable_hook name)
    if (NOT nxp_flash_tool)
        message(STATUS "NXP_Flash_tool not found, won't generate flash targets for ${name}")
    else()
        qul_private_find_and_get_board_manufacturer_name(${QUL_PLATFORM})
        string(TOLOWER ${QUL_PLATFORM} board_name)
        add_custom_target("flash_${name}" COMMAND ${nxp_flash_tool} -g --flash-load-exec "$<TARGET_FILE_DIR:${name}>/${name}.elf" -p ${NXP_CHIP_NAME} --ConnectScript ${NXP_CONNECT_SCRIPT} -x ${NXP_PARTFILES_DIR} $<$<BOOL:${NXP_RESET_SCRIPT}>:--resetscript=${NXP_RESET_SCRIPT}>)
        message(STATUS "Added flash target flash_${name}")
    endif()
endfunction()
