# This cmake file configures installing Qul and supporting platform libraries

function(qul_private_install_libs_with_symlinks)
    set(options)
    set(oneValues DESTINATION COMPONENT)
    set(multipleValues FILES)
    cmake_parse_arguments(_ARGS "${options}" "${oneValues}" "${multipleValues}" ${ARGN})
    foreach(file_path ${_ARGS_FILES})
        file(GLOB lib_with_symlinks "${file_path}*[!.debug]")
        install(FILES
                    ${file_path}
                    ${lib_with_symlinks}
                DESTINATION ${_ARGS_DESTINATION}
                COMPONENT ${_ARGS_COMPONENT}
                ${_ARGS_UNPARSED_ARGUMENTS}
        )
    endforeach()
endfunction()

file(MAKE_DIRECTORY ${Qul_BINARY_DIR}/include/qul)

install(DIRECTORY ${PROJECT_SOURCE_DIR}/include/qul
        DESTINATION "${CMAKE_INSTALL_INCLUDEDIR}"
        COMPONENT Base)

install(DIRECTORY ${CMAKE_BINARY_DIR}/include/qul DESTINATION "${CMAKE_INSTALL_INCLUDEDIR}" COMPONENT Base)
set(CMAKE_INSTALL_PLUGINSDIR plugins)

include(GNUInstallDirs)

# The main export is defined in src/CMakeLists.txt right after
# add_library(Qul)

export(PACKAGE Qul)

if(QUL_BUILD_FRAMEWORK)
    if(NOT QUL_CORE_TARGETS_BASE_NAME)
        message(FATAL_ERROR "Internal error: QUL_CORE_TARGETS_BASE_NAME is not set")
    endif()

    install(TARGETS Core PNGDecoderLodePNG PNGDecoderNull
            EXPORT ${QUL_CORE_TARGETS_BASE_NAME}
            LIBRARY DESTINATION ${CMAKE_INSTALL_LIBDIR} COMPONENT Core
            ARCHIVE DESTINATION ${CMAKE_INSTALL_LIBDIR} COMPONENT Core
            PUBLIC_HEADER DESTINATION "${CMAKE_INSTALL_INCLUDEDIR}/qul" COMPONENT Base
           )

    export(TARGETS PlatformArchitecture APPEND
           NAMESPACE Qul::
           FILE "${PROJECT_BINARY_DIR}/${QUL_CORE_TARGETS_BASE_NAME}.cmake"
            )

    install(TARGETS PlatformArchitecture
            EXPORT ${QUL_CORE_TARGETS_BASE_NAME}
            DESTINATION ${CMAKE_INSTALL_LIBDIR} COMPONENT Base)
endif()

if(QUL_BUILD_PLATFORM)
    if(NOT QUL_PLATFORM_TARGETS_BASE_NAME)
        message(FATAL_ERROR "Internal error: QUL_PLATFORM_TARGETS_BASE_NAME is not set")
    endif()

    install(FILES "${PROJECT_BINARY_DIR}/QulPlatformTargets_${QUL_PLATFORM}_extra_config.cmake"
            DESTINATION "${INSTALL_CMAKE_DIR}/QulPlatformTargets"
            COMPONENT PlatformSources OPTIONAL)
endif()

install(DIRECTORY "${PROJECT_SOURCE_DIR}/src/3rdparty/minihdlc"
        DESTINATION "src/3rdparty"
        COMPONENT PlatformBase)

install(FILES "${PROJECT_SOURCE_DIR}/src/3rdparty/NanopbConfig.cmake"
        DESTINATION "src/3rdparty"
        COMPONENT PlatformBase)

install(DIRECTORY "${PROJECT_SOURCE_DIR}/src/3rdparty/nanopb"
        DESTINATION "src/3rdparty"
        COMPONENT PlatformBase
        PATTERN "3rdparty/nanopb/spm_headers" EXCLUDE) # not needed, and does include symlinks

# On Windows install required Tools DLLs
if(WIN32)
    # Binaries
    find_package(Qt5 5.15 COMPONENTS Core Gui Xml LinguistTools REQUIRED)

    # Look for dlls for clang and freetype, but search only in CMAKE specific directories,
    # as looking in system PATH can result in installation of wrong dlls from unrelated software
    find_file(FREETYPE_DLL_PATH freetype.dll NO_SYSTEM_ENVIRONMENT_PATH PATH_SUFFIXES lib)
    if (NOT FREETYPE_DLL_PATH)
        message(FATAL_ERROR "Could not find freetype.dll for installation")
    endif()
    find_file(LIBCLANG_DLL_PATH libclang.dll NO_SYSTEM_ENVIRONMENT_PATH PATH_SUFFIXES bin)
    if (NOT LIBCLANG_DLL_PATH)
        message(FATAL_ERROR "Could not find libclang.dll for installation")
    endif()

    install(FILES "${_qt5Core_install_prefix}/bin/Qt5Core.dll"
            "${_qt5Core_install_prefix}/bin/Qt5Gui.dll"
            "${_qt5Core_install_prefix}/bin/Qt5Network.dll"
            "${_qt5Core_install_prefix}/bin/Qt5Xml.dll"
            "${_qt5Core_install_prefix}/bin/Qt5Svg.dll"
            "${_qt5Core_install_prefix}/bin/Qt5Widgets.dll"
            "${_qt5Core_install_prefix}/bin/lrelease.exe"
            "${_qt5Core_install_prefix}/bin/lupdate.exe"
            "${_qt5Core_install_prefix}/bin/lconvert.exe"
            "${CMAKE_CURRENT_SOURCE_DIR}/util/qt.conf"
            "${FREETYPE_DLL_PATH}"
            "${LIBCLANG_DLL_PATH}"
            DESTINATION ${CMAKE_INSTALL_BINDIR}
            COMPONENT Tools
    )

    # Image plugins are required for all platforms (used by qulrcc)
    install(DIRECTORY "${_qt5Core_install_prefix}/plugins/imageformats"
            DESTINATION ${CMAKE_INSTALL_PLUGINSDIR}
            COMPONENT Tools
            FILES_MATCHING
            PATTERN "*.dll"
            PATTERN  "*d.dll" EXCLUDE
    )

    # Qt5 binaries needed by desktop backend
    install(FILES "${_qt5Core_install_prefix}/bin/Qt5Cored.dll"
            "${_qt5Core_install_prefix}/bin/Qt5Guid.dll"
            "${_qt5Core_install_prefix}/bin/Qt5Widgetsd.dll"
            DESTINATION ${CMAKE_INSTALL_BINDIR}
            COMPONENT Core
            CONFIGURATIONS Debug
    )

    install(FILES "${_qt5Core_install_prefix}/plugins/platforms/qwindowsd.dll"
            DESTINATION ${CMAKE_INSTALL_PLUGINSDIR}/platforms
            COMPONENT Core
            CONFIGURATIONS Debug
    )

    install(FILES "${_qt5Core_install_prefix}/lib/Qt5Cored.lib"
            "${_qt5Core_install_prefix}/lib/Qt5Widgetsd.lib"
            "${_qt5Core_install_prefix}/lib/Qt5Guid.lib"
            DESTINATION ${CMAKE_INSTALL_LIBDIR}
            COMPONENT Core
            CONFIGURATIONS Debug
    )

    install(FILES "${_qt5Core_install_prefix}/bin/Qt5Core.dll"
            "${_qt5Core_install_prefix}/bin/Qt5Gui.dll"
            "${_qt5Core_install_prefix}/bin/Qt5Widgets.dll"
            DESTINATION ${CMAKE_INSTALL_BINDIR}
            COMPONENT Core
            CONFIGURATIONS Release
    )

    install(FILES "${_qt5Core_install_prefix}/plugins/platforms/qwindows.dll"
            DESTINATION ${CMAKE_INSTALL_PLUGINSDIR}/platforms
            COMPONENT Core
            CONFIGURATIONS Release
    )

    install(FILES "${_qt5Core_install_prefix}/lib/Qt5Core.lib"
            "${_qt5Core_install_prefix}/lib/Qt5Widgets.lib"
            "${_qt5Core_install_prefix}/lib/Qt5Gui.lib"
            DESTINATION ${CMAKE_INSTALL_LIBDIR}
            COMPONENT Core
            CONFIGURATIONS Release
    )

    # CMake files
    install(FILES "${Qul_CMAKE_DIR}/QulTranslationTools.cmake"
                    DESTINATION "${INSTALL_CMAKE_DIR}"
                    COMPONENT Base)
elseif(UNIX AND NOT APPLE)
    # Binaries
    find_package(Qt5 5.15 COMPONENTS Core Gui Xml LinguistTools REQUIRED)
    set(CLANG_LIB_DIR ${CLANG_RESOURCE_DIR}/../..)
    # Look for shared libs for clang-10
    find_library(LIBCLANG_PATH libclang-10.so libclang.so libclang.so.10 PATHS ${CLANG_LIB_DIR} NO_SYSTEM_ENVIRONMENT_PATH)
    if (NOT LIBCLANG_PATH)
        message(FATAL_ERROR "Could not find libclang for installation")
    endif()
    find_library(LIBLLVM_PATH libLLVM-10.so libLLVM.so libLLVM.so.10 PATHS ${CLANG_LIB_DIR} NO_SYSTEM_ENVIRONMENT_PATH)
    if (NOT LIBLLVM_PATH)
        message(FATAL_ERROR "Could not find libLLVM for installation")
    endif()

    install(
        PROGRAMS
            "${_qt5Core_install_prefix}/bin/lrelease"
            "${_qt5Core_install_prefix}/bin/lupdate"
            "${_qt5Core_install_prefix}/bin/lconvert"
        DESTINATION ${CMAKE_INSTALL_BINDIR}
        COMPONENT Tools
    )

    install(
        FILES "${CMAKE_CURRENT_SOURCE_DIR}/util/qt.conf"
        DESTINATION ${CMAKE_INSTALL_BINDIR}
        COMPONENT Tools
    )

    qul_private_install_libs_with_symlinks(
        FILES
            "${_qt5Core_install_prefix}/lib/libQt5Core.so"
            "${_qt5Core_install_prefix}/lib/libQt5Widgets.so"
            "${_qt5Core_install_prefix}/lib/libQt5Gui.so"
            "${_qt5Core_install_prefix}/lib/libQt5Network.so"
            "${_qt5Core_install_prefix}/lib/libQt5Xml.so"
            "${_qt5Core_install_prefix}/lib/libQt5Svg.so"
            "${_qt5Core_install_prefix}/lib/libQt5DBus.so"
            "${_qt5Core_install_prefix}/lib/libQt5XcbQpa.so"
            "${_qt5Core_install_prefix}/lib/libicui18n.so"
            "${_qt5Core_install_prefix}/lib/libicuuc.so"
            "${_qt5Core_install_prefix}/lib/libicudata.so"
            "${LIBCLANG_PATH}"
            "${LIBLLVM_PATH}"
        DESTINATION ${CMAKE_INSTALL_LIBDIR}
        COMPONENT Tools
    )

    # Image plugins are required for all platforms (used by qulrcc)
    install(DIRECTORY "${_qt5Core_install_prefix}/plugins/imageformats"
            DESTINATION ${CMAKE_INSTALL_PLUGINSDIR}
            COMPONENT Tools
            FILES_MATCHING
            PATTERN "*.so"
            PATTERN "*.so.debug" EXCLUDE
    )

    qul_private_install_libs_with_symlinks(
        FILES
            "${_qt5Core_install_prefix}/lib/libQt5Core.so"
            "${_qt5Core_install_prefix}/lib/libQt5Widgets.so"
            "${_qt5Core_install_prefix}/lib/libQt5Gui.so"
        DESTINATION ${CMAKE_INSTALL_LIBDIR}
        COMPONENT Core
    )

    install(FILES "${_qt5Core_install_prefix}/plugins/platforms/libqxcb.so"
            DESTINATION ${CMAKE_INSTALL_PLUGINSDIR}/platforms
            COMPONENT Core
    )

    # CMake files
    install(FILES "${Qul_CMAKE_DIR}/QulTranslationTools.cmake"
                    DESTINATION "${INSTALL_CMAKE_DIR}"
                    COMPONENT Base)
else()
    # CMake files
    install(FILES "${Qul_CMAKE_DIR}/QulTranslationTools.cmake"
                    DESTINATION "${INSTALL_CMAKE_DIR}"
                    COMPONENT Base)
endif()

# CMake files
configure_file(${PROJECT_SOURCE_DIR}/src/QulConfig.cmake.in "${PROJECT_BINARY_DIR}/QulConfig.cmake" @ONLY)

set(CONF_APP_COMMON_DIR "\${Qul_CMAKE_DIR}/../../../src/app_common")
set(CONF_FONTS_DIR "\${Qul_CMAKE_DIR}/../../../src/3rdparty/fonts")
set(CONF_BIN_DIR "\${Qul_CMAKE_DIR}/../../../${CMAKE_INSTALL_BINDIR}")
set(CONF_LIB_DIR "\${Qul_CMAKE_DIR}/../../../${CMAKE_INSTALL_LIBDIR}")
set(CONF_CMAKE_MODULES_DIR "\${Qul_CMAKE_DIR}/extra-cmake-modules")

# This has to be removed when the platform architecture build is used
# See UL-3028
set(CONF_PLATFORM_DIR "\${Qul_CMAKE_DIR}/../../../platform")
install(FILES "${Qul_CMAKE_DIR}/PlatformDefaults.cmake"
        DESTINATION "${INSTALL_CMAKE_DIR}"
        COMPONENT PlatformBase)

install(FILES "${Qul_CMAKE_DIR}/AssetsDefaults.cmake"
        DESTINATION "${INSTALL_CMAKE_DIR}"
        COMPONENT PlatformBase)

install(DIRECTORY "${CMAKE_SOURCE_DIR}/include/platform"
        DESTINATION "${CMAKE_INSTALL_INCLUDEDIR}"
        COMPONENT PlatformHeaders)

configure_file(${PROJECT_SOURCE_DIR}/src/QulConfig.cmake.in
               "${PROJECT_BINARY_DIR}${CMAKE_FILES_DIRECTORY}/QulConfig.cmake"
               @ONLY)
configure_file(${PROJECT_SOURCE_DIR}/src/QulConfigVersion.cmake.in
               "${PROJECT_BINARY_DIR}/QulConfigVersion.cmake" @ONLY)


install(FILES "${PROJECT_BINARY_DIR}${CMAKE_FILES_DIRECTORY}/QulConfig.cmake"
              "${PROJECT_BINARY_DIR}/QulConfigVersion.cmake"
              "${Qul_CMAKE_DIR}/QulScopeFinalizerHelpers.cmake"
              "${Qul_CMAKE_DIR}/QulMacros.cmake"
              "${Qul_CMAKE_DIR}/QulTargetPostProcess.cmake"
        DESTINATION "${INSTALL_CMAKE_DIR}"
        COMPONENT Base)

install(FILES "${PROJECT_SOURCE_DIR}/CMakeLists.txt"
        DESTINATION "."
        COMPONENT Base)

install(FILES "${Qul_CMAKE_DIR}/extra-cmake-modules/FindQt5Bundle.cmake"
        DESTINATION "${INSTALL_CMAKE_DIR}/extra-cmake-modules"
        COMPONENT Base)

install(FILES "${Qul_CMAKE_DIR}/3rdparty/extra-cmake-modules/modules/ECMEnableSanitizers.cmake"
        DESTINATION "${INSTALL_CMAKE_DIR}/3rdparty/extra-cmake-modules/modules"
        COMPONENT Base)

install(FILES "${PROJECT_SOURCE_DIR}/src/app_common/AppMacros.cmake"
        DESTINATION "src/app_common"
        COMPONENT Base)

install(FILES "${Qul_CMAKE_DIR}/performancelogging.cmake"
        DESTINATION "${INSTALL_CMAKE_DIR}"
        COMPONENT Base)

install(DIRECTORY "${PROJECT_SOURCE_DIR}/src/app_common/mains"
        DESTINATION "src/app_common"
        COMPONENT Base)

install(DIRECTORY "${PROJECT_SOURCE_DIR}/src/app_common/freertos"
        DESTINATION "src/app_common"
        COMPONENT Base)

install(DIRECTORY "${Qul_CMAKE_DIR}/toolchain"
        DESTINATION "${INSTALL_CMAKE_DIR}"
        COMPONENT Base)

install(FILES "${PROJECT_SOURCE_DIR}/util/deviceinformationexchangeprotocol/deviceinformationexchangeprotocol.proto"
              "${PROJECT_SOURCE_DIR}/util/deviceinformationexchangeprotocol/deviceinformationexchangeprotocol.options"
        DESTINATION "util/deviceinformationexchangeprotocol"
        COMPONENT Base)

install(DIRECTORY ${PROJECT_SOURCE_DIR}/platform/architecture
        DESTINATION "platform"
        COMPONENT PlatformBase)

if(QUL_BUILD_FRAMEWORK)
    install(EXPORT ${QUL_CORE_TARGETS_BASE_NAME} NAMESPACE Qul:: DESTINATION "${INSTALL_CMAKE_DIR}/QulCoreTargets" COMPONENT Core)
endif()

# Examples
install(DIRECTORY ${PROJECT_SOURCE_DIR}/examples DESTINATION "." COMPONENT Examples
                                                                 PATTERN "*/test_automation" EXCLUDE
                                                                 PATTERN "*/examples/CMakeLists.txt" EXCLUDE)
install(DIRECTORY ${PROJECT_SOURCE_DIR}/demos DESTINATION "." COMPONENT Examples
                                              PATTERN "*/rh850-d1m1a-baremetal" EXCLUDE
                                              PATTERN "*/test_automation" EXCLUDE
                                              PATTERN "*/demos/CMakeLists.txt" EXCLUDE)
# Sources
install(DIRECTORY ${PROJECT_SOURCE_DIR}/src DESTINATION "." COMPONENT SourcesCore
                                                            PATTERN "*/app_common" EXCLUDE
                                                            PATTERN "QulMonotypeIntegration.cmake" EXCLUDE # installed by QulMonotypeIntegration.cmake
                                                            PATTERN "*/monotype" EXCLUDE # installed by QulMonotypeIntegration.cmake
                                                            PATTERN "3rdparty/nanopb" EXCLUDE # already installed in PlatformSources
                                                            PATTERN "3rdparty/minihdlc" EXCLUDE # already installed in PlatformSources
                                                            )

install(FILES ${PROJECT_SOURCE_DIR}/src/install.cmake
              ${PROJECT_SOURCE_DIR}/src/QulConfig.cmake.in
              ${PROJECT_SOURCE_DIR}/src/QulConfigVersion.cmake.in
        DESTINATION "src" COMPONENT PlatformSources) # This is a workaround for UL-4168.
                                                     # These files should not be part of the platform sources.

if(EXISTS ${PROJECT_SOURCE_DIR}/tests)
    install(DIRECTORY ${PROJECT_SOURCE_DIR}/tests DESTINATION "." COMPONENT TestsSources)
    install(DIRECTORY ${PROJECT_SOURCE_DIR}/test_automation DESTINATION "." COMPONENT TestsSources)
    install(DIRECTORY ${PROJECT_SOURCE_DIR}/demos
                      ${PROJECT_SOURCE_DIR}/examples
                      DESTINATION "."
                      COMPONENT TestsSources
                      FILES_MATCHING
                      REGEX ".*/test_automation/.*"
                      )
endif()

install(DIRECTORY ${PROJECT_SOURCE_DIR}/include/platforminterface
        DESTINATION "${CMAKE_INSTALL_INCLUDEDIR}"
        COMPONENT Base)

install(DIRECTORY ${Qul_SOURCE_DIR}/src/3rdparty/fonts
        DESTINATION "src/3rdparty"
        COMPONENT Base)

# These files need to be optional because when an eval customer(which does not have SourcesCore wants to install
# the eval version, these files are not available.
install(FILES "${PROJECT_SOURCE_DIR}/examples/CMakeLists.txt" DESTINATION "examples/" COMPONENT SourcesCore OPTIONAL)
install(FILES "${PROJECT_SOURCE_DIR}/demos/CMakeLists.txt" DESTINATION "demos/" COMPONENT SourcesCore OPTIONAL)
install(FILES "${PROJECT_SOURCE_DIR}/CMakeLists.txt" DESTINATION  "." COMPONENT SourcesCore OPTIONAL)

set(CONF_PLATFORM_DIR "\${Qul_CMAKE_DIR}/../../../platform")

install(FILES "${Qul_CMAKE_DIR}/PlatformDefaults.cmake"
        DESTINATION "${INSTALL_CMAKE_DIR}"
        COMPONENT PlatformBase)
install(FILES ${PROJECT_SOURCE_DIR}/platform/CMakeLists.txt
        DESTINATION "platform"
        COMPONENT PlatformBase)
install(DIRECTORY "${CMAKE_SOURCE_DIR}/platform/common"
        DESTINATION "platform"
        COMPONENT PlatformBase)
install(DIRECTORY "${CMAKE_SOURCE_DIR}/platform/private"
        DESTINATION "platform"
        COMPONENT PlatformBase)

# Package Generator  #######################################################

if(CMAKE_CROSSCOMPILING)
    set(CORE_PACKAGE_NAME "${QUL_COMPILER_NAME}-${QUL_PLATFORM_ARCHITECTURE}")
endif()
if(NOT CORE_PACKAGE_NAME AND (QUL_BUILD_PLATFORM OR QUL_BUILD_FRAMEWORK OR QUL_BUILD_TOOLS))
    message(FATAL_ERROR "Internal error: CORE_PACKAGE_NAME not set.")
endif()

set(CPACK_PACKAGE_DESCRIPTION "Qt for MCU")
set(CPACK_PACKAGE_VERSION "${CMAKE_PROJECT_VERSION}")
set(CPACK_PACKAGE_VENDOR "The Qt Company")
set(CPACK_PACKAGE_CONTACT "https://www.qt.io/contact-us")
set(CPACK_PACKAGE_NAME "Qul_${CMAKE_PROJECT_VERSION}")
set(CPACK_PACKAGE_FILE_NAME ${CPACK_PACKAGE_NAME})
set(CPACK_GENERATOR 7Z)
set(CPACK_ARCHIVE_CORE_FILE_NAME "qtformcus-core-library-${CORE_PACKAGE_NAME}")
set(CPACK_ARCHIVE_TOOLS_FILE_NAME "qtformcus-tools-${CORE_PACKAGE_NAME}")
set(CPACK_ARCHIVE_BASE_FILE_NAME "qtformcus-common-files")
set(CPACK_ARCHIVE_DOCS_FILE_NAME "qtformcus-documentation")
set(CPACK_ARCHIVE_EXAMPLES_FILE_NAME "qtformcus-examples")
set(CPACK_ARCHIVE_SOURCESCORE_FILE_NAME "qtformcus-common-src-${CMAKE_PROJECT_VERSION}")
set(CPACK_ARCHIVE_PLATFORMSOURCES_FILE_NAME "qtformcus-platform-sources-${QUL_PLATFORM}-${QUL_COMPILER_NAME}-${CMAKE_PROJECT_VERSION}")
set(CPACK_ARCHIVE_PLATFORMHEADERS_FILE_NAME "qtformcus-platform-headers-${CMAKE_PROJECT_VERSION}") # Generic headers not specific to any platform or compiler
set(CPACK_ARCHIVE_PLATFORMBASE_FILE_NAME "qtformcus-platform-base-${CMAKE_PROJECT_VERSION}") # Platform base package must not contain any platform or architecture specific files
set(CPACK_ARCHIVE_PLATFORMLIBRARY_FILE_NAME "qtformcus-platform-library-${QUL_PLATFORM}-${QUL_COMPILER_NAME}-${CMAKE_PROJECT_VERSION}")
set(CPACK_ARCHIVE_TESTAUTOMATION_FILE_NAME "test-automation-${QUL_PLATFORM}-${QUL_COMPILER_NAME}-${CMAKE_PROJECT_VERSION}")
set(CPACK_ARCHIVE_TESTSSOURCES_FILE_NAME "qtformcus-tests-sources-${CMAKE_PROJECT_VERSION}")

if(QUL_BUILD_FRAMEWORK)
    set(CPACK_COMPONENTS_ALL "${CPACK_COMPONENTS_ALL};Core;SourcesCore;Base;TestsSources")
    set(CPACK_COMPONENTS_ALL "${CPACK_COMPONENTS_ALL};Examples;PlatformBase;PlatformHeaders")
endif()

if(QUL_BUILD_TOOLS)
    set(CPACK_COMPONENTS_ALL "${CPACK_COMPONENTS_ALL};Tools")
endif()

if(QUL_BUILD_DOC)
    set(CPACK_COMPONENTS_ALL "${CPACK_COMPONENTS_ALL};Docs")
endif()

if(QUL_BUILD_PLATFORM)
    set(CPACK_COMPONENTS_ALL "${CPACK_COMPONENTS_ALL};PlatformSources;PlatformLibrary")
endif()

if(CMAKE_CROSSCOMPILING)
    set(CPACK_COMPONENTS_ALL "${CPACK_COMPONENTS_ALL};TestAutomation")
endif()

set(CPACK_ARCHIVE_COMPONENT_INSTALL ON)
set(CPACK_COMPONENTS_GROUPING IGNORE)
set(CPACK_COMPONENT_INCLUDE_TOPLEVEL_DIRECTORY ON)
set(CPACK_TOPLEVEL_TAG "Qul_${CMAKE_PROJECT_VERSION}")

include (CPack)
